#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=CGI-Application-Plugin-TT
PACKAGE=libcgi-application-plugin-tt-perl
VERSION=1.05
LM_VERS=1.02
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/lastmodified/watch ${FD} ${NS} ${DD} ${US} ${LM_VERS} && true;
    cd ${DESTDIR}
    LM=`ls ${MODULE}-LastModified*.tar.gz`
    mv ${LM} ${PACKAGE}_${VERSION}.orig-lastmodified.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/lastmodified/watch ${RS} ${DD} ${US} ${LM_VERS} && true;
fi
