// Copyright (C) 2024 The Qt Company Ltd.
// Copyright © 2004-2023 Unicode, Inc.
// SPDX-License-Identifier: Unicode-3.0

#ifndef QTIMEZONELOCALE_DATA_P_H
#define QTIMEZONELOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not a normal header file.
// It defines data tables for internal use by QTimeZone's L10n code.
// It may change incompatibly between versions, or even be removed.
//
// We mean it.
//

// Only qtimezonelocale.cpp should #include this (after other things it needs),
// and even that only when feature icu is disabled.

QT_REQUIRE_CONFIG(timezone_locale);
#if QT_CONFIG(icu)
#  error "This file should only be needed (or seen) when ICU is not in use"
#endif

QT_BEGIN_NAMESPACE

#ifdef QT_CLDR_ZONE_DEBUG
#  define LOCALE_TAGS(lang, script, land) lang, script, land,
#else
#  define LOCALE_TAGS(lang, script, land)
#endif

namespace QtTimeZoneLocale {

/*
    Locale-specific data for timezone naming.
    https://www.unicode.org/reports/tr35/tr35-68/tr35-dates.html#Time_Zone_Names

    Available data, per locale, from LocaleScanner.timeZoneNames():

        formats: {
            'hour': ('+HH:mm', '-HH:mm'),
            'GMT': 'GMT%0',
            'region': ("%0 Time", std, dst),
            'fallback': "%1 (%0)" }
        zones: { ianaid: {
                'exemplarCity': name,
                'long': (gen, std, dst), 'short': (gen, std, dst) } }
        metazones: { meta: {'long': (gen, std, dst), 'short': (gen, std, dst) } }

    Mapped to C++ data-structures below (defined in QTZL_p.h) and used by
    QTZL.cpp, in conjunction with QTZP_data_p.h's locale-independent data
    conditioned on timezone_locale.
*/

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2025-07-01 from the
    Common Locale Data Repository v47

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

// Sorted by locale index, then iana name
static inline constexpr LocaleZoneExemplar localeZoneExemplarTable[] = {
    // locInd, ianaInd, xcty{ind, sz}
    {    0,   14,       0,  6, }, // Africa/Asmara C/AnyScript/AnyTerritory
    {    0, 4435,       6,  8, }, // Africa/Sao_Tome
    {    0, 4252,      14,  8, }, // America/Asuncion
    {    0,  237,      22,  8, }, // America/Atikokan
    {    0, 7623,      30, 17, }, // America/Bahia_Banderas
    {    0, 3868,      47,  6, }, // America/Cancun
    {    0, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    0, 5723,      66,  7, }, // America/Curacao
    {    0,  481,      73, 13, }, // America/Indiana/Knox
    {    0, 7961,      86, 16, }, // America/Indiana/Marengo
    {    0, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    0, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    0, 8038,     139, 14, }, // America/Indiana/Vevay
    {    0, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    0, 8086,     171, 16, }, // America/Indiana/Winamac
    {    0, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    0, 5932,     207, 22, }, // America/Lower_Princes
    {    0, 8220,     229,  6, }, // America/Merida
    {    0, 1850,     235, 19, }, // America/Noronha
    {    0, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {    0, 8329,     274, 20, }, // America/North_Dakota/Center
    {    0, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {    0,  393,     317,  4, }, // America/Nuuk
    {    0, 6899,     321, 16, }, // America/Scoresbysund
    {    0, 8508,     337, 14, }, // America/St_Barthelemy
    {    0, 2061,     351, 10, }, // America/St_Johns
    {    0, 5863,     361,  9, }, // America/St_Kitts
    {    0, 5880,     370,  9, }, // America/St_Lucia
    {    0,  855,     379, 10, }, // America/St_Thomas
    {    0, 5913,     389, 11, }, // America/St_Vincent
    {    0, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    0, 8568,     416, 16, }, // Antarctica/Macquarie
    {    0, 1259,     432, 16, }, // Asia/Ho_Chi_Minh
    {    0, 1185,     448,  9, }, // Asia/Kathmandu
    {    0,  992,     457,  7, }, // Asia/Kolkata
    {    0, 1211,     464,  5, }, // Asia/Macau
    {    0, 8708,     469,  8, }, // Asia/Qostanay
    {    0, 1235,     477,  6, }, // Asia/Yangon
    {    0, 1395,     483,  5, }, // Atlantic/Faroe
    {    0, 6821,     488, 10, }, // Atlantic/St_Helena
    {    0, 1547,     498, 16, }, // Australia/Lord_Howe
    {    0, 2527,     514,  4, }, // Europe/Kyiv
    {    0, 6046,     518, 16, }, // Indian/Christmas
    {    0, 6063,     534, 13, }, // Indian/Cocos
    {    0, 7211,     547,  7, }, // Indian/Reunion
    {    0, 3157,     554,  5, }, // Pacific/Chuuk
    {    0, 2237,     559, 13, }, // Pacific/Easter
    {    0, 4168,     572, 14, }, // Pacific/Norfolk
    {    0, 3096,     586,  7, }, // Pacific/Pohnpei
    {    0, 7392,     593, 11, }, // Pacific/Wake
    {    1, 6788,     604,  6, }, // Africa/Abidjan Abkhazian/Cyrillic/Georgia
    {    1, 6760,     610,  5, }, // Africa/Accra
    {    1, 5059,     615, 11, }, // Africa/Addis_Ababa
    {    1, 7420,     626,  5, }, // Africa/Algiers
    {    1,   14,     631,  6, }, // Africa/Asmara
    {    1,   44,     637,  6, }, // Africa/Bamako
    {    1, 5257,     643,  5, }, // Africa/Bangui
    {    1, 6746,     648,  6, }, // Africa/Banjul
    {    1, 7435,     654,  5, }, // Africa/Bissau
    {    1, 4957,     659,  8, }, // Africa/Blantyre
    {    1, 5287,     667,  9, }, // Africa/Brazzaville
    {    1, 4922,     676,  9, }, // Africa/Bujumbura
    {    1, 2320,     685,  4, }, // Africa/Cairo
    {    1, 4117,     689, 10, }, // Africa/Casablanca
    {    1, 7449,     699,  5, }, // Africa/Ceuta
    {    1, 6773,     704,  7, }, // Africa/Conakry
    {    1, 6840,     711,  5, }, // Africa/Dakar
    {    1, 5130,     716, 12, }, // Africa/Dar_es_Salaam
    {    1, 5043,     728,  6, }, // Africa/Djibouti
    {    1, 5243,     734,  5, }, // Africa/Douala
    {    1, 5166,     739,  7, }, // Africa/El_Aaiun
    {    1, 6853,     746,  7, }, // Africa/Freetown
    {    1, 4906,     753,  8, }, // Africa/Gaborone
    {    1, 5015,     761,  6, }, // Africa/Harare
    {    1, 4479,     767, 12, }, // Africa/Johannesburg
    {    1, 4499,     779,  4, }, // Africa/Juba
    {    1, 5151,     783,  7, }, // Africa/Kampala
    {    1, 4524,     790,  6, }, // Africa/Khartoum
    {    1, 4973,     796,  6, }, // Africa/Kigali
    {    1, 5306,     802,  7, }, // Africa/Kinshasa
    {    1, 4744,     809,  5, }, // Africa/Lagos
    {    1, 5336,     814,  8, }, // Africa/Libreville
    {    1, 6869,     822,  4, }, // Africa/Lome
    {    1, 5211,     826,  6, }, // Africa/Luanda
    {    1, 4939,     832,  9, }, // Africa/Lubumbashi
    {    1, 5001,     841,  6, }, // Africa/Lusaka
    {    1, 5322,     847,  6, }, // Africa/Malabo
    {    1, 4987,     853,  6, }, // Africa/Maputo
    {    1, 5197,     859,  6, }, // Africa/Maseru
    {    1, 5182,     865,  7, }, // Africa/Mbabane
    {    1, 5113,     872,  8, }, // Africa/Mogadishu
    {    1, 7034,     880,  8, }, // Africa/Monrovia
    {    1, 3853,     888,  7, }, // Africa/Nairobi
    {    1, 5271,     895,  7, }, // Africa/Ndjamena
    {    1, 5354,     902,  6, }, // Africa/Niamey
    {    1, 6803,     908,  7, }, // Africa/Nouakchott
    {    1, 6727,     915,  8, }, // Africa/Ouagadougou
    {    1, 5225,     923, 10, }, // Africa/Porto-Novo
    {    1, 4435,     933,  8, }, // Africa/Sao_Tome
    {    1, 2866,     941,  7, }, // Africa/Tripoli
    {    1, 6554,     948,  5, }, // Africa/Tunis
    {    1, 4152,     953,  7, }, // Africa/Windhoek
    {    1,  132,     960,  4, }, // America/Adak
    {    1, 3346,     964,  7, }, // America/Anchorage
    {    1, 5607,     971,  7, }, // America/Anguilla
    {    1, 5624,     978,  7, }, // America/Antigua
    {    1, 4554,     985,  9, }, // America/Araguaina
    {    1,  166,     994, 12, }, // America/Argentina/Buenos_Aires
    {    1,   91,    1006,  9, }, // America/Argentina/Catamarca
    {    1,  270,    1015,  7, }, // America/Argentina/Cordoba
    {    1,  441,    1022,  5, }, // America/Argentina/Jujuy
    {    1, 7462,    1027,  8, }, // America/Argentina/La_Rioja
    {    1,  565,    1035,  7, }, // America/Argentina/Mendoza
    {    1, 7489,    1042, 11, }, // America/Argentina/Rio_Gallegos
    {    1, 7520,    1053,  5, }, // America/Argentina/Salta
    {    1, 7544,    1058,  8, }, // America/Argentina/San_Juan
    {    1, 5580,    1066,  8, }, // America/Argentina/San_Luis
    {    1, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {    1, 7597,    1081,  6, }, // America/Argentina/Ushuaia
    {    1, 5640,    1087,  5, }, // America/Aruba
    {    1, 4252,    1092,  7, }, // America/Asuncion
    {    1,  237,    1099, 12, }, // America/Atikokan
    {    1, 3679,    1111,  4, }, // America/Bahia
    {    1, 7623,    1115, 16, }, // America/Bahia_Banderas
    {    1, 5654,    1131,  8, }, // America/Barbados
    {    1, 7646,    1139,  5, }, // America/Belem
    {    1, 5407,    1144,  5, }, // America/Belize
    {    1, 7660,    1149, 12, }, // America/Blanc-Sablon
    {    1, 7681,    1161,  9, }, // America/Boa_Vista
    {    1, 4361,    1170,  6, }, // America/Bogota
    {    1, 7699,    1176,  5, }, // America/Boise
    {    1, 7713,    1181, 12, }, // America/Cambridge_Bay
    {    1, 7735,    1193, 12, }, // America/Campo_Grande
    {    1, 3868,    1205,  6, }, // America/Cancun
    {    1, 4694,    1211,  7, }, // America/Caracas
    {    1, 4345,    1218,  7, }, // America/Cayenne
    {    1, 5496,    1225, 22, }, // America/Cayman
    {    1, 2260,    1247,  6, }, // America/Chicago
    {    1, 7756,    1253,  6, }, // America/Chihuahua
    {    1, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    1, 5422,    1259, 10, }, // America/Costa_Rica
    {    1, 7796,    1269,  7, }, // America/Creston
    {    1, 3791,    1276,  6, }, // America/Cuiaba
    {    1, 5723,    1282,  8, }, // America/Curacao
    {    1, 7812,    1290, 12, }, // America/Danmarkshavn
    {    1, 7833,    1302,  6, }, // America/Dawson
    {    1, 7848,    1308, 11, }, // America/Dawson_Creek
    {    1,  805,    1319,  6, }, // America/Denver
    {    1, 3465,    1325,  7, }, // America/Detroit
    {    1, 5739,    1332,  8, }, // America/Dominica
    {    1,  893,    1340,  8, }, // America/Edmonton
    {    1, 7869,    1348,  8, }, // America/Eirunepe
    {    1, 5441,    1356,  8, }, // America/El_Salvador
    {    1, 7886,    1364, 11, }, // America/Fort_Nelson
    {    1, 7906,    1375,  9, }, // America/Fortaleza
    {    1, 7924,    1384,  9, }, // America/Glace_Bay
    {    1, 6881,    1393,  7, }, // America/Goose_Bay
    {    1, 4612,    1400, 10, }, // America/Grand_Turk
    {    1, 5770,    1410,  7, }, // America/Grenada
    {    1, 5786,    1417,  9, }, // America/Guadeloupe
    {    1, 3760,    1426,  9, }, // America/Guatemala
    {    1, 4841,    1435,  8, }, // America/Guayaquil
    {    1, 6932,    1443,  6, }, // America/Guyana
    {    1, 1939,    1449,  8, }, // America/Halifax
    {    1, 2281,    1457,  6, }, // America/Havana
    {    1, 7942,    1463,  8, }, // America/Hermosillo
    {    1,  348,    1471, 12, }, // America/Indiana/Indianapolis
    {    1,  481,    1483, 13, }, // America/Indiana/Knox
    {    1, 7961,    1496, 16, }, // America/Indiana/Marengo
    {    1, 7985,    1512, 19, }, // America/Indiana/Petersburg
    {    1, 8012,    1531,  9, }, // America/Indiana/Tell_City
    {    1, 8038,    1540, 14, }, // America/Indiana/Vevay
    {    1, 8060,    1554,  9, }, // America/Indiana/Vincennes
    {    1, 8086,    1563,  7, }, // America/Indiana/Winamac
    {    1, 8110,    1570,  6, }, // America/Inuvik
    {    1,  660,    1576,  7, }, // America/Iqaluit
    {    1, 2799,    1583,  7, }, // America/Jamaica
    {    1, 5380,    1590,  4, }, // America/Juneau
    {    1,  521,    1594,  8, }, // America/Kentucky/Louisville
    {    1, 8125,    1602, 20, }, // America/Kentucky/Monticello
    {    1, 5704,    1622, 10, }, // America/Kralendijk
    {    1, 4376,    1632,  6, }, // America/La_Paz
    {    1, 7169,    1638,  4, }, // America/Lima
    {    1, 3239,    1642, 11, }, // America/Los_Angeles
    {    1, 5932,    1653, 18, }, // America/Lower_Princes
    {    1, 8153,    1671,  6, }, // America/Maceio
    {    1, 8168,    1677,  7, }, // America/Managua
    {    1, 1908,    1684,  6, }, // America/Manaus
    {    1, 5897,    1690,  6, }, // America/Marigot
    {    1, 5805,    1696,  9, }, // America/Martinique
    {    1, 8184,    1705,  9, }, // America/Matamoros
    {    1, 2917,    1714,  8, }, // America/Mazatlan
    {    1, 8202,    1722,  8, }, // America/Menominee
    {    1, 8220,    1730,  6, }, // America/Merida
    {    1, 8235,    1736, 10, }, // America/Metlakatla
    {    1, 2949,    1746,  6, }, // America/Mexico_City
    {    1, 4391,    1752,  7, }, // America/Miquelon
    {    1, 8254,    1759,  7, }, // America/Moncton
    {    1, 8270,    1766,  9, }, // America/Monterrey
    {    1, 4098,    1775, 10, }, // America/Montevideo
    {    1, 5824,    1785, 10, }, // America/Montserrat
    {    1, 5481,    1795,  6, }, // America/Nassau
    {    1, 2379,    1801,  8, }, // America/New_York
    {    1, 8288,    1809,  3, }, // America/Nome
    {    1, 1850,    1812,  7, }, // America/Noronha
    {    1, 8301,    1819, 22, }, // America/North_Dakota/Beulah
    {    1, 8329,    1841, 22, }, // America/North_Dakota/Center
    {    1, 8357,    1863, 27, }, // America/North_Dakota/New_Salem
    {    1,  393,    1890,  4, }, // America/Nuuk
    {    1, 8388,    1894,  7, }, // America/Ojinaga
    {    1, 2356,    1901,  6, }, // America/Panama
    {    1, 6173,    1907, 10, }, // America/Paramaribo
    {    1, 2973,    1917,  6, }, // America/Phoenix
    {    1, 3945,    1923, 12, }, // America/Port-au-Prince
    {    1, 5954,    1935, 13, }, // America/Port_of_Spain
    {    1, 8404,    1948, 11, }, // America/Porto_Velho
    {    1, 5843,    1959, 11, }, // America/Puerto_Rico
    {    1, 4030,    1970, 12, }, // America/Punta_Arenas
    {    1, 8424,    1982, 12, }, // America/Rankin_Inlet
    {    1, 8445,    1994,  6, }, // America/Recife
    {    1, 1995,    2000,  7, }, // America/Regina
    {    1, 8460,    2007,  8, }, // America/Resolute
    {    1,  695,    2015, 10, }, // America/Rio_Branco
    {    1, 8477,    2025,  8, }, // America/Santarem
    {    1, 2201,    2033,  8, }, // America/Santiago
    {    1, 6111,    2041, 13, }, // America/Santo_Domingo
    {    1, 1878,    2054,  9, }, // America/Sao_Paulo
    {    1, 6899,    2063, 11, }, // America/Scoresbysund
    {    1, 8494,    2074,  5, }, // America/Sitka
    {    1, 8508,    2079, 13, }, // America/St_Barthelemy
    {    1, 2061,    2092,  9, }, // America/St_Johns
    {    1, 5863,    2101,  9, }, // America/St_Kitts
    {    1, 5880,    2110, 11, }, // America/St_Lucia
    {    1,  855,    2121, 10, }, // America/St_Thomas
    {    1, 5913,    2131, 12, }, // America/St_Vincent
    {    1, 8530,    2143, 13, }, // America/Swift_Current
    {    1, 5461,    2156, 11, }, // America/Tegucigalpa
    {    1, 5756,    2167,  4, }, // America/Thule
    {    1,  313,    2171,  7, }, // America/Tijuana
    {    1,  608,    2178,  7, }, // America/Toronto
    {    1, 5688,    2185,  7, }, // America/Tortola
    {    1, 2093,    2192,  8, }, // America/Vancouver
    {    1, 2144,    2200,  8, }, // America/Whitehorse
    {    1,  734,    2208,  8, }, // America/Winnipeg
    {    1, 8552,    2216,  7, }, // America/Yakutat
    {    1, 6001,    2223,  5, }, // Antarctica/Casey
    {    1, 6094,    2228,  6, }, // Antarctica/Davis
    {    1, 6133,    2234, 15, }, // Antarctica/DumontDUrville
    {    1, 8568,    2249,  8, }, // Antarctica/Macquarie
    {    1, 7066,    2257,  6, }, // Antarctica/Mawson
    {    1, 7113,    2263,  9, }, // Antarctica/McMurdo
    {    1, 8589,    2272,  6, }, // Antarctica/Palmer
    {    1, 7226,    2278,  6, }, // Antarctica/Rothera
    {    1, 7295,    2284,  5, }, // Antarctica/Syowa
    {    1, 8607,    2289,  5, }, // Antarctica/Troll
    {    1, 7374,    2294, 10, }, // Antarctica/Vostok
    {    1, 1429,    2304,  6, }, // Arctic/Longyearbyen
    {    1, 5570,    2310,  4, }, // Asia/Aden
    {    1, 5395,    2314,  6, }, // Asia/Almaty
    {    1, 3968,    2320,  5, }, // Asia/Amman
    {    1, 5511,    2325,  6, }, // Asia/Anadyr
    {    1, 5523,    2331,  5, }, // Asia/Aqtau
    {    1, 5368,    2336,  6, }, // Asia/Aqtobe
    {    1,  964,    2342,  7, }, // Asia/Ashgabat
    {    1, 8624,    2349,  6, }, // Asia/Atyrau
    {    1, 3607,    2355,  6, }, // Asia/Baghdad
    {    1, 5534,    2361,  7, }, // Asia/Bahrain
    {    1, 3653,    2368,  4, }, // Asia/Baku
    {    1, 4466,    2372,  7, }, // Asia/Bangkok
    {    1, 3571,    2379,  7, }, // Asia/Barnaul
    {    1, 4086,    2386,  6, }, // Asia/Beirut
    {    1, 3778,    2392,  6, }, // Asia/Bishkek
    {    1, 5989,    2398,  6, }, // Asia/Brunei
    {    1, 4601,    2404,  4, }, // Asia/Chita
    {    1, 4511,    2408,  7, }, // Asia/Colombo
    {    1, 4540,    2415,  6, }, // Asia/Damascus
    {    1, 1093,    2421,  5, }, // Asia/Dhaka
    {    1, 6192,    2426,  4, }, // Asia/Dili
    {    1, 3596,    2430,  5, }, // Asia/Dubai
    {    1, 6159,    2435,  7, }, // Asia/Dushanbe
    {    1, 8636,    2442,  9, }, // Asia/Famagusta
    {    1, 8651,    2451,  4, }, // Asia/Gaza
    {    1, 4795,    2455,  6, }, // Asia/Hebron
    {    1, 1259,    2461,  7, }, // Asia/Ho_Chi_Minh
    {    1, 2704,    2468,  7, }, // Asia/Hong_Kong
    {    1, 4771,    2475,  4, }, // Asia/Hovd
    {    1, 4184,    2479,  7, }, // Asia/Irkutsk
    {    1, 7006,    2486,  7, }, // Asia/Jakarta
    {    1, 6992,    2493,  8, }, // Asia/Jayapura
    {    1, 1290,    2501,  9, }, // Asia/Jerusalem
    {    1, 3560,    2510,  5, }, // Asia/Kabul
    {    1, 4316,    2515, 25, }, // Asia/Kamchatka
    {    1, 4239,    2540,  6, }, // Asia/Karachi
    {    1, 1185,    2546,  8, }, // Asia/Kathmandu
    {    1, 8661,    2554,  7, }, // Asia/Khandyga
    {    1,  992,    2561,  8, }, // Asia/Kolkata
    {    1, 4197,    2569, 11, }, // Asia/Krasnoyarsk
    {    1, 4859,    2580, 12, }, // Asia/Kuala_Lumpur
    {    1, 5976,    2592,  6, }, // Asia/Kuching
    {    1, 5547,    2598,  6, }, // Asia/Kuwait
    {    1, 1211,    2604,  5, }, // Asia/Macau
    {    1, 4017,    2609,  7, }, // Asia/Magadan
    {    1, 1349,    2616,  7, }, // Asia/Makassar
    {    1, 7182,    2623,  6, }, // Asia/Manila
    {    1, 6920,    2629,  6, }, // Asia/Muscat
    {    1, 2554,    2635,  7, }, // Asia/Nicosia
    {    1, 8675,    2642, 11, }, // Asia/Novokuznetsk
    {    1, 4135,    2653, 11, }, // Asia/Novosibirsk
    {    1, 4229,    2664,  4, }, // Asia/Omsk
    {    1, 7145,    2668,  6, }, // Asia/Oral
    {    1, 6961,    2674,  7, }, // Asia/Phnom_Penh
    {    1, 8693,    2681,  9, }, // Asia/Pontianak
    {    1, 4214,    2690,  7, }, // Asia/Pyongyang
    {    1, 5559,    2697,  5, }, // Asia/Qatar
    {    1, 8708,    2702,  8, }, // Asia/Qostanay
    {    1, 4269,    2710,  9, }, // Asia/Qyzylorda
    {    1, 3584,    2719,  7, }, // Asia/Riyadh
    {    1, 4408,    2726, 13, }, // Asia/Sakhalin
    {    1, 7245,    2739,  9, }, // Asia/Samarkand
    {    1, 3279,    2748,  4, }, // Asia/Seoul
    {    1, 1053,    2752,  6, }, // Asia/Shanghai
    {    1, 3300,    2758,  8, }, // Asia/Singapore
    {    1, 4297,    2766, 13, }, // Asia/Srednekolymsk
    {    1, 3263,    2779,  6, }, // Asia/Taipei
    {    1, 4781,    2785,  7, }, // Asia/Tashkent
    {    1, 3915,    2792,  4, }, // Asia/Tbilisi
    {    1, 2772,    2796,  7, }, // Asia/Tehran
    {    1, 1317,    2803,  7, }, // Asia/Thimphu
    {    1, 2821,    2810,  5, }, // Asia/Tokyo
    {    1, 4572,    2815,  5, }, // Asia/Tomsk
    {    1, 1021,    2820, 10, }, // Asia/Ulaanbaatar
    {    1, 1159,    2830,  6, }, // Asia/Urumqi
    {    1, 8722,    2836,  8, }, // Asia/Ust-Nera
    {    1, 6977,    2844,  7, }, // Asia/Vientiane
    {    1, 4710,    2851, 11, }, // Asia/Vladivostok
    {    1, 4828,    2862,  7, }, // Asia/Yakutsk
    {    1, 1235,    2869,  6, }, // Asia/Yangon
    {    1, 3883,    2875, 12, }, // Asia/Yekaterinburg
    {    1, 3747,    2887,  6, }, // Asia/Yerevan
    {    1, 3663,    2893, 16, }, // Atlantic/Azores
    {    1, 5671,    2909, 18, }, // Atlantic/Bermuda
    {    1, 6628,    2927, 17, }, // Atlantic/Canary
    {    1, 3727,    2944, 10, }, // Atlantic/Cape_Verde
    {    1, 1395,    2954, 17, }, // Atlantic/Faroe
    {    1, 8736,    2971,  7, }, // Atlantic/Madeira
    {    1, 2748,    2978,  9, }, // Atlantic/Reykjavik
    {    1, 7272,    2987, 16, }, // Atlantic/South_Georgia
    {    1, 6821,    3003, 26, }, // Atlantic/St_Helena
    {    1, 6644,    3029,  6, }, // Atlantic/Stanley
    {    1, 1670,    3035,  8, }, // Australia/Adelaide
    {    1, 1635,    3043,  7, }, // Australia/Brisbane
    {    1, 1799,    3050, 11, }, // Australia/Broken_Hill
    {    1, 1583,    3061,  6, }, // Australia/Darwin
    {    1, 3637,    3067,  5, }, // Australia/Eucla
    {    1, 1516,    3072,  6, }, // Australia/Hobart
    {    1, 8753,    3078,  8, }, // Australia/Lindeman
    {    1, 1547,    3086,  8, }, // Australia/Lord_Howe
    {    1, 1727,    3094,  7, }, // Australia/Melbourne
    {    1, 1762,    3101,  4, }, // Australia/Perth
    {    1, 1463,    3105,  6, }, // Australia/Sydney
    {    1, 6441,    3111,  9, }, // Europe/Amsterdam
    {    1, 6216,    3120,  7, }, // Europe/Andorra
    {    1, 3620,    3127,  8, }, // Europe/Astrakhan
    {    1, 2300,    3135,  4, }, // Europe/Athens
    {    1, 6336,    3139,  7, }, // Europe/Belgrade
    {    1, 4757,    3146,  6, }, // Europe/Berlin
    {    1, 6488,    3152, 10, }, // Europe/Bratislava
    {    1, 2167,    3162,  8, }, // Europe/Brussels
    {    1, 3928,    3170,  8, }, // Europe/Bucharest
    {    1, 3806,    3178,  8, }, // Europe/Budapest
    {    1, 8772,    3186, 23, }, // Europe/Busingen
    {    1, 2583,    3209,  7, }, // Europe/Chisinau
    {    1, 6289,    3216, 10, }, // Europe/Copenhagen
    {    1, 2338,    3226,  6, }, // Europe/Dublin
    {    1, 6307,    3232,  9, }, // Europe/Gibraltar
    {    1, 8788,    3241,  6, }, // Europe/Guernsey
    {    1, 6612,    3247,  8, }, // Europe/Helsinki
    {    1, 8804,    3255,  9, }, // Europe/Isle_of_Man
    {    1, 1130,    3264,  7, }, // Europe/Istanbul
    {    1, 8823,    3271,  5, }, // Europe/Jersey
    {    1, 3979,    3276, 11, }, // Europe/Kaliningrad
    {    1, 8929,    3287,  5, }, // Europe/Kirov
    {    1, 2527,    3292,  4, }, // Europe/Kyiv
    {    1, 3213,    3296,  8, }, // Europe/Lisbon
    {    1, 6506,    3304,  9, }, // Europe/Ljubljana
    {    1, 2501,    3313,  6, }, // Europe/London
    {    1, 6365,    3319, 11, }, // Europe/Luxembourg
    {    1, 4892,    3330,  6, }, // Europe/Madrid
    {    1, 6397,    3336,  5, }, // Europe/Malta
    {    1, 6582,    3341,  9, }, // Europe/Mariehamn
    {    1, 3693,    3350,  5, }, // Europe/Minsk
    {    1, 6410,    3355,  6, }, // Europe/Monaco
    {    1, 3537,    3361,  6, }, // Europe/Moscow
    {    1, 6458,    3367,  4, }, // Europe/Oslo
    {    1, 4284,    3371,  5, }, // Europe/Paris
    {    1, 6424,    3376,  9, }, // Europe/Podgorica
    {    1, 6275,    3385,  5, }, // Europe/Prague
    {    1, 8837,    3390,  4, }, // Europe/Riga
    {    1, 6324,    3394,  3, }, // Europe/Rome
    {    1, 4331,    3397,  6, }, // Europe/Samara
    {    1, 6470,    3403, 10, }, // Europe/San_Marino
    {    1, 6245,    3413,  7, }, // Europe/Sarajevo
    {    1, 4451,    3420,  7, }, // Europe/Saratov
    {    1, 8849,    3427, 10, }, // Europe/Simferopol
    {    1, 6383,    3437,  5, }, // Europe/Skopje
    {    1, 6599,    3442,  5, }, // Europe/Sofia
    {    1, 6523,    3447,  8, }, // Europe/Stockholm
    {    1, 8867,    3455,  6, }, // Europe/Tallinn
    {    1, 6202,    3461,  6, }, // Europe/Tirane
    {    1, 8882,    3467,  9, }, // Europe/Ulyanovsk
    {    1, 6352,    3476,  5, }, // Europe/Vaduz
    {    1, 6567,    3481,  7, }, // Europe/Vatican
    {    1, 6231,    3488,  4, }, // Europe/Vienna
    {    1, 8899,    3492,  7, }, // Europe/Vilnius
    {    1, 4727,    3499,  9, }, // Europe/Volgograd
    {    1, 3190,    3508,  7, }, // Europe/Warsaw
    {    1, 6261,    3515,  6, }, // Europe/Zagreb
    {    1, 6540,    3521,  6, }, // Europe/Zurich
    {    1, 5078,    3527, 12, }, // Indian/Antananarivo
    {    1, 6947,    3539,  5, }, // Indian/Chagos
    {    1, 6046,    3544, 12, }, // Indian/Christmas
    {    1, 6063,    3556, 17, }, // Indian/Cocos
    {    1, 5029,    3573,  5, }, // Indian/Comoro
    {    1, 6661,    3578,  8, }, // Indian/Kerguelen
    {    1, 7260,    3586,  3, }, // Indian/Mahe
    {    1, 7050,    3589,  6, }, // Indian/Maldives
    {    1, 4069,    3595,  7, }, // Indian/Mauritius
    {    1, 5098,    3602,  7, }, // Indian/Mayotte
    {    1, 7211,    3609,  7, }, // Indian/Reunion
    {    1, 4422,    3616,  4, }, // Pacific/Apia
    {    1,  932,    3620,  6, }, // Pacific/Auckland
    {    1, 3706,    3626,  8, }, // Pacific/Bougainville
    {    1, 3015,    3634,  5, }, // Pacific/Chatham
    {    1, 3157,    3639,  4, }, // Pacific/Chuuk
    {    1, 2237,    3643, 11, }, // Pacific/Easter
    {    1, 7360,    3654,  5, }, // Pacific/Efate
    {    1, 7327,    3659,  7, }, // Pacific/Fakaofo
    {    1, 3902,    3666,  4, }, // Pacific/Fiji
    {    1, 7343,    3670,  8, }, // Pacific/Funafuti
    {    1, 6678,    3678, 21, }, // Pacific/Galapagos
    {    1, 6696,    3699, 14, }, // Pacific/Gambier
    {    1, 3822,    3713, 11, }, // Pacific/Guadalcanal
    {    1, 6018,    3724,  4, }, // Pacific/Guam
    {    1, 3049,    3728,  6, }, // Pacific/Kanton
    {    1, 3998,    3734, 10, }, // Pacific/Kiritimati
    {    1, 7019,    3744,  6, }, // Pacific/Kosrae
    {    1, 2842,    3750,  9, }, // Pacific/Kwajalein
    {    1, 4877,    3759,  6, }, // Pacific/Majuro
    {    1, 4051,    3765, 18, }, // Pacific/Marquesas
    {    1, 8914,    3783, 15, }, // Pacific/Midway
    {    1, 7084,    3798,  5, }, // Pacific/Nauru
    {    1, 7132,    3803,  4, }, // Pacific/Niue
    {    1, 4168,    3807,  7, }, // Pacific/Norfolk
    {    1, 7098,    3814,  5, }, // Pacific/Noumea
    {    1, 3126,    3819,  9, }, // Pacific/Pago_Pago
    {    1, 7155,    3828,  5, }, // Pacific/Palau
    {    1, 7194,    3833,  7, }, // Pacific/Pitcairn
    {    1, 3096,    3840,  6, }, // Pacific/Pohnpei
    {    1, 4807,    3846, 11, }, // Pacific/Port_Moresby
    {    1, 6076,    3857,  9, }, // Pacific/Rarotonga
    {    1, 6031,    3866,  6, }, // Pacific/Saipan
    {    1, 7312,    3872,  5, }, // Pacific/Tahiti
    {    1, 6712,    3877,  6, }, // Pacific/Tarawa
    {    1, 4583,    3883,  9, }, // Pacific/Tongatapu
    {    1, 7392,    3892,  4, }, // Pacific/Wake
    {    1, 7405,    3896,  6, }, // Pacific/Wallis
    {    2,   14,       0,  6, }, // Africa/Asmara Afar/Latin/Ethiopia
    {    2, 4435,       6,  8, }, // Africa/Sao_Tome
    {    2, 4252,      14,  8, }, // America/Asuncion
    {    2,  237,      22,  8, }, // America/Atikokan
    {    2, 7623,      30, 17, }, // America/Bahia_Banderas
    {    2, 3868,      47,  6, }, // America/Cancun
    {    2, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    2, 5723,      66,  7, }, // America/Curacao
    {    2,  481,      73, 13, }, // America/Indiana/Knox
    {    2, 7961,      86, 16, }, // America/Indiana/Marengo
    {    2, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    2, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    2, 8038,     139, 14, }, // America/Indiana/Vevay
    {    2, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    2, 8086,     171, 16, }, // America/Indiana/Winamac
    {    2, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    2, 5932,     207, 22, }, // America/Lower_Princes
    {    2, 8220,     229,  6, }, // America/Merida
    {    2, 1850,     235, 19, }, // America/Noronha
    {    2, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {    2, 8329,     274, 20, }, // America/North_Dakota/Center
    {    2, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {    2,  393,     317,  4, }, // America/Nuuk
    {    2, 6899,     321, 16, }, // America/Scoresbysund
    {    2, 8508,     337, 14, }, // America/St_Barthelemy
    {    2, 2061,     351, 10, }, // America/St_Johns
    {    2, 5863,     361,  9, }, // America/St_Kitts
    {    2, 5880,     370,  9, }, // America/St_Lucia
    {    2,  855,     379, 10, }, // America/St_Thomas
    {    2, 5913,     389, 11, }, // America/St_Vincent
    {    2, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    2, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {    2, 1185,     448,  9, }, // Asia/Kathmandu
    {    2,  992,     457,  7, }, // Asia/Kolkata
    {    2, 1211,     464,  5, }, // Asia/Macau
    {    2, 1235,     477,  6, }, // Asia/Yangon
    {    2, 1395,     483,  5, }, // Atlantic/Faroe
    {    2, 6821,     488, 10, }, // Atlantic/St_Helena
    {    2, 2527,     514,  4, }, // Europe/Kyiv
    {    2, 7211,     547,  7, }, // Indian/Reunion
    {    2, 3157,     554,  5, }, // Pacific/Chuuk
    {    2, 3096,     586,  7, }, // Pacific/Pohnpei
    {    5, 5059,    3902, 11, }, // Africa/Addis_Ababa Afrikaans/Latin/South Africa
    {    5,   14,       0,  6, }, // Africa/Asmara
    {    5, 2320,    3913,  5, }, // Africa/Cairo
    {    5, 5043,    3918,  8, }, // Africa/Djibouti
    {    5, 4524,    3926,  7, }, // Africa/Khartoum
    {    5, 5113,    3933, 10, }, // Africa/Mogadishu
    {    5, 4435,       6,  8, }, // Africa/Sao_Tome
    {    5, 4252,      14,  8, }, // America/Asuncion
    {    5,  237,      22,  8, }, // America/Atikokan
    {    5, 7623,    3943, 14, }, // America/Bahia_Banderas
    {    5, 7713,    3957, 13, }, // America/Cambridge_Bay
    {    5, 3868,      47,  6, }, // America/Cancun
    {    5, 5496,    3970,  7, }, // America/Cayman
    {    5, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    5, 5723,      66,  7, }, // America/Curacao
    {    5, 7924,    3977,  9, }, // America/Glace_Bay
    {    5, 6881,    3986,  9, }, // America/Goose_Bay
    {    5,  481,      73, 13, }, // America/Indiana/Knox
    {    5, 7961,      86, 16, }, // America/Indiana/Marengo
    {    5, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    5, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    5, 8038,     139, 14, }, // America/Indiana/Vevay
    {    5, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    5, 8086,     171, 16, }, // America/Indiana/Winamac
    {    5, 2799,    3995,  7, }, // America/Jamaica
    {    5, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    5, 5932,     207, 22, }, // America/Lower_Princes
    {    5, 8220,     229,  6, }, // America/Merida
    {    5, 2949,    4002, 11, }, // America/Mexico_City
    {    5, 1850,     235, 19, }, // America/Noronha
    {    5, 8301,    4013, 20, }, // America/North_Dakota/Beulah
    {    5, 8329,    4033, 20, }, // America/North_Dakota/Center
    {    5, 8357,    4053, 23, }, // America/North_Dakota/New_Salem
    {    5,  393,     317,  4, }, // America/Nuuk
    {    5, 6899,     321, 16, }, // America/Scoresbysund
    {    5, 8508,    4076, 17, }, // America/St_Barthelemy
    {    5, 2061,    4093, 11, }, // America/St_Johns
    {    5, 5863,    4104, 10, }, // America/St_Kitts
    {    5, 5880,    4114, 10, }, // America/St_Lucia
    {    5,  855,    4124, 11, }, // America/St_Thomas
    {    5, 5913,    4135, 12, }, // America/St_Vincent
    {    5, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    5, 7374,    4147,  6, }, // Antarctica/Vostok
    {    5,  964,    4153,  9, }, // Asia/Ashgabat
    {    5, 3607,    4162,  6, }, // Asia/Baghdad
    {    5, 5534,    4168,  7, }, // Asia/Bahrain
    {    5, 3653,    4175,  5, }, // Asia/Baku
    {    5, 4086,    4180,  7, }, // Asia/Beirut
    {    5, 3778,    4187,  7, }, // Asia/Bishkek
    {    5, 5989,    4194,  7, }, // Asia/Brunei
    {    5, 4540,    4201,  8, }, // Asia/Damascus
    {    5, 3596,    4209,  6, }, // Asia/Dubai
    {    5, 1259,    4215, 16, }, // Asia/Ho_Chi_Minh
    {    5, 2704,    4231,  8, }, // Asia/Hong_Kong
    {    5, 4184,    4239,  8, }, // Asia/Irkutsk
    {    5, 7006,    4247,  8, }, // Asia/Jakarta
    {    5, 3560,    4255,  6, }, // Asia/Kabul
    {    5, 4316,    4261, 10, }, // Asia/Kamchatka
    {    5, 4239,    4271,  8, }, // Asia/Karachi
    {    5, 1185,    4279,  9, }, // Asia/Kathmandu
    {    5,  992,     457,  7, }, // Asia/Kolkata
    {    5, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {    5, 4859,    4299, 15, }, // Asia/Kuala_Lumpur
    {    5, 5547,    4314,  7, }, // Asia/Kuwait
    {    5, 1211,    4321,  5, }, // Asia/Macau
    {    5, 6920,    4326,  6, }, // Asia/Muscat
    {    5, 5559,    4332,  5, }, // Asia/Qatar
    {    5, 8708,     469,  8, }, // Asia/Qostanay
    {    5, 3584,    4337,  5, }, // Asia/Riyadh
    {    5, 3279,    4342,  5, }, // Asia/Seoul
    {    5, 3300,    4347,  9, }, // Asia/Singapore
    {    5, 2821,    4356,  5, }, // Asia/Tokyo
    {    5, 4710,    4361, 11, }, // Asia/Vladivostok
    {    5, 4828,    4372,  8, }, // Asia/Yakutsk
    {    5, 1235,     477,  6, }, // Asia/Yangon
    {    5, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {    5, 3663,    4393,  5, }, // Atlantic/Azores
    {    5, 6628,    4398,  7, }, // Atlantic/Canary
    {    5, 3727,    4405, 10, }, // Atlantic/Cape_Verde
    {    5, 1395,     483,  5, }, // Atlantic/Faroe
    {    5, 7272,    4415, 12, }, // Atlantic/South_Georgia
    {    5, 6821,    4427, 11, }, // Atlantic/St_Helena
    {    5, 2300,    4438,  6, }, // Europe/Athens
    {    5, 4757,    4444,  6, }, // Europe/Berlin
    {    5, 2167,    4450,  7, }, // Europe/Brussels
    {    5, 3928,    4457,  9, }, // Europe/Bucharest
    {    5, 3806,    4466,  9, }, // Europe/Budapest
    {    5, 6289,    4475, 10, }, // Europe/Copenhagen
    {    5, 8804,    4485, 10, }, // Europe/Isle_of_Man
    {    5, 2527,    4495,  4, }, // Europe/Kyiv
    {    5, 3213,    4499,  8, }, // Europe/Lisbon
    {    5, 2501,    4507,  6, }, // Europe/London
    {    5, 6365,    4513,  9, }, // Europe/Luxembourg
    {    5, 3537,    4522,  6, }, // Europe/Moscow
    {    5, 4284,    4528,  5, }, // Europe/Paris
    {    5, 6275,    4533,  5, }, // Europe/Prague
    {    5, 4451,    4538,  7, }, // Europe/Saratov
    {    5, 6567,    4545, 12, }, // Europe/Vatican
    {    5, 6231,    4557,  4, }, // Europe/Vienna
    {    5, 4727,    4561,  9, }, // Europe/Volgograd
    {    5, 3190,    4570,  7, }, // Europe/Warsaw
    {    5, 6540,    4577,  6, }, // Europe/Zurich
    {    5, 6063,    4583,  5, }, // Indian/Cocos
    {    5, 5029,    4588,  6, }, // Indian/Comoro
    {    5, 7050,    4594,  8, }, // Indian/Maldives
    {    5, 7211,     547,  7, }, // Indian/Reunion
    {    5, 3157,     554,  5, }, // Pacific/Chuuk
    {    5, 2237,    4602,  4, }, // Pacific/Easter
    {    5, 3902,    4606,  5, }, // Pacific/Fiji
    {    5, 2723,    4611,  8, }, // Pacific/Honolulu
    {    5, 3049,    4619,  9, }, // Pacific/Kanton
    {    5, 7098,    4628,  6, }, // Pacific/Noumea
    {    5, 3096,     586,  7, }, // Pacific/Pohnpei
    {    5, 7405,    4634,  8, }, // Pacific/Wallis
    {    7,   14,       0,  6, }, // Africa/Asmara Aghem/Latin/Cameroon
    {    7, 4435,       6,  8, }, // Africa/Sao_Tome
    {    7, 4252,      14,  8, }, // America/Asuncion
    {    7,  237,      22,  8, }, // America/Atikokan
    {    7, 7623,      30, 17, }, // America/Bahia_Banderas
    {    7, 3868,      47,  6, }, // America/Cancun
    {    7, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    7, 5723,      66,  7, }, // America/Curacao
    {    7,  481,      73, 13, }, // America/Indiana/Knox
    {    7, 7961,      86, 16, }, // America/Indiana/Marengo
    {    7, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    7, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    7, 8038,     139, 14, }, // America/Indiana/Vevay
    {    7, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    7, 8086,     171, 16, }, // America/Indiana/Winamac
    {    7, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    7, 5932,     207, 22, }, // America/Lower_Princes
    {    7, 8220,     229,  6, }, // America/Merida
    {    7, 1850,     235, 19, }, // America/Noronha
    {    7, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {    7, 8329,     274, 20, }, // America/North_Dakota/Center
    {    7, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {    7,  393,     317,  4, }, // America/Nuuk
    {    7, 6899,     321, 16, }, // America/Scoresbysund
    {    7, 8508,     337, 14, }, // America/St_Barthelemy
    {    7, 2061,     351, 10, }, // America/St_Johns
    {    7, 5863,     361,  9, }, // America/St_Kitts
    {    7, 5880,     370,  9, }, // America/St_Lucia
    {    7,  855,     379, 10, }, // America/St_Thomas
    {    7, 5913,     389, 11, }, // America/St_Vincent
    {    7, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    7, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {    7, 1185,     448,  9, }, // Asia/Kathmandu
    {    7,  992,     457,  7, }, // Asia/Kolkata
    {    7, 1211,     464,  5, }, // Asia/Macau
    {    7, 1235,     477,  6, }, // Asia/Yangon
    {    7, 1395,     483,  5, }, // Atlantic/Faroe
    {    7, 6821,     488, 10, }, // Atlantic/St_Helena
    {    7, 2527,     514,  4, }, // Europe/Kyiv
    {    7, 7211,     547,  7, }, // Indian/Reunion
    {    7, 3157,     554,  5, }, // Pacific/Chuuk
    {    7, 3096,     586,  7, }, // Pacific/Pohnpei
    {    8, 6788,    4642,  7, }, // Africa/Abidjan Akan/Latin/Ghana
    {    8, 6760,    4649,  5, }, // Africa/Accra
    {    8, 7420,    4654,  7, }, // Africa/Algiers
    {    8,   14,       0,  6, }, // Africa/Asmara
    {    8, 6746,    4661,  7, }, // Africa/Banjul
    {    8, 7435,    4668,  5, }, // Africa/Bissau
    {    8, 4957,    4673,  7, }, // Africa/Blantyre
    {    8, 4922,    4680, 10, }, // Africa/Bujumbura
    {    8, 2320,    4690,  5, }, // Africa/Cairo
    {    8, 4117,    4695, 10, }, // Africa/Casablanca
    {    8, 7449,    4705,  5, }, // Africa/Ceuta
    {    8, 6773,    4710,  7, }, // Africa/Conakry
    {    8, 6840,    4717,  5, }, // Africa/Dakar
    {    8, 5043,    4722,  8, }, // Africa/Djibouti
    {    8, 4499,    4730,  5, }, // Africa/Juba
    {    8, 5306,    4735, 10, }, // Africa/Kinshasa
    {    8, 4744,    4745,  5, }, // Africa/Lagos
    {    8, 5271,    4750,  8, }, // Africa/Ndjamena
    {    8, 6727,    4758,  8, }, // Africa/Ouagadougou
    {    8, 4435,       6,  8, }, // Africa/Sao_Tome
    {    8, 3346,    4766,  9, }, // America/Anchorage
    {    8, 5607,    4775,  7, }, // America/Anguilla
    {    8,   91,    4782,  9, }, // America/Argentina/Catamarca
    {    8,  270,    4791,  7, }, // America/Argentina/Cordoba
    {    8,  441,    4798,  7, }, // America/Argentina/Jujuy
    {    8, 7462,    4805,  9, }, // America/Argentina/La_Rioja
    {    8,  565,    4814,  7, }, // America/Argentina/Mendoza
    {    8, 7489,    4821, 12, }, // America/Argentina/Rio_Gallegos
    {    8, 7544,    4833,  9, }, // America/Argentina/San_Juan
    {    8, 7571,    4842,  7, }, // America/Argentina/Tucuman
    {    8, 4252,      14,  8, }, // America/Asuncion
    {    8,  237,      22,  8, }, // America/Atikokan
    {    8, 7623,      30, 17, }, // America/Bahia_Banderas
    {    8, 5654,    4849,  8, }, // America/Barbados
    {    8, 7646,    4857,  5, }, // America/Belem
    {    8, 5407,    4862,  6, }, // America/Belize
    {    8, 7660,    4868, 12, }, // America/Blanc-Sablon
    {    8, 7699,    4880,  5, }, // America/Boise
    {    8, 7713,    4885, 13, }, // America/Cambridge_Bay
    {    8, 7735,    4898, 12, }, // America/Campo_Grande
    {    8, 3868,      47,  6, }, // America/Cancun
    {    8, 4694,    4910,  7, }, // America/Caracas
    {    8, 4345,    4917,  7, }, // America/Cayenne
    {    8, 5496,    4924,  7, }, // America/Cayman
    {    8, 2260,    4931,  7, }, // America/Chicago
    {    8, 7756,    4938,  9, }, // America/Chihuahua
    {    8, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    8, 5422,    4947, 10, }, // America/Costa_Rica
    {    8, 7796,    4957,  7, }, // America/Creston
    {    8, 3791,    4964,  6, }, // America/Cuiaba
    {    8, 5723,    4970,  7, }, // America/Curacao
    {    8, 7833,    4977,  6, }, // America/Dawson
    {    8, 7848,    4983, 12, }, // America/Dawson_Creek
    {    8,  805,    4995,  5, }, // America/Denver
    {    8, 3465,    5000,  7, }, // America/Detroit
    {    8, 5739,    5007,  8, }, // America/Dominica
    {    8,  893,    5015,  8, }, // America/Edmonton
    {    8, 5441,    5023, 11, }, // America/El_Salvador
    {    8, 7886,    5034, 10, }, // America/Fort_Nelson
    {    8, 7906,    5044,  9, }, // America/Fortaleza
    {    8, 6881,    5053,  8, }, // America/Goose_Bay
    {    8, 4612,    5061,  9, }, // America/Grand_Turk
    {    8, 5786,    5070,  9, }, // America/Guadeloupe
    {    8, 3760,    5079, 10, }, // America/Guatemala
    {    8, 4841,    5089,  9, }, // America/Guayaquil
    {    8, 6932,    5098,  6, }, // America/Guyana
    {    8, 7942,    5104,  8, }, // America/Hermosillo
    {    8,  348,    5112, 12, }, // America/Indiana/Indianapolis
    {    8,  481,      73, 13, }, // America/Indiana/Knox
    {    8, 7961,      86, 16, }, // America/Indiana/Marengo
    {    8, 7985,    5124, 19, }, // America/Indiana/Petersburg
    {    8, 8012,    5143, 18, }, // America/Indiana/Tell_City
    {    8, 8038,     139, 14, }, // America/Indiana/Vevay
    {    8, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    8, 8086,    5161, 16, }, // America/Indiana/Winamac
    {    8,  660,    5177,  7, }, // America/Iqaluit
    {    8, 2799,    5184,  7, }, // America/Jamaica
    {    8, 8125,    5191, 18, }, // America/Kentucky/Monticello
    {    8, 5704,    5209, 10, }, // America/Kralendijk
    {    8, 3239,    5219, 12, }, // America/Los_Angeles
    {    8, 5932,    5231, 16, }, // America/Lower_Princes
    {    8, 8153,    5247,  6, }, // America/Maceio
    {    8, 5897,    5253,  7, }, // America/Marigot
    {    8, 5805,    5260,  9, }, // America/Martinique
    {    8, 8184,    5269, 10, }, // America/Matamoros
    {    8, 2917,    5279,  8, }, // America/Mazatlan
    {    8, 8202,    5287,  9, }, // America/Menominee
    {    8, 8220,     229,  6, }, // America/Merida
    {    8, 8235,    5296, 10, }, // America/Metlakatla
    {    8, 2949,    5306, 12, }, // America/Mexico_City
    {    8, 8254,    5318,  7, }, // America/Moncton
    {    8, 8270,    5325,  8, }, // America/Monterrey
    {    8, 5824,    5333,  9, }, // America/Montserrat
    {    8, 2379,    5342,  7, }, // America/New_York
    {    8, 1850,     235, 19, }, // America/Noronha
    {    8, 8301,    5349, 17, }, // America/North_Dakota/Beulah
    {    8, 8329,    5366, 17, }, // America/North_Dakota/Center
    {    8, 8357,    5383, 21, }, // America/North_Dakota/New_Salem
    {    8,  393,     317,  4, }, // America/Nuuk
    {    8, 8388,    5404,  8, }, // America/Ojinaga
    {    8, 6173,    5412, 10, }, // America/Paramaribo
    {    8, 2973,    5422,  6, }, // America/Phoenix
    {    8, 5954,    5428, 11, }, // America/Port_of_Spain
    {    8, 8404,    5439, 11, }, // America/Porto_Velho
    {    8, 5843,    5450, 10, }, // America/Puerto_Rico
    {    8, 8445,    5460,  6, }, // America/Recife
    {    8, 1995,    5466,  7, }, // America/Regina
    {    8, 8460,    5473,  7, }, // America/Resolute
    {    8,  695,    5480, 10, }, // America/Rio_Branco
    {    8, 6899,    5490, 13, }, // America/Scoresbysund
    {    8, 8508,    5503, 13, }, // America/St_Barthelemy
    {    8, 2061,     351, 10, }, // America/St_Johns
    {    8, 5863,     361,  9, }, // America/St_Kitts
    {    8, 5880,     370,  9, }, // America/St_Lucia
    {    8,  855,     379, 10, }, // America/St_Thomas
    {    8, 5913,     389, 11, }, // America/St_Vincent
    {    8, 8530,    5516, 12, }, // America/Swift_Current
    {    8, 5461,    5528, 11, }, // America/Tegucigalpa
    {    8,  313,    5539,  8, }, // America/Tijuana
    {    8, 5688,    5547,  7, }, // America/Tortola
    {    8,  734,    5554,  7, }, // America/Winnipeg
    {    8, 6001,    5561,  4, }, // Antarctica/Casey
    {    8, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    8, 8568,    5565,  7, }, // Antarctica/Macquarie
    {    8, 7066,    5572,  6, }, // Antarctica/Mawson
    {    8, 8589,    5578,  5, }, // Antarctica/Palmer
    {    8, 7226,    5583,  6, }, // Antarctica/Rothera
    {    8, 8607,    5589,  4, }, // Antarctica/Troll
    {    8, 7374,    5593,  6, }, // Antarctica/Vostok
    {    8, 5395,    5599,  6, }, // Asia/Almaty
    {    8, 3968,    5605,  4, }, // Asia/Amman
    {    8, 5523,    5609,  5, }, // Asia/Aqtau
    {    8, 5368,    5614,  6, }, // Asia/Aqtobe
    {    8, 4466,    5620,  6, }, // Asia/Bangkok
    {    8, 4086,    5626,  6, }, // Asia/Beirut
    {    8, 4601,    5632,  5, }, // Asia/Chita
    {    8, 4511,    5637,  7, }, // Asia/Colombo
    {    8, 4540,    5644,  9, }, // Asia/Damascus
    {    8, 1093,    4717,  4, }, // Asia/Dhaka
    {    8, 4795,    5653,  6, }, // Asia/Hebron
    {    8, 1259,    5659, 10, }, // Asia/Ho_Chi_Minh
    {    8, 7006,    5669,  8, }, // Asia/Jakarta
    {    8, 6992,    5677,  9, }, // Asia/Jayapura
    {    8, 1290,    5686,  9, }, // Asia/Jerusalem
    {    8, 4316,    5695,  9, }, // Asia/Kamchatka
    {    8, 4239,    5704,  7, }, // Asia/Karachi
    {    8, 1185,    5711,  8, }, // Asia/Kathmandu
    {    8,  992,    5719,  7, }, // Asia/Kolkata
    {    8, 5976,    5726,  6, }, // Asia/Kuching
    {    8, 1211,     464,  5, }, // Asia/Macau
    {    8, 1349,    5732,  6, }, // Asia/Makassar
    {    8, 6920,    4326,  6, }, // Asia/Muscat
    {    8, 2554,    5738,  7, }, // Asia/Nicosia
    {    8, 5559,    4332,  4, }, // Asia/Qatar
    {    8, 8708,     469,  8, }, // Asia/Qostanay
    {    8, 3300,    5745,  7, }, // Asia/Singapore
    {    8, 2772,    5752,  6, }, // Asia/Tehran
    {    8, 1317,    5758,  6, }, // Asia/Thimphu
    {    8, 1021,    5764,  9, }, // Asia/Ulaanbaatar
    {    8, 1159,    5773,  7, }, // Asia/Urumqi
    {    8, 6977,    5780, 10, }, // Asia/Vientiane
    {    8, 1235,     477,  6, }, // Asia/Yangon
    {    8, 3883,    5790, 12, }, // Asia/Yekaterinburg
    {    8, 5671,    5802,  6, }, // Atlantic/Bermuda
    {    8, 6628,    4398,  6, }, // Atlantic/Canary
    {    8, 3727,    5808,  7, }, // Atlantic/Cape_Verde
    {    8, 1395,     483,  5, }, // Atlantic/Faroe
    {    8, 2748,    5815, 10, }, // Atlantic/Reykjavik
    {    8, 7272,    5825, 16, }, // Atlantic/South_Georgia
    {    8, 6821,     488, 10, }, // Atlantic/St_Helena
    {    8, 6644,    5841,  6, }, // Atlantic/Stanley
    {    8, 1799,    5847, 11, }, // Australia/Broken_Hill
    {    8, 1583,    5858,  6, }, // Australia/Darwin
    {    8, 3637,    5864,  5, }, // Australia/Eucla
    {    8, 1516,    5869,  5, }, // Australia/Hobart
    {    8, 1547,    5874,  8, }, // Australia/Lord_Howe
    {    8, 1727,    5882,  6, }, // Australia/Melbourne
    {    8, 1762,    5888,  4, }, // Australia/Perth
    {    8, 1463,    5892,  5, }, // Australia/Sydney
    {    8, 6441,    5897,  8, }, // Europe/Amsterdam
    {    8, 6216,    5905,  6, }, // Europe/Andorra
    {    8, 2300,    5911,  5, }, // Europe/Athens
    {    8, 6336,    5916,  8, }, // Europe/Belgrade
    {    8, 4757,    5924,  6, }, // Europe/Berlin
    {    8, 2167,    5930,  8, }, // Europe/Brussels
    {    8, 3928,    5938,  9, }, // Europe/Bucharest
    {    8, 3806,    5947,  8, }, // Europe/Budapest
    {    8, 8772,    5955,  8, }, // Europe/Busingen
    {    8, 2583,    5963,  8, }, // Europe/Chisinau
    {    8, 6289,    5971, 11, }, // Europe/Copenhagen
    {    8, 2338,    5982,  6, }, // Europe/Dublin
    {    8, 6307,    5988,  8, }, // Europe/Gibraltar
    {    8, 6612,    5996,  8, }, // Europe/Helsinki
    {    8, 8823,    6004,  5, }, // Europe/Jersey
    {    8, 2527,     514,  4, }, // Europe/Kyiv
    {    8, 3213,    6009,  6, }, // Europe/Lisbon
    {    8, 6506,    6015, 10, }, // Europe/Ljubljana
    {    8, 2501,    6025,  6, }, // Europe/London
    {    8, 6365,    6031,  8, }, // Europe/Luxembourg
    {    8, 6397,    6039,  5, }, // Europe/Malta
    {    8, 6410,    6044,  6, }, // Europe/Monaco
    {    8, 3537,    6050,  5, }, // Europe/Moscow
    {    8, 6424,    6055,  9, }, // Europe/Podgorica
    {    8, 6324,    6064,  4, }, // Europe/Rome
    {    8, 6245,    6068,  9, }, // Europe/Sarajevo
    {    8, 6383,    6077,  7, }, // Europe/Skopje
    {    8, 6599,    6084,  5, }, // Europe/Sofia
    {    8, 6523,    6089,  7, }, // Europe/Stockholm
    {    8, 6567,    6096,  7, }, // Europe/Vatican
    {    8, 6231,    6103,  5, }, // Europe/Vienna
    {    8, 3190,    6108,  6, }, // Europe/Warsaw
    {    8, 6540,    6114,  7, }, // Europe/Zurich
    {    8, 6947,    6121,  6, }, // Indian/Chagos
    {    8, 6046,    6127,  7, }, // Indian/Christmas
    {    8, 6063,    6134,  6, }, // Indian/Cocos
    {    8, 5029,    6140,  6, }, // Indian/Comoro
    {    8, 6661,    6146,  8, }, // Indian/Kerguelen
    {    8, 4069,    6154, 10, }, // Indian/Mauritius
    {    8, 5098,    6164,  6, }, // Indian/Mayotte
    {    8, 7211,     547,  7, }, // Indian/Reunion
    {    8,  932,    6170,  7, }, // Pacific/Auckland
    {    8, 3015,    6177,  6, }, // Pacific/Chatham
    {    8, 3157,    6183,  5, }, // Pacific/Chuuk
    {    8, 2237,    6188,  5, }, // Pacific/Easter
    {    8, 3902,    6193,  5, }, // Pacific/Fiji
    {    8, 6678,    6198,  9, }, // Pacific/Galapagos
    {    8, 3822,    6207, 11, }, // Pacific/Guadalcanal
    {    8, 2842,    6218, 11, }, // Pacific/Kwajalein
    {    8, 4877,    6229,  7, }, // Pacific/Majuro
    {    8, 4051,    6236,  9, }, // Pacific/Marquesas
    {    8, 4168,    6245,  6, }, // Pacific/Norfolk
    {    8, 7194,    6251,  9, }, // Pacific/Pitcairn
    {    8, 3096,    6260,  6, }, // Pacific/Pohnpei
    {    8, 4807,    6266, 11, }, // Pacific/Port_Moresby
    {    9,   14,       0,  6, }, // Africa/Asmara Akoose/Latin/Cameroon
    {    9, 4435,       6,  8, }, // Africa/Sao_Tome
    {    9, 4252,      14,  8, }, // America/Asuncion
    {    9,  237,      22,  8, }, // America/Atikokan
    {    9, 7623,      30, 17, }, // America/Bahia_Banderas
    {    9, 3868,      47,  6, }, // America/Cancun
    {    9, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    9, 5723,      66,  7, }, // America/Curacao
    {    9,  481,      73, 13, }, // America/Indiana/Knox
    {    9, 7961,      86, 16, }, // America/Indiana/Marengo
    {    9, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    9, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    9, 8038,     139, 14, }, // America/Indiana/Vevay
    {    9, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    9, 8086,     171, 16, }, // America/Indiana/Winamac
    {    9, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    9, 5932,     207, 22, }, // America/Lower_Princes
    {    9, 8220,     229,  6, }, // America/Merida
    {    9, 1850,     235, 19, }, // America/Noronha
    {    9, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {    9, 8329,     274, 20, }, // America/North_Dakota/Center
    {    9, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {    9,  393,     317,  4, }, // America/Nuuk
    {    9, 6899,     321, 16, }, // America/Scoresbysund
    {    9, 8508,     337, 14, }, // America/St_Barthelemy
    {    9, 2061,     351, 10, }, // America/St_Johns
    {    9, 5863,     361,  9, }, // America/St_Kitts
    {    9, 5880,     370,  9, }, // America/St_Lucia
    {    9,  855,     379, 10, }, // America/St_Thomas
    {    9, 5913,     389, 11, }, // America/St_Vincent
    {    9, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {    9, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {    9, 1185,     448,  9, }, // Asia/Kathmandu
    {    9,  992,     457,  7, }, // Asia/Kolkata
    {    9, 1211,     464,  5, }, // Asia/Macau
    {    9, 1235,     477,  6, }, // Asia/Yangon
    {    9, 1395,     483,  5, }, // Atlantic/Faroe
    {    9, 6821,     488, 10, }, // Atlantic/St_Helena
    {    9, 2527,     514,  4, }, // Europe/Kyiv
    {    9, 7211,     547,  7, }, // Indian/Reunion
    {    9, 3157,     554,  5, }, // Pacific/Chuuk
    {    9, 3096,     586,  7, }, // Pacific/Pohnpei
    {   10, 6788,    6277,  7, }, // Africa/Abidjan Albanian/Latin/Albania
    {   10, 6760,    4649,  4, }, // Africa/Accra
    {   10, 5059,    6284, 10, }, // Africa/Addis_Ababa
    {   10, 7420,    6294,  6, }, // Africa/Algiers
    {   10,   14,    6300,  6, }, // Africa/Asmara
    {   10, 6746,    6306,  7, }, // Africa/Banjul
    {   10, 7435,    6313,  5, }, // Africa/Bissau
    {   10, 4957,    6318,  8, }, // Africa/Blantyre
    {   10, 5287,    6326, 10, }, // Africa/Brazzaville
    {   10, 4922,    6336, 10, }, // Africa/Bujumbura
    {   10, 2320,    6346,  5, }, // Africa/Cairo
    {   10, 4117,    6351, 10, }, // Africa/Casablanca
    {   10, 7449,    6361,  6, }, // Africa/Ceuta
    {   10, 6773,    6367,  7, }, // Africa/Conakry
    {   10, 5130,    6374, 12, }, // Africa/Dar_es_Salaam
    {   10, 5043,    6386,  7, }, // Africa/Djibouti
    {   10, 5166,    6393,  7, }, // Africa/El_Aaiun
    {   10, 6853,    6400,  7, }, // Africa/Freetown
    {   10, 4479,    6407, 11, }, // Africa/Johannesburg
    {   10, 4499,    6418,  5, }, // Africa/Juba
    {   10, 4524,    6423,  6, }, // Africa/Khartoum
    {   10, 5336,    6429,  9, }, // Africa/Libreville
    {   10, 5354,    6438,  6, }, // Africa/Niamey
    {   10, 6803,    6444,  7, }, // Africa/Nouakchott
    {   10, 6727,    6451,  8, }, // Africa/Ouagadougou
    {   10, 4435,    6459,  8, }, // Africa/Sao_Tome
    {   10, 6554,    6467,  5, }, // Africa/Tunis
    {   10, 4152,    6472,  8, }, // Africa/Windhoek
    {   10, 3346,    6480,  9, }, // America/Anchorage
    {   10, 5607,    6489,  7, }, // America/Anguilla
    {   10, 4554,    6496, 10, }, // America/Araguaina
    {   10,  166,    6506, 12, }, // America/Argentina/Buenos_Aires
    {   10,   91,    6518,  9, }, // America/Argentina/Catamarca
    {   10,  270,    6527,  7, }, // America/Argentina/Cordoba
    {   10,  441,    6534,  5, }, // America/Argentina/Jujuy
    {   10, 7462,    6539,  8, }, // America/Argentina/La_Rioja
    {   10, 7489,    6547, 11, }, // America/Argentina/Rio_Gallegos
    {   10, 7520,    6558,  5, }, // America/Argentina/Salta
    {   10, 7544,    6563,  8, }, // America/Argentina/San_Juan
    {   10, 5580,    6571,  9, }, // America/Argentina/San_Luis
    {   10, 7571,    4842,  7, }, // America/Argentina/Tucuman
    {   10, 7597,    6580,  7, }, // America/Argentina/Ushuaia
    {   10, 5640,    6587,  5, }, // America/Aruba
    {   10, 4252,    6592,  8, }, // America/Asuncion
    {   10,  237,      22,  8, }, // America/Atikokan
    {   10, 7623,    6600, 14, }, // America/Bahia_Banderas
    {   10, 5407,    6614,  6, }, // America/Belize
    {   10, 7660,    6620, 12, }, // America/Blanc-Sablon
    {   10, 7681,    6632,  9, }, // America/Boa_Vista
    {   10, 4361,    6641,  6, }, // America/Bogota
    {   10, 7699,    6647,  5, }, // America/Boise
    {   10, 7713,    6652, 18, }, // America/Cambridge_Bay
    {   10, 7735,    6670, 12, }, // America/Campo_Grande
    {   10, 3868,    6682,  6, }, // America/Cancun
    {   10, 4694,    4910,  7, }, // America/Caracas
    {   10, 4345,    6688,  6, }, // America/Cayenne
    {   10, 5496,    6694,  6, }, // America/Cayman
    {   10, 2260,    6700,  6, }, // America/Chicago
    {   10, 7756,    6706,  7, }, // America/Chihuahua
    {   10, 7774,    6713, 13, }, // America/Ciudad_Juarez
    {   10, 5422,    6726, 10, }, // America/Costa_Rica
    {   10, 7796,    6736,  7, }, // America/Creston
    {   10, 3791,    6743,  6, }, // America/Cuiaba
    {   10, 5723,    6749,  7, }, // America/Curacao
    {   10, 7812,    6756, 13, }, // America/Danmarkshavn
    {   10, 7833,    6769,  6, }, // America/Dawson
    {   10, 7848,    6775, 16, }, // America/Dawson_Creek
    {   10, 5739,    6791,  8, }, // America/Dominica
    {   10, 7869,    6799,  7, }, // America/Eirunepe
    {   10, 5441,    6806,  8, }, // America/El_Salvador
    {   10, 7886,    6814, 11, }, // America/Fort_Nelson
    {   10, 7924,    6825, 14, }, // America/Glace_Bay
    {   10, 6881,    6839, 13, }, // America/Goose_Bay
    {   10, 4612,    6852, 12, }, // America/Grand_Turk
    {   10, 5770,    6864,  7, }, // America/Grenada
    {   10, 5786,    6871,  9, }, // America/Guadeloupe
    {   10, 3760,    6880,  9, }, // America/Guatemala
    {   10, 4841,    6889,  9, }, // America/Guayaquil
    {   10, 6932,    6898,  7, }, // America/Guyana
    {   10, 1939,    6905,  8, }, // America/Halifax
    {   10, 2281,    6913,  6, }, // America/Havana
    {   10, 7942,    6919,  9, }, // America/Hermosillo
    {   10,  481,    6928, 14, }, // America/Indiana/Knox
    {   10, 7961,      86, 16, }, // America/Indiana/Marengo
    {   10, 7985,    6942, 19, }, // America/Indiana/Petersburg
    {   10, 8012,    6961, 18, }, // America/Indiana/Tell_City
    {   10, 8038,    6979, 14, }, // America/Indiana/Vevay
    {   10, 8060,    6993, 17, }, // America/Indiana/Vincennes
    {   10, 8086,    7010, 16, }, // America/Indiana/Winamac
    {   10,  660,    5177,  7, }, // America/Iqaluit
    {   10, 2799,    7026,  8, }, // America/Jamaica
    {   10, 5380,    7034,  6, }, // America/Juneau
    {   10,  521,    7040,  8, }, // America/Kentucky/Louisville
    {   10, 8125,    7048, 18, }, // America/Kentucky/Monticello
    {   10, 7169,    7066,  4, }, // America/Lima
    {   10, 3239,    7070, 12, }, // America/Los_Angeles
    {   10, 5932,    7082, 21, }, // America/Lower_Princes
    {   10, 8153,    7103,  6, }, // America/Maceio
    {   10, 5805,    7109,  9, }, // America/Martinique
    {   10, 8202,    7118,  8, }, // America/Menominee
    {   10, 8220,    7126,  6, }, // America/Merida
    {   10, 2949,    7132, 17, }, // America/Mexico_City
    {   10, 4391,    7149,  7, }, // America/Miquelon
    {   10, 8254,    7156,  7, }, // America/Moncton
    {   10, 8270,    7163,  9, }, // America/Monterrey
    {   10, 5824,    7172,  9, }, // America/Montserrat
    {   10, 5481,    7181,  5, }, // America/Nassau
    {   10, 2379,    7186,  8, }, // America/New_York
    {   10, 1850,    7194,  7, }, // America/Noronha
    {   10, 8301,    7201, 22, }, // America/North_Dakota/Beulah
    {   10, 8329,    7223, 23, }, // America/North_Dakota/Center
    {   10, 8357,    7246, 26, }, // America/North_Dakota/New_Salem
    {   10,  393,    7272,  4, }, // America/Nuuk
    {   10, 8388,    7276,  7, }, // America/Ojinaga
    {   10, 2973,    7283,  6, }, // America/Phoenix
    {   10, 3945,    7289, 12, }, // America/Port-au-Prince
    {   10, 8404,    7301, 11, }, // America/Porto_Velho
    {   10, 5843,    7312, 10, }, // America/Puerto_Rico
    {   10, 4030,    7322, 12, }, // America/Punta_Arenas
    {   10, 8424,    7334, 11, }, // America/Rankin_Inlet
    {   10, 1995,    7345,  7, }, // America/Regina
    {   10,  695,    7352, 10, }, // America/Rio_Branco
    {   10, 6111,    7362, 13, }, // America/Santo_Domingo
    {   10, 1878,    7375,  9, }, // America/Sao_Paulo
    {   10, 6899,    7384, 12, }, // America/Scoresbysund
    {   10, 8508,    7396, 13, }, // America/St_Barthelemy
    {   10, 2061,    7409,  9, }, // America/St_Johns
    {   10, 5863,    7418,  9, }, // America/St_Kitts
    {   10, 5880,    7427, 10, }, // America/St_Lucia
    {   10,  855,    7437, 10, }, // America/St_Thomas
    {   10, 5913,    7447, 12, }, // America/St_Vincent
    {   10, 8530,    7459, 15, }, // America/Swift_Current
    {   10, 5461,    5528, 11, }, // America/Tegucigalpa
    {   10, 5756,    7474,  5, }, // America/Thule
    {   10,  313,    7479,  7, }, // America/Tijuana
    {   10, 5688,    7486,  7, }, // America/Tortola
    {   10, 2093,    7493,  8, }, // America/Vancouver
    {   10, 2144,    7501,  9, }, // America/Whitehorse
    {   10,  734,    7510,  7, }, // America/Winnipeg
    {   10, 8552,    7517,  7, }, // America/Yakutat
    {   10, 6001,    7524,  5, }, // Antarctica/Casey
    {   10, 6094,    7529,  6, }, // Antarctica/Davis
    {   10, 6133,    7535, 15, }, // Antarctica/DumontDUrville
    {   10, 8568,    7550,  7, }, // Antarctica/Macquarie
    {   10, 7066,    7557,  6, }, // Antarctica/Mawson
    {   10, 7113,    7563,  8, }, // Antarctica/McMurdo
    {   10, 7226,    7571,  7, }, // Antarctica/Rothera
    {   10, 7295,    7578,  5, }, // Antarctica/Syowa
    {   10, 1429,    7583, 11, }, // Arctic/Longyearbyen
    {   10, 5395,    7594,  6, }, // Asia/Almaty
    {   10, 3968,    5605,  4, }, // Asia/Amman
    {   10, 5511,    7600,  6, }, // Asia/Anadyr
    {   10, 5523,    5609,  5, }, // Asia/Aqtau
    {   10, 5368,    7606,  6, }, // Asia/Aqtobe
    {   10, 8624,    7612,  6, }, // Asia/Atyrau
    {   10, 3607,    4162,  6, }, // Asia/Baghdad
    {   10, 5534,    7618,  7, }, // Asia/Bahrain
    {   10, 4086,    7625,  6, }, // Asia/Beirut
    {   10, 4601,    7631,  4, }, // Asia/Chita
    {   10, 4511,    5637,  7, }, // Asia/Colombo
    {   10, 4540,    4201,  6, }, // Asia/Damascus
    {   10, 1093,    4717,  4, }, // Asia/Dhaka
    {   10, 8636,    7635,  9, }, // Asia/Famagusta
    {   10, 1259,    7644,  9, }, // Asia/Ho_Chi_Minh
    {   10, 2704,    7653,  9, }, // Asia/Hong_Kong
    {   10, 7006,    7662,  8, }, // Asia/Jakarta
    {   10, 6992,    7670,  9, }, // Asia/Jayapura
    {   10, 4316,    7679,  8, }, // Asia/Kamchatka
    {   10, 4239,    7687,  6, }, // Asia/Karachi
    {   10, 1185,    5711,  8, }, // Asia/Kathmandu
    {   10, 8661,    7693,  7, }, // Asia/Khandyga
    {   10,  992,    7700,  7, }, // Asia/Kolkata
    {   10, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {   10, 4859,    7707, 12, }, // Asia/Kuala_Lumpur
    {   10, 5976,    7719,  6, }, // Asia/Kuching
    {   10, 5547,    7725,  6, }, // Asia/Kuwait
    {   10, 1211,    7731,  5, }, // Asia/Macau
    {   10, 1349,    7736,  7, }, // Asia/Makassar
    {   10, 7182,    7743,  6, }, // Asia/Manila
    {   10, 6920,    4326,  6, }, // Asia/Muscat
    {   10, 2554,    7749,  7, }, // Asia/Nicosia
    {   10, 6961,    7756,  8, }, // Asia/Phnom_Penh
    {   10, 4214,    7764,  6, }, // Asia/Pyongyang
    {   10, 5559,    4332,  5, }, // Asia/Qatar
    {   10, 8708,    7770,  8, }, // Asia/Qostanay
    {   10, 4269,    7778,  9, }, // Asia/Qyzylorda
    {   10, 3584,    7787,  4, }, // Asia/Riyadh
    {   10, 4408,    7791,  7, }, // Asia/Sakhalin
    {   10, 3279,    7798,  4, }, // Asia/Seoul
    {   10, 1053,    7802,  7, }, // Asia/Shanghai
    {   10, 3300,    7809,  8, }, // Asia/Singapore
    {   10, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {   10, 3263,    7830,  6, }, // Asia/Taipei
    {   10, 3915,    7836,  6, }, // Asia/Tbilisi
    {   10, 2772,    7842,  7, }, // Asia/Tehran
    {   10, 1317,    7849,  6, }, // Asia/Thimphu
    {   10, 2821,    4356,  5, }, // Asia/Tokyo
    {   10, 1021,    7855,  9, }, // Asia/Ulaanbaatar
    {   10, 6977,    7864,  9, }, // Asia/Vientiane
    {   10, 4828,    7873,  7, }, // Asia/Yakutsk
    {   10, 1235,    7880,  6, }, // Asia/Yangon
    {   10, 3883,    7886, 12, }, // Asia/Yekaterinburg
    {   10, 3747,    7898,  7, }, // Asia/Yerevan
    {   10, 3663,    7905,  5, }, // Atlantic/Azores
    {   10, 5671,    7910,  7, }, // Atlantic/Bermuda
    {   10, 6628,    4398,  6, }, // Atlantic/Canary
    {   10, 3727,    7917, 14, }, // Atlantic/Cape_Verde
    {   10, 1395,     483,  5, }, // Atlantic/Faroe
    {   10, 2748,    7931,  9, }, // Atlantic/Reykjavik
    {   10, 7272,    7940, 15, }, // Atlantic/South_Georgia
    {   10, 6821,    7955, 10, }, // Atlantic/St_Helena
    {   10, 6644,    7965,  6, }, // Atlantic/Stanley
    {   10, 1670,    7971,  8, }, // Australia/Adelaide
    {   10, 1635,    7979,  8, }, // Australia/Brisbane
    {   10, 1799,    7987, 11, }, // Australia/Broken_Hill
    {   10, 1583,    7998,  6, }, // Australia/Darwin
    {   10, 3637,    5864,  5, }, // Australia/Eucla
    {   10, 8753,    8004,  8, }, // Australia/Lindeman
    {   10, 1547,    8012,  9, }, // Australia/Lord_Howe
    {   10, 1727,    8021,  7, }, // Australia/Melbourne
    {   10, 1762,    8028,  5, }, // Australia/Perth
    {   10, 1463,    8033,  6, }, // Australia/Sydney
    {   10, 6216,    8039,  7, }, // Europe/Andorra
    {   10, 3620,    8046,  8, }, // Europe/Astrakhan
    {   10, 2300,    8054,  6, }, // Europe/Athens
    {   10, 6336,    8060,  7, }, // Europe/Belgrade
    {   10, 6488,    8067, 10, }, // Europe/Bratislava
    {   10, 2167,    8077,  7, }, // Europe/Brussels
    {   10, 3928,    8084,  9, }, // Europe/Bucharest
    {   10, 2583,    8093,  8, }, // Europe/Chisinau
    {   10, 6289,    4475, 10, }, // Europe/Copenhagen
    {   10, 6307,    8101, 10, }, // Europe/Gibraltar
    {   10, 8788,    8111,  7, }, // Europe/Guernsey
    {   10, 8804,    8118, 15, }, // Europe/Isle_of_Man
    {   10, 1130,    8133,  8, }, // Europe/Istanbul
    {   10, 8823,    8141,  7, }, // Europe/Jersey
    {   10, 2527,    8148,  4, }, // Europe/Kyiv
    {   10, 3213,    8152,  7, }, // Europe/Lisbon
    {   10, 6506,    8159,  7, }, // Europe/Ljubljana
    {   10, 2501,    8166,  6, }, // Europe/London
    {   10, 6365,    8172, 10, }, // Europe/Luxembourg
    {   10, 6397,    8182,  5, }, // Europe/Malta
    {   10, 6410,    6044,  6, }, // Europe/Monaco
    {   10, 3537,    8187,  5, }, // Europe/Moscow
    {   10, 6424,    8192,  9, }, // Europe/Podgorica
    {   10, 6275,    8201,  5, }, // Europe/Prague
    {   10, 8837,    8206,  4, }, // Europe/Riga
    {   10, 6324,    8210,  4, }, // Europe/Rome
    {   10, 6470,    8214, 10, }, // Europe/San_Marino
    {   10, 6245,    8224,  8, }, // Europe/Sarajevo
    {   10, 6383,    8232,  5, }, // Europe/Skopje
    {   10, 6599,    8237,  5, }, // Europe/Sofia
    {   10, 6523,    8242,  8, }, // Europe/Stockholm
    {   10, 8867,    8250,  5, }, // Europe/Tallinn
    {   10, 6202,    8255,  6, }, // Europe/Tirane
    {   10, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {   10, 6567,    6096,  7, }, // Europe/Vatican
    {   10, 6231,    8270,  5, }, // Europe/Vienna
    {   10, 3190,    8275,  8, }, // Europe/Warsaw
    {   10, 6540,    8283,  5, }, // Europe/Zurich
    {   10, 6947,    8288,  5, }, // Indian/Chagos
    {   10, 6046,    8293, 12, }, // Indian/Christmas
    {   10, 6063,    4583,  5, }, // Indian/Cocos
    {   10, 5029,    8305,  6, }, // Indian/Comoro
    {   10, 7050,    8311,  7, }, // Indian/Maldives
    {   10, 5098,    8318,  6, }, // Indian/Mayotte
    {   10, 7211,     547,  7, }, // Indian/Reunion
    {   10,  932,    8324,  6, }, // Pacific/Auckland
    {   10, 3706,    8330, 10, }, // Pacific/Bougainville
    {   10, 3015,    8340,  6, }, // Pacific/Chatham
    {   10, 3157,    8346,  3, }, // Pacific/Chuuk
    {   10, 2237,    8349,  6, }, // Pacific/Easter
    {   10, 3902,    8355,  5, }, // Pacific/Fiji
    {   10, 3822,    8360, 11, }, // Pacific/Guadalcanal
    {   10, 2723,    4611,  8, }, // Pacific/Honolulu
    {   10, 3049,    4619,  8, }, // Pacific/Kanton
    {   10, 3998,    8371,  9, }, // Pacific/Kiritimati
    {   10, 7019,    8380,  5, }, // Pacific/Kosrae
    {   10, 2842,    8385, 10, }, // Pacific/Kwajalein
    {   10, 4877,    8395,  6, }, // Pacific/Majuro
    {   10, 4051,    8401,  6, }, // Pacific/Marquesas
    {   10, 8914,    8407,  6, }, // Pacific/Midway
    {   10, 3126,    8413,  9, }, // Pacific/Pago_Pago
    {   10, 7194,    8422,  7, }, // Pacific/Pitcairn
    {   10, 3096,    8429,  7, }, // Pacific/Pohnpei
    {   10, 4807,    8436, 12, }, // Pacific/Port_Moresby
    {   10, 6076,    8448,  9, }, // Pacific/Rarotonga
    {   10, 6712,    8457,  6, }, // Pacific/Tarawa
    {   10, 7392,    8463,  4, }, // Pacific/Wake
    {   10, 7405,    8467,  6, }, // Pacific/Wallis
    {   13, 6788,    8473,  4, }, // Africa/Abidjan Amharic/Ethiopic/Ethiopia
    {   13, 6760,    8477,  3, }, // Africa/Accra
    {   13, 5059,    8480,  7, }, // Africa/Addis_Ababa
    {   13, 7420,    8487,  5, }, // Africa/Algiers
    {   13,   14,    8492,  4, }, // Africa/Asmara
    {   13,   44,    8496,  3, }, // Africa/Bamako
    {   13, 5257,    8499,  4, }, // Africa/Bangui
    {   13, 6746,    8503,  4, }, // Africa/Banjul
    {   13, 7435,    8507,  3, }, // Africa/Bissau
    {   13, 4957,    8510,  6, }, // Africa/Blantyre
    {   13, 5287,    8516,  5, }, // Africa/Brazzaville
    {   13, 4922,    8521,  5, }, // Africa/Bujumbura
    {   13, 2320,    8526,  3, }, // Africa/Cairo
    {   13, 4117,    8529,  6, }, // Africa/Casablanca
    {   13, 7449,    8535,  3, }, // Africa/Ceuta
    {   13, 6773,    8538,  4, }, // Africa/Conakry
    {   13, 6840,    8542,  3, }, // Africa/Dakar
    {   13, 5130,    8545,  6, }, // Africa/Dar_es_Salaam
    {   13, 5043,    8551,  3, }, // Africa/Djibouti
    {   13, 5243,    8554,  3, }, // Africa/Douala
    {   13, 5166,    8557,  7, }, // Africa/El_Aaiun
    {   13, 6853,    8564,  5, }, // Africa/Freetown
    {   13, 4906,    8569,  4, }, // Africa/Gaborone
    {   13, 5015,    8573,  3, }, // Africa/Harare
    {   13, 4479,    8576,  7, }, // Africa/Johannesburg
    {   13, 4499,    8583,  2, }, // Africa/Juba
    {   13, 5151,    8585,  4, }, // Africa/Kampala
    {   13, 4524,    8589,  4, }, // Africa/Khartoum
    {   13, 4973,    8593,  3, }, // Africa/Kigali
    {   13, 5306,    8596,  4, }, // Africa/Kinshasa
    {   13, 4744,    8600,  3, }, // Africa/Lagos
    {   13, 5336,    8603,  5, }, // Africa/Libreville
    {   13, 6869,    8608,  2, }, // Africa/Lome
    {   13, 5211,    8610,  4, }, // Africa/Luanda
    {   13, 4939,    8614,  5, }, // Africa/Lubumbashi
    {   13, 5001,    8619,  3, }, // Africa/Lusaka
    {   13, 5322,    8622,  3, }, // Africa/Malabo
    {   13, 4987,    8625,  3, }, // Africa/Maputo
    {   13, 5197,    8628,  3, }, // Africa/Maseru
    {   13, 5182,    8631,  4, }, // Africa/Mbabane
    {   13, 5113,    8635,  4, }, // Africa/Mogadishu
    {   13, 7034,    8639,  5, }, // Africa/Monrovia
    {   13, 3853,    8644,  4, }, // Africa/Nairobi
    {   13, 5271,    8648,  4, }, // Africa/Ndjamena
    {   13, 5354,    8652,  4, }, // Africa/Niamey
    {   13, 6803,    8656,  5, }, // Africa/Nouakchott
    {   13, 6727,    8661,  4, }, // Africa/Ouagadougou
    {   13, 5225,    8665,  8, }, // Africa/Porto-Novo
    {   13, 4435,    8673,  5, }, // Africa/Sao_Tome
    {   13, 2866,    8678,  4, }, // Africa/Tripoli
    {   13, 6554,    8682,  3, }, // Africa/Tunis
    {   13, 4152,    8685,  5, }, // Africa/Windhoek
    {   13,  132,    8690,  3, }, // America/Adak
    {   13, 3346,    8693,  5, }, // America/Anchorage
    {   13, 5607,    8698,  5, }, // America/Anguilla
    {   13, 5624,    8703,  4, }, // America/Antigua
    {   13, 4554,    8707,  5, }, // America/Araguaina
    {   13,  166,    8712,  8, }, // America/Argentina/Buenos_Aires
    {   13,   91,    8720,  5, }, // America/Argentina/Catamarca
    {   13,  270,    8725,  4, }, // America/Argentina/Cordoba
    {   13,  441,    8729,  3, }, // America/Argentina/Jujuy
    {   13, 7462,    8732,  5, }, // America/Argentina/La_Rioja
    {   13,  565,    8737,  4, }, // America/Argentina/Mendoza
    {   13, 7489,    8741,  7, }, // America/Argentina/Rio_Gallegos
    {   13, 7520,    8748,  3, }, // America/Argentina/Salta
    {   13, 7544,    8751,  6, }, // America/Argentina/San_Juan
    {   13, 5580,    8757,  6, }, // America/Argentina/San_Luis
    {   13, 7571,    8763,  4, }, // America/Argentina/Tucuman
    {   13, 7597,    8767,  4, }, // America/Argentina/Ushuaia
    {   13, 5640,    8771,  3, }, // America/Aruba
    {   13, 4252,    8774,  6, }, // America/Asuncion
    {   13,  237,    8780,  5, }, // America/Atikokan
    {   13, 3679,    8785,  3, }, // America/Bahia
    {   13, 7623,    8788,  9, }, // America/Bahia_Banderas
    {   13, 5654,    8797,  5, }, // America/Barbados
    {   13, 7646,    8802,  3, }, // America/Belem
    {   13, 5407,    8805,  3, }, // America/Belize
    {   13, 7660,    8808, 10, }, // America/Blanc-Sablon
    {   13, 7681,    8818,  6, }, // America/Boa_Vista
    {   13, 4361,    8824,  3, }, // America/Bogota
    {   13, 7699,    8827,  3, }, // America/Boise
    {   13, 7713,    8830,  8, }, // America/Cambridge_Bay
    {   13, 7735,    8838,  8, }, // America/Campo_Grande
    {   13, 3868,    8846,  4, }, // America/Cancun
    {   13, 4694,    8850,  4, }, // America/Caracas
    {   13, 4345,    8854,  4, }, // America/Cayenne
    {   13, 5496,    8858,  4, }, // America/Cayman
    {   13, 2260,    8862,  3, }, // America/Chicago
    {   13, 7756,    8865,  5, }, // America/Chihuahua
    {   13, 7774,    8870,  9, }, // America/Ciudad_Juarez
    {   13, 5422,    8879,  5, }, // America/Costa_Rica
    {   13, 7796,    8884,  5, }, // America/Creston
    {   13, 3791,    8889,  4, }, // America/Cuiaba
    {   13, 5723,    8893,  4, }, // America/Curacao
    {   13, 7812,    8897,  8, }, // America/Danmarkshavn
    {   13, 7833,    8905,  4, }, // America/Dawson
    {   13, 7848,    8909,  8, }, // America/Dawson_Creek
    {   13,  805,    8917,  4, }, // America/Denver
    {   13, 3465,    8921,  5, }, // America/Detroit
    {   13, 5739,    8926,  4, }, // America/Dominica
    {   13,  893,    8930,  6, }, // America/Edmonton
    {   13, 7869,    8936,  4, }, // America/Eirunepe
    {   13, 5441,    8940,  7, }, // America/El_Salvador
    {   13, 7886,    8947,  8, }, // America/Fort_Nelson
    {   13, 7906,    8955,  5, }, // America/Fortaleza
    {   13, 7924,    8960,  6, }, // America/Glace_Bay
    {   13, 6881,    8966,  5, }, // America/Goose_Bay
    {   13, 4612,    8971,  8, }, // America/Grand_Turk
    {   13, 5770,    8979,  4, }, // America/Grenada
    {   13, 5786,    8983,  4, }, // America/Guadeloupe
    {   13, 3760,    8987,  4, }, // America/Guatemala
    {   13, 4841,    8991,  5, }, // America/Guayaquil
    {   13, 6932,    8996,  3, }, // America/Guyana
    {   13, 1939,    8999,  5, }, // America/Halifax
    {   13, 2281,    9004,  3, }, // America/Havana
    {   13, 7942,    9007,  5, }, // America/Hermosillo
    {   13,  348,    9012,  8, }, // America/Indiana/Indianapolis
    {   13,  481,    9020, 10, }, // America/Indiana/Knox
    {   13, 7961,    9030, 11, }, // America/Indiana/Marengo
    {   13, 7985,    9041, 14, }, // America/Indiana/Petersburg
    {   13, 8012,    9055, 13, }, // America/Indiana/Tell_City
    {   13, 8038,    9068, 10, }, // America/Indiana/Vevay
    {   13, 8060,    9078, 12, }, // America/Indiana/Vincennes
    {   13, 8086,    9090, 11, }, // America/Indiana/Winamac
    {   13, 8110,    9101,  4, }, // America/Inuvik
    {   13,  660,    9105,  5, }, // America/Iqaluit
    {   13, 2799,    9110,  4, }, // America/Jamaica
    {   13, 5380,    9114,  3, }, // America/Juneau
    {   13,  521,    9117,  5, }, // America/Kentucky/Louisville
    {   13, 8125,    9122, 11, }, // America/Kentucky/Monticello
    {   13, 5704,    9133,  7, }, // America/Kralendijk
    {   13, 4376,    9140,  4, }, // America/La_Paz
    {   13, 7169,    9144,  2, }, // America/Lima
    {   13, 3239,    9146,  8, }, // America/Los_Angeles
    {   13, 5932,    9154, 12, }, // America/Lower_Princes
    {   13, 8153,    9166,  3, }, // America/Maceio
    {   13, 8168,    9169,  4, }, // America/Managua
    {   13, 1908,    9173,  4, }, // America/Manaus
    {   13, 5897,    9177,  4, }, // America/Marigot
    {   13, 5805,    9181,  5, }, // America/Martinique
    {   13, 8184,    9186,  5, }, // America/Matamoros
    {   13, 2917,    9191,  5, }, // America/Mazatlan
    {   13, 8202,    9196,  4, }, // America/Menominee
    {   13, 8220,    9200,  3, }, // America/Merida
    {   13, 8235,    9203,  6, }, // America/Metlakatla
    {   13, 2949,    9209,  8, }, // America/Mexico_City
    {   13, 4391,    9217,  5, }, // America/Miquelon
    {   13, 8254,    9222,  5, }, // America/Moncton
    {   13, 8270,    9227,  6, }, // America/Monterrey
    {   13, 4098,    9233,  6, }, // America/Montevideo
    {   13, 5824,    9239,  6, }, // America/Montserrat
    {   13, 5481,    9245,  3, }, // America/Nassau
    {   13, 2379,    9248,  5, }, // America/New_York
    {   13, 8288,    9253,  2, }, // America/Nome
    {   13, 1850,    9255,  3, }, // America/Noronha
    {   13, 8301,    9258, 13, }, // America/North_Dakota/Beulah
    {   13, 8329,    9271, 14, }, // America/North_Dakota/Center
    {   13, 8357,    9285, 16, }, // America/North_Dakota/New_Salem
    {   13,  393,    9301,  4, }, // America/Nuuk
    {   13, 8388,    9305,  4, }, // America/Ojinaga
    {   13, 2356,    9309,  3, }, // America/Panama
    {   13, 6173,    9312,  5, }, // America/Paramaribo
    {   13, 2973,    9317,  4, }, // America/Phoenix
    {   13, 3945,    9321, 10, }, // America/Port-au-Prince
    {   13, 5954,    9331,  9, }, // America/Port_of_Spain
    {   13, 8404,    9340,  7, }, // America/Porto_Velho
    {   13, 5843,    9347,  5, }, // America/Puerto_Rico
    {   13, 4030,    9352,  8, }, // America/Punta_Arenas
    {   13, 8424,    9360,  9, }, // America/Rankin_Inlet
    {   13, 8445,    9369,  3, }, // America/Recife
    {   13, 1995,    9372,  3, }, // America/Regina
    {   13, 8460,    9375,  5, }, // America/Resolute
    {   13,  695,    9380,  7, }, // America/Rio_Branco
    {   13, 8477,    9387,  5, }, // America/Santarem
    {   13, 2201,    9392,  5, }, // America/Santiago
    {   13, 6111,    9397,  8, }, // America/Santo_Domingo
    {   13, 1878,    9405,  5, }, // America/Sao_Paulo
    {   13, 6899,    9410,  9, }, // America/Scoresbysund
    {   13, 8494,    9419,  3, }, // America/Sitka
    {   13, 8508,    9422, 10, }, // America/St_Barthelemy
    {   13, 2061,    9432,  8, }, // America/St_Johns
    {   13, 5863,    9440,  7, }, // America/St_Kitts
    {   13, 5880,    9447,  8, }, // America/St_Lucia
    {   13,  855,    9455,  7, }, // America/St_Thomas
    {   13, 5913,    9462,  9, }, // America/St_Vincent
    {   13, 8530,    9471,  9, }, // America/Swift_Current
    {   13, 5461,    9480,  6, }, // America/Tegucigalpa
    {   13, 5756,    9486,  2, }, // America/Thule
    {   13,  313,    9488,  4, }, // America/Tijuana
    {   13,  608,    9492,  4, }, // America/Toronto
    {   13, 5688,    9496,  4, }, // America/Tortola
    {   13, 2093,    9500,  5, }, // America/Vancouver
    {   13, 2144,    9505,  6, }, // America/Whitehorse
    {   13,  734,    9511,  4, }, // America/Winnipeg
    {   13, 8552,    9515,  4, }, // America/Yakutat
    {   13, 6001,    9519,  3, }, // Antarctica/Casey
    {   13, 6094,    9522,  3, }, // Antarctica/Davis
    {   13, 6133,    9525, 10, }, // Antarctica/DumontDUrville
    {   13, 8568,    9535,  3, }, // Antarctica/Macquarie
    {   13, 7066,    9538,  4, }, // Antarctica/Mawson
    {   13, 7113,    9542,  5, }, // Antarctica/McMurdo
    {   13, 8589,    9547,  4, }, // Antarctica/Palmer
    {   13, 7226,    9551,  3, }, // Antarctica/Rothera
    {   13, 7295,    9554,  3, }, // Antarctica/Syowa
    {   13, 8607,    9557,  3, }, // Antarctica/Troll
    {   13, 7374,    9560,  4, }, // Antarctica/Vostok
    {   13, 1429,    9564,  8, }, // Arctic/Longyearbyen
    {   13, 5570,    9572,  3, }, // Asia/Aden
    {   13, 5395,    9575,  5, }, // Asia/Almaty
    {   13, 3968,    9580,  3, }, // Asia/Amman
    {   13, 5511,    9583,  5, }, // Asia/Anadyr
    {   13, 5523,    9588,  4, }, // Asia/Aqtau
    {   13, 5368,    9592,  4, }, // Asia/Aqtobe
    {   13,  964,    9596,  5, }, // Asia/Ashgabat
    {   13, 8624,    9601,  5, }, // Asia/Atyrau
    {   13, 3607,    9606,  4, }, // Asia/Baghdad
    {   13, 5534,    9610,  4, }, // Asia/Bahrain
    {   13, 3653,    8892,  2, }, // Asia/Baku
    {   13, 4466,    9614,  4, }, // Asia/Bangkok
    {   13, 3571,    9618,  5, }, // Asia/Barnaul
    {   13, 4086,    9623,  3, }, // Asia/Beirut
    {   13, 3778,    9626,  4, }, // Asia/Bishkek
    {   13, 5989,    9630,  4, }, // Asia/Brunei
    {   13, 4601,    9634,  2, }, // Asia/Chita
    {   13, 4511,    9636,  4, }, // Asia/Colombo
    {   13, 4540,    9640,  4, }, // Asia/Damascus
    {   13, 1093,    8542,  2, }, // Asia/Dhaka
    {   13, 6192,    9644,  2, }, // Asia/Dili
    {   13, 3596,    9646,  3, }, // Asia/Dubai
    {   13, 6159,    9649,  4, }, // Asia/Dushanbe
    {   13, 8636,    9653,  5, }, // Asia/Famagusta
    {   13, 8651,    9658,  2, }, // Asia/Gaza
    {   13, 4795,    9660,  4, }, // Asia/Hebron
    {   13, 1259,    9664, 11, }, // Asia/Ho_Chi_Minh
    {   13, 2704,    9675,  7, }, // Asia/Hong_Kong
    {   13, 4771,    9682,  3, }, // Asia/Hovd
    {   13, 4184,    9685,  6, }, // Asia/Irkutsk
    {   13, 7006,    9691,  4, }, // Asia/Jakarta
    {   13, 6992,    9695,  4, }, // Asia/Jayapura
    {   13, 1290,    9699,  6, }, // Asia/Jerusalem
    {   13, 3560,    9705,  3, }, // Asia/Kabul
    {   13, 4316,    9708,  5, }, // Asia/Kamchatka
    {   13, 4239,    9713,  3, }, // Asia/Karachi
    {   13, 1185,    9716,  5, }, // Asia/Kathmandu
    {   13, 8661,    9721,  4, }, // Asia/Khandyga
    {   13,  992,    9725,  4, }, // Asia/Kolkata
    {   13, 4197,    9729,  8, }, // Asia/Krasnoyarsk
    {   13, 4859,    9737,  8, }, // Asia/Kuala_Lumpur
    {   13, 5976,    9745,  4, }, // Asia/Kuching
    {   13, 5547,    9749,  3, }, // Asia/Kuwait
    {   13, 1211,    9752,  3, }, // Asia/Macau
    {   13, 4017,    9755,  4, }, // Asia/Magadan
    {   13, 1349,    9759,  4, }, // Asia/Makassar
    {   13, 7182,    9763,  3, }, // Asia/Manila
    {   13, 6920,    9766,  4, }, // Asia/Muscat
    {   13, 2554,    9770,  4, }, // Asia/Nicosia
    {   13, 8675,    9774,  7, }, // Asia/Novokuznetsk
    {   13, 4135,    9781,  7, }, // Asia/Novosibirsk
    {   13, 4229,    9788,  4, }, // Asia/Omsk
    {   13, 7145,    9792,  3, }, // Asia/Oral
    {   13, 6961,    9795,  7, }, // Asia/Phnom_Penh
    {   13, 8693,    9802,  6, }, // Asia/Pontianak
    {   13, 4214,    9808,  7, }, // Asia/Pyongyang
    {   13, 5559,    9815,  3, }, // Asia/Qatar
    {   13, 8708,    9818,  5, }, // Asia/Qostanay
    {   13, 4269,    9823,  6, }, // Asia/Qyzylorda
    {   13, 3584,    9829,  3, }, // Asia/Riyadh
    {   13, 4408,    9832,  5, }, // Asia/Sakhalin
    {   13, 7245,    9837,  6, }, // Asia/Samarkand
    {   13, 3279,    9843,  3, }, // Asia/Seoul
    {   13, 1053,    9846,  4, }, // Asia/Shanghai
    {   13, 3300,    9850,  5, }, // Asia/Singapore
    {   13, 4297,    9855, 10, }, // Asia/Srednekolymsk
    {   13, 3263,    9865,  4, }, // Asia/Taipei
    {   13, 4781,    9869,  5, }, // Asia/Tashkent
    {   13, 3915,    9874,  4, }, // Asia/Tbilisi
    {   13, 2772,    9878,  4, }, // Asia/Tehran
    {   13, 1317,    9882,  3, }, // Asia/Thimphu
    {   13, 2821,    9885,  3, }, // Asia/Tokyo
    {   13, 4572,    9888,  4, }, // Asia/Tomsk
    {   13, 1021,    9892,  8, }, // Asia/Ulaanbaatar
    {   13, 1159,    9900,  4, }, // Asia/Urumqi
    {   13, 8722,    9904,  6, }, // Asia/Ust-Nera
    {   13, 6977,    9910,  5, }, // Asia/Vientiane
    {   13, 4710,    9915,  7, }, // Asia/Vladivostok
    {   13, 4828,    9922,  5, }, // Asia/Yakutsk
    {   13, 1235,    9927,  4, }, // Asia/Yangon
    {   13, 3883,    9931,  8, }, // Asia/Yekaterinburg
    {   13, 3747,    9939,  4, }, // Asia/Yerevan
    {   13, 3663,    9943,  4, }, // Atlantic/Azores
    {   13, 5671,    9947,  4, }, // Atlantic/Bermuda
    {   13, 6628,    9951,  3, }, // Atlantic/Canary
    {   13, 3727,    9954,  6, }, // Atlantic/Cape_Verde
    {   13, 1395,    9960,  3, }, // Atlantic/Faroe
    {   13, 8736,    9963,  3, }, // Atlantic/Madeira
    {   13, 2748,    9966,  6, }, // Atlantic/Reykjavik
    {   13, 7272,    9972,  8, }, // Atlantic/South_Georgia
    {   13, 6821,    9980,  8, }, // Atlantic/St_Helena
    {   13, 6644,    9988,  5, }, // Atlantic/Stanley
    {   13, 1670,    9993,  5, }, // Australia/Adelaide
    {   13, 1635,    9998,  5, }, // Australia/Brisbane
    {   13, 1799,   10003,  7, }, // Australia/Broken_Hill
    {   13, 1583,   10010,  4, }, // Australia/Darwin
    {   13, 3637,   10014,  3, }, // Australia/Eucla
    {   13, 1516,   10017,  4, }, // Australia/Hobart
    {   13, 8753,   10021,  5, }, // Australia/Lindeman
    {   13, 1547,   10026,  6, }, // Australia/Lord_Howe
    {   13, 1727,   10032,  5, }, // Australia/Melbourne
    {   13, 1762,   10037,  3, }, // Australia/Perth
    {   13, 1463,   10040,  3, }, // Australia/Sydney
    {   13, 6441,   10043,  7, }, // Europe/Amsterdam
    {   13, 6216,   10050,  4, }, // Europe/Andorra
    {   13, 3620,   10054,  7, }, // Europe/Astrakhan
    {   13, 2300,   10061,  4, }, // Europe/Athens
    {   13, 6336,   10065,  5, }, // Europe/Belgrade
    {   13, 4757,   10070,  4, }, // Europe/Berlin
    {   13, 6488,   10074,  6, }, // Europe/Bratislava
    {   13, 2167,   10080,  5, }, // Europe/Brussels
    {   13, 3928,   10085,  5, }, // Europe/Bucharest
    {   13, 3806,   10090,  5, }, // Europe/Budapest
    {   13, 8772,   10095,  5, }, // Europe/Busingen
    {   13, 2583,   10100,  4, }, // Europe/Chisinau
    {   13, 6289,   10104,  6, }, // Europe/Copenhagen
    {   13, 2338,   10110,  4, }, // Europe/Dublin
    {   13, 6307,   10114,  6, }, // Europe/Gibraltar
    {   13, 8788,   10120,  4, }, // Europe/Guernsey
    {   13, 6612,   10124,  5, }, // Europe/Helsinki
    {   13, 8804,   10129, 10, }, // Europe/Isle_of_Man
    {   13, 1130,   10139,  6, }, // Europe/Istanbul
    {   13, 8823,   10145,  3, }, // Europe/Jersey
    {   13, 3979,   10148,  7, }, // Europe/Kaliningrad
    {   13, 8929,   10155,  3, }, // Europe/Kirov
    {   13, 2527,   10158,  3, }, // Europe/Kyiv
    {   13, 3213,   10161,  4, }, // Europe/Lisbon
    {   13, 6506,   10165,  6, }, // Europe/Ljubljana
    {   13, 2501,   10171,  4, }, // Europe/London
    {   13, 6365,   10175,  7, }, // Europe/Luxembourg
    {   13, 4892,   10182,  4, }, // Europe/Madrid
    {   13, 6397,   10186,  3, }, // Europe/Malta
    {   13, 6582,   10189,  5, }, // Europe/Mariehamn
    {   13, 3693,   10194,  4, }, // Europe/Minsk
    {   13, 6410,   10198,  3, }, // Europe/Monaco
    {   13, 3537,   10201,  3, }, // Europe/Moscow
    {   13, 6458,   10204,  3, }, // Europe/Oslo
    {   13, 4284,   10207,  3, }, // Europe/Paris
    {   13, 6424,   10210,  5, }, // Europe/Podgorica
    {   13, 6275,   10215,  3, }, // Europe/Prague
    {   13, 8837,   10218,  2, }, // Europe/Riga
    {   13, 6324,   10220,  2, }, // Europe/Rome
    {   13, 4331,   10222,  3, }, // Europe/Samara
    {   13, 6470,   10225,  6, }, // Europe/San_Marino
    {   13, 6245,   10231,  4, }, // Europe/Sarajevo
    {   13, 4451,   10235,  4, }, // Europe/Saratov
    {   13, 8849,   10239,  6, }, // Europe/Simferopol
    {   13, 6383,   10245,  4, }, // Europe/Skopje
    {   13, 6599,   10249,  3, }, // Europe/Sofia
    {   13, 6523,   10252,  6, }, // Europe/Stockholm
    {   13, 8867,   10258,  3, }, // Europe/Tallinn
    {   13, 6202,   10261,  3, }, // Europe/Tirane
    {   13, 8882,   10264,  7, }, // Europe/Ulyanovsk
    {   13, 6352,   10271,  3, }, // Europe/Vaduz
    {   13, 6567,   10274,  4, }, // Europe/Vatican
    {   13, 6231,   10278,  3, }, // Europe/Vienna
    {   13, 8899,   10281,  4, }, // Europe/Vilnius
    {   13, 4727,   10285,  5, }, // Europe/Volgograd
    {   13, 3190,   10290,  4, }, // Europe/Warsaw
    {   13, 6261,   10294,  4, }, // Europe/Zagreb
    {   13, 6540,   10298,  3, }, // Europe/Zurich
    {   13, 5078,   10301,  7, }, // Indian/Antananarivo
    {   13, 6947,   10308,  3, }, // Indian/Chagos
    {   13, 6046,   10311,  2, }, // Indian/Christmas
    {   13, 6063,   10313,  3, }, // Indian/Cocos
    {   13, 5029,   10316,  3, }, // Indian/Comoro
    {   13, 6661,   10319,  5, }, // Indian/Kerguelen
    {   13, 7260,   10324,  2, }, // Indian/Mahe
    {   13, 7050,   10326,  4, }, // Indian/Maldives
    {   13, 4069,   10330,  5, }, // Indian/Mauritius
    {   13, 5098,   10335,  3, }, // Indian/Mayotte
    {   13, 7211,   10338,  5, }, // Indian/Reunion
    {   13, 4422,   10343,  3, }, // Pacific/Apia
    {   13,  932,   10346,  5, }, // Pacific/Auckland
    {   13, 3706,   10351,  6, }, // Pacific/Bougainville
    {   13, 3015,   10357,  3, }, // Pacific/Chatham
    {   13, 3157,   10360,  2, }, // Pacific/Chuuk
    {   13, 2237,   10362,  3, }, // Pacific/Easter
    {   13, 7360,   10365,  3, }, // Pacific/Efate
    {   13, 7327,   10368,  4, }, // Pacific/Fakaofo
    {   13, 3902,   10372,  2, }, // Pacific/Fiji
    {   13, 7343,   10374,  4, }, // Pacific/Funafuti
    {   13, 6678,   10378,  5, }, // Pacific/Galapagos
    {   13, 6696,   10383,  5, }, // Pacific/Gambier
    {   13, 3822,   10388,  7, }, // Pacific/Guadalcanal
    {   13, 6018,   10395,  3, }, // Pacific/Guam
    {   13, 2723,   10398,  4, }, // Pacific/Honolulu
    {   13, 3049,   10402,  6, }, // Pacific/Kanton
    {   13, 3998,   10408,  5, }, // Pacific/Kiritimati
    {   13, 7019,   10413,  3, }, // Pacific/Kosrae
    {   13, 2842,   10416,  5, }, // Pacific/Kwajalein
    {   13, 4877,   10421,  3, }, // Pacific/Majuro
    {   13, 4051,   10424,  6, }, // Pacific/Marquesas
    {   13, 8914,   10430,  4, }, // Pacific/Midway
    {   13, 7084,   10434,  3, }, // Pacific/Nauru
    {   13, 7132,   10437,  2, }, // Pacific/Niue
    {   13, 4168,   10439,  5, }, // Pacific/Norfolk
    {   13, 7098,   10444,  4, }, // Pacific/Noumea
    {   13, 3126,   10448,  5, }, // Pacific/Pago_Pago
    {   13, 7155,   10453,  3, }, // Pacific/Palau
    {   13, 7194,   10456,  6, }, // Pacific/Pitcairn
    {   13, 3096,   10462,  4, }, // Pacific/Pohnpei
    {   13, 4807,   10466,  9, }, // Pacific/Port_Moresby
    {   13, 6076,   10475,  5, }, // Pacific/Rarotonga
    {   13, 6031,   10480,  4, }, // Pacific/Saipan
    {   13, 7312,   10484,  3, }, // Pacific/Tahiti
    {   13, 6712,   10487,  3, }, // Pacific/Tarawa
    {   13, 4583,   10490,  5, }, // Pacific/Tongatapu
    {   13, 7392,   10495,  2, }, // Pacific/Wake
    {   13, 7405,   10497,  3, }, // Pacific/Wallis
    {   14, 6788,   10500,  7, }, // Africa/Abidjan Arabic/Arabic/Egypt
    {   14, 6760,   10507,  4, }, // Africa/Accra
    {   14, 5059,   10511, 10, }, // Africa/Addis_Ababa
    {   14, 7420,   10521,  7, }, // Africa/Algiers
    {   14,   14,   10528,  5, }, // Africa/Asmara
    {   14,   44,   10533,  6, }, // Africa/Bamako
    {   14, 5257,   10539,  6, }, // Africa/Bangui
    {   14, 6746,   10545,  6, }, // Africa/Banjul
    {   14, 7435,   10551,  5, }, // Africa/Bissau
    {   14, 4957,   10556,  8, }, // Africa/Blantyre
    {   14, 5287,   10564,  8, }, // Africa/Brazzaville
    {   14, 4922,   10572,  9, }, // Africa/Bujumbura
    {   14, 2320,   10581,  7, }, // Africa/Cairo
    {   14, 4117,   10588, 13, }, // Africa/Casablanca
    {   14, 7449,   10601,  4, }, // Africa/Ceuta
    {   14, 6773,   10605,  7, }, // Africa/Conakry
    {   14, 6840,   10612,  5, }, // Africa/Dakar
    {   14, 5130,   10617, 10, }, // Africa/Dar_es_Salaam
    {   14, 5043,   10627,  6, }, // Africa/Djibouti
    {   14, 5243,   10633,  5, }, // Africa/Douala
    {   14, 5166,   10638,  6, }, // Africa/El_Aaiun
    {   14, 6853,   10644,  8, }, // Africa/Freetown
    {   14, 4906,   10652,  7, }, // Africa/Gaborone
    {   14, 5015,   10659,  5, }, // Africa/Harare
    {   14, 4479,   10664,  9, }, // Africa/Johannesburg
    {   14, 4499,   10673,  4, }, // Africa/Juba
    {   14, 5151,   10677,  7, }, // Africa/Kampala
    {   14, 4524,   10684,  7, }, // Africa/Khartoum
    {   14, 4973,   10691,  6, }, // Africa/Kigali
    {   14, 5306,   10697,  7, }, // Africa/Kinshasa
    {   14, 4744,   10704,  5, }, // Africa/Lagos
    {   14, 5336,   10709,  7, }, // Africa/Libreville
    {   14, 6869,   10716,  4, }, // Africa/Lome
    {   14, 5211,   10720,  6, }, // Africa/Luanda
    {   14, 4939,   10726,  8, }, // Africa/Lubumbashi
    {   14, 5001,   10734,  6, }, // Africa/Lusaka
    {   14, 5322,   10740,  6, }, // Africa/Malabo
    {   14, 4987,   10746,  6, }, // Africa/Maputo
    {   14, 5197,   10752,  6, }, // Africa/Maseru
    {   14, 5182,   10758,  7, }, // Africa/Mbabane
    {   14, 5113,   10765,  7, }, // Africa/Mogadishu
    {   14, 7034,   10772,  8, }, // Africa/Monrovia
    {   14, 3853,   10780,  6, }, // Africa/Nairobi
    {   14, 5271,   10786,  7, }, // Africa/Ndjamena
    {   14, 5354,   10793,  5, }, // Africa/Niamey
    {   14, 6803,   10798,  7, }, // Africa/Nouakchott
    {   14, 6727,   10805,  8, }, // Africa/Ouagadougou
    {   14, 5225,   10813, 10, }, // Africa/Porto-Novo
    {   14, 4435,   10823,  8, }, // Africa/Sao_Tome
    {   14, 2866,   10831,  6, }, // Africa/Tripoli
    {   14, 6554,   10837,  4, }, // Africa/Tunis
    {   14, 4152,   10841,  7, }, // Africa/Windhoek
    {   14,  132,   10848,  4, }, // America/Adak
    {   14, 3346,   10852,  7, }, // America/Anchorage
    {   14, 5607,   10859,  7, }, // America/Anguilla
    {   14, 5624,   10866,  7, }, // America/Antigua
    {   14, 4554,   10873,  9, }, // America/Araguaina
    {   14,  166,   10882, 11, }, // America/Argentina/Buenos_Aires
    {   14,   91,   10893,  9, }, // America/Argentina/Catamarca
    {   14,  270,   10902,  7, }, // America/Argentina/Cordoba
    {   14,  441,   10909,  4, }, // America/Argentina/Jujuy
    {   14, 7462,   10913,  8, }, // America/Argentina/La_Rioja
    {   14,  565,   10921,  7, }, // America/Argentina/Mendoza
    {   14, 7489,   10928, 11, }, // America/Argentina/Rio_Gallegos
    {   14, 7520,   10939,  5, }, // America/Argentina/Salta
    {   14, 7544,   10944,  8, }, // America/Argentina/San_Juan
    {   14, 5580,   10952,  8, }, // America/Argentina/San_Luis
    {   14, 7571,   10960,  6, }, // America/Argentina/Tucuman
    {   14, 7597,   10966,  4, }, // America/Argentina/Ushuaia
    {   14, 5640,   10970,  5, }, // America/Aruba
    {   14, 4252,   10975,  8, }, // America/Asuncion
    {   14,  237,   10983, 11, }, // America/Atikokan
    {   14, 3679,   10994,  5, }, // America/Bahia
    {   14, 7623,   10999, 14, }, // America/Bahia_Banderas
    {   14, 5654,   11013,  7, }, // America/Barbados
    {   14, 7646,   11020,  3, }, // America/Belem
    {   14, 5407,   11023,  4, }, // America/Belize
    {   14, 7660,   11027, 12, }, // America/Blanc-Sablon
    {   14, 7681,   11039,  9, }, // America/Boa_Vista
    {   14, 4361,   11048,  6, }, // America/Bogota
    {   14, 7699,   11054,  4, }, // America/Boise
    {   14, 7713,   11058, 12, }, // America/Cambridge_Bay
    {   14, 7735,   11070, 11, }, // America/Campo_Grande
    {   14, 3868,   11081,  6, }, // America/Cancun
    {   14, 4694,   11087,  7, }, // America/Caracas
    {   14, 4345,   11094,  5, }, // America/Cayenne
    {   14, 5496,   11099,  6, }, // America/Cayman
    {   14, 2260,   11105,  6, }, // America/Chicago
    {   14, 7756,   11111,  7, }, // America/Chihuahua
    {   14, 7774,   11118, 13, }, // America/Ciudad_Juarez
    {   14, 5422,   11131,  9, }, // America/Costa_Rica
    {   14, 7796,   11140,  7, }, // America/Creston
    {   14, 3791,   11147,  5, }, // America/Cuiaba
    {   14, 5723,   11152,  7, }, // America/Curacao
    {   14, 7812,   11159, 11, }, // America/Danmarkshavn
    {   14, 7833,   11170,  6, }, // America/Dawson
    {   14, 7848,   11176, 10, }, // America/Dawson_Creek
    {   14,  805,   11186,  4, }, // America/Denver
    {   14, 3465,   11190,  7, }, // America/Detroit
    {   14, 5739,   11197,  8, }, // America/Dominica
    {   14,  893,   11205,  9, }, // America/Edmonton
    {   14, 7869,   11214,  7, }, // America/Eirunepe
    {   14, 5441,   11221,  9, }, // America/El_Salvador
    {   14, 7886,   11230, 11, }, // America/Fort_Nelson
    {   14, 7906,   11241,  9, }, // America/Fortaleza
    {   14, 7924,   11250,  8, }, // America/Glace_Bay
    {   14, 6881,   11258,  7, }, // America/Goose_Bay
    {   14, 4612,   11265,  9, }, // America/Grand_Turk
    {   14, 5770,   11274,  7, }, // America/Grenada
    {   14, 5786,   11281,  7, }, // America/Guadeloupe
    {   14, 3760,   11288,  9, }, // America/Guatemala
    {   14, 4841,   11297,  9, }, // America/Guayaquil
    {   14, 6932,   11306,  5, }, // America/Guyana
    {   14, 1939,   11311,  8, }, // America/Halifax
    {   14, 2281,   11319,  6, }, // America/Havana
    {   14, 7942,   11325,  9, }, // America/Hermosillo
    {   14,  348,   11334, 12, }, // America/Indiana/Indianapolis
    {   14,  481,   11346,  5, }, // America/Indiana/Knox
    {   14, 7961,   11351,  6, }, // America/Indiana/Marengo
    {   14, 7985,   11357,  8, }, // America/Indiana/Petersburg
    {   14, 8012,   11365, 17, }, // America/Indiana/Tell_City
    {   14, 8038,   11382,  5, }, // America/Indiana/Vevay
    {   14, 8060,   11387,  7, }, // America/Indiana/Vincennes
    {   14, 8086,   11394,  7, }, // America/Indiana/Winamac
    {   14, 8110,   11401,  7, }, // America/Inuvik
    {   14,  660,   11408,  6, }, // America/Iqaluit
    {   14, 2799,   11414,  7, }, // America/Jamaica
    {   14, 5380,   11421,  4, }, // America/Juneau
    {   14,  521,   11425,  8, }, // America/Kentucky/Louisville
    {   14, 8125,   11433,  9, }, // America/Kentucky/Monticello
    {   14, 5704,   11442,  8, }, // America/Kralendijk
    {   14, 4376,   11450,  6, }, // America/La_Paz
    {   14, 7169,   11456,  4, }, // America/Lima
    {   14, 3239,   11460, 10, }, // America/Los_Angeles
    {   14, 5932,   11470, 16, }, // America/Lower_Princes
    {   14, 8153,   11486,  5, }, // America/Maceio
    {   14, 8168,   11491,  7, }, // America/Managua
    {   14, 1908,   11498,  6, }, // America/Manaus
    {   14, 5897,   11504,  7, }, // America/Marigot
    {   14, 5805,   11511, 10, }, // America/Martinique
    {   14, 8184,   11521,  9, }, // America/Matamoros
    {   14, 2917,   11530,  8, }, // America/Mazatlan
    {   14, 8202,   11538,  8, }, // America/Menominee
    {   14, 8220,   11546,  6, }, // America/Merida
    {   14, 8235,   11552, 10, }, // America/Metlakatla
    {   14, 2949,   11562, 11, }, // America/Mexico_City
    {   14, 4391,   11573,  7, }, // America/Miquelon
    {   14, 8254,   11580,  7, }, // America/Moncton
    {   14, 8270,   11587,  7, }, // America/Monterrey
    {   14, 4098,   11594,  9, }, // America/Montevideo
    {   14, 5824,   11603,  9, }, // America/Montserrat
    {   14, 5481,   11612,  4, }, // America/Nassau
    {   14, 2379,   11616,  7, }, // America/New_York
    {   14, 8288,   11540,  3, }, // America/Nome
    {   14, 1850,   11623,  7, }, // America/Noronha
    {   14, 8301,   11630, 22, }, // America/North_Dakota/Beulah
    {   14, 8329,   11652,  4, }, // America/North_Dakota/Center
    {   14, 8357,   11656,  9, }, // America/North_Dakota/New_Salem
    {   14,  393,   11665,  6, }, // America/Nuuk
    {   14, 8388,   11671,  8, }, // America/Ojinaga
    {   14, 2356,   11679,  4, }, // America/Panama
    {   14, 6173,   11683, 10, }, // America/Paramaribo
    {   14, 2973,   11693,  5, }, // America/Phoenix
    {   14, 3945,   11698, 12, }, // America/Port-au-Prince
    {   14, 5954,   11710, 13, }, // America/Port_of_Spain
    {   14, 8404,   11723, 10, }, // America/Porto_Velho
    {   14, 5843,   11733,  9, }, // America/Puerto_Rico
    {   14, 4030,   11742, 12, }, // America/Punta_Arenas
    {   14, 8424,   11754, 10, }, // America/Rankin_Inlet
    {   14, 8445,   11764,  5, }, // America/Recife
    {   14, 1995,   11769,  6, }, // America/Regina
    {   14, 8460,   11775,  7, }, // America/Resolute
    {   14,  695,   11782,  9, }, // America/Rio_Branco
    {   14, 8477,   11791,  8, }, // America/Santarem
    {   14, 2201,   11799,  8, }, // America/Santiago
    {   14, 6111,   11807, 13, }, // America/Santo_Domingo
    {   14, 1878,   11820,  9, }, // America/Sao_Paulo
    {   14, 6899,   11829, 10, }, // America/Scoresbysund
    {   14, 8494,   11839,  5, }, // America/Sitka
    {   14, 8508,   11844, 14, }, // America/St_Barthelemy
    {   14, 2061,   11858,  9, }, // America/St_Johns
    {   14, 5863,   11867,  9, }, // America/St_Kitts
    {   14, 5880,   11876, 10, }, // America/St_Lucia
    {   14,  855,   11886, 10, }, // America/St_Thomas
    {   14, 5913,   11896, 10, }, // America/St_Vincent
    {   14, 8530,   11906, 10, }, // America/Swift_Current
    {   14, 5461,   11916, 11, }, // America/Tegucigalpa
    {   14, 5756,   11927,  3, }, // America/Thule
    {   14,  313,   11930,  7, }, // America/Tijuana
    {   14,  608,   11937,  7, }, // America/Toronto
    {   14, 5688,   11944,  7, }, // America/Tortola
    {   14, 2093,   11951,  7, }, // America/Vancouver
    {   14, 2144,   11958,  9, }, // America/Whitehorse
    {   14,  734,   11967,  7, }, // America/Winnipeg
    {   14, 8552,   11974,  7, }, // America/Yakutat
    {   14, 6001,   11981,  5, }, // Antarctica/Casey
    {   14, 6094,   11986,  5, }, // Antarctica/Davis
    {   14, 6133,   11991, 16, }, // Antarctica/DumontDUrville
    {   14, 8568,   12007,  7, }, // Antarctica/Macquarie
    {   14, 7066,   12014,  6, }, // Antarctica/Mawson
    {   14, 7113,   12020,  9, }, // Antarctica/McMurdo
    {   14, 8589,   12029,  6, }, // Antarctica/Palmer
    {   14, 7226,   12035,  6, }, // Antarctica/Rothera
    {   14, 7295,   12041,  6, }, // Antarctica/Syowa
    {   14, 8607,   12047,  4, }, // Antarctica/Troll
    {   14, 7374,   12051,  6, }, // Antarctica/Vostok
    {   14, 1429,   12057,  9, }, // Arctic/Longyearbyen
    {   14, 5570,   12066,  3, }, // Asia/Aden
    {   14, 5395,   12069,  6, }, // Asia/Almaty
    {   14, 3968,   12075,  5, }, // Asia/Amman
    {   14, 5511,   12080,  5, }, // Asia/Anadyr
    {   14, 5523,   12085,  5, }, // Asia/Aqtau
    {   14, 5368,   12090,  5, }, // Asia/Aqtobe
    {   14,  964,   12095,  8, }, // Asia/Ashgabat
    {   14, 8624,   12103,  6, }, // Asia/Atyrau
    {   14, 3607,   12109,  5, }, // Asia/Baghdad
    {   14, 5534,   12114,  7, }, // Asia/Bahrain
    {   14, 3653,   11150,  4, }, // Asia/Baku
    {   14, 4466,   12121,  6, }, // Asia/Bangkok
    {   14, 3571,   12127,  7, }, // Asia/Barnaul
    {   14, 4086,   12134,  5, }, // Asia/Beirut
    {   14, 3778,   12139,  5, }, // Asia/Bishkek
    {   14, 5989,   12144,  6, }, // Asia/Brunei
    {   14, 4601,   12150,  5, }, // Asia/Chita
    {   14, 4511,   12155,  7, }, // Asia/Colombo
    {   14, 4540,   12162,  4, }, // Asia/Damascus
    {   14, 1093,   11080,  3, }, // Asia/Dhaka
    {   14, 6192,   12166,  4, }, // Asia/Dili
    {   14, 3596,   12170,  3, }, // Asia/Dubai
    {   14, 6159,   12173,  7, }, // Asia/Dushanbe
    {   14, 8636,   12180,  9, }, // Asia/Famagusta
    {   14, 8651,   12189,  3, }, // Asia/Gaza
    {   14, 4795,   12192, 21, }, // Asia/Hebron
    {   14, 1259,   12213, 16, }, // Asia/Ho_Chi_Minh
    {   14, 2704,   12229,  9, }, // Asia/Hong_Kong
    {   14, 4771,   12238,  4, }, // Asia/Hovd
    {   14, 4184,   12242,  8, }, // Asia/Irkutsk
    {   14, 7006,   12250,  6, }, // Asia/Jakarta
    {   14, 6992,   12256,  9, }, // Asia/Jayapura
    {   14, 1290,   12265,  5, }, // Asia/Jerusalem
    {   14, 3560,   12270,  5, }, // Asia/Kabul
    {   14, 4316,   12275,  9, }, // Asia/Kamchatka
    {   14, 4239,   12284,  6, }, // Asia/Karachi
    {   14, 1185,   12290,  8, }, // Asia/Kathmandu
    {   14, 8661,   12298,  7, }, // Asia/Khandyga
    {   14,  992,   12305,  6, }, // Asia/Kolkata
    {   14, 4197,   12311, 11, }, // Asia/Krasnoyarsk
    {   14, 4859,   12322, 12, }, // Asia/Kuala_Lumpur
    {   14, 5976,   12334,  6, }, // Asia/Kuching
    {   14, 5547,   12340,  6, }, // Asia/Kuwait
    {   14, 1211,   12346,  5, }, // Asia/Macau
    {   14, 4017,   12351,  5, }, // Asia/Magadan
    {   14, 1349,   12356,  6, }, // Asia/Makassar
    {   14, 7182,   12362,  6, }, // Asia/Manila
    {   14, 6920,   12368,  4, }, // Asia/Muscat
    {   14, 2554,   12372,  7, }, // Asia/Nicosia
    {   14, 8675,   12379, 11, }, // Asia/Novokuznetsk
    {   14, 4135,   12390, 10, }, // Asia/Novosibirsk
    {   14, 4229,   12400,  5, }, // Asia/Omsk
    {   14, 7145,   12405,  5, }, // Asia/Oral
    {   14, 6961,   12410,  8, }, // Asia/Phnom_Penh
    {   14, 8693,   12418,  8, }, // Asia/Pontianak
    {   14, 4214,   12426, 10, }, // Asia/Pyongyang
    {   14, 5559,   12436,  3, }, // Asia/Qatar
    {   14, 8708,   12439,  8, }, // Asia/Qostanay
    {   14, 4269,   12447,  9, }, // Asia/Qyzylorda
    {   14, 3584,   12456,  6, }, // Asia/Riyadh
    {   14, 4408,   12462,  6, }, // Asia/Sakhalin
    {   14, 7245,   12468,  6, }, // Asia/Samarkand
    {   14, 3279,   12474,  3, }, // Asia/Seoul
    {   14, 1053,   12477,  6, }, // Asia/Shanghai
    {   14, 3300,   12483,  8, }, // Asia/Singapore
    {   14, 4297,   12491, 12, }, // Asia/Srednekolymsk
    {   14, 3263,   12503,  6, }, // Asia/Taipei
    {   14, 4781,   12509,  5, }, // Asia/Tashkent
    {   14, 3915,   12514,  6, }, // Asia/Tbilisi
    {   14, 2772,   12520,  5, }, // Asia/Tehran
    {   14, 1317,   12525,  5, }, // Asia/Thimphu
    {   14, 2821,   12530,  5, }, // Asia/Tokyo
    {   14, 4572,   12535,  5, }, // Asia/Tomsk
    {   14, 1021,   12540,  9, }, // Asia/Ulaanbaatar
    {   14, 1159,   12549,  6, }, // Asia/Urumqi
    {   14, 8722,   12555,  9, }, // Asia/Ust-Nera
    {   14, 6977,   12564,  8, }, // Asia/Vientiane
    {   14, 4710,   12572, 10, }, // Asia/Vladivostok
    {   14, 4828,   12582,  6, }, // Asia/Yakutsk
    {   14, 1235,   12588,  6, }, // Asia/Yangon
    {   14, 3883,   12594, 10, }, // Asia/Yekaterinburg
    {   14, 3747,   12604,  6, }, // Asia/Yerevan
    {   14, 3663,   12610,  5, }, // Atlantic/Azores
    {   14, 5671,   12615,  6, }, // Atlantic/Bermuda
    {   14, 6628,   12621,  5, }, // Atlantic/Canary
    {   14, 3727,   12626, 12, }, // Atlantic/Cape_Verde
    {   14, 1395,   12638,  4, }, // Atlantic/Faroe
    {   14, 8736,   12642,  6, }, // Atlantic/Madeira
    {   14, 2748,   12648,  8, }, // Atlantic/Reykjavik
    {   14, 7272,   12656, 15, }, // Atlantic/South_Georgia
    {   14, 6821,   12671, 11, }, // Atlantic/St_Helena
    {   14, 6644,   12682,  7, }, // Atlantic/Stanley
    {   14, 1670,   12689,  6, }, // Australia/Adelaide
    {   14, 1635,   12695,  7, }, // Australia/Brisbane
    {   14, 1799,   12702,  9, }, // Australia/Broken_Hill
    {   14, 1583,   12711,  5, }, // Australia/Darwin
    {   14, 3637,   12716,  5, }, // Australia/Eucla
    {   14, 1516,   12721,  6, }, // Australia/Hobart
    {   14, 8753,   12727,  7, }, // Australia/Lindeman
    {   14, 1547,   12734,  8, }, // Australia/Lord_Howe
    {   14, 1727,   12742,  7, }, // Australia/Melbourne
    {   14, 1762,   12749,  4, }, // Australia/Perth
    {   14, 1463,   12753,  5, }, // Australia/Sydney
    {   14, 6441,   12758,  8, }, // Europe/Amsterdam
    {   14, 6216,   12766,  6, }, // Europe/Andorra
    {   14, 3620,   12772,  8, }, // Europe/Astrakhan
    {   14, 2300,   12780,  5, }, // Europe/Athens
    {   14, 6336,   12785,  6, }, // Europe/Belgrade
    {   14, 4757,   12791,  5, }, // Europe/Berlin
    {   14, 6488,   12796, 10, }, // Europe/Bratislava
    {   14, 2167,   12806,  6, }, // Europe/Brussels
    {   14, 3928,   12812,  7, }, // Europe/Bucharest
    {   14, 3806,   12819,  7, }, // Europe/Budapest
    {   14, 8772,   12826,  6, }, // Europe/Busingen
    {   14, 2583,   12832,  8, }, // Europe/Chisinau
    {   14, 6289,   12840,  8, }, // Europe/Copenhagen
    {   14, 2338,   12848,  4, }, // Europe/Dublin
    {   14, 6307,   12852,  8, }, // Europe/Gibraltar
    {   14, 8788,   12860,  6, }, // Europe/Guernsey
    {   14, 6612,   12866,  6, }, // Europe/Helsinki
    {   14, 8804,   12872,  9, }, // Europe/Isle_of_Man
    {   14, 1130,   12881,  7, }, // Europe/Istanbul
    {   14, 8823,   12888,  5, }, // Europe/Jersey
    {   14, 3979,   12893,  9, }, // Europe/Kaliningrad
    {   14, 8929,   12902,  5, }, // Europe/Kirov
    {   14, 2527,   12907,  4, }, // Europe/Kyiv
    {   14, 3213,   12911,  6, }, // Europe/Lisbon
    {   14, 6506,   12917,  9, }, // Europe/Ljubljana
    {   14, 2501,   12926,  4, }, // Europe/London
    {   14, 6365,   12930,  9, }, // Europe/Luxembourg
    {   14, 4892,   12939,  5, }, // Europe/Madrid
    {   14, 6397,   12944,  5, }, // Europe/Malta
    {   14, 6582,   12949,  8, }, // Europe/Mariehamn
    {   14, 3693,   12957,  5, }, // Europe/Minsk
    {   14, 6410,   12962,  6, }, // Europe/Monaco
    {   14, 3537,   12968,  5, }, // Europe/Moscow
    {   14, 6458,   12973,  5, }, // Europe/Oslo
    {   14, 4284,   12978,  5, }, // Europe/Paris
    {   14, 6424,   12983,  9, }, // Europe/Podgorica
    {   14, 6275,   12992,  4, }, // Europe/Prague
    {   14, 8837,   12996,  4, }, // Europe/Riga
    {   14, 6324,   12640,  4, }, // Europe/Rome
    {   14, 4331,   13000,  5, }, // Europe/Samara
    {   14, 6470,   13005, 10, }, // Europe/San_Marino
    {   14, 6245,   13015,  7, }, // Europe/Sarajevo
    {   14, 4451,   13022,  7, }, // Europe/Saratov
    {   14, 8849,   13029,  9, }, // Europe/Simferopol
    {   14, 6383,   13038,  5, }, // Europe/Skopje
    {   14, 6599,   13043,  5, }, // Europe/Sofia
    {   14, 6523,   13048,  8, }, // Europe/Stockholm
    {   14, 8867,   13056,  5, }, // Europe/Tallinn
    {   14, 6202,   13061,  6, }, // Europe/Tirane
    {   14, 8882,   13067, 10, }, // Europe/Ulyanovsk
    {   14, 6352,   13077,  5, }, // Europe/Vaduz
    {   14, 6567,   13082,  9, }, // Europe/Vatican
    {   14, 6231,   13091,  5, }, // Europe/Vienna
    {   14, 8899,   13096,  7, }, // Europe/Vilnius
    {   14, 4727,   13103,  8, }, // Europe/Volgograd
    {   14, 3190,   13111,  5, }, // Europe/Warsaw
    {   14, 6261,   13116,  4, }, // Europe/Zagreb
    {   14, 6540,   13120,  5, }, // Europe/Zurich
    {   14, 5078,   13125, 12, }, // Indian/Antananarivo
    {   14, 6947,   13137,  6, }, // Indian/Chagos
    {   14, 6046,   13143,  7, }, // Indian/Christmas
    {   14, 6063,   13150,  5, }, // Indian/Cocos
    {   14, 5029,   13155,  9, }, // Indian/Comoro
    {   14, 6661,   13164,  9, }, // Indian/Kerguelen
    {   14, 7260,   13173,  4, }, // Indian/Mahe
    {   14, 7050,   13177,  8, }, // Indian/Maldives
    {   14, 4069,   13185,  8, }, // Indian/Mauritius
    {   14, 5098,   13193,  5, }, // Indian/Mayotte
    {   14, 7211,   13198,  7, }, // Indian/Reunion
    {   14, 4422,   13205,  4, }, // Pacific/Apia
    {   14,  932,   13209,  7, }, // Pacific/Auckland
    {   14, 3706,   13216,  8, }, // Pacific/Bougainville
    {   14, 3015,   13224,  6, }, // Pacific/Chatham
    {   14, 3157,   11271,  3, }, // Pacific/Chuuk
    {   14, 2237,   13230,  4, }, // Pacific/Easter
    {   14, 7360,   13234,  5, }, // Pacific/Efate
    {   14, 7327,   13239,  7, }, // Pacific/Fakaofo
    {   14, 3902,   13246,  4, }, // Pacific/Fiji
    {   14, 7343,   13250,  8, }, // Pacific/Funafuti
    {   14, 6678,   13258,  8, }, // Pacific/Galapagos
    {   14, 6696,   13266,  6, }, // Pacific/Gambier
    {   14, 3822,   13272, 11, }, // Pacific/Guadalcanal
    {   14, 6018,   11495,  4, }, // Pacific/Guam
    {   14, 2723,   13283,  8, }, // Pacific/Honolulu
    {   14, 3049,   13291,  8, }, // Pacific/Kanton
    {   14, 3998,   13299, 11, }, // Pacific/Kiritimati
    {   14, 7019,   13310,  5, }, // Pacific/Kosrae
    {   14, 2842,   13315,  8, }, // Pacific/Kwajalein
    {   14, 4877,   13323,  6, }, // Pacific/Majuro
    {   14, 4051,   13329,  8, }, // Pacific/Marquesas
    {   14, 8914,   13337,  6, }, // Pacific/Midway
    {   14, 7084,   13343,  5, }, // Pacific/Nauru
    {   14, 7132,   11616,  4, }, // Pacific/Niue
    {   14, 4168,   13348,  7, }, // Pacific/Norfolk
    {   14, 7098,   13355,  5, }, // Pacific/Noumea
    {   14, 3126,   13360,  9, }, // Pacific/Pago_Pago
    {   14, 7155,   13369,  5, }, // Pacific/Palau
    {   14, 7194,   13374,  7, }, // Pacific/Pitcairn
    {   14, 3096,   13381,  5, }, // Pacific/Pohnpei
    {   14, 4807,   13386, 10, }, // Pacific/Port_Moresby
    {   14, 6076,   13396,  9, }, // Pacific/Rarotonga
    {   14, 6031,   13405,  6, }, // Pacific/Saipan
    {   14, 7312,   13411,  6, }, // Pacific/Tahiti
    {   14, 6712,   13417,  6, }, // Pacific/Tarawa
    {   14, 4583,   13423,  9, }, // Pacific/Tongatapu
    {   14, 7392,   10799,  3, }, // Pacific/Wake
    {   14, 7405,   13432,  5, }, // Pacific/Wallis
    {   42,   14,       0,  6, }, // Africa/Asmara Aragonese/Latin/Spain
    {   42, 4435,       6,  8, }, // Africa/Sao_Tome
    {   42, 4252,      14,  8, }, // America/Asuncion
    {   42,  237,      22,  8, }, // America/Atikokan
    {   42, 7623,      30, 17, }, // America/Bahia_Banderas
    {   42, 3868,      47,  6, }, // America/Cancun
    {   42, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   42, 5723,      66,  7, }, // America/Curacao
    {   42,  481,      73, 13, }, // America/Indiana/Knox
    {   42, 7961,      86, 16, }, // America/Indiana/Marengo
    {   42, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   42, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   42, 8038,     139, 14, }, // America/Indiana/Vevay
    {   42, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   42, 8086,     171, 16, }, // America/Indiana/Winamac
    {   42, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   42, 5932,     207, 22, }, // America/Lower_Princes
    {   42, 8220,     229,  6, }, // America/Merida
    {   42, 1850,     235, 19, }, // America/Noronha
    {   42, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   42, 8329,     274, 20, }, // America/North_Dakota/Center
    {   42, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   42,  393,     317,  4, }, // America/Nuuk
    {   42, 6899,     321, 16, }, // America/Scoresbysund
    {   42, 8508,     337, 14, }, // America/St_Barthelemy
    {   42, 2061,     351, 10, }, // America/St_Johns
    {   42, 5863,     361,  9, }, // America/St_Kitts
    {   42, 5880,     370,  9, }, // America/St_Lucia
    {   42,  855,     379, 10, }, // America/St_Thomas
    {   42, 5913,     389, 11, }, // America/St_Vincent
    {   42, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   42, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   42, 1185,     448,  9, }, // Asia/Kathmandu
    {   42,  992,     457,  7, }, // Asia/Kolkata
    {   42, 1211,    4321,  5, }, // Asia/Macau
    {   42, 1235,     477,  6, }, // Asia/Yangon
    {   42, 1395,     483,  5, }, // Atlantic/Faroe
    {   42, 6821,     488, 10, }, // Atlantic/St_Helena
    {   42, 2527,     514,  4, }, // Europe/Kyiv
    {   42, 7211,     547,  7, }, // Indian/Reunion
    {   42, 3157,     554,  5, }, // Pacific/Chuuk
    {   42, 3096,     586,  7, }, // Pacific/Pohnpei
    {   43, 6788,   13437,  6, }, // Africa/Abidjan Armenian/Armenian/Armenia
    {   43, 6760,   13443,  4, }, // Africa/Accra
    {   43, 5059,   13447, 10, }, // Africa/Addis_Ababa
    {   43, 7420,   13457,  5, }, // Africa/Algiers
    {   43,   14,   13462,  6, }, // Africa/Asmara
    {   43,   44,   13468,  6, }, // Africa/Bamako
    {   43, 5257,   13474,  5, }, // Africa/Bangui
    {   43, 6746,   13479,  7, }, // Africa/Banjul
    {   43, 7435,   13486,  6, }, // Africa/Bissau
    {   43, 4957,   13492,  8, }, // Africa/Blantyre
    {   43, 5287,   13500,  8, }, // Africa/Brazzaville
    {   43, 4922,   13508, 12, }, // Africa/Bujumbura
    {   43, 2320,   13520,  6, }, // Africa/Cairo
    {   43, 4117,   13526, 10, }, // Africa/Casablanca
    {   43, 7449,   13536,  6, }, // Africa/Ceuta
    {   43, 6773,   13542,  7, }, // Africa/Conakry
    {   43, 6840,   13549,  5, }, // Africa/Dakar
    {   43, 5130,   13554, 12, }, // Africa/Dar_es_Salaam
    {   43, 5043,   13566,  7, }, // Africa/Djibouti
    {   43, 5243,   13573,  6, }, // Africa/Douala
    {   43, 5166,   13579,  8, }, // Africa/El_Aaiun
    {   43, 6853,   13587,  8, }, // Africa/Freetown
    {   43, 4906,   13595,  8, }, // Africa/Gaborone
    {   43, 5015,   13603,  6, }, // Africa/Harare
    {   43, 4479,   13609, 12, }, // Africa/Johannesburg
    {   43, 4499,   13621,  5, }, // Africa/Juba
    {   43, 5151,   13626,  7, }, // Africa/Kampala
    {   43, 4524,   13633,  7, }, // Africa/Khartoum
    {   43, 4973,   13640,  6, }, // Africa/Kigali
    {   43, 5306,   13646,  7, }, // Africa/Kinshasa
    {   43, 4744,   13653,  5, }, // Africa/Lagos
    {   43, 5336,   13658,  7, }, // Africa/Libreville
    {   43, 6869,   13665,  4, }, // Africa/Lome
    {   43, 5211,   13669,  7, }, // Africa/Luanda
    {   43, 4939,   13676, 11, }, // Africa/Lubumbashi
    {   43, 5001,   13687,  7, }, // Africa/Lusaka
    {   43, 5322,   13694,  6, }, // Africa/Malabo
    {   43, 4987,   13700,  8, }, // Africa/Maputo
    {   43, 5197,   13708,  7, }, // Africa/Maseru
    {   43, 5182,   13715,  7, }, // Africa/Mbabane
    {   43, 5113,   13722,  8, }, // Africa/Mogadishu
    {   43, 7034,   13730,  8, }, // Africa/Monrovia
    {   43, 3853,   13738,  7, }, // Africa/Nairobi
    {   43, 5271,   13745,  7, }, // Africa/Ndjamena
    {   43, 5354,   13752,  6, }, // Africa/Niamey
    {   43, 6803,   13758,  8, }, // Africa/Nouakchott
    {   43, 6727,   13766, 11, }, // Africa/Ouagadougou
    {   43, 5225,   13777, 10, }, // Africa/Porto-Novo
    {   43, 4435,   13787,  8, }, // Africa/Sao_Tome
    {   43, 2866,   13795,  7, }, // Africa/Tripoli
    {   43, 6554,   13802,  6, }, // Africa/Tunis
    {   43, 4152,   13808,  8, }, // Africa/Windhoek
    {   43,  132,   13816,  9, }, // America/Adak
    {   43, 3346,   13825,  7, }, // America/Anchorage
    {   43, 5607,   13832,  8, }, // America/Anguilla
    {   43, 5624,   13840,  8, }, // America/Antigua
    {   43, 4554,   13848, 10, }, // America/Araguaina
    {   43,  166,   13858, 13, }, // America/Argentina/Buenos_Aires
    {   43,   91,   13871,  9, }, // America/Argentina/Catamarca
    {   43,  270,   13880,  7, }, // America/Argentina/Cordoba
    {   43,  441,   13887,  7, }, // America/Argentina/Jujuy
    {   43, 7462,   13894,  8, }, // America/Argentina/La_Rioja
    {   43,  565,   13902,  7, }, // America/Argentina/Mendoza
    {   43, 7489,   13909, 12, }, // America/Argentina/Rio_Gallegos
    {   43, 7520,   13921,  5, }, // America/Argentina/Salta
    {   43, 7544,   13926,  9, }, // America/Argentina/San_Juan
    {   43, 5580,   13935,  9, }, // America/Argentina/San_Luis
    {   43, 7571,   13944,  9, }, // America/Argentina/Tucuman
    {   43, 7597,   13953,  8, }, // America/Argentina/Ushuaia
    {   43, 5640,   13961,  6, }, // America/Aruba
    {   43, 4252,   13967,  9, }, // America/Asuncion
    {   43,  237,   13976,  8, }, // America/Atikokan
    {   43, 3679,   13984,  5, }, // America/Bahia
    {   43, 7623,   13989, 14, }, // America/Bahia_Banderas
    {   43, 5654,   14003,  8, }, // America/Barbados
    {   43, 7646,   14011,  5, }, // America/Belem
    {   43, 5407,   14016,  5, }, // America/Belize
    {   43, 7660,   14021, 12, }, // America/Blanc-Sablon
    {   43, 7681,   14033,  9, }, // America/Boa_Vista
    {   43, 4361,   14042,  6, }, // America/Bogota
    {   43, 7699,   14048,  5, }, // America/Boise
    {   43, 7713,   14053, 11, }, // America/Cambridge_Bay
    {   43, 7735,   14064, 13, }, // America/Campo_Grande
    {   43, 3868,   14077,  7, }, // America/Cancun
    {   43, 4694,   14084,  7, }, // America/Caracas
    {   43, 4345,   14091,  5, }, // America/Cayenne
    {   43, 5496,   14096, 14, }, // America/Cayman
    {   43, 2260,   14110,  6, }, // America/Chicago
    {   43, 7756,   14116,  8, }, // America/Chihuahua
    {   43, 7774,   14124, 15, }, // America/Ciudad_Juarez
    {   43, 5422,   14139, 10, }, // America/Costa_Rica
    {   43, 7796,   14149,  7, }, // America/Creston
    {   43, 3791,   14156,  7, }, // America/Cuiaba
    {   43, 5723,   14163,  9, }, // America/Curacao
    {   43, 7812,   14172, 12, }, // America/Danmarkshavn
    {   43, 7833,   14184,  7, }, // America/Dawson
    {   43, 7848,   14191, 12, }, // America/Dawson_Creek
    {   43,  805,   14203,  6, }, // America/Denver
    {   43, 3465,   14209,  7, }, // America/Detroit
    {   43, 5739,   14216,  8, }, // America/Dominica
    {   43,  893,   14224,  8, }, // America/Edmonton
    {   43, 7869,   14232,  9, }, // America/Eirunepe
    {   43, 5441,   14241,  8, }, // America/El_Salvador
    {   43, 7886,   14249, 11, }, // America/Fort_Nelson
    {   43, 7906,   14260,  9, }, // America/Fortaleza
    {   43, 7924,   14269,  9, }, // America/Glace_Bay
    {   43, 6881,   14278,  8, }, // America/Goose_Bay
    {   43, 4612,   14286, 11, }, // America/Grand_Turk
    {   43, 5770,   14297,  7, }, // America/Grenada
    {   43, 5786,   14304, 10, }, // America/Guadeloupe
    {   43, 3760,   14314,  9, }, // America/Guatemala
    {   43, 4841,   14323,  9, }, // America/Guayaquil
    {   43, 6932,   14332,  6, }, // America/Guyana
    {   43, 1939,   14338,  8, }, // America/Halifax
    {   43, 2281,   14346,  6, }, // America/Havana
    {   43, 7942,   14352,  9, }, // America/Hermosillo
    {   43,  348,   14361, 12, }, // America/Indiana/Indianapolis
    {   43,  481,   14373, 13, }, // America/Indiana/Knox
    {   43, 7961,   14386, 16, }, // America/Indiana/Marengo
    {   43, 7985,   14402, 20, }, // America/Indiana/Petersburg
    {   43, 8012,   14422, 17, }, // America/Indiana/Tell_City
    {   43, 8038,   14439, 14, }, // America/Indiana/Vevay
    {   43, 8060,   14453, 16, }, // America/Indiana/Vincennes
    {   43, 8086,   14469, 16, }, // America/Indiana/Winamac
    {   43, 8110,   14485,  7, }, // America/Inuvik
    {   43,  660,   14492,  8, }, // America/Iqaluit
    {   43, 2799,   14500,  7, }, // America/Jamaica
    {   43, 5380,   14507,  5, }, // America/Juneau
    {   43,  521,   14512,  8, }, // America/Kentucky/Louisville
    {   43, 8125,   14520, 19, }, // America/Kentucky/Monticello
    {   43, 5704,   14539, 10, }, // America/Kralendijk
    {   43, 4376,   14549,  6, }, // America/La_Paz
    {   43, 7169,   14555,  4, }, // America/Lima
    {   43, 3239,   14559, 11, }, // America/Los_Angeles
    {   43, 5932,   14570, 22, }, // America/Lower_Princes
    {   43, 8153,   14592,  6, }, // America/Maceio
    {   43, 8168,   14598,  8, }, // America/Managua
    {   43, 1908,   14606,  7, }, // America/Manaus
    {   43, 5897,   14613,  6, }, // America/Marigot
    {   43, 5805,   14619,  9, }, // America/Martinique
    {   43, 8184,   14628,  9, }, // America/Matamoros
    {   43, 2917,   14637,  8, }, // America/Mazatlan
    {   43, 8202,   14645,  8, }, // America/Menominee
    {   43, 8220,   14653,  6, }, // America/Merida
    {   43, 8235,   14659, 10, }, // America/Metlakatla
    {   43, 2949,   14669,  6, }, // America/Mexico_City
    {   43, 4391,   14675,  7, }, // America/Miquelon
    {   43, 8254,   14682,  7, }, // America/Moncton
    {   43, 8270,   14689,  8, }, // America/Monterrey
    {   43, 4098,   14697, 10, }, // America/Montevideo
    {   43, 5824,   14707,  8, }, // America/Montserrat
    {   43, 5481,   14715,  6, }, // America/Nassau
    {   43, 2379,   14721,  9, }, // America/New_York
    {   43, 8288,   14730,  3, }, // America/Nome
    {   43, 1850,   14733,  7, }, // America/Noronha
    {   43, 8301,   14740, 25, }, // America/North_Dakota/Beulah
    {   43, 8329,   14765, 28, }, // America/North_Dakota/Center
    {   43, 8357,   14793, 30, }, // America/North_Dakota/New_Salem
    {   43,  393,   14823,  6, }, // America/Nuuk
    {   43, 8388,   14829,  7, }, // America/Ojinaga
    {   43, 2356,   14836,  6, }, // America/Panama
    {   43, 6173,   14842, 10, }, // America/Paramaribo
    {   43, 2973,   14852,  6, }, // America/Phoenix
    {   43, 3945,   14858, 12, }, // America/Port-au-Prince
    {   43, 5954,   14870, 13, }, // America/Port_of_Spain
    {   43, 8404,   14883, 13, }, // America/Porto_Velho
    {   43, 5843,   14896, 12, }, // America/Puerto_Rico
    {   43, 4030,   14908, 13, }, // America/Punta_Arenas
    {   43, 8424,   14921, 12, }, // America/Rankin_Inlet
    {   43, 8445,   14933,  6, }, // America/Recife
    {   43, 1995,   14939,  7, }, // America/Regina
    {   43, 8460,   14946,  9, }, // America/Resolute
    {   43,  695,   14955, 12, }, // America/Rio_Branco
    {   43, 8477,   14967,  8, }, // America/Santarem
    {   43, 2201,   14975,  8, }, // America/Santiago
    {   43, 6111,   14983, 13, }, // America/Santo_Domingo
    {   43, 1878,   14996, 11, }, // America/Sao_Paulo
    {   43, 6899,   15007, 11, }, // America/Scoresbysund
    {   43, 8494,   15018,  5, }, // America/Sitka
    {   43, 8508,   15023, 12, }, // America/St_Barthelemy
    {   43, 2061,   15035,  9, }, // America/St_Johns
    {   43, 5863,   15044,  9, }, // America/St_Kitts
    {   43, 5880,   15053, 12, }, // America/St_Lucia
    {   43,  855,   15065, 10, }, // America/St_Thomas
    {   43, 5913,   15075, 12, }, // America/St_Vincent
    {   43, 8530,   15087, 12, }, // America/Swift_Current
    {   43, 5461,   15099, 12, }, // America/Tegucigalpa
    {   43, 5756,   15111,  5, }, // America/Thule
    {   43,  313,   15116,  8, }, // America/Tijuana
    {   43,  608,   15124,  7, }, // America/Toronto
    {   43, 5688,   15131,  7, }, // America/Tortola
    {   43, 2093,   15138,  9, }, // America/Vancouver
    {   43, 2144,   15147,  9, }, // America/Whitehorse
    {   43,  734,   15156,  7, }, // America/Winnipeg
    {   43, 8552,   15163,  8, }, // America/Yakutat
    {   43, 6001,   15171,  5, }, // Antarctica/Casey
    {   43, 6094,   15176,  6, }, // Antarctica/Davis
    {   43, 6133,   15182, 17, }, // Antarctica/DumontDUrville
    {   43, 8568,   15199, 14, }, // Antarctica/Macquarie
    {   43, 7066,   15213,  7, }, // Antarctica/Mawson
    {   43, 7113,   15220,  9, }, // Antarctica/McMurdo
    {   43, 8589,   15229,  6, }, // Antarctica/Palmer
    {   43, 7226,   15235,  6, }, // Antarctica/Rothera
    {   43, 7295,   15241,  5, }, // Antarctica/Syowa
    {   43, 8607,   15246,  5, }, // Antarctica/Troll
    {   43, 7374,   15251,  6, }, // Antarctica/Vostok
    {   43, 1429,   15257,  7, }, // Arctic/Longyearbyen
    {   43, 5570,   15264,  4, }, // Asia/Aden
    {   43, 5395,   15268,  6, }, // Asia/Almaty
    {   43, 3968,   15274,  5, }, // Asia/Amman
    {   43, 5511,   15279,  6, }, // Asia/Anadyr
    {   43, 5523,   15285,  6, }, // Asia/Aqtau
    {   43, 5368,   15291,  6, }, // Asia/Aqtobe
    {   43,  964,   15297,  7, }, // Asia/Ashgabat
    {   43, 8624,   15304,  7, }, // Asia/Atyrau
    {   43, 3607,   15311,  6, }, // Asia/Baghdad
    {   43, 5534,   15317,  7, }, // Asia/Bahrain
    {   43, 3653,   15324,  5, }, // Asia/Baku
    {   43, 4466,   15329,  7, }, // Asia/Bangkok
    {   43, 3571,   15336,  8, }, // Asia/Barnaul
    {   43, 4086,   15344,  7, }, // Asia/Beirut
    {   43, 3778,   15351,  6, }, // Asia/Bishkek
    {   43, 5989,   15357,  7, }, // Asia/Brunei
    {   43, 4601,   15364,  4, }, // Asia/Chita
    {   43, 4511,   15368,  7, }, // Asia/Colombo
    {   43, 4540,   15375,  8, }, // Asia/Damascus
    {   43, 1093,   15383,  5, }, // Asia/Dhaka
    {   43, 6192,   15388,  4, }, // Asia/Dili
    {   43, 3596,   15392,  6, }, // Asia/Dubai
    {   43, 6159,   15398,  8, }, // Asia/Dushanbe
    {   43, 8636,   15406, 10, }, // Asia/Famagusta
    {   43, 8651,   15416,  4, }, // Asia/Gaza
    {   43, 4795,   15420,  6, }, // Asia/Hebron
    {   43, 1259,   15426,  7, }, // Asia/Ho_Chi_Minh
    {   43, 2704,   15433,  7, }, // Asia/Hong_Kong
    {   43, 4771,   15440,  4, }, // Asia/Hovd
    {   43, 4184,   15444,  8, }, // Asia/Irkutsk
    {   43, 7006,   15452,  7, }, // Asia/Jakarta
    {   43, 6992,   15459,  8, }, // Asia/Jayapura
    {   43, 1290,   15467,  9, }, // Asia/Jerusalem
    {   43, 3560,   15476,  6, }, // Asia/Kabul
    {   43, 4316,   15482,  8, }, // Asia/Kamchatka
    {   43, 4239,   15490,  6, }, // Asia/Karachi
    {   43, 1185,   15496,  9, }, // Asia/Kathmandu
    {   43, 8661,   15505,  7, }, // Asia/Khandyga
    {   43,  992,   15512,  8, }, // Asia/Kolkata
    {   43, 4197,   15520, 11, }, // Asia/Krasnoyarsk
    {   43, 4859,   15531, 15, }, // Asia/Kuala_Lumpur
    {   43, 5976,   15546,  7, }, // Asia/Kuching
    {   43, 5547,   15553,  7, }, // Asia/Kuwait
    {   43, 1211,   15560,  5, }, // Asia/Macau
    {   43, 4017,   15565,  7, }, // Asia/Magadan
    {   43, 1349,   15572,  7, }, // Asia/Makassar
    {   43, 7182,   15579,  6, }, // Asia/Manila
    {   43, 6920,   15585,  6, }, // Asia/Muscat
    {   43, 2554,   15591,  7, }, // Asia/Nicosia
    {   43, 8675,   15598, 12, }, // Asia/Novokuznetsk
    {   43, 4135,   15610, 11, }, // Asia/Novosibirsk
    {   43, 4229,   15621,  4, }, // Asia/Omsk
    {   43, 7145,   15625,  7, }, // Asia/Oral
    {   43, 6961,   15632,  7, }, // Asia/Phnom_Penh
    {   43, 8693,   15639,  9, }, // Asia/Pontianak
    {   43, 4214,   15648,  7, }, // Asia/Pyongyang
    {   43, 5559,   15655,  5, }, // Asia/Qatar
    {   43, 8708,   15660,  8, }, // Asia/Qostanay
    {   43, 4269,   15668,  9, }, // Asia/Qyzylorda
    {   43, 3584,   15677,  7, }, // Asia/Riyadh
    {   43, 4408,   15684,  7, }, // Asia/Sakhalin
    {   43, 7245,   15691,  9, }, // Asia/Samarkand
    {   43, 3279,   15700,  5, }, // Asia/Seoul
    {   43, 1053,   15705,  6, }, // Asia/Shanghai
    {   43, 3300,   15711,  9, }, // Asia/Singapore
    {   43, 4297,   15720, 13, }, // Asia/Srednekolymsk
    {   43, 3263,   15733,  6, }, // Asia/Taipei
    {   43, 4781,   15739,  7, }, // Asia/Tashkent
    {   43, 3915,   15746,  7, }, // Asia/Tbilisi
    {   43, 2772,   15753,  6, }, // Asia/Tehran
    {   43, 1317,   15759,  8, }, // Asia/Thimphu
    {   43, 2821,   15767,  5, }, // Asia/Tokyo
    {   43, 4572,   15772,  5, }, // Asia/Tomsk
    {   43, 1021,   15777, 11, }, // Asia/Ulaanbaatar
    {   43, 1159,   15788,  8, }, // Asia/Urumqi
    {   43, 8722,   15796,  9, }, // Asia/Ust-Nera
    {   43, 6977,   15805,  8, }, // Asia/Vientiane
    {   43, 4710,   15813, 11, }, // Asia/Vladivostok
    {   43, 4828,   15824,  8, }, // Asia/Yakutsk
    {   43, 1235,   15832,  7, }, // Asia/Yangon
    {   43, 3883,   15839, 13, }, // Asia/Yekaterinburg
    {   43, 3747,   15852,  5, }, // Asia/Yerevan
    {   43, 3663,   15857, 15, }, // Atlantic/Azores
    {   43, 5671,   15872, 10, }, // Atlantic/Bermuda
    {   43, 6628,   15882, 16, }, // Atlantic/Canary
    {   43, 3727,   15898, 10, }, // Atlantic/Cape_Verde
    {   43, 1395,   15908, 16, }, // Atlantic/Faroe
    {   43, 8736,   15924,  7, }, // Atlantic/Madeira
    {   43, 2748,   15931,  9, }, // Atlantic/Reykjavik
    {   43, 7272,   15940, 16, }, // Atlantic/South_Georgia
    {   43, 6821,   15956, 18, }, // Atlantic/St_Helena
    {   43, 6644,   15974,  6, }, // Atlantic/Stanley
    {   43, 1670,   15980,  8, }, // Australia/Adelaide
    {   43, 1635,   15988,  7, }, // Australia/Brisbane
    {   43, 1799,   15995, 10, }, // Australia/Broken_Hill
    {   43, 1583,   16005,  6, }, // Australia/Darwin
    {   43, 3637,   16011,  6, }, // Australia/Eucla
    {   43, 1516,   16017,  6, }, // Australia/Hobart
    {   43, 8753,   16023,  8, }, // Australia/Lindeman
    {   43, 1547,   16031, 14, }, // Australia/Lord_Howe
    {   43, 1727,   16045,  8, }, // Australia/Melbourne
    {   43, 1762,   16053,  4, }, // Australia/Perth
    {   43, 1463,   16057,  6, }, // Australia/Sydney
    {   43, 6441,   16063,  9, }, // Europe/Amsterdam
    {   43, 6216,   16072,  7, }, // Europe/Andorra
    {   43, 3620,   16079,  8, }, // Europe/Astrakhan
    {   43, 2300,   16087,  5, }, // Europe/Athens
    {   43, 6336,   16092,  7, }, // Europe/Belgrade
    {   43, 4757,   16099,  6, }, // Europe/Berlin
    {   43, 6488,   16105, 10, }, // Europe/Bratislava
    {   43, 2167,   16115,  8, }, // Europe/Brussels
    {   43, 3928,   16123,  9, }, // Europe/Bucharest
    {   43, 3806,   16132,  9, }, // Europe/Budapest
    {   43, 8772,   16141, 10, }, // Europe/Busingen
    {   43, 2583,   16151,  5, }, // Europe/Chisinau
    {   43, 6289,   16156, 10, }, // Europe/Copenhagen
    {   43, 2338,   16166,  7, }, // Europe/Dublin
    {   43, 6307,   16173,  9, }, // Europe/Gibraltar
    {   43, 8788,   16182,  6, }, // Europe/Guernsey
    {   43, 6612,   16188,  8, }, // Europe/Helsinki
    {   43, 8804,   16196,  8, }, // Europe/Isle_of_Man
    {   43, 1130,   16204,  8, }, // Europe/Istanbul
    {   43, 8823,   16212,  5, }, // Europe/Jersey
    {   43, 3979,   16217, 11, }, // Europe/Kaliningrad
    {   43, 8929,   16228,  5, }, // Europe/Kirov
    {   43, 2527,   16233,  3, }, // Europe/Kyiv
    {   43, 3213,   16236,  7, }, // Europe/Lisbon
    {   43, 6506,   16243, 10, }, // Europe/Ljubljana
    {   43, 2501,   16253,  6, }, // Europe/London
    {   43, 6365,   16259, 13, }, // Europe/Luxembourg
    {   43, 4892,   16272,  6, }, // Europe/Madrid
    {   43, 6397,   16278,  5, }, // Europe/Malta
    {   43, 6582,   16283,  9, }, // Europe/Mariehamn
    {   43, 3693,   16292,  5, }, // Europe/Minsk
    {   43, 6410,   16297,  6, }, // Europe/Monaco
    {   43, 3537,   16303,  6, }, // Europe/Moscow
    {   43, 6458,   16309,  4, }, // Europe/Oslo
    {   43, 4284,   16313,  5, }, // Europe/Paris
    {   43, 6424,   16318,  9, }, // Europe/Podgorica
    {   43, 6275,   16327,  5, }, // Europe/Prague
    {   43, 8837,   16332,  4, }, // Europe/Riga
    {   43, 6324,   16336,  4, }, // Europe/Rome
    {   43, 4331,   16340,  6, }, // Europe/Samara
    {   43, 6470,   16346, 10, }, // Europe/San_Marino
    {   43, 6245,   16356,  6, }, // Europe/Sarajevo
    {   43, 4451,   16362,  7, }, // Europe/Saratov
    {   43, 8849,   16369, 10, }, // Europe/Simferopol
    {   43, 6383,   16379,  6, }, // Europe/Skopje
    {   43, 6599,   16385,  5, }, // Europe/Sofia
    {   43, 6523,   16390,  8, }, // Europe/Stockholm
    {   43, 8867,   16398,  6, }, // Europe/Tallinn
    {   43, 6202,   16404,  6, }, // Europe/Tirane
    {   43, 8882,   16410, 10, }, // Europe/Ulyanovsk
    {   43, 6352,   16420,  6, }, // Europe/Vaduz
    {   43, 6567,   16426,  7, }, // Europe/Vatican
    {   43, 6231,   16433,  6, }, // Europe/Vienna
    {   43, 8899,   16439,  8, }, // Europe/Vilnius
    {   43, 4727,   16447,  9, }, // Europe/Volgograd
    {   43, 3190,   16456,  7, }, // Europe/Warsaw
    {   43, 6261,   16463,  6, }, // Europe/Zagreb
    {   43, 6540,   16469,  7, }, // Europe/Zurich
    {   43, 5078,   16476, 13, }, // Indian/Antananarivo
    {   43, 6947,   16489,  5, }, // Indian/Chagos
    {   43, 6046,   16494, 18, }, // Indian/Christmas
    {   43, 6063,   16512, 16, }, // Indian/Cocos
    {   43, 5029,   16528, 16, }, // Indian/Comoro
    {   43, 6661,   16544,  8, }, // Indian/Kerguelen
    {   43, 7260,   16552,  3, }, // Indian/Mahe
    {   43, 7050,   16555,  9, }, // Indian/Maldives
    {   43, 4069,   16564,  9, }, // Indian/Mauritius
    {   43, 5098,   16573,  5, }, // Indian/Mayotte
    {   43, 7211,   16578,  9, }, // Indian/Reunion
    {   43, 4422,   16587,  4, }, // Pacific/Apia
    {   43,  932,   16591,  6, }, // Pacific/Auckland
    {   43, 3706,   16597,  9, }, // Pacific/Bougainville
    {   43, 3015,   16606, 10, }, // Pacific/Chatham
    {   43, 3157,   16616,  6, }, // Pacific/Chuuk
    {   43, 2237,   16622, 10, }, // Pacific/Easter
    {   43, 7360,   16632,  5, }, // Pacific/Efate
    {   43, 7327,   16637,  7, }, // Pacific/Fakaofo
    {   43, 3902,   16644,  4, }, // Pacific/Fiji
    {   43, 7343,   16648, 10, }, // Pacific/Funafuti
    {   43, 6678,   16658, 20, }, // Pacific/Galapagos
    {   43, 6696,   16678, 14, }, // Pacific/Gambier
    {   43, 3822,   16692, 12, }, // Pacific/Guadalcanal
    {   43, 6018,   16704,  5, }, // Pacific/Guam
    {   43, 2723,   16709, 10, }, // Pacific/Honolulu
    {   43, 3049,   16719, 14, }, // Pacific/Kanton
    {   43, 3998,   16733, 10, }, // Pacific/Kiritimati
    {   43, 7019,   16743,  6, }, // Pacific/Kosrae
    {   43, 2842,   16749,  9, }, // Pacific/Kwajalein
    {   43, 4877,   16758,  7, }, // Pacific/Majuro
    {   43, 4051,   16765, 17, }, // Pacific/Marquesas
    {   43, 8914,   16782, 12, }, // Pacific/Midway
    {   43, 7084,   16794,  7, }, // Pacific/Nauru
    {   43, 7132,   16801,  5, }, // Pacific/Niue
    {   43, 4168,   16806,  7, }, // Pacific/Norfolk
    {   43, 7098,   16813,  6, }, // Pacific/Noumea
    {   43, 3126,   16819,  9, }, // Pacific/Pago_Pago
    {   43, 7155,   16828,  6, }, // Pacific/Palau
    {   43, 7194,   16834,  7, }, // Pacific/Pitcairn
    {   43, 3096,   16841,  6, }, // Pacific/Pohnpei
    {   43, 4807,   16847, 11, }, // Pacific/Port_Moresby
    {   43, 6076,   16858,  9, }, // Pacific/Rarotonga
    {   43, 6031,   16867,  6, }, // Pacific/Saipan
    {   43, 7312,   16873,  5, }, // Pacific/Tahiti
    {   43, 6712,   16878,  6, }, // Pacific/Tarawa
    {   43, 4583,   16884, 10, }, // Pacific/Tongatapu
    {   43, 7392,   16894, 10, }, // Pacific/Wake
    {   43, 7405,   16904,  6, }, // Pacific/Wallis
    {   44, 6788,   16910,  7, }, // Africa/Abidjan Assamese/Bangla/India
    {   44, 6760,   16917,  5, }, // Africa/Accra
    {   44, 5059,   16922, 12, }, // Africa/Addis_Ababa
    {   44, 7420,   16934, 10, }, // Africa/Algiers
    {   44,   14,   16944,  7, }, // Africa/Asmara
    {   44,   44,   16951,  6, }, // Africa/Bamako
    {   44, 5257,   16957,  6, }, // Africa/Bangui
    {   44, 6746,   16963,  7, }, // Africa/Banjul
    {   44, 7435,   16970,  5, }, // Africa/Bissau
    {   44, 4957,   16975, 12, }, // Africa/Blantyre
    {   44, 5287,   16987, 10, }, // Africa/Brazzaville
    {   44, 4922,   16997, 10, }, // Africa/Bujumbura
    {   44, 2320,   17007,  5, }, // Africa/Cairo
    {   44, 4117,   17012, 11, }, // Africa/Casablanca
    {   44, 7449,   17023,  5, }, // Africa/Ceuta
    {   44, 6773,   17028,  8, }, // Africa/Conakry
    {   44, 6840,   17036,  5, }, // Africa/Dakar
    {   44, 5130,   17041, 12, }, // Africa/Dar_es_Salaam
    {   44, 5043,   17053,  6, }, // Africa/Djibouti
    {   44, 5243,   17059,  6, }, // Africa/Douala
    {   44, 5166,   17065,  9, }, // Africa/El_Aaiun
    {   44, 6853,   17074,  8, }, // Africa/Freetown
    {   44, 4906,   17082,  7, }, // Africa/Gaborone
    {   44, 5015,   17089,  6, }, // Africa/Harare
    {   44, 4479,   17095, 12, }, // Africa/Johannesburg
    {   44, 4499,   17107,  4, }, // Africa/Juba
    {   44, 5151,   17111,  8, }, // Africa/Kampala
    {   44, 4524,   17119,  7, }, // Africa/Khartoum
    {   44, 4973,   17126,  6, }, // Africa/Kigali
    {   44, 5306,   17132,  7, }, // Africa/Kinshasa
    {   44, 4744,   17139,  5, }, // Africa/Lagos
    {   44, 5336,   17144, 10, }, // Africa/Libreville
    {   44, 6869,   17154,  3, }, // Africa/Lome
    {   44, 5211,   17157,  8, }, // Africa/Luanda
    {   44, 4939,   17165, 10, }, // Africa/Lubumbashi
    {   44, 5001,   17175,  6, }, // Africa/Lusaka
    {   44, 5322,   17181,  6, }, // Africa/Malabo
    {   44, 4987,   17187,  6, }, // Africa/Maputo
    {   44, 5197,   17193,  6, }, // Africa/Maseru
    {   44, 5182,   17199,  8, }, // Africa/Mbabane
    {   44, 5113,   17207,  8, }, // Africa/Mogadishu
    {   44, 7034,   17215, 10, }, // Africa/Monrovia
    {   44, 3853,   17225,  7, }, // Africa/Nairobi
    {   44, 5271,   17232,  9, }, // Africa/Ndjamena
    {   44, 5354,   17241,  7, }, // Africa/Niamey
    {   44, 6803,   17248,  7, }, // Africa/Nouakchott
    {   44, 6727,   17255,  7, }, // Africa/Ouagadougou
    {   44, 5225,   17262, 11, }, // Africa/Porto-Novo
    {   44, 4435,   17273,  8, }, // Africa/Sao_Tome
    {   44, 2866,   17281,  8, }, // Africa/Tripoli
    {   44, 6554,   17289,  5, }, // Africa/Tunis
    {   44, 4152,   17294,  8, }, // Africa/Windhoek
    {   44,  132,   17302,  4, }, // America/Adak
    {   44, 3346,   17306,  7, }, // America/Anchorage
    {   44, 5607,   17313,  7, }, // America/Anguilla
    {   44, 5624,   17320,  9, }, // America/Antigua
    {   44, 4554,   17329, 10, }, // America/Araguaina
    {   44,  166,   17339, 12, }, // America/Argentina/Buenos_Aires
    {   44,   91,   17351, 10, }, // America/Argentina/Catamarca
    {   44,  270,   17361,  8, }, // America/Argentina/Cordoba
    {   44,  441,   17369,  5, }, // America/Argentina/Jujuy
    {   44, 7462,   17374,  8, }, // America/Argentina/La_Rioja
    {   44,  565,   17382,  8, }, // America/Argentina/Mendoza
    {   44, 7489,   17390, 12, }, // America/Argentina/Rio_Gallegos
    {   44, 7520,   17402,  6, }, // America/Argentina/Salta
    {   44, 7544,   17408,  9, }, // America/Argentina/San_Juan
    {   44, 5580,   17417,  8, }, // America/Argentina/San_Luis
    {   44, 7571,   17425,  6, }, // America/Argentina/Tucuman
    {   44, 7597,   17431,  8, }, // America/Argentina/Ushuaia
    {   44, 5640,   17439,  5, }, // America/Aruba
    {   44, 4252,   17444,  9, }, // America/Asuncion
    {   44,  237,   17453,  8, }, // America/Atikokan
    {   44, 3679,   17461,  7, }, // America/Bahia
    {   44, 7623,   17468, 17, }, // America/Bahia_Banderas
    {   44, 5654,   17485,  9, }, // America/Barbados
    {   44, 7646,   17494,  5, }, // America/Belem
    {   44, 5407,   17499,  5, }, // America/Belize
    {   44, 7660,   17504, 13, }, // America/Blanc-Sablon
    {   44, 7681,   17517, 11, }, // America/Boa_Vista
    {   44, 4361,   17528,  6, }, // America/Bogota
    {   44, 7699,   17534,  5, }, // America/Boise
    {   44, 7713,   17539, 15, }, // America/Cambridge_Bay
    {   44, 7735,   17554, 15, }, // America/Campo_Grande
    {   44, 3868,   17569,  6, }, // America/Cancun
    {   44, 4694,   17575,  7, }, // America/Caracas
    {   44, 4345,   17582,  6, }, // America/Cayenne
    {   44, 5496,   17588,  6, }, // America/Cayman
    {   44, 2260,   17594,  6, }, // America/Chicago
    {   44, 7756,   17600,  9, }, // America/Chihuahua
    {   44, 7774,   17609, 12, }, // America/Ciudad_Juarez
    {   44, 5422,   17621, 11, }, // America/Costa_Rica
    {   44, 7796,   17632,  8, }, // America/Creston
    {   44, 3791,   17640,  6, }, // America/Cuiaba
    {   44, 5723,   17646,  7, }, // America/Curacao
    {   44, 7812,   17653, 12, }, // America/Danmarkshavn
    {   44, 7833,   17665,  5, }, // America/Dawson
    {   44, 7848,   17670, 11, }, // America/Dawson_Creek
    {   44,  805,   17681,  6, }, // America/Denver
    {   44, 3465,   17687,  8, }, // America/Detroit
    {   44, 5739,   17695,  7, }, // America/Dominica
    {   44,  893,   17702,  7, }, // America/Edmonton
    {   44, 7869,   17709,  7, }, // America/Eirunepe
    {   44, 5441,   17716, 11, }, // America/El_Salvador
    {   44, 7886,   17727, 11, }, // America/Fort_Nelson
    {   44, 7906,   17738, 10, }, // America/Fortaleza
    {   44, 7924,   17748, 12, }, // America/Glace_Bay
    {   44, 6881,   17760, 10, }, // America/Goose_Bay
    {   44, 4612,   17770, 13, }, // America/Grand_Turk
    {   44, 5770,   17783,  8, }, // America/Grenada
    {   44, 5786,   17791,  9, }, // America/Guadeloupe
    {   44, 3760,   17800, 10, }, // America/Guatemala
    {   44, 4841,   17810,  9, }, // America/Guayaquil
    {   44, 6932,   17819,  7, }, // America/Guyana
    {   44, 1939,   17826,  9, }, // America/Halifax
    {   44, 2281,   17835,  6, }, // America/Havana
    {   44, 7942,   17841, 12, }, // America/Hermosillo
    {   44,  348,   17853, 15, }, // America/Indiana/Indianapolis
    {   44,  481,   17868, 16, }, // America/Indiana/Knox
    {   44, 7961,   17884, 19, }, // America/Indiana/Marengo
    {   44, 7985,   17903, 24, }, // America/Indiana/Petersburg
    {   44, 8012,   17927, 20, }, // America/Indiana/Tell_City
    {   44, 8038,   17947, 16, }, // America/Indiana/Vevay
    {   44, 8060,   17963, 20, }, // America/Indiana/Vincennes
    {   44, 8086,   17983, 19, }, // America/Indiana/Winamac
    {   44, 8110,   18002,  6, }, // America/Inuvik
    {   44,  660,   18008,  7, }, // America/Iqaluit
    {   44, 2799,   18015,  7, }, // America/Jamaica
    {   44, 5380,   18022,  5, }, // America/Juneau
    {   44,  521,   18027,  8, }, // America/Kentucky/Louisville
    {   44, 8125,   18035, 19, }, // America/Kentucky/Monticello
    {   44, 5704,   18054, 13, }, // America/Kralendijk
    {   44, 4376,   18067,  6, }, // America/La_Paz
    {   44, 7169,   18073,  4, }, // America/Lima
    {   44, 3239,   18077, 11, }, // America/Los_Angeles
    {   44, 5932,   18088, 25, }, // America/Lower_Princes
    {   44, 8153,   18113,  5, }, // America/Maceio
    {   44, 8168,   18118,  8, }, // America/Managua
    {   44, 1908,   18126,  5, }, // America/Manaus
    {   44, 5897,   18131,  7, }, // America/Marigot
    {   44, 5805,   18138,  9, }, // America/Martinique
    {   44, 8184,   18147,  9, }, // America/Matamoros
    {   44, 2917,   18156, 10, }, // America/Mazatlan
    {   44, 8202,   18166,  8, }, // America/Menominee
    {   44, 8220,   18174,  6, }, // America/Merida
    {   44, 8235,   18180, 12, }, // America/Metlakatla
    {   44, 2949,   18192, 13, }, // America/Mexico_City
    {   44, 4391,   18205,  9, }, // America/Miquelon
    {   44, 8254,   18214,  7, }, // America/Moncton
    {   44, 8270,   18221,  9, }, // America/Monterrey
    {   44, 4098,   18230, 11, }, // America/Montevideo
    {   44, 5824,   18241,  9, }, // America/Montserrat
    {   44, 5481,   18250,  5, }, // America/Nassau
    {   44, 2379,   18255, 10, }, // America/New_York
    {   44, 8288,   18168,  3, }, // America/Nome
    {   44, 1850,   18265,  9, }, // America/Noronha
    {   44, 8301,   18274, 20, }, // America/North_Dakota/Beulah
    {   44, 8329,   18294, 21, }, // America/North_Dakota/Center
    {   44, 8357,   18315, 23, }, // America/North_Dakota/New_Salem
    {   44,  393,   18338,  3, }, // America/Nuuk
    {   44, 8388,   18341,  8, }, // America/Ojinaga
    {   44, 2356,   18349,  6, }, // America/Panama
    {   44, 6173,   18355, 10, }, // America/Paramaribo
    {   44, 2973,   18365,  7, }, // America/Phoenix
    {   44, 3945,   18372, 15, }, // America/Port-au-Prince
    {   44, 5954,   18387, 15, }, // America/Port_of_Spain
    {   44, 8404,   18402, 14, }, // America/Porto_Velho
    {   44, 5843,   18416, 13, }, // America/Puerto_Rico
    {   44, 4030,   18429, 13, }, // America/Punta_Arenas
    {   44, 8424,   18442, 12, }, // America/Rankin_Inlet
    {   44, 8445,   18454,  6, }, // America/Recife
    {   44, 1995,   18460,  6, }, // America/Regina
    {   44, 8460,   18466,  8, }, // America/Resolute
    {   44,  695,   18474, 12, }, // America/Rio_Branco
    {   44, 8477,   18486,  9, }, // America/Santarem
    {   44, 2201,   18495, 11, }, // America/Santiago
    {   44, 6111,   18506, 14, }, // America/Santo_Domingo
    {   44, 1878,   18520,  9, }, // America/Sao_Paulo
    {   44, 6899,   18529, 13, }, // America/Scoresbysund
    {   44, 8494,   18542,  8, }, // America/Sitka
    {   44, 8508,   18550, 16, }, // America/St_Barthelemy
    {   44, 2061,   18566, 11, }, // America/St_Johns
    {   44, 5863,   18577, 11, }, // America/St_Kitts
    {   44, 5880,   18588, 14, }, // America/St_Lucia
    {   44,  855,   18602, 11, }, // America/St_Thomas
    {   44, 5913,   18613, 15, }, // America/St_Vincent
    {   44, 8530,   18628, 14, }, // America/Swift_Current
    {   44, 5461,   18642, 12, }, // America/Tegucigalpa
    {   44, 5756,   18654,  6, }, // America/Thule
    {   44,  313,   18660,  8, }, // America/Tijuana
    {   44,  608,   18668,  8, }, // America/Toronto
    {   44, 5688,   18676,  8, }, // America/Tortola
    {   44, 2093,   18684,  8, }, // America/Vancouver
    {   44, 2144,   18692, 10, }, // America/Whitehorse
    {   44,  734,   18702,  7, }, // America/Winnipeg
    {   44, 8552,   18709,  8, }, // America/Yakutat
    {   44, 6001,   18717,  4, }, // Antarctica/Casey
    {   44, 6094,   18721,  5, }, // Antarctica/Davis
    {   44, 6133,   18726, 18, }, // Antarctica/DumontDUrville
    {   44, 8568,   18744, 11, }, // Antarctica/Macquarie
    {   44, 7066,   18755,  5, }, // Antarctica/Mawson
    {   44, 7113,   18760,  9, }, // Antarctica/McMurdo
    {   44, 8589,   18769,  4, }, // Antarctica/Palmer
    {   44, 7226,   18773,  6, }, // Antarctica/Rothera
    {   44, 7295,   18779,  6, }, // Antarctica/Syowa
    {   44, 8607,   18785,  5, }, // Antarctica/Troll
    {   44, 7374,   18790,  6, }, // Antarctica/Vostok
    {   44, 1429,   18796, 12, }, // Arctic/Longyearbyen
    {   44, 5570,   18808,  4, }, // Asia/Aden
    {   44, 5395,   18812,  6, }, // Asia/Almaty
    {   44, 3968,   18818,  6, }, // Asia/Amman
    {   44, 5511,   18824,  6, }, // Asia/Anadyr
    {   44, 5523,   18830, 10, }, // Asia/Aqtau
    {   44, 5368,   18840,  7, }, // Asia/Aqtobe
    {   44,  964,   18847, 11, }, // Asia/Ashgabat
    {   44, 8624,   18858,  5, }, // Asia/Atyrau
    {   44, 3607,   18863,  6, }, // Asia/Baghdad
    {   44, 5534,   18869,  7, }, // Asia/Bahrain
    {   44, 3653,   17644,  4, }, // Asia/Baku
    {   44, 4466,   18876,  5, }, // Asia/Bangkok
    {   44, 3571,   18881,  7, }, // Asia/Barnaul
    {   44, 4086,   18888,  6, }, // Asia/Beirut
    {   44, 3778,   18894, 10, }, // Asia/Bishkek
    {   44, 5989,   18904,  7, }, // Asia/Brunei
    {   44, 4601,   18911,  4, }, // Asia/Chita
    {   44, 4511,   18915,  6, }, // Asia/Colombo
    {   44, 4540,   18921,  9, }, // Asia/Damascus
    {   44, 1093,   18930,  4, }, // Asia/Dhaka
    {   44, 6192,   18934,  4, }, // Asia/Dili
    {   44, 3596,   18938,  5, }, // Asia/Dubai
    {   44, 6159,   18943,  7, }, // Asia/Dushanbe
    {   44, 8636,   18950, 10, }, // Asia/Famagusta
    {   44, 8651,   18960,  4, }, // Asia/Gaza
    {   44, 4795,   18964,  7, }, // Asia/Hebron
    {   44, 1259,   18971, 14, }, // Asia/Ho_Chi_Minh
    {   44, 2704,   18985,  5, }, // Asia/Hong_Kong
    {   44, 4771,   18990,  6, }, // Asia/Hovd
    {   44, 4184,   18996, 10, }, // Asia/Irkutsk
    {   44, 7006,   19006,  8, }, // Asia/Jakarta
    {   44, 6992,   19014,  9, }, // Asia/Jayapura
    {   44, 1290,   19023,  9, }, // Asia/Jerusalem
    {   44, 3560,   19032,  5, }, // Asia/Kabul
    {   44, 4316,   19037,  8, }, // Asia/Kamchatka
    {   44, 4239,   19045,  5, }, // Asia/Karachi
    {   44, 1185,   19050,  9, }, // Asia/Kathmandu
    {   44, 8661,   19059,  8, }, // Asia/Khandyga
    {   44,  992,   19067,  6, }, // Asia/Kolkata
    {   44, 4197,   19073, 15, }, // Asia/Krasnoyarsk
    {   44, 4859,   19088, 12, }, // Asia/Kuala_Lumpur
    {   44, 5976,   19100,  5, }, // Asia/Kuching
    {   44, 5547,   19105,  6, }, // Asia/Kuwait
    {   44, 1211,   19111,  5, }, // Asia/Macau
    {   44, 4017,   19116,  7, }, // Asia/Magadan
    {   44, 1349,   19123,  7, }, // Asia/Makassar
    {   44, 7182,   19130,  6, }, // Asia/Manila
    {   44, 6920,   19136,  7, }, // Asia/Muscat
    {   44, 2554,   19143,  9, }, // Asia/Nicosia
    {   44, 8675,   19152, 14, }, // Asia/Novokuznetsk
    {   44, 4135,   19166, 13, }, // Asia/Novosibirsk
    {   44, 4229,   19179,  5, }, // Asia/Omsk
    {   44, 7145,   19184,  5, }, // Asia/Oral
    {   44, 6961,   19189, 10, }, // Asia/Phnom_Penh
    {   44, 8693,   19199, 11, }, // Asia/Pontianak
    {   44, 4214,   19210,  8, }, // Asia/Pyongyang
    {   44, 5559,   19218,  5, }, // Asia/Qatar
    {   44, 8708,   19223,  8, }, // Asia/Qostanay
    {   44, 4269,   19231, 10, }, // Asia/Qyzylorda
    {   44, 3584,   19241,  6, }, // Asia/Riyadh
    {   44, 4408,   19247,  7, }, // Asia/Sakhalin
    {   44, 7245,   19254, 10, }, // Asia/Samarkand
    {   44, 3279,   19264,  4, }, // Asia/Seoul
    {   44, 1053,   19268,  6, }, // Asia/Shanghai
    {   44, 3300,   19274,  8, }, // Asia/Singapore
    {   44, 4297,   19282, 15, }, // Asia/Srednekolymsk
    {   44, 3263,   19297,  6, }, // Asia/Taipei
    {   44, 4781,   19303,  8, }, // Asia/Tashkent
    {   44, 3915,   19311,  7, }, // Asia/Tbilisi
    {   44, 2772,   19318,  6, }, // Asia/Tehran
    {   44, 1317,   19324,  6, }, // Asia/Thimphu
    {   44, 2821,   19330,  5, }, // Asia/Tokyo
    {   44, 4572,   19335,  8, }, // Asia/Tomsk
    {   44, 1021,   19343,  9, }, // Asia/Ulaanbaatar
    {   44, 1159,   19352,  8, }, // Asia/Urumqi
    {   44, 8722,   19360,  9, }, // Asia/Ust-Nera
    {   44, 6977,   19369, 13, }, // Asia/Vientiane
    {   44, 4710,   19382, 12, }, // Asia/Vladivostok
    {   44, 4828,   19394, 10, }, // Asia/Yakutsk
    {   44, 1235,   19404,  6, }, // Asia/Yangon
    {   44, 3883,   19410, 15, }, // Asia/Yekaterinburg
    {   44, 3747,   19425,  8, }, // Asia/Yerevan
    {   44, 3663,   19433,  6, }, // Atlantic/Azores
    {   44, 5671,   19439,  8, }, // Atlantic/Bermuda
    {   44, 6628,   19447,  6, }, // Atlantic/Canary
    {   44, 3727,   19453, 10, }, // Atlantic/Cape_Verde
    {   44, 1395,   19463,  4, }, // Atlantic/Faroe
    {   44, 8736,   19467,  6, }, // Atlantic/Madeira
    {   44, 2748,   19473,  9, }, // Atlantic/Reykjavik
    {   44, 7272,   19482, 15, }, // Atlantic/South_Georgia
    {   44, 6821,   19497, 13, }, // Atlantic/St_Helena
    {   44, 6644,   19510,  9, }, // Atlantic/Stanley
    {   44, 1670,   19519,  7, }, // Australia/Adelaide
    {   44, 1635,   19526,  8, }, // Australia/Brisbane
    {   44, 1799,   19534, 11, }, // Australia/Broken_Hill
    {   44, 1583,   19545,  6, }, // Australia/Darwin
    {   44, 3637,   19551,  6, }, // Australia/Eucla
    {   44, 1516,   19557,  7, }, // Australia/Hobart
    {   44, 8753,   19564,  8, }, // Australia/Lindeman
    {   44, 1547,   19572,  8, }, // Australia/Lord_Howe
    {   44, 1727,   19580,  8, }, // Australia/Melbourne
    {   44, 1762,   19588,  5, }, // Australia/Perth
    {   44, 1463,   19593,  5, }, // Australia/Sydney
    {   44, 6441,   19598, 10, }, // Europe/Amsterdam
    {   44, 6216,   19608,  7, }, // Europe/Andorra
    {   44, 3620,   19615, 10, }, // Europe/Astrakhan
    {   44, 2300,   19625,  6, }, // Europe/Athens
    {   44, 6336,   19631,  8, }, // Europe/Belgrade
    {   44, 4757,   19639,  7, }, // Europe/Berlin
    {   44, 6488,   19646, 11, }, // Europe/Bratislava
    {   44, 2167,   19657,  8, }, // Europe/Brussels
    {   44, 3928,   19665,  9, }, // Europe/Bucharest
    {   44, 3806,   19674,  9, }, // Europe/Budapest
    {   44, 8772,   19683,  8, }, // Europe/Busingen
    {   44, 2583,   19691,  7, }, // Europe/Chisinau
    {   44, 6289,   19698, 10, }, // Europe/Copenhagen
    {   44, 2338,   19708,  6, }, // Europe/Dublin
    {   44, 6307,   19714, 10, }, // Europe/Gibraltar
    {   44, 8788,   19724,  7, }, // Europe/Guernsey
    {   44, 6612,   19731,  8, }, // Europe/Helsinki
    {   44, 8804,   19739, 10, }, // Europe/Isle_of_Man
    {   44, 1130,   19749,  9, }, // Europe/Istanbul
    {   44, 8823,   19758,  6, }, // Europe/Jersey
    {   44, 3979,   19764, 12, }, // Europe/Kaliningrad
    {   44, 8929,   19776,  5, }, // Europe/Kirov
    {   44, 2527,   19781,  3, }, // Europe/Kyiv
    {   44, 3213,   19784,  5, }, // Europe/Lisbon
    {   44, 6506,   19789, 11, }, // Europe/Ljubljana
    {   44, 2501,   19800,  5, }, // Europe/London
    {   44, 6365,   19805, 12, }, // Europe/Luxembourg
    {   44, 4892,   19817,  7, }, // Europe/Madrid
    {   44, 6397,   19824,  6, }, // Europe/Malta
    {   44, 6582,   19830, 10, }, // Europe/Mariehamn
    {   44, 3693,   19840,  6, }, // Europe/Minsk
    {   44, 6410,   19846,  6, }, // Europe/Monaco
    {   44, 3537,   19852,  5, }, // Europe/Moscow
    {   44, 6458,   19857,  5, }, // Europe/Oslo
    {   44, 4284,   19862,  5, }, // Europe/Paris
    {   44, 6424,   19867,  9, }, // Europe/Podgorica
    {   44, 6275,   19876,  5, }, // Europe/Prague
    {   44, 8837,   19881,  4, }, // Europe/Riga
    {   44, 6324,   19465,  3, }, // Europe/Rome
    {   44, 4331,   19885,  6, }, // Europe/Samara
    {   44, 6470,   19891, 10, }, // Europe/San_Marino
    {   44, 6245,   19901,  8, }, // Europe/Sarajevo
    {   44, 4451,   19909,  7, }, // Europe/Saratov
    {   44, 8849,   19916, 11, }, // Europe/Simferopol
    {   44, 6383,   19927,  8, }, // Europe/Skopje
    {   44, 6599,   19935,  7, }, // Europe/Sofia
    {   44, 6523,   19942,  7, }, // Europe/Stockholm
    {   44, 8867,   19949,  5, }, // Europe/Tallinn
    {   44, 6202,   19954,  6, }, // Europe/Tirane
    {   44, 8882,   19960, 13, }, // Europe/Ulyanovsk
    {   44, 6352,   19973,  5, }, // Europe/Vaduz
    {   44, 6567,   19978,  7, }, // Europe/Vatican
    {   44, 6231,   19985,  7, }, // Europe/Vienna
    {   44, 8899,   19992,  9, }, // Europe/Vilnius
    {   44, 4727,   20001, 11, }, // Europe/Volgograd
    {   44, 3190,   20012,  6, }, // Europe/Warsaw
    {   44, 6261,   20018,  7, }, // Europe/Zagreb
    {   44, 6540,   20025,  5, }, // Europe/Zurich
    {   44, 5078,   20030, 13, }, // Indian/Antananarivo
    {   44, 6947,   20043,  5, }, // Indian/Chagos
    {   44, 6046,   20048, 10, }, // Indian/Christmas
    {   44, 6063,   20058,  5, }, // Indian/Cocos
    {   44, 5029,   20063,  6, }, // Indian/Comoro
    {   44, 6661,   20069,  8, }, // Indian/Kerguelen
    {   44, 7260,   20077,  4, }, // Indian/Mahe
    {   44, 7050,   20081,  8, }, // Indian/Maldives
    {   44, 4069,   20089,  6, }, // Indian/Mauritius
    {   44, 5098,   20095,  9, }, // Indian/Mayotte
    {   44, 7211,   20104,  9, }, // Indian/Reunion
    {   44, 4422,   20113,  6, }, // Pacific/Apia
    {   44,  932,   20119,  7, }, // Pacific/Auckland
    {   44, 3706,   20126, 10, }, // Pacific/Bougainville
    {   44, 3015,   20136,  5, }, // Pacific/Chatham
    {   44, 3157,   20141,  5, }, // Pacific/Chuuk
    {   44, 2237,   20146,  6, }, // Pacific/Easter
    {   44, 7360,   20152,  4, }, // Pacific/Efate
    {   44, 7327,   20156,  7, }, // Pacific/Fakaofo
    {   44, 3902,   20163,  4, }, // Pacific/Fiji
    {   44, 7343,   20167,  8, }, // Pacific/Funafuti
    {   44, 6678,   20175,  9, }, // Pacific/Galapagos
    {   44, 6696,   20184, 10, }, // Pacific/Gambier
    {   44, 3822,   20194, 11, }, // Pacific/Guadalcanal
    {   44, 6018,   18122,  5, }, // Pacific/Guam
    {   44, 3049,   20205,  9, }, // Pacific/Kanton
    {   44, 3998,   20214, 10, }, // Pacific/Kiritimati
    {   44, 7019,   20224,  8, }, // Pacific/Kosrae
    {   44, 2842,   20232,  9, }, // Pacific/Kwajalein
    {   44, 4877,   20241,  6, }, // Pacific/Majuro
    {   44, 4051,   20247,  8, }, // Pacific/Marquesas
    {   44, 8914,   20255,  5, }, // Pacific/Midway
    {   44, 7084,   20260,  4, }, // Pacific/Nauru
    {   44, 7132,   20264,  5, }, // Pacific/Niue
    {   44, 4168,   20269,  6, }, // Pacific/Norfolk
    {   44, 7098,   20275,  7, }, // Pacific/Noumea
    {   44, 3126,   20282,  9, }, // Pacific/Pago_Pago
    {   44, 7155,   20291,  5, }, // Pacific/Palau
    {   44, 7194,   20296,  9, }, // Pacific/Pitcairn
    {   44, 3096,   20305,  6, }, // Pacific/Pohnpei
    {   44, 4807,   20311, 15, }, // Pacific/Port_Moresby
    {   44, 6076,   20326, 10, }, // Pacific/Rarotonga
    {   44, 6031,   20336,  6, }, // Pacific/Saipan
    {   44, 7312,   20342,  6, }, // Pacific/Tahiti
    {   44, 6712,   20348,  6, }, // Pacific/Tarawa
    {   44, 4583,   20354,  8, }, // Pacific/Tongatapu
    {   44, 7392,   20362,  3, }, // Pacific/Wake
    {   44, 7405,   20365,  5, }, // Pacific/Wallis
    {   45, 5059,   20370, 10, }, // Africa/Addis_Ababa Asturian/Latin/Spain
    {   45, 7420,   20380,  5, }, // Africa/Algiers
    {   45,   14,       0,  6, }, // Africa/Asmara
    {   45, 2320,   20385,  8, }, // Africa/Cairo
    {   45, 5043,   20393,  6, }, // Africa/Djibouti
    {   45, 4479,   20399, 13, }, // Africa/Johannesburg
    {   45, 4524,   20412,  6, }, // Africa/Khartoum
    {   45, 6869,   20418,  4, }, // Africa/Lome
    {   45, 5113,   20422,  8, }, // Africa/Mogadishu
    {   45, 5271,   20430,  6, }, // Africa/Ndjamena
    {   45, 5354,   20436,  6, }, // Africa/Niamey
    {   45, 6803,   20442,  7, }, // Africa/Nouakchott
    {   45, 6727,   20449,  8, }, // Africa/Ouagadougou
    {   45, 4435,   20457, 10, }, // Africa/Sao_Tome
    {   45, 2866,   20467,  7, }, // Africa/Tripoli
    {   45, 6554,   20474,  5, }, // Africa/Tunis
    {   45, 5607,    4775,  7, }, // America/Anguilla
    {   45,  270,   20479,  7, }, // America/Argentina/Cordoba
    {   45, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {   45, 4252,      14,  8, }, // America/Asuncion
    {   45,  237,      22,  8, }, // America/Atikokan
    {   45, 3679,      30,  5, }, // America/Bahia
    {   45, 7623,   20493, 14, }, // America/Bahia_Banderas
    {   45, 4361,   20507,  6, }, // America/Bogota
    {   45, 3868,      47,  6, }, // America/Cancun
    {   45, 5496,   20513,  6, }, // America/Cayman
    {   45, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   45, 5723,      66,  7, }, // America/Curacao
    {   45, 5770,   20519,  7, }, // America/Grenada
    {   45, 5786,   20526,  9, }, // America/Guadeloupe
    {   45, 2281,   20535,  9, }, // America/Havana
    {   45,  481,      73, 13, }, // America/Indiana/Knox
    {   45, 7961,      86, 16, }, // America/Indiana/Marengo
    {   45, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   45, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   45, 8038,     139, 14, }, // America/Indiana/Vevay
    {   45, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   45, 8086,     171, 16, }, // America/Indiana/Winamac
    {   45, 2799,   20544,  7, }, // America/Jamaica
    {   45, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   45, 5932,     207, 22, }, // America/Lower_Princes
    {   45, 5805,   20551, 12, }, // America/Martinique
    {   45, 8220,     229,  6, }, // America/Merida
    {   45, 2949,   20563, 15, }, // America/Mexico_City
    {   45, 2379,   20578, 10, }, // America/New_York
    {   45, 1850,     235, 19, }, // America/Noronha
    {   45, 8301,   20588, 24, }, // America/North_Dakota/Beulah
    {   45, 8329,   20612, 24, }, // America/North_Dakota/Center
    {   45, 8357,   20636, 29, }, // America/North_Dakota/New_Salem
    {   45,  393,     317,  4, }, // America/Nuuk
    {   45, 2356,   20665,  6, }, // America/Panama
    {   45, 3945,   20671, 15, }, // America/Port-au-Prince
    {   45, 5954,   20686, 13, }, // America/Port_of_Spain
    {   45, 5843,   20699, 11, }, // America/Puerto_Rico
    {   45, 6111,   20710, 13, }, // America/Santo_Domingo
    {   45, 6899,     321, 16, }, // America/Scoresbysund
    {   45, 8508,     337, 14, }, // America/St_Barthelemy
    {   45, 2061,     351, 10, }, // America/St_Johns
    {   45, 5863,     361,  9, }, // America/St_Kitts
    {   45, 5880,     370,  9, }, // America/St_Lucia
    {   45,  855,     379, 10, }, // America/St_Thomas
    {   45, 5913,     389, 11, }, // America/St_Vincent
    {   45, 5688,   20723,  7, }, // America/Tortola
    {   45, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   45, 3968,   20730,  4, }, // Asia/Amman
    {   45, 3607,   20734,  6, }, // Asia/Baghdad
    {   45, 5534,   20740,  7, }, // Asia/Bahrain
    {   45, 3653,   20747,  4, }, // Asia/Baku
    {   45, 5989,   20751,  6, }, // Asia/Brunei
    {   45, 4540,   20757,  7, }, // Asia/Damascus
    {   45, 6159,   20764,  7, }, // Asia/Dushanbe
    {   45, 4795,   20771,  6, }, // Asia/Hebron
    {   45, 1259,   20777, 20, }, // Asia/Ho_Chi_Minh
    {   45, 2704,   20797,  9, }, // Asia/Hong_Kong
    {   45, 7006,   20806,  7, }, // Asia/Jakarta
    {   45, 6992,   20813,  8, }, // Asia/Jayapura
    {   45, 1290,   20821,  9, }, // Asia/Jerusalem
    {   45, 1185,   20830,  8, }, // Asia/Kathmandu
    {   45,  992,   20838,  7, }, // Asia/Kolkata
    {   45, 1211,   20845,  5, }, // Asia/Macau
    {   45, 4017,   20850,  7, }, // Asia/Magadan
    {   45, 6920,   20857,  7, }, // Asia/Muscat
    {   45, 4214,   20864, 10, }, // Asia/Pyongyang
    {   45, 3584,   20874,  5, }, // Asia/Riyadh
    {   45, 4408,   20879,  7, }, // Asia/Sakhalin
    {   45, 7245,   20886, 10, }, // Asia/Samarkand
    {   45, 3279,   20896,  4, }, // Asia/Seoul
    {   45, 3300,   20900,  8, }, // Asia/Singapore
    {   45, 2772,   20908,  6, }, // Asia/Tehran
    {   45, 2821,   20914,  5, }, // Asia/Tokyo
    {   45, 1021,   20919, 10, }, // Asia/Ulaanbaatar
    {   45, 6977,   20929,  8, }, // Asia/Vientiane
    {   45, 1235,   20937,  6, }, // Asia/Yangon
    {   45, 3883,   20943, 14, }, // Asia/Yekaterinburg
    {   45, 3663,   20957, 10, }, // Atlantic/Azores
    {   45, 6628,   20967,  8, }, // Atlantic/Canary
    {   45, 3727,   20975, 10, }, // Atlantic/Cape_Verde
    {   45, 1395,   20985, 12, }, // Atlantic/Faroe
    {   45, 2748,   20997,  9, }, // Atlantic/Reykjavik
    {   45, 7272,   21006, 14, }, // Atlantic/South_Georgia
    {   45, 6821,   21020, 10, }, // Atlantic/St_Helena
    {   45, 1670,   21030,  8, }, // Australia/Adelaide
    {   45, 3620,   21038,  8, }, // Europe/Astrakhan
    {   45, 2300,   21046,  6, }, // Europe/Athens
    {   45, 6336,   21052,  7, }, // Europe/Belgrade
    {   45, 4757,   21059,  6, }, // Europe/Berlin
    {   45, 2167,   21065,  8, }, // Europe/Brussels
    {   45, 3928,   21073,  8, }, // Europe/Bucharest
    {   45, 6289,   21081, 10, }, // Europe/Copenhagen
    {   45, 2338,   21091,  6, }, // Europe/Dublin
    {   45, 6307,   21097,  9, }, // Europe/Gibraltar
    {   45, 6612,   21106,  8, }, // Europe/Helsinki
    {   45, 8804,   21114, 12, }, // Europe/Isle_of_Man
    {   45, 3979,   21126, 11, }, // Europe/Kaliningrad
    {   45, 2527,    8148,  4, }, // Europe/Kyiv
    {   45, 3213,   21137,  6, }, // Europe/Lisbon
    {   45, 6506,   21143,  9, }, // Europe/Ljubljana
    {   45, 2501,   21152,  7, }, // Europe/London
    {   45, 6365,   21159, 10, }, // Europe/Luxembourg
    {   45, 6410,   21169,  6, }, // Europe/Monaco
    {   45, 3537,   21175,  5, }, // Europe/Moscow
    {   45, 4284,   21180,  5, }, // Europe/Paris
    {   45, 6275,   21185,  5, }, // Europe/Prague
    {   45, 6324,    6064,  4, }, // Europe/Rome
    {   45, 6470,   21190,  9, }, // Europe/San_Marino
    {   45, 6599,   21199,  5, }, // Europe/Sofia
    {   45, 6523,   21204,  9, }, // Europe/Stockholm
    {   45, 6202,   21213,  6, }, // Europe/Tirane
    {   45, 6567,   21219, 11, }, // Europe/Vatican
    {   45, 6231,   21230,  5, }, // Europe/Vienna
    {   45, 4727,   21235,  9, }, // Europe/Volgograd
    {   45, 3190,   21244,  8, }, // Europe/Warsaw
    {   45, 4069,   21252,  8, }, // Indian/Mauritius
    {   45, 7211,   21260,  7, }, // Indian/Reunion
    {   45, 3157,     554,  5, }, // Pacific/Chuuk
    {   45, 2237,   21267,  6, }, // Pacific/Easter
    {   45, 3902,   21273,  4, }, // Pacific/Fiji
    {   45, 6678,   21277,  9, }, // Pacific/Galapagos
    {   45, 2723,    4611,  8, }, // Pacific/Honolulu
    {   45, 3049,    4619,  9, }, // Pacific/Kanton
    {   45, 3096,     586,  7, }, // Pacific/Pohnpei
    {   46,   14,       0,  6, }, // Africa/Asmara Asu/Latin/Tanzania
    {   46, 4435,       6,  8, }, // Africa/Sao_Tome
    {   46, 4252,      14,  8, }, // America/Asuncion
    {   46,  237,      22,  8, }, // America/Atikokan
    {   46, 7623,      30, 17, }, // America/Bahia_Banderas
    {   46, 3868,      47,  6, }, // America/Cancun
    {   46, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   46, 5723,      66,  7, }, // America/Curacao
    {   46,  481,      73, 13, }, // America/Indiana/Knox
    {   46, 7961,      86, 16, }, // America/Indiana/Marengo
    {   46, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   46, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   46, 8038,     139, 14, }, // America/Indiana/Vevay
    {   46, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   46, 8086,     171, 16, }, // America/Indiana/Winamac
    {   46, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   46, 5932,     207, 22, }, // America/Lower_Princes
    {   46, 8220,     229,  6, }, // America/Merida
    {   46, 1850,     235, 19, }, // America/Noronha
    {   46, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   46, 8329,     274, 20, }, // America/North_Dakota/Center
    {   46, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   46,  393,     317,  4, }, // America/Nuuk
    {   46, 6899,     321, 16, }, // America/Scoresbysund
    {   46, 8508,     337, 14, }, // America/St_Barthelemy
    {   46, 2061,     351, 10, }, // America/St_Johns
    {   46, 5863,     361,  9, }, // America/St_Kitts
    {   46, 5880,     370,  9, }, // America/St_Lucia
    {   46,  855,     379, 10, }, // America/St_Thomas
    {   46, 5913,     389, 11, }, // America/St_Vincent
    {   46, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   46, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   46, 1185,     448,  9, }, // Asia/Kathmandu
    {   46,  992,     457,  7, }, // Asia/Kolkata
    {   46, 1211,     464,  5, }, // Asia/Macau
    {   46, 1235,     477,  6, }, // Asia/Yangon
    {   46, 1395,     483,  5, }, // Atlantic/Faroe
    {   46, 6821,     488, 10, }, // Atlantic/St_Helena
    {   46, 2527,     514,  4, }, // Europe/Kyiv
    {   46, 7211,     547,  7, }, // Indian/Reunion
    {   46, 3157,     554,  5, }, // Pacific/Chuuk
    {   46, 3096,     586,  7, }, // Pacific/Pohnpei
    {   47,   14,       0,  6, }, // Africa/Asmara Atsam/Latin/Nigeria
    {   47, 4435,       6,  8, }, // Africa/Sao_Tome
    {   47, 4252,      14,  8, }, // America/Asuncion
    {   47,  237,      22,  8, }, // America/Atikokan
    {   47, 7623,      30, 17, }, // America/Bahia_Banderas
    {   47, 3868,      47,  6, }, // America/Cancun
    {   47, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   47, 5723,      66,  7, }, // America/Curacao
    {   47,  481,      73, 13, }, // America/Indiana/Knox
    {   47, 7961,      86, 16, }, // America/Indiana/Marengo
    {   47, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   47, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   47, 8038,     139, 14, }, // America/Indiana/Vevay
    {   47, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   47, 8086,     171, 16, }, // America/Indiana/Winamac
    {   47, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   47, 5932,     207, 22, }, // America/Lower_Princes
    {   47, 8220,     229,  6, }, // America/Merida
    {   47, 1850,     235, 19, }, // America/Noronha
    {   47, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   47, 8329,     274, 20, }, // America/North_Dakota/Center
    {   47, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   47,  393,     317,  4, }, // America/Nuuk
    {   47, 6899,     321, 16, }, // America/Scoresbysund
    {   47, 8508,     337, 14, }, // America/St_Barthelemy
    {   47, 2061,     351, 10, }, // America/St_Johns
    {   47, 5863,     361,  9, }, // America/St_Kitts
    {   47, 5880,     370,  9, }, // America/St_Lucia
    {   47,  855,     379, 10, }, // America/St_Thomas
    {   47, 5913,     389, 11, }, // America/St_Vincent
    {   47, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   47, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   47, 1185,     448,  9, }, // Asia/Kathmandu
    {   47,  992,     457,  7, }, // Asia/Kolkata
    {   47, 1211,     464,  5, }, // Asia/Macau
    {   47, 1235,     477,  6, }, // Asia/Yangon
    {   47, 1395,     483,  5, }, // Atlantic/Faroe
    {   47, 6821,     488, 10, }, // Atlantic/St_Helena
    {   47, 2527,     514,  4, }, // Europe/Kyiv
    {   47, 7211,     547,  7, }, // Indian/Reunion
    {   47, 3157,     554,  5, }, // Pacific/Chuuk
    {   47, 3096,     586,  7, }, // Pacific/Pohnpei
    {   48, 6788,   21286,  6, }, // Africa/Abidjan Azerbaijani/Latin/Azerbaijan
    {   48, 6760,   21292,  5, }, // Africa/Accra
    {   48, 5059,   21297, 11, }, // Africa/Addis_Ababa
    {   48, 7420,   21308,  8, }, // Africa/Algiers
    {   48,   14,   21316,  6, }, // Africa/Asmara
    {   48, 5257,   21322,  6, }, // Africa/Bangui
    {   48, 6746,   21328,  6, }, // Africa/Banjul
    {   48, 4957,    6318,  7, }, // Africa/Blantyre
    {   48, 5287,   21334,  9, }, // Africa/Brazzaville
    {   48, 2320,   21343,  6, }, // Africa/Cairo
    {   48, 4117,    4695, 10, }, // Africa/Casablanca
    {   48, 7449,   21349,  5, }, // Africa/Ceuta
    {   48, 6773,    6367,  7, }, // Africa/Conakry
    {   48, 5130,   21354, 12, }, // Africa/Dar_es_Salaam
    {   48, 5043,   21366,  6, }, // Africa/Djibouti
    {   48, 5243,   21372,  5, }, // Africa/Douala
    {   48, 5166,   21377,  7, }, // Africa/El_Aaiun
    {   48, 6853,    6400,  7, }, // Africa/Freetown
    {   48, 4906,   21384,  7, }, // Africa/Gaborone
    {   48, 4479,   21391, 11, }, // Africa/Johannesburg
    {   48, 4524,   21402,  6, }, // Africa/Khartoum
    {   48, 4973,   21408,  6, }, // Africa/Kigali
    {   48, 5306,   21414,  7, }, // Africa/Kinshasa
    {   48, 4744,   21421,  5, }, // Africa/Lagos
    {   48, 5336,    6429,  8, }, // Africa/Libreville
    {   48, 4939,   21426,  9, }, // Africa/Lubumbashi
    {   48, 5113,   21435,  8, }, // Africa/Mogadishu
    {   48, 5271,   21443,  7, }, // Africa/Ndjamena
    {   48, 6803,   21450,  8, }, // Africa/Nouakchott
    {   48, 6727,   21458,  7, }, // Africa/Ouagadougou
    {   48, 4435,   21465,  7, }, // Africa/Sao_Tome
    {   48, 4152,   21472,  7, }, // Africa/Windhoek
    {   48, 3346,   21479,  7, }, // America/Anchorage
    {   48, 5607,   21486,  7, }, // America/Anguilla
    {   48, 5624,   21493,  7, }, // America/Antigua
    {   48, 4554,   21500,  9, }, // America/Araguaina
    {   48,  166,   21509, 12, }, // America/Argentina/Buenos_Aires
    {   48,   91,    6518,  9, }, // America/Argentina/Catamarca
    {   48,  270,    6527,  7, }, // America/Argentina/Cordoba
    {   48, 7462,   21521,  5, }, // America/Argentina/La_Rioja
    {   48, 7489,   21526, 12, }, // America/Argentina/Rio_Gallegos
    {   48, 7544,   21538,  8, }, // America/Argentina/San_Juan
    {   48, 7571,    4842,  7, }, // America/Argentina/Tucuman
    {   48, 7597,   21546,  6, }, // America/Argentina/Ushuaia
    {   48, 4252,    6592,  8, }, // America/Asuncion
    {   48,  237,      22,  8, }, // America/Atikokan
    {   48, 3679,   21552,  6, }, // America/Bahia
    {   48, 7623,    3943, 14, }, // America/Bahia_Banderas
    {   48, 5407,    6614,  5, }, // America/Belize
    {   48, 7660,    6620, 12, }, // America/Blanc-Sablon
    {   48, 4361,   21558,  6, }, // America/Bogota
    {   48, 7699,   21564,  5, }, // America/Boise
    {   48, 7713,   21569, 15, }, // America/Cambridge_Bay
    {   48, 7735,   21584, 12, }, // America/Campo_Grande
    {   48, 3868,    6682,  6, }, // America/Cancun
    {   48, 4694,    4910,  7, }, // America/Caracas
    {   48, 4345,   21596,  5, }, // America/Cayenne
    {   48, 5496,   21601,  6, }, // America/Cayman
    {   48, 2260,   21607,  6, }, // America/Chicago
    {   48, 7756,   21613,  8, }, // America/Chihuahua
    {   48, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   48, 5422,   21621, 10, }, // America/Costa_Rica
    {   48, 7796,    6736,  7, }, // America/Creston
    {   48, 3791,   21631,  6, }, // America/Cuiaba
    {   48, 5723,    6749,  7, }, // America/Curacao
    {   48, 7812,   21637, 11, }, // America/Danmarkshavn
    {   48, 7833,    6769,  6, }, // America/Dawson
    {   48, 7848,   21648, 11, }, // America/Dawson_Creek
    {   48, 3465,   21659,  7, }, // America/Detroit
    {   48, 5739,   21666,  8, }, // America/Dominica
    {   48,  893,   21674,  9, }, // America/Edmonton
    {   48, 7869,   21683,  7, }, // America/Eirunepe
    {   48, 5441,    6806,  8, }, // America/El_Salvador
    {   48, 7924,   21690, 13, }, // America/Glace_Bay
    {   48, 6881,   21703, 11, }, // America/Goose_Bay
    {   48, 4612,   21714, 10, }, // America/Grand_Turk
    {   48, 5770,   21724,  7, }, // America/Grenada
    {   48, 5786,   21731,  9, }, // America/Guadeloupe
    {   48, 3760,   21740,  9, }, // America/Guatemala
    {   48, 4841,   21749,  8, }, // America/Guayaquil
    {   48, 6932,   21757,  6, }, // America/Guyana
    {   48, 1939,    6905,  8, }, // America/Halifax
    {   48, 7942,   21763,  9, }, // America/Hermosillo
    {   48,  348,   21772, 12, }, // America/Indiana/Indianapolis
    {   48,  481,   21784,  4, }, // America/Indiana/Knox
    {   48, 7961,   21788,  7, }, // America/Indiana/Marengo
    {   48, 7985,   21795, 10, }, // America/Indiana/Petersburg
    {   48, 8012,     121,  4, }, // America/Indiana/Tell_City
    {   48, 8038,   21805,  5, }, // America/Indiana/Vevay
    {   48, 8060,   21810,  6, }, // America/Indiana/Vincennes
    {   48, 8086,   21816,  7, }, // America/Indiana/Winamac
    {   48, 8110,   21823,  6, }, // America/Inuvik
    {   48,  660,   21829,  7, }, // America/Iqaluit
    {   48, 2799,   21836,  7, }, // America/Jamaica
    {   48, 5380,   21843,  4, }, // America/Juneau
    {   48,  521,   21847,  7, }, // America/Kentucky/Louisville
    {   48, 8125,   21854, 10, }, // America/Kentucky/Monticello
    {   48, 5704,   21864,  9, }, // America/Kralendijk
    {   48, 4376,   21873,  6, }, // America/La_Paz
    {   48, 3239,   21879, 11, }, // America/Los_Angeles
    {   48, 5932,   21890, 20, }, // America/Lower_Princes
    {   48, 8153,   21910,  6, }, // America/Maceio
    {   48, 8168,   21916,  7, }, // America/Managua
    {   48, 5897,   21923,  7, }, // America/Marigot
    {   48, 5805,    5260,  8, }, // America/Martinique
    {   48, 2917,   21930,  8, }, // America/Mazatlan
    {   48, 8202,    7118,  8, }, // America/Menominee
    {   48, 8220,    7126,  6, }, // America/Merida
    {   48, 2949,   21938,  6, }, // America/Mexico_City
    {   48, 4391,    7149,  7, }, // America/Miquelon
    {   48, 8254,    7156,  7, }, // America/Moncton
    {   48, 8270,   21944,  8, }, // America/Monterrey
    {   48, 5824,   21952,  8, }, // America/Montserrat
    {   48, 2379,   21960,  8, }, // America/New_York
    {   48, 8288,   21968,  3, }, // America/Nome
    {   48, 1850,   21971,  7, }, // America/Noronha
    {   48, 8301,   21978, 21, }, // America/North_Dakota/Beulah
    {   48, 8329,   21999, 20, }, // America/North_Dakota/Center
    {   48, 8357,   22019,  9, }, // America/North_Dakota/New_Salem
    {   48,  393,     317,  4, }, // America/Nuuk
    {   48, 8388,   22028,  7, }, // America/Ojinaga
    {   48, 2973,    7283,  6, }, // America/Phoenix
    {   48, 3945,    7289, 12, }, // America/Port-au-Prince
    {   48, 5954,   22035, 12, }, // America/Port_of_Spain
    {   48, 8404,   22047, 11, }, // America/Porto_Velho
    {   48, 5843,   22058, 11, }, // America/Puerto_Rico
    {   48, 8424,   22069, 13, }, // America/Rankin_Inlet
    {   48, 8445,   22082,  5, }, // America/Recife
    {   48, 1995,   22087,  6, }, // America/Regina
    {   48, 8460,   22093,  8, }, // America/Resolute
    {   48,  695,    5480, 10, }, // America/Rio_Branco
    {   48, 2201,   22101,  8, }, // America/Santiago
    {   48, 6111,   22109, 13, }, // America/Santo_Domingo
    {   48, 1878,   22122,  9, }, // America/Sao_Paulo
    {   48, 6899,   22131, 12, }, // America/Scoresbysund
    {   48, 8508,   22143, 14, }, // America/St_Barthelemy
    {   48, 2061,   22157,  9, }, // America/St_Johns
    {   48, 5863,   22166,  8, }, // America/St_Kitts
    {   48, 5880,   22174, 10, }, // America/St_Lucia
    {   48,  855,   22184,  9, }, // America/St_Thomas
    {   48, 5913,   22193, 11, }, // America/St_Vincent
    {   48, 8530,   22204, 12, }, // America/Swift_Current
    {   48, 5461,   22216, 11, }, // America/Tegucigalpa
    {   48, 5756,   22227,  3, }, // America/Thule
    {   48,  313,   22230,  7, }, // America/Tijuana
    {   48, 2093,    7493,  8, }, // America/Vancouver
    {   48, 2144,   22237,  8, }, // America/Whitehorse
    {   48,  734,   22245,  8, }, // America/Winnipeg
    {   48, 6001,   22253,  5, }, // Antarctica/Casey
    {   48, 6094,   22258,  6, }, // Antarctica/Davis
    {   48, 6133,   22264, 14, }, // Antarctica/DumontDUrville
    {   48, 8568,   22278,  7, }, // Antarctica/Macquarie
    {   48, 7066,   22285,  6, }, // Antarctica/Mawson
    {   48, 7113,   22291,  9, }, // Antarctica/McMurdo
    {   48, 7295,   22300,  5, }, // Antarctica/Syowa
    {   48, 1429,   22305,  7, }, // Arctic/Longyearbyen
    {   48, 5395,   22312,  6, }, // Asia/Almaty
    {   48, 5511,   22318,  6, }, // Asia/Anadyr
    {   48, 5523,    5609,  5, }, // Asia/Aqtau
    {   48,  964,   22324,  7, }, // Asia/Ashgabat
    {   48, 8624,   22331,  6, }, // Asia/Atyrau
    {   48, 3607,   22337,  6, }, // Asia/Baghdad
    {   48, 5534,   22343,  7, }, // Asia/Bahrain
    {   48, 3653,   22350,  4, }, // Asia/Baku
    {   48, 4466,   22354,  7, }, // Asia/Bangkok
    {   48, 4086,   22361,  6, }, // Asia/Beirut
    {   48, 3778,   22367,  6, }, // Asia/Bishkek
    {   48, 5989,   22373,  6, }, // Asia/Brunei
    {   48, 4601,    7631,  4, }, // Asia/Chita
    {   48, 4511,    5637,  7, }, // Asia/Colombo
    {   48, 4540,   22379,  6, }, // Asia/Damascus
    {   48, 1093,   22385,  5, }, // Asia/Dhaka
    {   48, 3596,   22390,  5, }, // Asia/Dubai
    {   48, 6159,   22395,  7, }, // Asia/Dushanbe
    {   48, 8636,   22402,  9, }, // Asia/Famagusta
    {   48, 8651,   22411,  4, }, // Asia/Gaza
    {   48, 1259,   22415,  9, }, // Asia/Ho_Chi_Minh
    {   48, 2704,   22424,  9, }, // Asia/Hong_Kong
    {   48, 4184,   22433,  7, }, // Asia/Irkutsk
    {   48, 7006,   22440,  7, }, // Asia/Jakarta
    {   48, 6992,   22447,  8, }, // Asia/Jayapura
    {   48, 1290,   22455,  9, }, // Asia/Jerusalem
    {   48, 3560,   22464,  5, }, // Asia/Kabul
    {   48, 4316,   22469,  8, }, // Asia/Kamchatka
    {   48, 4239,    7687,  6, }, // Asia/Karachi
    {   48, 1185,    5711,  8, }, // Asia/Kathmandu
    {   48, 8661,   22477,  7, }, // Asia/Khandyga
    {   48,  992,   22484,  7, }, // Asia/Kolkata
    {   48, 5976,   22491,  6, }, // Asia/Kuching
    {   48, 5547,   22497,  6, }, // Asia/Kuwait
    {   48, 1211,    7731,  5, }, // Asia/Macau
    {   48, 4017,   22503,  7, }, // Asia/Magadan
    {   48, 1349,    7736,  7, }, // Asia/Makassar
    {   48, 6920,    4326,  6, }, // Asia/Muscat
    {   48, 2554,   22510,  8, }, // Asia/Nicosia
    {   48, 6961,   22518,  8, }, // Asia/Phnom_Penh
    {   48, 4214,   22526,  7, }, // Asia/Pyongyang
    {   48, 4269,   22533,  9, }, // Asia/Qyzylorda
    {   48, 3584,   20874,  5, }, // Asia/Riyadh
    {   48, 4408,   22542,  7, }, // Asia/Sakhalin
    {   48, 7245,   22549,  9, }, // Asia/Samarkand
    {   48, 3279,    7798,  4, }, // Asia/Seoul
    {   48, 1053,   22558,  6, }, // Asia/Shanghai
    {   48, 3300,   22564,  8, }, // Asia/Singapore
    {   48, 4297,   22572, 13, }, // Asia/Srednekolymsk
    {   48, 3263,   22585,  6, }, // Asia/Taipei
    {   48, 4781,   22591,  7, }, // Asia/Tashkent
    {   48, 1021,   22598,  9, }, // Asia/Ulaanbaatar
    {   48, 1159,   22607,  6, }, // Asia/Urumqi
    {   48, 6977,   22613,  8, }, // Asia/Vientiane
    {   48, 1235,   22621,  6, }, // Asia/Yangon
    {   48, 3883,   22627, 13, }, // Asia/Yekaterinburg
    {   48, 3663,    7905,  4, }, // Atlantic/Azores
    {   48, 5671,   22640, 14, }, // Atlantic/Bermuda
    {   48, 6628,    4398,  5, }, // Atlantic/Canary
    {   48, 3727,   22654, 10, }, // Atlantic/Cape_Verde
    {   48, 1395,   22664,  5, }, // Atlantic/Faroe
    {   48, 8736,   22669,  7, }, // Atlantic/Madeira
    {   48, 2748,   22676,  9, }, // Atlantic/Reykjavik
    {   48, 7272,   22685, 14, }, // Atlantic/South_Georgia
    {   48, 6821,   22699, 15, }, // Atlantic/St_Helena
    {   48, 6644,    7965,  6, }, // Atlantic/Stanley
    {   48, 1670,   21030,  8, }, // Australia/Adelaide
    {   48, 1635,   22714,  8, }, // Australia/Brisbane
    {   48, 1583,    7998,  6, }, // Australia/Darwin
    {   48, 3637,   22722,  5, }, // Australia/Eucla
    {   48, 1547,   22727,  8, }, // Australia/Lord_Howe
    {   48, 1727,    8021,  7, }, // Australia/Melbourne
    {   48, 1762,   22735,  4, }, // Australia/Perth
    {   48, 1463,   22739,  6, }, // Australia/Sydney
    {   48, 3620,   22745,  9, }, // Europe/Astrakhan
    {   48, 2300,   22754,  5, }, // Europe/Athens
    {   48, 6336,   22759,  7, }, // Europe/Belgrade
    {   48, 2167,   22766,  7, }, // Europe/Brussels
    {   48, 3928,   22773,  8, }, // Europe/Bucharest
    {   48, 3806,   22781,  8, }, // Europe/Budapest
    {   48, 2583,   22789,  8, }, // Europe/Chisinau
    {   48, 6289,    4475, 10, }, // Europe/Copenhagen
    {   48, 6307,   22797, 12, }, // Europe/Gibraltar
    {   48, 8788,   22809,  7, }, // Europe/Guernsey
    {   48, 8804,   22816,  9, }, // Europe/Isle_of_Man
    {   48, 1130,   22825,  8, }, // Europe/Istanbul
    {   48, 8823,   22833,  5, }, // Europe/Jersey
    {   48, 3979,   22838, 11, }, // Europe/Kaliningrad
    {   48, 2527,   22849,  5, }, // Europe/Kyiv
    {   48, 3213,    4499,  8, }, // Europe/Lisbon
    {   48, 6506,   22854,  9, }, // Europe/Ljubljana
    {   48, 6365,   22863, 10, }, // Europe/Luxembourg
    {   48, 6582,   22873,  7, }, // Europe/Mariehamn
    {   48, 6410,    6044,  6, }, // Europe/Monaco
    {   48, 3537,   22880,  6, }, // Europe/Moscow
    {   48, 6424,   22886, 10, }, // Europe/Podgorica
    {   48, 6275,   22896,  5, }, // Europe/Prague
    {   48, 8837,   22901,  4, }, // Europe/Riga
    {   48, 6324,    6064,  4, }, // Europe/Rome
    {   48, 6245,   22905,  8, }, // Europe/Sarajevo
    {   48, 6383,   22913,  6, }, // Europe/Skopje
    {   48, 6599,   22919,  6, }, // Europe/Sofia
    {   48, 6523,    8242,  8, }, // Europe/Stockholm
    {   48, 8867,   22925,  6, }, // Europe/Tallinn
    {   48, 6202,   21213,  6, }, // Europe/Tirane
    {   48, 6352,   22931,  6, }, // Europe/Vaduz
    {   48, 6567,    6096,  7, }, // Europe/Vatican
    {   48, 6231,   22937,  5, }, // Europe/Vienna
    {   48, 8899,   22942,  6, }, // Europe/Vilnius
    {   48, 4727,   22948,  9, }, // Europe/Volgograd
    {   48, 3190,   22957,  7, }, // Europe/Warsaw
    {   48, 6261,   22964,  6, }, // Europe/Zagreb
    {   48, 6540,   22970,  5, }, // Europe/Zurich
    {   48, 6947,   22975,  5, }, // Indian/Chagos
    {   48, 6046,   22980,  5, }, // Indian/Christmas
    {   48, 6063,    4583,  5, }, // Indian/Cocos
    {   48, 5029,   22985,  6, }, // Indian/Comoro
    {   48, 6661,   22991,  8, }, // Indian/Kerguelen
    {   48, 7050,    8311,  6, }, // Indian/Maldives
    {   48, 4069,   22999,  7, }, // Indian/Mauritius
    {   48, 5098,    6164,  5, }, // Indian/Mayotte
    {   48, 7211,     547,  7, }, // Indian/Reunion
    {   48,  932,   23006,  6, }, // Pacific/Auckland
    {   48, 3706,   23012,  8, }, // Pacific/Bougainville
    {   48, 3015,   23020,  5, }, // Pacific/Chatham
    {   48, 3157,   23025,  4, }, // Pacific/Chuuk
    {   48, 2237,   23029,  5, }, // Pacific/Easter
    {   48, 3902,   23034,  4, }, // Pacific/Fiji
    {   48, 6678,   23038,  9, }, // Pacific/Galapagos
    {   48, 6696,   23047,  8, }, // Pacific/Gambier
    {   48, 3822,   23055, 11, }, // Pacific/Guadalcanal
    {   48, 6018,   23066,  4, }, // Pacific/Guam
    {   48, 2723,    4611,  8, }, // Pacific/Honolulu
    {   48, 3049,   23070,  9, }, // Pacific/Kanton
    {   48, 3998,   23079,  8, }, // Pacific/Kiritimati
    {   48, 7019,   23087,  7, }, // Pacific/Kosrae
    {   48, 2842,   23094,  9, }, // Pacific/Kwajalein
    {   48, 4877,   23103,  6, }, // Pacific/Majuro
    {   48, 4051,   23109,  8, }, // Pacific/Marquesas
    {   48, 8914,   23117,  6, }, // Pacific/Midway
    {   48, 3126,   23123,  9, }, // Pacific/Pago_Pago
    {   48, 7194,    8422,  7, }, // Pacific/Pitcairn
    {   48, 3096,     586,  7, }, // Pacific/Pohnpei
    {   48, 4807,   23132, 12, }, // Pacific/Port_Moresby
    {   48, 6076,   23144,  9, }, // Pacific/Rarotonga
    {   48, 6031,   23153,  6, }, // Pacific/Saipan
    {   48, 6712,   23159,  6, }, // Pacific/Tarawa
    {   48, 4583,   23165,  9, }, // Pacific/Tongatapu
    {   48, 7392,   23174,  4, }, // Pacific/Wake
    {   48, 7405,    8467,  6, }, // Pacific/Wallis
    {   49,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Arabic/Iran
    {   49, 4435,       6,  8, }, // Africa/Sao_Tome
    {   49, 4252,      14,  8, }, // America/Asuncion
    {   49, 7623,      30, 17, }, // America/Bahia_Banderas
    {   49, 3868,      47,  6, }, // America/Cancun
    {   49, 5723,      66,  7, }, // America/Curacao
    {   49,  481,      73, 13, }, // America/Indiana/Knox
    {   49, 7961,      86, 16, }, // America/Indiana/Marengo
    {   49, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   49, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   49, 8038,     139, 14, }, // America/Indiana/Vevay
    {   49, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   49, 8086,     171, 16, }, // America/Indiana/Winamac
    {   49, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   49, 5932,     207, 22, }, // America/Lower_Princes
    {   49, 8220,     229,  6, }, // America/Merida
    {   49, 1850,     235, 19, }, // America/Noronha
    {   49, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   49, 8329,     274, 20, }, // America/North_Dakota/Center
    {   49, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   49, 6899,     321, 16, }, // America/Scoresbysund
    {   49, 8508,     337, 14, }, // America/St_Barthelemy
    {   49, 2061,     351, 10, }, // America/St_Johns
    {   49, 5863,     361,  9, }, // America/St_Kitts
    {   49, 5880,     370,  9, }, // America/St_Lucia
    {   49,  855,     379, 10, }, // America/St_Thomas
    {   49, 5913,     389, 11, }, // America/St_Vincent
    {   49, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   49, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   49, 1185,     448,  9, }, // Asia/Kathmandu
    {   49,  992,     457,  7, }, // Asia/Kolkata
    {   49, 1211,     464,  5, }, // Asia/Macau
    {   49, 1235,     477,  6, }, // Asia/Yangon
    {   49, 1395,     483,  5, }, // Atlantic/Faroe
    {   49, 6821,     488, 10, }, // Atlantic/St_Helena
    {   49, 2527,     514,  4, }, // Europe/Kyiv
    {   49, 3157,     554,  5, }, // Pacific/Chuuk
    {   52,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Cyrillic/Azerbaijan
    {   52, 4435,       6,  8, }, // Africa/Sao_Tome
    {   52, 4252,      14,  8, }, // America/Asuncion
    {   52, 7623,      30, 17, }, // America/Bahia_Banderas
    {   52, 3868,      47,  6, }, // America/Cancun
    {   52, 5723,      66,  7, }, // America/Curacao
    {   52,  481,      73, 13, }, // America/Indiana/Knox
    {   52, 7961,      86, 16, }, // America/Indiana/Marengo
    {   52, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   52, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   52, 8038,     139, 14, }, // America/Indiana/Vevay
    {   52, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   52, 8086,     171, 16, }, // America/Indiana/Winamac
    {   52, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   52, 5932,     207, 22, }, // America/Lower_Princes
    {   52, 8220,     229,  6, }, // America/Merida
    {   52, 1850,     235, 19, }, // America/Noronha
    {   52, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   52, 8329,     274, 20, }, // America/North_Dakota/Center
    {   52, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   52, 6899,     321, 16, }, // America/Scoresbysund
    {   52, 8508,     337, 14, }, // America/St_Barthelemy
    {   52, 2061,     351, 10, }, // America/St_Johns
    {   52, 5863,     361,  9, }, // America/St_Kitts
    {   52, 5880,     370,  9, }, // America/St_Lucia
    {   52,  855,     379, 10, }, // America/St_Thomas
    {   52, 5913,     389, 11, }, // America/St_Vincent
    {   52, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   52, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   52, 1185,     448,  9, }, // Asia/Kathmandu
    {   52,  992,     457,  7, }, // Asia/Kolkata
    {   52, 1211,     464,  5, }, // Asia/Macau
    {   52, 1235,     477,  6, }, // Asia/Yangon
    {   52, 1395,     483,  5, }, // Atlantic/Faroe
    {   52, 6821,     488, 10, }, // Atlantic/St_Helena
    {   52, 2527,     514,  4, }, // Europe/Kyiv
    {   52, 3157,     554,  5, }, // Pacific/Chuuk
    {   53,   14,       0,  6, }, // Africa/Asmara Bafia/Latin/Cameroon
    {   53, 4435,       6,  8, }, // Africa/Sao_Tome
    {   53, 4252,      14,  8, }, // America/Asuncion
    {   53,  237,      22,  8, }, // America/Atikokan
    {   53, 7623,      30, 17, }, // America/Bahia_Banderas
    {   53, 3868,      47,  6, }, // America/Cancun
    {   53, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   53, 5723,      66,  7, }, // America/Curacao
    {   53,  481,      73, 13, }, // America/Indiana/Knox
    {   53, 7961,      86, 16, }, // America/Indiana/Marengo
    {   53, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   53, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   53, 8038,     139, 14, }, // America/Indiana/Vevay
    {   53, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   53, 8086,     171, 16, }, // America/Indiana/Winamac
    {   53, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   53, 5932,     207, 22, }, // America/Lower_Princes
    {   53, 8220,     229,  6, }, // America/Merida
    {   53, 1850,     235, 19, }, // America/Noronha
    {   53, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   53, 8329,     274, 20, }, // America/North_Dakota/Center
    {   53, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   53,  393,     317,  4, }, // America/Nuuk
    {   53, 6899,     321, 16, }, // America/Scoresbysund
    {   53, 8508,     337, 14, }, // America/St_Barthelemy
    {   53, 2061,     351, 10, }, // America/St_Johns
    {   53, 5863,     361,  9, }, // America/St_Kitts
    {   53, 5880,     370,  9, }, // America/St_Lucia
    {   53,  855,     379, 10, }, // America/St_Thomas
    {   53, 5913,     389, 11, }, // America/St_Vincent
    {   53, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   53, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   53, 1185,     448,  9, }, // Asia/Kathmandu
    {   53,  992,     457,  7, }, // Asia/Kolkata
    {   53, 1211,     464,  5, }, // Asia/Macau
    {   53, 1235,     477,  6, }, // Asia/Yangon
    {   53, 1395,     483,  5, }, // Atlantic/Faroe
    {   53, 6821,     488, 10, }, // Atlantic/St_Helena
    {   53, 2527,     514,  4, }, // Europe/Kyiv
    {   53, 7211,     547,  7, }, // Indian/Reunion
    {   53, 3157,     554,  5, }, // Pacific/Chuuk
    {   53, 3096,     586,  7, }, // Pacific/Pohnpei
    {   54,   14,       0,  6, }, // Africa/Asmara Bambara/Latin/Mali
    {   54, 4435,       6,  8, }, // Africa/Sao_Tome
    {   54, 4252,      14,  8, }, // America/Asuncion
    {   54,  237,      22,  8, }, // America/Atikokan
    {   54, 7623,      30, 17, }, // America/Bahia_Banderas
    {   54, 3868,      47,  6, }, // America/Cancun
    {   54, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   54, 5723,      66,  7, }, // America/Curacao
    {   54,  481,      73, 13, }, // America/Indiana/Knox
    {   54, 7961,      86, 16, }, // America/Indiana/Marengo
    {   54, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   54, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   54, 8038,     139, 14, }, // America/Indiana/Vevay
    {   54, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   54, 8086,     171, 16, }, // America/Indiana/Winamac
    {   54, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   54, 5932,     207, 22, }, // America/Lower_Princes
    {   54, 8220,     229,  6, }, // America/Merida
    {   54, 1850,     235, 19, }, // America/Noronha
    {   54, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   54, 8329,     274, 20, }, // America/North_Dakota/Center
    {   54, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   54,  393,     317,  4, }, // America/Nuuk
    {   54, 6899,     321, 16, }, // America/Scoresbysund
    {   54, 8508,     337, 14, }, // America/St_Barthelemy
    {   54, 2061,     351, 10, }, // America/St_Johns
    {   54, 5863,     361,  9, }, // America/St_Kitts
    {   54, 5880,     370,  9, }, // America/St_Lucia
    {   54,  855,     379, 10, }, // America/St_Thomas
    {   54, 5913,     389, 11, }, // America/St_Vincent
    {   54, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   54, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   54, 1185,     448,  9, }, // Asia/Kathmandu
    {   54,  992,     457,  7, }, // Asia/Kolkata
    {   54, 1211,     464,  5, }, // Asia/Macau
    {   54, 1235,     477,  6, }, // Asia/Yangon
    {   54, 1395,     483,  5, }, // Atlantic/Faroe
    {   54, 6821,     488, 10, }, // Atlantic/St_Helena
    {   54, 2527,     514,  4, }, // Europe/Kyiv
    {   54, 7211,     547,  7, }, // Indian/Reunion
    {   54, 3157,     554,  5, }, // Pacific/Chuuk
    {   54, 3096,     586,  7, }, // Pacific/Pohnpei
    {   56, 6788,   23178,  7, }, // Africa/Abidjan Bangla/Bangla/Bangladesh
    {   56, 6760,   23185,  5, }, // Africa/Accra
    {   56, 5059,   23190, 12, }, // Africa/Addis_Ababa
    {   56, 7420,   23202, 10, }, // Africa/Algiers
    {   56,   14,   23212, 11, }, // Africa/Asmara
    {   56,   44,   23223,  8, }, // Africa/Bamako
    {   56, 5257,   23231,  7, }, // Africa/Bangui
    {   56, 6746,   23238,  7, }, // Africa/Banjul
    {   56, 7435,   23245,  5, }, // Africa/Bissau
    {   56, 4957,   23250, 13, }, // Africa/Blantyre
    {   56, 5287,   23263, 10, }, // Africa/Brazzaville
    {   56, 4922,   23273, 10, }, // Africa/Bujumbura
    {   56, 2320,   23283,  6, }, // Africa/Cairo
    {   56, 4117,   23289, 12, }, // Africa/Casablanca
    {   56, 7449,   23301,  5, }, // Africa/Ceuta
    {   56, 6773,   23306,  7, }, // Africa/Conakry
    {   56, 6840,   23313,  5, }, // Africa/Dakar
    {   56, 5130,   23318, 12, }, // Africa/Dar_es_Salaam
    {   56, 5043,   17053,  6, }, // Africa/Djibouti
    {   56, 5243,   23330,  7, }, // Africa/Douala
    {   56, 5166,   23337,  8, }, // Africa/El_Aaiun
    {   56, 6853,   23345,  8, }, // Africa/Freetown
    {   56, 4906,   23353,  9, }, // Africa/Gaborone
    {   56, 5015,   23362,  6, }, // Africa/Harare
    {   56, 4479,   23368, 12, }, // Africa/Johannesburg
    {   56, 4499,   17107,  4, }, // Africa/Juba
    {   56, 5151,   23380,  7, }, // Africa/Kampala
    {   56, 4524,   23387,  7, }, // Africa/Khartoum
    {   56, 4973,   23394,  6, }, // Africa/Kigali
    {   56, 5306,   23400,  7, }, // Africa/Kinshasa
    {   56, 4744,   23407,  5, }, // Africa/Lagos
    {   56, 5336,   23412,  9, }, // Africa/Libreville
    {   56, 6869,   23421,  4, }, // Africa/Lome
    {   56, 5211,   23425,  9, }, // Africa/Luanda
    {   56, 4939,   23434, 10, }, // Africa/Lubumbashi
    {   56, 5001,   23444,  6, }, // Africa/Lusaka
    {   56, 5322,   17181,  6, }, // Africa/Malabo
    {   56, 4987,   23450,  6, }, // Africa/Maputo
    {   56, 5197,   23456,  7, }, // Africa/Maseru
    {   56, 5182,   23463,  7, }, // Africa/Mbabane
    {   56, 5113,   23470,  9, }, // Africa/Mogadishu
    {   56, 7034,   23479,  9, }, // Africa/Monrovia
    {   56, 3853,   23488,  7, }, // Africa/Nairobi
    {   56, 5271,   23495,  7, }, // Africa/Ndjamena
    {   56, 5354,   23502,  7, }, // Africa/Niamey
    {   56, 6803,   23509,  8, }, // Africa/Nouakchott
    {   56, 6727,   23517, 11, }, // Africa/Ouagadougou
    {   56, 5225,   23528, 11, }, // Africa/Porto-Novo
    {   56, 4435,   23539,  7, }, // Africa/Sao_Tome
    {   56, 2866,   23546,  8, }, // Africa/Tripoli
    {   56, 6554,   23554,  6, }, // Africa/Tunis
    {   56, 4152,   23560,  6, }, // Africa/Windhoek
    {   56,  132,   23566,  3, }, // America/Adak
    {   56, 3346,   23569,  7, }, // America/Anchorage
    {   56, 5607,   23576, 11, }, // America/Anguilla
    {   56, 5624,   23587, 13, }, // America/Antigua
    {   56, 4554,   23600, 11, }, // America/Araguaina
    {   56,  166,   23611, 16, }, // America/Argentina/Buenos_Aires
    {   56,   91,   23627, 12, }, // America/Argentina/Catamarca
    {   56,  270,   23639,  7, }, // America/Argentina/Cordoba
    {   56,  441,   17369,  5, }, // America/Argentina/Jujuy
    {   56, 7462,   23646,  8, }, // America/Argentina/La_Rioja
    {   56,  565,   23654,  8, }, // America/Argentina/Mendoza
    {   56, 7489,   23662, 12, }, // America/Argentina/Rio_Gallegos
    {   56, 7520,   23674,  7, }, // America/Argentina/Salta
    {   56, 7544,   23681, 10, }, // America/Argentina/San_Juan
    {   56, 5580,   23691,  8, }, // America/Argentina/San_Luis
    {   56, 7571,   23699,  7, }, // America/Argentina/Tucuman
    {   56, 7597,   23706, 10, }, // America/Argentina/Ushuaia
    {   56, 5640,   23716,  5, }, // America/Aruba
    {   56, 4252,   23721,  9, }, // America/Asuncion
    {   56,  237,   17453,  8, }, // America/Atikokan
    {   56, 3679,   17461,  7, }, // America/Bahia
    {   56, 7623,   23730, 17, }, // America/Bahia_Banderas
    {   56, 5654,   23747,  9, }, // America/Barbados
    {   56, 7646,   17494,  5, }, // America/Belem
    {   56, 5407,   17499,  5, }, // America/Belize
    {   56, 7660,   23756, 15, }, // America/Blanc-Sablon
    {   56, 7681,   23771, 12, }, // America/Boa_Vista
    {   56, 4361,   17528,  6, }, // America/Bogota
    {   56, 7699,   23783,  5, }, // America/Boise
    {   56, 7713,   23788, 11, }, // America/Cambridge_Bay
    {   56, 7735,   23799, 15, }, // America/Campo_Grande
    {   56, 3868,   23814,  8, }, // America/Cancun
    {   56, 4694,   23822,  9, }, // America/Caracas
    {   56, 4345,   23831,  5, }, // America/Cayenne
    {   56, 5496,   23836,  5, }, // America/Cayman
    {   56, 2260,   23841,  6, }, // America/Chicago
    {   56, 7756,   23847, 12, }, // America/Chihuahua
    {   56, 7774,   23859, 15, }, // America/Ciudad_Juarez
    {   56, 5422,   23874, 10, }, // America/Costa_Rica
    {   56, 7796,   23884,  9, }, // America/Creston
    {   56, 3791,   23893,  8, }, // America/Cuiaba
    {   56, 5723,   23901,  7, }, // America/Curacao
    {   56, 7812,   23908, 14, }, // America/Danmarkshavn
    {   56, 7833,   23922,  4, }, // America/Dawson
    {   56, 7848,   23926, 10, }, // America/Dawson_Creek
    {   56,  805,   23936,  6, }, // America/Denver
    {   56, 3465,   23942,  8, }, // America/Detroit
    {   56, 5739,   23950,  8, }, // America/Dominica
    {   56,  893,   23958,  8, }, // America/Edmonton
    {   56, 7869,   23966,  8, }, // America/Eirunepe
    {   56, 5441,   23974, 11, }, // America/El_Salvador
    {   56, 7886,   23985, 11, }, // America/Fort_Nelson
    {   56, 7906,   23996, 10, }, // America/Fortaleza
    {   56, 7924,   24006,  8, }, // America/Glace_Bay
    {   56, 6881,   24014,  6, }, // America/Goose_Bay
    {   56, 4612,   24020, 15, }, // America/Grand_Turk
    {   56, 5770,   24035,  8, }, // America/Grenada
    {   56, 5786,   24043, 10, }, // America/Guadeloupe
    {   56, 3760,   24053, 11, }, // America/Guatemala
    {   56, 4841,   24064, 12, }, // America/Guayaquil
    {   56, 6932,   17819,  7, }, // America/Guyana
    {   56, 1939,   24076, 13, }, // America/Halifax
    {   56, 2281,   17835,  6, }, // America/Havana
    {   56, 7942,   24089, 11, }, // America/Hermosillo
    {   56,  348,   24100, 15, }, // America/Indiana/Indianapolis
    {   56,  481,   24115, 16, }, // America/Indiana/Knox
    {   56, 7961,   24131, 20, }, // America/Indiana/Marengo
    {   56, 7985,   24151, 25, }, // America/Indiana/Petersburg
    {   56, 8012,   24176, 19, }, // America/Indiana/Tell_City
    {   56, 8038,   24195, 18, }, // America/Indiana/Vevay
    {   56, 8060,   24213, 22, }, // America/Indiana/Vincennes
    {   56, 8086,   24235, 21, }, // America/Indiana/Winamac
    {   56, 8110,   24256,  8, }, // America/Inuvik
    {   56,  660,   24264, 10, }, // America/Iqaluit
    {   56, 2799,   18015,  7, }, // America/Jamaica
    {   56, 5380,   24274,  4, }, // America/Juneau
    {   56,  521,   24278,  7, }, // America/Kentucky/Louisville
    {   56, 8125,   24285, 19, }, // America/Kentucky/Monticello
    {   56, 5704,   24304, 13, }, // America/Kralendijk
    {   56, 4376,   18067,  6, }, // America/La_Paz
    {   56, 7169,   18073,  4, }, // America/Lima
    {   56, 3239,   24317, 14, }, // America/Los_Angeles
    {   56, 5932,   24331, 27, }, // America/Lower_Princes
    {   56, 8153,   24358,  7, }, // America/Maceio
    {   56, 8168,   24365,  9, }, // America/Managua
    {   56, 1908,   24374,  6, }, // America/Manaus
    {   56, 5897,   24380,  6, }, // America/Marigot
    {   56, 5805,   24386,  8, }, // America/Martinique
    {   56, 8184,   24394,  8, }, // America/Matamoros
    {   56, 2917,   24402,  8, }, // America/Mazatlan
    {   56, 8202,   24410,  8, }, // America/Menominee
    {   56, 8220,   24418,  6, }, // America/Merida
    {   56, 8235,   24424, 10, }, // America/Metlakatla
    {   56, 2949,   24434, 13, }, // America/Mexico_City
    {   56, 4391,   24447,  6, }, // America/Miquelon
    {   56, 8254,   24453,  7, }, // America/Moncton
    {   56, 8270,   24460,  7, }, // America/Monterrey
    {   56, 4098,   24467, 10, }, // America/Montevideo
    {   56, 5824,   24477,  9, }, // America/Montserrat
    {   56, 5481,   24486,  5, }, // America/Nassau
    {   56, 2379,   24491,  9, }, // America/New_York
    {   56, 8288,   18168,  3, }, // America/Nome
    {   56, 1850,   24500,  8, }, // America/Noronha
    {   56, 8301,   24508, 19, }, // America/North_Dakota/Beulah
    {   56, 8329,   24527, 18, }, // America/North_Dakota/Center
    {   56, 8357,   24545, 23, }, // America/North_Dakota/New_Salem
    {   56,  393,   18338,  3, }, // America/Nuuk
    {   56, 8388,   24568,  7, }, // America/Ojinaga
    {   56, 2356,   18349,  6, }, // America/Panama
    {   56, 6173,   24575, 12, }, // America/Paramaribo
    {   56, 2973,   18365,  7, }, // America/Phoenix
    {   56, 3945,   24587, 16, }, // America/Port-au-Prince
    {   56, 5954,   24603, 14, }, // America/Port_of_Spain
    {   56, 8404,   24617, 14, }, // America/Porto_Velho
    {   56, 5843,   24631, 14, }, // America/Puerto_Rico
    {   56, 4030,   24645, 13, }, // America/Punta_Arenas
    {   56, 8424,   24658, 16, }, // America/Rankin_Inlet
    {   56, 8445,   24674,  6, }, // America/Recife
    {   56, 1995,   24680,  6, }, // America/Regina
    {   56, 8460,   24686,  7, }, // America/Resolute
    {   56,  695,   24693, 12, }, // America/Rio_Branco
    {   56, 8477,   24705,  8, }, // America/Santarem
    {   56, 2201,   24713, 11, }, // America/Santiago
    {   56, 6111,   24724, 16, }, // America/Santo_Domingo
    {   56, 1878,   24740,  9, }, // America/Sao_Paulo
    {   56, 6899,   24749, 16, }, // America/Scoresbysund
    {   56, 8494,   24765,  5, }, // America/Sitka
    {   56, 8508,   24770, 16, }, // America/St_Barthelemy
    {   56, 2061,   24786, 10, }, // America/St_Johns
    {   56, 5863,   24796, 11, }, // America/St_Kitts
    {   56, 5880,   24807, 14, }, // America/St_Lucia
    {   56,  855,   24821, 11, }, // America/St_Thomas
    {   56, 5913,   24832, 15, }, // America/St_Vincent
    {   56, 8530,   24847, 14, }, // America/Swift_Current
    {   56, 5461,   24861, 11, }, // America/Tegucigalpa
    {   56, 5756,   24872,  4, }, // America/Thule
    {   56,  313,   24876,  9, }, // America/Tijuana
    {   56,  608,   24885,  7, }, // America/Toronto
    {   56, 5688,   24892,  6, }, // America/Tortola
    {   56, 2093,   24898, 11, }, // America/Vancouver
    {   56, 2144,   24909, 11, }, // America/Whitehorse
    {   56,  734,   24920,  7, }, // America/Winnipeg
    {   56, 8552,   24927,  9, }, // America/Yakutat
    {   56, 6001,   24936,  5, }, // Antarctica/Casey
    {   56, 6094,   24941,  5, }, // Antarctica/Davis
    {   56, 6133,   24946, 15, }, // Antarctica/DumontDUrville
    {   56, 8568,   24961, 14, }, // Antarctica/Macquarie
    {   56, 7066,   24975,  4, }, // Antarctica/Mawson
    {   56, 7113,   24979, 11, }, // Antarctica/McMurdo
    {   56, 8589,   24990,  6, }, // Antarctica/Palmer
    {   56, 7226,   24996,  5, }, // Antarctica/Rothera
    {   56, 7295,   25001,  6, }, // Antarctica/Syowa
    {   56, 8607,   25007,  4, }, // Antarctica/Troll
    {   56, 7374,   25011,  6, }, // Antarctica/Vostok
    {   56, 1429,   25017, 14, }, // Arctic/Longyearbyen
    {   56, 5570,   25031,  5, }, // Asia/Aden
    {   56, 5395,   18812,  6, }, // Asia/Almaty
    {   56, 3968,   18818,  6, }, // Asia/Amman
    {   56, 5511,   25036,  9, }, // Asia/Anadyr
    {   56, 5523,   25045,  5, }, // Asia/Aqtau
    {   56, 5368,   25050,  6, }, // Asia/Aqtobe
    {   56,  964,   25056,  7, }, // Asia/Ashgabat
    {   56, 8624,   25063,  6, }, // Asia/Atyrau
    {   56, 3607,   18863,  6, }, // Asia/Baghdad
    {   56, 5534,   25069,  7, }, // Asia/Bahrain
    {   56, 3653,   17644,  4, }, // Asia/Baku
    {   56, 4466,   25076,  7, }, // Asia/Bangkok
    {   56, 3571,   25083,  7, }, // Asia/Barnaul
    {   56, 4086,   25090,  6, }, // Asia/Beirut
    {   56, 3778,   25096,  6, }, // Asia/Bishkek
    {   56, 5989,   25102,  7, }, // Asia/Brunei
    {   56, 4601,   25109,  4, }, // Asia/Chita
    {   56, 4511,   18915,  6, }, // Asia/Colombo
    {   56, 4540,   25113,  9, }, // Asia/Damascus
    {   56, 1093,   18930,  4, }, // Asia/Dhaka
    {   56, 6192,   25122,  4, }, // Asia/Dili
    {   56, 3596,   25126,  5, }, // Asia/Dubai
    {   56, 6159,   25131,  7, }, // Asia/Dushanbe
    {   56, 8636,   25138, 10, }, // Asia/Famagusta
    {   56, 8651,   18960,  4, }, // Asia/Gaza
    {   56, 4795,   25148,  7, }, // Asia/Hebron
    {   56, 1259,   25155, 13, }, // Asia/Ho_Chi_Minh
    {   56, 2704,   18985,  5, }, // Asia/Hong_Kong
    {   56, 4771,   25168,  5, }, // Asia/Hovd
    {   56, 4184,   25173,  8, }, // Asia/Irkutsk
    {   56, 7006,   25181,  8, }, // Asia/Jakarta
    {   56, 6992,   25189,  8, }, // Asia/Jayapura
    {   56, 1290,   25197,  9, }, // Asia/Jerusalem
    {   56, 3560,   19032,  5, }, // Asia/Kabul
    {   56, 4316,   25206,  8, }, // Asia/Kamchatka
    {   56, 4239,   25214,  5, }, // Asia/Karachi
    {   56, 1185,   25219,  9, }, // Asia/Kathmandu
    {   56, 8661,   25228, 10, }, // Asia/Khandyga
    {   56,  992,   25238,  7, }, // Asia/Kolkata
    {   56, 4197,   25245, 16, }, // Asia/Krasnoyarsk
    {   56, 4859,   25261, 13, }, // Asia/Kuala_Lumpur
    {   56, 5976,   19100,  5, }, // Asia/Kuching
    {   56, 5547,   25274,  6, }, // Asia/Kuwait
    {   56, 1211,   25280,  7, }, // Asia/Macau
    {   56, 4017,   25287,  9, }, // Asia/Magadan
    {   56, 1349,   25296,  8, }, // Asia/Makassar
    {   56, 7182,   25304,  8, }, // Asia/Manila
    {   56, 6920,   25312,  5, }, // Asia/Muscat
    {   56, 2554,   25317,  9, }, // Asia/Nicosia
    {   56, 8675,   25326, 12, }, // Asia/Novokuznetsk
    {   56, 4135,   25338, 12, }, // Asia/Novosibirsk
    {   56, 4229,   25350,  6, }, // Asia/Omsk
    {   56, 7145,   25356,  4, }, // Asia/Oral
    {   56, 6961,   25360,  6, }, // Asia/Phnom_Penh
    {   56, 8693,   25366, 13, }, // Asia/Pontianak
    {   56, 4214,   25379,  9, }, // Asia/Pyongyang
    {   56, 5559,   25388,  5, }, // Asia/Qatar
    {   56, 8708,   25393,  9, }, // Asia/Qostanay
    {   56, 4269,   25402,  9, }, // Asia/Qyzylorda
    {   56, 3584,   25411,  6, }, // Asia/Riyadh
    {   56, 4408,   25417,  7, }, // Asia/Sakhalin
    {   56, 7245,   25424,  7, }, // Asia/Samarkand
    {   56, 3279,   25431,  4, }, // Asia/Seoul
    {   56, 1053,   25435,  6, }, // Asia/Shanghai
    {   56, 3300,   25441,  9, }, // Asia/Singapore
    {   56, 4297,   25450, 16, }, // Asia/Srednekolymsk
    {   56, 3263,   25466,  6, }, // Asia/Taipei
    {   56, 4781,   25472,  7, }, // Asia/Tashkent
    {   56, 3915,   25479,  8, }, // Asia/Tbilisi
    {   56, 2772,   25487,  7, }, // Asia/Tehran
    {   56, 1317,   19324,  6, }, // Asia/Thimphu
    {   56, 2821,   25494,  5, }, // Asia/Tokyo
    {   56, 4572,   25499,  6, }, // Asia/Tomsk
    {   56, 1021,   25505,  9, }, // Asia/Ulaanbaatar
    {   56, 1159,   25514,  6, }, // Asia/Urumqi
    {   56, 8722,   25520, 10, }, // Asia/Ust-Nera
    {   56, 6977,   25530, 12, }, // Asia/Vientiane
    {   56, 4710,   25542, 12, }, // Asia/Vladivostok
    {   56, 4828,   25554, 10, }, // Asia/Yakutsk
    {   56, 1235,   25564,  7, }, // Asia/Yangon
    {   56, 3883,   25571, 16, }, // Asia/Yekaterinburg
    {   56, 3747,   25587,  9, }, // Asia/Yerevan
    {   56, 3663,   25596,  6, }, // Atlantic/Azores
    {   56, 5671,   25602,  7, }, // Atlantic/Bermuda
    {   56, 6628,   25609,  6, }, // Atlantic/Canary
    {   56, 3727,   25615,  9, }, // Atlantic/Cape_Verde
    {   56, 1395,   25624,  6, }, // Atlantic/Faroe
    {   56, 8736,   25630,  7, }, // Atlantic/Madeira
    {   56, 2748,   25637,  8, }, // Atlantic/Reykjavik
    {   56, 7272,   25645, 15, }, // Atlantic/South_Georgia
    {   56, 6821,   25660, 13, }, // Atlantic/St_Helena
    {   56, 6644,   25673,  7, }, // Atlantic/Stanley
    {   56, 1670,   25680, 10, }, // Australia/Adelaide
    {   56, 1635,   25690,  8, }, // Australia/Brisbane
    {   56, 1799,   25698, 11, }, // Australia/Broken_Hill
    {   56, 1583,   25709,  6, }, // Australia/Darwin
    {   56, 3637,   19551,  6, }, // Australia/Eucla
    {   56, 1516,   25715,  7, }, // Australia/Hobart
    {   56, 8753,   25722, 10, }, // Australia/Lindeman
    {   56, 1547,   25732,  8, }, // Australia/Lord_Howe
    {   56, 1727,   25740,  8, }, // Australia/Melbourne
    {   56, 1762,   25748,  5, }, // Australia/Perth
    {   56, 1463,   25753,  5, }, // Australia/Sydney
    {   56, 6441,   25758, 10, }, // Europe/Amsterdam
    {   56, 6216,   25768, 10, }, // Europe/Andorra
    {   56, 3620,   25778,  9, }, // Europe/Astrakhan
    {   56, 2300,   19625,  6, }, // Europe/Athens
    {   56, 6336,   25787,  8, }, // Europe/Belgrade
    {   56, 4757,   25795,  7, }, // Europe/Berlin
    {   56, 6488,   25802, 12, }, // Europe/Bratislava
    {   56, 2167,   25814,  8, }, // Europe/Brussels
    {   56, 3928,   25822,  9, }, // Europe/Bucharest
    {   56, 3806,   25831,  9, }, // Europe/Budapest
    {   56, 8772,   25840,  8, }, // Europe/Busingen
    {   56, 2583,   25848,  8, }, // Europe/Chisinau
    {   56, 6289,   25856, 10, }, // Europe/Copenhagen
    {   56, 2338,   19708,  6, }, // Europe/Dublin
    {   56, 6307,   25866, 11, }, // Europe/Gibraltar
    {   56, 8788,   25877, 10, }, // Europe/Guernsey
    {   56, 6612,   25887,  9, }, // Europe/Helsinki
    {   56, 8804,   25896, 12, }, // Europe/Isle_of_Man
    {   56, 1130,   19749,  9, }, // Europe/Istanbul
    {   56, 8823,   25908,  6, }, // Europe/Jersey
    {   56, 3979,   25914, 12, }, // Europe/Kaliningrad
    {   56, 8929,   25926,  5, }, // Europe/Kirov
    {   56, 2527,   25931,  6, }, // Europe/Kyiv
    {   56, 3213,   25937,  5, }, // Europe/Lisbon
    {   56, 6506,   25942, 10, }, // Europe/Ljubljana
    {   56, 2501,   25952,  5, }, // Europe/London
    {   56, 6365,   25957, 12, }, // Europe/Luxembourg
    {   56, 4892,   25969,  7, }, // Europe/Madrid
    {   56, 6397,   19824,  6, }, // Europe/Malta
    {   56, 6582,   25976, 11, }, // Europe/Mariehamn
    {   56, 3693,   25987,  6, }, // Europe/Minsk
    {   56, 6410,   19846,  6, }, // Europe/Monaco
    {   56, 3537,   19852,  5, }, // Europe/Moscow
    {   56, 6458,   25993,  4, }, // Europe/Oslo
    {   56, 4284,   25997,  7, }, // Europe/Paris
    {   56, 6424,   26004,  9, }, // Europe/Podgorica
    {   56, 6275,   26013,  5, }, // Europe/Prague
    {   56, 8837,   26018,  4, }, // Europe/Riga
    {   56, 6324,   25628,  3, }, // Europe/Rome
    {   56, 4331,   26022,  6, }, // Europe/Samara
    {   56, 6470,   26028, 10, }, // Europe/San_Marino
    {   56, 6245,   26038,  8, }, // Europe/Sarajevo
    {   56, 4451,   26046,  7, }, // Europe/Saratov
    {   56, 8849,   26053, 10, }, // Europe/Simferopol
    {   56, 6383,   26063,  7, }, // Europe/Skopje
    {   56, 6599,   26070,  7, }, // Europe/Sofia
    {   56, 6523,   26077,  7, }, // Europe/Stockholm
    {   56, 8867,   26084,  6, }, // Europe/Tallinn
    {   56, 6202,   26090,  6, }, // Europe/Tirane
    {   56, 8882,   26096, 12, }, // Europe/Ulyanovsk
    {   56, 6352,   19973,  5, }, // Europe/Vaduz
    {   56, 6567,   26108,  7, }, // Europe/Vatican
    {   56, 6231,   19985,  7, }, // Europe/Vienna
    {   56, 8899,   26115,  7, }, // Europe/Vilnius
    {   56, 4727,   26122, 11, }, // Europe/Volgograd
    {   56, 3190,   26133,  6, }, // Europe/Warsaw
    {   56, 6261,   26139,  7, }, // Europe/Zagreb
    {   56, 6540,   26146,  5, }, // Europe/Zurich
    {   56, 5078,   26151, 13, }, // Indian/Antananarivo
    {   56, 6947,   26164,  5, }, // Indian/Chagos
    {   56, 6046,   26169,  8, }, // Indian/Christmas
    {   56, 6063,   26177,  5, }, // Indian/Cocos
    {   56, 5029,   26182,  6, }, // Indian/Comoro
    {   56, 6661,   26188,  9, }, // Indian/Kerguelen
    {   56, 7260,   20077,  4, }, // Indian/Mahe
    {   56, 7050,   20081,  8, }, // Indian/Maldives
    {   56, 4069,   26197,  6, }, // Indian/Mauritius
    {   56, 5098,   26203,  7, }, // Indian/Mayotte
    {   56, 7211,   26210,  9, }, // Indian/Reunion
    {   56, 4422,   20113,  6, }, // Pacific/Apia
    {   56,  932,   26219,  9, }, // Pacific/Auckland
    {   56, 3706,   26228,  9, }, // Pacific/Bougainville
    {   56, 3015,   26237,  7, }, // Pacific/Chatham
    {   56, 3157,   20143,  3, }, // Pacific/Chuuk
    {   56, 2237,   26244,  6, }, // Pacific/Easter
    {   56, 7360,   26250,  5, }, // Pacific/Efate
    {   56, 7327,   26255,  9, }, // Pacific/Fakaofo
    {   56, 3902,   20163,  4, }, // Pacific/Fiji
    {   56, 7343,   20167,  8, }, // Pacific/Funafuti
    {   56, 6678,   26264, 13, }, // Pacific/Galapagos
    {   56, 6696,   26277, 10, }, // Pacific/Gambier
    {   56, 3822,   26287, 13, }, // Pacific/Guadalcanal
    {   56, 6018,   24369,  6, }, // Pacific/Guam
    {   56, 2723,   26300,  7, }, // Pacific/Honolulu
    {   56, 3049,   26307, 10, }, // Pacific/Kanton
    {   56, 3998,   26317, 10, }, // Pacific/Kiritimati
    {   56, 7019,   26327,  7, }, // Pacific/Kosrae
    {   56, 2842,   26334, 11, }, // Pacific/Kwajalein
    {   56, 4877,   26345,  6, }, // Pacific/Majuro
    {   56, 4051,   26351,  9, }, // Pacific/Marquesas
    {   56, 8914,   26360,  7, }, // Pacific/Midway
    {   56, 7084,   26367,  5, }, // Pacific/Nauru
    {   56, 7132,   26372,  6, }, // Pacific/Niue
    {   56, 4168,   26378,  4, }, // Pacific/Norfolk
    {   56, 7098,   26382,  7, }, // Pacific/Noumea
    {   56, 3126,   26389, 13, }, // Pacific/Pago_Pago
    {   56, 7155,   20291,  5, }, // Pacific/Palau
    {   56, 7194,   26402, 11, }, // Pacific/Pitcairn
    {   56, 3096,   26413,  6, }, // Pacific/Pohnpei
    {   56, 4807,   26419, 12, }, // Pacific/Port_Moresby
    {   56, 6076,   26431, 11, }, // Pacific/Rarotonga
    {   56, 6031,   26442,  6, }, // Pacific/Saipan
    {   56, 7312,   20342,  6, }, // Pacific/Tahiti
    {   56, 6712,   26448,  8, }, // Pacific/Tarawa
    {   56, 4583,   26456, 10, }, // Pacific/Tongatapu
    {   56, 7392,   26466,  5, }, // Pacific/Wake
    {   56, 7405,   26471,  4, }, // Pacific/Wallis
    {   58,   14,       0,  6, }, // Africa/Asmara Basaa/Latin/Cameroon
    {   58, 4435,       6,  8, }, // Africa/Sao_Tome
    {   58, 4252,      14,  8, }, // America/Asuncion
    {   58,  237,      22,  8, }, // America/Atikokan
    {   58, 7623,      30, 17, }, // America/Bahia_Banderas
    {   58, 3868,      47,  6, }, // America/Cancun
    {   58, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   58, 5723,      66,  7, }, // America/Curacao
    {   58,  481,      73, 13, }, // America/Indiana/Knox
    {   58, 7961,      86, 16, }, // America/Indiana/Marengo
    {   58, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   58, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   58, 8038,     139, 14, }, // America/Indiana/Vevay
    {   58, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   58, 8086,     171, 16, }, // America/Indiana/Winamac
    {   58, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   58, 5932,     207, 22, }, // America/Lower_Princes
    {   58, 8220,     229,  6, }, // America/Merida
    {   58, 1850,     235, 19, }, // America/Noronha
    {   58, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   58, 8329,     274, 20, }, // America/North_Dakota/Center
    {   58, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   58,  393,     317,  4, }, // America/Nuuk
    {   58, 6899,     321, 16, }, // America/Scoresbysund
    {   58, 8508,     337, 14, }, // America/St_Barthelemy
    {   58, 2061,     351, 10, }, // America/St_Johns
    {   58, 5863,     361,  9, }, // America/St_Kitts
    {   58, 5880,     370,  9, }, // America/St_Lucia
    {   58,  855,     379, 10, }, // America/St_Thomas
    {   58, 5913,     389, 11, }, // America/St_Vincent
    {   58, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   58, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   58, 1185,     448,  9, }, // Asia/Kathmandu
    {   58,  992,     457,  7, }, // Asia/Kolkata
    {   58, 1211,     464,  5, }, // Asia/Macau
    {   58, 1235,     477,  6, }, // Asia/Yangon
    {   58, 1395,     483,  5, }, // Atlantic/Faroe
    {   58, 6821,     488, 10, }, // Atlantic/St_Helena
    {   58, 2527,     514,  4, }, // Europe/Kyiv
    {   58, 7211,     547,  7, }, // Indian/Reunion
    {   58, 3157,     554,  5, }, // Pacific/Chuuk
    {   58, 3096,     586,  7, }, // Pacific/Pohnpei
    {   59,   14,       0,  6, }, // Africa/Asmara Bashkir/Cyrillic/Russia
    {   59, 4435,       6,  8, }, // Africa/Sao_Tome
    {   59, 4252,      14,  8, }, // America/Asuncion
    {   59,  237,      22,  8, }, // America/Atikokan
    {   59, 7623,      30, 17, }, // America/Bahia_Banderas
    {   59, 3868,      47,  6, }, // America/Cancun
    {   59, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   59, 5723,      66,  7, }, // America/Curacao
    {   59,  481,      73, 13, }, // America/Indiana/Knox
    {   59, 7961,      86, 16, }, // America/Indiana/Marengo
    {   59, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   59, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   59, 8038,     139, 14, }, // America/Indiana/Vevay
    {   59, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   59, 8086,     171, 16, }, // America/Indiana/Winamac
    {   59, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   59, 5932,     207, 22, }, // America/Lower_Princes
    {   59, 8220,     229,  6, }, // America/Merida
    {   59, 1850,     235, 19, }, // America/Noronha
    {   59, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   59, 8329,     274, 20, }, // America/North_Dakota/Center
    {   59, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   59,  393,     317,  4, }, // America/Nuuk
    {   59, 6899,     321, 16, }, // America/Scoresbysund
    {   59, 8508,     337, 14, }, // America/St_Barthelemy
    {   59, 2061,     351, 10, }, // America/St_Johns
    {   59, 5863,     361,  9, }, // America/St_Kitts
    {   59, 5880,     370,  9, }, // America/St_Lucia
    {   59,  855,     379, 10, }, // America/St_Thomas
    {   59, 5913,     389, 11, }, // America/St_Vincent
    {   59, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   59, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   59, 1185,     448,  9, }, // Asia/Kathmandu
    {   59,  992,     457,  7, }, // Asia/Kolkata
    {   59, 1211,     464,  5, }, // Asia/Macau
    {   59, 1235,     477,  6, }, // Asia/Yangon
    {   59, 1395,     483,  5, }, // Atlantic/Faroe
    {   59, 6821,     488, 10, }, // Atlantic/St_Helena
    {   59, 2527,     514,  4, }, // Europe/Kyiv
    {   59, 7211,     547,  7, }, // Indian/Reunion
    {   59, 3157,     554,  5, }, // Pacific/Chuuk
    {   59, 3096,     586,  7, }, // Pacific/Pohnpei
    {   60, 6760,   21292,  5, }, // Africa/Accra Basque/Latin/Spain
    {   60, 5059,    3902, 11, }, // Africa/Addis_Ababa
    {   60, 7420,   26475,  5, }, // Africa/Algiers
    {   60,   14,       0,  6, }, // Africa/Asmara
    {   60, 5257,   26480,  5, }, // Africa/Bangui
    {   60, 2320,    4690,  5, }, // Africa/Cairo
    {   60, 6773,   26485,  7, }, // Africa/Conakry
    {   60, 5043,   26492,  7, }, // Africa/Djibouti
    {   60, 5243,   21372,  5, }, // Africa/Douala
    {   60, 5166,   26499,  5, }, // Africa/El_Aaiun
    {   60, 4524,   26504,  7, }, // Africa/Khartoum
    {   60, 5113,   26511,  8, }, // Africa/Mogadishu
    {   60, 5271,   26519,  9, }, // Africa/Ndjamena
    {   60, 5354,   26528,  6, }, // Africa/Niamey
    {   60, 6803,   20442,  7, }, // Africa/Nouakchott
    {   60, 6727,   26534,  8, }, // Africa/Ouagadougou
    {   60, 5225,   26542, 10, }, // Africa/Porto-Novo
    {   60, 4435,       6,  8, }, // Africa/Sao_Tome
    {   60, 5607,   26552,  7, }, // America/Anguilla
    {   60, 4554,   26559,  9, }, // America/Araguaina
    {   60,  270,   20479,  7, }, // America/Argentina/Cordoba
    {   60, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {   60, 4252,      14,  8, }, // America/Asuncion
    {   60,  237,      22,  8, }, // America/Atikokan
    {   60, 7623,      30, 17, }, // America/Bahia_Banderas
    {   60, 3868,      47,  6, }, // America/Cancun
    {   60, 5496,   26568,  6, }, // America/Cayman
    {   60, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   60, 3791,   26574,  6, }, // America/Cuiaba
    {   60, 5723,      66,  7, }, // America/Curacao
    {   60, 5739,   21666,  8, }, // America/Dominica
    {   60, 7869,   26580,  8, }, // America/Eirunepe
    {   60, 5786,   20526,  9, }, // America/Guadeloupe
    {   60, 2281,   20538,  6, }, // America/Havana
    {   60,  481,      73, 13, }, // America/Indiana/Knox
    {   60, 7961,      86, 16, }, // America/Indiana/Marengo
    {   60, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   60, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   60, 8038,     139, 14, }, // America/Indiana/Vevay
    {   60, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   60, 8086,     171, 16, }, // America/Indiana/Winamac
    {   60, 2799,    3995,  7, }, // America/Jamaica
    {   60, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   60, 5932,     207, 22, }, // America/Lower_Princes
    {   60, 8153,   26588,  6, }, // America/Maceio
    {   60, 5805,   26594,  9, }, // America/Martinique
    {   60, 2917,   26603,  8, }, // America/Mazatlan
    {   60, 8220,     229,  6, }, // America/Merida
    {   60, 2949,   26611, 12, }, // America/Mexico_City
    {   60, 4391,   26623,  8, }, // America/Miquelon
    {   60, 1850,     235, 19, }, // America/Noronha
    {   60, 8301,   26631, 19, }, // America/North_Dakota/Beulah
    {   60, 8329,   26650, 19, }, // America/North_Dakota/Center
    {   60, 8357,   26669, 22, }, // America/North_Dakota/New_Salem
    {   60,  393,     317,  4, }, // America/Nuuk
    {   60, 5954,   26691, 13, }, // America/Port_of_Spain
    {   60, 8477,   26704,  8, }, // America/Santarem
    {   60, 1878,   26712,  9, }, // America/Sao_Paulo
    {   60, 6899,     321, 16, }, // America/Scoresbysund
    {   60, 8508,   26721, 16, }, // America/St_Barthelemy
    {   60, 2061,   26737, 12, }, // America/St_Johns
    {   60, 5863,   26749, 11, }, // America/St_Kitts
    {   60, 5880,   26760, 11, }, // America/St_Lucia
    {   60,  855,   26771, 12, }, // America/St_Thomas
    {   60, 5913,   26783, 13, }, // America/St_Vincent
    {   60, 5756,   26796,  7, }, // America/Thule
    {   60, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   60, 5523,    5609,  5, }, // Asia/Aqtau
    {   60, 5368,    7606,  6, }, // Asia/Aqtobe
    {   60,  964,   26803,  7, }, // Asia/Ashgabat
    {   60, 3607,    4162,  6, }, // Asia/Baghdad
    {   60, 3778,   26810,  6, }, // Asia/Bishkek
    {   60, 4601,   26816,  5, }, // Asia/Chita
    {   60, 4511,    5637,  7, }, // Asia/Colombo
    {   60, 4540,   26821,  7, }, // Asia/Damascus
    {   60, 6159,   26828,  7, }, // Asia/Dushanbe
    {   60, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   60, 4771,   26835,  5, }, // Asia/Hovd
    {   60, 4316,   26840,  9, }, // Asia/Kamchatka
    {   60, 4239,   26849,  7, }, // Asia/Karachi
    {   60, 1185,    5711,  8, }, // Asia/Kathmandu
    {   60, 8661,   26856,  8, }, // Asia/Khandyga
    {   60,  992,   26864,  7, }, // Asia/Kolkata
    {   60, 4197,   26871, 11, }, // Asia/Krasnoyarsk
    {   60, 1211,    4321,  5, }, // Asia/Macau
    {   60, 6920,   26882,  6, }, // Asia/Muscat
    {   60, 2554,    5738,  7, }, // Asia/Nicosia
    {   60, 4214,   26888,  9, }, // Asia/Pyongyang
    {   60, 8708,     469,  8, }, // Asia/Qostanay
    {   60, 4269,   26897,  9, }, // Asia/Qyzylorda
    {   60, 3584,    7787,  4, }, // Asia/Riyadh
    {   60, 7245,   26906, 10, }, // Asia/Samarkand
    {   60, 3279,    7798,  4, }, // Asia/Seoul
    {   60, 3300,   20900,  8, }, // Asia/Singapore
    {   60, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {   60, 4781,   26916,  7, }, // Asia/Tashkent
    {   60, 2772,    7842,  7, }, // Asia/Tehran
    {   60, 2821,    4356,  5, }, // Asia/Tokyo
    {   60, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {   60, 1159,   26933,  6, }, // Asia/Urumqi
    {   60, 6977,   26939,  8, }, // Asia/Vientiane
    {   60, 4828,    7873,  7, }, // Asia/Yakutsk
    {   60, 1235,     477,  6, }, // Asia/Yangon
    {   60, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {   60, 3747,   26947,  6, }, // Asia/Yerevan
    {   60, 3663,   26953,  7, }, // Atlantic/Azores
    {   60, 6628,   26960,  8, }, // Atlantic/Canary
    {   60, 3727,   26968, 10, }, // Atlantic/Cape_Verde
    {   60, 1395,     483,  5, }, // Atlantic/Faroe
    {   60, 7272,   26978, 19, }, // Atlantic/South_Georgia
    {   60, 6821,   26997, 12, }, // Atlantic/St_Helena
    {   60, 2300,   27009,  6, }, // Europe/Athens
    {   60, 6336,   27015,  7, }, // Europe/Belgrade
    {   60, 2167,   27022,  7, }, // Europe/Brussels
    {   60, 3928,   27029,  8, }, // Europe/Bucharest
    {   60, 8772,   27037,  8, }, // Europe/Busingen
    {   60, 6289,    4475,  9, }, // Europe/Copenhagen
    {   60, 8788,   27045,  9, }, // Europe/Guernsey
    {   60, 8804,   27054, 11, }, // Europe/Isle_of_Man
    {   60, 2527,    8148,  4, }, // Europe/Kyiv
    {   60, 3213,   21137,  6, }, // Europe/Lisbon
    {   60, 2501,   21152,  7, }, // Europe/London
    {   60, 6365,   27065, 10, }, // Europe/Luxembourg
    {   60, 4892,   27075,  6, }, // Europe/Madrid
    {   60, 6410,    6044,  6, }, // Europe/Monaco
    {   60, 3537,   27081,  5, }, // Europe/Moscow
    {   60, 6275,   21185,  5, }, // Europe/Prague
    {   60, 6324,   27086,  6, }, // Europe/Rome
    {   60, 6202,   21213,  6, }, // Europe/Tirane
    {   60, 8882,   27092,  9, }, // Europe/Ulyanovsk
    {   60, 6567,   27101, 14, }, // Europe/Vatican
    {   60, 6231,   21230,  5, }, // Europe/Vienna
    {   60, 3190,   21244,  8, }, // Europe/Warsaw
    {   60, 6540,    4577,  6, }, // Europe/Zurich
    {   60, 7260,   27115,  4, }, // Indian/Mahe
    {   60, 7050,   27119,  8, }, // Indian/Maldives
    {   60, 4069,   27127,  8, }, // Indian/Mauritius
    {   60, 7211,     547,  7, }, // Indian/Reunion
    {   60, 3157,     554,  5, }, // Pacific/Chuuk
    {   60, 2237,   27135, 13, }, // Pacific/Easter
    {   60, 7360,   27148,  5, }, // Pacific/Efate
    {   60, 6678,   27153, 10, }, // Pacific/Galapagos
    {   60, 2723,    4611,  8, }, // Pacific/Honolulu
    {   60, 3049,    4619,  9, }, // Pacific/Kanton
    {   60, 4051,   27163,  8, }, // Pacific/Marquesas
    {   60, 7098,    4628,  6, }, // Pacific/Noumea
    {   60, 3096,     586,  7, }, // Pacific/Pohnpei
    {   61, 6788,   27171,  7, }, // Africa/Abidjan Belarusian/Cyrillic/Belarus
    {   61, 6760,   27178,  4, }, // Africa/Accra
    {   61, 5059,   27182, 10, }, // Africa/Addis_Ababa
    {   61, 7420,   27192,  5, }, // Africa/Algiers
    {   61,   14,   27197,  6, }, // Africa/Asmara
    {   61,   44,     637,  6, }, // Africa/Bamako
    {   61, 5257,   27203,  5, }, // Africa/Bangui
    {   61, 6746,   27208,  7, }, // Africa/Banjul
    {   61, 7435,   27215,  5, }, // Africa/Bissau
    {   61, 4957,   27220,  8, }, // Africa/Blantyre
    {   61, 5287,   27228,  9, }, // Africa/Brazzaville
    {   61, 4922,     676,  9, }, // Africa/Bujumbura
    {   61, 2320,   27237,  4, }, // Africa/Cairo
    {   61, 4117,     689, 10, }, // Africa/Casablanca
    {   61, 7449,     699,  5, }, // Africa/Ceuta
    {   61, 6773,   27241,  7, }, // Africa/Conakry
    {   61, 6840,     711,  5, }, // Africa/Dakar
    {   61, 5130,   27248, 12, }, // Africa/Dar_es_Salaam
    {   61, 5043,   27260,  7, }, // Africa/Djibouti
    {   61, 5243,     734,  5, }, // Africa/Douala
    {   61, 5166,   27267,  7, }, // Africa/El_Aaiun
    {   61, 6853,   27274,  7, }, // Africa/Freetown
    {   61, 4906,   27281,  8, }, // Africa/Gaborone
    {   61, 5015,   27289,  6, }, // Africa/Harare
    {   61, 4479,   27295, 10, }, // Africa/Johannesburg
    {   61, 4499,   27305,  5, }, // Africa/Juba
    {   61, 5151,     783,  7, }, // Africa/Kampala
    {   61, 4524,     790,  6, }, // Africa/Khartoum
    {   61, 4973,   27310,  6, }, // Africa/Kigali
    {   61, 5306,   27316,  7, }, // Africa/Kinshasa
    {   61, 4744,   27323,  5, }, // Africa/Lagos
    {   61, 5336,   27328,  9, }, // Africa/Libreville
    {   61, 6869,   27337,  4, }, // Africa/Lome
    {   61, 5211,     826,  6, }, // Africa/Luanda
    {   61, 4939,   27341,  9, }, // Africa/Lubumbashi
    {   61, 5001,     841,  6, }, // Africa/Lusaka
    {   61, 5322,   27350,  6, }, // Africa/Malabo
    {   61, 4987,     853,  6, }, // Africa/Maputo
    {   61, 5197,     859,  6, }, // Africa/Maseru
    {   61, 5182,   27356,  7, }, // Africa/Mbabane
    {   61, 5113,   27363,  8, }, // Africa/Mogadishu
    {   61, 7034,   27371,  8, }, // Africa/Monrovia
    {   61, 3853,   27379,  7, }, // Africa/Nairobi
    {   61, 5271,   27386,  8, }, // Africa/Ndjamena
    {   61, 5354,   27394,  6, }, // Africa/Niamey
    {   61, 6803,     908,  7, }, // Africa/Nouakchott
    {   61, 6727,     915,  8, }, // Africa/Ouagadougou
    {   61, 5225,   27400, 10, }, // Africa/Porto-Novo
    {   61, 4435,   27410,  8, }, // Africa/Sao_Tome
    {   61, 2866,   27418,  7, }, // Africa/Tripoli
    {   61, 6554,   27425,  5, }, // Africa/Tunis
    {   61, 4152,   27430,  7, }, // Africa/Windhoek
    {   61,  132,     960,  4, }, // America/Adak
    {   61, 3346,   27437,  8, }, // America/Anchorage
    {   61, 5607,   27445,  7, }, // America/Anguilla
    {   61, 5624,   27452,  7, }, // America/Antigua
    {   61, 4554,   27459,  9, }, // America/Araguaina
    {   61,  166,   27468, 12, }, // America/Argentina/Buenos_Aires
    {   61,   91,    1006,  9, }, // America/Argentina/Catamarca
    {   61,  270,   27480,  7, }, // America/Argentina/Cordoba
    {   61,  441,   27487,  5, }, // America/Argentina/Jujuy
    {   61, 7462,   27492,  8, }, // America/Argentina/La_Rioja
    {   61,  565,    1035,  7, }, // America/Argentina/Mendoza
    {   61, 7489,   27500, 12, }, // America/Argentina/Rio_Gallegos
    {   61, 7520,   27512,  6, }, // America/Argentina/Salta
    {   61, 7544,    1058,  8, }, // America/Argentina/San_Juan
    {   61, 5580,   27518,  8, }, // America/Argentina/San_Luis
    {   61, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {   61, 7597,   27526,  5, }, // America/Argentina/Ushuaia
    {   61, 5640,    1087,  5, }, // America/Aruba
    {   61, 4252,   27531,  8, }, // America/Asuncion
    {   61,  237,   27539,  8, }, // America/Atikokan
    {   61, 3679,   27547,  4, }, // America/Bahia
    {   61, 7623,   27551, 16, }, // America/Bahia_Banderas
    {   61, 5654,   27567,  8, }, // America/Barbados
    {   61, 7646,    1139,  5, }, // America/Belem
    {   61, 5407,   27575,  5, }, // America/Belize
    {   61, 7660,    1149, 12, }, // America/Blanc-Sablon
    {   61, 7681,   27580,  9, }, // America/Boa_Vista
    {   61, 4361,   27589,  6, }, // America/Bogota
    {   61, 7699,   27595,  5, }, // America/Boise
    {   61, 7713,   27600, 12, }, // America/Cambridge_Bay
    {   61, 7735,   27612, 12, }, // America/Campo_Grande
    {   61, 3868,    1205,  6, }, // America/Cancun
    {   61, 4694,    1211,  7, }, // America/Caracas
    {   61, 4345,   27624,  5, }, // America/Cayenne
    {   61, 5496,   27629, 17, }, // America/Cayman
    {   61, 2260,   27646,  6, }, // America/Chicago
    {   61, 7756,   27652,  6, }, // America/Chihuahua
    {   61, 7774,   27658, 13, }, // America/Ciudad_Juarez
    {   61, 5422,   27671, 10, }, // America/Costa_Rica
    {   61, 7796,   27681,  7, }, // America/Creston
    {   61, 3791,   27688,  5, }, // America/Cuiaba
    {   61, 5723,   27693,  7, }, // America/Curacao
    {   61, 7812,   27700, 12, }, // America/Danmarkshavn
    {   61, 7833,   27712,  6, }, // America/Dawson
    {   61, 7848,   27718, 10, }, // America/Dawson_Creek
    {   61,  805,   27728,  6, }, // America/Denver
    {   61, 3465,   27734,  7, }, // America/Detroit
    {   61, 5739,   27741,  8, }, // America/Dominica
    {   61,  893,   27749,  8, }, // America/Edmonton
    {   61, 7869,   27757,  8, }, // America/Eirunepe
    {   61, 5441,   27765,  9, }, // America/El_Salvador
    {   61, 7886,   27774, 12, }, // America/Fort_Nelson
    {   61, 7906,   27786,  9, }, // America/Fortaleza
    {   61, 7924,   27795,  9, }, // America/Glace_Bay
    {   61, 6881,   27804,  7, }, // America/Goose_Bay
    {   61, 4612,   27811, 10, }, // America/Grand_Turk
    {   61, 5770,   27821,  7, }, // America/Grenada
    {   61, 5786,   27828,  9, }, // America/Guadeloupe
    {   61, 3760,   27837,  9, }, // America/Guatemala
    {   61, 4841,   27846,  8, }, // America/Guayaquil
    {   61, 6932,   27854,  5, }, // America/Guyana
    {   61, 1939,   27859,  8, }, // America/Halifax
    {   61, 2281,    1457,  6, }, // America/Havana
    {   61, 7942,   27867,  9, }, // America/Hermosillo
    {   61,  348,   27876, 12, }, // America/Indiana/Indianapolis
    {   61,  481,   27888, 13, }, // America/Indiana/Knox
    {   61, 7961,   27901, 16, }, // America/Indiana/Marengo
    {   61, 7985,   27917, 19, }, // America/Indiana/Petersburg
    {   61, 8012,   27936, 17, }, // America/Indiana/Tell_City
    {   61, 8038,   27953, 13, }, // America/Indiana/Vevay
    {   61, 8060,   27966, 16, }, // America/Indiana/Vincennes
    {   61, 8086,   27982, 16, }, // America/Indiana/Winamac
    {   61, 8110,   27998,  6, }, // America/Inuvik
    {   61,  660,   28004,  7, }, // America/Iqaluit
    {   61, 2799,   28011,  6, }, // America/Jamaica
    {   61, 5380,   28017,  5, }, // America/Juneau
    {   61,  521,   28022,  7, }, // America/Kentucky/Louisville
    {   61, 8125,   28029, 18, }, // America/Kentucky/Monticello
    {   61, 5704,   28047, 10, }, // America/Kralendijk
    {   61, 4376,    1632,  6, }, // America/La_Paz
    {   61, 7169,   28057,  4, }, // America/Lima
    {   61, 3239,   28061, 12, }, // America/Los_Angeles
    {   61, 5932,   28073, 20, }, // America/Lower_Princes
    {   61, 8153,   28093,  5, }, // America/Maceio
    {   61, 8168,    1677,  7, }, // America/Managua
    {   61, 1908,   28098,  6, }, // America/Manaus
    {   61, 5897,   28104,  6, }, // America/Marigot
    {   61, 5805,   28110,  9, }, // America/Martinique
    {   61, 8184,   28119,  9, }, // America/Matamoros
    {   61, 2917,    1714,  8, }, // America/Mazatlan
    {   61, 8202,   28128,  8, }, // America/Menominee
    {   61, 8220,   28136,  6, }, // America/Merida
    {   61, 8235,    1736, 10, }, // America/Metlakatla
    {   61, 2949,   28142,  6, }, // America/Mexico_City
    {   61, 4391,   28148,  7, }, // America/Miquelon
    {   61, 8254,   28155,  7, }, // America/Moncton
    {   61, 8270,   28162,  8, }, // America/Monterrey
    {   61, 4098,   28170, 10, }, // America/Montevideo
    {   61, 5824,   28180,  9, }, // America/Montserrat
    {   61, 5481,   28189,  5, }, // America/Nassau
    {   61, 2379,   28194,  7, }, // America/New_York
    {   61, 8288,    1809,  3, }, // America/Nome
    {   61, 1850,   28201,  7, }, // America/Noronha
    {   61, 8301,   28208, 23, }, // America/North_Dakota/Beulah
    {   61, 8329,   28231, 24, }, // America/North_Dakota/Center
    {   61, 8357,   28255, 28, }, // America/North_Dakota/New_Salem
    {   61,  393,   28283,  3, }, // America/Nuuk
    {   61, 8388,   28286,  7, }, // America/Ojinaga
    {   61, 2356,    1901,  6, }, // America/Panama
    {   61, 6173,   28293, 10, }, // America/Paramaribo
    {   61, 2973,   28303,  6, }, // America/Phoenix
    {   61, 3945,   28309, 12, }, // America/Port-au-Prince
    {   61, 5954,   28321, 13, }, // America/Port_of_Spain
    {   61, 8404,   28334, 11, }, // America/Porto_Velho
    {   61, 5843,   28345, 11, }, // America/Puerto_Rico
    {   61, 4030,   28356, 12, }, // America/Punta_Arenas
    {   61, 8424,   28368, 12, }, // America/Rankin_Inlet
    {   61, 8445,   28380,  6, }, // America/Recife
    {   61, 1995,   28386,  8, }, // America/Regina
    {   61, 8460,   28394,  8, }, // America/Resolute
    {   61,  695,   28402, 10, }, // America/Rio_Branco
    {   61, 8477,   28412,  8, }, // America/Santarem
    {   61, 2201,   28420,  8, }, // America/Santiago
    {   61, 6111,   28428, 13, }, // America/Santo_Domingo
    {   61, 1878,   28441,  9, }, // America/Sao_Paulo
    {   61, 6899,   28450, 13, }, // America/Scoresbysund
    {   61, 8494,   28463,  5, }, // America/Sitka
    {   61, 8508,   28468, 13, }, // America/St_Barthelemy
    {   61, 2061,   28481, 10, }, // America/St_Johns
    {   61, 5863,   28491,  9, }, // America/St_Kitts
    {   61, 5880,   28500, 10, }, // America/St_Lucia
    {   61,  855,    2121, 10, }, // America/St_Thomas
    {   61, 5913,   28510, 12, }, // America/St_Vincent
    {   61, 8530,   28522, 12, }, // America/Swift_Current
    {   61, 5461,   28534, 12, }, // America/Tegucigalpa
    {   61, 5756,    2167,  4, }, // America/Thule
    {   61,  313,   28546,  7, }, // America/Tijuana
    {   61,  608,   28553,  7, }, // America/Toronto
    {   61, 5688,   28560,  7, }, // America/Tortola
    {   61, 2093,    2192,  8, }, // America/Vancouver
    {   61, 2144,   28567,  8, }, // America/Whitehorse
    {   61,  734,   28575,  7, }, // America/Winnipeg
    {   61, 8552,   28582,  6, }, // America/Yakutat
    {   61, 6001,   28588,  5, }, // Antarctica/Casey
    {   61, 6094,   28593,  6, }, // Antarctica/Davis
    {   61, 6133,   28599, 15, }, // Antarctica/DumontDUrville
    {   61, 8568,   28614,  7, }, // Antarctica/Macquarie
    {   61, 7066,   28621,  6, }, // Antarctica/Mawson
    {   61, 7113,   28627,  9, }, // Antarctica/McMurdo
    {   61, 8589,    2272,  6, }, // Antarctica/Palmer
    {   61, 7226,   28636,  6, }, // Antarctica/Rothera
    {   61, 7295,   28642,  4, }, // Antarctica/Syowa
    {   61, 8607,    2289,  4, }, // Antarctica/Troll
    {   61, 7374,   28646,  6, }, // Antarctica/Vostok
    {   61, 1429,   28652,  7, }, // Arctic/Longyearbyen
    {   61, 5570,   28659,  4, }, // Asia/Aden
    {   61, 5395,    2314,  6, }, // Asia/Almaty
    {   61, 3968,   28663, 12, }, // Asia/Amman
    {   61, 5511,    2325,  6, }, // Asia/Anadyr
    {   61, 5523,    2331,  5, }, // Asia/Aqtau
    {   61, 5368,   28675,  6, }, // Asia/Aqtobe
    {   61,  964,   28681,  7, }, // Asia/Ashgabat
    {   61, 8624,    2349,  6, }, // Asia/Atyrau
    {   61, 3607,    2355,  6, }, // Asia/Baghdad
    {   61, 5534,   28688,  7, }, // Asia/Bahrain
    {   61, 3653,    2368,  4, }, // Asia/Baku
    {   61, 4466,    2372,  7, }, // Asia/Bangkok
    {   61, 3571,    2379,  7, }, // Asia/Barnaul
    {   61, 4086,   28695,  6, }, // Asia/Beirut
    {   61, 3778,   28701,  6, }, // Asia/Bishkek
    {   61, 5989,   28707,  6, }, // Asia/Brunei
    {   61, 4601,   28713,  4, }, // Asia/Chita
    {   61, 4511,   28717,  7, }, // Asia/Colombo
    {   61, 4540,    2415,  6, }, // Asia/Damascus
    {   61, 1093,     711,  4, }, // Asia/Dhaka
    {   61, 6192,   28724,  4, }, // Asia/Dili
    {   61, 3596,   28728,  5, }, // Asia/Dubai
    {   61, 6159,   28733,  7, }, // Asia/Dushanbe
    {   61, 8636,    2442,  9, }, // Asia/Famagusta
    {   61, 8651,    2451,  4, }, // Asia/Gaza
    {   61, 4795,   28740,  6, }, // Asia/Hebron
    {   61, 1259,   28746,  7, }, // Asia/Ho_Chi_Minh
    {   61, 2704,   28753,  7, }, // Asia/Hong_Kong
    {   61, 4771,   28760,  4, }, // Asia/Hovd
    {   61, 4184,   28764,  6, }, // Asia/Irkutsk
    {   61, 7006,   28770,  8, }, // Asia/Jakarta
    {   61, 6992,   28778,  8, }, // Asia/Jayapura
    {   61, 1290,   28786,  9, }, // Asia/Jerusalem
    {   61, 3560,    2510,  5, }, // Asia/Kabul
    {   61, 4316,    2529,  8, }, // Asia/Kamchatka
    {   61, 4239,   28795,  6, }, // Asia/Karachi
    {   61, 1185,    2546,  8, }, // Asia/Kathmandu
    {   61, 8661,    2554,  7, }, // Asia/Khandyga
    {   61,  992,   28801,  8, }, // Asia/Kolkata
    {   61, 4197,   28809, 10, }, // Asia/Krasnoyarsk
    {   61, 4859,    2580, 12, }, // Asia/Kuala_Lumpur
    {   61, 5976,   28819,  6, }, // Asia/Kuching
    {   61, 5547,   28825,  6, }, // Asia/Kuwait
    {   61, 1211,   28831,  5, }, // Asia/Macau
    {   61, 4017,    2609,  7, }, // Asia/Magadan
    {   61, 1349,    2616,  7, }, // Asia/Makassar
    {   61, 7182,   28836,  6, }, // Asia/Manila
    {   61, 6920,    2629,  6, }, // Asia/Muscat
    {   61, 2554,   28842,  7, }, // Asia/Nicosia
    {   61, 8675,   28849, 11, }, // Asia/Novokuznetsk
    {   61, 4135,   28860, 11, }, // Asia/Novosibirsk
    {   61, 4229,    2664,  4, }, // Asia/Omsk
    {   61, 7145,   28871,  7, }, // Asia/Oral
    {   61, 6961,   28878,  8, }, // Asia/Phnom_Penh
    {   61, 8693,   28886,  9, }, // Asia/Pontianak
    {   61, 4214,   28895,  7, }, // Asia/Pyongyang
    {   61, 5559,    2697,  5, }, // Asia/Qatar
    {   61, 8708,   28902,  8, }, // Asia/Qostanay
    {   61, 4269,   28910,  9, }, // Asia/Qyzylorda
    {   61, 3584,   28919,  7, }, // Asia/Riyadh
    {   61, 4408,   28926,  7, }, // Asia/Sakhalin
    {   61, 7245,    2739,  9, }, // Asia/Samarkand
    {   61, 3279,    2748,  4, }, // Asia/Seoul
    {   61, 1053,   28933,  6, }, // Asia/Shanghai
    {   61, 3300,   28939,  8, }, // Asia/Singapore
    {   61, 4297,   28947, 14, }, // Asia/Srednekolymsk
    {   61, 3263,   28961,  6, }, // Asia/Taipei
    {   61, 4781,    2785,  7, }, // Asia/Tashkent
    {   61, 3915,   28967,  7, }, // Asia/Tbilisi
    {   61, 2772,   28974,  7, }, // Asia/Tehran
    {   61, 1317,   28981,  7, }, // Asia/Thimphu
    {   61, 2821,   28988,  5, }, // Asia/Tokyo
    {   61, 4572,    2815,  5, }, // Asia/Tomsk
    {   61, 1021,   28993, 10, }, // Asia/Ulaanbaatar
    {   61, 1159,   29003,  6, }, // Asia/Urumqi
    {   61, 8722,   29009,  9, }, // Asia/Ust-Nera
    {   61, 6977,   29018,  8, }, // Asia/Vientiane
    {   61, 4710,   29026, 12, }, // Asia/Vladivostok
    {   61, 4828,   29038,  5, }, // Asia/Yakutsk
    {   61, 1235,   29043,  6, }, // Asia/Yangon
    {   61, 3883,   29049, 12, }, // Asia/Yekaterinburg
    {   61, 3747,   29061,  6, }, // Asia/Yerevan
    {   61, 3663,   29067, 16, }, // Atlantic/Azores
    {   61, 5671,   29083, 18, }, // Atlantic/Bermuda
    {   61, 6628,   29101, 17, }, // Atlantic/Canary
    {   61, 3727,   29118, 10, }, // Atlantic/Cape_Verde
    {   61, 1395,   29128, 17, }, // Atlantic/Faroe
    {   61, 8736,   29145,  7, }, // Atlantic/Madeira
    {   61, 2748,   29152,  9, }, // Atlantic/Reykjavik
    {   61, 7272,   29161, 17, }, // Atlantic/South_Georgia
    {   61, 6821,   29178, 20, }, // Atlantic/St_Helena
    {   61, 6644,   29198, 11, }, // Atlantic/Stanley
    {   61, 1670,   29209,  8, }, // Australia/Adelaide
    {   61, 1635,   29217,  7, }, // Australia/Brisbane
    {   61, 1799,   29224, 10, }, // Australia/Broken_Hill
    {   61, 1583,   29234,  6, }, // Australia/Darwin
    {   61, 3637,   29240,  4, }, // Australia/Eucla
    {   61, 1516,    3072,  6, }, // Australia/Hobart
    {   61, 8753,   29244,  8, }, // Australia/Lindeman
    {   61, 1547,    3086,  8, }, // Australia/Lord_Howe
    {   61, 1727,   29252,  8, }, // Australia/Melbourne
    {   61, 1762,    3101,  4, }, // Australia/Perth
    {   61, 1463,   29260,  6, }, // Australia/Sydney
    {   61, 6441,   29266,  9, }, // Europe/Amsterdam
    {   61, 6216,   29275,  6, }, // Europe/Andorra
    {   61, 3620,   29281,  9, }, // Europe/Astrakhan
    {   61, 2300,   29290,  5, }, // Europe/Athens
    {   61, 6336,   29295,  7, }, // Europe/Belgrade
    {   61, 4757,   29302,  6, }, // Europe/Berlin
    {   61, 6488,   29308, 10, }, // Europe/Bratislava
    {   61, 2167,   29318,  7, }, // Europe/Brussels
    {   61, 3928,   29325,  8, }, // Europe/Bucharest
    {   61, 3806,    3178,  8, }, // Europe/Budapest
    {   61, 8772,   29333,  8, }, // Europe/Busingen
    {   61, 2583,   29341,  7, }, // Europe/Chisinau
    {   61, 6289,   29348, 10, }, // Europe/Copenhagen
    {   61, 2338,   29358,  6, }, // Europe/Dublin
    {   61, 6307,   29364,  9, }, // Europe/Gibraltar
    {   61, 8788,   29373,  6, }, // Europe/Guernsey
    {   61, 6612,   29379,  9, }, // Europe/Helsinki
    {   61, 8804,   29388, 11, }, // Europe/Isle_of_Man
    {   61, 1130,    3264,  7, }, // Europe/Istanbul
    {   61, 8823,   29399,  6, }, // Europe/Jersey
    {   61, 3979,   29405, 11, }, // Europe/Kaliningrad
    {   61, 8929,   29416,  5, }, // Europe/Kirov
    {   61, 2527,   29421,  4, }, // Europe/Kyiv
    {   61, 3213,   29425,  7, }, // Europe/Lisbon
    {   61, 6506,   29432,  7, }, // Europe/Ljubljana
    {   61, 2501,   29439,  6, }, // Europe/London
    {   61, 6365,   29445, 10, }, // Europe/Luxembourg
    {   61, 4892,   29455,  6, }, // Europe/Madrid
    {   61, 6397,   29461,  6, }, // Europe/Malta
    {   61, 6582,   29467, 12, }, // Europe/Mariehamn
    {   61, 3693,   29479,  5, }, // Europe/Minsk
    {   61, 6410,   29484,  6, }, // Europe/Monaco
    {   61, 3537,   29490,  6, }, // Europe/Moscow
    {   61, 6458,   29496,  4, }, // Europe/Oslo
    {   61, 4284,   29500,  5, }, // Europe/Paris
    {   61, 6424,   29505,  9, }, // Europe/Podgorica
    {   61, 6275,    3385,  5, }, // Europe/Prague
    {   61, 8837,   29514,  4, }, // Europe/Riga
    {   61, 6324,   29518,  3, }, // Europe/Rome
    {   61, 4331,    3397,  6, }, // Europe/Samara
    {   61, 6470,   29521, 10, }, // Europe/San_Marino
    {   61, 6245,   29531,  7, }, // Europe/Sarajevo
    {   61, 4451,   29538,  7, }, // Europe/Saratov
    {   61, 8849,   29545, 11, }, // Europe/Simferopol
    {   61, 6383,   29556,  6, }, // Europe/Skopje
    {   61, 6599,   29562,  5, }, // Europe/Sofia
    {   61, 6523,   29567,  9, }, // Europe/Stockholm
    {   61, 8867,   29576,  5, }, // Europe/Tallinn
    {   61, 6202,   29581,  6, }, // Europe/Tirane
    {   61, 8882,   29587,  9, }, // Europe/Ulyanovsk
    {   61, 6352,    3476,  5, }, // Europe/Vaduz
    {   61, 6567,   29596,  7, }, // Europe/Vatican
    {   61, 6231,    3488,  4, }, // Europe/Vienna
    {   61, 8899,   29603,  7, }, // Europe/Vilnius
    {   61, 4727,   29610,  9, }, // Europe/Volgograd
    {   61, 3190,    3508,  7, }, // Europe/Warsaw
    {   61, 6261,   29619,  6, }, // Europe/Zagreb
    {   61, 6540,   29625,  5, }, // Europe/Zurich
    {   61, 5078,   29630, 12, }, // Indian/Antananarivo
    {   61, 6947,   29642,  5, }, // Indian/Chagos
    {   61, 6046,   29647, 13, }, // Indian/Christmas
    {   61, 6063,   29660, 17, }, // Indian/Cocos
    {   61, 5029,   29677, 17, }, // Indian/Comoro
    {   61, 6661,    3578,  8, }, // Indian/Kerguelen
    {   61, 7260,   29694,  3, }, // Indian/Mahe
    {   61, 7050,   29697,  8, }, // Indian/Maldives
    {   61, 4069,   29705,  8, }, // Indian/Mauritius
    {   61, 5098,   29713,  5, }, // Indian/Mayotte
    {   61, 7211,   29718,  7, }, // Indian/Reunion
    {   61, 4422,   29725,  4, }, // Pacific/Apia
    {   61,  932,    3620,  6, }, // Pacific/Auckland
    {   61, 3706,   29729,  9, }, // Pacific/Bougainville
    {   61, 3015,   29738,  5, }, // Pacific/Chatham
    {   61, 3157,    3639,  4, }, // Pacific/Chuuk
    {   61, 2237,   29743, 17, }, // Pacific/Easter
    {   61, 7360,   29760,  5, }, // Pacific/Efate
    {   61, 7327,   29765,  7, }, // Pacific/Fakaofo
    {   61, 3902,   29772,  5, }, // Pacific/Fiji
    {   61, 7343,   29777,  8, }, // Pacific/Funafuti
    {   61, 6678,   29785,  9, }, // Pacific/Galapagos
    {   61, 6696,   29794, 14, }, // Pacific/Gambier
    {   61, 3822,    3713, 11, }, // Pacific/Guadalcanal
    {   61, 6018,    3724,  4, }, // Pacific/Guam
    {   61, 2723,   29808,  8, }, // Pacific/Honolulu
    {   61, 3049,   29816,  9, }, // Pacific/Kanton
    {   61, 3998,   29825, 10, }, // Pacific/Kiritimati
    {   61, 7019,   29835,  6, }, // Pacific/Kosrae
    {   61, 2842,   29841, 10, }, // Pacific/Kwajalein
    {   61, 4877,   29851,  7, }, // Pacific/Majuro
    {   61, 4051,   29858, 18, }, // Pacific/Marquesas
    {   61, 8914,   29876,  6, }, // Pacific/Midway
    {   61, 7084,    3798,  5, }, // Pacific/Nauru
    {   61, 7132,   29882,  4, }, // Pacific/Niue
    {   61, 4168,   29886,  7, }, // Pacific/Norfolk
    {   61, 7098,    3814,  5, }, // Pacific/Noumea
    {   61, 3126,   29893,  9, }, // Pacific/Pago_Pago
    {   61, 7155,    3828,  5, }, // Pacific/Palau
    {   61, 7194,   29902,  7, }, // Pacific/Pitcairn
    {   61, 3096,   29909,  6, }, // Pacific/Pohnpei
    {   61, 4807,   29915, 11, }, // Pacific/Port_Moresby
    {   61, 6076,   29926,  9, }, // Pacific/Rarotonga
    {   61, 6031,   29935,  6, }, // Pacific/Saipan
    {   61, 7312,   29941,  5, }, // Pacific/Tahiti
    {   61, 6712,    3877,  6, }, // Pacific/Tarawa
    {   61, 4583,   29946,  9, }, // Pacific/Tongatapu
    {   61, 7392,   29955,  4, }, // Pacific/Wake
    {   61, 7405,   29959,  5, }, // Pacific/Wallis
    {   62,   14,       0,  6, }, // Africa/Asmara Bemba/Latin/Zambia
    {   62, 4435,       6,  8, }, // Africa/Sao_Tome
    {   62, 4252,      14,  8, }, // America/Asuncion
    {   62,  237,      22,  8, }, // America/Atikokan
    {   62, 7623,      30, 17, }, // America/Bahia_Banderas
    {   62, 3868,      47,  6, }, // America/Cancun
    {   62, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   62, 5723,      66,  7, }, // America/Curacao
    {   62,  481,      73, 13, }, // America/Indiana/Knox
    {   62, 7961,      86, 16, }, // America/Indiana/Marengo
    {   62, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   62, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   62, 8038,     139, 14, }, // America/Indiana/Vevay
    {   62, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   62, 8086,     171, 16, }, // America/Indiana/Winamac
    {   62, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   62, 5932,     207, 22, }, // America/Lower_Princes
    {   62, 8220,     229,  6, }, // America/Merida
    {   62, 1850,     235, 19, }, // America/Noronha
    {   62, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   62, 8329,     274, 20, }, // America/North_Dakota/Center
    {   62, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   62,  393,     317,  4, }, // America/Nuuk
    {   62, 6899,     321, 16, }, // America/Scoresbysund
    {   62, 8508,     337, 14, }, // America/St_Barthelemy
    {   62, 2061,     351, 10, }, // America/St_Johns
    {   62, 5863,     361,  9, }, // America/St_Kitts
    {   62, 5880,     370,  9, }, // America/St_Lucia
    {   62,  855,     379, 10, }, // America/St_Thomas
    {   62, 5913,     389, 11, }, // America/St_Vincent
    {   62, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   62, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   62, 1185,     448,  9, }, // Asia/Kathmandu
    {   62,  992,     457,  7, }, // Asia/Kolkata
    {   62, 1211,     464,  5, }, // Asia/Macau
    {   62, 1235,     477,  6, }, // Asia/Yangon
    {   62, 1395,     483,  5, }, // Atlantic/Faroe
    {   62, 6821,     488, 10, }, // Atlantic/St_Helena
    {   62, 2527,     514,  4, }, // Europe/Kyiv
    {   62, 7211,     547,  7, }, // Indian/Reunion
    {   62, 3157,     554,  5, }, // Pacific/Chuuk
    {   62, 3096,     586,  7, }, // Pacific/Pohnpei
    {   63,   14,       0,  6, }, // Africa/Asmara Bena/Latin/Tanzania
    {   63, 4435,       6,  8, }, // Africa/Sao_Tome
    {   63, 4252,      14,  8, }, // America/Asuncion
    {   63,  237,      22,  8, }, // America/Atikokan
    {   63, 7623,      30, 17, }, // America/Bahia_Banderas
    {   63, 3868,      47,  6, }, // America/Cancun
    {   63, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   63, 5723,      66,  7, }, // America/Curacao
    {   63,  481,      73, 13, }, // America/Indiana/Knox
    {   63, 7961,      86, 16, }, // America/Indiana/Marengo
    {   63, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   63, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   63, 8038,     139, 14, }, // America/Indiana/Vevay
    {   63, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   63, 8086,     171, 16, }, // America/Indiana/Winamac
    {   63, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   63, 5932,     207, 22, }, // America/Lower_Princes
    {   63, 8220,     229,  6, }, // America/Merida
    {   63, 1850,     235, 19, }, // America/Noronha
    {   63, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   63, 8329,     274, 20, }, // America/North_Dakota/Center
    {   63, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   63,  393,     317,  4, }, // America/Nuuk
    {   63, 6899,     321, 16, }, // America/Scoresbysund
    {   63, 8508,     337, 14, }, // America/St_Barthelemy
    {   63, 2061,     351, 10, }, // America/St_Johns
    {   63, 5863,     361,  9, }, // America/St_Kitts
    {   63, 5880,     370,  9, }, // America/St_Lucia
    {   63,  855,     379, 10, }, // America/St_Thomas
    {   63, 5913,     389, 11, }, // America/St_Vincent
    {   63, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   63, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   63, 1185,     448,  9, }, // Asia/Kathmandu
    {   63,  992,     457,  7, }, // Asia/Kolkata
    {   63, 1211,     464,  5, }, // Asia/Macau
    {   63, 1235,     477,  6, }, // Asia/Yangon
    {   63, 1395,     483,  5, }, // Atlantic/Faroe
    {   63, 6821,     488, 10, }, // Atlantic/St_Helena
    {   63, 2527,     514,  4, }, // Europe/Kyiv
    {   63, 7211,     547,  7, }, // Indian/Reunion
    {   63, 3157,     554,  5, }, // Pacific/Chuuk
    {   63, 3096,     586,  7, }, // Pacific/Pohnpei
    {   64,   14,       0,  6, }, // Africa/Asmara Bhojpuri/Devanagari/India
    {   64, 4435,       6,  8, }, // Africa/Sao_Tome
    {   64, 4252,      14,  8, }, // America/Asuncion
    {   64,  237,      22,  8, }, // America/Atikokan
    {   64, 7623,      30, 17, }, // America/Bahia_Banderas
    {   64, 3868,      47,  6, }, // America/Cancun
    {   64, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   64, 5723,      66,  7, }, // America/Curacao
    {   64,  481,      73, 13, }, // America/Indiana/Knox
    {   64, 7961,      86, 16, }, // America/Indiana/Marengo
    {   64, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   64, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   64, 8038,     139, 14, }, // America/Indiana/Vevay
    {   64, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   64, 8086,     171, 16, }, // America/Indiana/Winamac
    {   64, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   64, 5932,     207, 22, }, // America/Lower_Princes
    {   64, 8220,     229,  6, }, // America/Merida
    {   64, 1850,     235, 19, }, // America/Noronha
    {   64, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   64, 8329,     274, 20, }, // America/North_Dakota/Center
    {   64, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   64,  393,     317,  4, }, // America/Nuuk
    {   64, 6899,     321, 16, }, // America/Scoresbysund
    {   64, 8508,     337, 14, }, // America/St_Barthelemy
    {   64, 2061,     351, 10, }, // America/St_Johns
    {   64, 5863,     361,  9, }, // America/St_Kitts
    {   64, 5880,     370,  9, }, // America/St_Lucia
    {   64,  855,     379, 10, }, // America/St_Thomas
    {   64, 5913,     389, 11, }, // America/St_Vincent
    {   64, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   64, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   64, 1185,     448,  9, }, // Asia/Kathmandu
    {   64,  992,     457,  7, }, // Asia/Kolkata
    {   64, 1211,     464,  5, }, // Asia/Macau
    {   64, 1235,     477,  6, }, // Asia/Yangon
    {   64, 1395,     483,  5, }, // Atlantic/Faroe
    {   64, 6821,     488, 10, }, // Atlantic/St_Helena
    {   64, 2527,     514,  4, }, // Europe/Kyiv
    {   64, 7211,     547,  7, }, // Indian/Reunion
    {   64, 3157,     554,  5, }, // Pacific/Chuuk
    {   64, 3096,     586,  7, }, // Pacific/Pohnpei
    {   65,   14,       0,  6, }, // Africa/Asmara Blin/Ethiopic/Eritrea
    {   65, 4435,       6,  8, }, // Africa/Sao_Tome
    {   65, 4252,      14,  8, }, // America/Asuncion
    {   65,  237,      22,  8, }, // America/Atikokan
    {   65, 7623,      30, 17, }, // America/Bahia_Banderas
    {   65, 3868,      47,  6, }, // America/Cancun
    {   65, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   65, 5723,      66,  7, }, // America/Curacao
    {   65,  481,      73, 13, }, // America/Indiana/Knox
    {   65, 7961,      86, 16, }, // America/Indiana/Marengo
    {   65, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   65, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   65, 8038,     139, 14, }, // America/Indiana/Vevay
    {   65, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   65, 8086,     171, 16, }, // America/Indiana/Winamac
    {   65, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   65, 5932,     207, 22, }, // America/Lower_Princes
    {   65, 8220,     229,  6, }, // America/Merida
    {   65, 1850,     235, 19, }, // America/Noronha
    {   65, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   65, 8329,     274, 20, }, // America/North_Dakota/Center
    {   65, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   65,  393,     317,  4, }, // America/Nuuk
    {   65, 6899,     321, 16, }, // America/Scoresbysund
    {   65, 8508,     337, 14, }, // America/St_Barthelemy
    {   65, 2061,     351, 10, }, // America/St_Johns
    {   65, 5863,     361,  9, }, // America/St_Kitts
    {   65, 5880,     370,  9, }, // America/St_Lucia
    {   65,  855,     379, 10, }, // America/St_Thomas
    {   65, 5913,     389, 11, }, // America/St_Vincent
    {   65, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   65, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   65, 1185,     448,  9, }, // Asia/Kathmandu
    {   65,  992,     457,  7, }, // Asia/Kolkata
    {   65, 1211,     464,  5, }, // Asia/Macau
    {   65, 1235,     477,  6, }, // Asia/Yangon
    {   65, 1395,     483,  5, }, // Atlantic/Faroe
    {   65, 6821,     488, 10, }, // Atlantic/St_Helena
    {   65, 2527,     514,  4, }, // Europe/Kyiv
    {   65, 7211,     547,  7, }, // Indian/Reunion
    {   65, 3157,     554,  5, }, // Pacific/Chuuk
    {   65, 3096,     586,  7, }, // Pacific/Pohnpei
    {   66, 6788,   29964,  7, }, // Africa/Abidjan Bodo/Devanagari/India
    {   66, 6760,   29971,  5, }, // Africa/Accra
    {   66, 5059,   29976, 12, }, // Africa/Addis_Ababa
    {   66, 7420,   29988,  9, }, // Africa/Algiers
    {   66,   14,   29997,  7, }, // Africa/Asmara
    {   66,   44,   30004,  6, }, // Africa/Bamako
    {   66, 5257,   30010,  6, }, // Africa/Bangui
    {   66, 6746,   30016,  6, }, // Africa/Banjul
    {   66, 7435,   30022,  7, }, // Africa/Bissau
    {   66, 4957,   30029, 10, }, // Africa/Blantyre
    {   66, 5287,   30039, 11, }, // Africa/Brazzaville
    {   66, 4922,   30050, 10, }, // Africa/Bujumbura
    {   66, 2320,   30060,  5, }, // Africa/Cairo
    {   66, 4117,   30065, 11, }, // Africa/Casablanca
    {   66, 7449,   30076,  5, }, // Africa/Ceuta
    {   66, 6773,   30081,  7, }, // Africa/Conakry
    {   66, 6840,   30088,  5, }, // Africa/Dakar
    {   66, 5130,   30093, 11, }, // Africa/Dar_es_Salaam
    {   66, 5043,   30104,  6, }, // Africa/Djibouti
    {   66, 5243,   30110,  5, }, // Africa/Douala
    {   66, 5166,   30115,  7, }, // Africa/El_Aaiun
    {   66, 6853,   30122,  8, }, // Africa/Freetown
    {   66, 4906,   30130,  7, }, // Africa/Gaborone
    {   66, 5015,   30137,  6, }, // Africa/Harare
    {   66, 4479,   30143, 11, }, // Africa/Johannesburg
    {   66, 4499,   30154,  4, }, // Africa/Juba
    {   66, 5151,   30158,  8, }, // Africa/Kampala
    {   66, 4524,   30166,  7, }, // Africa/Khartoum
    {   66, 4973,   30173,  6, }, // Africa/Kigali
    {   66, 5306,   30179,  8, }, // Africa/Kinshasa
    {   66, 4744,   30187,  5, }, // Africa/Lagos
    {   66, 5336,   30192,  9, }, // Africa/Libreville
    {   66, 6869,   30201,  3, }, // Africa/Lome
    {   66, 5211,   30204,  7, }, // Africa/Luanda
    {   66, 4939,   30211, 10, }, // Africa/Lubumbashi
    {   66, 5001,   30221,  6, }, // Africa/Lusaka
    {   66, 5322,   30227,  6, }, // Africa/Malabo
    {   66, 4987,   30233,  6, }, // Africa/Maputo
    {   66, 5197,   30239,  6, }, // Africa/Maseru
    {   66, 5182,   30245,  8, }, // Africa/Mbabane
    {   66, 5113,   30253,  7, }, // Africa/Mogadishu
    {   66, 7034,   30260,  9, }, // Africa/Monrovia
    {   66, 3853,   30269,  7, }, // Africa/Nairobi
    {   66, 5271,   30276,  8, }, // Africa/Ndjamena
    {   66, 5354,   30284,  5, }, // Africa/Niamey
    {   66, 6803,   30289,  8, }, // Africa/Nouakchott
    {   66, 6727,   30297,  7, }, // Africa/Ouagadougou
    {   66, 5225,   30304,  9, }, // Africa/Porto-Novo
    {   66, 4435,   30313,  7, }, // Africa/Sao_Tome
    {   66, 2866,   30320,  8, }, // Africa/Tripoli
    {   66, 6554,   30328,  7, }, // Africa/Tunis
    {   66, 4152,   30335,  8, }, // Africa/Windhoek
    {   66,  132,   30343,  4, }, // America/Adak
    {   66, 3346,   30347,  6, }, // America/Anchorage
    {   66, 5607,   30353,  8, }, // America/Anguilla
    {   66, 5624,   30361,  9, }, // America/Antigua
    {   66, 4554,   30370,  9, }, // America/Araguaina
    {   66,  166,   30379, 11, }, // America/Argentina/Buenos_Aires
    {   66,   91,   30390, 10, }, // America/Argentina/Catamarca
    {   66,  270,   30400,  6, }, // America/Argentina/Cordoba
    {   66,  441,   30406,  5, }, // America/Argentina/Jujuy
    {   66, 7462,   30411,  8, }, // America/Argentina/La_Rioja
    {   66,  565,   30419,  8, }, // America/Argentina/Mendoza
    {   66, 7489,   30427, 10, }, // America/Argentina/Rio_Gallegos
    {   66, 7520,   30437,  6, }, // America/Argentina/Salta
    {   66, 7544,   30443,  9, }, // America/Argentina/San_Juan
    {   66, 5580,   30452,  8, }, // America/Argentina/San_Luis
    {   66, 7571,   30460,  7, }, // America/Argentina/Tucuman
    {   66, 7597,   30467,  8, }, // America/Argentina/Ushuaia
    {   66, 5640,   30475,  5, }, // America/Aruba
    {   66, 4252,   30480,  8, }, // America/Asuncion
    {   66,  237,   30488,  7, }, // America/Atikokan
    {   66, 3679,   30495,  6, }, // America/Bahia
    {   66, 7623,   30501, 16, }, // America/Bahia_Banderas
    {   66, 5654,   30517,  9, }, // America/Barbados
    {   66, 7646,   30526,  5, }, // America/Belem
    {   66, 5407,   30531,  5, }, // America/Belize
    {   66, 7660,   30536, 14, }, // America/Blanc-Sablon
    {   66, 7681,   30550,  9, }, // America/Boa_Vista
    {   66, 4361,   30559,  5, }, // America/Bogota
    {   66, 7699,   30564,  4, }, // America/Boise
    {   66, 7713,   30568, 15, }, // America/Cambridge_Bay
    {   66, 7735,   30583, 13, }, // America/Campo_Grande
    {   66, 3868,   30596,  6, }, // America/Cancun
    {   66, 4694,   30602,  7, }, // America/Caracas
    {   66, 4345,   30609,  5, }, // America/Cayenne
    {   66, 5496,   30614,  5, }, // America/Cayman
    {   66, 2260,   30619,  6, }, // America/Chicago
    {   66, 7756,   30625,  7, }, // America/Chihuahua
    {   66, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   66, 5422,   30632, 10, }, // America/Costa_Rica
    {   66, 7796,   30642,  8, }, // America/Creston
    {   66, 3791,   30650,  6, }, // America/Cuiaba
    {   66, 5723,   30656,  7, }, // America/Curacao
    {   66, 7812,   30663, 13, }, // America/Danmarkshavn
    {   66, 7833,   30676,  6, }, // America/Dawson
    {   66, 7848,   30682, 12, }, // America/Dawson_Creek
    {   66,  805,   30694,  6, }, // America/Denver
    {   66, 3465,   30700,  8, }, // America/Detroit
    {   66, 5739,   30708,  7, }, // America/Dominica
    {   66,  893,   30715,  7, }, // America/Edmonton
    {   66, 7869,   30722,  8, }, // America/Eirunepe
    {   66, 5441,   30730, 11, }, // America/El_Salvador
    {   66, 7886,   30741, 10, }, // America/Fort_Nelson
    {   66, 7906,   30751,  9, }, // America/Fortaleza
    {   66, 7924,   30760,  9, }, // America/Glace_Bay
    {   66, 6881,   30769,  7, }, // America/Goose_Bay
    {   66, 4612,   30776, 13, }, // America/Grand_Turk
    {   66, 5770,   30789,  8, }, // America/Grenada
    {   66, 5786,   30797,  9, }, // America/Guadeloupe
    {   66, 3760,   30806, 10, }, // America/Guatemala
    {   66, 4841,   30816,  8, }, // America/Guayaquil
    {   66, 6932,   30824,  6, }, // America/Guyana
    {   66, 1939,   30830,  9, }, // America/Halifax
    {   66, 2281,   30839,  6, }, // America/Havana
    {   66, 7942,   30845, 12, }, // America/Hermosillo
    {   66,  348,   30857, 13, }, // America/Indiana/Indianapolis
    {   66,  481,   30870, 15, }, // America/Indiana/Knox
    {   66, 7961,   30885, 17, }, // America/Indiana/Marengo
    {   66, 7985,   30902, 23, }, // America/Indiana/Petersburg
    {   66, 8012,   30925, 20, }, // America/Indiana/Tell_City
    {   66, 8038,   30945, 15, }, // America/Indiana/Vevay
    {   66, 8060,   30960, 21, }, // America/Indiana/Vincennes
    {   66, 8086,   30981, 18, }, // America/Indiana/Winamac
    {   66, 8110,   30999,  6, }, // America/Inuvik
    {   66,  660,   31005,  7, }, // America/Iqaluit
    {   66, 2799,   31012,  7, }, // America/Jamaica
    {   66, 5380,   31019,  4, }, // America/Juneau
    {   66,  521,   31023,  6, }, // America/Kentucky/Louisville
    {   66, 8125,   31029, 19, }, // America/Kentucky/Monticello
    {   66, 5704,   31048, 10, }, // America/Kralendijk
    {   66, 4376,   31058,  6, }, // America/La_Paz
    {   66, 7169,   31064,  4, }, // America/Lima
    {   66, 3239,   31068, 11, }, // America/Los_Angeles
    {   66, 5932,   31079, 24, }, // America/Lower_Princes
    {   66, 8153,   31103,  6, }, // America/Maceio
    {   66, 8168,   31109,  6, }, // America/Managua
    {   66, 1908,   31115,  5, }, // America/Manaus
    {   66, 5897,   31120,  6, }, // America/Marigot
    {   66, 5805,   31126,  9, }, // America/Martinique
    {   66, 8184,   31135,  7, }, // America/Matamoros
    {   66, 2917,   31142,  8, }, // America/Mazatlan
    {   66, 8202,   31150,  8, }, // America/Menominee
    {   66, 8220,   31158,  6, }, // America/Merida
    {   66, 8235,   31164, 12, }, // America/Metlakatla
    {   66, 2949,   31176, 13, }, // America/Mexico_City
    {   66, 4391,   31189,  9, }, // America/Miquelon
    {   66, 8254,   31198,  6, }, // America/Moncton
    {   66, 8270,   31204,  9, }, // America/Monterrey
    {   66, 4098,   31213, 10, }, // America/Montevideo
    {   66, 5824,   31223,  9, }, // America/Montserrat
    {   66, 5481,   31232,  7, }, // America/Nassau
    {   66, 2379,   31239,  8, }, // America/New_York
    {   66, 8288,   31152,  3, }, // America/Nome
    {   66, 1850,   31247,  7, }, // America/Noronha
    {   66, 8301,   31254, 19, }, // America/North_Dakota/Beulah
    {   66, 8329,   31273, 20, }, // America/North_Dakota/Center
    {   66, 8357,   31293, 22, }, // America/North_Dakota/New_Salem
    {   66,  393,   31315,  3, }, // America/Nuuk
    {   66, 8388,   31318,  7, }, // America/Ojinaga
    {   66, 2356,   31325,  6, }, // America/Panama
    {   66, 6173,   31331, 10, }, // America/Paramaribo
    {   66, 2973,   31341,  7, }, // America/Phoenix
    {   66, 3945,   31348, 15, }, // America/Port-au-Prince
    {   66, 5954,   31363, 13, }, // America/Port_of_Spain
    {   66, 8404,   31376, 12, }, // America/Porto_Velho
    {   66, 5843,   31388, 12, }, // America/Puerto_Rico
    {   66, 4030,   31400, 13, }, // America/Punta_Arenas
    {   66, 8424,   31413, 12, }, // America/Rankin_Inlet
    {   66, 8445,   31425,  6, }, // America/Recife
    {   66, 1995,   31431,  6, }, // America/Regina
    {   66, 8460,   31437,  8, }, // America/Resolute
    {   66,  695,   31445, 12, }, // America/Rio_Branco
    {   66, 8477,   31457,  9, }, // America/Santarem
    {   66, 2201,   31466,  9, }, // America/Santiago
    {   66, 6111,   31475, 12, }, // America/Santo_Domingo
    {   66, 1878,   31487,  9, }, // America/Sao_Paulo
    {   66, 6899,   31496, 14, }, // America/Scoresbysund
    {   66, 8494,   31510,  6, }, // America/Sitka
    {   66, 8508,   31516, 16, }, // America/St_Barthelemy
    {   66, 2061,   31532, 10, }, // America/St_Johns
    {   66, 5863,   31542, 11, }, // America/St_Kitts
    {   66, 5880,   31553, 12, }, // America/St_Lucia
    {   66,  855,   31565, 10, }, // America/St_Thomas
    {   66, 5913,   31575, 15, }, // America/St_Vincent
    {   66, 8530,   31590, 15, }, // America/Swift_Current
    {   66, 5461,   31605, 12, }, // America/Tegucigalpa
    {   66, 5756,   31617,  5, }, // America/Thule
    {   66,  313,   31622,  7, }, // America/Tijuana
    {   66,  608,   31629,  6, }, // America/Toronto
    {   66, 5688,   31635,  7, }, // America/Tortola
    {   66, 2093,   31642,  7, }, // America/Vancouver
    {   66, 2144,   31649, 10, }, // America/Whitehorse
    {   66,  734,   31659,  7, }, // America/Winnipeg
    {   66, 8552,   31666,  7, }, // America/Yakutat
    {   66, 6001,   31673,  4, }, // Antarctica/Casey
    {   66, 6094,   31677,  5, }, // Antarctica/Davis
    {   66, 6133,   31682, 15, }, // Antarctica/DumontDUrville
    {   66, 8568,   31697,  8, }, // Antarctica/Macquarie
    {   66, 7066,   31705,  4, }, // Antarctica/Mawson
    {   66, 7113,   31709,  9, }, // Antarctica/McMurdo
    {   66, 8589,   31718,  6, }, // Antarctica/Palmer
    {   66, 7226,   31724,  5, }, // Antarctica/Rothera
    {   66, 7295,   31729,  5, }, // Antarctica/Syowa
    {   66, 8607,   31734,  5, }, // Antarctica/Troll
    {   66, 7374,   31739,  6, }, // Antarctica/Vostok
    {   66, 1429,   31745, 10, }, // Arctic/Longyearbyen
    {   66, 5570,   31755,  4, }, // Asia/Aden
    {   66, 5395,   31759,  7, }, // Asia/Almaty
    {   66, 3968,   31766,  6, }, // Asia/Amman
    {   66, 5511,   31772,  6, }, // Asia/Anadyr
    {   66, 5523,   31778,  6, }, // Asia/Aqtau
    {   66, 5368,   31784,  7, }, // Asia/Aqtobe
    {   66,  964,   31791,  8, }, // Asia/Ashgabat
    {   66, 8624,   31799,  6, }, // Asia/Atyrau
    {   66, 3607,   31805,  6, }, // Asia/Baghdad
    {   66, 5534,   31811,  6, }, // Asia/Bahrain
    {   66, 3653,   30654,  4, }, // Asia/Baku
    {   66, 4466,   31817,  7, }, // Asia/Bangkok
    {   66, 3571,   31824,  7, }, // Asia/Barnaul
    {   66, 4086,   31831,  5, }, // Asia/Beirut
    {   66, 3778,   31836,  7, }, // Asia/Bishkek
    {   66, 5989,   31843,  6, }, // Asia/Brunei
    {   66, 4601,   31849,  4, }, // Asia/Chita
    {   66, 4511,   31853,  6, }, // Asia/Colombo
    {   66, 4540,   31859,  9, }, // Asia/Damascus
    {   66, 1093,   31868,  4, }, // Asia/Dhaka
    {   66, 6192,   31872,  4, }, // Asia/Dili
    {   66, 3596,   31876,  5, }, // Asia/Dubai
    {   66, 6159,   31881,  8, }, // Asia/Dushanbe
    {   66, 8636,   31889, 10, }, // Asia/Famagusta
    {   66, 8651,   31899,  4, }, // Asia/Gaza
    {   66, 4795,   31903,  7, }, // Asia/Hebron
    {   66, 1259,   31910,  6, }, // Asia/Ho_Chi_Minh
    {   66, 2704,   31916,  4, }, // Asia/Hong_Kong
    {   66, 4771,   31920,  5, }, // Asia/Hovd
    {   66, 4184,   31925, 10, }, // Asia/Irkutsk
    {   66, 7006,   31935,  8, }, // Asia/Jakarta
    {   66, 6992,   31943,  7, }, // Asia/Jayapura
    {   66, 1290,   31950,  9, }, // Asia/Jerusalem
    {   66, 3560,   31959,  5, }, // Asia/Kabul
    {   66, 4316,   31964,  8, }, // Asia/Kamchatka
    {   66, 4239,   31972,  5, }, // Asia/Karachi
    {   66, 1185,   31977,  9, }, // Asia/Kathmandu
    {   66, 8661,   31986,  8, }, // Asia/Khandyga
    {   66,  992,   31994,  6, }, // Asia/Kolkata
    {   66, 4197,   32000, 15, }, // Asia/Krasnoyarsk
    {   66, 4859,   32015, 13, }, // Asia/Kuala_Lumpur
    {   66, 5976,   32028,  6, }, // Asia/Kuching
    {   66, 5547,   32034,  5, }, // Asia/Kuwait
    {   66, 1211,   32039,  5, }, // Asia/Macau
    {   66, 4017,   32044,  7, }, // Asia/Magadan
    {   66, 1349,   32051,  9, }, // Asia/Makassar
    {   66, 7182,   32060,  5, }, // Asia/Manila
    {   66, 6920,   32065,  7, }, // Asia/Muscat
    {   66, 2554,   32072,  8, }, // Asia/Nicosia
    {   66, 8675,   32080, 14, }, // Asia/Novokuznetsk
    {   66, 4135,   32094, 12, }, // Asia/Novosibirsk
    {   66, 4229,   32106,  6, }, // Asia/Omsk
    {   66, 7145,   32112,  4, }, // Asia/Oral
    {   66, 6961,   32116,  7, }, // Asia/Phnom_Penh
    {   66, 8693,   32123,  9, }, // Asia/Pontianak
    {   66, 4214,   32132,  7, }, // Asia/Pyongyang
    {   66, 5559,   32139,  5, }, // Asia/Qatar
    {   66, 8708,   32144,  7, }, // Asia/Qostanay
    {   66, 4269,   32151,  9, }, // Asia/Qyzylorda
    {   66, 3584,   32160,  5, }, // Asia/Riyadh
    {   66, 4408,   32165,  7, }, // Asia/Sakhalin
    {   66, 7245,   32172,  8, }, // Asia/Samarkand
    {   66, 3279,   32180,  4, }, // Asia/Seoul
    {   66, 1053,   32184,  6, }, // Asia/Shanghai
    {   66, 3300,   32190,  8, }, // Asia/Singapore
    {   66, 4297,   32198, 16, }, // Asia/Srednekolymsk
    {   66, 3263,   32214,  6, }, // Asia/Taipei
    {   66, 4781,   32220,  8, }, // Asia/Tashkent
    {   66, 3915,   32228,  8, }, // Asia/Tbilisi
    {   66, 2772,   32236,  6, }, // Asia/Tehran
    {   66, 1317,   32242,  6, }, // Asia/Thimphu
    {   66, 2821,   32248,  6, }, // Asia/Tokyo
    {   66, 4572,   32254,  6, }, // Asia/Tomsk
    {   66, 1021,   32260,  9, }, // Asia/Ulaanbaatar
    {   66, 1159,   32269,  6, }, // Asia/Urumqi
    {   66, 8722,   32275,  9, }, // Asia/Ust-Nera
    {   66, 6977,   32284,  9, }, // Asia/Vientiane
    {   66, 4710,   32293, 12, }, // Asia/Vladivostok
    {   66, 4828,   32305,  9, }, // Asia/Yakutsk
    {   66, 1235,   32314,  5, }, // Asia/Yangon
    {   66, 3883,   32319, 15, }, // Asia/Yekaterinburg
    {   66, 3747,   32334,  7, }, // Asia/Yerevan
    {   66, 3663,   32341,  6, }, // Atlantic/Azores
    {   66, 5671,   32347,  8, }, // Atlantic/Bermuda
    {   66, 6628,   32355,  6, }, // Atlantic/Canary
    {   66, 3727,   32361, 10, }, // Atlantic/Cape_Verde
    {   66, 1395,   32371,  4, }, // Atlantic/Faroe
    {   66, 8736,   32375,  6, }, // Atlantic/Madeira
    {   66, 2748,   32381,  8, }, // Atlantic/Reykjavik
    {   66, 7272,   32389, 12, }, // Atlantic/South_Georgia
    {   66, 6821,   32401, 12, }, // Atlantic/St_Helena
    {   66, 6644,   32413,  7, }, // Atlantic/Stanley
    {   66, 1670,   32420,  6, }, // Australia/Adelaide
    {   66, 1635,   32426,  8, }, // Australia/Brisbane
    {   66, 1799,   32434, 11, }, // Australia/Broken_Hill
    {   66, 1583,   32445,  7, }, // Australia/Darwin
    {   66, 3637,   32452,  6, }, // Australia/Eucla
    {   66, 1516,   32458,  6, }, // Australia/Hobart
    {   66, 8753,   32464,  8, }, // Australia/Lindeman
    {   66, 1547,   32472,  9, }, // Australia/Lord_Howe
    {   66, 1727,   32481,  8, }, // Australia/Melbourne
    {   66, 1762,   32489,  5, }, // Australia/Perth
    {   66, 1463,   32494,  5, }, // Australia/Sydney
    {   66, 6441,   32499, 10, }, // Europe/Amsterdam
    {   66, 6216,   32509,  7, }, // Europe/Andorra
    {   66, 3620,   32516, 10, }, // Europe/Astrakhan
    {   66, 2300,   32526,  6, }, // Europe/Athens
    {   66, 6336,   32532,  8, }, // Europe/Belgrade
    {   66, 4757,   32540,  7, }, // Europe/Berlin
    {   66, 6488,   32547, 12, }, // Europe/Bratislava
    {   66, 2167,   32559, 11, }, // Europe/Brussels
    {   66, 3928,   32570,  9, }, // Europe/Bucharest
    {   66, 3806,   32579,  9, }, // Europe/Budapest
    {   66, 8772,   32588,  8, }, // Europe/Busingen
    {   66, 2583,   32596,  6, }, // Europe/Chisinau
    {   66, 6289,   32602,  9, }, // Europe/Copenhagen
    {   66, 2338,   32611,  6, }, // Europe/Dublin
    {   66, 6307,   32617, 11, }, // Europe/Gibraltar
    {   66, 8788,   32628,  7, }, // Europe/Guernsey
    {   66, 6612,   32635,  9, }, // Europe/Helsinki
    {   66, 8804,   32644, 11, }, // Europe/Isle_of_Man
    {   66, 1130,   32655,  9, }, // Europe/Istanbul
    {   66, 8823,   32664,  6, }, // Europe/Jersey
    {   66, 3979,   32670, 12, }, // Europe/Kaliningrad
    {   66, 8929,   32682,  5, }, // Europe/Kirov
    {   66, 2527,   32687,  3, }, // Europe/Kyiv
    {   66, 3213,   32690,  6, }, // Europe/Lisbon
    {   66, 6506,   32696, 10, }, // Europe/Ljubljana
    {   66, 2501,   32706,  5, }, // Europe/London
    {   66, 6365,   32711, 13, }, // Europe/Luxembourg
    {   66, 4892,   32724,  7, }, // Europe/Madrid
    {   66, 6397,   32731,  6, }, // Europe/Malta
    {   66, 6582,   32737,  7, }, // Europe/Mariehamn
    {   66, 3693,   32744,  7, }, // Europe/Minsk
    {   66, 6410,   32751,  5, }, // Europe/Monaco
    {   66, 3537,   32756,  5, }, // Europe/Moscow
    {   66, 6458,   32761,  5, }, // Europe/Oslo
    {   66, 4284,   32766,  5, }, // Europe/Paris
    {   66, 6424,   32771,  8, }, // Europe/Podgorica
    {   66, 6275,   32779,  5, }, // Europe/Prague
    {   66, 8837,   32784,  4, }, // Europe/Riga
    {   66, 6324,   32788,  3, }, // Europe/Rome
    {   66, 4331,   32791,  6, }, // Europe/Samara
    {   66, 6470,   32797, 10, }, // Europe/San_Marino
    {   66, 6245,   32807,  8, }, // Europe/Sarajevo
    {   66, 4451,   32815,  7, }, // Europe/Saratov
    {   66, 8849,   32822, 11, }, // Europe/Simferopol
    {   66, 6383,   32833,  8, }, // Europe/Skopje
    {   66, 6599,   32841,  5, }, // Europe/Sofia
    {   66, 6523,   32846,  8, }, // Europe/Stockholm
    {   66, 8867,   32854,  5, }, // Europe/Tallinn
    {   66, 6202,   32859,  5, }, // Europe/Tirane
    {   66, 8882,   32864, 12, }, // Europe/Ulyanovsk
    {   66, 6352,   32876,  5, }, // Europe/Vaduz
    {   66, 6567,   32881,  7, }, // Europe/Vatican
    {   66, 6231,   32888,  8, }, // Europe/Vienna
    {   66, 8899,   32896,  8, }, // Europe/Vilnius
    {   66, 4727,   32904, 10, }, // Europe/Volgograd
    {   66, 3190,   32914,  5, }, // Europe/Warsaw
    {   66, 6261,   32919,  7, }, // Europe/Zagreb
    {   66, 6540,   32926,  5, }, // Europe/Zurich
    {   66, 5078,   32931, 13, }, // Indian/Antananarivo
    {   66, 6947,   32944,  5, }, // Indian/Chagos
    {   66, 6046,   32949, 16, }, // Indian/Christmas
    {   66, 6063,   32965,  4, }, // Indian/Cocos
    {   66, 5029,   32969,  5, }, // Indian/Comoro
    {   66, 6661,   32974,  9, }, // Indian/Kerguelen
    {   66, 7260,   32983,  4, }, // Indian/Mahe
    {   66, 7050,   32987,  8, }, // Indian/Maldives
    {   66, 4069,   32995,  8, }, // Indian/Mauritius
    {   66, 5098,   33003,  8, }, // Indian/Mayotte
    {   66, 7211,   33011,  9, }, // Indian/Reunion
    {   66, 4422,   33020,  5, }, // Pacific/Apia
    {   66,  932,   33025,  7, }, // Pacific/Auckland
    {   66, 3706,   33032,  8, }, // Pacific/Bougainville
    {   66, 3015,   33040,  5, }, // Pacific/Chatham
    {   66, 3157,   33045,  3, }, // Pacific/Chuuk
    {   66, 2237,   33048,  9, }, // Pacific/Easter
    {   66, 7360,   33057,  5, }, // Pacific/Efate
    {   66, 7327,   33062,  7, }, // Pacific/Fakaofo
    {   66, 3902,   33069,  4, }, // Pacific/Fiji
    {   66, 7343,   33073,  8, }, // Pacific/Funafuti
    {   66, 6678,   33081,  9, }, // Pacific/Galapagos
    {   66, 6696,   33090,  9, }, // Pacific/Gambier
    {   66, 3822,   33099, 12, }, // Pacific/Guadalcanal
    {   66, 6018,   33111,  5, }, // Pacific/Guam
    {   66, 2723,   33116,  6, }, // Pacific/Honolulu
    {   66, 3049,   33122, 10, }, // Pacific/Kanton
    {   66, 3998,   33132, 10, }, // Pacific/Kiritimati
    {   66, 7019,   33142,  5, }, // Pacific/Kosrae
    {   66, 2842,   33147,  9, }, // Pacific/Kwajalein
    {   66, 4877,   33156,  6, }, // Pacific/Majuro
    {   66, 4051,   33162,  9, }, // Pacific/Marquesas
    {   66, 8914,   33171,  5, }, // Pacific/Midway
    {   66, 7084,   33176,  5, }, // Pacific/Nauru
    {   66, 7132,   33181,  4, }, // Pacific/Niue
    {   66, 4168,   33185,  5, }, // Pacific/Norfolk
    {   66, 7098,   33190,  6, }, // Pacific/Noumea
    {   66, 3126,   33196,  9, }, // Pacific/Pago_Pago
    {   66, 7155,   33205,  5, }, // Pacific/Palau
    {   66, 7194,   33210,  8, }, // Pacific/Pitcairn
    {   66, 3096,   33218,  5, }, // Pacific/Pohnpei
    {   66, 4807,   33223, 11, }, // Pacific/Port_Moresby
    {   66, 6076,   33234,  8, }, // Pacific/Rarotonga
    {   66, 6031,   33242,  6, }, // Pacific/Saipan
    {   66, 7312,   33248,  6, }, // Pacific/Tahiti
    {   66, 6712,   33254,  6, }, // Pacific/Tarawa
    {   66, 4583,   33260,  8, }, // Pacific/Tongatapu
    {   66, 7392,   33268,  3, }, // Pacific/Wake
    {   66, 7405,   33271,  5, }, // Pacific/Wallis
    {   67,   14,       0,  6, }, // Africa/Asmara Bosnian/Latin/Bosnia and Herzegovina
    {   67, 2320,    4690,  5, }, // Africa/Cairo
    {   67, 4117,   33276, 10, }, // Africa/Casablanca
    {   67, 5043,   33286,  7, }, // Africa/Djibouti
    {   67, 4524,    6423,  6, }, // Africa/Khartoum
    {   67, 5113,   33293,  7, }, // Africa/Mogadishu
    {   67, 4435,       6,  8, }, // Africa/Sao_Tome
    {   67, 5607,   33300,  7, }, // America/Anguilla
    {   67, 5624,   33307,  7, }, // America/Antigua
    {   67, 4252,      14,  8, }, // America/Asuncion
    {   67,  237,      22,  8, }, // America/Atikokan
    {   67, 7623,    3943, 14, }, // America/Bahia_Banderas
    {   67, 3868,   33314,  6, }, // America/Cancun
    {   67, 5496,    6694,  6, }, // America/Cayman
    {   67, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   67, 5422,   33320,  9, }, // America/Costa_Rica
    {   67, 5723,    6749,  7, }, // America/Curacao
    {   67, 5739,   21666,  8, }, // America/Dominica
    {   67, 5441,    6806,  8, }, // America/El_Salvador
    {   67, 5786,   33329,  9, }, // America/Guadeloupe
    {   67, 3760,   33338,  9, }, // America/Guatemala
    {   67,  481,      73, 13, }, // America/Indiana/Knox
    {   67, 7961,      86, 16, }, // America/Indiana/Marengo
    {   67, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   67, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   67, 8038,     139, 14, }, // America/Indiana/Vevay
    {   67, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   67, 8086,     171, 16, }, // America/Indiana/Winamac
    {   67, 2799,   33347,  7, }, // America/Jamaica
    {   67, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   67, 5932,     207, 22, }, // America/Lower_Princes
    {   67, 8220,    7126,  6, }, // America/Merida
    {   67, 1850,     235, 19, }, // America/Noronha
    {   67, 8301,   33354, 23, }, // America/North_Dakota/Beulah
    {   67, 8329,   33377, 23, }, // America/North_Dakota/Center
    {   67, 8357,   33400, 26, }, // America/North_Dakota/New_Salem
    {   67,  393,     317,  4, }, // America/Nuuk
    {   67, 5843,   33426,  9, }, // America/Puerto_Rico
    {   67, 6899,     321, 16, }, // America/Scoresbysund
    {   67, 8508,     337, 14, }, // America/St_Barthelemy
    {   67, 2061,     351, 10, }, // America/St_Johns
    {   67, 5863,     361,  9, }, // America/St_Kitts
    {   67, 5880,     370,  9, }, // America/St_Lucia
    {   67,  855,     379, 10, }, // America/St_Thomas
    {   67, 5913,     389, 11, }, // America/St_Vincent
    {   67, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   67, 5395,    7594,  6, }, // Asia/Almaty
    {   67, 3968,    5605,  4, }, // Asia/Amman
    {   67, 5511,    7600,  6, }, // Asia/Anadyr
    {   67, 5523,    5609,  5, }, // Asia/Aqtau
    {   67, 5368,   33435,  7, }, // Asia/Aqtobe
    {   67,  964,   33442,  7, }, // Asia/Ashgabat
    {   67, 8624,   33449,  6, }, // Asia/Atyrau
    {   67, 3607,    4162,  6, }, // Asia/Baghdad
    {   67, 5534,    4168,  7, }, // Asia/Bahrain
    {   67, 4086,    7625,  6, }, // Asia/Beirut
    {   67, 3778,   33455,  6, }, // Asia/Bishkek
    {   67, 5989,   33461,  7, }, // Asia/Brunei
    {   67, 4511,    5637,  7, }, // Asia/Colombo
    {   67, 4540,    4201,  6, }, // Asia/Damascus
    {   67, 1093,    4717,  4, }, // Asia/Dhaka
    {   67, 6159,   33468,  7, }, // Asia/Dushanbe
    {   67, 1259,   33475,  9, }, // Asia/Ho_Chi_Minh
    {   67, 7006,   33484,  8, }, // Asia/Jakarta
    {   67, 6992,   33492,  9, }, // Asia/Jayapura
    {   67, 1290,   33501,  9, }, // Asia/Jerusalem
    {   67, 4316,   33510,  8, }, // Asia/Kamchatka
    {   67, 4239,   33518,  6, }, // Asia/Karachi
    {   67, 1185,    5711,  8, }, // Asia/Kathmandu
    {   67, 8661,   33524,  7, }, // Asia/Khandyga
    {   67,  992,     457,  7, }, // Asia/Kolkata
    {   67, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {   67, 5976,   33531,  6, }, // Asia/Kuching
    {   67, 5547,    7725,  6, }, // Asia/Kuwait
    {   67, 1211,   33537,  5, }, // Asia/Macau
    {   67, 1349,    7736,  7, }, // Asia/Makassar
    {   67, 6920,    4326,  6, }, // Asia/Muscat
    {   67, 2554,   33542,  8, }, // Asia/Nicosia
    {   67, 8675,   33550, 12, }, // Asia/Novokuznetsk
    {   67, 6961,   22518,  8, }, // Asia/Phnom_Penh
    {   67, 4214,   33562,  9, }, // Asia/Pyongyang
    {   67, 5559,    4332,  5, }, // Asia/Qatar
    {   67, 8708,    7770,  8, }, // Asia/Qostanay
    {   67, 4269,    7778,  9, }, // Asia/Qyzylorda
    {   67, 3584,   33571,  5, }, // Asia/Riyadh
    {   67, 4408,   33576,  7, }, // Asia/Sakhalin
    {   67, 3279,    7798,  4, }, // Asia/Seoul
    {   67, 1053,   33583,  6, }, // Asia/Shanghai
    {   67, 3300,   20900,  8, }, // Asia/Singapore
    {   67, 3263,    7830,  6, }, // Asia/Taipei
    {   67, 4781,   33589,  7, }, // Asia/Tashkent
    {   67, 2772,    7842,  7, }, // Asia/Tehran
    {   67, 2821,    4356,  5, }, // Asia/Tokyo
    {   67, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {   67, 1159,   33596,  6, }, // Asia/Urumqi
    {   67, 6977,   33602, 10, }, // Asia/Vientiane
    {   67, 4828,    7873,  7, }, // Asia/Yakutsk
    {   67, 1235,    7880,  6, }, // Asia/Yangon
    {   67, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {   67, 3747,    7898,  7, }, // Asia/Yerevan
    {   67, 3663,   33612,  5, }, // Atlantic/Azores
    {   67, 6628,    4398,  6, }, // Atlantic/Canary
    {   67, 3727,   22654, 10, }, // Atlantic/Cape_Verde
    {   67, 1395,     483,  5, }, // Atlantic/Faroe
    {   67, 2748,   33617,  9, }, // Atlantic/Reykjavik
    {   67, 6821,   33626, 12, }, // Atlantic/St_Helena
    {   67, 1547,   22727,  8, }, // Australia/Lord_Howe
    {   67, 1727,    8021,  7, }, // Australia/Melbourne
    {   67, 1762,   22735,  4, }, // Australia/Perth
    {   67, 1463,    8033,  6, }, // Australia/Sydney
    {   67, 6216,   33638,  6, }, // Europe/Andorra
    {   67, 3620,   33644,  8, }, // Europe/Astrakhan
    {   67, 2300,   33652,  5, }, // Europe/Athens
    {   67, 6336,    8060,  7, }, // Europe/Belgrade
    {   67, 2167,   33657,  6, }, // Europe/Brussels
    {   67, 3928,   33663,  8, }, // Europe/Bucharest
    {   67, 3806,   33671, 10, }, // Europe/Budapest
    {   67, 2583,   33681,  8, }, // Europe/Chisinau
    {   67, 6289,    4475, 10, }, // Europe/Copenhagen
    {   67, 2338,   33689,  6, }, // Europe/Dublin
    {   67, 8788,   33695,  6, }, // Europe/Guernsey
    {   67, 8804,   33701, 10, }, // Europe/Isle_of_Man
    {   67, 3979,   33711, 12, }, // Europe/Kaliningrad
    {   67, 2527,   33723,  5, }, // Europe/Kyiv
    {   67, 3213,   33728,  7, }, // Europe/Lisbon
    {   67, 6365,    8172, 10, }, // Europe/Luxembourg
    {   67, 6410,    6044,  6, }, // Europe/Monaco
    {   67, 3537,   22880,  6, }, // Europe/Moscow
    {   67, 4284,   33735,  5, }, // Europe/Paris
    {   67, 6275,    8201,  4, }, // Europe/Prague
    {   67, 6324,   33740,  3, }, // Europe/Rome
    {   67, 8849,   33743, 11, }, // Europe/Simferopol
    {   67, 6383,   33754,  7, }, // Europe/Skopje
    {   67, 6599,   33761,  6, }, // Europe/Sofia
    {   67, 6523,   33767,  8, }, // Europe/Stockholm
    {   67, 8867,    8250,  5, }, // Europe/Tallinn
    {   67, 6202,   21213,  6, }, // Europe/Tirane
    {   67, 6567,    6096,  7, }, // Europe/Vatican
    {   67, 6231,   33775,  3, }, // Europe/Vienna
    {   67, 3190,   33778,  7, }, // Europe/Warsaw
    {   67, 6540,   33785,  5, }, // Europe/Zurich
    {   67, 6046,   33790, 14, }, // Indian/Christmas
    {   67, 6063,   33804, 15, }, // Indian/Cocos
    {   67, 7050,   33819,  7, }, // Indian/Maldives
    {   67, 4069,   33826, 10, }, // Indian/Mauritius
    {   67, 7211,     547,  7, }, // Indian/Reunion
    {   67, 3157,     554,  5, }, // Pacific/Chuuk
    {   67, 3902,   33836,  5, }, // Pacific/Fiji
    {   67, 2723,    4611,  8, }, // Pacific/Honolulu
    {   67, 3049,    4619,  9, }, // Pacific/Kanton
    {   67, 7194,    8422,  7, }, // Pacific/Pitcairn
    {   67, 3096,     586,  7, }, // Pacific/Pohnpei
    {   67, 7405,   33841,  5, }, // Pacific/Wallis
    {   68, 6788,     604,  6, }, // Africa/Abidjan Bosnian/Cyrillic/Bosnia and Herzegovina
    {   68, 6760,   27178,  4, }, // Africa/Accra
    {   68, 5059,   33846, 10, }, // Africa/Addis_Ababa
    {   68, 7420,     626,  5, }, // Africa/Algiers
    {   68,   14,     631,  6, }, // Africa/Asmara
    {   68,   44,     637,  6, }, // Africa/Bamako
    {   68, 5257,   33856,  6, }, // Africa/Bangui
    {   68, 6746,     648,  6, }, // Africa/Banjul
    {   68, 7435,   33862,  5, }, // Africa/Bissau
    {   68, 4957,   33867,  7, }, // Africa/Blantyre
    {   68, 5287,   33874,  8, }, // Africa/Brazzaville
    {   68, 4922,   33882,  9, }, // Africa/Bujumbura
    {   68, 2320,   33891,  5, }, // Africa/Cairo
    {   68, 4117,   33896, 10, }, // Africa/Casablanca
    {   68, 7449,     699,  5, }, // Africa/Ceuta
    {   68, 6773,     704,  7, }, // Africa/Conakry
    {   68, 6840,     711,  5, }, // Africa/Dakar
    {   68, 5130,     716, 12, }, // Africa/Dar_es_Salaam
    {   68, 5043,     728,  6, }, // Africa/Djibouti
    {   68, 5243,     734,  5, }, // Africa/Douala
    {   68, 5166,   33906,  7, }, // Africa/El_Aaiun
    {   68, 6853,     746,  7, }, // Africa/Freetown
    {   68, 4906,     753,  7, }, // Africa/Gaborone
    {   68, 5015,   33913,  6, }, // Africa/Harare
    {   68, 4479,   33919, 11, }, // Africa/Johannesburg
    {   68, 4499,     779,  4, }, // Africa/Juba
    {   68, 5151,     783,  7, }, // Africa/Kampala
    {   68, 4524,   33930,  6, }, // Africa/Khartoum
    {   68, 4973,     796,  6, }, // Africa/Kigali
    {   68, 5306,     802,  7, }, // Africa/Kinshasa
    {   68, 4744,     809,  5, }, // Africa/Lagos
    {   68, 5336,     814,  8, }, // Africa/Libreville
    {   68, 6869,     822,  4, }, // Africa/Lome
    {   68, 5211,     826,  6, }, // Africa/Luanda
    {   68, 4939,   33936,  9, }, // Africa/Lubumbashi
    {   68, 5001,     841,  6, }, // Africa/Lusaka
    {   68, 5322,     847,  6, }, // Africa/Malabo
    {   68, 4987,   33945,  6, }, // Africa/Maputo
    {   68, 5197,     859,  6, }, // Africa/Maseru
    {   68, 5182,     865,  7, }, // Africa/Mbabane
    {   68, 5113,     872,  7, }, // Africa/Mogadishu
    {   68, 7034,   33951,  9, }, // Africa/Monrovia
    {   68, 3853,   33960,  7, }, // Africa/Nairobi
    {   68, 5271,     895,  7, }, // Africa/Ndjamena
    {   68, 5354,   33967,  7, }, // Africa/Niamey
    {   68, 6803,     908,  7, }, // Africa/Nouakchott
    {   68, 6727,     915,  8, }, // Africa/Ouagadougou
    {   68, 5225,   33974, 10, }, // Africa/Porto-Novo
    {   68, 4435,   33984,  8, }, // Africa/Sao_Tome
    {   68, 2866,     941,  7, }, // Africa/Tripoli
    {   68, 6554,     948,  5, }, // Africa/Tunis
    {   68, 4152,     953,  7, }, // Africa/Windhoek
    {   68,  132,     960,  4, }, // America/Adak
    {   68, 3346,   33992,  7, }, // America/Anchorage
    {   68, 5607,   33999,  7, }, // America/Anguilla
    {   68, 5624,   34006,  7, }, // America/Antigua
    {   68, 4554,   34013, 10, }, // America/Araguaina
    {   68,  166,   34023, 12, }, // America/Argentina/Buenos_Aires
    {   68,   91,    1006,  9, }, // America/Argentina/Catamarca
    {   68,  270,   34035,  7, }, // America/Argentina/Cordoba
    {   68,  441,   34042,  5, }, // America/Argentina/Jujuy
    {   68, 7462,   34047,  8, }, // America/Argentina/La_Rioja
    {   68,  565,   34055,  7, }, // America/Argentina/Mendoza
    {   68, 7489,   34062, 11, }, // America/Argentina/Rio_Gallegos
    {   68, 7520,    1053,  5, }, // America/Argentina/Salta
    {   68, 7544,   34073,  8, }, // America/Argentina/San_Juan
    {   68, 5580,   34081,  7, }, // America/Argentina/San_Luis
    {   68, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {   68, 7597,   34088,  7, }, // America/Argentina/Ushuaia
    {   68, 5640,    1087,  5, }, // America/Aruba
    {   68, 4252,   34095,  8, }, // America/Asuncion
    {   68,  237,   34103,  8, }, // America/Atikokan
    {   68, 3679,   34111,  5, }, // America/Bahia
    {   68, 7623,   34116, 14, }, // America/Bahia_Banderas
    {   68, 5654,    1131,  8, }, // America/Barbados
    {   68, 7646,   34130,  5, }, // America/Belem
    {   68, 5407,   34135,  6, }, // America/Belize
    {   68, 7660,   34141, 13, }, // America/Blanc-Sablon
    {   68, 7681,   34154,  9, }, // America/Boa_Vista
    {   68, 4361,    1170,  6, }, // America/Bogota
    {   68, 7699,   34163,  5, }, // America/Boise
    {   68, 7713,   34168, 11, }, // America/Cambridge_Bay
    {   68, 7735,   34179, 12, }, // America/Campo_Grande
    {   68, 3868,    1205,  6, }, // America/Cancun
    {   68, 4694,    1211,  7, }, // America/Caracas
    {   68, 4345,   34191,  5, }, // America/Cayenne
    {   68, 5496,   34196, 16, }, // America/Cayman
    {   68, 2260,    1247,  6, }, // America/Chicago
    {   68, 7756,   34212,  6, }, // America/Chihuahua
    {   68, 5422,   34218,  9, }, // America/Costa_Rica
    {   68, 7796,    1269,  7, }, // America/Creston
    {   68, 3791,    1276,  6, }, // America/Cuiaba
    {   68, 5723,   34227,  7, }, // America/Curacao
    {   68, 7812,   34234, 13, }, // America/Danmarkshavn
    {   68, 7833,   34247,  5, }, // America/Dawson
    {   68, 7848,   34252, 10, }, // America/Dawson_Creek
    {   68,  805,    1319,  6, }, // America/Denver
    {   68, 3465,    1325,  7, }, // America/Detroit
    {   68, 5739,    1332,  8, }, // America/Dominica
    {   68,  893,    1340,  8, }, // America/Edmonton
    {   68, 7869,    1348,  8, }, // America/Eirunepe
    {   68, 5441,    1356,  8, }, // America/El_Salvador
    {   68, 7886,    1364, 11, }, // America/Fort_Nelson
    {   68, 7906,    1375,  9, }, // America/Fortaleza
    {   68, 7924,   34262,  9, }, // America/Glace_Bay
    {   68, 6881,   34271,  7, }, // America/Goose_Bay
    {   68, 4612,   34278, 10, }, // America/Grand_Turk
    {   68, 5770,    1410,  7, }, // America/Grenada
    {   68, 5786,   34288,  9, }, // America/Guadeloupe
    {   68, 3760,    1426,  9, }, // America/Guatemala
    {   68, 4841,   34297,  8, }, // America/Guayaquil
    {   68, 6932,   34305,  5, }, // America/Guyana
    {   68, 1939,   34310,  8, }, // America/Halifax
    {   68, 2281,   34318,  6, }, // America/Havana
    {   68, 7942,   34324,  9, }, // America/Hermosillo
    {   68,  348,    1471, 12, }, // America/Indiana/Indianapolis
    {   68,  481,   34333, 15, }, // America/Indiana/Knox
    {   68, 7961,   34348, 17, }, // America/Indiana/Marengo
    {   68, 7985,   34365, 20, }, // America/Indiana/Petersburg
    {   68, 8012,   34385, 18, }, // America/Indiana/Tell_City
    {   68, 8038,   34403, 15, }, // America/Indiana/Vevay
    {   68, 8060,   34418, 18, }, // America/Indiana/Vincennes
    {   68, 8086,   34436, 17, }, // America/Indiana/Winamac
    {   68, 8110,    1570,  6, }, // America/Inuvik
    {   68,  660,   34453,  8, }, // America/Iqaluit
    {   68, 2799,   34461,  7, }, // America/Jamaica
    {   68, 5380,   34468,  4, }, // America/Juneau
    {   68,  521,    1594,  7, }, // America/Kentucky/Louisville
    {   68, 8125,   34472, 18, }, // America/Kentucky/Monticello
    {   68, 5704,   34490, 10, }, // America/Kralendijk
    {   68, 4376,   34500,  6, }, // America/La_Paz
    {   68, 7169,    1638,  4, }, // America/Lima
    {   68, 3239,   34506, 11, }, // America/Los_Angeles
    {   68, 5932,   34517, 19, }, // America/Lower_Princes
    {   68, 8153,   34536,  6, }, // America/Maceio
    {   68, 8168,   34542,  7, }, // America/Managua
    {   68, 1908,    1684,  6, }, // America/Manaus
    {   68, 5897,    1690,  6, }, // America/Marigot
    {   68, 5805,    1696,  8, }, // America/Martinique
    {   68, 8184,    1705,  9, }, // America/Matamoros
    {   68, 2917,   34549,  8, }, // America/Mazatlan
    {   68, 8202,    1722,  8, }, // America/Menominee
    {   68, 8220,    1730,  6, }, // America/Merida
    {   68, 8235,    1736, 10, }, // America/Metlakatla
    {   68, 2949,   34557, 12, }, // America/Mexico_City
    {   68, 4391,    1752,  7, }, // America/Miquelon
    {   68, 8254,    1759,  7, }, // America/Moncton
    {   68, 8270,   34569,  8, }, // America/Monterrey
    {   68, 4098,    1775, 10, }, // America/Montevideo
    {   68, 5824,   34577,  9, }, // America/Montserrat
    {   68, 5481,   34586,  5, }, // America/Nassau
    {   68, 2379,   34591,  6, }, // America/New_York
    {   68, 8288,    1809,  3, }, // America/Nome
    {   68, 1850,   34597,  6, }, // America/Noronha
    {   68, 8301,   34603, 22, }, // America/North_Dakota/Beulah
    {   68, 8329,   34625, 22, }, // America/North_Dakota/Center
    {   68, 8357,   34647, 26, }, // America/North_Dakota/New_Salem
    {   68,  393,   28283,  3, }, // America/Nuuk
    {   68, 8388,    1894,  7, }, // America/Ojinaga
    {   68, 2356,    1901,  6, }, // America/Panama
    {   68, 6173,    1907, 10, }, // America/Paramaribo
    {   68, 2973,   34673,  6, }, // America/Phoenix
    {   68, 3945,    1923, 12, }, // America/Port-au-Prince
    {   68, 5954,   34679, 13, }, // America/Port_of_Spain
    {   68, 8404,   34692, 10, }, // America/Porto_Velho
    {   68, 5843,   34702,  9, }, // America/Puerto_Rico
    {   68, 4030,   34711, 12, }, // America/Punta_Arenas
    {   68, 8424,   34723, 12, }, // America/Rankin_Inlet
    {   68, 8445,   34735,  6, }, // America/Recife
    {   68, 1995,   34741,  6, }, // America/Regina
    {   68, 8460,   34747,  7, }, // America/Resolute
    {   68,  695,   34754, 10, }, // America/Rio_Branco
    {   68, 8477,   34764,  8, }, // America/Santarem
    {   68, 2201,   34772,  9, }, // America/Santiago
    {   68, 6111,   34781, 13, }, // America/Santo_Domingo
    {   68, 1878,   34794,  9, }, // America/Sao_Paulo
    {   68, 6899,   34803, 12, }, // America/Scoresbysund
    {   68, 8494,    2074,  5, }, // America/Sitka
    {   68, 8508,   34815, 14, }, // America/St_Barthelemy
    {   68, 2061,   34829,  7, }, // America/St_Johns
    {   68, 5863,   34836,  9, }, // America/St_Kitts
    {   68, 5880,   34845, 10, }, // America/St_Lucia
    {   68,  855,   34855,  8, }, // America/St_Thomas
    {   68, 5913,   34863, 12, }, // America/St_Vincent
    {   68, 8530,   34875, 12, }, // America/Swift_Current
    {   68, 5461,    2156, 11, }, // America/Tegucigalpa
    {   68, 5756,    2167,  4, }, // America/Thule
    {   68,  313,    2171,  7, }, // America/Tijuana
    {   68,  608,    2178,  7, }, // America/Toronto
    {   68, 5688,    2185,  7, }, // America/Tortola
    {   68, 2093,    2192,  8, }, // America/Vancouver
    {   68, 2144,   34887,  8, }, // America/Whitehorse
    {   68,  734,   34895,  7, }, // America/Winnipeg
    {   68, 8552,   34902,  7, }, // America/Yakutat
    {   68, 6001,   34909,  5, }, // Antarctica/Casey
    {   68, 6094,   34914,  6, }, // Antarctica/Davis
    {   68, 6133,   34920, 13, }, // Antarctica/DumontDUrville
    {   68, 8568,   34933,  7, }, // Antarctica/Macquarie
    {   68, 7066,   34940,  5, }, // Antarctica/Mawson
    {   68, 7113,   34945,  8, }, // Antarctica/McMurdo
    {   68, 8589,    2272,  6, }, // Antarctica/Palmer
    {   68, 7226,    2278,  6, }, // Antarctica/Rothera
    {   68, 7295,   34953,  4, }, // Antarctica/Syowa
    {   68, 8607,    2289,  4, }, // Antarctica/Troll
    {   68, 7374,   34957,  6, }, // Antarctica/Vostok
    {   68, 1429,   34963, 11, }, // Arctic/Longyearbyen
    {   68, 5570,    2310,  4, }, // Asia/Aden
    {   68, 5395,   34974,  6, }, // Asia/Almaty
    {   68, 3968,   28663,  4, }, // Asia/Amman
    {   68, 5511,   34980,  6, }, // Asia/Anadyr
    {   68, 5523,    2331,  5, }, // Asia/Aqtau
    {   68, 5368,   34986,  7, }, // Asia/Aqtobe
    {   68,  964,    2342,  7, }, // Asia/Ashgabat
    {   68, 8624,   34993,  6, }, // Asia/Atyrau
    {   68, 3607,    2355,  6, }, // Asia/Baghdad
    {   68, 5534,    2361,  7, }, // Asia/Bahrain
    {   68, 3653,    2368,  4, }, // Asia/Baku
    {   68, 4466,   34999,  6, }, // Asia/Bangkok
    {   68, 3571,    2379,  7, }, // Asia/Barnaul
    {   68, 4086,   35005,  6, }, // Asia/Beirut
    {   68, 3778,    2392,  6, }, // Asia/Bishkek
    {   68, 5989,   35011,  7, }, // Asia/Brunei
    {   68, 4601,    2404,  4, }, // Asia/Chita
    {   68, 4511,    2408,  7, }, // Asia/Colombo
    {   68, 4540,    2415,  6, }, // Asia/Damascus
    {   68, 1093,     711,  4, }, // Asia/Dhaka
    {   68, 6192,    2426,  4, }, // Asia/Dili
    {   68, 3596,    2430,  5, }, // Asia/Dubai
    {   68, 6159,    2435,  7, }, // Asia/Dushanbe
    {   68, 8636,    2442,  9, }, // Asia/Famagusta
    {   68, 8651,    2451,  4, }, // Asia/Gaza
    {   68, 4795,   35018,  6, }, // Asia/Hebron
    {   68, 1259,   35024,  9, }, // Asia/Ho_Chi_Minh
    {   68, 2704,   35033,  9, }, // Asia/Hong_Kong
    {   68, 4771,    2475,  4, }, // Asia/Hovd
    {   68, 4184,   35042,  6, }, // Asia/Irkutsk
    {   68, 7006,    2486,  7, }, // Asia/Jakarta
    {   68, 6992,   35048,  8, }, // Asia/Jayapura
    {   68, 1290,   35056,  9, }, // Asia/Jerusalem
    {   68, 3560,    2510,  5, }, // Asia/Kabul
    {   68, 4316,    2529,  8, }, // Asia/Kamchatka
    {   68, 4239,    2540,  6, }, // Asia/Karachi
    {   68, 1185,    2546,  8, }, // Asia/Kathmandu
    {   68, 8661,   35065,  7, }, // Asia/Khandyga
    {   68,  992,   35072,  7, }, // Asia/Kolkata
    {   68, 4197,   35079, 11, }, // Asia/Krasnoyarsk
    {   68, 4859,   35090, 12, }, // Asia/Kuala_Lumpur
    {   68, 5976,    2592,  6, }, // Asia/Kuching
    {   68, 5547,   35102,  6, }, // Asia/Kuwait
    {   68, 1211,   35108,  5, }, // Asia/Macau
    {   68, 4017,    2609,  7, }, // Asia/Magadan
    {   68, 1349,    2616,  7, }, // Asia/Makassar
    {   68, 7182,    2623,  6, }, // Asia/Manila
    {   68, 6920,   35113,  6, }, // Asia/Muscat
    {   68, 2554,   35119,  8, }, // Asia/Nicosia
    {   68, 8675,   35127, 11, }, // Asia/Novokuznetsk
    {   68, 4135,    2653, 11, }, // Asia/Novosibirsk
    {   68, 4229,    2664,  4, }, // Asia/Omsk
    {   68, 7145,   35138,  4, }, // Asia/Oral
    {   68, 6961,   35142,  8, }, // Asia/Phnom_Penh
    {   68, 8693,    2681,  9, }, // Asia/Pontianak
    {   68, 4214,   35150,  9, }, // Asia/Pyongyang
    {   68, 5559,    2697,  5, }, // Asia/Qatar
    {   68, 8708,   35159,  8, }, // Asia/Qostanay
    {   68, 4269,   35167,  9, }, // Asia/Qyzylorda
    {   68, 3584,   35176,  5, }, // Asia/Riyadh
    {   68, 4408,    2732,  7, }, // Asia/Sakhalin
    {   68, 7245,    2739,  9, }, // Asia/Samarkand
    {   68, 3279,    2748,  4, }, // Asia/Seoul
    {   68, 1053,   35181,  6, }, // Asia/Shanghai
    {   68, 3300,    2758,  8, }, // Asia/Singapore
    {   68, 4297,   35187, 13, }, // Asia/Srednekolymsk
    {   68, 3263,   35200,  6, }, // Asia/Taipei
    {   68, 4781,    2785,  7, }, // Asia/Tashkent
    {   68, 3915,   35206,  7, }, // Asia/Tbilisi
    {   68, 2772,   35213,  7, }, // Asia/Tehran
    {   68, 1317,   35220,  5, }, // Asia/Thimphu
    {   68, 2821,    2810,  5, }, // Asia/Tokyo
    {   68, 4572,    2815,  5, }, // Asia/Tomsk
    {   68, 1021,   35225, 10, }, // Asia/Ulaanbaatar
    {   68, 1159,   35235,  7, }, // Asia/Urumqi
    {   68, 8722,    2836,  8, }, // Asia/Ust-Nera
    {   68, 6977,   35242, 10, }, // Asia/Vientiane
    {   68, 4710,    2851, 11, }, // Asia/Vladivostok
    {   68, 4828,   35252,  7, }, // Asia/Yakutsk
    {   68, 1235,   29043,  6, }, // Asia/Yangon
    {   68, 3883,   35259, 13, }, // Asia/Yekaterinburg
    {   68, 3747,   35272,  7, }, // Asia/Yerevan
    {   68, 3663,   35279,  5, }, // Atlantic/Azores
    {   68, 5671,   35284,  7, }, // Atlantic/Bermuda
    {   68, 6628,   35291, 15, }, // Atlantic/Canary
    {   68, 3727,   35306, 18, }, // Atlantic/Cape_Verde
    {   68, 1395,   35324, 13, }, // Atlantic/Faroe
    {   68, 8736,    2971,  7, }, // Atlantic/Madeira
    {   68, 2748,   35337,  9, }, // Atlantic/Reykjavik
    {   68, 7272,   35346, 13, }, // Atlantic/South_Georgia
    {   68, 6821,   35359, 10, }, // Atlantic/St_Helena
    {   68, 6644,    3029,  6, }, // Atlantic/Stanley
    {   68, 1670,    3035,  8, }, // Australia/Adelaide
    {   68, 1635,   35369,  8, }, // Australia/Brisbane
    {   68, 1799,   35377, 10, }, // Australia/Broken_Hill
    {   68, 1583,    3061,  6, }, // Australia/Darwin
    {   68, 3637,    3067,  5, }, // Australia/Eucla
    {   68, 1516,    3072,  6, }, // Australia/Hobart
    {   68, 8753,    3078,  8, }, // Australia/Lindeman
    {   68, 1547,   35387,  8, }, // Australia/Lord_Howe
    {   68, 1727,    3094,  7, }, // Australia/Melbourne
    {   68, 1762,    3101,  4, }, // Australia/Perth
    {   68, 1463,   35395,  6, }, // Australia/Sydney
    {   68, 6441,    3111,  9, }, // Europe/Amsterdam
    {   68, 6216,   29275,  6, }, // Europe/Andorra
    {   68, 3620,    3127,  8, }, // Europe/Astrakhan
    {   68, 2300,   35401,  5, }, // Europe/Athens
    {   68, 6336,   35406,  7, }, // Europe/Belgrade
    {   68, 4757,    3146,  6, }, // Europe/Berlin
    {   68, 6488,    3152, 10, }, // Europe/Bratislava
    {   68, 2167,   35413,  6, }, // Europe/Brussels
    {   68, 3928,   35419,  8, }, // Europe/Bucharest
    {   68, 3806,   35427, 10, }, // Europe/Budapest
    {   68, 8772,   35437,  8, }, // Europe/Busingen
    {   68, 2583,   35445,  7, }, // Europe/Chisinau
    {   68, 6289,   35452, 10, }, // Europe/Copenhagen
    {   68, 2338,   35462,  6, }, // Europe/Dublin
    {   68, 6307,    3232,  9, }, // Europe/Gibraltar
    {   68, 8788,   35468,  6, }, // Europe/Guernsey
    {   68, 6612,    3247,  8, }, // Europe/Helsinki
    {   68, 8804,   35474, 10, }, // Europe/Isle_of_Man
    {   68, 1130,   35484,  8, }, // Europe/Istanbul
    {   68, 8823,    3271,  5, }, // Europe/Jersey
    {   68, 3979,   35492, 11, }, // Europe/Kaliningrad
    {   68, 8929,    3287,  5, }, // Europe/Kirov
    {   68, 2527,   35503,  5, }, // Europe/Kyiv
    {   68, 3213,   35508,  7, }, // Europe/Lisbon
    {   68, 6506,   35515,  7, }, // Europe/Ljubljana
    {   68, 2501,    3313,  6, }, // Europe/London
    {   68, 6365,   35522, 10, }, // Europe/Luxembourg
    {   68, 4892,    3330,  6, }, // Europe/Madrid
    {   68, 6397,    3336,  5, }, // Europe/Malta
    {   68, 6582,   35532,  8, }, // Europe/Mariehamn
    {   68, 3693,    3350,  5, }, // Europe/Minsk
    {   68, 6410,    3355,  6, }, // Europe/Monaco
    {   68, 3537,    3361,  6, }, // Europe/Moscow
    {   68, 6458,    3367,  4, }, // Europe/Oslo
    {   68, 4284,   35540,  5, }, // Europe/Paris
    {   68, 6424,    3376,  9, }, // Europe/Podgorica
    {   68, 6275,    3385,  4, }, // Europe/Prague
    {   68, 8837,    3390,  4, }, // Europe/Riga
    {   68, 6324,    3394,  3, }, // Europe/Rome
    {   68, 4331,    3397,  6, }, // Europe/Samara
    {   68, 6470,   35545, 10, }, // Europe/San_Marino
    {   68, 6245,   35555,  8, }, // Europe/Sarajevo
    {   68, 4451,    3420,  7, }, // Europe/Saratov
    {   68, 8849,   35563, 10, }, // Europe/Simferopol
    {   68, 6383,   35573,  6, }, // Europe/Skopje
    {   68, 6599,   35579,  6, }, // Europe/Sofia
    {   68, 6523,   35585,  8, }, // Europe/Stockholm
    {   68, 8867,   35593,  5, }, // Europe/Tallinn
    {   68, 6202,    3461,  6, }, // Europe/Tirane
    {   68, 8882,   35598,  8, }, // Europe/Ulyanovsk
    {   68, 6352,   35606,  5, }, // Europe/Vaduz
    {   68, 6567,    3481,  7, }, // Europe/Vatican
    {   68, 6231,   35611,  3, }, // Europe/Vienna
    {   68, 8899,   35614,  6, }, // Europe/Vilnius
    {   68, 4727,    3499,  9, }, // Europe/Volgograd
    {   68, 3190,    3508,  7, }, // Europe/Warsaw
    {   68, 6261,    3515,  6, }, // Europe/Zagreb
    {   68, 6540,   35620,  5, }, // Europe/Zurich
    {   68, 5078,   35625, 12, }, // Indian/Antananarivo
    {   68, 6947,    3539,  5, }, // Indian/Chagos
    {   68, 6046,   35637,  5, }, // Indian/Christmas
    {   68, 6063,    3556,  5, }, // Indian/Cocos
    {   68, 5029,   35642,  6, }, // Indian/Comoro
    {   68, 6661,    3578,  8, }, // Indian/Kerguelen
    {   68, 7260,   35648,  4, }, // Indian/Mahe
    {   68, 7050,   35652,  7, }, // Indian/Maldives
    {   68, 4069,   35659, 10, }, // Indian/Mauritius
    {   68, 5098,   35669,  5, }, // Indian/Mayotte
    {   68, 7211,   35674,  7, }, // Indian/Reunion
    {   68, 4422,   35681,  5, }, // Pacific/Apia
    {   68,  932,   35686,  6, }, // Pacific/Auckland
    {   68, 3706,    3626,  8, }, // Pacific/Bougainville
    {   68, 3015,   35692,  6, }, // Pacific/Chatham
    {   68, 3157,    3639,  4, }, // Pacific/Chuuk
    {   68, 2237,   35698, 14, }, // Pacific/Easter
    {   68, 7360,    3654,  4, }, // Pacific/Efate
    {   68, 7327,    3659,  7, }, // Pacific/Fakaofo
    {   68, 3902,    3666,  4, }, // Pacific/Fiji
    {   68, 7343,    3670,  8, }, // Pacific/Funafuti
    {   68, 6678,    3678,  9, }, // Pacific/Galapagos
    {   68, 6696,   35712,  7, }, // Pacific/Gambier
    {   68, 3822,   35719, 11, }, // Pacific/Guadalcanal
    {   68, 6018,    3724,  4, }, // Pacific/Guam
    {   68, 2723,   35730,  8, }, // Pacific/Honolulu
    {   68, 3049,   35738,  9, }, // Pacific/Kanton
    {   68, 3998,    3734, 10, }, // Pacific/Kiritimati
    {   68, 7019,   35747,  5, }, // Pacific/Kosrae
    {   68, 2842,   35752, 10, }, // Pacific/Kwajalein
    {   68, 4877,   35762,  6, }, // Pacific/Majuro
    {   68, 4051,    3765,  6, }, // Pacific/Marquesas
    {   68, 8914,   35768,  6, }, // Pacific/Midway
    {   68, 7084,    3798,  5, }, // Pacific/Nauru
    {   68, 7132,    3803,  4, }, // Pacific/Niue
    {   68, 4168,    3807,  7, }, // Pacific/Norfolk
    {   68, 7098,    3814,  5, }, // Pacific/Noumea
    {   68, 3126,   35774,  9, }, // Pacific/Pago_Pago
    {   68, 7155,    3828,  5, }, // Pacific/Palau
    {   68, 7194,    3833,  7, }, // Pacific/Pitcairn
    {   68, 3096,   35783,  6, }, // Pacific/Pohnpei
    {   68, 4807,   35789, 11, }, // Pacific/Port_Moresby
    {   68, 6076,    3857,  9, }, // Pacific/Rarotonga
    {   68, 6031,   35800,  6, }, // Pacific/Saipan
    {   68, 7312,   35806,  6, }, // Pacific/Tahiti
    {   68, 6712,    3877,  6, }, // Pacific/Tarawa
    {   68, 4583,    3883,  9, }, // Pacific/Tongatapu
    {   68, 7392,   35812,  4, }, // Pacific/Wake
    {   68, 7405,   35816,  5, }, // Pacific/Wallis
    {   69, 5059,   35821, 10, }, // Africa/Addis_Ababa Breton/Latin/France
    {   69, 7420,   26475,  5, }, // Africa/Algiers
    {   69,   14,       0,  6, }, // Africa/Asmara
    {   69, 2320,   35831,  5, }, // Africa/Cairo
    {   69, 4117,   35836, 25, }, // Africa/Casablanca
    {   69, 5166,   35861,  7, }, // Africa/El_Aaiun
    {   69, 6869,   20418,  4, }, // Africa/Lome
    {   69, 5113,   26511,  8, }, // Africa/Mogadishu
    {   69, 5271,   35868,  9, }, // Africa/Ndjamena
    {   69, 4435,       6,  8, }, // Africa/Sao_Tome
    {   69, 2866,   35877, 19, }, // Africa/Tripoli
    {   69, 6554,    6467,  5, }, // Africa/Tunis
    {   69, 4252,      14,  8, }, // America/Asuncion
    {   69,  237,      22,  8, }, // America/Atikokan
    {   69, 7623,      30, 17, }, // America/Bahia_Banderas
    {   69, 7646,   35896,  5, }, // America/Belem
    {   69, 4361,   20507,  6, }, // America/Bogota
    {   69, 3868,      47,  6, }, // America/Cancun
    {   69, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   69, 5723,      66,  7, }, // America/Curacao
    {   69, 5441,    6806,  8, }, // America/El_Salvador
    {   69, 5786,   35901,  9, }, // America/Guadeloupe
    {   69, 2281,   20535,  9, }, // America/Havana
    {   69,  481,      73, 13, }, // America/Indiana/Knox
    {   69, 7961,      86, 16, }, // America/Indiana/Marengo
    {   69, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   69, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   69, 8038,     139, 14, }, // America/Indiana/Vevay
    {   69, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   69, 8086,     171, 16, }, // America/Indiana/Winamac
    {   69, 2799,    3995,  7, }, // America/Jamaica
    {   69, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   69, 5932,     207, 22, }, // America/Lower_Princes
    {   69, 5805,    5260,  8, }, // America/Martinique
    {   69, 8220,     229,  6, }, // America/Merida
    {   69, 2949,   35910, 12, }, // America/Mexico_City
    {   69, 4391,    7149,  7, }, // America/Miquelon
    {   69, 1850,     235, 19, }, // America/Noronha
    {   69, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   69, 8329,     274, 20, }, // America/North_Dakota/Center
    {   69, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   69,  393,   35922, 14, }, // America/Nuuk
    {   69, 2356,   20665,  6, }, // America/Panama
    {   69, 1878,   26712,  9, }, // America/Sao_Paulo
    {   69, 6899,     321, 16, }, // America/Scoresbysund
    {   69, 8508,   35936, 16, }, // America/St_Barthelemy
    {   69, 2061,   35952, 12, }, // America/St_Johns
    {   69, 5863,   26749, 11, }, // America/St_Kitts
    {   69, 5880,   35964, 11, }, // America/St_Lucia
    {   69,  855,     379, 10, }, // America/St_Thomas
    {   69, 5913,   35975, 11, }, // America/St_Vincent
    {   69, 5756,   35986,  5, }, // America/Thule
    {   69, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   69, 5511,   35991,  7, }, // Asia/Anadyr
    {   69, 5534,    4168,  7, }, // Asia/Bahrain
    {   69, 3653,   35998,  5, }, // Asia/Baku
    {   69, 4086,   36003,  6, }, // Asia/Beirut
    {   69, 4601,   36009,  6, }, // Asia/Chita
    {   69, 4511,   36015,  7, }, // Asia/Colombo
    {   69, 4540,    4201,  6, }, // Asia/Damascus
    {   69, 1259,   36022, 15, }, // Asia/Ho_Chi_Minh
    {   69, 1290,   33501,  9, }, // Asia/Jerusalem
    {   69, 3560,   36037,  6, }, // Asia/Kabul
    {   69, 4316,   36043, 10, }, // Asia/Kamchatka
    {   69, 1185,     448,  9, }, // Asia/Kathmandu
    {   69,  992,   36053,  8, }, // Asia/Kolkata
    {   69, 5547,   36061,  6, }, // Asia/Kuwait
    {   69, 1211,    4321,  5, }, // Asia/Macau
    {   69, 6920,   36067,  6, }, // Asia/Muscat
    {   69, 2554,   36073,  8, }, // Asia/Nicosia
    {   69, 6961,   36081, 10, }, // Asia/Phnom_Penh
    {   69, 4214,   36091, 10, }, // Asia/Pyongyang
    {   69, 3300,   36101,  9, }, // Asia/Singapore
    {   69, 4781,   36110,  8, }, // Asia/Tashkent
    {   69, 1159,   26933,  6, }, // Asia/Urumqi
    {   69, 6977,   36118,  9, }, // Asia/Vientiane
    {   69, 1235,     477,  6, }, // Asia/Yangon
    {   69, 3883,   36127, 14, }, // Asia/Yekaterinburg
    {   69, 3663,   36141,  6, }, // Atlantic/Azores
    {   69, 5671,   36147,  8, }, // Atlantic/Bermuda
    {   69, 6628,   36155,  8, }, // Atlantic/Canary
    {   69, 3727,   36163,  8, }, // Atlantic/Cape_Verde
    {   69, 1395,   36171,  5, }, // Atlantic/Faroe
    {   69, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {   69, 7272,   36185, 13, }, // Atlantic/South_Georgia
    {   69, 6821,   36198, 12, }, // Atlantic/St_Helena
    {   69, 2300,    5911,  4, }, // Europe/Athens
    {   69, 6336,    8060,  7, }, // Europe/Belgrade
    {   69, 2167,   27022,  6, }, // Europe/Brussels
    {   69, 3928,   27029,  8, }, // Europe/Bucharest
    {   69, 6289,    4475, 10, }, // Europe/Copenhagen
    {   69, 2338,   36210,  6, }, // Europe/Dublin
    {   69, 6307,   36216,  9, }, // Europe/Gibraltar
    {   69, 8788,   36225,  9, }, // Europe/Guernsey
    {   69, 8804,   36234,  5, }, // Europe/Isle_of_Man
    {   69, 8823,   36239,  8, }, // Europe/Jersey
    {   69, 2527,    8148,  4, }, // Europe/Kyiv
    {   69, 3213,   21137,  6, }, // Europe/Lisbon
    {   69, 2501,   36247,  7, }, // Europe/London
    {   69, 6365,   36254, 11, }, // Europe/Luxembourg
    {   69, 6582,   36265,  9, }, // Europe/Mariehamn
    {   69, 3693,   36274,  5, }, // Europe/Minsk
    {   69, 3537,   36279,  6, }, // Europe/Moscow
    {   69, 4284,   33735,  5, }, // Europe/Paris
    {   69, 6275,   36285,  5, }, // Europe/Prague
    {   69, 6324,    6064,  4, }, // Europe/Rome
    {   69, 6202,    8255,  6, }, // Europe/Tirane
    {   69, 6567,    6096,  7, }, // Europe/Vatican
    {   69, 3190,   21244,  8, }, // Europe/Warsaw
    {   69, 6063,   36290,  5, }, // Indian/Cocos
    {   69, 5029,   36295,  7, }, // Indian/Comoro
    {   69, 6661,   36302,  9, }, // Indian/Kerguelen
    {   69, 7050,   36311,  8, }, // Indian/Maldives
    {   69, 4069,   36319,  5, }, // Indian/Mauritius
    {   69, 7211,   36324,  7, }, // Indian/Reunion
    {   69, 3157,     554,  5, }, // Pacific/Chuuk
    {   69, 2237,   36331,  9, }, // Pacific/Easter
    {   69, 3902,    4606,  5, }, // Pacific/Fiji
    {   69, 6678,   21277,  9, }, // Pacific/Galapagos
    {   69, 2723,    4611,  8, }, // Pacific/Honolulu
    {   69, 4051,   36340,  6, }, // Pacific/Marquesas
    {   69, 3096,     586,  7, }, // Pacific/Pohnpei
    {   70, 6788,   36346,  7, }, // Africa/Abidjan Bulgarian/Cyrillic/Bulgaria
    {   70, 6760,   27178,  4, }, // Africa/Accra
    {   70, 5059,   33846, 10, }, // Africa/Addis_Ababa
    {   70, 7420,     626,  5, }, // Africa/Algiers
    {   70,   14,   27197,  6, }, // Africa/Asmara
    {   70,   44,     637,  6, }, // Africa/Bamako
    {   70, 5257,   33856,  6, }, // Africa/Bangui
    {   70, 6746,   27208,  7, }, // Africa/Banjul
    {   70, 7435,     654,  5, }, // Africa/Bissau
    {   70, 4957,   36353,  9, }, // Africa/Blantyre
    {   70, 5287,   33874,  8, }, // Africa/Brazzaville
    {   70, 4922,     676,  9, }, // Africa/Bujumbura
    {   70, 2320,   36362,  5, }, // Africa/Cairo
    {   70, 4117,   33896, 10, }, // Africa/Casablanca
    {   70, 7449,     699,  5, }, // Africa/Ceuta
    {   70, 6773,     704,  7, }, // Africa/Conakry
    {   70, 6840,     711,  5, }, // Africa/Dakar
    {   70, 5130,   36367, 12, }, // Africa/Dar_es_Salaam
    {   70, 5043,   36379,  7, }, // Africa/Djibouti
    {   70, 5243,     734,  5, }, // Africa/Douala
    {   70, 5166,   36386,  6, }, // Africa/El_Aaiun
    {   70, 6853,   36392,  8, }, // Africa/Freetown
    {   70, 4906,     753,  8, }, // Africa/Gaborone
    {   70, 5015,   33913,  6, }, // Africa/Harare
    {   70, 4479,   36400, 11, }, // Africa/Johannesburg
    {   70, 4499,   27305,  5, }, // Africa/Juba
    {   70, 5151,     783,  7, }, // Africa/Kampala
    {   70, 4524,     790,  6, }, // Africa/Khartoum
    {   70, 4973,     796,  6, }, // Africa/Kigali
    {   70, 5306,     802,  7, }, // Africa/Kinshasa
    {   70, 4744,     809,  5, }, // Africa/Lagos
    {   70, 5336,     814,  8, }, // Africa/Libreville
    {   70, 6869,     822,  4, }, // Africa/Lome
    {   70, 5211,     826,  6, }, // Africa/Luanda
    {   70, 4939,     832,  9, }, // Africa/Lubumbashi
    {   70, 5001,     841,  6, }, // Africa/Lusaka
    {   70, 5322,     847,  6, }, // Africa/Malabo
    {   70, 4987,   33945,  6, }, // Africa/Maputo
    {   70, 5197,     859,  6, }, // Africa/Maseru
    {   70, 5182,     865,  7, }, // Africa/Mbabane
    {   70, 5113,   36411,  8, }, // Africa/Mogadishu
    {   70, 7034,   36419,  8, }, // Africa/Monrovia
    {   70, 3853,   36427,  7, }, // Africa/Nairobi
    {   70, 5271,   27386,  8, }, // Africa/Ndjamena
    {   70, 5354,   36434,  6, }, // Africa/Niamey
    {   70, 6803,     908,  7, }, // Africa/Nouakchott
    {   70, 6727,     915,  8, }, // Africa/Ouagadougou
    {   70, 5225,   33974, 10, }, // Africa/Porto-Novo
    {   70, 4435,   33984,  8, }, // Africa/Sao_Tome
    {   70, 2866,     941,  7, }, // Africa/Tripoli
    {   70, 6554,     948,  5, }, // Africa/Tunis
    {   70, 4152,     953,  7, }, // Africa/Windhoek
    {   70,  132,     960,  4, }, // America/Adak
    {   70, 3346,   36440,  8, }, // America/Anchorage
    {   70, 5607,   36448,  7, }, // America/Anguilla
    {   70, 5624,     978,  7, }, // America/Antigua
    {   70, 4554,   36455,  9, }, // America/Araguaina
    {   70,  166,   36464, 12, }, // America/Argentina/Buenos_Aires
    {   70,   91,    1006,  9, }, // America/Argentina/Catamarca
    {   70,  270,   34035,  7, }, // America/Argentina/Cordoba
    {   70,  441,   36476,  5, }, // America/Argentina/Jujuy
    {   70, 7462,   34047,  8, }, // America/Argentina/La_Rioja
    {   70,  565,    1035,  7, }, // America/Argentina/Mendoza
    {   70, 7489,   36481, 11, }, // America/Argentina/Rio_Gallegos
    {   70, 7520,    1053,  5, }, // America/Argentina/Salta
    {   70, 7544,   34073,  8, }, // America/Argentina/San_Juan
    {   70, 5580,   36492,  8, }, // America/Argentina/San_Luis
    {   70, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {   70, 7597,   27526,  5, }, // America/Argentina/Ushuaia
    {   70, 5640,    1087,  5, }, // America/Aruba
    {   70, 4252,   34095,  8, }, // America/Asuncion
    {   70,  237,   34103,  8, }, // America/Atikokan
    {   70, 3679,   36500,  4, }, // America/Bahia
    {   70, 7623,   36504, 16, }, // America/Bahia_Banderas
    {   70, 5654,    1131,  8, }, // America/Barbados
    {   70, 7646,   34130,  5, }, // America/Belem
    {   70, 5407,    1144,  5, }, // America/Belize
    {   70, 7660,   36520, 11, }, // America/Blanc-Sablon
    {   70, 7681,   34154,  9, }, // America/Boa_Vista
    {   70, 4361,    1170,  6, }, // America/Bogota
    {   70, 7699,   36531,  5, }, // America/Boise
    {   70, 7713,   36536, 13, }, // America/Cambridge_Bay
    {   70, 7735,   34179, 12, }, // America/Campo_Grande
    {   70, 3868,    1205,  6, }, // America/Cancun
    {   70, 4694,    1211,  7, }, // America/Caracas
    {   70, 4345,   36549,  5, }, // America/Cayenne
    {   70, 5496,   36554, 17, }, // America/Cayman
    {   70, 2260,    1247,  6, }, // America/Chicago
    {   70, 7756,    1253,  6, }, // America/Chihuahua
    {   70, 7774,   36571, 13, }, // America/Ciudad_Juarez
    {   70, 5422,   36584, 10, }, // America/Costa_Rica
    {   70, 7796,   36594,  7, }, // America/Creston
    {   70, 3791,   36601,  5, }, // America/Cuiaba
    {   70, 5723,   36606,  7, }, // America/Curacao
    {   70, 7812,   36613, 12, }, // America/Danmarkshavn
    {   70, 7833,   36625,  6, }, // America/Dawson
    {   70, 7848,   36631, 12, }, // America/Dawson_Creek
    {   70,  805,   36643,  6, }, // America/Denver
    {   70, 3465,   36649,  7, }, // America/Detroit
    {   70, 5739,    1332,  8, }, // America/Dominica
    {   70,  893,   36656,  8, }, // America/Edmonton
    {   70, 7869,   36664,  8, }, // America/Eirunepe
    {   70, 5441,    1356,  8, }, // America/El_Salvador
    {   70, 7886,   36672, 11, }, // America/Fort_Nelson
    {   70, 7906,    1375,  9, }, // America/Fortaleza
    {   70, 7924,   36683,  9, }, // America/Glace_Bay
    {   70, 6881,   36692,  7, }, // America/Goose_Bay
    {   70, 4612,   36699, 10, }, // America/Grand_Turk
    {   70, 5770,    1410,  7, }, // America/Grenada
    {   70, 5786,    1417,  9, }, // America/Guadeloupe
    {   70, 3760,    1426,  9, }, // America/Guatemala
    {   70, 4841,   36709,  7, }, // America/Guayaquil
    {   70, 6932,   27854,  5, }, // America/Guyana
    {   70, 1939,   34310,  8, }, // America/Halifax
    {   70, 2281,   34318,  6, }, // America/Havana
    {   70, 7942,   36716,  9, }, // America/Hermosillo
    {   70,  348,    1471, 12, }, // America/Indiana/Indianapolis
    {   70,  481,    1483,  4, }, // America/Indiana/Knox
    {   70, 7961,    1496,  7, }, // America/Indiana/Marengo
    {   70, 7985,   36725, 10, }, // America/Indiana/Petersburg
    {   70, 8012,   34385,  8, }, // America/Indiana/Tell_City
    {   70, 8038,   36735,  4, }, // America/Indiana/Vevay
    {   70, 8060,   36739,  7, }, // America/Indiana/Vincennes
    {   70, 8086,    1563,  7, }, // America/Indiana/Winamac
    {   70, 8110,    1570,  6, }, // America/Inuvik
    {   70,  660,   34453,  8, }, // America/Iqaluit
    {   70, 2799,   28011,  6, }, // America/Jamaica
    {   70, 5380,   36746,  5, }, // America/Juneau
    {   70,  521,    1594,  7, }, // America/Kentucky/Louisville
    {   70, 8125,   34472,  9, }, // America/Kentucky/Monticello
    {   70, 5704,   36751, 10, }, // America/Kralendijk
    {   70, 4376,   36761,  6, }, // America/La_Paz
    {   70, 7169,    1638,  4, }, // America/Lima
    {   70, 3239,   36767, 12, }, // America/Los_Angeles
    {   70, 5932,   36779, 20, }, // America/Lower_Princes
    {   70, 8153,   36799,  6, }, // America/Maceio
    {   70, 8168,    1677,  7, }, // America/Managua
    {   70, 1908,    1684,  6, }, // America/Manaus
    {   70, 5897,    1690,  6, }, // America/Marigot
    {   70, 5805,    1696,  9, }, // America/Martinique
    {   70, 8184,    1705,  9, }, // America/Matamoros
    {   70, 2917,    1714,  8, }, // America/Mazatlan
    {   70, 8202,    1722,  8, }, // America/Menominee
    {   70, 8220,    1730,  6, }, // America/Merida
    {   70, 8235,    1736, 10, }, // America/Metlakatla
    {   70, 2949,   34557, 12, }, // America/Mexico_City
    {   70, 4391,    1752,  7, }, // America/Miquelon
    {   70, 8254,    1759,  7, }, // America/Moncton
    {   70, 8270,   36805,  8, }, // America/Monterrey
    {   70, 4098,    1775, 10, }, // America/Montevideo
    {   70, 5824,   34577,  9, }, // America/Montserrat
    {   70, 5481,   34586,  5, }, // America/Nassau
    {   70, 2379,   36813,  7, }, // America/New_York
    {   70, 8288,   36820,  4, }, // America/Nome
    {   70, 1850,   36824,  6, }, // America/Noronha
    {   70, 8301,   36830,  4, }, // America/North_Dakota/Beulah
    {   70, 8329,   36834,  6, }, // America/North_Dakota/Center
    {   70, 8357,   36840,  9, }, // America/North_Dakota/New_Salem
    {   70,  393,    1890,  4, }, // America/Nuuk
    {   70, 8388,    1894,  7, }, // America/Ojinaga
    {   70, 2356,    1901,  6, }, // America/Panama
    {   70, 6173,    1907, 10, }, // America/Paramaribo
    {   70, 2973,    1917,  6, }, // America/Phoenix
    {   70, 3945,    1923, 12, }, // America/Port-au-Prince
    {   70, 5954,   36849, 13, }, // America/Port_of_Spain
    {   70, 8404,   36862, 11, }, // America/Porto_Velho
    {   70, 5843,   36873, 11, }, // America/Puerto_Rico
    {   70, 4030,   34711, 12, }, // America/Punta_Arenas
    {   70, 8424,   34723, 12, }, // America/Rankin_Inlet
    {   70, 8445,   34735,  6, }, // America/Recife
    {   70, 1995,   36884,  8, }, // America/Regina
    {   70, 8460,   36892,  7, }, // America/Resolute
    {   70,  695,   34754, 10, }, // America/Rio_Branco
    {   70, 8477,   34764,  8, }, // America/Santarem
    {   70, 2201,   36899,  7, }, // America/Santiago
    {   70, 6111,   34781, 13, }, // America/Santo_Domingo
    {   70, 1878,   36906,  9, }, // America/Sao_Paulo
    {   70, 6899,   36915, 10, }, // America/Scoresbysund
    {   70, 8494,    2074,  5, }, // America/Sitka
    {   70, 8508,   36925, 13, }, // America/St_Barthelemy
    {   70, 2061,   36938, 11, }, // America/St_Johns
    {   70, 5863,   36949, 10, }, // America/St_Kitts
    {   70, 5880,   36959, 11, }, // America/St_Lucia
    {   70,  855,   36970, 11, }, // America/St_Thomas
    {   70, 5913,   36981, 13, }, // America/St_Vincent
    {   70, 8530,   36994, 12, }, // America/Swift_Current
    {   70, 5461,    2156, 11, }, // America/Tegucigalpa
    {   70, 5756,    2167,  4, }, // America/Thule
    {   70,  313,    2171,  7, }, // America/Tijuana
    {   70,  608,    2178,  7, }, // America/Toronto
    {   70, 5688,    2185,  7, }, // America/Tortola
    {   70, 2093,   37006,  8, }, // America/Vancouver
    {   70, 2144,   28567,  8, }, // America/Whitehorse
    {   70,  734,   37014,  7, }, // America/Winnipeg
    {   70, 8552,   28582,  6, }, // America/Yakutat
    {   70, 6001,   37021,  5, }, // Antarctica/Casey
    {   70, 6094,   37026,  6, }, // Antarctica/Davis
    {   70, 6133,   37032, 12, }, // Antarctica/DumontDUrville
    {   70, 8568,    2249,  8, }, // Antarctica/Macquarie
    {   70, 7066,   37044,  6, }, // Antarctica/Mawson
    {   70, 7113,   37050,  8, }, // Antarctica/McMurdo
    {   70, 8589,   37058,  6, }, // Antarctica/Palmer
    {   70, 7226,    2278,  6, }, // Antarctica/Rothera
    {   70, 7295,   34953,  4, }, // Antarctica/Syowa
    {   70, 8607,    2289,  4, }, // Antarctica/Troll
    {   70, 7374,   34957,  6, }, // Antarctica/Vostok
    {   70, 1429,   37064, 10, }, // Arctic/Longyearbyen
    {   70, 5570,    2310,  4, }, // Asia/Aden
    {   70, 5395,   34974,  6, }, // Asia/Almaty
    {   70, 3968,   28663,  4, }, // Asia/Amman
    {   70, 5511,   34980,  6, }, // Asia/Anadyr
    {   70, 5523,    2331,  5, }, // Asia/Aqtau
    {   70, 5368,    2336,  6, }, // Asia/Aqtobe
    {   70,  964,    2342,  7, }, // Asia/Ashgabat
    {   70, 8624,   37074,  6, }, // Asia/Atyrau
    {   70, 3607,    2355,  6, }, // Asia/Baghdad
    {   70, 5534,   37080,  7, }, // Asia/Bahrain
    {   70, 3653,    2368,  4, }, // Asia/Baku
    {   70, 4466,   34999,  6, }, // Asia/Bangkok
    {   70, 3571,    2379,  7, }, // Asia/Barnaul
    {   70, 4086,   28695,  6, }, // Asia/Beirut
    {   70, 3778,    2392,  6, }, // Asia/Bishkek
    {   70, 5989,   28707,  6, }, // Asia/Brunei
    {   70, 4601,    2404,  4, }, // Asia/Chita
    {   70, 4511,    2408,  7, }, // Asia/Colombo
    {   70, 4540,    2415,  6, }, // Asia/Damascus
    {   70, 1093,     711,  4, }, // Asia/Dhaka
    {   70, 6192,    2426,  4, }, // Asia/Dili
    {   70, 3596,   28728,  5, }, // Asia/Dubai
    {   70, 6159,    2435,  7, }, // Asia/Dushanbe
    {   70, 8636,    2442,  9, }, // Asia/Famagusta
    {   70, 8651,    2451,  4, }, // Asia/Gaza
    {   70, 4795,   35018,  6, }, // Asia/Hebron
    {   70, 1259,    2461,  7, }, // Asia/Ho_Chi_Minh
    {   70, 2704,   37087,  7, }, // Asia/Hong_Kong
    {   70, 4771,    2475,  4, }, // Asia/Hovd
    {   70, 4184,    2479,  7, }, // Asia/Irkutsk
    {   70, 7006,   28770,  8, }, // Asia/Jakarta
    {   70, 6992,   28778,  8, }, // Asia/Jayapura
    {   70, 1290,   37094,  9, }, // Asia/Jerusalem
    {   70, 3560,    2510,  5, }, // Asia/Kabul
    {   70, 4316,    2529,  8, }, // Asia/Kamchatka
    {   70, 4239,    2540,  6, }, // Asia/Karachi
    {   70, 1185,    2546,  8, }, // Asia/Kathmandu
    {   70, 8661,   35065,  7, }, // Asia/Khandyga
    {   70,  992,   37103,  7, }, // Asia/Kolkata
    {   70, 4197,   37110, 10, }, // Asia/Krasnoyarsk
    {   70, 4859,   35090, 12, }, // Asia/Kuala_Lumpur
    {   70, 5976,    2592,  5, }, // Asia/Kuching
    {   70, 5547,   28825,  6, }, // Asia/Kuwait
    {   70, 1211,    2604,  5, }, // Asia/Macau
    {   70, 4017,    2609,  7, }, // Asia/Magadan
    {   70, 1349,    2616,  7, }, // Asia/Makassar
    {   70, 7182,    2623,  6, }, // Asia/Manila
    {   70, 6920,   35113,  6, }, // Asia/Muscat
    {   70, 2554,   37120,  7, }, // Asia/Nicosia
    {   70, 8675,    2642, 11, }, // Asia/Novokuznetsk
    {   70, 4135,    2653, 11, }, // Asia/Novosibirsk
    {   70, 4229,    2664,  4, }, // Asia/Omsk
    {   70, 7145,   37127,  4, }, // Asia/Oral
    {   70, 6961,   35142,  8, }, // Asia/Phnom_Penh
    {   70, 8693,    2681,  9, }, // Asia/Pontianak
    {   70, 4214,   37131,  6, }, // Asia/Pyongyang
    {   70, 5559,    2697,  5, }, // Asia/Qatar
    {   70, 8708,   37137,  8, }, // Asia/Qostanay
    {   70, 4269,   37145,  9, }, // Asia/Qyzylorda
    {   70, 3584,   37154,  4, }, // Asia/Riyadh
    {   70, 4408,    2732,  7, }, // Asia/Sakhalin
    {   70, 7245,    2739,  9, }, // Asia/Samarkand
    {   70, 3279,    2748,  4, }, // Asia/Seoul
    {   70, 1053,   28933,  6, }, // Asia/Shanghai
    {   70, 3300,    2758,  8, }, // Asia/Singapore
    {   70, 4297,   37158, 13, }, // Asia/Srednekolymsk
    {   70, 3263,   37171,  5, }, // Asia/Taipei
    {   70, 4781,    2785,  7, }, // Asia/Tashkent
    {   70, 3915,   35206,  7, }, // Asia/Tbilisi
    {   70, 2772,   35213,  7, }, // Asia/Tehran
    {   70, 1317,    2803,  7, }, // Asia/Thimphu
    {   70, 2821,    2810,  5, }, // Asia/Tokyo
    {   70, 4572,    2815,  5, }, // Asia/Tomsk
    {   70, 1021,   35225, 10, }, // Asia/Ulaanbaatar
    {   70, 1159,    2830,  6, }, // Asia/Urumqi
    {   70, 8722,    2836,  8, }, // Asia/Ust-Nera
    {   70, 6977,   37176,  7, }, // Asia/Vientiane
    {   70, 4710,    2851, 11, }, // Asia/Vladivostok
    {   70, 4828,   37183,  6, }, // Asia/Yakutsk
    {   70, 1235,   29043,  6, }, // Asia/Yangon
    {   70, 3883,    2875, 12, }, // Asia/Yekaterinburg
    {   70, 3747,    2887,  6, }, // Asia/Yerevan
    {   70, 3663,   37189, 15, }, // Atlantic/Azores
    {   70, 5671,   37204, 17, }, // Atlantic/Bermuda
    {   70, 6628,   37221, 16, }, // Atlantic/Canary
    {   70, 3727,   37237, 10, }, // Atlantic/Cape_Verde
    {   70, 1395,   37247, 17, }, // Atlantic/Faroe
    {   70, 8736,   37264,  7, }, // Atlantic/Madeira
    {   70, 2748,   37271,  8, }, // Atlantic/Reykjavik
    {   70, 7272,   37279, 13, }, // Atlantic/South_Georgia
    {   70, 6821,   37292, 11, }, // Atlantic/St_Helena
    {   70, 6644,    3029,  6, }, // Atlantic/Stanley
    {   70, 1670,    3035,  8, }, // Australia/Adelaide
    {   70, 1635,   37303,  8, }, // Australia/Brisbane
    {   70, 1799,   37311, 11, }, // Australia/Broken_Hill
    {   70, 1583,    3061,  6, }, // Australia/Darwin
    {   70, 3637,   29240,  4, }, // Australia/Eucla
    {   70, 1516,    3072,  6, }, // Australia/Hobart
    {   70, 8753,    3078,  8, }, // Australia/Lindeman
    {   70, 1547,   37322,  8, }, // Australia/Lord_Howe
    {   70, 1727,   37330,  7, }, // Australia/Melbourne
    {   70, 1762,   37337,  4, }, // Australia/Perth
    {   70, 1463,   37341,  5, }, // Australia/Sydney
    {   70, 6441,    3111,  9, }, // Europe/Amsterdam
    {   70, 6216,   29275,  6, }, // Europe/Andorra
    {   70, 3620,    3127,  8, }, // Europe/Astrakhan
    {   70, 2300,   35401,  5, }, // Europe/Athens
    {   70, 6336,    3139,  7, }, // Europe/Belgrade
    {   70, 4757,    3146,  6, }, // Europe/Berlin
    {   70, 6488,    3152, 10, }, // Europe/Bratislava
    {   70, 2167,   37346,  7, }, // Europe/Brussels
    {   70, 3928,   37353,  7, }, // Europe/Bucharest
    {   70, 3806,   37360,  8, }, // Europe/Budapest
    {   70, 8772,   37368,  8, }, // Europe/Busingen
    {   70, 2583,    3209,  7, }, // Europe/Chisinau
    {   70, 6289,   35452, 10, }, // Europe/Copenhagen
    {   70, 2338,   37376,  6, }, // Europe/Dublin
    {   70, 6307,    3232,  9, }, // Europe/Gibraltar
    {   70, 8788,   37382,  6, }, // Europe/Guernsey
    {   70, 6612,   37388,  8, }, // Europe/Helsinki
    {   70, 8804,   37396, 10, }, // Europe/Isle_of_Man
    {   70, 1130,   35484,  8, }, // Europe/Istanbul
    {   70, 8823,   37406,  6, }, // Europe/Jersey
    {   70, 3979,    3276, 11, }, // Europe/Kaliningrad
    {   70, 8929,    3287,  5, }, // Europe/Kirov
    {   70, 2527,    3292,  4, }, // Europe/Kyiv
    {   70, 3213,   35508,  7, }, // Europe/Lisbon
    {   70, 6506,   29432,  7, }, // Europe/Ljubljana
    {   70, 2501,    3313,  6, }, // Europe/London
    {   70, 6365,   29445, 10, }, // Europe/Luxembourg
    {   70, 4892,    3330,  6, }, // Europe/Madrid
    {   70, 6397,    3336,  5, }, // Europe/Malta
    {   70, 6582,    3341,  9, }, // Europe/Mariehamn
    {   70, 3693,    3350,  5, }, // Europe/Minsk
    {   70, 6410,    3355,  6, }, // Europe/Monaco
    {   70, 3537,    3361,  6, }, // Europe/Moscow
    {   70, 6458,    3367,  4, }, // Europe/Oslo
    {   70, 4284,    3371,  5, }, // Europe/Paris
    {   70, 6424,    3376,  9, }, // Europe/Podgorica
    {   70, 6275,    3385,  5, }, // Europe/Prague
    {   70, 8837,    3390,  4, }, // Europe/Riga
    {   70, 6324,    3394,  3, }, // Europe/Rome
    {   70, 4331,    3397,  6, }, // Europe/Samara
    {   70, 6470,   35545, 10, }, // Europe/San_Marino
    {   70, 6245,    3413,  7, }, // Europe/Sarajevo
    {   70, 4451,    3420,  7, }, // Europe/Saratov
    {   70, 8849,    3427, 10, }, // Europe/Simferopol
    {   70, 6383,   37412,  6, }, // Europe/Skopje
    {   70, 6599,   37418,  5, }, // Europe/Sofia
    {   70, 6523,   35585,  8, }, // Europe/Stockholm
    {   70, 8867,   35593,  5, }, // Europe/Tallinn
    {   70, 6202,    3461,  6, }, // Europe/Tirane
    {   70, 8882,   37423,  8, }, // Europe/Ulyanovsk
    {   70, 6352,    3476,  5, }, // Europe/Vaduz
    {   70, 6567,    3481,  7, }, // Europe/Vatican
    {   70, 6231,   37431,  5, }, // Europe/Vienna
    {   70, 8899,   37436,  6, }, // Europe/Vilnius
    {   70, 4727,    3499,  9, }, // Europe/Volgograd
    {   70, 3190,    3508,  7, }, // Europe/Warsaw
    {   70, 6261,    3515,  6, }, // Europe/Zagreb
    {   70, 6540,   37442,  5, }, // Europe/Zurich
    {   70, 5078,   35625, 12, }, // Indian/Antananarivo
    {   70, 6947,    3539,  5, }, // Indian/Chagos
    {   70, 6046,   37447,  9, }, // Indian/Christmas
    {   70, 6063,   37456, 16, }, // Indian/Cocos
    {   70, 5029,   37472, 16, }, // Indian/Comoro
    {   70, 6661,    3578,  8, }, // Indian/Kerguelen
    {   70, 7260,    3586,  3, }, // Indian/Mahe
    {   70, 7050,   35652,  7, }, // Indian/Maldives
    {   70, 4069,   37488,  8, }, // Indian/Mauritius
    {   70, 5098,   37496,  5, }, // Indian/Mayotte
    {   70, 7211,   37501,  7, }, // Indian/Reunion
    {   70, 4422,   37508,  4, }, // Pacific/Apia
    {   70,  932,   35686,  6, }, // Pacific/Auckland
    {   70, 3706,    3626,  8, }, // Pacific/Bougainville
    {   70, 3015,   37512,  5, }, // Pacific/Chatham
    {   70, 3157,   37517,  4, }, // Pacific/Chuuk
    {   70, 2237,   37521, 18, }, // Pacific/Easter
    {   70, 7360,    3654,  5, }, // Pacific/Efate
    {   70, 7327,    3659,  7, }, // Pacific/Fakaofo
    {   70, 3902,   37539,  5, }, // Pacific/Fiji
    {   70, 7343,    3670,  8, }, // Pacific/Funafuti
    {   70, 6678,    3678,  9, }, // Pacific/Galapagos
    {   70, 6696,   37544,  6, }, // Pacific/Gambier
    {   70, 3822,    3713, 11, }, // Pacific/Guadalcanal
    {   70, 6018,    3724,  4, }, // Pacific/Guam
    {   70, 2723,   35730,  8, }, // Pacific/Honolulu
    {   70, 3049,   37550,  9, }, // Pacific/Kanton
    {   70, 3998,    3734, 10, }, // Pacific/Kiritimati
    {   70, 7019,   37559,  6, }, // Pacific/Kosrae
    {   70, 2842,   37565,  9, }, // Pacific/Kwajalein
    {   70, 4877,   37574,  7, }, // Pacific/Majuro
    {   70, 4051,   37581, 16, }, // Pacific/Marquesas
    {   70, 8914,   37597,  6, }, // Pacific/Midway
    {   70, 7084,    3798,  5, }, // Pacific/Nauru
    {   70, 7132,    3803,  4, }, // Pacific/Niue
    {   70, 4168,    3807,  7, }, // Pacific/Norfolk
    {   70, 7098,    3814,  5, }, // Pacific/Noumea
    {   70, 3126,   35774,  9, }, // Pacific/Pago_Pago
    {   70, 7155,    3828,  5, }, // Pacific/Palau
    {   70, 7194,    3833,  7, }, // Pacific/Pitcairn
    {   70, 3096,   37603,  6, }, // Pacific/Pohnpei
    {   70, 4807,   37609, 11, }, // Pacific/Port_Moresby
    {   70, 6076,    3857,  9, }, // Pacific/Rarotonga
    {   70, 6031,   29935,  6, }, // Pacific/Saipan
    {   70, 7312,    3872,  5, }, // Pacific/Tahiti
    {   70, 6712,   37620,  6, }, // Pacific/Tarawa
    {   70, 4583,    3883,  9, }, // Pacific/Tongatapu
    {   70, 7392,   37626,  4, }, // Pacific/Wake
    {   70, 7405,   37630,  5, }, // Pacific/Wallis
    {   71, 6788,   37635,  8, }, // Africa/Abidjan Burmese/Myanmar/Myanmar
    {   71, 6760,   37643,  6, }, // Africa/Accra
    {   71, 5059,   37649, 12, }, // Africa/Addis_Ababa
    {   71, 7420,   37661, 15, }, // Africa/Algiers
    {   71,   14,   37676, 10, }, // Africa/Asmara
    {   71,   44,   37686,  7, }, // Africa/Bamako
    {   71, 5257,   37693,  7, }, // Africa/Bangui
    {   71, 6746,   37700,  9, }, // Africa/Banjul
    {   71, 7435,   37709,  7, }, // Africa/Bissau
    {   71, 4957,   37716, 14, }, // Africa/Blantyre
    {   71, 5287,   37730, 11, }, // Africa/Brazzaville
    {   71, 4922,   37741, 12, }, // Africa/Bujumbura
    {   71, 2320,   37753,  8, }, // Africa/Cairo
    {   71, 4117,   37761, 10, }, // Africa/Casablanca
    {   71, 7449,   37771,  7, }, // Africa/Ceuta
    {   71, 6773,   37778,  9, }, // Africa/Conakry
    {   71, 6840,   37787,  6, }, // Africa/Dakar
    {   71, 5130,   37793, 12, }, // Africa/Dar_es_Salaam
    {   71, 5043,   37805,  7, }, // Africa/Djibouti
    {   71, 5243,   37812,  9, }, // Africa/Douala
    {   71, 5166,   37821, 12, }, // Africa/El_Aaiun
    {   71, 6853,   37833, 12, }, // Africa/Freetown
    {   71, 4906,   37845, 11, }, // Africa/Gaborone
    {   71, 5015,   37856,  9, }, // Africa/Harare
    {   71, 4479,   37865, 15, }, // Africa/Johannesburg
    {   71, 4499,   37880,  5, }, // Africa/Juba
    {   71, 5151,   37885,  7, }, // Africa/Kampala
    {   71, 4524,   37892,  8, }, // Africa/Khartoum
    {   71, 4973,   37900,  7, }, // Africa/Kigali
    {   71, 5306,   37907,  8, }, // Africa/Kinshasa
    {   71, 4744,   37915,  7, }, // Africa/Lagos
    {   71, 5336,   37922, 10, }, // Africa/Libreville
    {   71, 6869,   37932,  5, }, // Africa/Lome
    {   71, 5211,   37937,  7, }, // Africa/Luanda
    {   71, 4939,   37944, 12, }, // Africa/Lubumbashi
    {   71, 5001,   37956,  6, }, // Africa/Lusaka
    {   71, 5322,   37962,  7, }, // Africa/Malabo
    {   71, 4987,   37969,  8, }, // Africa/Maputo
    {   71, 5197,   37977,  7, }, // Africa/Maseru
    {   71, 5182,   37984,  8, }, // Africa/Mbabane
    {   71, 5113,   37992, 13, }, // Africa/Mogadishu
    {   71, 7034,   38005, 14, }, // Africa/Monrovia
    {   71, 3853,   38019, 10, }, // Africa/Nairobi
    {   71, 5271,   38029, 10, }, // Africa/Ndjamena
    {   71, 5354,   38039,  6, }, // Africa/Niamey
    {   71, 6803,   38045, 15, }, // Africa/Nouakchott
    {   71, 6727,   38060,  9, }, // Africa/Ouagadougou
    {   71, 5225,   38069, 13, }, // Africa/Porto-Novo
    {   71, 4435,   38082, 10, }, // Africa/Sao_Tome
    {   71, 2866,   38092,  8, }, // Africa/Tripoli
    {   71, 6554,   38100,  6, }, // Africa/Tunis
    {   71, 4152,   38106,  9, }, // Africa/Windhoek
    {   71,  132,   38115,  5, }, // America/Adak
    {   71, 3346,   38120, 11, }, // America/Anchorage
    {   71, 5607,   38131,  7, }, // America/Anguilla
    {   71, 5624,   38138,  8, }, // America/Antigua
    {   71, 4554,   38146, 11, }, // America/Araguaina
    {   71,  166,   38157, 13, }, // America/Argentina/Buenos_Aires
    {   71,   91,   38170,  9, }, // America/Argentina/Catamarca
    {   71,  270,   38179,  8, }, // America/Argentina/Cordoba
    {   71,  441,   38187,  6, }, // America/Argentina/Jujuy
    {   71, 7462,   38193, 10, }, // America/Argentina/La_Rioja
    {   71,  565,   38203,  8, }, // America/Argentina/Mendoza
    {   71, 7489,   38211, 15, }, // America/Argentina/Rio_Gallegos
    {   71, 7520,   38226,  6, }, // America/Argentina/Salta
    {   71, 7544,   38232,  8, }, // America/Argentina/San_Juan
    {   71, 5580,   38240, 10, }, // America/Argentina/San_Luis
    {   71, 7571,   38250,  7, }, // America/Argentina/Tucuman
    {   71, 7597,   38257,  8, }, // America/Argentina/Ushuaia
    {   71, 5640,   38265,  7, }, // America/Aruba
    {   71, 4252,   38272, 11, }, // America/Asuncion
    {   71,  237,   38283, 10, }, // America/Atikokan
    {   71, 3679,   38293,  6, }, // America/Bahia
    {   71, 7623,   38299, 16, }, // America/Bahia_Banderas
    {   71, 5654,   38315, 11, }, // America/Barbados
    {   71, 7646,   38326,  7, }, // America/Belem
    {   71, 5407,   38333,  5, }, // America/Belize
    {   71, 7660,   38338, 15, }, // America/Blanc-Sablon
    {   71, 7681,   38353, 11, }, // America/Boa_Vista
    {   71, 4361,   38364,  8, }, // America/Bogota
    {   71, 7699,   38372,  8, }, // America/Boise
    {   71, 7713,   38380, 16, }, // America/Cambridge_Bay
    {   71, 7735,   38396, 14, }, // America/Campo_Grande
    {   71, 3868,   38410,  6, }, // America/Cancun
    {   71, 4694,   38416,  8, }, // America/Caracas
    {   71, 4345,   38424,  7, }, // America/Cayenne
    {   71, 5496,   38431,  5, }, // America/Cayman
    {   71, 2260,   38436,  8, }, // America/Chicago
    {   71, 7756,   38444, 11, }, // America/Chihuahua
    {   71, 7774,   38455, 18, }, // America/Ciudad_Juarez
    {   71, 5422,   38473, 11, }, // America/Costa_Rica
    {   71, 7796,   38484,  9, }, // America/Creston
    {   71, 3791,   38493,  7, }, // America/Cuiaba
    {   71, 5723,   38500, 10, }, // America/Curacao
    {   71, 7812,   38510, 13, }, // America/Danmarkshavn
    {   71, 7833,   38523,  7, }, // America/Dawson
    {   71, 7848,   38530, 13, }, // America/Dawson_Creek
    {   71,  805,   38543,  7, }, // America/Denver
    {   71, 3465,   38550, 10, }, // America/Detroit
    {   71, 5739,   38560,  9, }, // America/Dominica
    {   71,  893,   38569, 12, }, // America/Edmonton
    {   71, 7869,   38581,  8, }, // America/Eirunepe
    {   71, 5441,   38589, 12, }, // America/El_Salvador
    {   71, 7886,   38601, 15, }, // America/Fort_Nelson
    {   71, 7906,   38616, 12, }, // America/Fortaleza
    {   71, 7924,   38628,  8, }, // America/Glace_Bay
    {   71, 6881,   38636,  8, }, // America/Goose_Bay
    {   71, 4612,   38644, 10, }, // America/Grand_Turk
    {   71, 5770,   38654,  7, }, // America/Grenada
    {   71, 5786,   38661,  9, }, // America/Guadeloupe
    {   71, 3760,   38670,  9, }, // America/Guatemala
    {   71, 4841,   38679, 11, }, // America/Guayaquil
    {   71, 6932,   38690,  9, }, // America/Guyana
    {   71, 1939,   38699,  8, }, // America/Halifax
    {   71, 2281,   38707,  6, }, // America/Havana
    {   71, 7942,   38713, 12, }, // America/Hermosillo
    {   71,  348,   38725, 19, }, // America/Indiana/Indianapolis
    {   71,  481,   38744, 22, }, // America/Indiana/Knox
    {   71, 7961,   38766, 21, }, // America/Indiana/Marengo
    {   71, 7985,   38787, 24, }, // America/Indiana/Petersburg
    {   71, 8012,   38811, 23, }, // America/Indiana/Tell_City
    {   71, 8038,   38834, 17, }, // America/Indiana/Vevay
    {   71, 8060,   38851, 22, }, // America/Indiana/Vincennes
    {   71, 8086,   38873, 22, }, // America/Indiana/Winamac
    {   71, 8110,   38895,  8, }, // America/Inuvik
    {   71,  660,   38903, 10, }, // America/Iqaluit
    {   71, 2799,   38913,  6, }, // America/Jamaica
    {   71, 5380,   38919,  9, }, // America/Juneau
    {   71,  521,   38928,  9, }, // America/Kentucky/Louisville
    {   71, 8125,   38937, 23, }, // America/Kentucky/Monticello
    {   71, 5704,   38960, 14, }, // America/Kralendijk
    {   71, 4376,   38974,  6, }, // America/La_Paz
    {   71, 7169,   38980,  4, }, // America/Lima
    {   71, 3239,   38984, 18, }, // America/Los_Angeles
    {   71, 5932,   39002, 18, }, // America/Lower_Princes
    {   71, 8153,   39020,  7, }, // America/Maceio
    {   71, 8168,   39027,  7, }, // America/Managua
    {   71, 1908,   39034,  9, }, // America/Manaus
    {   71, 5897,   39043,  8, }, // America/Marigot
    {   71, 5805,   39051,  8, }, // America/Martinique
    {   71, 8184,   39059, 12, }, // America/Matamoros
    {   71, 2917,   39071,  8, }, // America/Mazatlan
    {   71, 8202,   39079, 10, }, // America/Menominee
    {   71, 8220,   39089,  6, }, // America/Merida
    {   71, 8235,   39095, 12, }, // America/Metlakatla
    {   71, 2949,   39107, 16, }, // America/Mexico_City
    {   71, 4391,   39123,  9, }, // America/Miquelon
    {   71, 8254,   39132, 10, }, // America/Moncton
    {   71, 8270,   39142,  9, }, // America/Monterrey
    {   71, 4098,   39151, 13, }, // America/Montevideo
    {   71, 5824,   39164, 15, }, // America/Montserrat
    {   71, 5481,   39179,  7, }, // America/Nassau
    {   71, 2379,   39186,  9, }, // America/New_York
    {   71, 8288,   39081,  5, }, // America/Nome
    {   71, 1850,   39195,  8, }, // America/Noronha
    {   71, 8301,   39203, 20, }, // America/North_Dakota/Beulah
    {   71, 8329,   39223, 20, }, // America/North_Dakota/Center
    {   71, 8357,   39243, 25, }, // America/North_Dakota/New_Salem
    {   71,  393,   39268,  4, }, // America/Nuuk
    {   71, 8388,   39272,  8, }, // America/Ojinaga
    {   71, 2356,   39280,  7, }, // America/Panama
    {   71, 6173,   39287, 11, }, // America/Paramaribo
    {   71, 2973,   39298,  6, }, // America/Phoenix
    {   71, 3945,   39304, 18, }, // America/Port-au-Prince
    {   71, 5954,   39322, 19, }, // America/Port_of_Spain
    {   71, 8404,   39341, 17, }, // America/Porto_Velho
    {   71, 5843,   39358, 12, }, // America/Puerto_Rico
    {   71, 4030,   39370, 14, }, // America/Punta_Arenas
    {   71, 8424,   39384, 14, }, // America/Rankin_Inlet
    {   71, 8445,   39398,  8, }, // America/Recife
    {   71, 1995,   39406,  8, }, // America/Regina
    {   71, 8460,   39414, 13, }, // America/Resolute
    {   71,  695,   39427, 13, }, // America/Rio_Branco
    {   71, 8477,   39440,  8, }, // America/Santarem
    {   71, 2201,   39448, 10, }, // America/Santiago
    {   71, 6111,   39458, 17, }, // America/Santo_Domingo
    {   71, 1878,   39475, 10, }, // America/Sao_Paulo
    {   71, 6899,   39485, 19, }, // America/Scoresbysund
    {   71, 8494,   39504,  5, }, // America/Sitka
    {   71, 8508,   39509, 13, }, // America/St_Barthelemy
    {   71, 2061,   39522, 11, }, // America/St_Johns
    {   71, 5863,   39533,  9, }, // America/St_Kitts
    {   71, 5880,   39542, 11, }, // America/St_Lucia
    {   71,  855,   39553, 13, }, // America/St_Thomas
    {   71, 5913,   39566, 13, }, // America/St_Vincent
    {   71, 8530,   39579, 16, }, // America/Swift_Current
    {   71, 5461,   39595, 11, }, // America/Tegucigalpa
    {   71, 5756,   39606,  4, }, // America/Thule
    {   71,  313,   39610,  7, }, // America/Tijuana
    {   71,  608,   39617,  9, }, // America/Toronto
    {   71, 5688,   39626,  8, }, // America/Tortola
    {   71, 2093,   39634,  9, }, // America/Vancouver
    {   71, 2144,   39643, 14, }, // America/Whitehorse
    {   71,  734,   39657,  9, }, // America/Winnipeg
    {   71, 8552,   39666,  7, }, // America/Yakutat
    {   71, 6001,   39673,  4, }, // Antarctica/Casey
    {   71, 6094,   39677,  6, }, // Antarctica/Davis
    {   71, 6133,   39683, 19, }, // Antarctica/DumontDUrville
    {   71, 8568,   39702,  9, }, // Antarctica/Macquarie
    {   71, 7066,   39711,  8, }, // Antarctica/Mawson
    {   71, 7113,   39719,  9, }, // Antarctica/McMurdo
    {   71, 8589,   39728,  6, }, // Antarctica/Palmer
    {   71, 7226,   39734,  7, }, // Antarctica/Rothera
    {   71, 7295,   39741,  7, }, // Antarctica/Syowa
    {   71, 8607,   39748,  6, }, // Antarctica/Troll
    {   71, 7374,   39754, 10, }, // Antarctica/Vostok
    {   71, 1429,   39764, 13, }, // Arctic/Longyearbyen
    {   71, 5570,   39777,  5, }, // Asia/Aden
    {   71, 5395,   39782,  8, }, // Asia/Almaty
    {   71, 3968,   39790,  7, }, // Asia/Amman
    {   71, 5511,   39797,  9, }, // Asia/Anadyr
    {   71, 5523,   39806,  7, }, // Asia/Aqtau
    {   71, 5368,   39813,  9, }, // Asia/Aqtobe
    {   71,  964,   39822, 11, }, // Asia/Ashgabat
    {   71, 8624,   39833,  7, }, // Asia/Atyrau
    {   71, 3607,   39840,  7, }, // Asia/Baghdad
    {   71, 5534,   39847,  7, }, // Asia/Bahrain
    {   71, 3653,   39854,  4, }, // Asia/Baku
    {   71, 4466,   39858,  8, }, // Asia/Bangkok
    {   71, 3571,   39866,  7, }, // Asia/Barnaul
    {   71, 4086,   39873,  6, }, // Asia/Beirut
    {   71, 3778,   39879,  8, }, // Asia/Bishkek
    {   71, 5989,   39887,  9, }, // Asia/Brunei
    {   71, 4601,   39896,  5, }, // Asia/Chita
    {   71, 4511,   39901,  8, }, // Asia/Colombo
    {   71, 4540,   39909,  8, }, // Asia/Damascus
    {   71, 1093,   39917,  5, }, // Asia/Dhaka
    {   71, 6192,   39922,  5, }, // Asia/Dili
    {   71, 3596,   39927,  8, }, // Asia/Dubai
    {   71, 6159,   39935,  9, }, // Asia/Dushanbe
    {   71, 8636,   39944,  9, }, // Asia/Famagusta
    {   71, 8651,   39953,  4, }, // Asia/Gaza
    {   71, 4795,   39957,  7, }, // Asia/Hebron
    {   71, 1259,   39964, 16, }, // Asia/Ho_Chi_Minh
    {   71, 2704,   39980, 10, }, // Asia/Hong_Kong
    {   71, 4771,   39990,  6, }, // Asia/Hovd
    {   71, 4184,   39996,  8, }, // Asia/Irkutsk
    {   71, 7006,   40004,  6, }, // Asia/Jakarta
    {   71, 6992,   40010,  9, }, // Asia/Jayapura
    {   71, 1290,   40019,  9, }, // Asia/Jerusalem
    {   71, 3560,   40028,  7, }, // Asia/Kabul
    {   71, 4316,   40035,  9, }, // Asia/Kamchatka
    {   71, 4239,   40044,  6, }, // Asia/Karachi
    {   71, 1185,   40050,  9, }, // Asia/Kathmandu
    {   71, 8661,   40059, 10, }, // Asia/Khandyga
    {   71,  992,   40069, 11, }, // Asia/Kolkata
    {   71, 4197,   40080, 13, }, // Asia/Krasnoyarsk
    {   71, 4859,   40093, 10, }, // Asia/Kuala_Lumpur
    {   71, 5976,   40103,  6, }, // Asia/Kuching
    {   71, 5547,   40109,  6, }, // Asia/Kuwait
    {   71, 1211,   40115,  6, }, // Asia/Macau
    {   71, 4017,   40121,  8, }, // Asia/Magadan
    {   71, 1349,   40129,  8, }, // Asia/Makassar
    {   71, 7182,   40137,  5, }, // Asia/Manila
    {   71, 6920,   40142, 10, }, // Asia/Muscat
    {   71, 2554,   40152,  9, }, // Asia/Nicosia
    {   71, 8675,   40161, 15, }, // Asia/Novokuznetsk
    {   71, 4135,   40176, 16, }, // Asia/Novosibirsk
    {   71, 4229,   40192,  9, }, // Asia/Omsk
    {   71, 7145,   40201,  8, }, // Asia/Oral
    {   71, 6961,   40209,  8, }, // Asia/Phnom_Penh
    {   71, 8693,   40217, 14, }, // Asia/Pontianak
    {   71, 4214,   40231,  8, }, // Asia/Pyongyang
    {   71, 5559,   38170,  4, }, // Asia/Qatar
    {   71, 8708,   40239,  9, }, // Asia/Qostanay
    {   71, 4269,   40248,  9, }, // Asia/Qyzylorda
    {   71, 3584,   40257,  7, }, // Asia/Riyadh
    {   71, 4408,   40264,  7, }, // Asia/Sakhalin
    {   71, 7245,   40271, 12, }, // Asia/Samarkand
    {   71, 3279,   40283,  6, }, // Asia/Seoul
    {   71, 1053,   40289, 10, }, // Asia/Shanghai
    {   71, 3300,   40299,  8, }, // Asia/Singapore
    {   71, 4297,   40307, 16, }, // Asia/Srednekolymsk
    {   71, 3263,   40323,  7, }, // Asia/Taipei
    {   71, 4781,   40330, 10, }, // Asia/Tashkent
    {   71, 3915,   40340,  8, }, // Asia/Tbilisi
    {   71, 2772,   40348,  7, }, // Asia/Tehran
    {   71, 1317,   40355,  6, }, // Asia/Thimphu
    {   71, 2821,   40361,  7, }, // Asia/Tokyo
    {   71, 4572,   40368, 10, }, // Asia/Tomsk
    {   71, 1021,   40378,  9, }, // Asia/Ulaanbaatar
    {   71, 1159,   40387,  9, }, // Asia/Urumqi
    {   71, 8722,   40396, 11, }, // Asia/Ust-Nera
    {   71, 6977,   40407, 10, }, // Asia/Vientiane
    {   71, 4710,   40417, 16, }, // Asia/Vladivostok
    {   71, 4828,   40433,  9, }, // Asia/Yakutsk
    {   71, 1235,   40442,  7, }, // Asia/Yangon
    {   71, 3883,   40449, 16, }, // Asia/Yekaterinburg
    {   71, 3747,   40465, 10, }, // Asia/Yerevan
    {   71, 3663,   40475, 11, }, // Atlantic/Azores
    {   71, 5671,   40486,  7, }, // Atlantic/Bermuda
    {   71, 6628,   40493,  5, }, // Atlantic/Canary
    {   71, 3727,   40498, 11, }, // Atlantic/Cape_Verde
    {   71, 1395,   40509,  5, }, // Atlantic/Faroe
    {   71, 8736,   40514,  6, }, // Atlantic/Madeira
    {   71, 2748,   40520, 10, }, // Atlantic/Reykjavik
    {   71, 7272,   40530, 15, }, // Atlantic/South_Georgia
    {   71, 6821,   40545, 13, }, // Atlantic/St_Helena
    {   71, 6644,   40558,  6, }, // Atlantic/Stanley
    {   71, 1670,   40564, 11, }, // Australia/Adelaide
    {   71, 1635,   40575, 10, }, // Australia/Brisbane
    {   71, 1799,   40585, 12, }, // Australia/Broken_Hill
    {   71, 1583,   40597,  5, }, // Australia/Darwin
    {   71, 3637,   40602,  6, }, // Australia/Eucla
    {   71, 1516,   40608,  9, }, // Australia/Hobart
    {   71, 8753,   40617, 10, }, // Australia/Lindeman
    {   71, 1547,   40627, 12, }, // Australia/Lord_Howe
    {   71, 1727,   40639,  9, }, // Australia/Melbourne
    {   71, 1762,   40648,  5, }, // Australia/Perth
    {   71, 1463,   40653,  6, }, // Australia/Sydney
    {   71, 6441,   40659,  9, }, // Europe/Amsterdam
    {   71, 6216,   40668,  8, }, // Europe/Andorra
    {   71, 3620,   40676, 11, }, // Europe/Astrakhan
    {   71, 2300,   40687,  5, }, // Europe/Athens
    {   71, 6336,   40692,  9, }, // Europe/Belgrade
    {   71, 4757,   40701,  5, }, // Europe/Berlin
    {   71, 6488,   40706, 13, }, // Europe/Bratislava
    {   71, 2167,   40719,  8, }, // Europe/Brussels
    {   71, 3928,   40727,  9, }, // Europe/Bucharest
    {   71, 3806,   40736,  9, }, // Europe/Budapest
    {   71, 8772,   40745, 10, }, // Europe/Busingen
    {   71, 2583,   40755, 11, }, // Europe/Chisinau
    {   71, 6289,   40766, 11, }, // Europe/Copenhagen
    {   71, 2338,   40777,  7, }, // Europe/Dublin
    {   71, 6307,   40784, 12, }, // Europe/Gibraltar
    {   71, 8788,   40796,  7, }, // Europe/Guernsey
    {   71, 6612,   40803,  9, }, // Europe/Helsinki
    {   71, 8804,   40812, 10, }, // Europe/Isle_of_Man
    {   71, 1130,   40822, 11, }, // Europe/Istanbul
    {   71, 8823,   40833,  5, }, // Europe/Jersey
    {   71, 3979,   40838, 11, }, // Europe/Kaliningrad
    {   71, 8929,   40849,  7, }, // Europe/Kirov
    {   71, 2527,   40856,  8, }, // Europe/Kyiv
    {   71, 3213,   40864,  9, }, // Europe/Lisbon
    {   71, 6506,   40873, 11, }, // Europe/Ljubljana
    {   71, 2501,   40884,  6, }, // Europe/London
    {   71, 6365,   40890,  8, }, // Europe/Luxembourg
    {   71, 4892,   40898,  5, }, // Europe/Madrid
    {   71, 6397,   40903,  8, }, // Europe/Malta
    {   71, 6582,   40911, 12, }, // Europe/Mariehamn
    {   71, 3693,   40923,  7, }, // Europe/Minsk
    {   71, 6410,   40930,  8, }, // Europe/Monaco
    {   71, 3537,   40938,  8, }, // Europe/Moscow
    {   71, 6458,   40946,  8, }, // Europe/Oslo
    {   71, 4284,   40954,  5, }, // Europe/Paris
    {   71, 6424,   40959, 11, }, // Europe/Podgorica
    {   71, 6275,   40970,  6, }, // Europe/Prague
    {   71, 8837,   40976,  4, }, // Europe/Riga
    {   71, 6324,   40980,  4, }, // Europe/Rome
    {   71, 4331,   40984,  7, }, // Europe/Samara
    {   71, 6470,   40991, 10, }, // Europe/San_Marino
    {   71, 6245,   41001,  9, }, // Europe/Sarajevo
    {   71, 4451,   41010, 10, }, // Europe/Saratov
    {   71, 8849,   41020, 12, }, // Europe/Simferopol
    {   71, 6383,   41032,  9, }, // Europe/Skopje
    {   71, 6599,   41041,  7, }, // Europe/Sofia
    {   71, 6523,   41048, 10, }, // Europe/Stockholm
    {   71, 8867,   41058,  6, }, // Europe/Tallinn
    {   71, 6202,   41064,  6, }, // Europe/Tirane
    {   71, 8882,   41070, 15, }, // Europe/Ulyanovsk
    {   71, 6352,   41085,  7, }, // Europe/Vaduz
    {   71, 6567,   41092,  7, }, // Europe/Vatican
    {   71, 6231,   41099,  7, }, // Europe/Vienna
    {   71, 8899,   41106, 13, }, // Europe/Vilnius
    {   71, 4727,   41119, 12, }, // Europe/Volgograd
    {   71, 3190,   41131,  5, }, // Europe/Warsaw
    {   71, 6261,   41136, 10, }, // Europe/Zagreb
    {   71, 6540,   41146,  9, }, // Europe/Zurich
    {   71, 5078,   41155, 15, }, // Indian/Antananarivo
    {   71, 6947,   41170,  8, }, // Indian/Chagos
    {   71, 6046,   41178,  8, }, // Indian/Christmas
    {   71, 6063,   41186,  9, }, // Indian/Cocos
    {   71, 5029,   41195,  9, }, // Indian/Comoro
    {   71, 6661,   41204,  7, }, // Indian/Kerguelen
    {   71, 7260,   41211,  4, }, // Indian/Mahe
    {   71, 7050,   41215, 10, }, // Indian/Maldives
    {   71, 4069,   41225,  8, }, // Indian/Mauritius
    {   71, 5098,   41233,  7, }, // Indian/Mayotte
    {   71, 7211,   41240,  9, }, // Indian/Reunion
    {   71, 4422,   41249,  8, }, // Pacific/Apia
    {   71,  932,   41257,  8, }, // Pacific/Auckland
    {   71, 3706,   41265, 14, }, // Pacific/Bougainville
    {   71, 3015,   41279,  7, }, // Pacific/Chatham
    {   71, 3157,   41286,  5, }, // Pacific/Chuuk
    {   71, 2237,   41291,  5, }, // Pacific/Easter
    {   71, 7360,   41296,  6, }, // Pacific/Efate
    {   71, 7327,   41302, 10, }, // Pacific/Fakaofo
    {   71, 3902,   41312,  5, }, // Pacific/Fiji
    {   71, 7343,   41317,  8, }, // Pacific/Funafuti
    {   71, 6678,   41325, 11, }, // Pacific/Galapagos
    {   71, 6696,   41336,  7, }, // Pacific/Gambier
    {   71, 3822,   41343, 10, }, // Pacific/Guadalcanal
    {   71, 6018,   41353,  5, }, // Pacific/Guam
    {   71, 2723,   41358, 10, }, // Pacific/Honolulu
    {   71, 3049,   41368,  9, }, // Pacific/Kanton
    {   71, 3998,   41377,  8, }, // Pacific/Kiritimati
    {   71, 7019,   41385, 10, }, // Pacific/Kosrae
    {   71, 2842,   41395, 10, }, // Pacific/Kwajalein
    {   71, 4877,   41405,  9, }, // Pacific/Majuro
    {   71, 4051,   41414, 10, }, // Pacific/Marquesas
    {   71, 8914,   41424,  8, }, // Pacific/Midway
    {   71, 7084,   41432,  6, }, // Pacific/Nauru
    {   71, 7132,   41438,  6, }, // Pacific/Niue
    {   71, 4168,   41444, 10, }, // Pacific/Norfolk
    {   71, 7098,   41454,  7, }, // Pacific/Noumea
    {   71, 3126,   41461, 10, }, // Pacific/Pago_Pago
    {   71, 7155,   41471,  6, }, // Pacific/Palau
    {   71, 7194,   41477, 10, }, // Pacific/Pitcairn
    {   71, 3096,   41487,  9, }, // Pacific/Pohnpei
    {   71, 4807,   41496, 17, }, // Pacific/Port_Moresby
    {   71, 6076,   41513, 12, }, // Pacific/Rarotonga
    {   71, 6031,   41525,  8, }, // Pacific/Saipan
    {   71, 7312,   41533,  5, }, // Pacific/Tahiti
    {   71, 6712,   41538,  6, }, // Pacific/Tarawa
    {   71, 4583,   41544, 10, }, // Pacific/Tongatapu
    {   71, 7392,   41554,  6, }, // Pacific/Wake
    {   71, 7405,   41560,  7, }, // Pacific/Wallis
    {   72, 6788,   41567,  3, }, // Africa/Abidjan Cantonese/Traditional Han/Hong Kong
    {   72, 6760,   41570,  3, }, // Africa/Accra
    {   72, 5059,   41573,  6, }, // Africa/Addis_Ababa
    {   72, 7420,   41579,  4, }, // Africa/Algiers
    {   72,   14,   41583,  4, }, // Africa/Asmara
    {   72,   44,   41587,  3, }, // Africa/Bamako
    {   72, 5257,   41590,  2, }, // Africa/Bangui
    {   72, 6746,   41592,  2, }, // Africa/Banjul
    {   72, 7435,   41594,  2, }, // Africa/Bissau
    {   72, 4957,   41596,  4, }, // Africa/Blantyre
    {   72, 5287,   41600,  5, }, // Africa/Brazzaville
    {   72, 4922,   41605,  4, }, // Africa/Bujumbura
    {   72, 2320,   41609,  2, }, // Africa/Cairo
    {   72, 4117,   41611,  5, }, // Africa/Casablanca
    {   72, 7449,   41616,  2, }, // Africa/Ceuta
    {   72, 6773,   41618,  4, }, // Africa/Conakry
    {   72, 6840,   41622,  3, }, // Africa/Dakar
    {   72, 5130,   41625,  3, }, // Africa/Dar_es_Salaam
    {   72, 5043,   41628,  3, }, // Africa/Djibouti
    {   72, 5243,   41631,  3, }, // Africa/Douala
    {   72, 5166,   41634,  3, }, // Africa/El_Aaiun
    {   72, 6853,   41637,  3, }, // Africa/Freetown
    {   72, 4906,   41640,  4, }, // Africa/Gaborone
    {   72, 5015,   41644,  3, }, // Africa/Harare
    {   72, 4479,   41647,  5, }, // Africa/Johannesburg
    {   72, 4499,   41652,  2, }, // Africa/Juba
    {   72, 5151,   41654,  3, }, // Africa/Kampala
    {   72, 4524,   41657,  3, }, // Africa/Khartoum
    {   72, 4973,   41660,  3, }, // Africa/Kigali
    {   72, 5306,   41663,  3, }, // Africa/Kinshasa
    {   72, 4744,   41666,  3, }, // Africa/Lagos
    {   72, 5336,   41669,  3, }, // Africa/Libreville
    {   72, 6869,   41672,  2, }, // Africa/Lome
    {   72, 5211,   41674,  3, }, // Africa/Luanda
    {   72, 4939,   41677,  4, }, // Africa/Lubumbashi
    {   72, 5001,   41681,  3, }, // Africa/Lusaka
    {   72, 5322,   41684,  3, }, // Africa/Malabo
    {   72, 4987,   41687,  3, }, // Africa/Maputo
    {   72, 5197,   41690,  3, }, // Africa/Maseru
    {   72, 5182,   41693,  3, }, // Africa/Mbabane
    {   72, 5113,   41696,  4, }, // Africa/Mogadishu
    {   72, 7034,   41700,  4, }, // Africa/Monrovia
    {   72, 3853,   41704,  3, }, // Africa/Nairobi
    {   72, 5271,   41707,  4, }, // Africa/Ndjamena
    {   72, 5354,   41711,  3, }, // Africa/Niamey
    {   72, 6803,   41714,  3, }, // Africa/Nouakchott
    {   72, 6727,   41717,  4, }, // Africa/Ouagadougou
    {   72, 5225,   41721,  4, }, // Africa/Porto-Novo
    {   72, 4435,   41725,  3, }, // Africa/Sao_Tome
    {   72, 2866,   41728,  4, }, // Africa/Tripoli
    {   72, 6554,   41732,  3, }, // Africa/Tunis
    {   72, 4152,   41735,  4, }, // Africa/Windhoek
    {   72,  132,   41739,  3, }, // America/Adak
    {   72, 3346,   41742,  4, }, // America/Anchorage
    {   72, 5607,   41746,  3, }, // America/Anguilla
    {   72, 5624,   41749,  3, }, // America/Antigua
    {   72, 4554,   41752,  4, }, // America/Araguaina
    {   72,  166,   41756,  7, }, // America/Argentina/Buenos_Aires
    {   72,   91,   41763,  4, }, // America/Argentina/Catamarca
    {   72,  270,   41767,  3, }, // America/Argentina/Cordoba
    {   72,  441,   41770,  3, }, // America/Argentina/Jujuy
    {   72, 7462,   41773,  3, }, // America/Argentina/La_Rioja
    {   72,  565,   41776,  3, }, // America/Argentina/Mendoza
    {   72, 7489,   41779,  6, }, // America/Argentina/Rio_Gallegos
    {   72, 7520,   41785,  3, }, // America/Argentina/Salta
    {   72, 7544,   41788,  3, }, // America/Argentina/San_Juan
    {   72, 5580,   41791,  3, }, // America/Argentina/San_Luis
    {   72, 7571,   41794,  3, }, // America/Argentina/Tucuman
    {   72, 7597,   41797,  4, }, // America/Argentina/Ushuaia
    {   72, 5640,   41801,  3, }, // America/Aruba
    {   72, 4252,   41804,  3, }, // America/Asuncion
    {   72,  237,   41807,  4, }, // America/Atikokan
    {   72, 3679,   41811,  3, }, // America/Bahia
    {   72, 7623,   41814,  7, }, // America/Bahia_Banderas
    {   72, 5654,   41821,  3, }, // America/Barbados
    {   72, 7646,   41824,  2, }, // America/Belem
    {   72, 5407,   41826,  3, }, // America/Belize
    {   72, 7660,   41829,  5, }, // America/Blanc-Sablon
    {   72, 7681,   41834,  4, }, // America/Boa_Vista
    {   72, 4361,   41838,  3, }, // America/Bogota
    {   72, 7699,   41841,  2, }, // America/Boise
    {   72, 7713,   41843,  3, }, // America/Cambridge_Bay
    {   72, 7735,   41846,  3, }, // America/Campo_Grande
    {   72, 3868,   41849,  2, }, // America/Cancun
    {   72, 4694,   41851,  4, }, // America/Caracas
    {   72, 4345,   41855,  2, }, // America/Cayenne
    {   72, 5496,   41857,  4, }, // America/Cayman
    {   72, 2260,   41861,  3, }, // America/Chicago
    {   72, 7756,   41864,  3, }, // America/Chihuahua
    {   72, 7774,   41867,  4, }, // America/Ciudad_Juarez
    {   72, 5422,   41871,  5, }, // America/Costa_Rica
    {   72, 7796,   41876,  4, }, // America/Creston
    {   72, 3791,   41880,  3, }, // America/Cuiaba
    {   72, 5723,   41883,  3, }, // America/Curacao
    {   72, 7812,   41886,  4, }, // America/Danmarkshavn
    {   72, 7833,   41890,  2, }, // America/Dawson
    {   72, 7848,   41892,  5, }, // America/Dawson_Creek
    {   72,  805,   41897,  2, }, // America/Denver
    {   72, 3465,   41899,  3, }, // America/Detroit
    {   72, 5739,   41902,  4, }, // America/Dominica
    {   72,  893,   41906,  4, }, // America/Edmonton
    {   72, 7869,   41910,  4, }, // America/Eirunepe
    {   72, 5441,   41914,  4, }, // America/El_Salvador
    {   72, 7886,   41918,  4, }, // America/Fort_Nelson
    {   72, 7906,   41922,  4, }, // America/Fortaleza
    {   72, 7924,   41926,  4, }, // America/Glace_Bay
    {   72, 6881,   41930,  2, }, // America/Goose_Bay
    {   72, 4612,   41932,  4, }, // America/Grand_Turk
    {   72, 5770,   41936,  4, }, // America/Grenada
    {   72, 5786,   41940,  4, }, // America/Guadeloupe
    {   72, 3760,   41944,  4, }, // America/Guatemala
    {   72, 4841,   41948,  4, }, // America/Guayaquil
    {   72, 6932,   41952,  3, }, // America/Guyana
    {   72, 1939,   41955,  5, }, // America/Halifax
    {   72, 2281,   41960,  3, }, // America/Havana
    {   72, 7942,   41963,  4, }, // America/Hermosillo
    {   72,  348,   41967,  7, }, // America/Indiana/Indianapolis
    {   72,  481,   41974,  8, }, // America/Indiana/Knox
    {   72, 7961,   41982,  8, }, // America/Indiana/Marengo
    {   72, 7985,   41990,  8, }, // America/Indiana/Petersburg
    {   72, 8012,   41998,  8, }, // America/Indiana/Tell_City
    {   72, 8038,   42006,  7, }, // America/Indiana/Vevay
    {   72, 8060,   42013,  8, }, // America/Indiana/Vincennes
    {   72, 8086,   42021,  9, }, // America/Indiana/Winamac
    {   72, 8110,   42030,  4, }, // America/Inuvik
    {   72,  660,   42034,  3, }, // America/Iqaluit
    {   72, 2799,   42037,  3, }, // America/Jamaica
    {   72, 5380,   42040,  2, }, // America/Juneau
    {   72,  521,   42042,  5, }, // America/Kentucky/Louisville
    {   72, 8125,   42047,  8, }, // America/Kentucky/Monticello
    {   72, 5704,   42055,  5, }, // America/Kralendijk
    {   72, 4376,   42060,  3, }, // America/La_Paz
    {   72, 7169,   42063,  2, }, // America/Lima
    {   72, 3239,   42065,  3, }, // America/Los_Angeles
    {   72, 5932,   42068,  4, }, // America/Lower_Princes
    {   72, 8153,   42072,  3, }, // America/Maceio
    {   72, 8168,   42075,  3, }, // America/Managua
    {   72, 1908,   42078,  3, }, // America/Manaus
    {   72, 5897,   42081,  4, }, // America/Marigot
    {   72, 5805,   42085,  4, }, // America/Martinique
    {   72, 8184,   42089,  5, }, // America/Matamoros
    {   72, 2917,   42094,  4, }, // America/Mazatlan
    {   72, 8202,   42098,  4, }, // America/Menominee
    {   72, 8220,   42102,  3, }, // America/Merida
    {   72, 8235,   42105,  6, }, // America/Metlakatla
    {   72, 2949,   42111,  4, }, // America/Mexico_City
    {   72, 4391,   42115,  3, }, // America/Miquelon
    {   72, 8254,   42118,  3, }, // America/Moncton
    {   72, 8270,   42121,  3, }, // America/Monterrey
    {   72, 4098,   42124,  4, }, // America/Montevideo
    {   72, 5824,   42128,  3, }, // America/Montserrat
    {   72, 5481,   42131,  2, }, // America/Nassau
    {   72, 2379,   42133,  2, }, // America/New_York
    {   72, 8288,   42135,  2, }, // America/Nome
    {   72, 1850,   42137,  3, }, // America/Noronha
    {   72, 8301,   42140,  8, }, // America/North_Dakota/Beulah
    {   72, 8329,   42148,  7, }, // America/North_Dakota/Center
    {   72, 8357,   42155,  8, }, // America/North_Dakota/New_Salem
    {   72,  393,   42163,  2, }, // America/Nuuk
    {   72, 8388,   42165,  4, }, // America/Ojinaga
    {   72, 2356,   42169,  3, }, // America/Panama
    {   72, 6173,   42172,  5, }, // America/Paramaribo
    {   72, 2973,   42177,  3, }, // America/Phoenix
    {   72, 3945,   42180,  3, }, // America/Port-au-Prince
    {   72, 5954,   42183,  4, }, // America/Port_of_Spain
    {   72, 8404,   42187,  3, }, // America/Porto_Velho
    {   72, 5843,   42190,  4, }, // America/Puerto_Rico
    {   72, 4030,   42194,  6, }, // America/Punta_Arenas
    {   72, 8424,   42200,  3, }, // America/Rankin_Inlet
    {   72, 8445,   42203,  3, }, // America/Recife
    {   72, 1995,   42206,  3, }, // America/Regina
    {   72, 8460,   42209,  4, }, // America/Resolute
    {   72,  695,   42213,  4, }, // America/Rio_Branco
    {   72, 8477,   42217,  3, }, // America/Santarem
    {   72, 2201,   42220,  4, }, // America/Santiago
    {   72, 6111,   42224,  4, }, // America/Santo_Domingo
    {   72, 1878,   42228,  3, }, // America/Sao_Paulo
    {   72, 6899,   42231,  7, }, // America/Scoresbysund
    {   72, 8494,   42238,  3, }, // America/Sitka
    {   72, 8508,   42241,  6, }, // America/St_Barthelemy
    {   72, 2061,   42247,  3, }, // America/St_Johns
    {   72, 5863,   42250,  3, }, // America/St_Kitts
    {   72, 5880,   42253,  4, }, // America/St_Lucia
    {   72,  855,   42257,  4, }, // America/St_Thomas
    {   72, 5913,   42261,  3, }, // America/St_Vincent
    {   72, 8530,   42264,  7, }, // America/Swift_Current
    {   72, 5461,   42271,  5, }, // America/Tegucigalpa
    {   72, 5756,   42276,  2, }, // America/Thule
    {   72,  313,   42278,  3, }, // America/Tijuana
    {   72,  608,   42281,  3, }, // America/Toronto
    {   72, 5688,   42284,  4, }, // America/Tortola
    {   72, 2093,   42288,  3, }, // America/Vancouver
    {   72, 2144,   42291,  4, }, // America/Whitehorse
    {   72,  734,   42295,  3, }, // America/Winnipeg
    {   72, 8552,   42298,  3, }, // America/Yakutat
    {   72, 6001,   42301,  2, }, // Antarctica/Casey
    {   72, 6094,   42303,  3, }, // Antarctica/Davis
    {   72, 6133,   42306,  5, }, // Antarctica/DumontDUrville
    {   72, 8568,   42311,  3, }, // Antarctica/Macquarie
    {   72, 7066,   42314,  2, }, // Antarctica/Mawson
    {   72, 7113,   42316,  4, }, // Antarctica/McMurdo
    {   72, 8589,   42320,  2, }, // Antarctica/Palmer
    {   72, 7226,   42322,  3, }, // Antarctica/Rothera
    {   72, 7295,   42325,  4, }, // Antarctica/Syowa
    {   72, 8607,   42329,  2, }, // Antarctica/Troll
    {   72, 7374,   42331,  4, }, // Antarctica/Vostok
    {   72, 1429,   42335,  5, }, // Arctic/Longyearbyen
    {   72, 5570,   42340,  2, }, // Asia/Aden
    {   72, 5395,   42342,  4, }, // Asia/Almaty
    {   72, 3968,   42346,  2, }, // Asia/Amman
    {   72, 5511,   42348,  3, }, // Asia/Anadyr
    {   72, 5523,   42351,  3, }, // Asia/Aqtau
    {   72, 5368,   42354,  4, }, // Asia/Aqtobe
    {   72,  964,   42358,  5, }, // Asia/Ashgabat
    {   72, 8624,   42363,  3, }, // Asia/Atyrau
    {   72, 3607,   42366,  3, }, // Asia/Baghdad
    {   72, 5534,   42369,  2, }, // Asia/Bahrain
    {   72, 3653,   41882,  2, }, // Asia/Baku
    {   72, 4466,   42371,  2, }, // Asia/Bangkok
    {   72, 3571,   42373,  4, }, // Asia/Barnaul
    {   72, 4086,   42377,  3, }, // Asia/Beirut
    {   72, 3778,   42380,  4, }, // Asia/Bishkek
    {   72, 5989,   42384,  2, }, // Asia/Brunei
    {   72, 4601,   42386,  2, }, // Asia/Chita
    {   72, 4511,   42388,  3, }, // Asia/Colombo
    {   72, 4540,   42391,  4, }, // Asia/Damascus
    {   72, 1093,   42395,  2, }, // Asia/Dhaka
    {   72, 6192,   42397,  2, }, // Asia/Dili
    {   72, 3596,   42399,  2, }, // Asia/Dubai
    {   72, 6159,   42401,  3, }, // Asia/Dushanbe
    {   72, 8636,   42404,  5, }, // Asia/Famagusta
    {   72, 8651,   42409,  2, }, // Asia/Gaza
    {   72, 4795,   42411,  3, }, // Asia/Hebron
    {   72, 1259,   42414,  4, }, // Asia/Ho_Chi_Minh
    {   72, 2704,   42418, 14, }, // Asia/Hong_Kong
    {   72, 4771,   42432,  3, }, // Asia/Hovd
    {   72, 4184,   42435,  5, }, // Asia/Irkutsk
    {   72, 7006,   42440,  3, }, // Asia/Jakarta
    {   72, 6992,   42443,  4, }, // Asia/Jayapura
    {   72, 1290,   42447,  4, }, // Asia/Jerusalem
    {   72, 3560,   42451,  3, }, // Asia/Kabul
    {   72, 4316,   42454,  3, }, // Asia/Kamchatka
    {   72, 4239,   42457,  3, }, // Asia/Karachi
    {   72, 1185,   42460,  4, }, // Asia/Kathmandu
    {   72, 8661,   42464,  3, }, // Asia/Khandyga
    {   72,  992,   42467,  4, }, // Asia/Kolkata
    {   72, 4197,   42471,  8, }, // Asia/Krasnoyarsk
    {   72, 4859,   42479,  3, }, // Asia/Kuala_Lumpur
    {   72, 5976,   42482,  2, }, // Asia/Kuching
    {   72, 5547,   42484,  3, }, // Asia/Kuwait
    {   72, 1211,   42487, 14, }, // Asia/Macau
    {   72, 4017,   42501,  3, }, // Asia/Magadan
    {   72, 1349,   42504,  4, }, // Asia/Makassar
    {   72, 7182,   42508,  3, }, // Asia/Manila
    {   72, 6920,   42511,  4, }, // Asia/Muscat
    {   72, 2554,   42515,  4, }, // Asia/Nicosia
    {   72, 8675,   42519,  6, }, // Asia/Novokuznetsk
    {   72, 4135,   42525,  5, }, // Asia/Novosibirsk
    {   72, 4229,   42530,  4, }, // Asia/Omsk
    {   72, 7145,   42534,  3, }, // Asia/Oral
    {   72, 6961,   42537,  2, }, // Asia/Phnom_Penh
    {   72, 8693,   42539,  2, }, // Asia/Pontianak
    {   72, 4214,   42541,  2, }, // Asia/Pyongyang
    {   72, 5559,   42543,  2, }, // Asia/Qatar
    {   72, 8708,   42545,  4, }, // Asia/Qostanay
    {   72, 4269,   42549,  6, }, // Asia/Qyzylorda
    {   72, 3584,   42555,  3, }, // Asia/Riyadh
    {   72, 4408,   42558,  3, }, // Asia/Sakhalin
    {   72, 7245,   42561,  4, }, // Asia/Samarkand
    {   72, 3279,   42565,  2, }, // Asia/Seoul
    {   72, 1053,   42567,  2, }, // Asia/Shanghai
    {   72, 3300,   42569,  3, }, // Asia/Singapore
    {   72, 4297,   42572,  6, }, // Asia/Srednekolymsk
    {   72, 3263,   42578,  2, }, // Asia/Taipei
    {   72, 4781,   42580,  3, }, // Asia/Tashkent
    {   72, 3915,   42583,  4, }, // Asia/Tbilisi
    {   72, 2772,   42587,  3, }, // Asia/Tehran
    {   72, 1317,   42590,  2, }, // Asia/Thimphu
    {   72, 2821,   42592,  2, }, // Asia/Tokyo
    {   72, 4572,   42594,  4, }, // Asia/Tomsk
    {   72, 1021,   42598,  4, }, // Asia/Ulaanbaatar
    {   72, 1159,   42602,  4, }, // Asia/Urumqi
    {   72, 8722,   42606,  4, }, // Asia/Ust-Nera
    {   72, 6977,   42610,  2, }, // Asia/Vientiane
    {   72, 4710,   42612,  3, }, // Asia/Vladivostok
    {   72, 4828,   42615,  4, }, // Asia/Yakutsk
    {   72, 1235,   42619,  2, }, // Asia/Yangon
    {   72, 3883,   42621,  5, }, // Asia/Yekaterinburg
    {   72, 3747,   42626,  3, }, // Asia/Yerevan
    {   72, 3663,   42629,  5, }, // Atlantic/Azores
    {   72, 5671,   42634,  3, }, // Atlantic/Bermuda
    {   72, 6628,   42637,  3, }, // Atlantic/Canary
    {   72, 3727,   42640,  3, }, // Atlantic/Cape_Verde
    {   72, 1395,   42643,  4, }, // Atlantic/Faroe
    {   72, 8736,   42647,  5, }, // Atlantic/Madeira
    {   72, 2748,   42652,  5, }, // Atlantic/Reykjavik
    {   72, 7272,   42657,  4, }, // Atlantic/South_Georgia
    {   72, 6821,   42661,  5, }, // Atlantic/St_Helena
    {   72, 6644,   42666,  3, }, // Atlantic/Stanley
    {   72, 1670,   42669,  4, }, // Australia/Adelaide
    {   72, 1635,   42673,  4, }, // Australia/Brisbane
    {   72, 1799,   42677,  5, }, // Australia/Broken_Hill
    {   72, 1583,   42682,  3, }, // Australia/Darwin
    {   72, 3637,   42685,  3, }, // Australia/Eucla
    {   72, 1516,   42688,  3, }, // Australia/Hobart
    {   72, 8753,   42691,  3, }, // Australia/Lindeman
    {   72, 1547,   42694,  4, }, // Australia/Lord_Howe
    {   72, 1727,   42698,  3, }, // Australia/Melbourne
    {   72, 1762,   42701,  2, }, // Australia/Perth
    {   72, 1463,   42703,  2, }, // Australia/Sydney
    {   72, 6441,   42705,  5, }, // Europe/Amsterdam
    {   72, 6216,   42710,  3, }, // Europe/Andorra
    {   72, 3620,   42713,  5, }, // Europe/Astrakhan
    {   72, 2300,   42718,  2, }, // Europe/Athens
    {   72, 6336,   42720,  4, }, // Europe/Belgrade
    {   72, 4757,   42724,  2, }, // Europe/Berlin
    {   72, 6488,   42726,  6, }, // Europe/Bratislava
    {   72, 2167,   42732,  4, }, // Europe/Brussels
    {   72, 3928,   42736,  5, }, // Europe/Bucharest
    {   72, 3806,   42741,  4, }, // Europe/Budapest
    {   72, 8772,   42745,  3, }, // Europe/Busingen
    {   72, 2583,   42748,  3, }, // Europe/Chisinau
    {   72, 6289,   42751,  4, }, // Europe/Copenhagen
    {   72, 2338,   42755,  3, }, // Europe/Dublin
    {   72, 6307,   42758,  4, }, // Europe/Gibraltar
    {   72, 8788,   42762,  3, }, // Europe/Guernsey
    {   72, 6612,   42765,  4, }, // Europe/Helsinki
    {   72, 8804,   42769,  2, }, // Europe/Isle_of_Man
    {   72, 1130,   42771,  4, }, // Europe/Istanbul
    {   72, 8823,   42775,  3, }, // Europe/Jersey
    {   72, 3979,   42778,  5, }, // Europe/Kaliningrad
    {   72, 8929,   42783,  3, }, // Europe/Kirov
    {   72, 2527,   42786,  2, }, // Europe/Kyiv
    {   72, 3213,   42788,  3, }, // Europe/Lisbon
    {   72, 6506,   42791,  4, }, // Europe/Ljubljana
    {   72, 2501,   42795,  2, }, // Europe/London
    {   72, 6365,   42797,  3, }, // Europe/Luxembourg
    {   72, 4892,   42800,  3, }, // Europe/Madrid
    {   72, 6397,   42803,  3, }, // Europe/Malta
    {   72, 6582,   42806,  3, }, // Europe/Mariehamn
    {   72, 3693,   42809,  3, }, // Europe/Minsk
    {   72, 6410,   42812,  3, }, // Europe/Monaco
    {   72, 3537,   42815,  3, }, // Europe/Moscow
    {   72, 6458,   42818,  3, }, // Europe/Oslo
    {   72, 4284,   42821,  2, }, // Europe/Paris
    {   72, 6424,   42823,  4, }, // Europe/Podgorica
    {   72, 6275,   42827,  3, }, // Europe/Prague
    {   72, 8837,   42830,  2, }, // Europe/Riga
    {   72, 6324,   42832,  2, }, // Europe/Rome
    {   72, 4331,   42834,  3, }, // Europe/Samara
    {   72, 6470,   42837,  4, }, // Europe/San_Marino
    {   72, 6245,   42841,  4, }, // Europe/Sarajevo
    {   72, 4451,   42845,  4, }, // Europe/Saratov
    {   72, 8849,   42849,  4, }, // Europe/Simferopol
    {   72, 6383,   42853,  4, }, // Europe/Skopje
    {   72, 6599,   42857,  3, }, // Europe/Sofia
    {   72, 6523,   42860,  5, }, // Europe/Stockholm
    {   72, 8867,   42865,  2, }, // Europe/Tallinn
    {   72, 6202,   42867,  3, }, // Europe/Tirane
    {   72, 8882,   42870,  7, }, // Europe/Ulyanovsk
    {   72, 6352,   42877,  3, }, // Europe/Vaduz
    {   72, 6567,   42880,  3, }, // Europe/Vatican
    {   72, 6231,   42883,  3, }, // Europe/Vienna
    {   72, 8899,   42886,  4, }, // Europe/Vilnius
    {   72, 4727,   42890,  5, }, // Europe/Volgograd
    {   72, 3190,   42895,  2, }, // Europe/Warsaw
    {   72, 6261,   42897,  4, }, // Europe/Zagreb
    {   72, 6540,   42901,  3, }, // Europe/Zurich
    {   72, 5078,   42904,  6, }, // Indian/Antananarivo
    {   72, 6947,   42910,  3, }, // Indian/Chagos
    {   72, 6046,   42913,  3, }, // Indian/Christmas
    {   72, 6063,   42916,  5, }, // Indian/Cocos
    {   72, 5029,   42921,  5, }, // Indian/Comoro
    {   72, 6661,   42926,  5, }, // Indian/Kerguelen
    {   72, 7260,   42931,  3, }, // Indian/Mahe
    {   72, 7050,   42934,  4, }, // Indian/Maldives
    {   72, 4069,   42938,  4, }, // Indian/Mauritius
    {   72, 5098,   42942,  4, }, // Indian/Mayotte
    {   72, 7211,   42946,  4, }, // Indian/Reunion
    {   72, 4422,   42950,  3, }, // Pacific/Apia
    {   72,  932,   42953,  3, }, // Pacific/Auckland
    {   72, 3706,   42956,  4, }, // Pacific/Bougainville
    {   72, 3015,   42960,  2, }, // Pacific/Chatham
    {   72, 3157,   42962,  2, }, // Pacific/Chuuk
    {   72, 2237,   42964,  3, }, // Pacific/Easter
    {   72, 7360,   42967,  3, }, // Pacific/Efate
    {   72, 7327,   42970,  3, }, // Pacific/Fakaofo
    {   72, 3902,   42973,  2, }, // Pacific/Fiji
    {   72, 7343,   42975,  4, }, // Pacific/Funafuti
    {   72, 6678,   42979,  6, }, // Pacific/Galapagos
    {   72, 6696,   42985,  5, }, // Pacific/Gambier
    {   72, 3822,   42990,  6, }, // Pacific/Guadalcanal
    {   72, 6018,   42996,  2, }, // Pacific/Guam
    {   72, 2723,   42998,  3, }, // Pacific/Honolulu
    {   72, 3049,   43001,  5, }, // Pacific/Kanton
    {   72, 3998,   43006,  6, }, // Pacific/Kiritimati
    {   72, 7019,   43012,  3, }, // Pacific/Kosrae
    {   72, 2842,   43015,  4, }, // Pacific/Kwajalein
    {   72, 4877,   43019,  3, }, // Pacific/Majuro
    {   72, 4051,   43022,  5, }, // Pacific/Marquesas
    {   72, 8914,   43027,  3, }, // Pacific/Midway
    {   72, 7084,   43030,  2, }, // Pacific/Nauru
    {   72, 7132,   43032,  3, }, // Pacific/Niue
    {   72, 4168,   43035,  3, }, // Pacific/Norfolk
    {   72, 7098,   43038,  3, }, // Pacific/Noumea
    {   72, 3126,   43041,  4, }, // Pacific/Pago_Pago
    {   72, 7155,   43045,  2, }, // Pacific/Palau
    {   72, 7194,   43047,  5, }, // Pacific/Pitcairn
    {   72, 3096,   43052,  3, }, // Pacific/Pohnpei
    {   72, 4807,   43055,  4, }, // Pacific/Port_Moresby
    {   72, 6076,   43059,  4, }, // Pacific/Rarotonga
    {   72, 6031,   43063,  2, }, // Pacific/Saipan
    {   72, 7312,   43065,  3, }, // Pacific/Tahiti
    {   72, 6712,   43068,  3, }, // Pacific/Tarawa
    {   72, 4583,   43071,  5, }, // Pacific/Tongatapu
    {   72, 7392,   43076,  2, }, // Pacific/Wake
    {   72, 7405,   43078,  3, }, // Pacific/Wallis
    {   73, 6788,   43081,  3, }, // Africa/Abidjan Cantonese/Simplified Han/China
    {   73, 5059,   43084,  6, }, // Africa/Addis_Ababa
    {   73, 7420,   43090,  4, }, // Africa/Algiers
    {   73,   14,   43094,  4, }, // Africa/Asmara
    {   73,   44,   43098,  3, }, // Africa/Bamako
    {   73, 7435,   43101,  2, }, // Africa/Bissau
    {   73, 4957,   43103,  4, }, // Africa/Blantyre
    {   73, 5287,   43107,  5, }, // Africa/Brazzaville
    {   73, 2320,   43112,  2, }, // Africa/Cairo
    {   73, 4117,   43114,  5, }, // Africa/Casablanca
    {   73, 7449,   43119,  2, }, // Africa/Ceuta
    {   73, 6840,   43121,  3, }, // Africa/Dakar
    {   73, 5130,   43124,  3, }, // Africa/Dar_es_Salaam
    {   73, 4479,   43127,  5, }, // Africa/Johannesburg
    {   73, 5211,   43132,  3, }, // Africa/Luanda
    {   73, 4939,   43135,  4, }, // Africa/Lubumbashi
    {   73, 5322,   43139,  3, }, // Africa/Malabo
    {   73, 4987,   43142,  3, }, // Africa/Maputo
    {   73, 5197,   43145,  3, }, // Africa/Maseru
    {   73, 7034,   43148,  4, }, // Africa/Monrovia
    {   73, 5271,   43152,  4, }, // Africa/Ndjamena
    {   73, 5354,   43156,  3, }, // Africa/Niamey
    {   73, 6803,   43159,  3, }, // Africa/Nouakchott
    {   73, 5225,   43162,  4, }, // Africa/Porto-Novo
    {   73, 4435,   43166,  3, }, // Africa/Sao_Tome
    {   73, 4152,   43169,  4, }, // Africa/Windhoek
    {   73,  132,   43173,  3, }, // America/Adak
    {   73,  166,   43176,  7, }, // America/Argentina/Buenos_Aires
    {   73,   91,   43183,  4, }, // America/Argentina/Catamarca
    {   73,  270,   43187,  3, }, // America/Argentina/Cordoba
    {   73,  565,   43190,  3, }, // America/Argentina/Mendoza
    {   73, 7489,   43193,  6, }, // America/Argentina/Rio_Gallegos
    {   73, 7520,   43199,  3, }, // America/Argentina/Salta
    {   73, 7544,   43202,  3, }, // America/Argentina/San_Juan
    {   73, 5580,   43205,  3, }, // America/Argentina/San_Luis
    {   73, 7571,   43208,  3, }, // America/Argentina/Tucuman
    {   73, 7597,   43211,  4, }, // America/Argentina/Ushuaia
    {   73, 4252,   43215,  3, }, // America/Asuncion
    {   73, 7623,   43218,  7, }, // America/Bahia_Banderas
    {   73, 5654,   43225,  3, }, // America/Barbados
    {   73, 7646,   43228,  2, }, // America/Belem
    {   73, 5407,   43230,  3, }, // America/Belize
    {   73, 7660,   43233,  5, }, // America/Blanc-Sablon
    {   73, 7681,   43238,  4, }, // America/Boa_Vista
    {   73, 7713,   43242,  3, }, // America/Cambridge_Bay
    {   73, 7735,   43245,  3, }, // America/Campo_Grande
    {   73, 4345,   43248,  2, }, // America/Cayenne
    {   73, 5496,   43250,  4, }, // America/Cayman
    {   73, 7756,   43254,  3, }, // America/Chihuahua
    {   73, 7774,   43257,  4, }, // America/Ciudad_Juarez
    {   73, 7796,   43261,  4, }, // America/Creston
    {   73, 5723,   43265,  3, }, // America/Curacao
    {   73, 7812,   43268,  4, }, // America/Danmarkshavn
    {   73, 7869,   43272,  4, }, // America/Eirunepe
    {   73, 5441,   43276,  4, }, // America/El_Salvador
    {   73, 7886,   43280,  4, }, // America/Fort_Nelson
    {   73, 7924,   43284,  4, }, // America/Glace_Bay
    {   73, 6881,   43288,  2, }, // America/Goose_Bay
    {   73, 4612,   43290,  4, }, // America/Grand_Turk
    {   73, 5770,   43294,  4, }, // America/Grenada
    {   73, 3760,   43298,  4, }, // America/Guatemala
    {   73, 4841,   43302,  4, }, // America/Guayaquil
    {   73, 6932,   43306,  3, }, // America/Guyana
    {   73, 7942,   43309,  4, }, // America/Hermosillo
    {   73,  481,   43313,  8, }, // America/Indiana/Knox
    {   73, 7961,   43321,  8, }, // America/Indiana/Marengo
    {   73, 8012,   43329,  8, }, // America/Indiana/Tell_City
    {   73, 8038,   43337,  7, }, // America/Indiana/Vevay
    {   73, 8060,   43344,  8, }, // America/Indiana/Vincennes
    {   73, 8086,   43352,  9, }, // America/Indiana/Winamac
    {   73, 8110,   43361,  4, }, // America/Inuvik
    {   73, 2799,   43365,  3, }, // America/Jamaica
    {   73, 5380,   43368,  2, }, // America/Juneau
    {   73,  521,   43370,  5, }, // America/Kentucky/Louisville
    {   73, 8125,   43375,  8, }, // America/Kentucky/Monticello
    {   73, 5704,   43383,  5, }, // America/Kralendijk
    {   73, 7169,   43388,  2, }, // America/Lima
    {   73, 3239,   43390,  3, }, // America/Los_Angeles
    {   73, 5932,   43393,  4, }, // America/Lower_Princes
    {   73, 8153,   43397,  3, }, // America/Maceio
    {   73, 8168,   43400,  3, }, // America/Managua
    {   73, 1908,   43403,  3, }, // America/Manaus
    {   73, 5897,   43406,  4, }, // America/Marigot
    {   73, 5805,   43410,  4, }, // America/Martinique
    {   73, 8184,   43414,  5, }, // America/Matamoros
    {   73, 2917,   43419,  4, }, // America/Mazatlan
    {   73, 8202,   43423,  4, }, // America/Menominee
    {   73, 8220,   43427,  3, }, // America/Merida
    {   73, 4391,   43430,  3, }, // America/Miquelon
    {   73, 8254,   43433,  3, }, // America/Moncton
    {   73, 4098,   43436,  4, }, // America/Montevideo
    {   73, 5824,   43440,  3, }, // America/Montserrat
    {   73, 2379,   43443,  2, }, // America/New_York
    {   73, 8288,   43445,  2, }, // America/Nome
    {   73, 1850,   43447,  3, }, // America/Noronha
    {   73, 8301,   43450,  8, }, // America/North_Dakota/Beulah
    {   73, 8329,   43458,  7, }, // America/North_Dakota/Center
    {   73, 8357,   43465,  8, }, // America/North_Dakota/New_Salem
    {   73, 8388,   43473,  4, }, // America/Ojinaga
    {   73, 2356,   43477,  3, }, // America/Panama
    {   73, 6173,   43480,  5, }, // America/Paramaribo
    {   73, 2973,   43485,  3, }, // America/Phoenix
    {   73, 8404,   43488,  3, }, // America/Porto_Velho
    {   73, 4030,   43491,  6, }, // America/Punta_Arenas
    {   73, 8424,   43497,  3, }, // America/Rankin_Inlet
    {   73, 1995,   43500,  3, }, // America/Regina
    {   73, 8460,   43503,  4, }, // America/Resolute
    {   73,  695,   43507,  4, }, // America/Rio_Branco
    {   73, 8477,   43511,  3, }, // America/Santarem
    {   73, 2201,   43514,  4, }, // America/Santiago
    {   73, 6111,   43518,  4, }, // America/Santo_Domingo
    {   73, 1878,   43522,  3, }, // America/Sao_Paulo
    {   73, 6899,   43525,  7, }, // America/Scoresbysund
    {   73, 8494,   43532,  3, }, // America/Sitka
    {   73, 8508,   43535,  6, }, // America/St_Barthelemy
    {   73, 2061,   43541,  3, }, // America/St_Johns
    {   73, 5863,   43544,  3, }, // America/St_Kitts
    {   73, 5880,   43547,  4, }, // America/St_Lucia
    {   73,  855,   43551,  4, }, // America/St_Thomas
    {   73, 5913,   43555,  3, }, // America/St_Vincent
    {   73, 8530,   43558,  7, }, // America/Swift_Current
    {   73,  313,   43565,  3, }, // America/Tijuana
    {   73,  608,   43568,  3, }, // America/Toronto
    {   73, 5688,   43571,  4, }, // America/Tortola
    {   73, 2093,   43575,  3, }, // America/Vancouver
    {   73, 2144,   43578,  4, }, // America/Whitehorse
    {   73,  734,   43582,  3, }, // America/Winnipeg
    {   73, 8552,   43585,  3, }, // America/Yakutat
    {   73, 6001,   43588,  2, }, // Antarctica/Casey
    {   73, 6094,   43590,  3, }, // Antarctica/Davis
    {   73, 6133,   43593,  5, }, // Antarctica/DumontDUrville
    {   73, 8568,   43598,  3, }, // Antarctica/Macquarie
    {   73, 7113,   43601,  4, }, // Antarctica/McMurdo
    {   73, 8589,   43605,  2, }, // Antarctica/Palmer
    {   73, 7226,   43607,  3, }, // Antarctica/Rothera
    {   73, 8607,   43610,  2, }, // Antarctica/Troll
    {   73, 5570,   43612,  2, }, // Asia/Aden
    {   73, 5395,   43614,  4, }, // Asia/Almaty
    {   73, 8624,   43618,  3, }, // Asia/Atyrau
    {   73, 3607,   43621,  3, }, // Asia/Baghdad
    {   73, 3653,   43624,  2, }, // Asia/Baku
    {   73, 3571,   43626,  4, }, // Asia/Barnaul
    {   73, 4086,   43630,  3, }, // Asia/Beirut
    {   73, 3778,   43633,  4, }, // Asia/Bishkek
    {   73, 5989,   43637,  2, }, // Asia/Brunei
    {   73, 4511,   43639,  3, }, // Asia/Colombo
    {   73, 4540,   43642,  4, }, // Asia/Damascus
    {   73, 1093,   43646,  2, }, // Asia/Dhaka
    {   73, 6159,   43648,  3, }, // Asia/Dushanbe
    {   73, 8636,   43651,  5, }, // Asia/Famagusta
    {   73, 8651,   43656,  2, }, // Asia/Gaza
    {   73, 2704,   43658, 14, }, // Asia/Hong_Kong
    {   73, 4184,   43672,  5, }, // Asia/Irkutsk
    {   73, 7006,   43677,  3, }, // Asia/Jakarta
    {   73, 6992,   43680,  4, }, // Asia/Jayapura
    {   73, 3560,   43684,  3, }, // Asia/Kabul
    {   73, 1185,   43687,  4, }, // Asia/Kathmandu
    {   73,  992,   43691,  4, }, // Asia/Kolkata
    {   73, 4197,   43695,  8, }, // Asia/Krasnoyarsk
    {   73, 5976,   43703,  2, }, // Asia/Kuching
    {   73, 1211,   43705, 14, }, // Asia/Macau
    {   73, 4017,   43719,  3, }, // Asia/Magadan
    {   73, 1349,   43722,  4, }, // Asia/Makassar
    {   73, 7182,   43726,  3, }, // Asia/Manila
    {   73, 6920,   43729,  4, }, // Asia/Muscat
    {   73, 2554,   43733,  4, }, // Asia/Nicosia
    {   73, 8675,   43737,  6, }, // Asia/Novokuznetsk
    {   73, 4135,   43743,  5, }, // Asia/Novosibirsk
    {   73, 7145,   43748,  3, }, // Asia/Oral
    {   73, 6961,   43751,  2, }, // Asia/Phnom_Penh
    {   73, 5559,   43753,  2, }, // Asia/Qatar
    {   73, 4269,   43755,  6, }, // Asia/Qyzylorda
    {   73, 4408,   43761,  3, }, // Asia/Sakhalin
    {   73, 7245,   43764,  4, }, // Asia/Samarkand
    {   73, 3279,   43768,  2, }, // Asia/Seoul
    {   73, 2772,   43770,  3, }, // Asia/Tehran
    {   73, 2821,   43773,  2, }, // Asia/Tokyo
    {   73, 1021,   43775,  4, }, // Asia/Ulaanbaatar
    {   73, 1159,   43779,  4, }, // Asia/Urumqi
    {   73, 8722,   43783,  4, }, // Asia/Ust-Nera
    {   73, 4710,   43787,  3, }, // Asia/Vladivostok
    {   73, 4828,   43790,  4, }, // Asia/Yakutsk
    {   73, 3883,   43794,  5, }, // Asia/Yekaterinburg
    {   73, 3747,   43799,  3, }, // Asia/Yerevan
    {   73, 3663,   43802,  5, }, // Atlantic/Azores
    {   73, 5671,   43807,  3, }, // Atlantic/Bermuda
    {   73, 6628,   43810,  3, }, // Atlantic/Canary
    {   73, 3727,   43813,  3, }, // Atlantic/Cape_Verde
    {   73, 1395,   43816,  4, }, // Atlantic/Faroe
    {   73, 8736,   43820,  5, }, // Atlantic/Madeira
    {   73, 2748,   43825,  5, }, // Atlantic/Reykjavik
    {   73, 7272,   43830,  4, }, // Atlantic/South_Georgia
    {   73, 6821,   43834,  5, }, // Atlantic/St_Helena
    {   73, 1799,   43839,  5, }, // Australia/Broken_Hill
    {   73, 1583,   43844,  3, }, // Australia/Darwin
    {   73, 1547,   43847,  4, }, // Australia/Lord_Howe
    {   73, 1727,   43851,  3, }, // Australia/Melbourne
    {   73, 6216,   43854,  3, }, // Europe/Andorra
    {   73, 6336,   43857,  4, }, // Europe/Belgrade
    {   73, 2167,   43861,  4, }, // Europe/Brussels
    {   73, 3806,   43865,  4, }, // Europe/Budapest
    {   73, 2338,   42755,  3, }, // Europe/Dublin
    {   73, 6307,   43869,  4, }, // Europe/Gibraltar
    {   73, 8788,   43873,  3, }, // Europe/Guernsey
    {   73, 6612,   43876,  4, }, // Europe/Helsinki
    {   73, 8804,   43880,  2, }, // Europe/Isle_of_Man
    {   73, 8823,   43882,  3, }, // Europe/Jersey
    {   73, 3979,   43885,  5, }, // Europe/Kaliningrad
    {   73, 2527,   43890,  2, }, // Europe/Kyiv
    {   73, 6506,   43892,  4, }, // Europe/Ljubljana
    {   73, 2501,   43896,  2, }, // Europe/London
    {   73, 6365,   43898,  3, }, // Europe/Luxembourg
    {   73, 4892,   43901,  3, }, // Europe/Madrid
    {   73, 6397,   43904,  3, }, // Europe/Malta
    {   73, 6582,   43907,  3, }, // Europe/Mariehamn
    {   73, 6410,   43910,  3, }, // Europe/Monaco
    {   73, 6458,   43913,  3, }, // Europe/Oslo
    {   73, 6324,   43916,  2, }, // Europe/Rome
    {   73, 4331,   43918,  3, }, // Europe/Samara
    {   73, 6470,   43921,  4, }, // Europe/San_Marino
    {   73, 4451,   43925,  4, }, // Europe/Saratov
    {   73, 6599,   43929,  3, }, // Europe/Sofia
    {   73, 6523,   43932,  5, }, // Europe/Stockholm
    {   73, 8882,   43937,  7, }, // Europe/Ulyanovsk
    {   73, 6352,   43944,  3, }, // Europe/Vaduz
    {   73, 6567,   43947,  3, }, // Europe/Vatican
    {   73, 6231,   43950,  3, }, // Europe/Vienna
    {   73, 8899,   43953,  4, }, // Europe/Vilnius
    {   73, 4727,   43957,  5, }, // Europe/Volgograd
    {   73, 3190,   43962,  2, }, // Europe/Warsaw
    {   73, 6540,   43964,  3, }, // Europe/Zurich
    {   73, 6046,   43967,  3, }, // Indian/Christmas
    {   73, 6063,   43970,  5, }, // Indian/Cocos
    {   73, 5029,   43975,  5, }, // Indian/Comoro
    {   73, 6661,   43980,  5, }, // Indian/Kerguelen
    {   73, 7260,   43985,  3, }, // Indian/Mahe
    {   73, 7050,   43988,  4, }, // Indian/Maldives
    {   73, 5098,   43992,  4, }, // Indian/Mayotte
    {   73, 7211,   43996,  4, }, // Indian/Reunion
    {   73, 4422,   44000,  3, }, // Pacific/Apia
    {   73,  932,   44003,  3, }, // Pacific/Auckland
    {   73, 3706,   44006,  4, }, // Pacific/Bougainville
    {   73, 2237,   44010,  3, }, // Pacific/Easter
    {   73, 3902,   44013,  2, }, // Pacific/Fiji
    {   73, 6678,   44015,  6, }, // Pacific/Galapagos
    {   73, 6696,   44021,  5, }, // Pacific/Gambier
    {   73, 3822,   44026,  6, }, // Pacific/Guadalcanal
    {   73, 6018,   44032,  2, }, // Pacific/Guam
    {   73, 3049,   44034,  5, }, // Pacific/Kanton
    {   73, 3998,   44039,  6, }, // Pacific/Kiritimati
    {   73, 2842,   44045,  4, }, // Pacific/Kwajalein
    {   73, 4877,   44049,  3, }, // Pacific/Majuro
    {   73, 4051,   44052,  5, }, // Pacific/Marquesas
    {   73, 8914,   44057,  3, }, // Pacific/Midway
    {   73, 7084,   44060,  2, }, // Pacific/Nauru
    {   73, 7132,   44062,  3, }, // Pacific/Niue
    {   73, 4168,   44065,  3, }, // Pacific/Norfolk
    {   73, 7098,   44068,  3, }, // Pacific/Noumea
    {   73, 7194,   44071,  5, }, // Pacific/Pitcairn
    {   73, 3096,   44076,  3, }, // Pacific/Pohnpei
    {   73, 6076,   44079,  4, }, // Pacific/Rarotonga
    {   73, 4583,   44083,  5, }, // Pacific/Tongatapu
    {   76, 5059,    3902, 11, }, // Africa/Addis_Ababa Catalan/Latin/Spain
    {   76, 7420,   44088,  5, }, // Africa/Algiers
    {   76,   14,       0,  6, }, // Africa/Asmara
    {   76, 2320,   44093,  9, }, // Africa/Cairo
    {   76, 5166,   44102,  8, }, // Africa/El_Aaiun
    {   76, 4524,   26504,  7, }, // Africa/Khartoum
    {   76, 5113,   44110, 10, }, // Africa/Mogadishu
    {   76, 7034,   44120,  8, }, // Africa/Monrovia
    {   76, 5271,   44128,  9, }, // Africa/Ndjamena
    {   76, 4435,       6,  8, }, // Africa/Sao_Tome
    {   76, 2866,   20467,  7, }, // Africa/Tripoli
    {   76, 4554,   26559,  9, }, // America/Araguaina
    {   76,  270,   20479,  7, }, // America/Argentina/Cordoba
    {   76, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {   76, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {   76, 4252,      14,  8, }, // America/Asuncion
    {   76,  237,      22,  8, }, // America/Atikokan
    {   76, 7623,      30, 17, }, // America/Bahia_Banderas
    {   76, 7646,   35896,  5, }, // America/Belem
    {   76, 7660,   44149, 12, }, // America/Blanc-Sablon
    {   76, 4361,   44161,  6, }, // America/Bogota
    {   76, 3868,   33314,  6, }, // America/Cancun
    {   76, 4345,   44167,  6, }, // America/Cayenne
    {   76, 5496,   44173,  6, }, // America/Cayman
    {   76, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   76, 3791,   26574,  6, }, // America/Cuiaba
    {   76, 5723,      66,  7, }, // America/Curacao
    {   76, 7869,   26580,  8, }, // America/Eirunepe
    {   76,  481,      73, 13, }, // America/Indiana/Knox
    {   76, 7961,      86, 16, }, // America/Indiana/Marengo
    {   76, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   76, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   76, 8038,     139, 14, }, // America/Indiana/Vevay
    {   76, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   76, 8086,     171, 16, }, // America/Indiana/Winamac
    {   76, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   76, 5932,     207, 22, }, // America/Lower_Princes
    {   76, 8153,   26588,  6, }, // America/Maceio
    {   76, 5805,   20554,  9, }, // America/Martinique
    {   76, 2917,   26603,  8, }, // America/Mazatlan
    {   76, 8220,     229,  6, }, // America/Merida
    {   76, 2949,   44179, 15, }, // America/Mexico_City
    {   76, 2379,   44194,  9, }, // America/New_York
    {   76, 1850,     235, 19, }, // America/Noronha
    {   76, 8301,   44203, 23, }, // America/North_Dakota/Beulah
    {   76, 8329,   44226, 23, }, // America/North_Dakota/Center
    {   76, 8357,   44249, 26, }, // America/North_Dakota/New_Salem
    {   76,  393,     317,  4, }, // America/Nuuk
    {   76, 2356,   44275,  6, }, // America/Panama
    {   76, 8477,   26704,  8, }, // America/Santarem
    {   76, 1878,   26712,  9, }, // America/Sao_Paulo
    {   76, 6899,   44281, 12, }, // America/Scoresbysund
    {   76, 8508,   35936, 16, }, // America/St_Barthelemy
    {   76, 2061,   26737, 12, }, // America/St_Johns
    {   76, 5863,   26749, 11, }, // America/St_Kitts
    {   76, 5880,   35964, 11, }, // America/St_Lucia
    {   76,  855,   44293, 12, }, // America/St_Thomas
    {   76, 5913,   26783, 13, }, // America/St_Vincent
    {   76, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   76, 5511,   44305,  6, }, // Asia/Anadyr
    {   76, 5523,   44311,  5, }, // Asia/Aqtau
    {   76, 5368,   44316,  6, }, // Asia/Aqtobe
    {   76,  964,   44322,  7, }, // Asia/Ashgabat
    {   76, 8624,   44329,  6, }, // Asia/Atyrau
    {   76, 3607,    4162,  6, }, // Asia/Baghdad
    {   76, 3653,   20747,  4, }, // Asia/Baku
    {   76, 3571,   44335,  7, }, // Asia/Barnaul
    {   76, 4601,   44342,  5, }, // Asia/Chita
    {   76, 4540,   20757,  6, }, // Asia/Damascus
    {   76, 6159,   44347,  8, }, // Asia/Dushanbe
    {   76, 1259,   44355, 11, }, // Asia/Ho_Chi_Minh
    {   76, 4771,   26835,  5, }, // Asia/Hovd
    {   76, 6992,   44366,  6, }, // Asia/Jayapura
    {   76, 4316,   26840,  9, }, // Asia/Kamchatka
    {   76, 1185,   20830,  8, }, // Asia/Kathmandu
    {   76,  992,   20838,  7, }, // Asia/Kolkata
    {   76, 4197,   26871, 11, }, // Asia/Krasnoyarsk
    {   76, 1211,    4321,  5, }, // Asia/Macau
    {   76, 6920,   36067,  6, }, // Asia/Muscat
    {   76, 2554,   44372,  7, }, // Asia/Nicosia
    {   76, 4135,   44379, 12, }, // Asia/Novosibirsk
    {   76, 8708,   44391,  8, }, // Asia/Qostanay
    {   76, 3584,    7787,  4, }, // Asia/Riyadh
    {   76, 4408,   44399,  8, }, // Asia/Sakhalin
    {   76, 7245,   20886, 10, }, // Asia/Samarkand
    {   76, 3279,   44407,  4, }, // Asia/Seoul
    {   76, 3300,   20900,  8, }, // Asia/Singapore
    {   76, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {   76, 4781,   44411,  8, }, // Asia/Tashkent
    {   76, 2772,    7842,  7, }, // Asia/Tehran
    {   76, 2821,   44419,  6, }, // Asia/Tokyo
    {   76, 1159,   44425,  7, }, // Asia/Urumqi
    {   76, 8722,   44432,  9, }, // Asia/Ust-Nera
    {   76, 4828,   44441,  7, }, // Asia/Yakutsk
    {   76, 1235,     477,  6, }, // Asia/Yangon
    {   76, 3883,   44448, 13, }, // Asia/Yekaterinburg
    {   76, 3663,   44461,  6, }, // Atlantic/Azores
    {   76, 5671,   44467,  8, }, // Atlantic/Bermuda
    {   76, 6628,   44475, 14, }, // Atlantic/Canary
    {   76, 3727,   44489,  8, }, // Atlantic/Cape_Verde
    {   76, 1395,   44497, 11, }, // Atlantic/Faroe
    {   76, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {   76, 7272,   44508, 15, }, // Atlantic/South_Georgia
    {   76, 6821,   36198, 12, }, // Atlantic/St_Helena
    {   76, 3620,   44523,  8, }, // Europe/Astrakhan
    {   76, 2300,   21046,  6, }, // Europe/Athens
    {   76, 6336,   27015,  7, }, // Europe/Belgrade
    {   76, 4757,   21059,  6, }, // Europe/Berlin
    {   76, 2167,   44531, 11, }, // Europe/Brussels
    {   76, 3928,   21073,  8, }, // Europe/Bucharest
    {   76, 6289,   44542, 11, }, // Europe/Copenhagen
    {   76, 2338,   21091,  6, }, // Europe/Dublin
    {   76, 6612,   44553,  8, }, // Europe/Helsinki
    {   76, 8804,    4492,  3, }, // Europe/Isle_of_Man
    {   76, 8929,   44561,  5, }, // Europe/Kirov
    {   76, 2527,   44566,  4, }, // Europe/Kyiv
    {   76, 3213,   21137,  6, }, // Europe/Lisbon
    {   76, 2501,   21152,  7, }, // Europe/London
    {   76, 6365,    4513,  9, }, // Europe/Luxembourg
    {   76, 6410,   44570,  6, }, // Europe/Monaco
    {   76, 3537,   44576,  6, }, // Europe/Moscow
    {   76, 4284,   21180,  5, }, // Europe/Paris
    {   76, 6275,   21185,  5, }, // Europe/Prague
    {   76, 6324,    6064,  4, }, // Europe/Rome
    {   76, 4451,   44582,  7, }, // Europe/Saratov
    {   76, 8849,   44589, 10, }, // Europe/Simferopol
    {   76, 6523,   21204,  8, }, // Europe/Stockholm
    {   76, 6202,   21213,  6, }, // Europe/Tirane
    {   76, 8882,   44599,  9, }, // Europe/Ulyanovsk
    {   76, 6567,   44608,  6, }, // Europe/Vatican
    {   76, 6231,   21230,  5, }, // Europe/Vienna
    {   76, 8899,   44614,  7, }, // Europe/Vilnius
    {   76, 3190,   44621,  8, }, // Europe/Warsaw
    {   76, 6540,   44629,  5, }, // Europe/Zurich
    {   76, 4069,   21252,  7, }, // Indian/Mauritius
    {   76, 7211,   21260,  6, }, // Indian/Reunion
    {   76, 3157,     554,  5, }, // Pacific/Chuuk
    {   76, 2237,   44634, 14, }, // Pacific/Easter
    {   76, 6678,   21277,  9, }, // Pacific/Galapagos
    {   76, 2723,    4611,  8, }, // Pacific/Honolulu
    {   76, 3049,    4619,  9, }, // Pacific/Kanton
    {   76, 4051,   44648,  9, }, // Pacific/Marquesas
    {   76, 7098,    4628,  6, }, // Pacific/Noumea
    {   76, 3096,     586,  7, }, // Pacific/Pohnpei
    {   76, 7312,   44657,  6, }, // Pacific/Tahiti
    {   80,   14,       0,  6, }, // Africa/Asmara Cebuano/Latin/Philippines
    {   80, 4435,       6,  8, }, // Africa/Sao_Tome
    {   80, 4252,      14,  8, }, // America/Asuncion
    {   80,  237,      22,  8, }, // America/Atikokan
    {   80, 7623,      30, 17, }, // America/Bahia_Banderas
    {   80, 3868,      47,  6, }, // America/Cancun
    {   80, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   80, 5723,      66,  7, }, // America/Curacao
    {   80,  481,      73, 13, }, // America/Indiana/Knox
    {   80, 7961,      86, 16, }, // America/Indiana/Marengo
    {   80, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   80, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   80, 8038,     139, 14, }, // America/Indiana/Vevay
    {   80, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   80, 8086,     171, 16, }, // America/Indiana/Winamac
    {   80, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   80, 5932,     207, 22, }, // America/Lower_Princes
    {   80, 8220,     229,  6, }, // America/Merida
    {   80, 1850,     235, 19, }, // America/Noronha
    {   80, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   80, 8329,     274, 20, }, // America/North_Dakota/Center
    {   80, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   80,  393,     317,  4, }, // America/Nuuk
    {   80, 6899,     321, 16, }, // America/Scoresbysund
    {   80, 8508,     337, 14, }, // America/St_Barthelemy
    {   80, 2061,     351, 10, }, // America/St_Johns
    {   80, 5863,     361,  9, }, // America/St_Kitts
    {   80, 5880,     370,  9, }, // America/St_Lucia
    {   80,  855,     379, 10, }, // America/St_Thomas
    {   80, 5913,     389, 11, }, // America/St_Vincent
    {   80, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   80, 1259,   44663, 22, }, // Asia/Ho_Chi_Minh
    {   80, 1185,     448,  9, }, // Asia/Kathmandu
    {   80,  992,     457,  7, }, // Asia/Kolkata
    {   80, 1211,     464,  5, }, // Asia/Macau
    {   80, 1235,     477,  6, }, // Asia/Yangon
    {   80, 1395,     483,  5, }, // Atlantic/Faroe
    {   80, 6821,     488, 10, }, // Atlantic/St_Helena
    {   80, 2527,     514,  4, }, // Europe/Kyiv
    {   80, 7211,     547,  7, }, // Indian/Reunion
    {   80, 3157,     554,  5, }, // Pacific/Chuuk
    {   80, 3049,    4619,  9, }, // Pacific/Kanton
    {   80, 3096,     586,  7, }, // Pacific/Pohnpei
    {   81,   14,       0,  6, }, // Africa/Asmara Central Atlas Tamazight/Latin/Morocco
    {   81, 4435,       6,  8, }, // Africa/Sao_Tome
    {   81, 4252,      14,  8, }, // America/Asuncion
    {   81,  237,      22,  8, }, // America/Atikokan
    {   81, 7623,      30, 17, }, // America/Bahia_Banderas
    {   81, 3868,      47,  6, }, // America/Cancun
    {   81, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   81, 5723,      66,  7, }, // America/Curacao
    {   81,  481,      73, 13, }, // America/Indiana/Knox
    {   81, 7961,      86, 16, }, // America/Indiana/Marengo
    {   81, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   81, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   81, 8038,     139, 14, }, // America/Indiana/Vevay
    {   81, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   81, 8086,     171, 16, }, // America/Indiana/Winamac
    {   81, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   81, 5932,     207, 22, }, // America/Lower_Princes
    {   81, 8220,     229,  6, }, // America/Merida
    {   81, 1850,     235, 19, }, // America/Noronha
    {   81, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   81, 8329,     274, 20, }, // America/North_Dakota/Center
    {   81, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   81,  393,     317,  4, }, // America/Nuuk
    {   81, 6899,     321, 16, }, // America/Scoresbysund
    {   81, 8508,     337, 14, }, // America/St_Barthelemy
    {   81, 2061,     351, 10, }, // America/St_Johns
    {   81, 5863,     361,  9, }, // America/St_Kitts
    {   81, 5880,     370,  9, }, // America/St_Lucia
    {   81,  855,     379, 10, }, // America/St_Thomas
    {   81, 5913,     389, 11, }, // America/St_Vincent
    {   81, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   81, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   81, 1185,     448,  9, }, // Asia/Kathmandu
    {   81,  992,     457,  7, }, // Asia/Kolkata
    {   81, 1211,     464,  5, }, // Asia/Macau
    {   81, 1235,     477,  6, }, // Asia/Yangon
    {   81, 1395,     483,  5, }, // Atlantic/Faroe
    {   81, 6821,     488, 10, }, // Atlantic/St_Helena
    {   81, 2527,     514,  4, }, // Europe/Kyiv
    {   81, 7211,     547,  7, }, // Indian/Reunion
    {   81, 3157,     554,  5, }, // Pacific/Chuuk
    {   81, 3096,     586,  7, }, // Pacific/Pohnpei
    {   82,   14,       0,  6, }, // Africa/Asmara Central Kurdish/Arabic/Iraq
    {   82, 4435,       6,  8, }, // Africa/Sao_Tome
    {   82, 4252,      14,  8, }, // America/Asuncion
    {   82,  237,      22,  8, }, // America/Atikokan
    {   82, 7623,      30, 17, }, // America/Bahia_Banderas
    {   82, 3868,      47,  6, }, // America/Cancun
    {   82, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   82, 5723,      66,  7, }, // America/Curacao
    {   82,  481,      73, 13, }, // America/Indiana/Knox
    {   82, 7961,      86, 16, }, // America/Indiana/Marengo
    {   82, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   82, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   82, 8038,     139, 14, }, // America/Indiana/Vevay
    {   82, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   82, 8086,     171, 16, }, // America/Indiana/Winamac
    {   82, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   82, 5932,     207, 22, }, // America/Lower_Princes
    {   82, 8220,     229,  6, }, // America/Merida
    {   82, 1850,     235, 19, }, // America/Noronha
    {   82, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   82, 8329,     274, 20, }, // America/North_Dakota/Center
    {   82, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   82,  393,     317,  4, }, // America/Nuuk
    {   82, 6899,     321, 16, }, // America/Scoresbysund
    {   82, 8508,     337, 14, }, // America/St_Barthelemy
    {   82, 2061,     351, 10, }, // America/St_Johns
    {   82, 5863,     361,  9, }, // America/St_Kitts
    {   82, 5880,     370,  9, }, // America/St_Lucia
    {   82,  855,     379, 10, }, // America/St_Thomas
    {   82, 5913,     389, 11, }, // America/St_Vincent
    {   82, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   82, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   82, 1185,     448,  9, }, // Asia/Kathmandu
    {   82,  992,     457,  7, }, // Asia/Kolkata
    {   82, 1211,     464,  5, }, // Asia/Macau
    {   82, 1235,     477,  6, }, // Asia/Yangon
    {   82, 1395,     483,  5, }, // Atlantic/Faroe
    {   82, 6821,     488, 10, }, // Atlantic/St_Helena
    {   82, 2527,     514,  4, }, // Europe/Kyiv
    {   82, 7211,     547,  7, }, // Indian/Reunion
    {   82, 3157,     554,  5, }, // Pacific/Chuuk
    {   82, 3096,     586,  7, }, // Pacific/Pohnpei
    {   84, 6788,   44685, 16, }, // Africa/Abidjan Chakma/Chakma/Bangladesh
    {   84, 6760,   44701,  8, }, // Africa/Accra
    {   84, 5059,   44709, 21, }, // Africa/Addis_Ababa
    {   84, 7420,   44730, 20, }, // Africa/Algiers
    {   84,   14,   44750, 16, }, // Africa/Asmara
    {   84,   44,   44766, 12, }, // Africa/Bamako
    {   84, 5257,   44778, 12, }, // Africa/Bangui
    {   84, 6746,   44790, 12, }, // Africa/Banjul
    {   84, 7435,   44802,  8, }, // Africa/Bissau
    {   84, 4957,   44810, 24, }, // Africa/Blantyre
    {   84, 5287,   44834, 18, }, // Africa/Brazzaville
    {   84, 4922,   44852, 24, }, // Africa/Bujumbura
    {   84, 2320,   44876, 10, }, // Africa/Cairo
    {   84, 4117,   44886, 14, }, // Africa/Casablanca
    {   84, 7449,   44900, 10, }, // Africa/Ceuta
    {   84, 6773,   44910, 14, }, // Africa/Conakry
    {   84, 6840,   44924,  8, }, // Africa/Dakar
    {   84, 5130,   44932, 24, }, // Africa/Dar_es_Salaam
    {   84, 5043,   44956, 12, }, // Africa/Djibouti
    {   84, 5243,   44968,  8, }, // Africa/Douala
    {   84, 5166,   44976, 27, }, // Africa/El_Aaiun
    {   84, 6853,   45003, 18, }, // Africa/Freetown
    {   84, 4906,   45021, 18, }, // Africa/Gaborone
    {   84, 5015,   45039,  8, }, // Africa/Harare
    {   84, 4479,   45047, 24, }, // Africa/Johannesburg
    {   84, 4499,   45071,  6, }, // Africa/Juba
    {   84, 5151,   45077, 10, }, // Africa/Kampala
    {   84, 4524,   45087, 14, }, // Africa/Khartoum
    {   84, 4973,   45101, 10, }, // Africa/Kigali
    {   84, 5306,   45111, 12, }, // Africa/Kinshasa
    {   84, 4744,   45123, 10, }, // Africa/Lagos
    {   84, 5336,   45133, 20, }, // Africa/Libreville
    {   84, 6869,   45153,  8, }, // Africa/Lome
    {   84, 5211,   45161, 12, }, // Africa/Luanda
    {   84, 4939,   45173, 18, }, // Africa/Lubumbashi
    {   84, 5001,   45191,  8, }, // Africa/Lusaka
    {   84, 5322,   45199,  8, }, // Africa/Malabo
    {   84, 4987,   45207, 10, }, // Africa/Maputo
    {   84, 5197,   45217, 14, }, // Africa/Maseru
    {   84, 5182,   45231, 16, }, // Africa/Mbabane
    {   84, 5113,   45247, 14, }, // Africa/Mogadishu
    {   84, 7034,   45261, 18, }, // Africa/Monrovia
    {   84, 3853,   45279, 12, }, // Africa/Nairobi
    {   84, 5271,   45291, 18, }, // Africa/Ndjamena
    {   84, 5354,   45309, 10, }, // Africa/Niamey
    {   84, 6803,   45319, 18, }, // Africa/Nouakchott
    {   84, 6727,   45337, 18, }, // Africa/Ouagadougou
    {   84, 5225,   45355, 21, }, // Africa/Porto-Novo
    {   84, 4435,   45376, 15, }, // Africa/Sao_Tome
    {   84, 2866,   45391, 16, }, // Africa/Tripoli
    {   84, 6554,   45407, 16, }, // Africa/Tunis
    {   84, 4152,   45423, 20, }, // Africa/Windhoek
    {   84,  132,   45443,  8, }, // America/Adak
    {   84, 3346,   45451, 20, }, // America/Anchorage
    {   84, 5607,   45471, 20, }, // America/Anguilla
    {   84, 5624,   45491, 22, }, // America/Antigua
    {   84, 4554,   45513, 14, }, // America/Araguaina
    {   84,  166,   45527, 31, }, // America/Argentina/Buenos_Aires
    {   84,   91,   45558, 16, }, // America/Argentina/Catamarca
    {   84,  270,   45574, 14, }, // America/Argentina/Cordoba
    {   84,  441,   45588, 12, }, // America/Argentina/Jujuy
    {   84, 7462,   45600, 13, }, // America/Argentina/La_Rioja
    {   84,  565,   45613, 14, }, // America/Argentina/Mendoza
    {   84, 7489,   45627, 23, }, // America/Argentina/Rio_Gallegos
    {   84, 7520,   45650, 12, }, // America/Argentina/Salta
    {   84, 7544,   45662, 17, }, // America/Argentina/San_Juan
    {   84, 5580,   45679, 17, }, // America/Argentina/San_Luis
    {   84, 7571,   45696, 14, }, // America/Argentina/Tucuman
    {   84, 7597,   45710, 12, }, // America/Argentina/Ushuaia
    {   84, 5640,   45722, 10, }, // America/Aruba
    {   84, 4252,   45732, 22, }, // America/Asuncion
    {   84,  237,   45754, 23, }, // America/Atikokan
    {   84, 3679,   45777,  8, }, // America/Bahia
    {   84, 7623,   45785, 25, }, // America/Bahia_Banderas
    {   84, 5654,   45810, 16, }, // America/Barbados
    {   84, 7646,   45826, 12, }, // America/Belem
    {   84, 5407,   45838, 12, }, // America/Belize
    {   84, 7660,   45850, 27, }, // America/Blanc-Sablon
    {   84, 7681,   45877, 15, }, // America/Boa_Vista
    {   84, 4361,   45892, 10, }, // America/Bogota
    {   84, 7699,   45902, 12, }, // America/Boise
    {   84, 7713,   45914, 25, }, // America/Cambridge_Bay
    {   84, 7735,   45939, 25, }, // America/Campo_Grande
    {   84, 3868,   45964, 18, }, // America/Cancun
    {   84, 4694,   45982, 14, }, // America/Caracas
    {   84, 4345,   45996, 10, }, // America/Cayenne
    {   84, 5496,   46006, 10, }, // America/Cayman
    {   84, 2260,   46016, 10, }, // America/Chicago
    {   84, 7756,   46026, 16, }, // America/Chihuahua
    {   84, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   84, 5422,   46042, 16, }, // America/Costa_Rica
    {   84, 7796,   46058, 18, }, // America/Creston
    {   84, 3791,   46076, 10, }, // America/Cuiaba
    {   84, 5723,   46086, 12, }, // America/Curacao
    {   84, 7812,   46098, 30, }, // America/Danmarkshavn
    {   84, 7833,   46128, 12, }, // America/Dawson
    {   84, 7848,   46140, 25, }, // America/Dawson_Creek
    {   84,  805,   46165, 14, }, // America/Denver
    {   84, 3465,   46179, 20, }, // America/Detroit
    {   84, 5739,   46199, 14, }, // America/Dominica
    {   84,  893,   46213, 24, }, // America/Edmonton
    {   84, 7869,   46237, 16, }, // America/Eirunepe
    {   84, 5441,   46253, 25, }, // America/El_Salvador
    {   84, 7886,   46278, 29, }, // America/Fort_Nelson
    {   84, 7906,   46307, 14, }, // America/Fortaleza
    {   84, 7924,   46321, 15, }, // America/Glace_Bay
    {   84, 6881,   46336, 13, }, // America/Goose_Bay
    {   84, 4612,   46349, 31, }, // America/Grand_Turk
    {   84, 5770,   46380, 12, }, // America/Grenada
    {   84, 5786,   46392, 16, }, // America/Guadeloupe
    {   84, 3760,   46408, 12, }, // America/Guatemala
    {   84, 4841,   46420, 20, }, // America/Guayaquil
    {   84, 6932,   46440,  6, }, // America/Guyana
    {   84, 1939,   46446, 24, }, // America/Halifax
    {   84, 2281,   46470,  6, }, // America/Havana
    {   84, 7942,   46476, 22, }, // America/Hermosillo
    {   84,  348,   46498, 28, }, // America/Indiana/Indianapolis
    {   84,  481,   46526, 30, }, // America/Indiana/Knox
    {   84, 7961,   46556, 32, }, // America/Indiana/Marengo
    {   84, 7985,   46588, 42, }, // America/Indiana/Petersburg
    {   84, 8012,   46630, 34, }, // America/Indiana/Tell_City
    {   84, 8038,   46664, 30, }, // America/Indiana/Vevay
    {   84, 8060,   46694, 42, }, // America/Indiana/Vincennes
    {   84, 8086,   46736, 38, }, // America/Indiana/Winamac
    {   84, 8110,   46774, 18, }, // America/Inuvik
    {   84,  660,   46792, 20, }, // America/Iqaluit
    {   84, 2799,   46812,  8, }, // America/Jamaica
    {   84, 5380,   46820,  8, }, // America/Juneau
    {   84,  521,   46828, 18, }, // America/Kentucky/Louisville
    {   84, 8125,   46846, 36, }, // America/Kentucky/Monticello
    {   84, 5704,   46882, 26, }, // America/Kralendijk
    {   84, 4376,   46908,  9, }, // America/La_Paz
    {   84, 7169,   46917,  6, }, // America/Lima
    {   84, 3239,   46923, 31, }, // America/Los_Angeles
    {   84, 5932,   46954, 48, }, // America/Lower_Princes
    {   84, 8153,   47002, 10, }, // America/Maceio
    {   84, 8168,   47012,  8, }, // America/Managua
    {   84, 1908,   47020, 12, }, // America/Manaus
    {   84, 5897,   47032, 10, }, // America/Marigot
    {   84, 5805,   47042, 18, }, // America/Martinique
    {   84, 8184,   47060, 16, }, // America/Matamoros
    {   84, 2917,   47076, 14, }, // America/Mazatlan
    {   84, 8202,   47090, 16, }, // America/Menominee
    {   84, 8220,   47106, 10, }, // America/Merida
    {   84, 8235,   47116, 16, }, // America/Metlakatla
    {   84, 2949,   47132, 29, }, // America/Mexico_City
    {   84, 4391,   47161, 16, }, // America/Miquelon
    {   84, 8254,   47177, 16, }, // America/Moncton
    {   84, 8270,   47193, 16, }, // America/Monterrey
    {   84, 4098,   47209, 24, }, // America/Montevideo
    {   84, 5824,   47233, 22, }, // America/Montserrat
    {   84, 5481,   47255,  8, }, // America/Nassau
    {   84, 2379,   47263, 24, }, // America/New_York
    {   84, 8288,   47287,  8, }, // America/Nome
    {   84, 1850,   47295, 14, }, // America/Noronha
    {   84, 8301,   47309, 37, }, // America/North_Dakota/Beulah
    {   84, 8329,   47346, 41, }, // America/North_Dakota/Center
    {   84, 8357,   47387, 46, }, // America/North_Dakota/New_Salem
    {   84,  393,   47433,  8, }, // America/Nuuk
    {   84, 8388,   47441, 14, }, // America/Ojinaga
    {   84, 2356,   47455,  6, }, // America/Panama
    {   84, 6173,   47461, 20, }, // America/Paramaribo
    {   84, 2973,   47481, 16, }, // America/Phoenix
    {   84, 3945,   47497, 34, }, // America/Port-au-Prince
    {   84, 5954,   47531, 34, }, // America/Port_of_Spain
    {   84, 8404,   47565, 25, }, // America/Porto_Velho
    {   84, 5843,   47590, 25, }, // America/Puerto_Rico
    {   84, 8424,   47615, 35, }, // America/Rankin_Inlet
    {   84, 8445,   47650, 12, }, // America/Recife
    {   84, 1995,   47662, 10, }, // America/Regina
    {   84, 8460,   47672, 16, }, // America/Resolute
    {   84,  695,   47688, 23, }, // America/Rio_Branco
    {   84, 8477,   47711, 20, }, // America/Santarem
    {   84, 2201,   47731, 16, }, // America/Santiago
    {   84, 6111,   47747, 29, }, // America/Santo_Domingo
    {   84, 1878,   47776, 17, }, // America/Sao_Paulo
    {   84, 6899,   47793, 36, }, // America/Scoresbysund
    {   84, 8494,   47829, 10, }, // America/Sitka
    {   84, 8508,   47839, 32, }, // America/St_Barthelemy
    {   84, 2061,   47871, 25, }, // America/St_Johns
    {   84, 5863,   47896, 26, }, // America/St_Kitts
    {   84, 5880,   47922, 24, }, // America/St_Lucia
    {   84,  855,   47946, 23, }, // America/St_Thomas
    {   84, 5913,   47969, 33, }, // America/St_Vincent
    {   84, 8530,   48002, 29, }, // America/Swift_Current
    {   84, 5461,   48031, 20, }, // America/Tegucigalpa
    {   84, 5756,   48051,  8, }, // America/Thule
    {   84,  313,   48059, 12, }, // America/Tijuana
    {   84,  608,   48071, 16, }, // America/Toronto
    {   84, 5688,   48087, 14, }, // America/Tortola
    {   84, 2093,   48101, 20, }, // America/Vancouver
    {   84, 2144,   48121, 22, }, // America/Whitehorse
    {   84,  734,   48143, 20, }, // America/Winnipeg
    {   84, 8552,   48163, 16, }, // America/Yakutat
    {   84, 6001,   48179, 12, }, // Antarctica/Casey
    {   84, 6094,   48191, 12, }, // Antarctica/Davis
    {   84, 6133,   48203, 37, }, // Antarctica/DumontDUrville
    {   84, 8568,   48240, 22, }, // Antarctica/Macquarie
    {   84, 7066,   48262, 12, }, // Antarctica/Mawson
    {   84, 7113,   48274, 22, }, // Antarctica/McMurdo
    {   84, 8589,   48296, 12, }, // Antarctica/Palmer
    {   84, 7226,   48308, 10, }, // Antarctica/Rothera
    {   84, 7295,   48318,  6, }, // Antarctica/Syowa
    {   84, 8607,   48324, 12, }, // Antarctica/Troll
    {   84, 7374,   48336, 16, }, // Antarctica/Vostok
    {   84, 1429,   48352, 28, }, // Arctic/Longyearbyen
    {   84, 5570,   48380, 14, }, // Asia/Aden
    {   84, 5395,   48394, 12, }, // Asia/Almaty
    {   84, 3968,   48406, 14, }, // Asia/Amman
    {   84, 5511,   48420, 16, }, // Asia/Anadyr
    {   84, 5523,   48436, 12, }, // Asia/Aqtau
    {   84, 5368,   48448, 14, }, // Asia/Aqtobe
    {   84,  964,   48462, 16, }, // Asia/Ashgabat
    {   84, 3607,   48478, 12, }, // Asia/Baghdad
    {   84, 5534,   48490, 14, }, // Asia/Bahrain
    {   84, 3653,   46084,  6, }, // Asia/Baku
    {   84, 4466,   48504, 16, }, // Asia/Bangkok
    {   84, 3571,   48520, 14, }, // Asia/Barnaul
    {   84, 4086,   48534, 14, }, // Asia/Beirut
    {   84, 3778,   48548, 16, }, // Asia/Bishkek
    {   84, 5989,   48564, 14, }, // Asia/Brunei
    {   84, 4601,   48578,  6, }, // Asia/Chita
    {   84, 4511,   48584, 22, }, // Asia/Colombo
    {   84, 4540,   48606, 14, }, // Asia/Damascus
    {   84, 1093,   48620,  4, }, // Asia/Dhaka
    {   84, 6192,   48624,  8, }, // Asia/Dili
    {   84, 3596,   48632,  8, }, // Asia/Dubai
    {   84, 6159,   48640, 14, }, // Asia/Dushanbe
    {   84, 8651,   48654,  4, }, // Asia/Gaza
    {   84, 4795,   48658, 16, }, // Asia/Hebron
    {   84, 1259,   48674, 31, }, // Asia/Ho_Chi_Minh
    {   84, 2704,   48705, 13, }, // Asia/Hong_Kong
    {   84, 4771,   48718, 12, }, // Asia/Hovd
    {   84, 4184,   48730, 24, }, // Asia/Irkutsk
    {   84, 7006,   48754, 10, }, // Asia/Jakarta
    {   84, 6992,   48764, 12, }, // Asia/Jayapura
    {   84, 1290,   48776, 18, }, // Asia/Jerusalem
    {   84, 3560,   48794, 10, }, // Asia/Kabul
    {   84, 4316,   48804, 14, }, // Asia/Kamchatka
    {   84, 4239,   48818, 10, }, // Asia/Karachi
    {   84, 1185,   48828, 18, }, // Asia/Kathmandu
    {   84, 8661,   48846, 14, }, // Asia/Khandyga
    {   84,  992,   48860, 12, }, // Asia/Kolkata
    {   84, 4197,   48872, 28, }, // Asia/Krasnoyarsk
    {   84, 4859,   48900, 22, }, // Asia/Kuala_Lumpur
    {   84, 5976,   48922, 10, }, // Asia/Kuching
    {   84, 5547,   48932, 12, }, // Asia/Kuwait
    {   84, 1211,   48944, 12, }, // Asia/Macau
    {   84, 4017,   48956, 14, }, // Asia/Magadan
    {   84, 1349,   48970, 14, }, // Asia/Makassar
    {   84, 7182,   48984, 12, }, // Asia/Manila
    {   84, 6920,   48996, 12, }, // Asia/Muscat
    {   84, 2554,   49008, 14, }, // Asia/Nicosia
    {   84, 8675,   49022, 32, }, // Asia/Novokuznetsk
    {   84, 4135,   49054, 28, }, // Asia/Novosibirsk
    {   84, 4229,   49082, 16, }, // Asia/Omsk
    {   84, 7145,   49098, 10, }, // Asia/Oral
    {   84, 6961,   49108, 17, }, // Asia/Phnom_Penh
    {   84, 8693,   49125, 24, }, // Asia/Pontianak
    {   84, 4214,   49149, 21, }, // Asia/Pyongyang
    {   84, 5559,   49170,  8, }, // Asia/Qatar
    {   84, 4269,   49178, 18, }, // Asia/Qyzylorda
    {   84, 3584,   49196, 10, }, // Asia/Riyadh
    {   84, 4408,   49206, 12, }, // Asia/Sakhalin
    {   84, 7245,   49218, 24, }, // Asia/Samarkand
    {   84, 3279,   49242, 12, }, // Asia/Seoul
    {   84, 1053,   49254,  8, }, // Asia/Shanghai
    {   84, 3300,   49262, 18, }, // Asia/Singapore
    {   84, 4297,   49280, 40, }, // Asia/Srednekolymsk
    {   84, 3263,   49320, 12, }, // Asia/Taipei
    {   84, 4781,   49332, 18, }, // Asia/Tashkent
    {   84, 3915,   49350, 16, }, // Asia/Tbilisi
    {   84, 2772,   49366, 14, }, // Asia/Tehran
    {   84, 1317,   49380, 12, }, // Asia/Thimphu
    {   84, 2821,   49392, 12, }, // Asia/Tokyo
    {   84, 4572,   49404, 16, }, // Asia/Tomsk
    {   84, 1021,   49420, 18, }, // Asia/Ulaanbaatar
    {   84, 1159,   49438, 16, }, // Asia/Urumqi
    {   84, 8722,   49454, 19, }, // Asia/Ust-Nera
    {   84, 6977,   49473, 24, }, // Asia/Vientiane
    {   84, 4710,   49497, 26, }, // Asia/Vladivostok
    {   84, 4828,   49523, 18, }, // Asia/Yakutsk
    {   84, 1235,   49541, 16, }, // Asia/Yangon
    {   84, 3883,   49557, 32, }, // Asia/Yekaterinburg
    {   84, 3747,   49589, 16, }, // Asia/Yerevan
    {   84, 3663,   49605, 14, }, // Atlantic/Azores
    {   84, 5671,   49619, 12, }, // Atlantic/Bermuda
    {   84, 6628,   49631, 10, }, // Atlantic/Canary
    {   84, 3727,   49641, 19, }, // Atlantic/Cape_Verde
    {   84, 1395,   49660, 10, }, // Atlantic/Faroe
    {   84, 8736,   49670, 10, }, // Atlantic/Madeira
    {   84, 2748,   49680, 18, }, // Atlantic/Reykjavik
    {   84, 7272,   49698, 27, }, // Atlantic/South_Georgia
    {   84, 6821,   49725, 23, }, // Atlantic/St_Helena
    {   84, 6644,   49748, 14, }, // Atlantic/Stanley
    {   84, 1670,   49762, 20, }, // Australia/Adelaide
    {   84, 1635,   49782, 20, }, // Australia/Brisbane
    {   84, 1799,   49802, 25, }, // Australia/Broken_Hill
    {   84, 1583,   49827, 18, }, // Australia/Darwin
    {   84, 3637,   49845, 14, }, // Australia/Eucla
    {   84, 1516,   49859, 14, }, // Australia/Hobart
    {   84, 8753,   49873, 22, }, // Australia/Lindeman
    {   84, 1547,   49895, 19, }, // Australia/Lord_Howe
    {   84, 1727,   49914, 18, }, // Australia/Melbourne
    {   84, 1762,   49932, 10, }, // Australia/Perth
    {   84, 1463,   49942, 12, }, // Australia/Sydney
    {   84, 6441,   49954, 22, }, // Europe/Amsterdam
    {   84, 6216,   49976, 16, }, // Europe/Andorra
    {   84, 3620,   49992, 18, }, // Europe/Astrakhan
    {   84, 2300,   50010, 16, }, // Europe/Athens
    {   84, 6336,   50026, 20, }, // Europe/Belgrade
    {   84, 4757,   50046, 14, }, // Europe/Berlin
    {   84, 6488,   50060, 18, }, // Europe/Bratislava
    {   84, 2167,   50078, 18, }, // Europe/Brussels
    {   84, 3928,   50096, 18, }, // Europe/Bucharest
    {   84, 3806,   50114, 18, }, // Europe/Budapest
    {   84, 8772,   50132, 20, }, // Europe/Busingen
    {   84, 2583,   50152, 14, }, // Europe/Chisinau
    {   84, 6289,   50166, 24, }, // Europe/Copenhagen
    {   84, 2338,   50190, 14, }, // Europe/Dublin
    {   84, 6307,   50204, 20, }, // Europe/Gibraltar
    {   84, 8788,   50224, 16, }, // Europe/Guernsey
    {   84, 6612,   50240, 18, }, // Europe/Helsinki
    {   84, 8804,   50258, 28, }, // Europe/Isle_of_Man
    {   84, 1130,   50286, 22, }, // Europe/Istanbul
    {   84, 8823,   50308, 10, }, // Europe/Jersey
    {   84, 3979,   50318, 24, }, // Europe/Kaliningrad
    {   84, 8929,   50342, 12, }, // Europe/Kirov
    {   84, 2527,   50354, 12, }, // Europe/Kyiv
    {   84, 3213,   50366, 16, }, // Europe/Lisbon
    {   84, 6506,   50382, 16, }, // Europe/Ljubljana
    {   84, 2501,   50398, 16, }, // Europe/London
    {   84, 6365,   50414, 26, }, // Europe/Luxembourg
    {   84, 4892,   50440, 14, }, // Europe/Madrid
    {   84, 6397,   50454, 10, }, // Europe/Malta
    {   84, 6582,   50464, 22, }, // Europe/Mariehamn
    {   84, 3693,   50486, 16, }, // Europe/Minsk
    {   84, 6410,   50502, 10, }, // Europe/Monaco
    {   84, 3537,   50512, 12, }, // Europe/Moscow
    {   84, 6458,   50524, 12, }, // Europe/Oslo
    {   84, 4284,   50536, 14, }, // Europe/Paris
    {   84, 6424,   50550, 18, }, // Europe/Podgorica
    {   84, 6275,   50568, 10, }, // Europe/Prague
    {   84, 8837,   47034,  6, }, // Europe/Riga
    {   84, 6324,   50578,  8, }, // Europe/Rome
    {   84, 4331,   50586,  6, }, // Europe/Samara
    {   84, 6470,   50592, 19, }, // Europe/San_Marino
    {   84, 6245,   50611, 12, }, // Europe/Sarajevo
    {   84, 8849,   50623, 24, }, // Europe/Simferopol
    {   84, 6383,   50647, 16, }, // Europe/Skopje
    {   84, 6599,   50663, 10, }, // Europe/Sofia
    {   84, 6523,   50673, 20, }, // Europe/Stockholm
    {   84, 8867,   50693, 10, }, // Europe/Tallinn
    {   84, 6202,   50703,  8, }, // Europe/Tirane
    {   84, 8882,   50711, 26, }, // Europe/Ulyanovsk
    {   84, 6352,   50737, 10, }, // Europe/Vaduz
    {   84, 6567,   50747, 12, }, // Europe/Vatican
    {   84, 6231,   49473, 10, }, // Europe/Vienna
    {   84, 8899,   50759, 18, }, // Europe/Vilnius
    {   84, 4727,   50777, 22, }, // Europe/Volgograd
    {   84, 3190,   50799, 10, }, // Europe/Warsaw
    {   84, 6261,   50809, 14, }, // Europe/Zagreb
    {   84, 6540,   50823, 12, }, // Europe/Zurich
    {   84, 5078,   50835, 20, }, // Indian/Antananarivo
    {   84, 6947,   50855, 10, }, // Indian/Chagos
    {   84, 6046,   50865, 33, }, // Indian/Christmas
    {   84, 6063,   50898, 12, }, // Indian/Cocos
    {   84, 5029,   50910, 12, }, // Indian/Comoro
    {   84, 6661,   50922, 18, }, // Indian/Kerguelen
    {   84, 7260,   50940,  6, }, // Indian/Mahe
    {   84, 7050,   50946, 14, }, // Indian/Maldives
    {   84, 4069,   50960, 14, }, // Indian/Mauritius
    {   84, 5098,   50974, 10, }, // Indian/Mayotte
    {   84, 7211,   50984, 24, }, // Indian/Reunion
    {   84, 4422,   51008,  8, }, // Pacific/Apia
    {   84,  932,   51016, 22, }, // Pacific/Auckland
    {   84, 3706,   51038, 20, }, // Pacific/Bougainville
    {   84, 3015,   51058, 12, }, // Pacific/Chatham
    {   84, 3157,   51070, 12, }, // Pacific/Chuuk
    {   84, 2237,   51082, 14, }, // Pacific/Easter
    {   84, 7360,   51096, 10, }, // Pacific/Efate
    {   84, 7327,   51106, 16, }, // Pacific/Fakaofo
    {   84, 3902,   51122,  8, }, // Pacific/Fiji
    {   84, 7343,   51130, 14, }, // Pacific/Funafuti
    {   84, 6678,   51144, 22, }, // Pacific/Galapagos
    {   84, 6696,   51166, 18, }, // Pacific/Gambier
    {   84, 3822,   51184, 20, }, // Pacific/Guadalcanal
    {   84, 6018,   51204,  8, }, // Pacific/Guam
    {   84, 2723,   51212, 16, }, // Pacific/Honolulu
    {   84, 3049,   51228, 20, }, // Pacific/Kanton
    {   84, 3998,   51248, 18, }, // Pacific/Kiritimati
    {   84, 7019,   51266, 14, }, // Pacific/Kosrae
    {   84, 2842,   51280, 16, }, // Pacific/Kwajalein
    {   84, 4877,   51296, 10, }, // Pacific/Majuro
    {   84, 4051,   51306, 16, }, // Pacific/Marquesas
    {   84, 8914,   51322, 16, }, // Pacific/Midway
    {   84, 7084,   51338, 10, }, // Pacific/Nauru
    {   84, 7132,   51348, 12, }, // Pacific/Niue
    {   84, 4168,   51360, 16, }, // Pacific/Norfolk
    {   84, 7098,   51376, 10, }, // Pacific/Noumea
    {   84, 3126,   51386, 21, }, // Pacific/Pago_Pago
    {   84, 7155,   51407,  8, }, // Pacific/Palau
    {   84, 7194,   51415, 22, }, // Pacific/Pitcairn
    {   84, 3096,   51437, 10, }, // Pacific/Pohnpei
    {   84, 4807,   51447, 29, }, // Pacific/Port_Moresby
    {   84, 6076,   51476, 14, }, // Pacific/Rarotonga
    {   84, 6031,   51490, 10, }, // Pacific/Saipan
    {   84, 7312,   51500, 10, }, // Pacific/Tahiti
    {   84, 6712,   51510,  6, }, // Pacific/Tarawa
    {   84, 4583,   51516, 14, }, // Pacific/Tongatapu
    {   84, 7392,   51530, 12, }, // Pacific/Wake
    {   84, 7405,   51542, 12, }, // Pacific/Wallis
    {   86, 6788,   36346,  7, }, // Africa/Abidjan Chechen/Cyrillic/Russia
    {   86, 6760,     610,  5, }, // Africa/Accra
    {   86, 5059,     615, 11, }, // Africa/Addis_Ababa
    {   86, 7420,     626,  5, }, // Africa/Algiers
    {   86,   14,     631,  6, }, // Africa/Asmara
    {   86,   44,     637,  6, }, // Africa/Bamako
    {   86, 5257,     643,  5, }, // Africa/Bangui
    {   86, 6746,     648,  6, }, // Africa/Banjul
    {   86, 7435,     654,  5, }, // Africa/Bissau
    {   86, 4957,   27220,  8, }, // Africa/Blantyre
    {   86, 5287,   51554, 10, }, // Africa/Brazzaville
    {   86, 4922,     676,  9, }, // Africa/Bujumbura
    {   86, 2320,   51564,  8, }, // Africa/Cairo
    {   86, 4117,     689, 10, }, // Africa/Casablanca
    {   86, 7449,     699,  5, }, // Africa/Ceuta
    {   86, 6773,     704,  7, }, // Africa/Conakry
    {   86, 6840,     711,  5, }, // Africa/Dakar
    {   86, 5130,   27248, 12, }, // Africa/Dar_es_Salaam
    {   86, 5043,   36379,  7, }, // Africa/Djibouti
    {   86, 5243,     734,  5, }, // Africa/Douala
    {   86, 5166,   27267,  7, }, // Africa/El_Aaiun
    {   86, 6853,     746,  7, }, // Africa/Freetown
    {   86, 4906,     753,  8, }, // Africa/Gaborone
    {   86, 5015,   33913,  6, }, // Africa/Harare
    {   86, 4479,   51572, 12, }, // Africa/Johannesburg
    {   86, 4499,   27305,  5, }, // Africa/Juba
    {   86, 5151,     783,  7, }, // Africa/Kampala
    {   86, 4524,     790,  6, }, // Africa/Khartoum
    {   86, 4973,     796,  6, }, // Africa/Kigali
    {   86, 5306,     802,  7, }, // Africa/Kinshasa
    {   86, 4744,     809,  5, }, // Africa/Lagos
    {   86, 5336,   51584,  9, }, // Africa/Libreville
    {   86, 6869,     822,  4, }, // Africa/Lome
    {   86, 5211,     826,  6, }, // Africa/Luanda
    {   86, 4939,     832,  9, }, // Africa/Lubumbashi
    {   86, 5001,     841,  6, }, // Africa/Lusaka
    {   86, 5322,     847,  6, }, // Africa/Malabo
    {   86, 4987,     853,  6, }, // Africa/Maputo
    {   86, 5197,     859,  6, }, // Africa/Maseru
    {   86, 5182,     865,  7, }, // Africa/Mbabane
    {   86, 5113,     872,  8, }, // Africa/Mogadishu
    {   86, 7034,     880,  7, }, // Africa/Monrovia
    {   86, 3853,   36427,  7, }, // Africa/Nairobi
    {   86, 5271,   27386,  8, }, // Africa/Ndjamena
    {   86, 5354,   36434,  6, }, // Africa/Niamey
    {   86, 6803,     908,  7, }, // Africa/Nouakchott
    {   86, 6727,     915,  8, }, // Africa/Ouagadougou
    {   86, 5225,     923, 10, }, // Africa/Porto-Novo
    {   86, 4435,     933,  8, }, // Africa/Sao_Tome
    {   86, 2866,     941,  7, }, // Africa/Tripoli
    {   86, 6554,     948,  5, }, // Africa/Tunis
    {   86, 4152,     953,  7, }, // Africa/Windhoek
    {   86,  132,     960,  4, }, // America/Adak
    {   86, 3346,   51593,  8, }, // America/Anchorage
    {   86, 5607,   51601,  7, }, // America/Anguilla
    {   86, 5624,     978,  7, }, // America/Antigua
    {   86, 4554,     985,  9, }, // America/Araguaina
    {   86,  166,   51608, 12, }, // America/Argentina/Buenos_Aires
    {   86,   91,    1006,  9, }, // America/Argentina/Catamarca
    {   86,  270,    1015,  7, }, // America/Argentina/Cordoba
    {   86,  441,   27487,  5, }, // America/Argentina/Jujuy
    {   86, 7462,    1027,  8, }, // America/Argentina/La_Rioja
    {   86,  565,    1035,  7, }, // America/Argentina/Mendoza
    {   86, 7489,   51620, 12, }, // America/Argentina/Rio_Gallegos
    {   86, 7520,   27512,  6, }, // America/Argentina/Salta
    {   86, 7544,    1058,  8, }, // America/Argentina/San_Juan
    {   86, 5580,    1066,  8, }, // America/Argentina/San_Luis
    {   86, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {   86, 7597,   27526,  5, }, // America/Argentina/Ushuaia
    {   86, 5640,    1087,  5, }, // America/Aruba
    {   86, 4252,   51632,  8, }, // America/Asuncion
    {   86,  237,    1099, 12, }, // America/Atikokan
    {   86, 3679,    1111,  3, }, // America/Bahia
    {   86, 7623,   51640, 16, }, // America/Bahia_Banderas
    {   86, 5654,    1131,  8, }, // America/Barbados
    {   86, 7646,    1139,  5, }, // America/Belem
    {   86, 5407,    1144,  5, }, // America/Belize
    {   86, 7660,    1149, 12, }, // America/Blanc-Sablon
    {   86, 7681,    1161,  9, }, // America/Boa_Vista
    {   86, 4361,    1170,  6, }, // America/Bogota
    {   86, 7699,   51656,  5, }, // America/Boise
    {   86, 7713,   51661, 13, }, // America/Cambridge_Bay
    {   86, 7735,    1193, 12, }, // America/Campo_Grande
    {   86, 3868,    1205,  6, }, // America/Cancun
    {   86, 4694,    1211,  7, }, // America/Caracas
    {   86, 4345,   51674,  7, }, // America/Cayenne
    {   86, 5496,   27629,  6, }, // America/Cayman
    {   86, 2260,    1247,  6, }, // America/Chicago
    {   86, 7756,    1253,  6, }, // America/Chihuahua
    {   86, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   86, 5422,    1259, 10, }, // America/Costa_Rica
    {   86, 7796,    1269,  7, }, // America/Creston
    {   86, 3791,   27688,  5, }, // America/Cuiaba
    {   86, 5723,   36606,  7, }, // America/Curacao
    {   86, 7812,    1290, 12, }, // America/Danmarkshavn
    {   86, 7833,    1302,  6, }, // America/Dawson
    {   86, 7848,    1308, 11, }, // America/Dawson_Creek
    {   86,  805,    1319,  6, }, // America/Denver
    {   86, 3465,   36649,  7, }, // America/Detroit
    {   86, 5739,    1332,  8, }, // America/Dominica
    {   86,  893,   51681,  8, }, // America/Edmonton
    {   86, 7869,   51689,  8, }, // America/Eirunepe
    {   86, 5441,   27765,  9, }, // America/El_Salvador
    {   86, 7886,   51697, 12, }, // America/Fort_Nelson
    {   86, 7906,    1375,  9, }, // America/Fortaleza
    {   86, 7924,   51709,  9, }, // America/Glace_Bay
    {   86, 6881,   51718,  7, }, // America/Goose_Bay
    {   86, 4612,   34278, 10, }, // America/Grand_Turk
    {   86, 5770,    1410,  7, }, // America/Grenada
    {   86, 5786,    1417,  9, }, // America/Guadeloupe
    {   86, 3760,    1426,  9, }, // America/Guatemala
    {   86, 4841,   51725,  8, }, // America/Guayaquil
    {   86, 6932,   51733,  6, }, // America/Guyana
    {   86, 1939,   51739,  8, }, // America/Halifax
    {   86, 2281,    1457,  6, }, // America/Havana
    {   86, 7942,   51747,  9, }, // America/Hermosillo
    {   86,  348,    1471, 12, }, // America/Indiana/Indianapolis
    {   86,  481,    1483,  4, }, // America/Indiana/Knox
    {   86, 7961,    1496,  7, }, // America/Indiana/Marengo
    {   86, 7985,   34365, 10, }, // America/Indiana/Petersburg
    {   86, 8012,    1531,  9, }, // America/Indiana/Tell_City
    {   86, 8038,   51756,  5, }, // America/Indiana/Vevay
    {   86, 8060,   36739,  7, }, // America/Indiana/Vincennes
    {   86, 8086,   34436,  7, }, // America/Indiana/Winamac
    {   86, 8110,    1570,  6, }, // America/Inuvik
    {   86,  660,    1576,  7, }, // America/Iqaluit
    {   86, 2799,   28011,  6, }, // America/Jamaica
    {   86, 5380,   36746,  5, }, // America/Juneau
    {   86,  521,    1594,  8, }, // America/Kentucky/Louisville
    {   86, 8125,    1602, 10, }, // America/Kentucky/Monticello
    {   86, 5704,   36751, 10, }, // America/Kralendijk
    {   86, 4376,    1632,  6, }, // America/La_Paz
    {   86, 7169,    1638,  4, }, // America/Lima
    {   86, 3239,   51761, 12, }, // America/Los_Angeles
    {   86, 5932,   51773, 21, }, // America/Lower_Princes
    {   86, 8153,   36799,  6, }, // America/Maceio
    {   86, 8168,    1677,  7, }, // America/Managua
    {   86, 1908,    1684,  6, }, // America/Manaus
    {   86, 5897,    1690,  6, }, // America/Marigot
    {   86, 5805,    1696,  9, }, // America/Martinique
    {   86, 8184,    1705,  9, }, // America/Matamoros
    {   86, 2917,    1714,  8, }, // America/Mazatlan
    {   86, 8202,    1722,  8, }, // America/Menominee
    {   86, 8220,    1730,  6, }, // America/Merida
    {   86, 8235,    1736, 10, }, // America/Metlakatla
    {   86, 2949,    1746,  6, }, // America/Mexico_City
    {   86, 4391,    1752,  7, }, // America/Miquelon
    {   86, 8254,    1759,  7, }, // America/Moncton
    {   86, 8270,   51794,  9, }, // America/Monterrey
    {   86, 4098,    1775, 10, }, // America/Montevideo
    {   86, 5824,   51803,  9, }, // America/Montserrat
    {   86, 5481,    1795,  6, }, // America/Nassau
    {   86, 2379,   51812,  8, }, // America/New_York
    {   86, 8288,    1809,  3, }, // America/Nome
    {   86, 1850,   51820,  7, }, // America/Noronha
    {   86, 8301,   51827, 24, }, // America/North_Dakota/Beulah
    {   86, 8329,   51851, 22, }, // America/North_Dakota/Center
    {   86, 8357,   51873,  9, }, // America/North_Dakota/New_Salem
    {   86,  393,   51882,  6, }, // America/Nuuk
    {   86, 8388,    1894,  7, }, // America/Ojinaga
    {   86, 2356,    1901,  6, }, // America/Panama
    {   86, 6173,    1907, 10, }, // America/Paramaribo
    {   86, 2973,    1917,  6, }, // America/Phoenix
    {   86, 3945,    1923, 12, }, // America/Port-au-Prince
    {   86, 5954,   28321, 13, }, // America/Port_of_Spain
    {   86, 8404,   28334, 11, }, // America/Porto_Velho
    {   86, 5843,   51888, 11, }, // America/Puerto_Rico
    {   86, 4030,    1970, 12, }, // America/Punta_Arenas
    {   86, 8424,    1982, 12, }, // America/Rankin_Inlet
    {   86, 8445,    1994,  6, }, // America/Recife
    {   86, 1995,   51899,  8, }, // America/Regina
    {   86, 8460,   36892,  7, }, // America/Resolute
    {   86,  695,    2015, 10, }, // America/Rio_Branco
    {   86, 8477,    2025,  8, }, // America/Santarem
    {   86, 2201,   51907,  8, }, // America/Santiago
    {   86, 6111,    2041, 13, }, // America/Santo_Domingo
    {   86, 1878,    2054,  9, }, // America/Sao_Paulo
    {   86, 6899,    2063, 11, }, // America/Scoresbysund
    {   86, 8494,    2074,  5, }, // America/Sitka
    {   86, 8508,   51915, 13, }, // America/St_Barthelemy
    {   86, 2061,   28481, 10, }, // America/St_Johns
    {   86, 5863,    2101,  9, }, // America/St_Kitts
    {   86, 5880,   51928,  9, }, // America/St_Lucia
    {   86,  855,    2121, 10, }, // America/St_Thomas
    {   86, 5913,    2131, 12, }, // America/St_Vincent
    {   86, 8530,   51937, 12, }, // America/Swift_Current
    {   86, 5461,   51949, 12, }, // America/Tegucigalpa
    {   86, 5756,    2167,  4, }, // America/Thule
    {   86,  313,    2171,  7, }, // America/Tijuana
    {   86,  608,    2178,  7, }, // America/Toronto
    {   86, 5688,    2185,  7, }, // America/Tortola
    {   86, 2093,    2192,  8, }, // America/Vancouver
    {   86, 2144,   28567,  8, }, // America/Whitehorse
    {   86,  734,    2208,  8, }, // America/Winnipeg
    {   86, 8552,   28582,  6, }, // America/Yakutat
    {   86, 6001,   37021,  5, }, // Antarctica/Casey
    {   86, 6094,   37026,  6, }, // Antarctica/Davis
    {   86, 6133,   51961, 14, }, // Antarctica/DumontDUrville
    {   86, 8568,    2249,  8, }, // Antarctica/Macquarie
    {   86, 7066,    2257,  6, }, // Antarctica/Mawson
    {   86, 7113,    2263,  9, }, // Antarctica/McMurdo
    {   86, 8589,    2272,  6, }, // Antarctica/Palmer
    {   86, 7226,    2278,  6, }, // Antarctica/Rothera
    {   86, 7295,   28642,  4, }, // Antarctica/Syowa
    {   86, 8607,   51975,  6, }, // Antarctica/Troll
    {   86, 7374,   34957,  6, }, // Antarctica/Vostok
    {   86, 1429,   51981,  7, }, // Arctic/Longyearbyen
    {   86, 5570,    2310,  4, }, // Asia/Aden
    {   86, 5395,   51988,  8, }, // Asia/Almaty
    {   86, 3968,   51996,  6, }, // Asia/Amman
    {   86, 5511,   52002,  7, }, // Asia/Anadyr
    {   86, 5523,    2331,  5, }, // Asia/Aqtau
    {   86, 5368,    2336,  6, }, // Asia/Aqtobe
    {   86,  964,    2342,  7, }, // Asia/Ashgabat
    {   86, 8624,   52009,  6, }, // Asia/Atyrau
    {   86, 3607,   52015,  7, }, // Asia/Baghdad
    {   86, 5534,   37080,  7, }, // Asia/Bahrain
    {   86, 3653,   52022,  5, }, // Asia/Baku
    {   86, 4466,    2372,  7, }, // Asia/Bangkok
    {   86, 3571,    2379,  7, }, // Asia/Barnaul
    {   86, 4086,   28695,  6, }, // Asia/Beirut
    {   86, 3778,    2392,  6, }, // Asia/Bishkek
    {   86, 5989,   28707,  6, }, // Asia/Brunei
    {   86, 4601,    2404,  4, }, // Asia/Chita
    {   86, 4511,    2408,  7, }, // Asia/Colombo
    {   86, 4540,   52027,  7, }, // Asia/Damascus
    {   86, 1093,    2421,  5, }, // Asia/Dhaka
    {   86, 6192,    2426,  4, }, // Asia/Dili
    {   86, 3596,   28728,  5, }, // Asia/Dubai
    {   86, 6159,    2435,  7, }, // Asia/Dushanbe
    {   86, 8636,    2442,  9, }, // Asia/Famagusta
    {   86, 8651,    2451,  4, }, // Asia/Gaza
    {   86, 4795,    2455,  6, }, // Asia/Hebron
    {   86, 1259,    2461,  7, }, // Asia/Ho_Chi_Minh
    {   86, 2704,   52034,  7, }, // Asia/Hong_Kong
    {   86, 4771,    2475,  4, }, // Asia/Hovd
    {   86, 4184,    2479,  7, }, // Asia/Irkutsk
    {   86, 7006,   28770,  8, }, // Asia/Jakarta
    {   86, 6992,   52041,  7, }, // Asia/Jayapura
    {   86, 1290,   52048, 11, }, // Asia/Jerusalem
    {   86, 3560,    2510,  5, }, // Asia/Kabul
    {   86, 4316,   52059, 23, }, // Asia/Kamchatka
    {   86, 4239,    2540,  6, }, // Asia/Karachi
    {   86, 1185,    2546,  8, }, // Asia/Kathmandu
    {   86, 8661,    2554,  7, }, // Asia/Khandyga
    {   86,  992,   52082,  9, }, // Asia/Kolkata
    {   86, 4197,   37110, 10, }, // Asia/Krasnoyarsk
    {   86, 4859,    2580, 12, }, // Asia/Kuala_Lumpur
    {   86, 5976,    2592,  6, }, // Asia/Kuching
    {   86, 5547,   28825,  6, }, // Asia/Kuwait
    {   86, 1211,    2604,  5, }, // Asia/Macau
    {   86, 4017,    2609,  7, }, // Asia/Magadan
    {   86, 1349,    2616,  7, }, // Asia/Makassar
    {   86, 7182,    2623,  6, }, // Asia/Manila
    {   86, 6920,    2629,  6, }, // Asia/Muscat
    {   86, 2554,    2635,  6, }, // Asia/Nicosia
    {   86, 8675,    2642, 11, }, // Asia/Novokuznetsk
    {   86, 4135,    2653, 11, }, // Asia/Novosibirsk
    {   86, 4229,    2664,  4, }, // Asia/Omsk
    {   86, 7145,   35138,  4, }, // Asia/Oral
    {   86, 6961,   52091,  8, }, // Asia/Phnom_Penh
    {   86, 8693,    2681,  9, }, // Asia/Pontianak
    {   86, 4214,   28895,  7, }, // Asia/Pyongyang
    {   86, 5559,    2697,  5, }, // Asia/Qatar
    {   86, 4269,    2710,  9, }, // Asia/Qyzylorda
    {   86, 3584,   52099,  7, }, // Asia/Riyadh
    {   86, 4408,   52106, 12, }, // Asia/Sakhalin
    {   86, 7245,    2739,  9, }, // Asia/Samarkand
    {   86, 3279,    2748,  4, }, // Asia/Seoul
    {   86, 1053,   28933,  6, }, // Asia/Shanghai
    {   86, 3300,    2758,  8, }, // Asia/Singapore
    {   86, 4297,    2766, 13, }, // Asia/Srednekolymsk
    {   86, 3263,   28961,  6, }, // Asia/Taipei
    {   86, 4781,    2785,  7, }, // Asia/Tashkent
    {   86, 3915,   35206,  7, }, // Asia/Tbilisi
    {   86, 2772,   52118,  7, }, // Asia/Tehran
    {   86, 1317,   35220,  5, }, // Asia/Thimphu
    {   86, 2821,    2810,  5, }, // Asia/Tokyo
    {   86, 4572,    2815,  5, }, // Asia/Tomsk
    {   86, 1021,    2820, 10, }, // Asia/Ulaanbaatar
    {   86, 1159,    2830,  6, }, // Asia/Urumqi
    {   86, 8722,   52125,  9, }, // Asia/Ust-Nera
    {   86, 6977,   52134,  8, }, // Asia/Vientiane
    {   86, 4710,    2851, 11, }, // Asia/Vladivostok
    {   86, 4828,   37183,  6, }, // Asia/Yakutsk
    {   86, 1235,   29043,  6, }, // Asia/Yangon
    {   86, 3883,    2875, 12, }, // Asia/Yekaterinburg
    {   86, 3747,    2887,  6, }, // Asia/Yerevan
    {   86, 3663,   52142, 16, }, // Atlantic/Azores
    {   86, 5671,   52158,  8, }, // Atlantic/Bermuda
    {   86, 6628,   52166, 17, }, // Atlantic/Canary
    {   86, 3727,    2944, 10, }, // Atlantic/Cape_Verde
    {   86, 1395,   52183, 18, }, // Atlantic/Faroe
    {   86, 8736,   52201, 13, }, // Atlantic/Madeira
    {   86, 2748,   52214,  9, }, // Atlantic/Reykjavik
    {   86, 7272,   52223, 14, }, // Atlantic/South_Georgia
    {   86, 6821,   52237, 19, }, // Atlantic/St_Helena
    {   86, 6644,   52256,  6, }, // Atlantic/Stanley
    {   86, 1670,    3035,  8, }, // Australia/Adelaide
    {   86, 1635,    3043,  7, }, // Australia/Brisbane
    {   86, 1799,    3050, 11, }, // Australia/Broken_Hill
    {   86, 1583,    3061,  6, }, // Australia/Darwin
    {   86, 3637,   29240,  4, }, // Australia/Eucla
    {   86, 1516,    3072,  6, }, // Australia/Hobart
    {   86, 8753,    3078,  8, }, // Australia/Lindeman
    {   86, 1547,   52262, 14, }, // Australia/Lord_Howe
    {   86, 1727,   29252,  8, }, // Australia/Melbourne
    {   86, 1762,    3101,  4, }, // Australia/Perth
    {   86, 1463,   52276,  6, }, // Australia/Sydney
    {   86, 6441,    3111,  9, }, // Europe/Amsterdam
    {   86, 6216,    3120,  7, }, // Europe/Andorra
    {   86, 3620,   52282,  9, }, // Europe/Astrakhan
    {   86, 2300,   52291,  5, }, // Europe/Athens
    {   86, 6336,    3139,  7, }, // Europe/Belgrade
    {   86, 4757,    3146,  6, }, // Europe/Berlin
    {   86, 6488,    3152, 10, }, // Europe/Bratislava
    {   86, 2167,   52296,  8, }, // Europe/Brussels
    {   86, 3928,    3170,  8, }, // Europe/Bucharest
    {   86, 3806,    3178,  8, }, // Europe/Budapest
    {   86, 8772,   52304, 19, }, // Europe/Busingen
    {   86, 2583,    3209,  7, }, // Europe/Chisinau
    {   86, 6289,   52323, 10, }, // Europe/Copenhagen
    {   86, 2338,    3226,  6, }, // Europe/Dublin
    {   86, 6307,    3232,  9, }, // Europe/Gibraltar
    {   86, 8788,    3241,  6, }, // Europe/Guernsey
    {   86, 6612,   52333,  9, }, // Europe/Helsinki
    {   86, 8804,   52342,  9, }, // Europe/Isle_of_Man
    {   86, 1130,    3264,  7, }, // Europe/Istanbul
    {   86, 8823,   52351,  6, }, // Europe/Jersey
    {   86, 3979,    3276, 11, }, // Europe/Kaliningrad
    {   86, 8929,    3287,  5, }, // Europe/Kirov
    {   86, 2527,    3292,  4, }, // Europe/Kyiv
    {   86, 3213,    3296,  8, }, // Europe/Lisbon
    {   86, 6506,   29432,  7, }, // Europe/Ljubljana
    {   86, 2501,    3313,  6, }, // Europe/London
    {   86, 6365,   29445, 10, }, // Europe/Luxembourg
    {   86, 4892,    3330,  6, }, // Europe/Madrid
    {   86, 6397,   29461,  6, }, // Europe/Malta
    {   86, 6582,    3341,  9, }, // Europe/Mariehamn
    {   86, 3693,    3350,  5, }, // Europe/Minsk
    {   86, 6410,    3355,  6, }, // Europe/Monaco
    {   86, 3537,    3361,  6, }, // Europe/Moscow
    {   86, 6458,    3367,  4, }, // Europe/Oslo
    {   86, 4284,    3371,  5, }, // Europe/Paris
    {   86, 6424,    3376,  9, }, // Europe/Podgorica
    {   86, 6275,    3385,  5, }, // Europe/Prague
    {   86, 8837,    3390,  4, }, // Europe/Riga
    {   86, 6324,    3394,  3, }, // Europe/Rome
    {   86, 4331,    3397,  6, }, // Europe/Samara
    {   86, 6470,    3403, 10, }, // Europe/San_Marino
    {   86, 6245,    3413,  7, }, // Europe/Sarajevo
    {   86, 4451,    3420,  7, }, // Europe/Saratov
    {   86, 8849,   52357, 11, }, // Europe/Simferopol
    {   86, 6383,   52368,  6, }, // Europe/Skopje
    {   86, 6599,    3442,  4, }, // Europe/Sofia
    {   86, 6523,   52374,  9, }, // Europe/Stockholm
    {   86, 8867,    3455,  6, }, // Europe/Tallinn
    {   86, 6202,    3461,  6, }, // Europe/Tirane
    {   86, 8882,   52383,  9, }, // Europe/Ulyanovsk
    {   86, 6352,    3476,  5, }, // Europe/Vaduz
    {   86, 6567,    3481,  7, }, // Europe/Vatican
    {   86, 6231,    3488,  4, }, // Europe/Vienna
    {   86, 8899,   52392,  7, }, // Europe/Vilnius
    {   86, 4727,    3499,  9, }, // Europe/Volgograd
    {   86, 3190,    3508,  7, }, // Europe/Warsaw
    {   86, 6261,    3515,  6, }, // Europe/Zagreb
    {   86, 6540,   37442,  5, }, // Europe/Zurich
    {   86, 5078,    3527, 12, }, // Indian/Antananarivo
    {   86, 6947,    3539,  5, }, // Indian/Chagos
    {   86, 6046,   52399, 31, }, // Indian/Christmas
    {   86, 6063,   52430, 16, }, // Indian/Cocos
    {   86, 5029,   52446, 18, }, // Indian/Comoro
    {   86, 6661,    3578,  8, }, // Indian/Kerguelen
    {   86, 7260,   29694,  3, }, // Indian/Mahe
    {   86, 7050,   52464,  9, }, // Indian/Maldives
    {   86, 4069,    3595,  7, }, // Indian/Mauritius
    {   86, 5098,   52473,  7, }, // Indian/Mayotte
    {   86, 7211,   52480,  7, }, // Indian/Reunion
    {   86, 4422,    3616,  3, }, // Pacific/Apia
    {   86,  932,    3620,  6, }, // Pacific/Auckland
    {   86, 3706,   52487, 15, }, // Pacific/Bougainville
    {   86, 3015,   52502, 11, }, // Pacific/Chatham
    {   86, 3157,   52513, 12, }, // Pacific/Chuuk
    {   86, 2237,   52525, 16, }, // Pacific/Easter
    {   86, 7360,   52541,  5, }, // Pacific/Efate
    {   86, 7327,    3659,  7, }, // Pacific/Fakaofo
    {   86, 3902,   37539,  5, }, // Pacific/Fiji
    {   86, 7343,    3670,  8, }, // Pacific/Funafuti
    {   86, 6678,   52546, 21, }, // Pacific/Galapagos
    {   86, 6696,   52567, 15, }, // Pacific/Gambier
    {   86, 3822,   35719, 11, }, // Pacific/Guadalcanal
    {   86, 6018,    3724,  4, }, // Pacific/Guam
    {   86, 2723,   52582,  8, }, // Pacific/Honolulu
    {   86, 3049,   52590, 16, }, // Pacific/Kanton
    {   86, 3998,    3734, 10, }, // Pacific/Kiritimati
    {   86, 7019,    3744,  6, }, // Pacific/Kosrae
    {   86, 2842,   29841, 10, }, // Pacific/Kwajalein
    {   86, 4877,   37574,  7, }, // Pacific/Majuro
    {   86, 4051,   52606, 16, }, // Pacific/Marquesas
    {   86, 8914,   52622, 14, }, // Pacific/Midway
    {   86, 7084,    3798,  5, }, // Pacific/Nauru
    {   86, 7132,   52636,  4, }, // Pacific/Niue
    {   86, 4168,    3807,  7, }, // Pacific/Norfolk
    {   86, 7098,    3814,  5, }, // Pacific/Noumea
    {   86, 3126,    3819,  9, }, // Pacific/Pago_Pago
    {   86, 7155,    3828,  5, }, // Pacific/Palau
    {   86, 7194,    3833,  7, }, // Pacific/Pitcairn
    {   86, 3096,   52640, 14, }, // Pacific/Pohnpei
    {   86, 4807,    3846, 11, }, // Pacific/Port_Moresby
    {   86, 6076,    3857,  9, }, // Pacific/Rarotonga
    {   86, 6031,   29935,  6, }, // Pacific/Saipan
    {   86, 7312,   52654, 13, }, // Pacific/Tahiti
    {   86, 6712,    3877,  6, }, // Pacific/Tarawa
    {   86, 4583,    3883,  9, }, // Pacific/Tongatapu
    {   86, 7392,   52667, 10, }, // Pacific/Wake
    {   86, 7405,    3896,  6, }, // Pacific/Wallis
    {   87, 6788,   52677,  4, }, // Africa/Abidjan Cherokee/Cherokee/United States
    {   87, 6760,   52681,  2, }, // Africa/Accra
    {   87, 5059,   52683,  7, }, // Africa/Addis_Ababa
    {   87, 7420,   52690,  4, }, // Africa/Algiers
    {   87,   14,   52694,  4, }, // Africa/Asmara
    {   87,   44,   52698,  3, }, // Africa/Bamako
    {   87, 5257,   52701,  4, }, // Africa/Bangui
    {   87, 6746,   52705,  4, }, // Africa/Banjul
    {   87, 7435,   52709,  3, }, // Africa/Bissau
    {   87, 4957,   52712,  3, }, // Africa/Blantyre
    {   87, 5287,   52715,  4, }, // Africa/Brazzaville
    {   87, 4922,   52719,  5, }, // Africa/Bujumbura
    {   87, 2320,   52724,  3, }, // Africa/Cairo
    {   87, 4117,   52727,  8, }, // Africa/Casablanca
    {   87, 7449,   52735,  2, }, // Africa/Ceuta
    {   87, 6773,   52737,  3, }, // Africa/Conakry
    {   87, 6840,   52740,  3, }, // Africa/Dakar
    {   87, 5130,   52743,  8, }, // Africa/Dar_es_Salaam
    {   87, 5043,   52751,  3, }, // Africa/Djibouti
    {   87, 5243,   52754,  4, }, // Africa/Douala
    {   87, 5166,   52758,  7, }, // Africa/El_Aaiun
    {   87, 6853,   52765,  7, }, // Africa/Freetown
    {   87, 4906,   52772,  4, }, // Africa/Gaborone
    {   87, 5015,   52776,  3, }, // Africa/Harare
    {   87, 4479,   52779,  6, }, // Africa/Johannesburg
    {   87, 4499,   52785,  2, }, // Africa/Juba
    {   87, 5151,   52787,  4, }, // Africa/Kampala
    {   87, 4524,   52791,  3, }, // Africa/Khartoum
    {   87, 4973,   52794,  3, }, // Africa/Kigali
    {   87, 5306,   52797,  4, }, // Africa/Kinshasa
    {   87, 4744,   52801,  3, }, // Africa/Lagos
    {   87, 5336,   52804,  4, }, // Africa/Libreville
    {   87, 6869,   52808,  2, }, // Africa/Lome
    {   87, 5211,   52810,  4, }, // Africa/Luanda
    {   87, 4939,   52814,  4, }, // Africa/Lubumbashi
    {   87, 5001,   52818,  3, }, // Africa/Lusaka
    {   87, 5322,   52821,  3, }, // Africa/Malabo
    {   87, 4987,   52824,  3, }, // Africa/Maputo
    {   87, 5197,   52827,  3, }, // Africa/Maseru
    {   87, 5182,   52830,  3, }, // Africa/Mbabane
    {   87, 5113,   52833,  4, }, // Africa/Mogadishu
    {   87, 7034,   52837,  5, }, // Africa/Monrovia
    {   87, 3853,   52842,  4, }, // Africa/Nairobi
    {   87, 5271,   52846,  4, }, // Africa/Ndjamena
    {   87, 5354,   52850,  3, }, // Africa/Niamey
    {   87, 6803,   52853,  4, }, // Africa/Nouakchott
    {   87, 6727,   52857,  5, }, // Africa/Ouagadougou
    {   87, 5225,   52862, 11, }, // Africa/Porto-Novo
    {   87, 4435,   52873,  4, }, // Africa/Sao_Tome
    {   87, 2866,   52877,  3, }, // Africa/Tripoli
    {   87, 6554,   52880,  3, }, // Africa/Tunis
    {   87, 4152,   52883,  5, }, // Africa/Windhoek
    {   87,  132,   52888,  3, }, // America/Adak
    {   87, 3346,   52891,  5, }, // America/Anchorage
    {   87, 5607,   52896,  4, }, // America/Anguilla
    {   87, 5624,   52900,  3, }, // America/Antigua
    {   87, 4554,   52903,  6, }, // America/Araguaina
    {   87,  166,   52909,  7, }, // America/Argentina/Buenos_Aires
    {   87,   91,   52916,  4, }, // America/Argentina/Catamarca
    {   87,  270,   52920,  3, }, // America/Argentina/Cordoba
    {   87,  441,   52923,  3, }, // America/Argentina/Jujuy
    {   87, 7462,   52926,  5, }, // America/Argentina/La_Rioja
    {   87,  565,   52931,  4, }, // America/Argentina/Mendoza
    {   87, 7489,   52935,  8, }, // America/Argentina/Rio_Gallegos
    {   87, 7520,   52943,  3, }, // America/Argentina/Salta
    {   87, 7544,   52946,  5, }, // America/Argentina/San_Juan
    {   87, 5580,   52951,  8, }, // America/Argentina/San_Luis
    {   87, 7571,   52959,  4, }, // America/Argentina/Tucuman
    {   87, 7597,   52963,  4, }, // America/Argentina/Ushuaia
    {   87, 5640,   52967,  3, }, // America/Aruba
    {   87, 4252,   52970,  5, }, // America/Asuncion
    {   87,  237,   52975,  5, }, // America/Atikokan
    {   87, 3679,   52980,  3, }, // America/Bahia
    {   87, 7623,   52983,  9, }, // America/Bahia_Banderas
    {   87, 5654,   52992,  4, }, // America/Barbados
    {   87, 7646,   52996,  3, }, // America/Belem
    {   87, 5407,   52999,  3, }, // America/Belize
    {   87, 7660,   53002,  6, }, // America/Blanc-Sablon
    {   87, 7681,   53008,  9, }, // America/Boa_Vista
    {   87, 4361,   53017,  3, }, // America/Bogota
    {   87, 7699,   53020,  3, }, // America/Boise
    {   87, 7713,   53023, 10, }, // America/Cambridge_Bay
    {   87, 7735,   53033,  7, }, // America/Campo_Grande
    {   87, 3868,   53040,  4, }, // America/Cancun
    {   87, 4694,   53044,  4, }, // America/Caracas
    {   87, 4345,   53048,  3, }, // America/Cayenne
    {   87, 5496,   53051,  4, }, // America/Cayman
    {   87, 2260,   53055,  3, }, // America/Chicago
    {   87, 7756,   53058,  3, }, // America/Chihuahua
    {   87, 7774,   53061,  7, }, // America/Ciudad_Juarez
    {   87, 5422,   53068,  5, }, // America/Costa_Rica
    {   87, 7796,   53073,  4, }, // America/Creston
    {   87, 3791,   53077,  3, }, // America/Cuiaba
    {   87, 5723,   53080,  4, }, // America/Curacao
    {   87, 7812,   53084,  7, }, // America/Danmarkshavn
    {   87, 7833,   53091,  3, }, // America/Dawson
    {   87, 7848,   53094,  7, }, // America/Dawson_Creek
    {   87,  805,   53101,  8, }, // America/Denver
    {   87, 3465,   53109,  3, }, // America/Detroit
    {   87, 5739,   53112,  4, }, // America/Dominica
    {   87,  893,   53116,  6, }, // America/Edmonton
    {   87, 7869,   53122,  4, }, // America/Eirunepe
    {   87, 5441,   53126,  8, }, // America/El_Salvador
    {   87, 7886,   53134,  8, }, // America/Fort_Nelson
    {   87, 7906,   53142,  4, }, // America/Fortaleza
    {   87, 7924,   53146,  8, }, // America/Glace_Bay
    {   87, 6881,   53154,  8, }, // America/Goose_Bay
    {   87, 4612,   53162,  8, }, // America/Grand_Turk
    {   87, 5770,   53170,  3, }, // America/Grenada
    {   87, 5786,   53173,  4, }, // America/Guadeloupe
    {   87, 3760,   53177,  4, }, // America/Guatemala
    {   87, 4841,   53181,  4, }, // America/Guayaquil
    {   87, 6932,   53185,  3, }, // America/Guyana
    {   87, 1939,   53188,  5, }, // America/Halifax
    {   87, 2281,   53193,  3, }, // America/Havana
    {   87, 7942,   53196,  4, }, // America/Hermosillo
    {   87,  348,   53200,  9, }, // America/Indiana/Indianapolis
    {   87,  481,   53209, 10, }, // America/Indiana/Knox
    {   87, 7961,   53219, 11, }, // America/Indiana/Marengo
    {   87, 7985,   53230, 11, }, // America/Indiana/Petersburg
    {   87, 8012,   53241, 13, }, // America/Indiana/Tell_City
    {   87, 8038,   53254,  9, }, // America/Indiana/Vevay
    {   87, 8060,   53263, 12, }, // America/Indiana/Vincennes
    {   87, 8086,   53275, 11, }, // America/Indiana/Winamac
    {   87, 8110,   53286,  4, }, // America/Inuvik
    {   87,  660,   53290,  5, }, // America/Iqaluit
    {   87, 2799,   53295,  4, }, // America/Jamaica
    {   87, 5380,   53299,  2, }, // America/Juneau
    {   87,  521,   53301,  4, }, // America/Kentucky/Louisville
    {   87, 8125,   53305, 11, }, // America/Kentucky/Monticello
    {   87, 5704,   53316,  4, }, // America/Kralendijk
    {   87, 4376,   53320,  2, }, // America/La_Paz
    {   87, 7169,   53304,  2, }, // America/Lima
    {   87, 3239,   53322, 12, }, // America/Los_Angeles
    {   87, 5932,   53334, 17, }, // America/Lower_Princes
    {   87, 8153,   53351,  3, }, // America/Maceio
    {   87, 8168,   53354,  3, }, // America/Managua
    {   87, 1908,   53357,  4, }, // America/Manaus
    {   87, 5897,   53361,  4, }, // America/Marigot
    {   87, 5805,   53365,  4, }, // America/Martinique
    {   87, 8184,   53369,  5, }, // America/Matamoros
    {   87, 2917,   53374,  4, }, // America/Mazatlan
    {   87, 8202,   53378,  4, }, // America/Menominee
    {   87, 8220,   53382,  3, }, // America/Merida
    {   87, 8235,   53385,  4, }, // America/Metlakatla
    {   87, 2949,   53389,  9, }, // America/Mexico_City
    {   87, 4391,   53398,  4, }, // America/Miquelon
    {   87, 8254,   53402,  4, }, // America/Moncton
    {   87, 8270,   53406,  3, }, // America/Monterrey
    {   87, 4098,   53409,  6, }, // America/Montevideo
    {   87, 5824,   53415,  6, }, // America/Montserrat
    {   87, 5481,   53421,  3, }, // America/Nassau
    {   87, 2379,   53424,  3, }, // America/New_York
    {   87, 8288,   53427,  2, }, // America/Nome
    {   87, 1850,   53429,  4, }, // America/Noronha
    {   87, 8301,   53433, 12, }, // America/North_Dakota/Beulah
    {   87, 8329,   53445, 12, }, // America/North_Dakota/Center
    {   87, 8357,   53457, 15, }, // America/North_Dakota/New_Salem
    {   87,  393,   53472,  2, }, // America/Nuuk
    {   87, 8388,   53474,  4, }, // America/Ojinaga
    {   87, 2356,   53478,  3, }, // America/Panama
    {   87, 6173,   53481,  5, }, // America/Paramaribo
    {   87, 2973,   53486,  6, }, // America/Phoenix
    {   87, 3945,   53492, 17, }, // America/Port-au-Prince
    {   87, 5954,   53509, 15, }, // America/Port_of_Spain
    {   87, 8404,   53524, 12, }, // America/Porto_Velho
    {   87, 5843,   53536,  7, }, // America/Puerto_Rico
    {   87, 4030,   53543,  7, }, // America/Punta_Arenas
    {   87, 8424,   53550,  9, }, // America/Rankin_Inlet
    {   87, 8445,   53559,  3, }, // America/Recife
    {   87, 1995,   53562,  3, }, // America/Regina
    {   87, 8460,   53565,  4, }, // America/Resolute
    {   87,  695,   53569,  7, }, // America/Rio_Branco
    {   87, 8477,   53576,  5, }, // America/Santarem
    {   87, 2201,   53581,  5, }, // America/Santiago
    {   87, 6111,   53586,  7, }, // America/Santo_Domingo
    {   87, 1878,   53593,  5, }, // America/Sao_Paulo
    {   87, 6899,   53598,  6, }, // America/Scoresbysund
    {   87, 8494,   53604,  3, }, // America/Sitka
    {   87, 8508,   53607, 10, }, // America/St_Barthelemy
    {   87, 2061,   53617, 11, }, // America/St_Johns
    {   87, 5863,   53628,  8, }, // America/St_Kitts
    {   87, 5880,   53636,  8, }, // America/St_Lucia
    {   87,  855,   53644,  8, }, // America/St_Thomas
    {   87, 5913,   53652,  9, }, // America/St_Vincent
    {   87, 8530,   53661,  8, }, // America/Swift_Current
    {   87, 5461,   53669,  6, }, // America/Tegucigalpa
    {   87, 5756,   53675,  2, }, // America/Thule
    {   87,  313,   53677,  4, }, // America/Tijuana
    {   87,  608,   53681,  4, }, // America/Toronto
    {   87, 5688,   53685,  3, }, // America/Tortola
    {   87, 2093,   53688,  5, }, // America/Vancouver
    {   87, 2144,   53693,  7, }, // America/Whitehorse
    {   87,  734,   53700,  4, }, // America/Winnipeg
    {   87, 8552,   53704,  4, }, // America/Yakutat
    {   87, 6001,   53038,  2, }, // Antarctica/Casey
    {   87, 6094,   53708,  3, }, // Antarctica/Davis
    {   87, 6133,   53711, 11, }, // Antarctica/DumontDUrville
    {   87, 8568,   53722,  3, }, // Antarctica/Macquarie
    {   87, 7066,   53725,  3, }, // Antarctica/Mawson
    {   87, 7113,   53728,  4, }, // Antarctica/McMurdo
    {   87, 8589,   53732,  4, }, // Antarctica/Palmer
    {   87, 7226,   53736,  3, }, // Antarctica/Rothera
    {   87, 7295,   53739,  3, }, // Antarctica/Syowa
    {   87, 8607,   53742,  2, }, // Antarctica/Troll
    {   87, 7374,   53744,  4, }, // Antarctica/Vostok
    {   87, 1429,   53748, 17, }, // Arctic/Longyearbyen
    {   87, 5570,   53765,  3, }, // Asia/Aden
    {   87, 5395,   53768,  4, }, // Asia/Almaty
    {   87, 3968,   53772,  3, }, // Asia/Amman
    {   87, 5511,   53775,  4, }, // Asia/Anadyr
    {   87, 5523,   53779,  4, }, // Asia/Aqtau
    {   87, 5368,   53783,  4, }, // Asia/Aqtobe
    {   87,  964,   53787,  5, }, // Asia/Ashgabat
    {   87, 8624,   53792,  4, }, // Asia/Atyrau
    {   87, 3607,   53796,  4, }, // Asia/Baghdad
    {   87, 5534,   53800,  5, }, // Asia/Bahrain
    {   87, 3653,   53079,  2, }, // Asia/Baku
    {   87, 4466,   53805,  5, }, // Asia/Bangkok
    {   87, 3571,   53810,  4, }, // Asia/Barnaul
    {   87, 4086,   53814,  3, }, // Asia/Beirut
    {   87, 3778,   53817,  4, }, // Asia/Bishkek
    {   87, 5989,   53821,  3, }, // Asia/Brunei
    {   87, 4601,   53824,  2, }, // Asia/Chita
    {   87, 4511,   53826,  4, }, // Asia/Colombo
    {   87, 4540,   53830,  5, }, // Asia/Damascus
    {   87, 1093,   52740,  2, }, // Asia/Dhaka
    {   87, 6192,   53777,  2, }, // Asia/Dili
    {   87, 3596,   53835,  3, }, // Asia/Dubai
    {   87, 6159,   53838,  4, }, // Asia/Dushanbe
    {   87, 8636,   53842,  5, }, // Asia/Famagusta
    {   87, 8651,   53847,  2, }, // Asia/Gaza
    {   87, 4795,   53849,  3, }, // Asia/Hebron
    {   87, 1259,   53852, 10, }, // Asia/Ho_Chi_Minh
    {   87, 2704,   53862,  7, }, // Asia/Hong_Kong
    {   87, 4771,   53869,  3, }, // Asia/Hovd
    {   87, 4184,   53872,  4, }, // Asia/Irkutsk
    {   87, 7006,   53876,  3, }, // Asia/Jakarta
    {   87, 6992,   53879,  4, }, // Asia/Jayapura
    {   87, 1290,   53883,  5, }, // Asia/Jerusalem
    {   87, 3560,   53888,  3, }, // Asia/Kabul
    {   87, 4316,   53891,  4, }, // Asia/Kamchatka
    {   87, 4239,   53895,  3, }, // Asia/Karachi
    {   87, 1185,   53898,  5, }, // Asia/Kathmandu
    {   87, 8661,   53903,  4, }, // Asia/Khandyga
    {   87,  992,   53907,  4, }, // Asia/Kolkata
    {   87, 4197,   53911,  6, }, // Asia/Krasnoyarsk
    {   87, 4859,   53917,  7, }, // Asia/Kuala_Lumpur
    {   87, 5976,   53924,  4, }, // Asia/Kuching
    {   87, 5547,   53928,  3, }, // Asia/Kuwait
    {   87, 1211,   53931,  3, }, // Asia/Macau
    {   87, 4017,   53934,  4, }, // Asia/Magadan
    {   87, 1349,   53938,  4, }, // Asia/Makassar
    {   87, 7182,   53942,  3, }, // Asia/Manila
    {   87, 6920,   53945,  4, }, // Asia/Muscat
    {   87, 2554,   53949,  4, }, // Asia/Nicosia
    {   87, 8675,   53953,  7, }, // Asia/Novokuznetsk
    {   87, 4135,   53960,  6, }, // Asia/Novosibirsk
    {   87, 4229,   53966,  4, }, // Asia/Omsk
    {   87, 7145,   53970,  3, }, // Asia/Oral
    {   87, 6961,   53973,  5, }, // Asia/Phnom_Penh
    {   87, 8693,   53978,  6, }, // Asia/Pontianak
    {   87, 4214,   53984,  7, }, // Asia/Pyongyang
    {   87, 5559,   53991,  3, }, // Asia/Qatar
    {   87, 8708,   53994,  4, }, // Asia/Qostanay
    {   87, 4269,   53998,  5, }, // Asia/Qyzylorda
    {   87, 3584,   54003,  3, }, // Asia/Riyadh
    {   87, 4408,   54006,  4, }, // Asia/Sakhalin
    {   87, 7245,   54010,  5, }, // Asia/Samarkand
    {   87, 3279,   54015,  2, }, // Asia/Seoul
    {   87, 1053,   54017,  5, }, // Asia/Shanghai
    {   87, 3300,   54022,  5, }, // Asia/Singapore
    {   87, 4297,   54027,  9, }, // Asia/Srednekolymsk
    {   87, 3263,   54036,  3, }, // Asia/Taipei
    {   87, 4781,   54039,  5, }, // Asia/Tashkent
    {   87, 3915,   54044,  4, }, // Asia/Tbilisi
    {   87, 2772,   54048,  3, }, // Asia/Tehran
    {   87, 1317,   54051,  3, }, // Asia/Thimphu
    {   87, 2821,   54054,  3, }, // Asia/Tokyo
    {   87, 4572,   54057,  4, }, // Asia/Tomsk
    {   87, 1021,   54061,  5, }, // Asia/Ulaanbaatar
    {   87, 1159,   54066,  4, }, // Asia/Urumqi
    {   87, 8722,   54070,  6, }, // Asia/Ust-Nera
    {   87, 6977,   54076,  6, }, // Asia/Vientiane
    {   87, 4710,   54082,  7, }, // Asia/Vladivostok
    {   87, 4828,   54089,  4, }, // Asia/Yakutsk
    {   87, 1235,   54093,  4, }, // Asia/Yangon
    {   87, 3883,   54097,  7, }, // Asia/Yekaterinburg
    {   87, 3747,   54104,  4, }, // Asia/Yerevan
    {   87, 3663,   54108,  4, }, // Atlantic/Azores
    {   87, 5671,   54112,  3, }, // Atlantic/Bermuda
    {   87, 6628,   54115,  3, }, // Atlantic/Canary
    {   87, 3727,   54118, 11, }, // Atlantic/Cape_Verde
    {   87, 1395,   54129,  2, }, // Atlantic/Faroe
    {   87, 8736,   54131,  3, }, // Atlantic/Madeira
    {   87, 2748,   54134,  4, }, // Atlantic/Reykjavik
    {   87, 7272,   54138,  9, }, // Atlantic/South_Georgia
    {   87, 6821,   54147,  8, }, // Atlantic/St_Helena
    {   87, 6644,   54155,  4, }, // Atlantic/Stanley
    {   87, 1670,   54159,  4, }, // Australia/Adelaide
    {   87, 1635,   54163,  4, }, // Australia/Brisbane
    {   87, 1799,   54167,  8, }, // Australia/Broken_Hill
    {   87, 1583,   54175,  3, }, // Australia/Darwin
    {   87, 3637,   54178,  2, }, // Australia/Eucla
    {   87, 1516,   54180,  3, }, // Australia/Hobart
    {   87, 8753,   54183,  5, }, // Australia/Lindeman
    {   87, 1547,   54188,  8, }, // Australia/Lord_Howe
    {   87, 1727,   54196,  4, }, // Australia/Melbourne
    {   87, 1762,   54200,  3, }, // Australia/Perth
    {   87, 1463,   54203,  3, }, // Australia/Sydney
    {   87, 6441,   54206,  6, }, // Europe/Amsterdam
    {   87, 6216,   54212,  4, }, // Europe/Andorra
    {   87, 3620,   54216,  4, }, // Europe/Astrakhan
    {   87, 2300,   54220,  4, }, // Europe/Athens
    {   87, 6336,   54224,  4, }, // Europe/Belgrade
    {   87, 4757,   54228,  3, }, // Europe/Berlin
    {   87, 6488,   54231,  5, }, // Europe/Bratislava
    {   87, 2167,   54236,  4, }, // Europe/Brussels
    {   87, 3928,   54240,  5, }, // Europe/Bucharest
    {   87, 3806,   54245,  5, }, // Europe/Budapest
    {   87, 8772,   54250,  5, }, // Europe/Busingen
    {   87, 2583,   54255,  4, }, // Europe/Chisinau
    {   87, 6289,   54259,  6, }, // Europe/Copenhagen
    {   87, 2338,   54265,  3, }, // Europe/Dublin
    {   87, 6307,   54268,  4, }, // Europe/Gibraltar
    {   87, 8788,   54272,  3, }, // Europe/Guernsey
    {   87, 6612,   54275,  5, }, // Europe/Helsinki
    {   87, 8804,   54280, 15, }, // Europe/Isle_of_Man
    {   87, 1130,   54295,  6, }, // Europe/Istanbul
    {   87, 8823,   54301,  3, }, // Europe/Jersey
    {   87, 3979,   54304,  5, }, // Europe/Kaliningrad
    {   87, 8929,   54309,  3, }, // Europe/Kirov
    {   87, 2527,   54312,  2, }, // Europe/Kyiv
    {   87, 3213,   54314,  4, }, // Europe/Lisbon
    {   87, 6506,   54318,  3, }, // Europe/Ljubljana
    {   87, 2501,   54321,  4, }, // Europe/London
    {   87, 6365,   54325,  5, }, // Europe/Luxembourg
    {   87, 4892,   54330,  3, }, // Europe/Madrid
    {   87, 6397,   54333,  3, }, // Europe/Malta
    {   87, 6582,   54336,  4, }, // Europe/Mariehamn
    {   87, 3693,   54340,  4, }, // Europe/Minsk
    {   87, 6410,   54344,  3, }, // Europe/Monaco
    {   87, 3537,   54347,  4, }, // Europe/Moscow
    {   87, 6458,   54351,  3, }, // Europe/Oslo
    {   87, 4284,   54354,  3, }, // Europe/Paris
    {   87, 6424,   54357,  4, }, // Europe/Podgorica
    {   87, 6275,   52830,  2, }, // Europe/Prague
    {   87, 8837,   53184,  2, }, // Europe/Riga
    {   87, 6324,   53827,  2, }, // Europe/Rome
    {   87, 4331,   54361,  3, }, // Europe/Samara
    {   87, 6470,   54364,  3, }, // Europe/San_Marino
    {   87, 6245,   54367,  4, }, // Europe/Sarajevo
    {   87, 4451,   54371,  4, }, // Europe/Saratov
    {   87, 8849,   54375,  6, }, // Europe/Simferopol
    {   87, 6383,   54381,  3, }, // Europe/Skopje
    {   87, 6599,   54384,  3, }, // Europe/Sofia
    {   87, 6523,   54387,  5, }, // Europe/Stockholm
    {   87, 8867,   54392,  3, }, // Europe/Tallinn
    {   87, 6202,   54395,  3, }, // Europe/Tirane
    {   87, 8882,   54398,  7, }, // Europe/Ulyanovsk
    {   87, 6352,   54405,  3, }, // Europe/Vaduz
    {   87, 6567,   54408,  5, }, // Europe/Vatican
    {   87, 6231,   54413,  3, }, // Europe/Vienna
    {   87, 8899,   54416,  5, }, // Europe/Vilnius
    {   87, 4727,   54421,  5, }, // Europe/Volgograd
    {   87, 3190,   54426,  8, }, // Europe/Warsaw
    {   87, 6261,   54434,  3, }, // Europe/Zagreb
    {   87, 6540,   54437,  3, }, // Europe/Zurich
    {   87, 5078,   54440,  7, }, // Indian/Antananarivo
    {   87, 6947,   54447,  3, }, // Indian/Chagos
    {   87, 6046,   54450,  7, }, // Indian/Christmas
    {   87, 6063,   54457,  3, }, // Indian/Cocos
    {   87, 5029,   54460,  3, }, // Indian/Comoro
    {   87, 6661,   54463,  6, }, // Indian/Kerguelen
    {   87, 7260,   54469,  2, }, // Indian/Mahe
    {   87, 7050,   54471,  5, }, // Indian/Maldives
    {   87, 4069,   54476,  5, }, // Indian/Mauritius
    {   87, 5098,   54481,  3, }, // Indian/Mayotte
    {   87, 7211,   54484,  5, }, // Indian/Reunion
    {   87, 4422,   54489,  3, }, // Pacific/Apia
    {   87,  932,   54492,  5, }, // Pacific/Auckland
    {   87, 3706,   54497,  5, }, // Pacific/Bougainville
    {   87, 3015,   54502,  3, }, // Pacific/Chatham
    {   87, 3157,   54505,  2, }, // Pacific/Chuuk
    {   87, 2237,   54507,  7, }, // Pacific/Easter
    {   87, 7360,   54514,  3, }, // Pacific/Efate
    {   87, 7327,   54517,  4, }, // Pacific/Fakaofo
    {   87, 3902,   54521,  2, }, // Pacific/Fiji
    {   87, 7343,   54523,  4, }, // Pacific/Funafuti
    {   87, 6678,   54527, 12, }, // Pacific/Galapagos
    {   87, 6696,   54539,  4, }, // Pacific/Gambier
    {   87, 3822,   54543,  6, }, // Pacific/Guadalcanal
    {   87, 6018,   54549,  2, }, // Pacific/Guam
    {   87, 2723,   54551,  4, }, // Pacific/Honolulu
    {   87, 3049,   54555,  4, }, // Pacific/Kanton
    {   87, 3998,   54559,  5, }, // Pacific/Kiritimati
    {   87, 7019,   54564,  3, }, // Pacific/Kosrae
    {   87, 2842,   54567,  5, }, // Pacific/Kwajalein
    {   87, 4877,   54572,  3, }, // Pacific/Majuro
    {   87, 4051,   54575,  5, }, // Pacific/Marquesas
    {   87, 8914,   54580,  5, }, // Pacific/Midway
    {   87, 7084,   54585,  3, }, // Pacific/Nauru
    {   87, 7132,   54177,  2, }, // Pacific/Niue
    {   87, 4168,   54588,  5, }, // Pacific/Norfolk
    {   87, 7098,   54593,  4, }, // Pacific/Noumea
    {   87, 3126,   54597,  5, }, // Pacific/Pago_Pago
    {   87, 7155,   54602,  4, }, // Pacific/Palau
    {   87, 7194,   54606,  5, }, // Pacific/Pitcairn
    {   87, 3096,   54611,  3, }, // Pacific/Pohnpei
    {   87, 4807,   54614, 13, }, // Pacific/Port_Moresby
    {   87, 6076,   54627,  5, }, // Pacific/Rarotonga
    {   87, 6031,   54632,  4, }, // Pacific/Saipan
    {   87, 7312,   54636,  3, }, // Pacific/Tahiti
    {   87, 6712,   54639,  3, }, // Pacific/Tarawa
    {   87, 4583,   54642,  5, }, // Pacific/Tongatapu
    {   87, 7392,   54647,  3, }, // Pacific/Wake
    {   87, 7405,   54650,  3, }, // Pacific/Wallis
    {   88,   14,       0,  6, }, // Africa/Asmara Chickasaw/Latin/United States
    {   88, 4435,       6,  8, }, // Africa/Sao_Tome
    {   88, 4252,      14,  8, }, // America/Asuncion
    {   88,  237,      22,  8, }, // America/Atikokan
    {   88, 7623,      30, 17, }, // America/Bahia_Banderas
    {   88, 3868,      47,  6, }, // America/Cancun
    {   88, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   88, 5723,      66,  7, }, // America/Curacao
    {   88,  481,      73, 13, }, // America/Indiana/Knox
    {   88, 7961,      86, 16, }, // America/Indiana/Marengo
    {   88, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   88, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   88, 8038,     139, 14, }, // America/Indiana/Vevay
    {   88, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   88, 8086,     171, 16, }, // America/Indiana/Winamac
    {   88, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   88, 5932,     207, 22, }, // America/Lower_Princes
    {   88, 8220,     229,  6, }, // America/Merida
    {   88, 1850,     235, 19, }, // America/Noronha
    {   88, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   88, 8329,     274, 20, }, // America/North_Dakota/Center
    {   88, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   88,  393,     317,  4, }, // America/Nuuk
    {   88, 6899,     321, 16, }, // America/Scoresbysund
    {   88, 8508,     337, 14, }, // America/St_Barthelemy
    {   88, 2061,     351, 10, }, // America/St_Johns
    {   88, 5863,     361,  9, }, // America/St_Kitts
    {   88, 5880,     370,  9, }, // America/St_Lucia
    {   88,  855,     379, 10, }, // America/St_Thomas
    {   88, 5913,     389, 11, }, // America/St_Vincent
    {   88, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   88, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   88, 1185,     448,  9, }, // Asia/Kathmandu
    {   88,  992,     457,  7, }, // Asia/Kolkata
    {   88, 1211,     464,  5, }, // Asia/Macau
    {   88, 1235,     477,  6, }, // Asia/Yangon
    {   88, 1395,     483,  5, }, // Atlantic/Faroe
    {   88, 6821,     488, 10, }, // Atlantic/St_Helena
    {   88, 2527,     514,  4, }, // Europe/Kyiv
    {   88, 7211,     547,  7, }, // Indian/Reunion
    {   88, 3157,     554,  5, }, // Pacific/Chuuk
    {   88, 3096,     586,  7, }, // Pacific/Pohnpei
    {   89,   14,       0,  6, }, // Africa/Asmara Chiga/Latin/Uganda
    {   89, 4435,       6,  8, }, // Africa/Sao_Tome
    {   89, 4252,      14,  8, }, // America/Asuncion
    {   89,  237,      22,  8, }, // America/Atikokan
    {   89, 7623,      30, 17, }, // America/Bahia_Banderas
    {   89, 3868,      47,  6, }, // America/Cancun
    {   89, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   89, 5723,      66,  7, }, // America/Curacao
    {   89,  481,      73, 13, }, // America/Indiana/Knox
    {   89, 7961,      86, 16, }, // America/Indiana/Marengo
    {   89, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   89, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   89, 8038,     139, 14, }, // America/Indiana/Vevay
    {   89, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   89, 8086,     171, 16, }, // America/Indiana/Winamac
    {   89, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   89, 5932,     207, 22, }, // America/Lower_Princes
    {   89, 8220,     229,  6, }, // America/Merida
    {   89, 1850,     235, 19, }, // America/Noronha
    {   89, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {   89, 8329,     274, 20, }, // America/North_Dakota/Center
    {   89, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {   89,  393,     317,  4, }, // America/Nuuk
    {   89, 6899,     321, 16, }, // America/Scoresbysund
    {   89, 8508,     337, 14, }, // America/St_Barthelemy
    {   89, 2061,     351, 10, }, // America/St_Johns
    {   89, 5863,     361,  9, }, // America/St_Kitts
    {   89, 5880,     370,  9, }, // America/St_Lucia
    {   89,  855,     379, 10, }, // America/St_Thomas
    {   89, 5913,     389, 11, }, // America/St_Vincent
    {   89, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {   89, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {   89, 1185,     448,  9, }, // Asia/Kathmandu
    {   89,  992,     457,  7, }, // Asia/Kolkata
    {   89, 1211,     464,  5, }, // Asia/Macau
    {   89, 1235,     477,  6, }, // Asia/Yangon
    {   89, 1395,     483,  5, }, // Atlantic/Faroe
    {   89, 6821,     488, 10, }, // Atlantic/St_Helena
    {   89, 2527,     514,  4, }, // Europe/Kyiv
    {   89, 7211,     547,  7, }, // Indian/Reunion
    {   89, 3157,     554,  5, }, // Pacific/Chuuk
    {   89, 3096,     586,  7, }, // Pacific/Pohnpei
    {   90, 6788,   43081,  3, }, // Africa/Abidjan Chinese/Simplified Han/China
    {   90, 6760,   41570,  3, }, // Africa/Accra
    {   90, 5059,   54653,  6, }, // Africa/Addis_Ababa
    {   90, 7420,   43090,  4, }, // Africa/Algiers
    {   90,   14,   54659,  4, }, // Africa/Asmara
    {   90,   44,   43098,  3, }, // Africa/Bamako
    {   90, 5257,   41590,  2, }, // Africa/Bangui
    {   90, 6746,   54663,  3, }, // Africa/Banjul
    {   90, 7435,   43101,  2, }, // Africa/Bissau
    {   90, 4957,   43103,  4, }, // Africa/Blantyre
    {   90, 5287,   43107,  5, }, // Africa/Brazzaville
    {   90, 4922,   54666,  4, }, // Africa/Bujumbura
    {   90, 2320,   43112,  2, }, // Africa/Cairo
    {   90, 4117,   43114,  5, }, // Africa/Casablanca
    {   90, 7449,   43119,  2, }, // Africa/Ceuta
    {   90, 6773,   54670,  4, }, // Africa/Conakry
    {   90, 6840,   43121,  3, }, // Africa/Dakar
    {   90, 5130,   54674,  6, }, // Africa/Dar_es_Salaam
    {   90, 5043,   54680,  3, }, // Africa/Djibouti
    {   90, 5243,   41631,  3, }, // Africa/Douala
    {   90, 5166,   41634,  3, }, // Africa/El_Aaiun
    {   90, 6853,   54683,  3, }, // Africa/Freetown
    {   90, 4906,   54686,  4, }, // Africa/Gaborone
    {   90, 5015,   41644,  3, }, // Africa/Harare
    {   90, 4479,   54690,  5, }, // Africa/Johannesburg
    {   90, 4499,   41652,  2, }, // Africa/Juba
    {   90, 5151,   41654,  3, }, // Africa/Kampala
    {   90, 4524,   41657,  3, }, // Africa/Khartoum
    {   90, 4973,   41660,  3, }, // Africa/Kigali
    {   90, 5306,   54695,  3, }, // Africa/Kinshasa
    {   90, 4744,   54698,  3, }, // Africa/Lagos
    {   90, 5336,   54701,  4, }, // Africa/Libreville
    {   90, 6869,   41672,  2, }, // Africa/Lome
    {   90, 5211,   43132,  3, }, // Africa/Luanda
    {   90, 4939,   43135,  4, }, // Africa/Lubumbashi
    {   90, 5001,   54705,  3, }, // Africa/Lusaka
    {   90, 5322,   43139,  3, }, // Africa/Malabo
    {   90, 4987,   43142,  3, }, // Africa/Maputo
    {   90, 5197,   54708,  3, }, // Africa/Maseru
    {   90, 5182,   54711,  4, }, // Africa/Mbabane
    {   90, 5113,   54715,  4, }, // Africa/Mogadishu
    {   90, 7034,   43148,  4, }, // Africa/Monrovia
    {   90, 3853,   54719,  3, }, // Africa/Nairobi
    {   90, 5271,   43152,  4, }, // Africa/Ndjamena
    {   90, 5354,   43156,  3, }, // Africa/Niamey
    {   90, 6803,   54722,  5, }, // Africa/Nouakchott
    {   90, 6727,   41717,  4, }, // Africa/Ouagadougou
    {   90, 5225,   54727,  4, }, // Africa/Porto-Novo
    {   90, 4435,   43166,  3, }, // Africa/Sao_Tome
    {   90, 2866,   41728,  4, }, // Africa/Tripoli
    {   90, 6554,   41732,  3, }, // Africa/Tunis
    {   90, 4152,   43169,  4, }, // Africa/Windhoek
    {   90,  132,   54731,  3, }, // America/Adak
    {   90, 3346,   54734,  4, }, // America/Anchorage
    {   90, 5607,   54738,  3, }, // America/Anguilla
    {   90, 5624,   54741,  3, }, // America/Antigua
    {   90, 4554,   54744,  5, }, // America/Araguaina
    {   90,  166,   43176,  7, }, // America/Argentina/Buenos_Aires
    {   90,   91,   43183,  4, }, // America/Argentina/Catamarca
    {   90,  270,   54749,  4, }, // America/Argentina/Cordoba
    {   90,  441,   41770,  3, }, // America/Argentina/Jujuy
    {   90, 7462,   54753,  4, }, // America/Argentina/La_Rioja
    {   90,  565,   43190,  3, }, // America/Argentina/Mendoza
    {   90, 7489,   43193,  6, }, // America/Argentina/Rio_Gallegos
    {   90, 7520,   43199,  3, }, // America/Argentina/Salta
    {   90, 7544,   43202,  3, }, // America/Argentina/San_Juan
    {   90, 5580,   54757,  4, }, // America/Argentina/San_Luis
    {   90, 7571,   54761,  3, }, // America/Argentina/Tucuman
    {   90, 7597,   43211,  4, }, // America/Argentina/Ushuaia
    {   90, 5640,   54764,  3, }, // America/Aruba
    {   90, 4252,   43215,  3, }, // America/Asuncion
    {   90,  237,   41807,  4, }, // America/Atikokan
    {   90, 3679,   43218,  3, }, // America/Bahia
    {   90, 7623,   43218,  7, }, // America/Bahia_Banderas
    {   90, 5654,   54767,  4, }, // America/Barbados
    {   90, 7646,   43228,  2, }, // America/Belem
    {   90, 5407,   54771,  3, }, // America/Belize
    {   90, 7660,   54774,  6, }, // America/Blanc-Sablon
    {   90, 7681,   54780,  5, }, // America/Boa_Vista
    {   90, 4361,   41838,  3, }, // America/Bogota
    {   90, 7699,   54785,  3, }, // America/Boise
    {   90, 7713,   43242,  3, }, // America/Cambridge_Bay
    {   90, 7735,   54788,  3, }, // America/Campo_Grande
    {   90, 3868,   41849,  2, }, // America/Cancun
    {   90, 4694,   54791,  4, }, // America/Caracas
    {   90, 4345,   54795,  2, }, // America/Cayenne
    {   90, 5496,   43250,  2, }, // America/Cayman
    {   90, 2260,   41861,  3, }, // America/Chicago
    {   90, 7756,   54797,  3, }, // America/Chihuahua
    {   90, 7774,   43257,  4, }, // America/Ciudad_Juarez
    {   90, 5422,   54800,  5, }, // America/Costa_Rica
    {   90, 7796,   43261,  4, }, // America/Creston
    {   90, 3791,   54805,  3, }, // America/Cuiaba
    {   90, 5723,   43265,  3, }, // America/Curacao
    {   90, 7812,   43268,  4, }, // America/Danmarkshavn
    {   90, 7833,   41890,  2, }, // America/Dawson
    {   90, 7848,   41892,  5, }, // America/Dawson_Creek
    {   90,  805,   41897,  2, }, // America/Denver
    {   90, 3465,   41899,  3, }, // America/Detroit
    {   90, 5739,   54808,  4, }, // America/Dominica
    {   90,  893,   54812,  4, }, // America/Edmonton
    {   90, 7869,   54816,  4, }, // America/Eirunepe
    {   90, 5441,   43276,  4, }, // America/El_Salvador
    {   90, 7886,   43280,  4, }, // America/Fort_Nelson
    {   90, 7906,   54820,  4, }, // America/Fortaleza
    {   90, 7924,   54824,  4, }, // America/Glace_Bay
    {   90, 6881,   54828,  3, }, // America/Goose_Bay
    {   90, 4612,   41932,  3, }, // America/Grand_Turk
    {   90, 5770,   54831,  4, }, // America/Grenada
    {   90, 5786,   54835,  4, }, // America/Guadeloupe
    {   90, 3760,   54839,  4, }, // America/Guatemala
    {   90, 4841,   43302,  4, }, // America/Guayaquil
    {   90, 6932,   54843,  3, }, // America/Guyana
    {   90, 1939,   54846,  5, }, // America/Halifax
    {   90, 2281,   41960,  3, }, // America/Havana
    {   90, 7942,   43309,  4, }, // America/Hermosillo
    {   90,  348,   54851,  7, }, // America/Indiana/Indianapolis
    {   90,  481,   54858,  8, }, // America/Indiana/Knox
    {   90, 7961,   54866,  8, }, // America/Indiana/Marengo
    {   90, 7985,   54874,  9, }, // America/Indiana/Petersburg
    {   90, 8012,   54883,  8, }, // America/Indiana/Tell_City
    {   90, 8038,   54891,  8, }, // America/Indiana/Vevay
    {   90, 8060,   54899,  8, }, // America/Indiana/Vincennes
    {   90, 8086,   54907,  9, }, // America/Indiana/Winamac
    {   90, 8110,   54916,  4, }, // America/Inuvik
    {   90,  660,   42034,  3, }, // America/Iqaluit
    {   90, 2799,   43365,  3, }, // America/Jamaica
    {   90, 5380,   43368,  2, }, // America/Juneau
    {   90,  521,   43370,  5, }, // America/Kentucky/Louisville
    {   90, 8125,   54920,  8, }, // America/Kentucky/Monticello
    {   90, 5704,   43383,  5, }, // America/Kralendijk
    {   90, 4376,   42060,  3, }, // America/La_Paz
    {   90, 7169,   43388,  2, }, // America/Lima
    {   90, 3239,   43390,  3, }, // America/Los_Angeles
    {   90, 5932,   43393,  4, }, // America/Lower_Princes
    {   90, 8153,   54928,  3, }, // America/Maceio
    {   90, 8168,   54931,  3, }, // America/Managua
    {   90, 1908,   54934,  3, }, // America/Manaus
    {   90, 5897,   43406,  4, }, // America/Marigot
    {   90, 5805,   54937,  4, }, // America/Martinique
    {   90, 8184,   43414,  5, }, // America/Matamoros
    {   90, 2917,   43419,  4, }, // America/Mazatlan
    {   90, 8202,   54941,  4, }, // America/Menominee
    {   90, 8220,   43427,  3, }, // America/Merida
    {   90, 8235,   42105,  6, }, // America/Metlakatla
    {   90, 2949,   54945,  4, }, // America/Mexico_City
    {   90, 4391,   54949,  3, }, // America/Miquelon
    {   90, 8254,   43433,  3, }, // America/Moncton
    {   90, 8270,   54952,  3, }, // America/Monterrey
    {   90, 4098,   54955,  5, }, // America/Montevideo
    {   90, 5824,   54960,  5, }, // America/Montserrat
    {   90, 5481,   54965,  2, }, // America/Nassau
    {   90, 2379,   43443,  2, }, // America/New_York
    {   90, 8288,   43445,  2, }, // America/Nome
    {   90, 1850,   54967,  4, }, // America/Noronha
    {   90, 8301,   54971,  8, }, // America/North_Dakota/Beulah
    {   90, 8329,   54979,  7, }, // America/North_Dakota/Center
    {   90, 8357,   54986,  9, }, // America/North_Dakota/New_Salem
    {   90,  393,   42163,  2, }, // America/Nuuk
    {   90, 8388,   43473,  4, }, // America/Ojinaga
    {   90, 2356,   43477,  3, }, // America/Panama
    {   90, 6173,   54995,  5, }, // America/Paramaribo
    {   90, 2973,   43485,  3, }, // America/Phoenix
    {   90, 3945,   42180,  3, }, // America/Port-au-Prince
    {   90, 5954,   42183,  4, }, // America/Port_of_Spain
    {   90, 8404,   55000,  4, }, // America/Porto_Velho
    {   90, 5843,   42190,  4, }, // America/Puerto_Rico
    {   90, 4030,   43491,  6, }, // America/Punta_Arenas
    {   90, 8424,   43497,  3, }, // America/Rankin_Inlet
    {   90, 8445,   55004,  3, }, // America/Recife
    {   90, 1995,   43500,  3, }, // America/Regina
    {   90, 8460,   55007,  4, }, // America/Resolute
    {   90,  695,   55011,  5, }, // America/Rio_Branco
    {   90, 8477,   43511,  3, }, // America/Santarem
    {   90, 2201,   55016,  4, }, // America/Santiago
    {   90, 6111,   55020,  4, }, // America/Santo_Domingo
    {   90, 1878,   43522,  3, }, // America/Sao_Paulo
    {   90, 6899,   55024,  7, }, // America/Scoresbysund
    {   90, 8494,   43532,  3, }, // America/Sitka
    {   90, 8508,   55031,  6, }, // America/St_Barthelemy
    {   90, 2061,   55037,  4, }, // America/St_Johns
    {   90, 5863,   43544,  3, }, // America/St_Kitts
    {   90, 5880,   55041,  4, }, // America/St_Lucia
    {   90,  855,   43551,  4, }, // America/St_Thomas
    {   90, 5913,   55045,  4, }, // America/St_Vincent
    {   90, 8530,   43558,  7, }, // America/Swift_Current
    {   90, 5461,   55049,  6, }, // America/Tegucigalpa
    {   90, 5756,   55055,  2, }, // America/Thule
    {   90,  313,   55057,  3, }, // America/Tijuana
    {   90,  608,   43568,  3, }, // America/Toronto
    {   90, 5688,   43571,  4, }, // America/Tortola
    {   90, 2093,   43575,  3, }, // America/Vancouver
    {   90, 2144,   43578,  4, }, // America/Whitehorse
    {   90,  734,   43582,  3, }, // America/Winnipeg
    {   90, 8552,   55060,  4, }, // America/Yakutat
    {   90, 6001,   55064,  2, }, // Antarctica/Casey
    {   90, 6094,   43590,  3, }, // Antarctica/Davis
    {   90, 6133,   55066,  6, }, // Antarctica/DumontDUrville
    {   90, 8568,   55072,  3, }, // Antarctica/Macquarie
    {   90, 7066,   42314,  2, }, // Antarctica/Mawson
    {   90, 7113,   43601,  4, }, // Antarctica/McMurdo
    {   90, 8589,   55075,  3, }, // Antarctica/Palmer
    {   90, 7226,   43607,  3, }, // Antarctica/Rothera
    {   90, 7295,   42325,  2, }, // Antarctica/Syowa
    {   90, 8607,   55078,  3, }, // Antarctica/Troll
    {   90, 7374,   42331,  4, }, // Antarctica/Vostok
    {   90, 1429,   55081,  4, }, // Arctic/Longyearbyen
    {   90, 5570,   43612,  2, }, // Asia/Aden
    {   90, 5395,   43614,  4, }, // Asia/Almaty
    {   90, 3968,   42346,  2, }, // Asia/Amman
    {   90, 5511,   55085,  4, }, // Asia/Anadyr
    {   90, 5523,   42351,  3, }, // Asia/Aqtau
    {   90, 5368,   55089,  4, }, // Asia/Aqtobe
    {   90,  964,   55093,  5, }, // Asia/Ashgabat
    {   90, 8624,   43618,  3, }, // Asia/Atyrau
    {   90, 3607,   43621,  3, }, // Asia/Baghdad
    {   90, 5534,   42369,  2, }, // Asia/Bahrain
    {   90, 3653,   43624,  2, }, // Asia/Baku
    {   90, 4466,   42371,  2, }, // Asia/Bangkok
    {   90, 3571,   43626,  4, }, // Asia/Barnaul
    {   90, 4086,   43630,  3, }, // Asia/Beirut
    {   90, 3778,   43633,  4, }, // Asia/Bishkek
    {   90, 5989,   55098,  2, }, // Asia/Brunei
    {   90, 4601,   42386,  2, }, // Asia/Chita
    {   90, 4511,   55100,  3, }, // Asia/Colombo
    {   90, 4540,   43642,  4, }, // Asia/Damascus
    {   90, 1093,   43646,  2, }, // Asia/Dhaka
    {   90, 6192,   42397,  2, }, // Asia/Dili
    {   90, 3596,   55103,  2, }, // Asia/Dubai
    {   90, 6159,   55105,  3, }, // Asia/Dushanbe
    {   90, 8636,   43651,  5, }, // Asia/Famagusta
    {   90, 8651,   55108,  2, }, // Asia/Gaza
    {   90, 4795,   55110,  3, }, // Asia/Hebron
    {   90, 1259,   42414,  4, }, // Asia/Ho_Chi_Minh
    {   90, 2704,   42425,  2, }, // Asia/Hong_Kong
    {   90, 4771,   42432,  3, }, // Asia/Hovd
    {   90, 4184,   55113,  5, }, // Asia/Irkutsk
    {   90, 7006,   43677,  3, }, // Asia/Jakarta
    {   90, 6992,   55118,  4, }, // Asia/Jayapura
    {   90, 1290,   42447,  4, }, // Asia/Jerusalem
    {   90, 3560,   43684,  3, }, // Asia/Kabul
    {   90, 4316,   42454,  3, }, // Asia/Kamchatka
    {   90, 4239,   55122,  3, }, // Asia/Karachi
    {   90, 1185,   43687,  4, }, // Asia/Kathmandu
    {   90, 8661,   55125,  3, }, // Asia/Khandyga
    {   90,  992,   43691,  4, }, // Asia/Kolkata
    {   90, 4197,   43695,  8, }, // Asia/Krasnoyarsk
    {   90, 4859,   42479,  3, }, // Asia/Kuala_Lumpur
    {   90, 5976,   43703,  2, }, // Asia/Kuching
    {   90, 5547,   42484,  3, }, // Asia/Kuwait
    {   90, 1211,   43712,  2, }, // Asia/Macau
    {   90, 4017,   43719,  3, }, // Asia/Magadan
    {   90, 1349,   55128,  3, }, // Asia/Makassar
    {   90, 7182,   43726,  3, }, // Asia/Manila
    {   90, 6920,   55131,  4, }, // Asia/Muscat
    {   90, 2554,   55135,  4, }, // Asia/Nicosia
    {   90, 8675,   43737,  6, }, // Asia/Novokuznetsk
    {   90, 4135,   43743,  5, }, // Asia/Novosibirsk
    {   90, 4229,   42530,  4, }, // Asia/Omsk
    {   90, 7145,   43748,  3, }, // Asia/Oral
    {   90, 6961,   43751,  2, }, // Asia/Phnom_Penh
    {   90, 8693,   42539,  2, }, // Asia/Pontianak
    {   90, 4214,   42541,  2, }, // Asia/Pyongyang
    {   90, 5559,   55139,  3, }, // Asia/Qatar
    {   90, 8708,   55142,  4, }, // Asia/Qostanay
    {   90, 4269,   55146,  5, }, // Asia/Qyzylorda
    {   90, 3584,   55151,  3, }, // Asia/Riyadh
    {   90, 4408,   55154,  3, }, // Asia/Sakhalin
    {   90, 7245,   43764,  4, }, // Asia/Samarkand
    {   90, 3279,   43768,  2, }, // Asia/Seoul
    {   90, 1053,   42567,  2, }, // Asia/Shanghai
    {   90, 3300,   42569,  3, }, // Asia/Singapore
    {   90, 4297,   42572,  6, }, // Asia/Srednekolymsk
    {   90, 3263,   42578,  2, }, // Asia/Taipei
    {   90, 4781,   42580,  3, }, // Asia/Tashkent
    {   90, 3915,   42583,  4, }, // Asia/Tbilisi
    {   90, 2772,   43770,  3, }, // Asia/Tehran
    {   90, 1317,   42590,  2, }, // Asia/Thimphu
    {   90, 2821,   43773,  2, }, // Asia/Tokyo
    {   90, 4572,   42594,  4, }, // Asia/Tomsk
    {   90, 1021,   43775,  4, }, // Asia/Ulaanbaatar
    {   90, 1159,   43779,  4, }, // Asia/Urumqi
    {   90, 8722,   43783,  4, }, // Asia/Ust-Nera
    {   90, 6977,   55157,  2, }, // Asia/Vientiane
    {   90, 4710,   55159,  7, }, // Asia/Vladivostok
    {   90, 4828,   55166,  4, }, // Asia/Yakutsk
    {   90, 1235,   42619,  2, }, // Asia/Yangon
    {   90, 3883,   55170,  5, }, // Asia/Yekaterinburg
    {   90, 3747,   55175,  3, }, // Asia/Yerevan
    {   90, 3663,   43802,  5, }, // Atlantic/Azores
    {   90, 5671,   55178,  3, }, // Atlantic/Bermuda
    {   90, 6628,   55181,  3, }, // Atlantic/Canary
    {   90, 3727,   55184,  3, }, // Atlantic/Cape_Verde
    {   90, 1395,   43816,  2, }, // Atlantic/Faroe
    {   90, 8736,   55187,  3, }, // Atlantic/Madeira
    {   90, 2748,   55190,  5, }, // Atlantic/Reykjavik
    {   90, 7272,   43830,  4, }, // Atlantic/South_Georgia
    {   90, 6821,   43834,  4, }, // Atlantic/St_Helena
    {   90, 6644,   55195,  3, }, // Atlantic/Stanley
    {   90, 1670,   55198,  4, }, // Australia/Adelaide
    {   90, 1635,   55202,  4, }, // Australia/Brisbane
    {   90, 1799,   43839,  5, }, // Australia/Broken_Hill
    {   90, 1583,   43844,  3, }, // Australia/Darwin
    {   90, 3637,   42685,  3, }, // Australia/Eucla
    {   90, 1516,   55206,  3, }, // Australia/Hobart
    {   90, 8753,   42691,  3, }, // Australia/Lindeman
    {   90, 1547,   43847,  4, }, // Australia/Lord_Howe
    {   90, 1727,   43851,  3, }, // Australia/Melbourne
    {   90, 1762,   55209,  2, }, // Australia/Perth
    {   90, 1463,   55211,  2, }, // Australia/Sydney
    {   90, 6441,   42705,  5, }, // Europe/Amsterdam
    {   90, 6216,   43854,  3, }, // Europe/Andorra
    {   90, 3620,   42713,  5, }, // Europe/Astrakhan
    {   90, 2300,   42718,  2, }, // Europe/Athens
    {   90, 6336,   55213,  5, }, // Europe/Belgrade
    {   90, 4757,   42724,  2, }, // Europe/Berlin
    {   90, 6488,   55218,  6, }, // Europe/Bratislava
    {   90, 2167,   43861,  4, }, // Europe/Brussels
    {   90, 3928,   42736,  5, }, // Europe/Bucharest
    {   90, 3806,   43865,  4, }, // Europe/Budapest
    {   90, 8772,   42745,  3, }, // Europe/Busingen
    {   90, 2583,   55224,  4, }, // Europe/Chisinau
    {   90, 6289,   42751,  4, }, // Europe/Copenhagen
    {   90, 2338,   42755,  3, }, // Europe/Dublin
    {   90, 6307,   43869,  4, }, // Europe/Gibraltar
    {   90, 8788,   55228,  3, }, // Europe/Guernsey
    {   90, 6612,   43876,  4, }, // Europe/Helsinki
    {   90, 8804,   55231,  3, }, // Europe/Isle_of_Man
    {   90, 1130,   55234,  5, }, // Europe/Istanbul
    {   90, 8823,   43882,  3, }, // Europe/Jersey
    {   90, 3979,   43885,  5, }, // Europe/Kaliningrad
    {   90, 8929,   42783,  3, }, // Europe/Kirov
    {   90, 2527,   43890,  2, }, // Europe/Kyiv
    {   90, 3213,   42788,  3, }, // Europe/Lisbon
    {   90, 6506,   55239,  5, }, // Europe/Ljubljana
    {   90, 2501,   43896,  2, }, // Europe/London
    {   90, 6365,   43898,  3, }, // Europe/Luxembourg
    {   90, 4892,   43901,  3, }, // Europe/Madrid
    {   90, 6397,   55244,  3, }, // Europe/Malta
    {   90, 6582,   43907,  3, }, // Europe/Mariehamn
    {   90, 3693,   42809,  3, }, // Europe/Minsk
    {   90, 6410,   43910,  3, }, // Europe/Monaco
    {   90, 3537,   42815,  3, }, // Europe/Moscow
    {   90, 6458,   43913,  3, }, // Europe/Oslo
    {   90, 4284,   42821,  2, }, // Europe/Paris
    {   90, 6424,   55247,  5, }, // Europe/Podgorica
    {   90, 6275,   42827,  3, }, // Europe/Prague
    {   90, 8837,   42830,  2, }, // Europe/Riga
    {   90, 6324,   43916,  2, }, // Europe/Rome
    {   90, 4331,   55252,  3, }, // Europe/Samara
    {   90, 6470,   55255,  4, }, // Europe/San_Marino
    {   90, 6245,   55259,  4, }, // Europe/Sarajevo
    {   90, 4451,   43925,  4, }, // Europe/Saratov
    {   90, 8849,   55263,  5, }, // Europe/Simferopol
    {   90, 6383,   55268,  4, }, // Europe/Skopje
    {   90, 6599,   55272,  3, }, // Europe/Sofia
    {   90, 6523,   43932,  5, }, // Europe/Stockholm
    {   90, 8867,   42865,  2, }, // Europe/Tallinn
    {   90, 6202,   42867,  3, }, // Europe/Tirane
    {   90, 8882,   43937,  7, }, // Europe/Ulyanovsk
    {   90, 6352,   55275,  3, }, // Europe/Vaduz
    {   90, 6567,   43947,  3, }, // Europe/Vatican
    {   90, 6231,   43950,  3, }, // Europe/Vienna
    {   90, 8899,   43953,  4, }, // Europe/Vilnius
    {   90, 4727,   43957,  5, }, // Europe/Volgograd
    {   90, 3190,   43962,  2, }, // Europe/Warsaw
    {   90, 6261,   55278,  4, }, // Europe/Zagreb
    {   90, 6540,   43964,  3, }, // Europe/Zurich
    {   90, 5078,   42904,  6, }, // Indian/Antananarivo
    {   90, 6947,   42910,  3, }, // Indian/Chagos
    {   90, 6046,   43967,  3, }, // Indian/Christmas
    {   90, 6063,   55282,  3, }, // Indian/Cocos
    {   90, 5029,   43975,  3, }, // Indian/Comoro
    {   90, 6661,   43980,  4, }, // Indian/Kerguelen
    {   90, 7260,   43985,  3, }, // Indian/Mahe
    {   90, 7050,   55285,  4, }, // Indian/Maldives
    {   90, 4069,   55289,  4, }, // Indian/Mauritius
    {   90, 5098,   43992,  3, }, // Indian/Mayotte
    {   90, 7211,   55293,  3, }, // Indian/Reunion
    {   90, 4422,   44000,  3, }, // Pacific/Apia
    {   90,  932,   44003,  3, }, // Pacific/Auckland
    {   90, 3706,   44006,  4, }, // Pacific/Bougainville
    {   90, 3015,   55296,  3, }, // Pacific/Chatham
    {   90, 3157,   55299,  5, }, // Pacific/Chuuk
    {   90, 2237,   55304,  4, }, // Pacific/Easter
    {   90, 7360,   42967,  3, }, // Pacific/Efate
    {   90, 7327,   42970,  3, }, // Pacific/Fakaofo
    {   90, 3902,   44013,  2, }, // Pacific/Fiji
    {   90, 7343,   55308,  4, }, // Pacific/Funafuti
    {   90, 6678,   55312,  4, }, // Pacific/Galapagos
    {   90, 6696,   44021,  3, }, // Pacific/Gambier
    {   90, 3822,   55316,  6, }, // Pacific/Guadalcanal
    {   90, 6018,   44032,  2, }, // Pacific/Guam
    {   90, 2723,   42998,  3, }, // Pacific/Honolulu
    {   90, 3049,   55322,  4, }, // Pacific/Kanton
    {   90, 3998,   44039,  6, }, // Pacific/Kiritimati
    {   90, 7019,   55326,  3, }, // Pacific/Kosrae
    {   90, 2842,   55329,  3, }, // Pacific/Kwajalein
    {   90, 4877,   55332,  3, }, // Pacific/Majuro
    {   90, 4051,   55335,  4, }, // Pacific/Marquesas
    {   90, 8914,   44057,  3, }, // Pacific/Midway
    {   90, 7084,   55339,  2, }, // Pacific/Nauru
    {   90, 7132,   44062,  2, }, // Pacific/Niue
    {   90, 4168,   44065,  3, }, // Pacific/Norfolk
    {   90, 7098,   55341,  3, }, // Pacific/Noumea
    {   90, 3126,   55344,  4, }, // Pacific/Pago_Pago
    {   90, 7155,   55348,  2, }, // Pacific/Palau
    {   90, 7194,   55350,  4, }, // Pacific/Pitcairn
    {   90, 3096,   55354,  4, }, // Pacific/Pohnpei
    {   90, 4807,   55358,  5, }, // Pacific/Port_Moresby
    {   90, 6076,   44079,  4, }, // Pacific/Rarotonga
    {   90, 6031,   43063,  2, }, // Pacific/Saipan
    {   90, 7312,   55363,  3, }, // Pacific/Tahiti
    {   90, 6712,   43068,  3, }, // Pacific/Tarawa
    {   90, 4583,   44083,  4, }, // Pacific/Tongatapu
    {   90, 7392,   43076,  2, }, // Pacific/Wake
    {   90, 7405,   43078,  3, }, // Pacific/Wallis
    {   95, 6899,   55366,  6, }, // America/Scoresbysund Chinese/Simplified Han/Singapore
    {   96, 6788,   55372,  3, }, // Africa/Abidjan Chinese/Traditional Han/Hong Kong
    {   96,   14,   55375,  4, }, // Africa/Asmara
    {   96, 5257,   55379,  2, }, // Africa/Bangui
    {   96, 6773,   55381,  4, }, // Africa/Conakry
    {   96, 5130,   55385,  6, }, // Africa/Dar_es_Salaam
    {   96, 4479,   55391,  5, }, // Africa/Johannesburg
    {   96, 5306,   55396,  3, }, // Africa/Kinshasa
    {   96, 5336,   55399,  3, }, // Africa/Libreville
    {   96, 5211,   55402,  3, }, // Africa/Luanda
    {   96, 5001,   55405,  3, }, // Africa/Lusaka
    {   96, 5197,   55408,  3, }, // Africa/Maseru
    {   96, 3853,   55411,  3, }, // Africa/Nairobi
    {   96, 4152,   55414,  4, }, // Africa/Windhoek
    {   96,  132,   55418,  3, }, // America/Adak
    {   96, 4554,   55421,  5, }, // America/Araguaina
    {   96,  270,   55426,  4, }, // America/Argentina/Cordoba
    {   96, 7462,   55430,  4, }, // America/Argentina/La_Rioja
    {   96, 5640,   55434,  3, }, // America/Aruba
    {   96, 4252,   55437,  3, }, // America/Asuncion
    {   96, 3679,   55440,  3, }, // America/Bahia
    {   96, 7623,   55443,  8, }, // America/Bahia_Banderas
    {   96, 5407,   55451,  3, }, // America/Belize
    {   96, 7681,   55454,  5, }, // America/Boa_Vista
    {   96, 7756,   55459,  3, }, // America/Chihuahua
    {   96, 7774,   41867,  4, }, // America/Ciudad_Juarez
    {   96, 5422,   55462,  5, }, // America/Costa_Rica
    {   96, 3791,   55467,  3, }, // America/Cuiaba
    {   96, 7848,   55470,  3, }, // America/Dawson_Creek
    {   96,  893,   55473,  3, }, // America/Edmonton
    {   96, 7906,   55476,  4, }, // America/Fortaleza
    {   96, 7924,   55480,  4, }, // America/Glace_Bay
    {   96, 5770,   55484,  4, }, // America/Grenada
    {   96, 5786,   55488,  4, }, // America/Guadeloupe
    {   96, 3760,   55492,  4, }, // America/Guatemala
    {   96, 6932,   55496,  3, }, // America/Guyana
    {   96, 2281,   55499,  3, }, // America/Havana
    {   96,  348,   55502,  7, }, // America/Indiana/Indianapolis
    {   96,  481,   55509,  8, }, // America/Indiana/Knox
    {   96, 7961,   55517,  8, }, // America/Indiana/Marengo
    {   96, 7985,   55525,  8, }, // America/Indiana/Petersburg
    {   96, 8012,   55533,  8, }, // America/Indiana/Tell_City
    {   96, 8038,   55541,  7, }, // America/Indiana/Vevay
    {   96, 8060,   55548,  8, }, // America/Indiana/Vincennes
    {   96, 8086,   55556,  9, }, // America/Indiana/Winamac
    {   96, 8110,   55565,  4, }, // America/Inuvik
    {   96,  521,   55569,  4, }, // America/Kentucky/Louisville
    {   96, 8153,   55573,  3, }, // America/Maceio
    {   96, 8168,   55576,  3, }, // America/Managua
    {   96, 5805,   55579,  4, }, // America/Martinique
    {   96, 8202,   55583,  4, }, // America/Menominee
    {   96, 4098,   55587,  5, }, // America/Montevideo
    {   96, 5824,   55592,  5, }, // America/Montserrat
    {   96, 5481,   55597,  2, }, // America/Nassau
    {   96, 1850,   55599,  4, }, // America/Noronha
    {   96, 8301,   55603,  8, }, // America/North_Dakota/Beulah
    {   96, 8329,   55611,  8, }, // America/North_Dakota/Center
    {   96, 8357,   55619,  9, }, // America/North_Dakota/New_Salem
    {   96, 8404,   55628,  3, }, // America/Porto_Velho
    {   96,  695,   55631,  5, }, // America/Rio_Branco
    {   96, 2201,   55636,  4, }, // America/Santiago
    {   96, 6111,   55640,  4, }, // America/Santo_Domingo
    {   96, 8508,   55644,  5, }, // America/St_Barthelemy
    {   96, 2061,   55649,  4, }, // America/St_Johns
    {   96, 5880,   55653,  4, }, // America/St_Lucia
    {   96, 5913,   55657,  4, }, // America/St_Vincent
    {   96, 5461,   55661,  6, }, // America/Tegucigalpa
    {   96, 5756,   55667,  2, }, // America/Thule
    {   96,  313,   55669,  3, }, // America/Tijuana
    {   96, 2144,   55672,  3, }, // America/Whitehorse
    {   96, 8552,   55675,  4, }, // America/Yakutat
    {   96, 6001,   55679,  3, }, // Antarctica/Casey
    {   96, 6094,   55682,  4, }, // Antarctica/Davis
    {   96, 6133,   55686,  6, }, // Antarctica/DumontDUrville
    {   96, 8568,   55692,  3, }, // Antarctica/Macquarie
    {   96, 7066,   55695,  3, }, // Antarctica/Mawson
    {   96, 7113,   55698,  5, }, // Antarctica/McMurdo
    {   96, 8589,   55703,  3, }, // Antarctica/Palmer
    {   96, 7226,   55706,  4, }, // Antarctica/Rothera
    {   96, 7295,   55710,  3, }, // Antarctica/Syowa
    {   96, 8607,   55713,  4, }, // Antarctica/Troll
    {   96, 1429,   55717,  4, }, // Arctic/Longyearbyen
    {   96, 5511,   55721,  4, }, // Asia/Anadyr
    {   96, 3778,   55725,  4, }, // Asia/Bishkek
    {   96, 4511,   55729,  3, }, // Asia/Colombo
    {   96, 6159,   55732,  3, }, // Asia/Dushanbe
    {   96, 4795,   55735,  3, }, // Asia/Hebron
    {   96, 4184,   55738,  5, }, // Asia/Irkutsk
    {   96, 6992,   55743,  4, }, // Asia/Jayapura
    {   96, 1349,   55747,  2, }, // Asia/Makassar
    {   96, 6920,   55749,  4, }, // Asia/Muscat
    {   96, 2554,   55753,  4, }, // Asia/Nicosia
    {   96, 5559,   55757,  3, }, // Asia/Qatar
    {   96, 4828,   55760,  4, }, // Asia/Yakutsk
    {   96, 3883,   55764,  5, }, // Asia/Yekaterinburg
    {   96, 8736,   55769,  4, }, // Atlantic/Madeira
    {   96, 6644,   55773,  3, }, // Atlantic/Stanley
    {   96, 1670,   55776,  4, }, // Australia/Adelaide
    {   96, 1635,   55780,  4, }, // Australia/Brisbane
    {   96, 1516,   55784,  3, }, // Australia/Hobart
    {   96, 6336,   55787,  5, }, // Europe/Belgrade
    {   96, 6488,   55792,  6, }, // Europe/Bratislava
    {   96, 2583,   55798,  4, }, // Europe/Chisinau
    {   96, 8788,   55802,  3, }, // Europe/Guernsey
    {   96, 8804,   55805,  3, }, // Europe/Isle_of_Man
    {   96, 6506,   55808,  5, }, // Europe/Ljubljana
    {   96, 6397,   55813,  3, }, // Europe/Malta
    {   96, 6245,   55816,  4, }, // Europe/Sarajevo
    {   96, 6352,   55820,  3, }, // Europe/Vaduz
    {   96, 6261,   55823,  4, }, // Europe/Zagreb
    {   96, 6947,   55827,  5, }, // Indian/Chagos
    {   96, 6063,   55832,  5, }, // Indian/Cocos
    {   96, 5029,   42921,  3, }, // Indian/Comoro
    {   96, 6661,   55837,  6, }, // Indian/Kerguelen
    {   96, 7050,   55843,  4, }, // Indian/Maldives
    {   96, 4069,   55847,  4, }, // Indian/Mauritius
    {   96, 5098,   42942,  3, }, // Indian/Mayotte
    {   96, 7211,   42946,  3, }, // Indian/Reunion
    {   96, 3706,   55851,  5, }, // Pacific/Bougainville
    {   96, 7327,   55856,  5, }, // Pacific/Fakaofo
    {   96, 6696,   42985,  3, }, // Pacific/Gambier
    {   96, 3822,   55861,  7, }, // Pacific/Guadalcanal
    {   96, 3049,   55868,  5, }, // Pacific/Kanton
    {   96, 7019,   55873,  3, }, // Pacific/Kosrae
    {   96, 2842,   55876,  5, }, // Pacific/Kwajalein
    {   96, 4877,   55881,  3, }, // Pacific/Majuro
    {   96, 4051,   55884,  6, }, // Pacific/Marquesas
    {   96, 7084,   55890,  2, }, // Pacific/Nauru
    {   96, 7194,   55892,  5, }, // Pacific/Pitcairn
    {   96, 4583,   55897,  5, }, // Pacific/Tongatapu
    {   96, 7392,   55902,  3, }, // Pacific/Wake
    {   97, 6788,   55372,  3, }, // Africa/Abidjan Chinese/Traditional Han/Macao
    {   97,   14,   55375,  4, }, // Africa/Asmara
    {   97, 5257,   55379,  2, }, // Africa/Bangui
    {   97, 6773,   55381,  4, }, // Africa/Conakry
    {   97, 5130,   55385,  6, }, // Africa/Dar_es_Salaam
    {   97, 4479,   55391,  5, }, // Africa/Johannesburg
    {   97, 5306,   55396,  3, }, // Africa/Kinshasa
    {   97, 5336,   55399,  3, }, // Africa/Libreville
    {   97, 5211,   55402,  3, }, // Africa/Luanda
    {   97, 5001,   55405,  3, }, // Africa/Lusaka
    {   97, 5197,   55408,  3, }, // Africa/Maseru
    {   97, 3853,   55411,  3, }, // Africa/Nairobi
    {   97, 4152,   55414,  4, }, // Africa/Windhoek
    {   97,  132,   55418,  3, }, // America/Adak
    {   97, 4554,   55421,  5, }, // America/Araguaina
    {   97,  270,   55426,  4, }, // America/Argentina/Cordoba
    {   97, 7462,   55430,  4, }, // America/Argentina/La_Rioja
    {   97, 5640,   55434,  3, }, // America/Aruba
    {   97, 4252,   55437,  3, }, // America/Asuncion
    {   97, 3679,   55440,  3, }, // America/Bahia
    {   97, 7623,   55443,  8, }, // America/Bahia_Banderas
    {   97, 5407,   55451,  3, }, // America/Belize
    {   97, 7681,   55454,  5, }, // America/Boa_Vista
    {   97, 7756,   55459,  3, }, // America/Chihuahua
    {   97, 7774,   41867,  4, }, // America/Ciudad_Juarez
    {   97, 5422,   55462,  5, }, // America/Costa_Rica
    {   97, 3791,   55467,  3, }, // America/Cuiaba
    {   97, 7848,   55470,  3, }, // America/Dawson_Creek
    {   97,  893,   55473,  3, }, // America/Edmonton
    {   97, 7906,   55476,  4, }, // America/Fortaleza
    {   97, 7924,   55480,  4, }, // America/Glace_Bay
    {   97, 5770,   55484,  4, }, // America/Grenada
    {   97, 5786,   55488,  4, }, // America/Guadeloupe
    {   97, 3760,   55492,  4, }, // America/Guatemala
    {   97, 6932,   55496,  3, }, // America/Guyana
    {   97, 2281,   55499,  3, }, // America/Havana
    {   97,  348,   55502,  7, }, // America/Indiana/Indianapolis
    {   97,  481,   55509,  8, }, // America/Indiana/Knox
    {   97, 7961,   55517,  8, }, // America/Indiana/Marengo
    {   97, 7985,   55525,  8, }, // America/Indiana/Petersburg
    {   97, 8012,   55533,  8, }, // America/Indiana/Tell_City
    {   97, 8038,   55541,  7, }, // America/Indiana/Vevay
    {   97, 8060,   55548,  8, }, // America/Indiana/Vincennes
    {   97, 8086,   55556,  9, }, // America/Indiana/Winamac
    {   97, 8110,   55565,  4, }, // America/Inuvik
    {   97,  521,   55569,  4, }, // America/Kentucky/Louisville
    {   97, 8153,   55573,  3, }, // America/Maceio
    {   97, 8168,   55576,  3, }, // America/Managua
    {   97, 5805,   55579,  4, }, // America/Martinique
    {   97, 8202,   55583,  4, }, // America/Menominee
    {   97, 4098,   55587,  5, }, // America/Montevideo
    {   97, 5824,   55592,  5, }, // America/Montserrat
    {   97, 5481,   55597,  2, }, // America/Nassau
    {   97, 1850,   55599,  4, }, // America/Noronha
    {   97, 8301,   55603,  8, }, // America/North_Dakota/Beulah
    {   97, 8329,   55611,  8, }, // America/North_Dakota/Center
    {   97, 8357,   55619,  9, }, // America/North_Dakota/New_Salem
    {   97, 8404,   55628,  3, }, // America/Porto_Velho
    {   97,  695,   55631,  5, }, // America/Rio_Branco
    {   97, 2201,   55636,  4, }, // America/Santiago
    {   97, 6111,   55640,  4, }, // America/Santo_Domingo
    {   97, 8508,   55644,  5, }, // America/St_Barthelemy
    {   97, 2061,   55649,  4, }, // America/St_Johns
    {   97, 5880,   55653,  4, }, // America/St_Lucia
    {   97, 5913,   55657,  4, }, // America/St_Vincent
    {   97, 5461,   55661,  6, }, // America/Tegucigalpa
    {   97, 5756,   55667,  2, }, // America/Thule
    {   97,  313,   55669,  3, }, // America/Tijuana
    {   97, 2144,   55672,  3, }, // America/Whitehorse
    {   97, 8552,   55675,  4, }, // America/Yakutat
    {   97, 6001,   55679,  3, }, // Antarctica/Casey
    {   97, 6094,   55682,  4, }, // Antarctica/Davis
    {   97, 6133,   55686,  6, }, // Antarctica/DumontDUrville
    {   97, 8568,   55692,  3, }, // Antarctica/Macquarie
    {   97, 7066,   55695,  3, }, // Antarctica/Mawson
    {   97, 7113,   55698,  5, }, // Antarctica/McMurdo
    {   97, 8589,   55703,  3, }, // Antarctica/Palmer
    {   97, 7226,   55706,  4, }, // Antarctica/Rothera
    {   97, 7295,   55710,  3, }, // Antarctica/Syowa
    {   97, 8607,   55713,  4, }, // Antarctica/Troll
    {   97, 1429,   55717,  4, }, // Arctic/Longyearbyen
    {   97, 5511,   55721,  4, }, // Asia/Anadyr
    {   97, 3778,   55725,  4, }, // Asia/Bishkek
    {   97, 4511,   55729,  3, }, // Asia/Colombo
    {   97, 6159,   55732,  3, }, // Asia/Dushanbe
    {   97, 4795,   55735,  3, }, // Asia/Hebron
    {   97, 4184,   55738,  5, }, // Asia/Irkutsk
    {   97, 6992,   55743,  4, }, // Asia/Jayapura
    {   97, 1349,   55747,  2, }, // Asia/Makassar
    {   97, 6920,   55749,  4, }, // Asia/Muscat
    {   97, 2554,   55753,  4, }, // Asia/Nicosia
    {   97, 5559,   55757,  3, }, // Asia/Qatar
    {   97, 4828,   55760,  4, }, // Asia/Yakutsk
    {   97, 3883,   55764,  5, }, // Asia/Yekaterinburg
    {   97, 8736,   55769,  4, }, // Atlantic/Madeira
    {   97, 6644,   55773,  3, }, // Atlantic/Stanley
    {   97, 1670,   55776,  4, }, // Australia/Adelaide
    {   97, 1635,   55780,  4, }, // Australia/Brisbane
    {   97, 1516,   55784,  3, }, // Australia/Hobart
    {   97, 6336,   55787,  5, }, // Europe/Belgrade
    {   97, 6488,   55792,  6, }, // Europe/Bratislava
    {   97, 2583,   55798,  4, }, // Europe/Chisinau
    {   97, 8788,   55802,  3, }, // Europe/Guernsey
    {   97, 8804,   55805,  3, }, // Europe/Isle_of_Man
    {   97, 6506,   55808,  5, }, // Europe/Ljubljana
    {   97, 6397,   55813,  3, }, // Europe/Malta
    {   97, 6245,   55816,  4, }, // Europe/Sarajevo
    {   97, 6352,   55820,  3, }, // Europe/Vaduz
    {   97, 6261,   55823,  4, }, // Europe/Zagreb
    {   97, 6947,   55827,  5, }, // Indian/Chagos
    {   97, 6063,   55832,  5, }, // Indian/Cocos
    {   97, 5029,   42921,  3, }, // Indian/Comoro
    {   97, 6661,   55837,  6, }, // Indian/Kerguelen
    {   97, 7050,   55843,  4, }, // Indian/Maldives
    {   97, 4069,   55847,  4, }, // Indian/Mauritius
    {   97, 5098,   42942,  3, }, // Indian/Mayotte
    {   97, 7211,   42946,  3, }, // Indian/Reunion
    {   97, 3706,   55851,  5, }, // Pacific/Bougainville
    {   97, 7327,   55856,  5, }, // Pacific/Fakaofo
    {   97, 6696,   42985,  3, }, // Pacific/Gambier
    {   97, 3822,   55861,  7, }, // Pacific/Guadalcanal
    {   97, 3049,   55868,  5, }, // Pacific/Kanton
    {   97, 7019,   55873,  3, }, // Pacific/Kosrae
    {   97, 2842,   55876,  5, }, // Pacific/Kwajalein
    {   97, 4877,   55881,  3, }, // Pacific/Majuro
    {   97, 4051,   55884,  6, }, // Pacific/Marquesas
    {   97, 7084,   55890,  2, }, // Pacific/Nauru
    {   97, 7194,   55892,  5, }, // Pacific/Pitcairn
    {   97, 4583,   55897,  5, }, // Pacific/Tongatapu
    {   97, 7392,   55902,  3, }, // Pacific/Wake
    {   99, 6788,   41567,  3, }, // Africa/Abidjan Chinese/Traditional Han/Taiwan
    {   99, 5059,   41573,  6, }, // Africa/Addis_Ababa
    {   99, 7420,   41579,  4, }, // Africa/Algiers
    {   99,   14,   41583,  4, }, // Africa/Asmara
    {   99,   44,   41587,  3, }, // Africa/Bamako
    {   99, 6746,   41592,  2, }, // Africa/Banjul
    {   99, 7435,   41594,  2, }, // Africa/Bissau
    {   99, 4957,   41596,  4, }, // Africa/Blantyre
    {   99, 5287,   41600,  5, }, // Africa/Brazzaville
    {   99, 4922,   41605,  4, }, // Africa/Bujumbura
    {   99, 2320,   41609,  2, }, // Africa/Cairo
    {   99, 4117,   41611,  5, }, // Africa/Casablanca
    {   99, 7449,   41616,  2, }, // Africa/Ceuta
    {   99, 6773,   41618,  4, }, // Africa/Conakry
    {   99, 6840,   41622,  3, }, // Africa/Dakar
    {   99, 5130,   41625,  3, }, // Africa/Dar_es_Salaam
    {   99, 5043,   41628,  3, }, // Africa/Djibouti
    {   99, 6853,   41637,  3, }, // Africa/Freetown
    {   99, 4906,   41640,  4, }, // Africa/Gaborone
    {   99, 4479,   41647,  5, }, // Africa/Johannesburg
    {   99, 5306,   41663,  3, }, // Africa/Kinshasa
    {   99, 4744,   41666,  3, }, // Africa/Lagos
    {   99, 5336,   41669,  3, }, // Africa/Libreville
    {   99, 5211,   41674,  3, }, // Africa/Luanda
    {   99, 4939,   41677,  4, }, // Africa/Lubumbashi
    {   99, 5001,   41681,  3, }, // Africa/Lusaka
    {   99, 5322,   41684,  3, }, // Africa/Malabo
    {   99, 4987,   41687,  3, }, // Africa/Maputo
    {   99, 5197,   41690,  3, }, // Africa/Maseru
    {   99, 5182,   41693,  3, }, // Africa/Mbabane
    {   99, 5113,   41696,  4, }, // Africa/Mogadishu
    {   99, 7034,   41700,  4, }, // Africa/Monrovia
    {   99, 3853,   41704,  3, }, // Africa/Nairobi
    {   99, 5271,   41707,  4, }, // Africa/Ndjamena
    {   99, 5354,   41711,  3, }, // Africa/Niamey
    {   99, 6803,   41714,  3, }, // Africa/Nouakchott
    {   99, 5225,   41721,  4, }, // Africa/Porto-Novo
    {   99, 4435,   41725,  3, }, // Africa/Sao_Tome
    {   99, 4152,   41735,  4, }, // Africa/Windhoek
    {   99,  132,   41739,  3, }, // America/Adak
    {   99, 3346,   41742,  4, }, // America/Anchorage
    {   99, 5607,   55905,  3, }, // America/Anguilla
    {   99, 5624,   41749,  3, }, // America/Antigua
    {   99, 4554,   41752,  4, }, // America/Araguaina
    {   99,  166,   41756,  7, }, // America/Argentina/Buenos_Aires
    {   99,   91,   41763,  4, }, // America/Argentina/Catamarca
    {   99,  270,   41767,  3, }, // America/Argentina/Cordoba
    {   99, 7462,   41773,  3, }, // America/Argentina/La_Rioja
    {   99,  565,   41776,  3, }, // America/Argentina/Mendoza
    {   99, 7489,   41779,  6, }, // America/Argentina/Rio_Gallegos
    {   99, 7520,   41785,  3, }, // America/Argentina/Salta
    {   99, 7544,   41788,  3, }, // America/Argentina/San_Juan
    {   99, 5580,   41791,  3, }, // America/Argentina/San_Luis
    {   99, 7571,   41794,  3, }, // America/Argentina/Tucuman
    {   99, 7597,   41797,  4, }, // America/Argentina/Ushuaia
    {   99, 5640,   55908,  5, }, // America/Aruba
    {   99, 4252,   41804,  3, }, // America/Asuncion
    {   99, 3679,   41811,  3, }, // America/Bahia
    {   99, 7623,   41814,  7, }, // America/Bahia_Banderas
    {   99, 5654,   41821,  3, }, // America/Barbados
    {   99, 7646,   41824,  2, }, // America/Belem
    {   99, 5407,   41826,  3, }, // America/Belize
    {   99, 7660,   41829,  5, }, // America/Blanc-Sablon
    {   99, 7681,   41834,  4, }, // America/Boa_Vista
    {   99, 7699,   41841,  2, }, // America/Boise
    {   99, 7713,   41843,  3, }, // America/Cambridge_Bay
    {   99, 7735,   41846,  3, }, // America/Campo_Grande
    {   99, 4694,   41851,  4, }, // America/Caracas
    {   99, 4345,   41855,  2, }, // America/Cayenne
    {   99, 5496,   41857,  4, }, // America/Cayman
    {   99, 7756,   41864,  3, }, // America/Chihuahua
    {   99, 7774,   41867,  3, }, // America/Ciudad_Juarez
    {   99, 5422,   41871,  5, }, // America/Costa_Rica
    {   99, 7796,   41876,  4, }, // America/Creston
    {   99, 3791,   41880,  3, }, // America/Cuiaba
    {   99, 5723,   41883,  3, }, // America/Curacao
    {   99, 7812,   41886,  4, }, // America/Danmarkshavn
    {   99, 5739,   55913,  4, }, // America/Dominica
    {   99,  893,   41906,  4, }, // America/Edmonton
    {   99, 7869,   41910,  4, }, // America/Eirunepe
    {   99, 5441,   41914,  4, }, // America/El_Salvador
    {   99, 7886,   41918,  4, }, // America/Fort_Nelson
    {   99, 7906,   41922,  4, }, // America/Fortaleza
    {   99, 7924,   41926,  4, }, // America/Glace_Bay
    {   99, 6881,   41930,  2, }, // America/Goose_Bay
    {   99, 4612,   41932,  4, }, // America/Grand_Turk
    {   99, 5770,   41936,  4, }, // America/Grenada
    {   99, 5786,   41940,  4, }, // America/Guadeloupe
    {   99, 3760,   41944,  4, }, // America/Guatemala
    {   99, 4841,   41948,  4, }, // America/Guayaquil
    {   99, 6932,   41952,  3, }, // America/Guyana
    {   99, 1939,   41955,  5, }, // America/Halifax
    {   99, 7942,   41963,  4, }, // America/Hermosillo
    {   99,  348,   41967,  7, }, // America/Indiana/Indianapolis
    {   99,  481,   41974,  8, }, // America/Indiana/Knox
    {   99, 7961,   41982,  8, }, // America/Indiana/Marengo
    {   99, 7985,   41990,  8, }, // America/Indiana/Petersburg
    {   99, 8012,   41998,  8, }, // America/Indiana/Tell_City
    {   99, 8038,   42006,  7, }, // America/Indiana/Vevay
    {   99, 8060,   42013,  8, }, // America/Indiana/Vincennes
    {   99, 8086,   42021,  9, }, // America/Indiana/Winamac
    {   99, 8110,   42030,  4, }, // America/Inuvik
    {   99, 2799,   42037,  3, }, // America/Jamaica
    {   99, 5380,   42040,  2, }, // America/Juneau
    {   99,  521,   42042,  5, }, // America/Kentucky/Louisville
    {   99, 8125,   42047,  8, }, // America/Kentucky/Monticello
    {   99, 5704,   42055,  5, }, // America/Kralendijk
    {   99, 7169,   42063,  2, }, // America/Lima
    {   99, 3239,   42065,  3, }, // America/Los_Angeles
    {   99, 5932,   42068,  4, }, // America/Lower_Princes
    {   99, 8153,   42072,  3, }, // America/Maceio
    {   99, 8168,   42075,  3, }, // America/Managua
    {   99, 1908,   42078,  3, }, // America/Manaus
    {   99, 5897,   42081,  4, }, // America/Marigot
    {   99, 5805,   42085,  4, }, // America/Martinique
    {   99, 8184,   42089,  5, }, // America/Matamoros
    {   99, 2917,   42094,  4, }, // America/Mazatlan
    {   99, 8202,   42098,  4, }, // America/Menominee
    {   99, 8220,   42102,  3, }, // America/Merida
    {   99, 2949,   42111,  4, }, // America/Mexico_City
    {   99, 4391,   42115,  3, }, // America/Miquelon
    {   99, 8254,   42118,  3, }, // America/Moncton
    {   99, 8270,   42121,  3, }, // America/Monterrey
    {   99, 4098,   42124,  4, }, // America/Montevideo
    {   99, 5824,   42128,  3, }, // America/Montserrat
    {   99, 5481,   42131,  2, }, // America/Nassau
    {   99, 2379,   42133,  2, }, // America/New_York
    {   99, 8288,   42135,  2, }, // America/Nome
    {   99, 1850,   42137,  3, }, // America/Noronha
    {   99, 8301,   42140,  8, }, // America/North_Dakota/Beulah
    {   99, 8329,   42148,  7, }, // America/North_Dakota/Center
    {   99, 8357,   42155,  8, }, // America/North_Dakota/New_Salem
    {   99, 8388,   42165,  4, }, // America/Ojinaga
    {   99, 2356,   42169,  3, }, // America/Panama
    {   99, 6173,   42172,  5, }, // America/Paramaribo
    {   99, 2973,   42177,  3, }, // America/Phoenix
    {   99, 8404,   42187,  3, }, // America/Porto_Velho
    {   99, 4030,   42194,  6, }, // America/Punta_Arenas
    {   99, 8424,   42200,  3, }, // America/Rankin_Inlet
    {   99, 8445,   42203,  3, }, // America/Recife
    {   99, 1995,   42206,  3, }, // America/Regina
    {   99, 8460,   42209,  4, }, // America/Resolute
    {   99,  695,   42213,  4, }, // America/Rio_Branco
    {   99, 8477,   42217,  3, }, // America/Santarem
    {   99, 2201,   42220,  4, }, // America/Santiago
    {   99, 6111,   42224,  4, }, // America/Santo_Domingo
    {   99, 1878,   42228,  3, }, // America/Sao_Paulo
    {   99, 6899,   42231,  7, }, // America/Scoresbysund
    {   99, 8494,   42238,  3, }, // America/Sitka
    {   99, 8508,   42241,  6, }, // America/St_Barthelemy
    {   99, 2061,   42247,  3, }, // America/St_Johns
    {   99, 5863,   42250,  3, }, // America/St_Kitts
    {   99, 5880,   42253,  4, }, // America/St_Lucia
    {   99,  855,   42257,  4, }, // America/St_Thomas
    {   99, 5913,   42261,  3, }, // America/St_Vincent
    {   99, 8530,   42264,  7, }, // America/Swift_Current
    {   99, 5461,   42271,  5, }, // America/Tegucigalpa
    {   99, 5756,   42276,  2, }, // America/Thule
    {   99,  313,   42278,  3, }, // America/Tijuana
    {   99,  608,   42281,  3, }, // America/Toronto
    {   99, 5688,   42284,  4, }, // America/Tortola
    {   99, 2093,   42288,  3, }, // America/Vancouver
    {   99, 2144,   42291,  4, }, // America/Whitehorse
    {   99,  734,   42295,  3, }, // America/Winnipeg
    {   99, 8552,   42298,  3, }, // America/Yakutat
    {   99, 6001,   42301,  2, }, // Antarctica/Casey
    {   99, 6094,   42303,  3, }, // Antarctica/Davis
    {   99, 6133,   42306,  5, }, // Antarctica/DumontDUrville
    {   99, 8568,   42311,  3, }, // Antarctica/Macquarie
    {   99, 7113,   42316,  4, }, // Antarctica/McMurdo
    {   99, 8589,   42320,  2, }, // Antarctica/Palmer
    {   99, 7226,   42322,  3, }, // Antarctica/Rothera
    {   99, 7295,   42325,  4, }, // Antarctica/Syowa
    {   99, 8607,   42329,  2, }, // Antarctica/Troll
    {   99, 1429,   42335,  5, }, // Arctic/Longyearbyen
    {   99, 5570,   42340,  2, }, // Asia/Aden
    {   99, 5395,   42342,  4, }, // Asia/Almaty
    {   99, 5511,   42348,  3, }, // Asia/Anadyr
    {   99, 5368,   42354,  4, }, // Asia/Aqtobe
    {   99,  964,   42358,  5, }, // Asia/Ashgabat
    {   99, 8624,   42363,  3, }, // Asia/Atyrau
    {   99, 3607,   42366,  3, }, // Asia/Baghdad
    {   99, 3653,   41882,  2, }, // Asia/Baku
    {   99, 3571,   42373,  4, }, // Asia/Barnaul
    {   99, 4086,   42377,  3, }, // Asia/Beirut
    {   99, 3778,   42380,  4, }, // Asia/Bishkek
    {   99, 5989,   42384,  2, }, // Asia/Brunei
    {   99, 4511,   42388,  3, }, // Asia/Colombo
    {   99, 4540,   42391,  4, }, // Asia/Damascus
    {   99, 1093,   42395,  2, }, // Asia/Dhaka
    {   99, 3596,   42399,  2, }, // Asia/Dubai
    {   99, 6159,   42401,  3, }, // Asia/Dushanbe
    {   99, 8636,   42404,  5, }, // Asia/Famagusta
    {   99, 8651,   42409,  2, }, // Asia/Gaza
    {   99, 4795,   42411,  3, }, // Asia/Hebron
    {   99, 4184,   42435,  5, }, // Asia/Irkutsk
    {   99, 7006,   42440,  3, }, // Asia/Jakarta
    {   99, 6992,   42443,  4, }, // Asia/Jayapura
    {   99, 3560,   42451,  3, }, // Asia/Kabul
    {   99, 4239,   42457,  3, }, // Asia/Karachi
    {   99, 1185,   42460,  4, }, // Asia/Kathmandu
    {   99, 8661,   42464,  3, }, // Asia/Khandyga
    {   99,  992,   42467,  4, }, // Asia/Kolkata
    {   99, 4197,   42471,  8, }, // Asia/Krasnoyarsk
    {   99, 5976,   42482,  2, }, // Asia/Kuching
    {   99, 1211,   42494,  2, }, // Asia/Macau
    {   99, 4017,   42501,  3, }, // Asia/Magadan
    {   99, 1349,   42504,  4, }, // Asia/Makassar
    {   99, 7182,   42508,  3, }, // Asia/Manila
    {   99, 6920,   42511,  4, }, // Asia/Muscat
    {   99, 2554,   42515,  4, }, // Asia/Nicosia
    {   99, 8675,   42519,  6, }, // Asia/Novokuznetsk
    {   99, 4135,   42525,  5, }, // Asia/Novosibirsk
    {   99, 7145,   42534,  3, }, // Asia/Oral
    {   99, 6961,   42537,  2, }, // Asia/Phnom_Penh
    {   99, 5559,   42543,  2, }, // Asia/Qatar
    {   99, 8708,   55917,  4, }, // Asia/Qostanay
    {   99, 4269,   42549,  6, }, // Asia/Qyzylorda
    {   99, 3584,   42555,  3, }, // Asia/Riyadh
    {   99, 4408,   42558,  3, }, // Asia/Sakhalin
    {   99, 7245,   42561,  4, }, // Asia/Samarkand
    {   99, 3279,   42565,  2, }, // Asia/Seoul
    {   99, 2772,   42587,  3, }, // Asia/Tehran
    {   99, 2821,   42592,  2, }, // Asia/Tokyo
    {   99, 1021,   42598,  4, }, // Asia/Ulaanbaatar
    {   99, 1159,   42602,  4, }, // Asia/Urumqi
    {   99, 8722,   42606,  4, }, // Asia/Ust-Nera
    {   99, 6977,   42610,  2, }, // Asia/Vientiane
    {   99, 4710,   42612,  3, }, // Asia/Vladivostok
    {   99, 4828,   42615,  4, }, // Asia/Yakutsk
    {   99, 3883,   42621,  5, }, // Asia/Yekaterinburg
    {   99, 3747,   42626,  3, }, // Asia/Yerevan
    {   99, 3663,   42629,  5, }, // Atlantic/Azores
    {   99, 5671,   42634,  3, }, // Atlantic/Bermuda
    {   99, 6628,   42637,  3, }, // Atlantic/Canary
    {   99, 3727,   42640,  3, }, // Atlantic/Cape_Verde
    {   99, 1395,   42643,  4, }, // Atlantic/Faroe
    {   99, 8736,   42647,  5, }, // Atlantic/Madeira
    {   99, 2748,   42652,  5, }, // Atlantic/Reykjavik
    {   99, 7272,   42657,  4, }, // Atlantic/South_Georgia
    {   99, 6821,   42661,  5, }, // Atlantic/St_Helena
    {   99, 6644,   42666,  3, }, // Atlantic/Stanley
    {   99, 1670,   42669,  4, }, // Australia/Adelaide
    {   99, 1635,   42673,  4, }, // Australia/Brisbane
    {   99, 1799,   42677,  5, }, // Australia/Broken_Hill
    {   99, 1583,   42682,  3, }, // Australia/Darwin
    {   99, 1516,   42688,  3, }, // Australia/Hobart
    {   99, 1547,   42694,  4, }, // Australia/Lord_Howe
    {   99, 1727,   42698,  3, }, // Australia/Melbourne
    {   99, 1762,   42701,  2, }, // Australia/Perth
    {   99, 1463,   42703,  2, }, // Australia/Sydney
    {   99, 6216,   42710,  3, }, // Europe/Andorra
    {   99, 6336,   42720,  4, }, // Europe/Belgrade
    {   99, 6488,   42726,  6, }, // Europe/Bratislava
    {   99, 2167,   42732,  4, }, // Europe/Brussels
    {   99, 3806,   42741,  4, }, // Europe/Budapest
    {   99, 2583,   55921,  3, }, // Europe/Chisinau
    {   99, 2338,   42755,  3, }, // Europe/Dublin
    {   99, 6307,   42758,  4, }, // Europe/Gibraltar
    {   99, 8788,   42762,  3, }, // Europe/Guernsey
    {   99, 6612,   42765,  4, }, // Europe/Helsinki
    {   99, 8804,   42769,  2, }, // Europe/Isle_of_Man
    {   99, 1130,   42771,  4, }, // Europe/Istanbul
    {   99, 8823,   42775,  3, }, // Europe/Jersey
    {   99, 3979,   42778,  5, }, // Europe/Kaliningrad
    {   99, 2527,   42786,  2, }, // Europe/Kyiv
    {   99, 6506,   42791,  4, }, // Europe/Ljubljana
    {   99, 2501,   42795,  2, }, // Europe/London
    {   99, 6365,   42797,  3, }, // Europe/Luxembourg
    {   99, 4892,   42800,  3, }, // Europe/Madrid
    {   99, 6397,   42803,  3, }, // Europe/Malta
    {   99, 6582,   42806,  3, }, // Europe/Mariehamn
    {   99, 6410,   42812,  3, }, // Europe/Monaco
    {   99, 6458,   42818,  3, }, // Europe/Oslo
    {   99, 6424,   42823,  4, }, // Europe/Podgorica
    {   99, 6324,   42832,  2, }, // Europe/Rome
    {   99, 4331,   42834,  3, }, // Europe/Samara
    {   99, 6470,   42837,  4, }, // Europe/San_Marino
    {   99, 6245,   42841,  4, }, // Europe/Sarajevo
    {   99, 4451,   42845,  4, }, // Europe/Saratov
    {   99, 8849,   42849,  4, }, // Europe/Simferopol
    {   99, 6383,   42853,  4, }, // Europe/Skopje
    {   99, 6599,   42857,  3, }, // Europe/Sofia
    {   99, 6523,   42860,  5, }, // Europe/Stockholm
    {   99, 8882,   42870,  7, }, // Europe/Ulyanovsk
    {   99, 6352,   42877,  3, }, // Europe/Vaduz
    {   99, 6567,   42880,  3, }, // Europe/Vatican
    {   99, 6231,   42883,  3, }, // Europe/Vienna
    {   99, 8899,   42886,  4, }, // Europe/Vilnius
    {   99, 4727,   42890,  5, }, // Europe/Volgograd
    {   99, 3190,   42895,  2, }, // Europe/Warsaw
    {   99, 6261,   42897,  4, }, // Europe/Zagreb
    {   99, 6540,   42901,  3, }, // Europe/Zurich
    {   99, 5078,   55924,  6, }, // Indian/Antananarivo
    {   99, 6046,   42913,  3, }, // Indian/Christmas
    {   99, 6063,   42916,  5, }, // Indian/Cocos
    {   99, 5029,   42921,  5, }, // Indian/Comoro
    {   99, 6661,   42926,  5, }, // Indian/Kerguelen
    {   99, 7260,   42931,  3, }, // Indian/Mahe
    {   99, 7050,   42934,  4, }, // Indian/Maldives
    {   99, 4069,   42938,  4, }, // Indian/Mauritius
    {   99, 5098,   42942,  4, }, // Indian/Mayotte
    {   99, 7211,   42946,  4, }, // Indian/Reunion
    {   99, 4422,   42950,  3, }, // Pacific/Apia
    {   99,  932,   42953,  3, }, // Pacific/Auckland
    {   99, 3706,   42956,  4, }, // Pacific/Bougainville
    {   99, 3015,   42960,  2, }, // Pacific/Chatham
    {   99, 3157,   42962,  2, }, // Pacific/Chuuk
    {   99, 2237,   42964,  3, }, // Pacific/Easter
    {   99, 3902,   42973,  2, }, // Pacific/Fiji
    {   99, 7343,   42975,  4, }, // Pacific/Funafuti
    {   99, 6678,   42979,  6, }, // Pacific/Galapagos
    {   99, 6696,   42985,  5, }, // Pacific/Gambier
    {   99, 3822,   42990,  6, }, // Pacific/Guadalcanal
    {   99, 6018,   42996,  2, }, // Pacific/Guam
    {   99, 3049,   43001,  5, }, // Pacific/Kanton
    {   99, 3998,   43006,  6, }, // Pacific/Kiritimati
    {   99, 7019,   43012,  3, }, // Pacific/Kosrae
    {   99, 2842,   43015,  4, }, // Pacific/Kwajalein
    {   99, 4877,   43019,  3, }, // Pacific/Majuro
    {   99, 4051,   43022,  5, }, // Pacific/Marquesas
    {   99, 8914,   43027,  3, }, // Pacific/Midway
    {   99, 7084,   43030,  2, }, // Pacific/Nauru
    {   99, 7132,   43032,  3, }, // Pacific/Niue
    {   99, 4168,   43035,  3, }, // Pacific/Norfolk
    {   99, 7098,   43038,  3, }, // Pacific/Noumea
    {   99, 3126,   43041,  4, }, // Pacific/Pago_Pago
    {   99, 7155,   43045,  2, }, // Pacific/Palau
    {   99, 7194,   43047,  5, }, // Pacific/Pitcairn
    {   99, 3096,   43052,  3, }, // Pacific/Pohnpei
    {   99, 4807,   43055,  4, }, // Pacific/Port_Moresby
    {   99, 6076,   43059,  4, }, // Pacific/Rarotonga
    {   99, 7312,   43065,  3, }, // Pacific/Tahiti
    {   99, 4583,   43071,  5, }, // Pacific/Tongatapu
    {  100,   14,       0,  6, }, // Africa/Asmara Church/Cyrillic/Russia
    {  100, 4435,       6,  8, }, // Africa/Sao_Tome
    {  100, 4252,      14,  8, }, // America/Asuncion
    {  100,  237,      22,  8, }, // America/Atikokan
    {  100, 7623,      30, 17, }, // America/Bahia_Banderas
    {  100, 3868,      47,  6, }, // America/Cancun
    {  100, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  100, 5723,      66,  7, }, // America/Curacao
    {  100,  481,      73, 13, }, // America/Indiana/Knox
    {  100, 7961,      86, 16, }, // America/Indiana/Marengo
    {  100, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  100, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  100, 8038,     139, 14, }, // America/Indiana/Vevay
    {  100, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  100, 8086,     171, 16, }, // America/Indiana/Winamac
    {  100, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  100, 5932,     207, 22, }, // America/Lower_Princes
    {  100, 8220,     229,  6, }, // America/Merida
    {  100, 1850,     235, 19, }, // America/Noronha
    {  100, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  100, 8329,     274, 20, }, // America/North_Dakota/Center
    {  100, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  100,  393,     317,  4, }, // America/Nuuk
    {  100, 6899,     321, 16, }, // America/Scoresbysund
    {  100, 8508,     337, 14, }, // America/St_Barthelemy
    {  100, 2061,     351, 10, }, // America/St_Johns
    {  100, 5863,     361,  9, }, // America/St_Kitts
    {  100, 5880,     370,  9, }, // America/St_Lucia
    {  100,  855,     379, 10, }, // America/St_Thomas
    {  100, 5913,     389, 11, }, // America/St_Vincent
    {  100, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  100, 5395,   55930,  8, }, // Asia/Almaty
    {  100, 5511,   55938,  9, }, // Asia/Anadyr
    {  100, 5523,   55947,  7, }, // Asia/Aqtau
    {  100, 5368,   55954, 12, }, // Asia/Aqtobe
    {  100, 3778,   55966,  8, }, // Asia/Bishkek
    {  100, 4601,   55974,  5, }, // Asia/Chita
    {  100, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  100, 4184,   55979, 10, }, // Asia/Irkutsk
    {  100, 4316,   55989, 27, }, // Asia/Kamchatka
    {  100, 1185,     448,  9, }, // Asia/Kathmandu
    {  100, 8661,   56016,  8, }, // Asia/Khandyga
    {  100,  992,     457,  7, }, // Asia/Kolkata
    {  100, 4197,   56024, 12, }, // Asia/Krasnoyarsk
    {  100, 1211,     464,  5, }, // Asia/Macau
    {  100, 4017,   56036,  9, }, // Asia/Magadan
    {  100, 8675,   56045, 13, }, // Asia/Novokuznetsk
    {  100, 4135,   56058, 13, }, // Asia/Novosibirsk
    {  100, 4229,   56071,  7, }, // Asia/Omsk
    {  100, 7145,   56078, 11, }, // Asia/Oral
    {  100, 4269,   56089, 10, }, // Asia/Qyzylorda
    {  100, 4408,   56099,  9, }, // Asia/Sakhalin
    {  100, 4297,   56108, 15, }, // Asia/Srednekolymsk
    {  100, 8722,   56123, 13, }, // Asia/Ust-Nera
    {  100, 4710,   56136, 13, }, // Asia/Vladivostok
    {  100, 4828,   56149,  9, }, // Asia/Yakutsk
    {  100, 1235,     477,  6, }, // Asia/Yangon
    {  100, 3883,   56158, 15, }, // Asia/Yekaterinburg
    {  100, 1395,     483,  5, }, // Atlantic/Faroe
    {  100, 6821,     488, 10, }, // Atlantic/St_Helena
    {  100, 3979,   56173, 13, }, // Europe/Kaliningrad
    {  100, 2527,   56186,  6, }, // Europe/Kyiv
    {  100, 3693,   56192,  7, }, // Europe/Minsk
    {  100, 3537,   56199,  7, }, // Europe/Moscow
    {  100, 4331,   56206,  7, }, // Europe/Samara
    {  100, 8849,   56213, 12, }, // Europe/Simferopol
    {  100, 4727,   56225, 11, }, // Europe/Volgograd
    {  100, 7211,     547,  7, }, // Indian/Reunion
    {  100, 3157,     554,  5, }, // Pacific/Chuuk
    {  100, 3096,     586,  7, }, // Pacific/Pohnpei
    {  101, 6788,   36346,  7, }, // Africa/Abidjan Chuvash/Cyrillic/Russia
    {  101, 6760,     610,  5, }, // Africa/Accra
    {  101, 5059,     615, 11, }, // Africa/Addis_Ababa
    {  101, 7420,     626,  5, }, // Africa/Algiers
    {  101,   14,   56236,  6, }, // Africa/Asmara
    {  101,   44,     637,  6, }, // Africa/Bamako
    {  101, 5257,     643,  5, }, // Africa/Bangui
    {  101, 6746,     648,  6, }, // Africa/Banjul
    {  101, 7435,     654,  5, }, // Africa/Bissau
    {  101, 4957,   27220,  8, }, // Africa/Blantyre
    {  101, 5287,   51554, 10, }, // Africa/Brazzaville
    {  101, 4922,     676,  9, }, // Africa/Bujumbura
    {  101, 2320,     685,  4, }, // Africa/Cairo
    {  101, 4117,     689, 10, }, // Africa/Casablanca
    {  101, 7449,     699,  5, }, // Africa/Ceuta
    {  101, 6773,     704,  7, }, // Africa/Conakry
    {  101, 6840,     711,  5, }, // Africa/Dakar
    {  101, 5130,   27248, 12, }, // Africa/Dar_es_Salaam
    {  101, 5043,   36379,  7, }, // Africa/Djibouti
    {  101, 5243,     734,  5, }, // Africa/Douala
    {  101, 5166,   27267,  7, }, // Africa/El_Aaiun
    {  101, 6853,     746,  7, }, // Africa/Freetown
    {  101, 4906,     753,  8, }, // Africa/Gaborone
    {  101, 5015,   33913,  6, }, // Africa/Harare
    {  101, 4479,   51572, 12, }, // Africa/Johannesburg
    {  101, 4499,   27305,  5, }, // Africa/Juba
    {  101, 5151,     783,  7, }, // Africa/Kampala
    {  101, 4524,     790,  6, }, // Africa/Khartoum
    {  101, 4973,     796,  6, }, // Africa/Kigali
    {  101, 5306,     802,  7, }, // Africa/Kinshasa
    {  101, 4744,     809,  5, }, // Africa/Lagos
    {  101, 5336,   51584,  9, }, // Africa/Libreville
    {  101, 6869,     822,  4, }, // Africa/Lome
    {  101, 5211,     826,  6, }, // Africa/Luanda
    {  101, 4939,     832,  9, }, // Africa/Lubumbashi
    {  101, 5001,     841,  6, }, // Africa/Lusaka
    {  101, 5322,     847,  6, }, // Africa/Malabo
    {  101, 4987,     853,  6, }, // Africa/Maputo
    {  101, 5197,     859,  6, }, // Africa/Maseru
    {  101, 5182,     865,  7, }, // Africa/Mbabane
    {  101, 5113,     872,  8, }, // Africa/Mogadishu
    {  101, 7034,     880,  7, }, // Africa/Monrovia
    {  101, 3853,   36427,  7, }, // Africa/Nairobi
    {  101, 5271,   27386,  8, }, // Africa/Ndjamena
    {  101, 5354,   36434,  6, }, // Africa/Niamey
    {  101, 6803,     908,  7, }, // Africa/Nouakchott
    {  101, 6727,     915,  8, }, // Africa/Ouagadougou
    {  101, 5225,     923, 10, }, // Africa/Porto-Novo
    {  101, 4435,   56242, 17, }, // Africa/Sao_Tome
    {  101, 2866,     941,  7, }, // Africa/Tripoli
    {  101, 6554,     948,  5, }, // Africa/Tunis
    {  101, 4152,     953,  7, }, // Africa/Windhoek
    {  101,  132,     960,  4, }, // America/Adak
    {  101, 3346,   51593,  8, }, // America/Anchorage
    {  101, 5607,   51601,  7, }, // America/Anguilla
    {  101, 5624,     978,  7, }, // America/Antigua
    {  101, 4554,     985,  9, }, // America/Araguaina
    {  101,  166,   51608, 12, }, // America/Argentina/Buenos_Aires
    {  101,   91,    1006,  9, }, // America/Argentina/Catamarca
    {  101,  270,    1015,  7, }, // America/Argentina/Cordoba
    {  101,  441,   27487,  5, }, // America/Argentina/Jujuy
    {  101, 7462,    1027,  8, }, // America/Argentina/La_Rioja
    {  101,  565,    1035,  7, }, // America/Argentina/Mendoza
    {  101, 7489,   51620, 12, }, // America/Argentina/Rio_Gallegos
    {  101, 7520,   27512,  6, }, // America/Argentina/Salta
    {  101, 7544,    1058,  8, }, // America/Argentina/San_Juan
    {  101, 5580,   56259, 17, }, // America/Argentina/San_Luis
    {  101, 7571,    1074,  7, }, // America/Argentina/Tucuman
    {  101, 7597,   27526,  5, }, // America/Argentina/Ushuaia
    {  101, 5640,    1087,  5, }, // America/Aruba
    {  101, 4252,   51632,  8, }, // America/Asuncion
    {  101,  237,    1099, 12, }, // America/Atikokan
    {  101, 3679,   36500,  4, }, // America/Bahia
    {  101, 7623,   51640, 16, }, // America/Bahia_Banderas
    {  101, 5654,    1131,  8, }, // America/Barbados
    {  101, 7646,    1139,  5, }, // America/Belem
    {  101, 5407,    1144,  5, }, // America/Belize
    {  101, 7660,    1149, 12, }, // America/Blanc-Sablon
    {  101, 7681,    1161,  9, }, // America/Boa_Vista
    {  101, 4361,    1170,  6, }, // America/Bogota
    {  101, 7699,   51656,  5, }, // America/Boise
    {  101, 7713,   51661, 13, }, // America/Cambridge_Bay
    {  101, 7735,    1193, 12, }, // America/Campo_Grande
    {  101, 3868,    1205,  6, }, // America/Cancun
    {  101, 4694,    1211,  7, }, // America/Caracas
    {  101, 4345,   51674,  7, }, // America/Cayenne
    {  101, 5496,   56276, 16, }, // America/Cayman
    {  101, 2260,    1247,  6, }, // America/Chicago
    {  101, 7756,    1253,  6, }, // America/Chihuahua
    {  101, 7774,   56292, 13, }, // America/Ciudad_Juarez
    {  101, 5422,    1259, 10, }, // America/Costa_Rica
    {  101, 7796,    1269,  7, }, // America/Creston
    {  101, 3791,   27688,  5, }, // America/Cuiaba
    {  101, 5723,   36606,  7, }, // America/Curacao
    {  101, 7812,    1290, 12, }, // America/Danmarkshavn
    {  101, 7833,    1302,  6, }, // America/Dawson
    {  101, 7848,    1308, 11, }, // America/Dawson_Creek
    {  101,  805,    1319,  6, }, // America/Denver
    {  101, 3465,   36649,  7, }, // America/Detroit
    {  101, 5739,    1332,  8, }, // America/Dominica
    {  101,  893,   51681,  8, }, // America/Edmonton
    {  101, 7869,   51689,  8, }, // America/Eirunepe
    {  101, 5441,   27765,  9, }, // America/El_Salvador
    {  101, 7886,   51697, 12, }, // America/Fort_Nelson
    {  101, 7906,    1375,  9, }, // America/Fortaleza
    {  101, 7924,   51709,  9, }, // America/Glace_Bay
    {  101, 6881,   51718,  7, }, // America/Goose_Bay
    {  101, 4612,    1400, 10, }, // America/Grand_Turk
    {  101, 5770,    1410,  7, }, // America/Grenada
    {  101, 5786,    1417,  9, }, // America/Guadeloupe
    {  101, 3760,    1426,  9, }, // America/Guatemala
    {  101, 4841,   51725,  8, }, // America/Guayaquil
    {  101, 6932,   51733,  6, }, // America/Guyana
    {  101, 1939,   51739,  8, }, // America/Halifax
    {  101, 2281,    1457,  6, }, // America/Havana
    {  101, 7942,   51747,  9, }, // America/Hermosillo
    {  101,  348,    1471, 12, }, // America/Indiana/Indianapolis
    {  101,  481,    1483, 13, }, // America/Indiana/Knox
    {  101, 7961,    1496, 16, }, // America/Indiana/Marengo
    {  101, 7985,    1512, 19, }, // America/Indiana/Petersburg
    {  101, 8012,   56305, 18, }, // America/Indiana/Tell_City
    {  101, 8038,   56323, 14, }, // America/Indiana/Vevay
    {  101, 8060,   56337, 18, }, // America/Indiana/Vincennes
    {  101, 8086,   56355, 16, }, // America/Indiana/Winamac
    {  101, 8110,    1570,  6, }, // America/Inuvik
    {  101,  660,    1576,  7, }, // America/Iqaluit
    {  101, 2799,   28011,  6, }, // America/Jamaica
    {  101, 5380,   36746,  5, }, // America/Juneau
    {  101,  521,    1594,  8, }, // America/Kentucky/Louisville
    {  101, 8125,    1602, 20, }, // America/Kentucky/Monticello
    {  101, 5704,   36751, 10, }, // America/Kralendijk
    {  101, 4376,    1632,  6, }, // America/La_Paz
    {  101, 7169,    1638,  4, }, // America/Lima
    {  101, 3239,   51761, 12, }, // America/Los_Angeles
    {  101, 5932,   56371, 18, }, // America/Lower_Princes
    {  101, 8153,   36799,  6, }, // America/Maceio
    {  101, 8168,    1677,  7, }, // America/Managua
    {  101, 1908,    1684,  6, }, // America/Manaus
    {  101, 5897,    1690,  6, }, // America/Marigot
    {  101, 5805,    1696,  9, }, // America/Martinique
    {  101, 8184,    1705,  9, }, // America/Matamoros
    {  101, 2917,    1714,  8, }, // America/Mazatlan
    {  101, 8202,    1722,  8, }, // America/Menominee
    {  101, 8220,    1730,  6, }, // America/Merida
    {  101, 8235,    1736, 10, }, // America/Metlakatla
    {  101, 2949,    1746,  6, }, // America/Mexico_City
    {  101, 4391,    1752,  7, }, // America/Miquelon
    {  101, 8254,    1759,  7, }, // America/Moncton
    {  101, 8270,   51794,  9, }, // America/Monterrey
    {  101, 4098,    1775, 10, }, // America/Montevideo
    {  101, 5824,    1785, 10, }, // America/Montserrat
    {  101, 5481,    1795,  6, }, // America/Nassau
    {  101, 2379,   51812,  8, }, // America/New_York
    {  101, 8288,    1809,  3, }, // America/Nome
    {  101, 1850,   56389,  7, }, // America/Noronha
    {  101, 8301,   56396, 20, }, // America/North_Dakota/Beulah
    {  101, 8329,   56416, 20, }, // America/North_Dakota/Center
    {  101, 8357,   56436, 25, }, // America/North_Dakota/New_Salem
    {  101,  393,    1890,  4, }, // America/Nuuk
    {  101, 8388,    1894,  7, }, // America/Ojinaga
    {  101, 2356,    1901,  6, }, // America/Panama
    {  101, 6173,    1907, 10, }, // America/Paramaribo
    {  101, 2973,    1917,  6, }, // America/Phoenix
    {  101, 3945,    1923, 12, }, // America/Port-au-Prince
    {  101, 5954,   28321, 13, }, // America/Port_of_Spain
    {  101, 8404,   28334, 11, }, // America/Porto_Velho
    {  101, 5843,   51888, 11, }, // America/Puerto_Rico
    {  101, 4030,    1970, 12, }, // America/Punta_Arenas
    {  101, 8424,    1982, 12, }, // America/Rankin_Inlet
    {  101, 8445,    1994,  6, }, // America/Recife
    {  101, 1995,   51899,  8, }, // America/Regina
    {  101, 8460,   56461,  8, }, // America/Resolute
    {  101,  695,    2015, 10, }, // America/Rio_Branco
    {  101, 8477,    2025,  8, }, // America/Santarem
    {  101, 2201,   51907,  8, }, // America/Santiago
    {  101, 6111,    2041, 13, }, // America/Santo_Domingo
    {  101, 1878,   56469, 19, }, // America/Sao_Paulo
    {  101, 6899,    2063, 11, }, // America/Scoresbysund
    {  101, 8494,    2074,  5, }, // America/Sitka
    {  101, 8508,    2079, 13, }, // America/St_Barthelemy
    {  101, 2061,   28481, 10, }, // America/St_Johns
    {  101, 5863,    2101,  9, }, // America/St_Kitts
    {  101, 5880,   56488, 10, }, // America/St_Lucia
    {  101,  855,    2121, 10, }, // America/St_Thomas
    {  101, 5913,    2131, 12, }, // America/St_Vincent
    {  101, 8530,    2143, 13, }, // America/Swift_Current
    {  101, 5461,   51949, 12, }, // America/Tegucigalpa
    {  101, 5756,    2167,  4, }, // America/Thule
    {  101,  313,    2171,  7, }, // America/Tijuana
    {  101,  608,    2178,  7, }, // America/Toronto
    {  101, 5688,    2185,  7, }, // America/Tortola
    {  101, 2093,    2192,  8, }, // America/Vancouver
    {  101, 2144,   28567,  8, }, // America/Whitehorse
    {  101,  734,    2208,  8, }, // America/Winnipeg
    {  101, 8552,   28582,  6, }, // America/Yakutat
    {  101, 6001,   37021,  5, }, // Antarctica/Casey
    {  101, 6094,   37026,  6, }, // Antarctica/Davis
    {  101, 6133,   56498, 29, }, // Antarctica/DumontDUrville
    {  101, 8568,    2249,  8, }, // Antarctica/Macquarie
    {  101, 7066,    2257,  6, }, // Antarctica/Mawson
    {  101, 7113,    2263,  9, }, // Antarctica/McMurdo
    {  101, 8589,    2272,  6, }, // Antarctica/Palmer
    {  101, 7226,    2278,  6, }, // Antarctica/Rothera
    {  101, 7295,   28642,  4, }, // Antarctica/Syowa
    {  101, 8607,   51975,  6, }, // Antarctica/Troll
    {  101, 7374,   34957,  6, }, // Antarctica/Vostok
    {  101, 1429,   51981,  7, }, // Arctic/Longyearbyen
    {  101, 5570,    2310,  4, }, // Asia/Aden
    {  101, 5395,    2314,  6, }, // Asia/Almaty
    {  101, 3968,    2320,  5, }, // Asia/Amman
    {  101, 5511,   52002,  7, }, // Asia/Anadyr
    {  101, 5523,    2331,  5, }, // Asia/Aqtau
    {  101, 5368,    2336,  6, }, // Asia/Aqtobe
    {  101,  964,    2342,  7, }, // Asia/Ashgabat
    {  101, 8624,    2349,  6, }, // Asia/Atyrau
    {  101, 3607,    2355,  6, }, // Asia/Baghdad
    {  101, 5534,   37080,  7, }, // Asia/Bahrain
    {  101, 3653,    2368,  4, }, // Asia/Baku
    {  101, 4466,    2372,  7, }, // Asia/Bangkok
    {  101, 3571,    2379,  7, }, // Asia/Barnaul
    {  101, 4086,   28695,  6, }, // Asia/Beirut
    {  101, 3778,    2392,  6, }, // Asia/Bishkek
    {  101, 5989,   28707,  6, }, // Asia/Brunei
    {  101, 4601,    2404,  4, }, // Asia/Chita
    {  101, 4511,    2408,  7, }, // Asia/Colombo
    {  101, 4540,    2415,  6, }, // Asia/Damascus
    {  101, 1093,    2421,  5, }, // Asia/Dhaka
    {  101, 6192,    2426,  4, }, // Asia/Dili
    {  101, 3596,   28728,  5, }, // Asia/Dubai
    {  101, 6159,    2435,  7, }, // Asia/Dushanbe
    {  101, 8636,    2442,  9, }, // Asia/Famagusta
    {  101, 8651,    2451,  4, }, // Asia/Gaza
    {  101, 4795,    2455,  6, }, // Asia/Hebron
    {  101, 1259,    2461,  7, }, // Asia/Ho_Chi_Minh
    {  101, 2704,   52034,  7, }, // Asia/Hong_Kong
    {  101, 4771,    2475,  4, }, // Asia/Hovd
    {  101, 4184,    2479,  7, }, // Asia/Irkutsk
    {  101, 7006,   28770,  8, }, // Asia/Jakarta
    {  101, 6992,   28778,  8, }, // Asia/Jayapura
    {  101, 1290,    2501,  9, }, // Asia/Jerusalem
    {  101, 3560,    2510,  5, }, // Asia/Kabul
    {  101, 4316,   52059, 23, }, // Asia/Kamchatka
    {  101, 4239,    2540,  6, }, // Asia/Karachi
    {  101, 1185,    2546,  8, }, // Asia/Kathmandu
    {  101, 8661,    2554,  7, }, // Asia/Khandyga
    {  101,  992,   52082,  9, }, // Asia/Kolkata
    {  101, 4197,   37110, 10, }, // Asia/Krasnoyarsk
    {  101, 4859,    2580, 12, }, // Asia/Kuala_Lumpur
    {  101, 5976,    2592,  6, }, // Asia/Kuching
    {  101, 5547,   28825,  6, }, // Asia/Kuwait
    {  101, 1211,    2604,  5, }, // Asia/Macau
    {  101, 4017,    2609,  7, }, // Asia/Magadan
    {  101, 1349,    2616,  7, }, // Asia/Makassar
    {  101, 7182,    2623,  6, }, // Asia/Manila
    {  101, 6920,    2629,  6, }, // Asia/Muscat
    {  101, 2554,    2635,  6, }, // Asia/Nicosia
    {  101, 8675,    2642, 11, }, // Asia/Novokuznetsk
    {  101, 4135,    2653, 11, }, // Asia/Novosibirsk
    {  101, 4229,    2664,  4, }, // Asia/Omsk
    {  101, 7145,   28871,  7, }, // Asia/Oral
    {  101, 6961,   52091,  8, }, // Asia/Phnom_Penh
    {  101, 8693,    2681,  9, }, // Asia/Pontianak
    {  101, 4214,   28895,  7, }, // Asia/Pyongyang
    {  101, 5559,    2697,  5, }, // Asia/Qatar
    {  101, 8708,   37137,  8, }, // Asia/Qostanay
    {  101, 4269,    2710,  9, }, // Asia/Qyzylorda
    {  101, 3584,   52099,  7, }, // Asia/Riyadh
    {  101, 4408,   56527, 14, }, // Asia/Sakhalin
    {  101, 7245,    2739,  9, }, // Asia/Samarkand
    {  101, 3279,    2748,  4, }, // Asia/Seoul
    {  101, 1053,   28933,  6, }, // Asia/Shanghai
    {  101, 3300,    2758,  8, }, // Asia/Singapore
    {  101, 4297,    2766, 13, }, // Asia/Srednekolymsk
    {  101, 3263,   28961,  6, }, // Asia/Taipei
    {  101, 4781,    2785,  7, }, // Asia/Tashkent
    {  101, 3915,   35206,  7, }, // Asia/Tbilisi
    {  101, 2772,    2796,  7, }, // Asia/Tehran
    {  101, 1317,    2803,  7, }, // Asia/Thimphu
    {  101, 2821,    2810,  5, }, // Asia/Tokyo
    {  101, 4572,    2815,  5, }, // Asia/Tomsk
    {  101, 1021,    2820, 10, }, // Asia/Ulaanbaatar
    {  101, 1159,    2830,  6, }, // Asia/Urumqi
    {  101, 8722,   52125,  9, }, // Asia/Ust-Nera
    {  101, 6977,   52134,  8, }, // Asia/Vientiane
    {  101, 4710,    2851, 11, }, // Asia/Vladivostok
    {  101, 4828,   37183,  6, }, // Asia/Yakutsk
    {  101, 1235,   56541,  5, }, // Asia/Yangon
    {  101, 3883,    2875, 12, }, // Asia/Yekaterinburg
    {  101, 3747,    2887,  6, }, // Asia/Yerevan
    {  101, 3663,   56546, 14, }, // Atlantic/Azores
    {  101, 5671,   56560, 16, }, // Atlantic/Bermuda
    {  101, 6628,   56576, 15, }, // Atlantic/Canary
    {  101, 3727,    2944, 10, }, // Atlantic/Cape_Verde
    {  101, 1395,   56591, 15, }, // Atlantic/Faroe
    {  101, 8736,   37264,  7, }, // Atlantic/Madeira
    {  101, 2748,   52214,  9, }, // Atlantic/Reykjavik
    {  101, 7272,   56606, 13, }, // Atlantic/South_Georgia
    {  101, 6821,   56619, 20, }, // Atlantic/St_Helena
    {  101, 6644,   52256,  6, }, // Atlantic/Stanley
    {  101, 1670,    3035,  8, }, // Australia/Adelaide
    {  101, 1635,    3043,  7, }, // Australia/Brisbane
    {  101, 1799,    3050, 11, }, // Australia/Broken_Hill
    {  101, 1583,    3061,  6, }, // Australia/Darwin
    {  101, 3637,   29240,  4, }, // Australia/Eucla
    {  101, 1516,    3072,  6, }, // Australia/Hobart
    {  101, 8753,    3078,  8, }, // Australia/Lindeman
    {  101, 1547,    3086,  8, }, // Australia/Lord_Howe
    {  101, 1727,   29252,  8, }, // Australia/Melbourne
    {  101, 1762,    3101,  4, }, // Australia/Perth
    {  101, 1463,   52276,  6, }, // Australia/Sydney
    {  101, 6441,    3111,  9, }, // Europe/Amsterdam
    {  101, 6216,    3120,  7, }, // Europe/Andorra
    {  101, 3620,   29281,  9, }, // Europe/Astrakhan
    {  101, 2300,   56639,  7, }, // Europe/Athens
    {  101, 6336,    3139,  7, }, // Europe/Belgrade
    {  101, 4757,    3146,  6, }, // Europe/Berlin
    {  101, 6488,    3152, 10, }, // Europe/Bratislava
    {  101, 2167,   52296,  8, }, // Europe/Brussels
    {  101, 3928,    3170,  8, }, // Europe/Bucharest
    {  101, 3806,    3178,  8, }, // Europe/Budapest
    {  101, 8772,   37368,  8, }, // Europe/Busingen
    {  101, 2583,    3209,  7, }, // Europe/Chisinau
    {  101, 6289,   52323, 10, }, // Europe/Copenhagen
    {  101, 2338,    3226,  6, }, // Europe/Dublin
    {  101, 6307,    3232,  9, }, // Europe/Gibraltar
    {  101, 8788,    3241,  6, }, // Europe/Guernsey
    {  101, 6612,   52333,  9, }, // Europe/Helsinki
    {  101, 8804,   56646, 10, }, // Europe/Isle_of_Man
    {  101, 1130,    3264,  7, }, // Europe/Istanbul
    {  101, 8823,   52351,  6, }, // Europe/Jersey
    {  101, 3979,    3276, 11, }, // Europe/Kaliningrad
    {  101, 8929,    3287,  5, }, // Europe/Kirov
    {  101, 2527,    3292,  4, }, // Europe/Kyiv
    {  101, 3213,    3296,  8, }, // Europe/Lisbon
    {  101, 6506,   29432,  7, }, // Europe/Ljubljana
    {  101, 2501,    3313,  6, }, // Europe/London
    {  101, 6365,   29445, 10, }, // Europe/Luxembourg
    {  101, 4892,    3330,  6, }, // Europe/Madrid
    {  101, 6397,   29461,  6, }, // Europe/Malta
    {  101, 6582,    3341,  9, }, // Europe/Mariehamn
    {  101, 3693,    3350,  5, }, // Europe/Minsk
    {  101, 6410,    3355,  6, }, // Europe/Monaco
    {  101, 3537,   56656,  6, }, // Europe/Moscow
    {  101, 6458,    3367,  4, }, // Europe/Oslo
    {  101, 4284,    3371,  5, }, // Europe/Paris
    {  101, 6424,    3376,  9, }, // Europe/Podgorica
    {  101, 6275,    3385,  5, }, // Europe/Prague
    {  101, 8837,    3390,  4, }, // Europe/Riga
    {  101, 6324,    3394,  3, }, // Europe/Rome
    {  101, 4331,    3397,  6, }, // Europe/Samara
    {  101, 6470,    3403, 10, }, // Europe/San_Marino
    {  101, 6245,    3413,  7, }, // Europe/Sarajevo
    {  101, 4451,    3420,  7, }, // Europe/Saratov
    {  101, 8849,   52357, 11, }, // Europe/Simferopol
    {  101, 6383,   52368,  6, }, // Europe/Skopje
    {  101, 6599,    3442,  4, }, // Europe/Sofia
    {  101, 6523,   52374,  9, }, // Europe/Stockholm
    {  101, 8867,    3455,  6, }, // Europe/Tallinn
    {  101, 6202,    3461,  6, }, // Europe/Tirane
    {  101, 8882,   52383,  9, }, // Europe/Ulyanovsk
    {  101, 6352,    3476,  5, }, // Europe/Vaduz
    {  101, 6567,    3481,  7, }, // Europe/Vatican
    {  101, 6231,    3488,  4, }, // Europe/Vienna
    {  101, 8899,   52392,  7, }, // Europe/Vilnius
    {  101, 4727,    3499,  9, }, // Europe/Volgograd
    {  101, 3190,    3508,  7, }, // Europe/Warsaw
    {  101, 6261,    3515,  6, }, // Europe/Zagreb
    {  101, 6540,   37442,  5, }, // Europe/Zurich
    {  101, 5078,    3527, 12, }, // Indian/Antananarivo
    {  101, 6947,    3539,  5, }, // Indian/Chagos
    {  101, 6046,   56662, 13, }, // Indian/Christmas
    {  101, 6063,   56675, 15, }, // Indian/Cocos
    {  101, 5029,   56690,  8, }, // Indian/Comoro
    {  101, 6661,    3578,  8, }, // Indian/Kerguelen
    {  101, 7260,   29694,  3, }, // Indian/Mahe
    {  101, 7050,   56698, 10, }, // Indian/Maldives
    {  101, 4069,   56708,  8, }, // Indian/Mauritius
    {  101, 5098,   56716,  7, }, // Indian/Mayotte
    {  101, 7211,   52480,  7, }, // Indian/Reunion
    {  101, 4422,    3616,  4, }, // Pacific/Apia
    {  101,  932,    3620,  6, }, // Pacific/Auckland
    {  101, 3706,   52487,  9, }, // Pacific/Bougainville
    {  101, 3015,    3634,  5, }, // Pacific/Chatham
    {  101, 3157,    3639,  4, }, // Pacific/Chuuk
    {  101, 2237,   56723, 13, }, // Pacific/Easter
    {  101, 7360,   52541,  5, }, // Pacific/Efate
    {  101, 7327,    3659,  7, }, // Pacific/Fakaofo
    {  101, 3902,   37539,  5, }, // Pacific/Fiji
    {  101, 7343,    3670,  8, }, // Pacific/Funafuti
    {  101, 6678,   56736, 19, }, // Pacific/Galapagos
    {  101, 6696,   56755, 16, }, // Pacific/Gambier
    {  101, 3822,    3713, 11, }, // Pacific/Guadalcanal
    {  101, 6018,    3724,  4, }, // Pacific/Guam
    {  101, 3049,    3728,  6, }, // Pacific/Kanton
    {  101, 3998,    3734, 10, }, // Pacific/Kiritimati
    {  101, 7019,    3744,  6, }, // Pacific/Kosrae
    {  101, 2842,   29841, 10, }, // Pacific/Kwajalein
    {  101, 4877,   37574,  7, }, // Pacific/Majuro
    {  101, 4051,   56771, 18, }, // Pacific/Marquesas
    {  101, 8914,   52622,  6, }, // Pacific/Midway
    {  101, 7084,    3798,  5, }, // Pacific/Nauru
    {  101, 7132,   52636,  4, }, // Pacific/Niue
    {  101, 4168,    3807,  7, }, // Pacific/Norfolk
    {  101, 7098,    3814,  5, }, // Pacific/Noumea
    {  101, 3126,    3819,  9, }, // Pacific/Pago_Pago
    {  101, 7155,    3828,  5, }, // Pacific/Palau
    {  101, 7194,   56789,  7, }, // Pacific/Pitcairn
    {  101, 3096,    3840,  6, }, // Pacific/Pohnpei
    {  101, 4807,    3846, 11, }, // Pacific/Port_Moresby
    {  101, 6076,    3857,  9, }, // Pacific/Rarotonga
    {  101, 6031,   29935,  6, }, // Pacific/Saipan
    {  101, 7312,    3872,  5, }, // Pacific/Tahiti
    {  101, 6712,    3877,  6, }, // Pacific/Tarawa
    {  101, 4583,    3883,  9, }, // Pacific/Tongatapu
    {  101, 7392,   29955,  4, }, // Pacific/Wake
    {  101, 7405,    3896,  6, }, // Pacific/Wallis
    {  102,   14,       0,  6, }, // Africa/Asmara Colognian/Latin/Germany
    {  102, 2320,   56796,  6, }, // Africa/Cairo
    {  102, 4744,   56802,  6, }, // Africa/Lagos
    {  102, 4435,       6,  8, }, // Africa/Sao_Tome
    {  102, 4152,   56808,  7, }, // Africa/Windhoek
    {  102, 4252,      14,  8, }, // America/Asuncion
    {  102,  237,      22,  8, }, // America/Atikokan
    {  102, 7623,      30, 17, }, // America/Bahia_Banderas
    {  102, 3868,      47,  6, }, // America/Cancun
    {  102, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  102, 5422,   56815, 10, }, // America/Costa_Rica
    {  102, 5723,      66,  7, }, // America/Curacao
    {  102, 4841,   56825,  9, }, // America/Guayaquil
    {  102,  481,   56834, 15, }, // America/Indiana/Knox
    {  102, 7961,   56849, 18, }, // America/Indiana/Marengo
    {  102, 7985,   56867, 21, }, // America/Indiana/Petersburg
    {  102, 8012,   56888, 20, }, // America/Indiana/Tell_City
    {  102, 8038,   56908, 16, }, // America/Indiana/Vevay
    {  102, 8060,   56924, 20, }, // America/Indiana/Vincennes
    {  102, 8086,   56944, 18, }, // America/Indiana/Winamac
    {  102, 8125,   56962, 22, }, // America/Kentucky/Monticello
    {  102, 5932,     207, 22, }, // America/Lower_Princes
    {  102, 8220,     229,  6, }, // America/Merida
    {  102, 2949,   56984, 14, }, // America/Mexico_City
    {  102, 1850,     235, 19, }, // America/Noronha
    {  102, 8301,   56998, 21, }, // America/North_Dakota/Beulah
    {  102, 8329,   57019, 21, }, // America/North_Dakota/Center
    {  102, 8357,   57040, 24, }, // America/North_Dakota/New_Salem
    {  102,  393,     317,  4, }, // America/Nuuk
    {  102, 6899,     321, 16, }, // America/Scoresbysund
    {  102, 8508,   57064, 15, }, // America/St_Barthelemy
    {  102, 2061,   57079, 11, }, // America/St_Johns
    {  102, 5863,   57090, 10, }, // America/St_Kitts
    {  102, 5880,   57100, 16, }, // America/St_Lucia
    {  102,  855,   57116, 11, }, // America/St_Thomas
    {  102, 5913,   57127, 15, }, // America/St_Vincent
    {  102, 8552,    7517,  7, }, // America/Yakutat
    {  102, 6133,   57142, 27, }, // Antarctica/DumontDUrville
    {  102, 7295,   57169, 36, }, // Antarctica/Syowa
    {  102, 7374,    4147,  6, }, // Antarctica/Vostok
    {  102, 5368,   57205,  6, }, // Asia/Aqtobe
    {  102,  964,   57211,  9, }, // Asia/Ashgabat
    {  102, 3607,    4162,  6, }, // Asia/Baghdad
    {  102, 3778,   57220,  8, }, // Asia/Bishkek
    {  102, 4540,    4201,  8, }, // Asia/Damascus
    {  102, 6159,   57228,  9, }, // Asia/Dushanbe
    {  102, 8651,   57237,  5, }, // Asia/Gaza
    {  102, 1259,   57242, 30, }, // Asia/Ho_Chi_Minh
    {  102, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  102, 4316,   57272, 11, }, // Asia/Kamchatka
    {  102, 1185,     448,  9, }, // Asia/Kathmandu
    {  102,  992,     457,  7, }, // Asia/Kolkata
    {  102, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  102, 1211,     464,  5, }, // Asia/Macau
    {  102, 2554,   57283,  8, }, // Asia/Nicosia
    {  102, 6961,   57291,  9, }, // Asia/Phnom_Penh
    {  102, 4269,   57300,  9, }, // Asia/Qyzylorda
    {  102, 3584,   33571,  5, }, // Asia/Riyadh
    {  102, 1053,   57309,  9, }, // Asia/Shanghai
    {  102, 3300,   57318, 10, }, // Asia/Singapore
    {  102, 4781,   57328,  9, }, // Asia/Tashkent
    {  102, 3915,   57337,  6, }, // Asia/Tbilisi
    {  102, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {  102, 1159,   57343, 11, }, // Asia/Urumqi
    {  102, 4710,    4361, 11, }, // Asia/Vladivostok
    {  102, 4828,    7873,  7, }, // Asia/Yakutsk
    {  102, 1235,   57354,  6, }, // Asia/Yangon
    {  102, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  102, 3747,   57360,  6, }, // Asia/Yerevan
    {  102, 3663,   57366,  6, }, // Atlantic/Azores
    {  102, 6628,   57372,  8, }, // Atlantic/Canary
    {  102, 3727,   57380,  9, }, // Atlantic/Cape_Verde
    {  102, 1395,   57389,  5, }, // Atlantic/Faroe
    {  102, 6821,   57394, 11, }, // Atlantic/St_Helena
    {  102, 2300,    4438,  5, }, // Europe/Athens
    {  102, 6336,   57405,  7, }, // Europe/Belgrade
    {  102, 2167,   22766,  7, }, // Europe/Brussels
    {  102, 3928,   27029,  8, }, // Europe/Bucharest
    {  102, 6289,   57412, 10, }, // Europe/Copenhagen
    {  102, 6307,   57422,  9, }, // Europe/Gibraltar
    {  102, 8788,   57431,  7, }, // Europe/Guernsey
    {  102, 8804,   57438,  9, }, // Europe/Isle_of_Man
    {  102, 1130,   57447,  8, }, // Europe/Istanbul
    {  102, 8823,   57455,  6, }, // Europe/Jersey
    {  102, 3979,   57461, 13, }, // Europe/Kaliningrad
    {  102, 2527,     514,  4, }, // Europe/Kyiv
    {  102, 3213,    4499,  8, }, // Europe/Lisbon
    {  102, 6365,   57474, 11, }, // Europe/Luxembourg
    {  102, 3537,   57485,  6, }, // Europe/Moscow
    {  102, 6275,    8201,  4, }, // Europe/Prague
    {  102, 8837,   57491,  5, }, // Europe/Riga
    {  102, 6324,    6064,  3, }, // Europe/Rome
    {  102, 6202,   57496,  7, }, // Europe/Tirane
    {  102, 6567,   57503, 12, }, // Europe/Vatican
    {  102, 6231,   57515,  4, }, // Europe/Vienna
    {  102, 4727,   57519,  9, }, // Europe/Volgograd
    {  102, 3190,   57528,  8, }, // Europe/Warsaw
    {  102, 6261,   57536,  6, }, // Europe/Zagreb
    {  102, 6540,   57542,  7, }, // Europe/Zurich
    {  102, 7050,   57549,  8, }, // Indian/Maldives
    {  102, 7211,     547,  7, }, // Indian/Reunion
    {  102, 3157,     554,  5, }, // Pacific/Chuuk
    {  102, 6678,   57557, 10, }, // Pacific/Galapagos
    {  102, 6018,   57567,  4, }, // Pacific/Guam
    {  102, 2723,   57571,  8, }, // Pacific/Honolulu
    {  102, 7194,    8422,  7, }, // Pacific/Pitcairn
    {  102, 3096,     586,  7, }, // Pacific/Pohnpei
    {  103,   14,       0,  6, }, // Africa/Asmara Coptic/Coptic/Egypt
    {  103, 4435,       6,  8, }, // Africa/Sao_Tome
    {  103, 4252,      14,  8, }, // America/Asuncion
    {  103,  237,      22,  8, }, // America/Atikokan
    {  103, 7623,      30, 17, }, // America/Bahia_Banderas
    {  103, 3868,      47,  6, }, // America/Cancun
    {  103, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  103, 5723,      66,  7, }, // America/Curacao
    {  103,  481,      73, 13, }, // America/Indiana/Knox
    {  103, 7961,      86, 16, }, // America/Indiana/Marengo
    {  103, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  103, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  103, 8038,     139, 14, }, // America/Indiana/Vevay
    {  103, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  103, 8086,     171, 16, }, // America/Indiana/Winamac
    {  103, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  103, 5932,     207, 22, }, // America/Lower_Princes
    {  103, 8220,     229,  6, }, // America/Merida
    {  103, 1850,     235, 19, }, // America/Noronha
    {  103, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  103, 8329,     274, 20, }, // America/North_Dakota/Center
    {  103, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  103,  393,     317,  4, }, // America/Nuuk
    {  103, 6899,     321, 16, }, // America/Scoresbysund
    {  103, 8508,     337, 14, }, // America/St_Barthelemy
    {  103, 2061,     351, 10, }, // America/St_Johns
    {  103, 5863,     361,  9, }, // America/St_Kitts
    {  103, 5880,     370,  9, }, // America/St_Lucia
    {  103,  855,     379, 10, }, // America/St_Thomas
    {  103, 5913,     389, 11, }, // America/St_Vincent
    {  103, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  103, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  103, 1185,     448,  9, }, // Asia/Kathmandu
    {  103,  992,     457,  7, }, // Asia/Kolkata
    {  103, 1211,     464,  5, }, // Asia/Macau
    {  103, 1235,     477,  6, }, // Asia/Yangon
    {  103, 1395,     483,  5, }, // Atlantic/Faroe
    {  103, 6821,     488, 10, }, // Atlantic/St_Helena
    {  103, 2527,     514,  4, }, // Europe/Kyiv
    {  103, 7211,     547,  7, }, // Indian/Reunion
    {  103, 3157,     554,  5, }, // Pacific/Chuuk
    {  103, 3096,     586,  7, }, // Pacific/Pohnpei
    {  104,   14,       0,  6, }, // Africa/Asmara Cornish/Latin/United Kingdom
    {  104, 4435,       6,  8, }, // Africa/Sao_Tome
    {  104, 4252,      14,  8, }, // America/Asuncion
    {  104,  237,      22,  8, }, // America/Atikokan
    {  104, 7623,      30, 17, }, // America/Bahia_Banderas
    {  104, 3868,      47,  6, }, // America/Cancun
    {  104, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  104, 5723,      66,  7, }, // America/Curacao
    {  104,  481,      73, 13, }, // America/Indiana/Knox
    {  104, 7961,      86, 16, }, // America/Indiana/Marengo
    {  104, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  104, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  104, 8038,     139, 14, }, // America/Indiana/Vevay
    {  104, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  104, 8086,     171, 16, }, // America/Indiana/Winamac
    {  104, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  104, 5932,     207, 22, }, // America/Lower_Princes
    {  104, 8220,     229,  6, }, // America/Merida
    {  104, 1850,     235, 19, }, // America/Noronha
    {  104, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  104, 8329,     274, 20, }, // America/North_Dakota/Center
    {  104, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  104,  393,     317,  4, }, // America/Nuuk
    {  104, 6899,     321, 16, }, // America/Scoresbysund
    {  104, 8508,     337, 14, }, // America/St_Barthelemy
    {  104, 2061,     351, 10, }, // America/St_Johns
    {  104, 5863,     361,  9, }, // America/St_Kitts
    {  104, 5880,     370,  9, }, // America/St_Lucia
    {  104,  855,     379, 10, }, // America/St_Thomas
    {  104, 5913,     389, 11, }, // America/St_Vincent
    {  104, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  104, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  104, 1185,     448,  9, }, // Asia/Kathmandu
    {  104,  992,     457,  7, }, // Asia/Kolkata
    {  104, 1211,     464,  5, }, // Asia/Macau
    {  104, 1235,     477,  6, }, // Asia/Yangon
    {  104, 1395,     483,  5, }, // Atlantic/Faroe
    {  104, 6821,     488, 10, }, // Atlantic/St_Helena
    {  104, 2527,     514,  4, }, // Europe/Kyiv
    {  104, 7211,     547,  7, }, // Indian/Reunion
    {  104, 3157,     554,  5, }, // Pacific/Chuuk
    {  104, 3096,     586,  7, }, // Pacific/Pohnpei
    {  105,   14,       0,  6, }, // Africa/Asmara Corsican/Latin/France
    {  105, 4435,       6,  8, }, // Africa/Sao_Tome
    {  105, 4252,      14,  8, }, // America/Asuncion
    {  105,  237,      22,  8, }, // America/Atikokan
    {  105, 7623,      30, 17, }, // America/Bahia_Banderas
    {  105, 3868,      47,  6, }, // America/Cancun
    {  105, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  105, 5723,      66,  7, }, // America/Curacao
    {  105,  481,      73, 13, }, // America/Indiana/Knox
    {  105, 7961,      86, 16, }, // America/Indiana/Marengo
    {  105, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  105, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  105, 8038,     139, 14, }, // America/Indiana/Vevay
    {  105, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  105, 8086,     171, 16, }, // America/Indiana/Winamac
    {  105, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  105, 5932,     207, 22, }, // America/Lower_Princes
    {  105, 8220,     229,  6, }, // America/Merida
    {  105, 1850,     235, 19, }, // America/Noronha
    {  105, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  105, 8329,     274, 20, }, // America/North_Dakota/Center
    {  105, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  105,  393,     317,  4, }, // America/Nuuk
    {  105, 6899,     321, 16, }, // America/Scoresbysund
    {  105, 8508,     337, 14, }, // America/St_Barthelemy
    {  105, 2061,     351, 10, }, // America/St_Johns
    {  105, 5863,     361,  9, }, // America/St_Kitts
    {  105, 5880,     370,  9, }, // America/St_Lucia
    {  105,  855,     379, 10, }, // America/St_Thomas
    {  105, 5913,     389, 11, }, // America/St_Vincent
    {  105, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  105, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  105, 1185,     448,  9, }, // Asia/Kathmandu
    {  105,  992,     457,  7, }, // Asia/Kolkata
    {  105, 1211,     464,  5, }, // Asia/Macau
    {  105, 1235,     477,  6, }, // Asia/Yangon
    {  105, 1395,     483,  5, }, // Atlantic/Faroe
    {  105, 6821,     488, 10, }, // Atlantic/St_Helena
    {  105, 2527,     514,  4, }, // Europe/Kyiv
    {  105, 7211,     547,  7, }, // Indian/Reunion
    {  105, 3157,     554,  5, }, // Pacific/Chuuk
    {  105, 3096,     586,  7, }, // Pacific/Pohnpei
    {  106, 5059,    3902, 11, }, // Africa/Addis_Ababa Croatian/Latin/Croatia
    {  106, 7420,   57579,  5, }, // Africa/Algiers
    {  106,   14,       0,  6, }, // Africa/Asmara
    {  106, 2320,    4690,  5, }, // Africa/Cairo
    {  106, 5043,   33286,  7, }, // Africa/Djibouti
    {  106, 6869,   20418,  4, }, // Africa/Lome
    {  106, 4435,       6,  8, }, // Africa/Sao_Tome
    {  106, 5607,   33300,  7, }, // America/Anguilla
    {  106, 4252,      14,  8, }, // America/Asuncion
    {  106,  237,      22,  8, }, // America/Atikokan
    {  106, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  106, 3868,   33314,  6, }, // America/Cancun
    {  106, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  106, 5422,   33320,  9, }, // America/Costa_Rica
    {  106, 5723,      66,  7, }, // America/Curacao
    {  106, 5739,   21666,  8, }, // America/Dominica
    {  106, 5441,    6806,  8, }, // America/El_Salvador
    {  106, 5786,   20526,  9, }, // America/Guadeloupe
    {  106, 3760,   33338,  9, }, // America/Guatemala
    {  106, 6932,   57584,  7, }, // America/Guyana
    {  106,  481,      73, 13, }, // America/Indiana/Knox
    {  106, 7961,      86, 16, }, // America/Indiana/Marengo
    {  106, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  106, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  106, 8038,     139, 14, }, // America/Indiana/Vevay
    {  106, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  106, 8086,     171, 16, }, // America/Indiana/Winamac
    {  106, 2799,   33347,  7, }, // America/Jamaica
    {  106, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  106, 5932,     207, 22, }, // America/Lower_Princes
    {  106, 8220,    7126,  6, }, // America/Merida
    {  106, 2949,   57591, 16, }, // America/Mexico_City
    {  106, 1850,     235, 19, }, // America/Noronha
    {  106, 8301,   33354, 23, }, // America/North_Dakota/Beulah
    {  106, 8329,   33377, 23, }, // America/North_Dakota/Center
    {  106, 8357,   33400, 26, }, // America/North_Dakota/New_Salem
    {  106,  393,     317,  4, }, // America/Nuuk
    {  106, 5843,   33426,  9, }, // America/Puerto_Rico
    {  106, 6899,     321, 16, }, // America/Scoresbysund
    {  106, 8508,   35936, 16, }, // America/St_Barthelemy
    {  106, 2061,     351, 10, }, // America/St_Johns
    {  106, 5863,     361,  9, }, // America/St_Kitts
    {  106, 5880,     370,  9, }, // America/St_Lucia
    {  106,  855,     379, 10, }, // America/St_Thomas
    {  106, 5913,     389, 11, }, // America/St_Vincent
    {  106, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  106, 5395,   57607,  8, }, // Asia/Almaty
    {  106, 5511,    7600,  6, }, // Asia/Anadyr
    {  106, 5523,    5609,  5, }, // Asia/Aqtau
    {  106, 5368,    7606,  6, }, // Asia/Aqtobe
    {  106,  964,   57615,  7, }, // Asia/Ashgabat
    {  106, 3607,    4162,  6, }, // Asia/Baghdad
    {  106, 5534,    4168,  7, }, // Asia/Bahrain
    {  106, 3778,   33455,  6, }, // Asia/Bishkek
    {  106, 5989,   33461,  6, }, // Asia/Brunei
    {  106, 4601,   57622,  4, }, // Asia/Chita
    {  106, 4540,    4201,  6, }, // Asia/Damascus
    {  106, 6159,   33468,  7, }, // Asia/Dushanbe
    {  106, 1259,   33475,  9, }, // Asia/Ho_Chi_Minh
    {  106, 7006,   33484,  8, }, // Asia/Jakarta
    {  106, 1290,   33501,  9, }, // Asia/Jerusalem
    {  106, 4316,   33510,  8, }, // Asia/Kamchatka
    {  106, 4239,   33518,  6, }, // Asia/Karachi
    {  106, 1185,    5711,  8, }, // Asia/Kathmandu
    {  106, 8661,   33524,  7, }, // Asia/Khandyga
    {  106,  992,     457,  7, }, // Asia/Kolkata
    {  106, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  106, 5547,    7725,  6, }, // Asia/Kuwait
    {  106, 1211,    7731,  5, }, // Asia/Macau
    {  106, 2554,   33542,  8, }, // Asia/Nicosia
    {  106, 8675,   33550, 12, }, // Asia/Novokuznetsk
    {  106, 4214,   33562,  9, }, // Asia/Pyongyang
    {  106, 5559,    4332,  5, }, // Asia/Qatar
    {  106, 8708,     469,  8, }, // Asia/Qostanay
    {  106, 4269,    7778,  9, }, // Asia/Qyzylorda
    {  106, 3584,   33571,  5, }, // Asia/Riyadh
    {  106, 4408,   33576,  7, }, // Asia/Sakhalin
    {  106, 3279,    7798,  4, }, // Asia/Seoul
    {  106, 1053,   33583,  6, }, // Asia/Shanghai
    {  106, 3300,   20900,  8, }, // Asia/Singapore
    {  106, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {  106, 4781,   33589,  7, }, // Asia/Tashkent
    {  106, 2772,    7842,  7, }, // Asia/Tehran
    {  106, 2821,    4356,  5, }, // Asia/Tokyo
    {  106, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {  106, 1159,   33596,  6, }, // Asia/Urumqi
    {  106, 4828,    7873,  7, }, // Asia/Yakutsk
    {  106, 1235,    7880,  6, }, // Asia/Yangon
    {  106, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  106, 3747,   26947,  6, }, // Asia/Yerevan
    {  106, 3663,   33612,  5, }, // Atlantic/Azores
    {  106, 5671,   57626,  7, }, // Atlantic/Bermuda
    {  106, 6628,    4398,  6, }, // Atlantic/Canary
    {  106, 1395,   57633, 14, }, // Atlantic/Faroe
    {  106, 7272,   57647, 14, }, // Atlantic/South_Georgia
    {  106, 6821,   33626, 12, }, // Atlantic/St_Helena
    {  106, 6216,   33638,  6, }, // Europe/Andorra
    {  106, 3620,   33644,  8, }, // Europe/Astrakhan
    {  106, 2300,   27009,  5, }, // Europe/Athens
    {  106, 6336,    8060,  7, }, // Europe/Belgrade
    {  106, 2167,   57661,  9, }, // Europe/Brussels
    {  106, 3928,   33663,  8, }, // Europe/Bucharest
    {  106, 3806,   33671, 10, }, // Europe/Budapest
    {  106, 2583,   33681,  8, }, // Europe/Chisinau
    {  106, 6289,    4475, 10, }, // Europe/Copenhagen
    {  106, 8804,   57670,  8, }, // Europe/Isle_of_Man
    {  106, 3979,   33711, 12, }, // Europe/Kaliningrad
    {  106, 2527,   33723,  5, }, // Europe/Kyiv
    {  106, 3213,   33728,  7, }, // Europe/Lisbon
    {  106, 6365,    8172, 10, }, // Europe/Luxembourg
    {  106, 6410,    6044,  6, }, // Europe/Monaco
    {  106, 3537,   22880,  6, }, // Europe/Moscow
    {  106, 4284,   33735,  5, }, // Europe/Paris
    {  106, 6275,    8201,  4, }, // Europe/Prague
    {  106, 6324,   33740,  3, }, // Europe/Rome
    {  106, 8849,   33743, 11, }, // Europe/Simferopol
    {  106, 6383,   33754,  7, }, // Europe/Skopje
    {  106, 6599,   33761,  6, }, // Europe/Sofia
    {  106, 6202,   21213,  6, }, // Europe/Tirane
    {  106, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {  106, 6567,    6096,  7, }, // Europe/Vatican
    {  106, 6231,   33775,  3, }, // Europe/Vienna
    {  106, 3190,   33778,  7, }, // Europe/Warsaw
    {  106, 6540,    4577,  6, }, // Europe/Zurich
    {  106, 7050,   33819,  7, }, // Indian/Maldives
    {  106, 4069,   33826, 10, }, // Indian/Mauritius
    {  106, 7211,     547,  7, }, // Indian/Reunion
    {  106, 3157,     554,  5, }, // Pacific/Chuuk
    {  106, 3902,   33836,  5, }, // Pacific/Fiji
    {  106, 2723,    4611,  8, }, // Pacific/Honolulu
    {  106, 3049,    4619,  9, }, // Pacific/Kanton
    {  106, 4051,   57678, 18, }, // Pacific/Marquesas
    {  106, 3096,     586,  7, }, // Pacific/Pohnpei
    {  108, 6788,   57696,  7, }, // Africa/Abidjan Czech/Latin/Czechia
    {  108, 5059,    3902, 11, }, // Africa/Addis_Ababa
    {  108, 7420,   57703,  5, }, // Africa/Algiers
    {  108,   14,       0,  6, }, // Africa/Asmara
    {  108, 2320,   57708,  6, }, // Africa/Cairo
    {  108, 5043,   33286,  7, }, // Africa/Djibouti
    {  108, 4524,   57714,  7, }, // Africa/Khartoum
    {  108, 6869,   20418,  4, }, // Africa/Lome
    {  108, 5113,   57721,  8, }, // Africa/Mogadishu
    {  108, 5271,   57729,  8, }, // Africa/Ndjamena
    {  108, 6803,   57737,  8, }, // Africa/Nouakchott
    {  108, 4435,   57745, 11, }, // Africa/Sao_Tome
    {  108, 2866,   57756,  8, }, // Africa/Tripoli
    {  108,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  108, 4252,      14,  8, }, // America/Asuncion
    {  108,  237,      22,  8, }, // America/Atikokan
    {  108, 3679,      30,  5, }, // America/Bahia
    {  108, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  108, 7646,   35896,  5, }, // America/Belem
    {  108, 4361,   20507,  6, }, // America/Bogota
    {  108, 3868,      47,  6, }, // America/Cancun
    {  108, 5496,   57764, 17, }, // America/Cayman
    {  108, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  108, 5422,   33320,  9, }, // America/Costa_Rica
    {  108, 5723,      66,  7, }, // America/Curacao
    {  108, 5739,   21666,  8, }, // America/Dominica
    {  108, 5441,    6806,  8, }, // America/El_Salvador
    {  108,  481,      73, 13, }, // America/Indiana/Knox
    {  108, 7961,      86, 16, }, // America/Indiana/Marengo
    {  108, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  108, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  108, 8038,     139, 14, }, // America/Indiana/Vevay
    {  108, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  108, 8086,     171, 16, }, // America/Indiana/Winamac
    {  108, 2799,   33347,  7, }, // America/Jamaica
    {  108, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  108, 5932,     207, 22, }, // America/Lower_Princes
    {  108, 5805,    5260,  8, }, // America/Martinique
    {  108, 2917,   26603,  8, }, // America/Mazatlan
    {  108, 8220,    7126,  6, }, // America/Merida
    {  108, 2949,   57591, 16, }, // America/Mexico_City
    {  108, 1850,     235, 19, }, // America/Noronha
    {  108, 8301,   57781, 22, }, // America/North_Dakota/Beulah
    {  108, 8329,   57803, 22, }, // America/North_Dakota/Center
    {  108, 8357,   57825, 25, }, // America/North_Dakota/New_Salem
    {  108,  393,     317,  4, }, // America/Nuuk
    {  108, 5843,   33426,  9, }, // America/Puerto_Rico
    {  108, 8477,   26704,  8, }, // America/Santarem
    {  108, 1878,   26712,  9, }, // America/Sao_Paulo
    {  108, 6899,     321, 16, }, // America/Scoresbysund
    {  108, 8508,   57850, 16, }, // America/St_Barthelemy
    {  108, 2061,     351, 10, }, // America/St_Johns
    {  108, 5863,   57866, 13, }, // America/St_Kitts
    {  108, 5880,   57879, 11, }, // America/St_Lucia
    {  108,  855,   57890, 21, }, // America/St_Thomas
    {  108, 5913,   57911, 13, }, // America/St_Vincent
    {  108, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  108, 3968,   57924,  5, }, // Asia/Amman
    {  108, 5523,    5609,  5, }, // Asia/Aqtau
    {  108, 5368,    7606,  6, }, // Asia/Aqtobe
    {  108,  964,   57929,  8, }, // Asia/Ashgabat
    {  108, 3607,   57937,  6, }, // Asia/Baghdad
    {  108, 5534,   57943,  7, }, // Asia/Bahrain
    {  108, 4086,   57950,  6, }, // Asia/Beirut
    {  108, 3778,   33455,  6, }, // Asia/Bishkek
    {  108, 5989,   33461,  6, }, // Asia/Brunei
    {  108, 4601,   57622,  4, }, // Asia/Chita
    {  108, 4511,    5637,  7, }, // Asia/Colombo
    {  108, 4540,   57956,  7, }, // Asia/Damascus
    {  108, 1093,   57963,  5, }, // Asia/Dhaka
    {  108, 3596,   57968,  5, }, // Asia/Dubai
    {  108, 6159,   33468,  7, }, // Asia/Dushanbe
    {  108, 1259,   57973, 18, }, // Asia/Ho_Chi_Minh
    {  108, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  108, 1290,   57991,  9, }, // Asia/Jerusalem
    {  108, 3560,   58000,  5, }, // Asia/Kabul
    {  108, 4316,   33510,  8, }, // Asia/Kamchatka
    {  108, 4239,   58005,  6, }, // Asia/Karachi
    {  108, 1185,   58011,  9, }, // Asia/Kathmandu
    {  108, 8661,   58020,  8, }, // Asia/Khandyga
    {  108,  992,   58028,  7, }, // Asia/Kolkata
    {  108, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  108, 5976,   33531,  6, }, // Asia/Kuching
    {  108, 5547,    7725,  6, }, // Asia/Kuwait
    {  108, 1211,     464,  5, }, // Asia/Macau
    {  108, 6920,   26882,  6, }, // Asia/Muscat
    {  108, 2554,   58035,  7, }, // Asia/Nicosia
    {  108, 8675,   58042, 11, }, // Asia/Novokuznetsk
    {  108, 7145,   58053,  6, }, // Asia/Oral
    {  108, 6961,   58059,  9, }, // Asia/Phnom_Penh
    {  108, 4214,   58068, 11, }, // Asia/Pyongyang
    {  108, 5559,    4332,  5, }, // Asia/Qatar
    {  108, 8708,    7770,  8, }, // Asia/Qostanay
    {  108, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  108, 3584,   58079,  5, }, // Asia/Riyadh
    {  108, 4408,   58084,  8, }, // Asia/Sakhalin
    {  108, 3279,   58092,  4, }, // Asia/Seoul
    {  108, 1053,   58096,  7, }, // Asia/Shanghai
    {  108, 3300,   20900,  8, }, // Asia/Singapore
    {  108, 4297,   58103, 13, }, // Asia/Srednekolymsk
    {  108, 3263,   58116,  9, }, // Asia/Taipei
    {  108, 4781,   33589,  7, }, // Asia/Tashkent
    {  108, 2772,   58125,  7, }, // Asia/Tehran
    {  108, 1317,   58132,  6, }, // Asia/Thimphu
    {  108, 2821,    4356,  5, }, // Asia/Tokyo
    {  108, 1021,   58138,  9, }, // Asia/Ulaanbaatar
    {  108, 1159,   33596,  6, }, // Asia/Urumqi
    {  108, 4828,    7873,  7, }, // Asia/Yakutsk
    {  108, 1235,   20937,  6, }, // Asia/Yangon
    {  108, 3883,   58147, 13, }, // Asia/Yekaterinburg
    {  108, 3747,    7898,  7, }, // Asia/Yerevan
    {  108, 3663,   58160, 15, }, // Atlantic/Azores
    {  108, 5671,   58175,  7, }, // Atlantic/Bermuda
    {  108, 6628,   58182, 16, }, // Atlantic/Canary
    {  108, 3727,   58198,  8, }, // Atlantic/Cape_Verde
    {  108, 1395,   58206, 15, }, // Atlantic/Faroe
    {  108, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  108, 7272,   58221, 13, }, // Atlantic/South_Georgia
    {  108, 6821,   58234, 12, }, // Atlantic/St_Helena
    {  108, 3620,   58246,  9, }, // Europe/Astrakhan
    {  108, 2300,   58255,  6, }, // Europe/Athens
    {  108, 6336,   58261,  8, }, // Europe/Belgrade
    {  108, 4757,   21059,  6, }, // Europe/Berlin
    {  108, 2167,   27022,  6, }, // Europe/Brussels
    {  108, 3928,   58269,  8, }, // Europe/Bucharest
    {  108, 3806,   58277,  8, }, // Europe/Budapest
    {  108, 2583,   58285,  7, }, // Europe/Chisinau
    {  108, 6289,   58292,  5, }, // Europe/Copenhagen
    {  108, 6612,   58297,  8, }, // Europe/Helsinki
    {  108, 8804,   58305, 10, }, // Europe/Isle_of_Man
    {  108, 2527,   58315,  5, }, // Europe/Kyiv
    {  108, 3213,   33728,  7, }, // Europe/Lisbon
    {  108, 6506,   58320,  6, }, // Europe/Ljubljana
    {  108, 2501,   58326,  6, }, // Europe/London
    {  108, 6365,   58332,  9, }, // Europe/Luxembourg
    {  108, 6410,    6044,  6, }, // Europe/Monaco
    {  108, 3537,   22880,  6, }, // Europe/Moscow
    {  108, 4284,   58341,  5, }, // Europe/Paris
    {  108, 6275,   36285,  5, }, // Europe/Prague
    {  108, 6324,   58346,  3, }, // Europe/Rome
    {  108, 6599,   58349,  5, }, // Europe/Sofia
    {  108, 6202,   21213,  6, }, // Europe/Tirane
    {  108, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {  108, 6567,   58354,  7, }, // Europe/Vatican
    {  108, 6231,   58361,  5, }, // Europe/Vienna
    {  108, 3190,   33778,  7, }, // Europe/Warsaw
    {  108, 6261,   58366,  6, }, // Europe/Zagreb
    {  108, 6540,   58372,  6, }, // Europe/Zurich
    {  108, 6046,   58378, 14, }, // Indian/Christmas
    {  108, 6063,   58392, 16, }, // Indian/Cocos
    {  108, 5029,   58408,  6, }, // Indian/Comoro
    {  108, 6661,   58414, 20, }, // Indian/Kerguelen
    {  108, 7260,   27115,  4, }, // Indian/Mahe
    {  108, 7050,   58434,  8, }, // Indian/Maldives
    {  108, 4069,   58442,  9, }, // Indian/Mauritius
    {  108, 7211,     547,  7, }, // Indian/Reunion
    {  108, 3015,   58451, 18, }, // Pacific/Chatham
    {  108, 3157,   58469, 16, }, // Pacific/Chuuk
    {  108, 2237,   58485, 18, }, // Pacific/Easter
    {  108, 7360,   27148,  5, }, // Pacific/Efate
    {  108, 3902,   33836,  5, }, // Pacific/Fiji
    {  108, 6678,   58503,  8, }, // Pacific/Galapagos
    {  108, 6696,   58511, 18, }, // Pacific/Gambier
    {  108, 2723,    4611,  8, }, // Pacific/Honolulu
    {  108, 3049,    4619,  9, }, // Pacific/Kanton
    {  108, 4051,   58529,  7, }, // Pacific/Marquesas
    {  108, 7098,    4628,  6, }, // Pacific/Noumea
    {  108, 7194,   58536, 19, }, // Pacific/Pitcairn
    {  108, 3096,     586,  7, }, // Pacific/Pohnpei
    {  109, 5059,    3902, 11, }, // Africa/Addis_Ababa Danish/Latin/Denmark
    {  109, 7420,   58555,  6, }, // Africa/Algiers
    {  109,   14,       0,  6, }, // Africa/Asmara
    {  109, 4435,       6,  8, }, // Africa/Sao_Tome
    {  109, 4252,      14,  8, }, // America/Asuncion
    {  109,  237,      22,  8, }, // America/Atikokan
    {  109, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  109, 3868,   33314,  6, }, // America/Cancun
    {  109, 5496,   58561, 11, }, // America/Cayman
    {  109, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  109, 5723,      66,  7, }, // America/Curacao
    {  109,  481,      73, 13, }, // America/Indiana/Knox
    {  109, 7961,      86, 16, }, // America/Indiana/Marengo
    {  109, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  109, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  109, 8038,     139, 14, }, // America/Indiana/Vevay
    {  109, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  109, 8086,     171, 16, }, // America/Indiana/Winamac
    {  109, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  109, 5932,     207, 22, }, // America/Lower_Princes
    {  109, 8220,    7126,  6, }, // America/Merida
    {  109, 1850,     235, 19, }, // America/Noronha
    {  109, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  109, 8329,     274, 20, }, // America/North_Dakota/Center
    {  109, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  109,  393,     317,  4, }, // America/Nuuk
    {  109, 1878,   26712,  9, }, // America/Sao_Paulo
    {  109, 6899,     321, 16, }, // America/Scoresbysund
    {  109, 8508,   26721, 16, }, // America/St_Barthelemy
    {  109, 2061,     351, 10, }, // America/St_Johns
    {  109, 5863,     361,  9, }, // America/St_Kitts
    {  109, 5880,     370,  9, }, // America/St_Lucia
    {  109,  855,     379, 10, }, // America/St_Thomas
    {  109, 5913,     389, 11, }, // America/St_Vincent
    {  109, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  109, 5523,    5609,  5, }, // Asia/Aqtau
    {  109, 5368,    7606,  6, }, // Asia/Aqtobe
    {  109,  964,   58572,  9, }, // Asia/Ashgabat
    {  109, 3607,    4162,  6, }, // Asia/Baghdad
    {  109, 3778,    4187,  7, }, // Asia/Bishkek
    {  109, 4540,    4201,  8, }, // Asia/Damascus
    {  109, 6159,   58581,  8, }, // Asia/Dushanbe
    {  109, 1259,     432, 16, }, // Asia/Ho_Chi_Minh
    {  109, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  109, 4316,   58589,  9, }, // Asia/Kamchatka
    {  109, 1185,    5711,  8, }, // Asia/Kathmandu
    {  109,  992,     457,  7, }, // Asia/Kolkata
    {  109, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  109, 1211,     464,  5, }, // Asia/Macau
    {  109, 8675,   58598, 12, }, // Asia/Novokuznetsk
    {  109, 8708,     469,  8, }, // Asia/Qostanay
    {  109, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  109, 4781,   58610,  8, }, // Asia/Tashkent
    {  109, 2772,    7842,  7, }, // Asia/Tehran
    {  109, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {  109, 1159,   26933,  6, }, // Asia/Urumqi
    {  109, 4828,    7873,  7, }, // Asia/Yakutsk
    {  109, 1235,   58618,  7, }, // Asia/Yangon
    {  109, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  109, 3747,    7898,  7, }, // Asia/Yerevan
    {  109, 3663,   58625,  8, }, // Atlantic/Azores
    {  109, 6628,   58633, 16, }, // Atlantic/Canary
    {  109, 3727,   57380,  9, }, // Atlantic/Cape_Verde
    {  109, 1395,   58649,  8, }, // Atlantic/Faroe
    {  109, 6821,     488, 10, }, // Atlantic/St_Helena
    {  109, 2300,    4438,  5, }, // Europe/Athens
    {  109, 6336,    8060,  7, }, // Europe/Belgrade
    {  109, 2167,   57661,  9, }, // Europe/Brussels
    {  109, 3928,   27029,  8, }, // Europe/Bucharest
    {  109, 6289,   58657,  9, }, // Europe/Copenhagen
    {  109, 2527,    8148,  4, }, // Europe/Kyiv
    {  109, 3213,    4499,  8, }, // Europe/Lisbon
    {  109, 3537,   22880,  6, }, // Europe/Moscow
    {  109, 6275,    8201,  4, }, // Europe/Prague
    {  109, 6324,    6064,  3, }, // Europe/Rome
    {  109, 6202,   21213,  6, }, // Europe/Tirane
    {  109, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {  109, 6567,   58666,  9, }, // Europe/Vatican
    {  109, 6231,   57515,  4, }, // Europe/Vienna
    {  109, 3190,   58675,  8, }, // Europe/Warsaw
    {  109, 6540,    4577,  6, }, // Europe/Zurich
    {  109, 6046,   58683,  7, }, // Indian/Christmas
    {  109, 5029,   58690,  9, }, // Indian/Comoro
    {  109, 7050,   58699, 10, }, // Indian/Maldives
    {  109, 7211,     547,  7, }, // Indian/Reunion
    {  109, 3157,     554,  5, }, // Pacific/Chuuk
    {  109, 2237,   58709,  8, }, // Pacific/Easter
    {  109, 2723,    4611,  8, }, // Pacific/Honolulu
    {  109, 3049,    4619,  9, }, // Pacific/Kanton
    {  109, 3096,     586,  7, }, // Pacific/Pohnpei
    {  111,   14,       0,  6, }, // Africa/Asmara Divehi/Thaana/Maldives
    {  111, 4435,       6,  8, }, // Africa/Sao_Tome
    {  111, 4252,      14,  8, }, // America/Asuncion
    {  111,  237,      22,  8, }, // America/Atikokan
    {  111, 7623,      30, 17, }, // America/Bahia_Banderas
    {  111, 3868,      47,  6, }, // America/Cancun
    {  111, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  111, 5723,      66,  7, }, // America/Curacao
    {  111,  481,      73, 13, }, // America/Indiana/Knox
    {  111, 7961,      86, 16, }, // America/Indiana/Marengo
    {  111, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  111, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  111, 8038,     139, 14, }, // America/Indiana/Vevay
    {  111, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  111, 8086,     171, 16, }, // America/Indiana/Winamac
    {  111, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  111, 5932,     207, 22, }, // America/Lower_Princes
    {  111, 8220,     229,  6, }, // America/Merida
    {  111, 1850,     235, 19, }, // America/Noronha
    {  111, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  111, 8329,     274, 20, }, // America/North_Dakota/Center
    {  111, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  111,  393,     317,  4, }, // America/Nuuk
    {  111, 6899,     321, 16, }, // America/Scoresbysund
    {  111, 8508,     337, 14, }, // America/St_Barthelemy
    {  111, 2061,     351, 10, }, // America/St_Johns
    {  111, 5863,     361,  9, }, // America/St_Kitts
    {  111, 5880,     370,  9, }, // America/St_Lucia
    {  111,  855,     379, 10, }, // America/St_Thomas
    {  111, 5913,     389, 11, }, // America/St_Vincent
    {  111, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  111, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  111, 1185,     448,  9, }, // Asia/Kathmandu
    {  111,  992,     457,  7, }, // Asia/Kolkata
    {  111, 1211,     464,  5, }, // Asia/Macau
    {  111, 1235,     477,  6, }, // Asia/Yangon
    {  111, 1395,     483,  5, }, // Atlantic/Faroe
    {  111, 6821,     488, 10, }, // Atlantic/St_Helena
    {  111, 2527,     514,  4, }, // Europe/Kyiv
    {  111, 7211,     547,  7, }, // Indian/Reunion
    {  111, 3157,     554,  5, }, // Pacific/Chuuk
    {  111, 3096,     586,  7, }, // Pacific/Pohnpei
    {  112,   14,       0,  6, }, // Africa/Asmara Dogri/Devanagari/India
    {  112, 4435,       6,  8, }, // Africa/Sao_Tome
    {  112, 4252,      14,  8, }, // America/Asuncion
    {  112,  237,      22,  8, }, // America/Atikokan
    {  112, 7623,      30, 17, }, // America/Bahia_Banderas
    {  112, 3868,      47,  6, }, // America/Cancun
    {  112, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  112, 5723,      66,  7, }, // America/Curacao
    {  112,  481,      73, 13, }, // America/Indiana/Knox
    {  112, 7961,      86, 16, }, // America/Indiana/Marengo
    {  112, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  112, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  112, 8038,     139, 14, }, // America/Indiana/Vevay
    {  112, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  112, 8086,     171, 16, }, // America/Indiana/Winamac
    {  112, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  112, 5932,     207, 22, }, // America/Lower_Princes
    {  112, 8220,     229,  6, }, // America/Merida
    {  112, 1850,     235, 19, }, // America/Noronha
    {  112, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  112, 8329,     274, 20, }, // America/North_Dakota/Center
    {  112, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  112,  393,     317,  4, }, // America/Nuuk
    {  112, 6899,     321, 16, }, // America/Scoresbysund
    {  112, 8508,     337, 14, }, // America/St_Barthelemy
    {  112, 2061,     351, 10, }, // America/St_Johns
    {  112, 5863,     361,  9, }, // America/St_Kitts
    {  112, 5880,     370,  9, }, // America/St_Lucia
    {  112,  855,     379, 10, }, // America/St_Thomas
    {  112, 5913,     389, 11, }, // America/St_Vincent
    {  112, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  112, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  112, 1185,     448,  9, }, // Asia/Kathmandu
    {  112,  992,     457,  7, }, // Asia/Kolkata
    {  112, 1211,     464,  5, }, // Asia/Macau
    {  112, 1235,     477,  6, }, // Asia/Yangon
    {  112, 1395,     483,  5, }, // Atlantic/Faroe
    {  112, 6821,     488, 10, }, // Atlantic/St_Helena
    {  112, 2527,     514,  4, }, // Europe/Kyiv
    {  112, 7211,     547,  7, }, // Indian/Reunion
    {  112, 3157,     554,  5, }, // Pacific/Chuuk
    {  112, 3096,     586,  7, }, // Pacific/Pohnpei
    {  113,   14,       0,  6, }, // Africa/Asmara Duala/Latin/Cameroon
    {  113, 4435,       6,  8, }, // Africa/Sao_Tome
    {  113, 4252,      14,  8, }, // America/Asuncion
    {  113,  237,      22,  8, }, // America/Atikokan
    {  113, 7623,      30, 17, }, // America/Bahia_Banderas
    {  113, 3868,      47,  6, }, // America/Cancun
    {  113, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  113, 5723,      66,  7, }, // America/Curacao
    {  113,  481,      73, 13, }, // America/Indiana/Knox
    {  113, 7961,      86, 16, }, // America/Indiana/Marengo
    {  113, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  113, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  113, 8038,     139, 14, }, // America/Indiana/Vevay
    {  113, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  113, 8086,     171, 16, }, // America/Indiana/Winamac
    {  113, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  113, 5932,     207, 22, }, // America/Lower_Princes
    {  113, 8220,     229,  6, }, // America/Merida
    {  113, 1850,     235, 19, }, // America/Noronha
    {  113, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  113, 8329,     274, 20, }, // America/North_Dakota/Center
    {  113, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  113,  393,     317,  4, }, // America/Nuuk
    {  113, 6899,     321, 16, }, // America/Scoresbysund
    {  113, 8508,     337, 14, }, // America/St_Barthelemy
    {  113, 2061,     351, 10, }, // America/St_Johns
    {  113, 5863,     361,  9, }, // America/St_Kitts
    {  113, 5880,     370,  9, }, // America/St_Lucia
    {  113,  855,     379, 10, }, // America/St_Thomas
    {  113, 5913,     389, 11, }, // America/St_Vincent
    {  113, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  113, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  113, 1185,     448,  9, }, // Asia/Kathmandu
    {  113,  992,     457,  7, }, // Asia/Kolkata
    {  113, 1211,     464,  5, }, // Asia/Macau
    {  113, 1235,     477,  6, }, // Asia/Yangon
    {  113, 1395,     483,  5, }, // Atlantic/Faroe
    {  113, 6821,     488, 10, }, // Atlantic/St_Helena
    {  113, 2527,     514,  4, }, // Europe/Kyiv
    {  113, 7211,     547,  7, }, // Indian/Reunion
    {  113, 3157,     554,  5, }, // Pacific/Chuuk
    {  113, 3096,     586,  7, }, // Pacific/Pohnpei
    {  114, 5059,    3902, 11, }, // Africa/Addis_Ababa Dutch/Latin/Netherlands
    {  114,   14,       0,  6, }, // Africa/Asmara
    {  114, 2320,   58717,  5, }, // Africa/Cairo
    {  114, 4524,   58722,  8, }, // Africa/Khartoum
    {  114, 6869,   20418,  4, }, // Africa/Lome
    {  114, 4435,   58730,  8, }, // Africa/Sao_Tome
    {  114,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  114, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  114, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  114, 4252,      14,  8, }, // America/Asuncion
    {  114,  237,      22,  8, }, // America/Atikokan
    {  114, 7623,      30, 17, }, // America/Bahia_Banderas
    {  114, 7646,   35896,  5, }, // America/Belem
    {  114, 3868,   33314,  6, }, // America/Cancun
    {  114, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  114, 3791,   26574,  6, }, // America/Cuiaba
    {  114, 5723,      66,  7, }, // America/Curacao
    {  114,  481,      73, 13, }, // America/Indiana/Knox
    {  114, 7961,      86, 16, }, // America/Indiana/Marengo
    {  114, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  114, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  114, 8038,     139, 14, }, // America/Indiana/Vevay
    {  114, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  114, 8086,     171, 16, }, // America/Indiana/Winamac
    {  114, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  114, 5932,   58738, 24, }, // America/Lower_Princes
    {  114, 8153,   26588,  6, }, // America/Maceio
    {  114, 2917,   26603,  8, }, // America/Mazatlan
    {  114, 8220,     229,  6, }, // America/Merida
    {  114, 2949,   58762, 11, }, // America/Mexico_City
    {  114, 1850,     235, 19, }, // America/Noronha
    {  114, 8301,    4013, 20, }, // America/North_Dakota/Beulah
    {  114, 8329,    4033, 20, }, // America/North_Dakota/Center
    {  114, 8357,    4053, 23, }, // America/North_Dakota/New_Salem
    {  114,  393,     317,  4, }, // America/Nuuk
    {  114, 1878,   26712,  9, }, // America/Sao_Paulo
    {  114, 6899,     321, 16, }, // America/Scoresbysund
    {  114, 8508,   26721, 16, }, // America/St_Barthelemy
    {  114, 2061,   26737, 12, }, // America/St_Johns
    {  114, 5863,   26749, 11, }, // America/St_Kitts
    {  114, 5880,   35964, 11, }, // America/St_Lucia
    {  114,  855,   44293, 12, }, // America/St_Thomas
    {  114, 5913,   26783, 13, }, // America/St_Vincent
    {  114, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  114, 5395,   58773,  8, }, // Asia/Almaty
    {  114, 5368,   57205,  6, }, // Asia/Aqtobe
    {  114,  964,    4153,  9, }, // Asia/Ashgabat
    {  114, 8624,   58781,  6, }, // Asia/Atyrau
    {  114, 3607,    4162,  6, }, // Asia/Baghdad
    {  114, 5534,    4168,  7, }, // Asia/Bahrain
    {  114, 3653,    4175,  5, }, // Asia/Baku
    {  114, 4086,    4180,  7, }, // Asia/Beirut
    {  114, 3778,    4187,  7, }, // Asia/Bishkek
    {  114, 6159,   58787,  9, }, // Asia/Dushanbe
    {  114, 1259,   58796, 15, }, // Asia/Ho_Chi_Minh
    {  114, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  114, 4184,    4239,  8, }, // Asia/Irkutsk
    {  114, 1290,   33501,  9, }, // Asia/Jerusalem
    {  114, 4316,    4261, 10, }, // Asia/Kamchatka
    {  114, 1185,     448,  9, }, // Asia/Kathmandu
    {  114,  992,   36053,  8, }, // Asia/Kolkata
    {  114, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  114, 5547,    4314,  7, }, // Asia/Kuwait
    {  114, 1211,    4321,  5, }, // Asia/Macau
    {  114, 7182,   58811,  7, }, // Asia/Manila
    {  114, 3584,   20874,  5, }, // Asia/Riyadh
    {  114, 4408,   58084,  8, }, // Asia/Sakhalin
    {  114, 1053,   58818,  8, }, // Asia/Shanghai
    {  114, 4781,   58610,  8, }, // Asia/Tashkent
    {  114, 2772,    7842,  7, }, // Asia/Tehran
    {  114, 2821,    4356,  5, }, // Asia/Tokyo
    {  114, 4828,    4372,  8, }, // Asia/Yakutsk
    {  114, 1235,   58618,  7, }, // Asia/Yangon
    {  114, 3883,   58826, 15, }, // Asia/Yekaterinburg
    {  114, 3747,    7898,  7, }, // Asia/Yerevan
    {  114, 3663,   58841,  6, }, // Atlantic/Azores
    {  114, 6628,   58847, 19, }, // Atlantic/Canary
    {  114, 3727,   58866, 10, }, // Atlantic/Cape_Verde
    {  114, 1395,   58876,  7, }, // Atlantic/Faroe
    {  114, 7272,   58883, 12, }, // Atlantic/South_Georgia
    {  114, 6821,   58895, 11, }, // Atlantic/St_Helena
    {  114, 2300,    4438,  6, }, // Europe/Athens
    {  114, 6336,   58906,  8, }, // Europe/Belgrade
    {  114, 4757,   58914,  7, }, // Europe/Berlin
    {  114, 2167,    4450,  7, }, // Europe/Brussels
    {  114, 3928,    4457,  9, }, // Europe/Bucharest
    {  114, 3806,    4466,  9, }, // Europe/Budapest
    {  114, 6289,    4475, 10, }, // Europe/Copenhagen
    {  114, 1130,   58921,  9, }, // Europe/Istanbul
    {  114, 2527,    8148,  4, }, // Europe/Kyiv
    {  114, 3213,    4499,  8, }, // Europe/Lisbon
    {  114, 2501,    4507,  6, }, // Europe/London
    {  114, 6365,    4513,  9, }, // Europe/Luxembourg
    {  114, 3537,    4522,  6, }, // Europe/Moscow
    {  114, 4284,   58930,  6, }, // Europe/Paris
    {  114, 6275,    4533,  5, }, // Europe/Prague
    {  114, 6202,   21213,  6, }, // Europe/Tirane
    {  114, 6567,   58936, 12, }, // Europe/Vatican
    {  114, 6231,   58948,  5, }, // Europe/Vienna
    {  114, 4727,    4561,  9, }, // Europe/Volgograd
    {  114, 3190,   57528,  8, }, // Europe/Warsaw
    {  114, 6540,    4577,  6, }, // Europe/Zurich
    {  114, 6947,   58953, 14, }, // Indian/Chagos
    {  114, 6046,   58967, 15, }, // Indian/Christmas
    {  114, 6063,   58982, 13, }, // Indian/Cocos
    {  114, 7260,   27115,  4, }, // Indian/Mahe
    {  114, 7050,   58995,  8, }, // Indian/Maldives
    {  114, 7211,     547,  7, }, // Indian/Reunion
    {  114, 3157,     554,  5, }, // Pacific/Chuuk
    {  114, 2237,   59003, 10, }, // Pacific/Easter
    {  114, 6696,   59013, 12, }, // Pacific/Gambier
    {  114, 2723,    4611,  8, }, // Pacific/Honolulu
    {  114, 3049,    4619,  9, }, // Pacific/Kanton
    {  114, 4051,   59025, 17, }, // Pacific/Marquesas
    {  114, 7098,    4628,  6, }, // Pacific/Noumea
    {  114, 3096,     586,  7, }, // Pacific/Pohnpei
    {  121, 6760,   59042,  6, }, // Africa/Accra Dzongkha/Tibetan/Bhutan
    {  121, 5059,   59048, 14, }, // Africa/Addis_Ababa
    {  121, 7420,   59062,  8, }, // Africa/Algiers
    {  121,   14,   59070,  7, }, // Africa/Asmara
    {  121,   44,   59077,  7, }, // Africa/Bamako
    {  121, 5257,   59084,  6, }, // Africa/Bangui
    {  121, 6746,   59090,  8, }, // Africa/Banjul
    {  121, 7435,   59098,  8, }, // Africa/Bissau
    {  121, 5287,   59106,  9, }, // Africa/Brazzaville
    {  121, 4922,   59115, 13, }, // Africa/Bujumbura
    {  121, 2320,   59128,  7, }, // Africa/Cairo
    {  121, 6773,   59135,  8, }, // Africa/Conakry
    {  121, 6840,   59143,  5, }, // Africa/Dakar
    {  121, 5043,   59148,  9, }, // Africa/Djibouti
    {  121, 4906,   59157, 12, }, // Africa/Gaborone
    {  121, 5015,   59169,  7, }, // Africa/Harare
    {  121, 5151,   59176,  7, }, // Africa/Kampala
    {  121, 4524,   59183,  7, }, // Africa/Khartoum
    {  121, 4973,   59190,  8, }, // Africa/Kigali
    {  121, 5306,   59198,  7, }, // Africa/Kinshasa
    {  121, 5336,   59205, 10, }, // Africa/Libreville
    {  121, 6869,   59215,  5, }, // Africa/Lome
    {  121, 5211,   59220,  8, }, // Africa/Luanda
    {  121, 5001,   59228,  7, }, // Africa/Lusaka
    {  121, 5322,   59235,  7, }, // Africa/Malabo
    {  121, 4987,   59242,  7, }, // Africa/Maputo
    {  121, 5197,   59249,  6, }, // Africa/Maseru
    {  121, 5182,   59255, 12, }, // Africa/Mbabane
    {  121, 5113,   59267, 11, }, // Africa/Mogadishu
    {  121, 7034,   59278, 11, }, // Africa/Monrovia
    {  121, 3853,   59289, 10, }, // Africa/Nairobi
    {  121, 5354,   59299,  7, }, // Africa/Niamey
    {  121, 6803,   59306, 10, }, // Africa/Nouakchott
    {  121, 6727,   59316, 10, }, // Africa/Ouagadougou
    {  121, 4435,   59326,  9, }, // Africa/Sao_Tome
    {  121, 2866,   59335,  9, }, // Africa/Tripoli
    {  121, 6554,   59344,  7, }, // Africa/Tunis
    {  121, 4152,   59351,  8, }, // Africa/Windhoek
    {  121, 5624,   59359, 11, }, // America/Antigua
    {  121,  166,   59370, 18, }, // America/Argentina/Buenos_Aires
    {  121, 4252,   59388, 12, }, // America/Asuncion
    {  121,  237,   59400, 11, }, // America/Atikokan
    {  121, 7623,      30, 17, }, // America/Bahia_Banderas
    {  121, 5654,   59411, 10, }, // America/Barbados
    {  121, 5407,   59421,  7, }, // America/Belize
    {  121, 4361,   59428,  7, }, // America/Bogota
    {  121, 7713,   59435, 15, }, // America/Cambridge_Bay
    {  121, 3868,      47,  6, }, // America/Cancun
    {  121, 4694,   59450,  7, }, // America/Caracas
    {  121, 2260,   59457,  8, }, // America/Chicago
    {  121, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  121, 5422,   59465, 10, }, // America/Costa_Rica
    {  121, 5723,      66,  7, }, // America/Curacao
    {  121, 7833,   59475,  8, }, // America/Dawson
    {  121, 7848,   59483, 15, }, // America/Dawson_Creek
    {  121, 5739,   59498, 10, }, // America/Dominica
    {  121,  893,   59508, 12, }, // America/Edmonton
    {  121, 5441,   59520, 13, }, // America/El_Salvador
    {  121, 6881,   59533, 10, }, // America/Goose_Bay
    {  121, 3760,   59543,  9, }, // America/Guatemala
    {  121, 6932,   59552,  6, }, // America/Guyana
    {  121, 1939,   59558, 10, }, // America/Halifax
    {  121,  481,      73, 13, }, // America/Indiana/Knox
    {  121, 7961,      86, 16, }, // America/Indiana/Marengo
    {  121, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  121, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  121, 8038,     139, 14, }, // America/Indiana/Vevay
    {  121, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  121, 8086,     171, 16, }, // America/Indiana/Winamac
    {  121, 8110,   59568,  9, }, // America/Inuvik
    {  121, 2799,   59577,  8, }, // America/Jamaica
    {  121, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  121, 4376,   59585,  6, }, // America/La_Paz
    {  121, 7169,   59591,  4, }, // America/Lima
    {  121, 5932,     207, 22, }, // America/Lower_Princes
    {  121, 8220,     229,  6, }, // America/Merida
    {  121, 2949,   59595, 16, }, // America/Mexico_City
    {  121, 8254,   59611,  9, }, // America/Moncton
    {  121, 4098,   59620, 15, }, // America/Montevideo
    {  121, 5481,   59635,  5, }, // America/Nassau
    {  121, 1850,     235, 19, }, // America/Noronha
    {  121, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  121, 8329,     274, 20, }, // America/North_Dakota/Center
    {  121, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  121,  393,     317,  4, }, // America/Nuuk
    {  121, 2356,   59640,  5, }, // America/Panama
    {  121, 6173,   59645, 12, }, // America/Paramaribo
    {  121, 8424,   59657, 16, }, // America/Rankin_Inlet
    {  121, 1995,   59673,  7, }, // America/Regina
    {  121, 8460,   59680, 11, }, // America/Resolute
    {  121, 2201,   59691, 12, }, // America/Santiago
    {  121, 6111,   59703, 18, }, // America/Santo_Domingo
    {  121, 6899,     321, 16, }, // America/Scoresbysund
    {  121, 8508,     337, 14, }, // America/St_Barthelemy
    {  121, 2061,   59721, 17, }, // America/St_Johns
    {  121, 5863,     361,  9, }, // America/St_Kitts
    {  121, 5880,     370,  9, }, // America/St_Lucia
    {  121,  855,     379, 10, }, // America/St_Thomas
    {  121, 5913,     389, 11, }, // America/St_Vincent
    {  121, 8530,   59738, 14, }, // America/Swift_Current
    {  121, 5461,   59752, 14, }, // America/Tegucigalpa
    {  121,  313,   59766,  8, }, // America/Tijuana
    {  121,  608,   59774,  9, }, // America/Toronto
    {  121, 8552,   59783,  7, }, // America/Yakutat
    {  121, 6094,   59790,  7, }, // Antarctica/Davis
    {  121, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  121, 7066,   59797,  8, }, // Antarctica/Mawson
    {  121, 8589,   59805,  6, }, // Antarctica/Palmer
    {  121, 7226,   59811,  8, }, // Antarctica/Rothera
    {  121, 7374,   59819,  8, }, // Antarctica/Vostok
    {  121, 5534,   59827,  7, }, // Asia/Bahrain
    {  121, 5989,   59834,  8, }, // Asia/Brunei
    {  121, 4511,   59842, 10, }, // Asia/Colombo
    {  121, 1093,   59143,  4, }, // Asia/Dhaka
    {  121, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  121, 7006,   59852,  7, }, // Asia/Jakarta
    {  121, 6992,   59859,  8, }, // Asia/Jayapura
    {  121, 3560,   59867,  6, }, // Asia/Kabul
    {  121, 4239,   59873,  6, }, // Asia/Karachi
    {  121, 1185,   59879, 10, }, // Asia/Kathmandu
    {  121,  992,   59889,  8, }, // Asia/Kolkata
    {  121, 4859,   59897, 12, }, // Asia/Kuala_Lumpur
    {  121, 1211,     464,  5, }, // Asia/Macau
    {  121, 8693,   59909, 11, }, // Asia/Pontianak
    {  121, 2772,   59920,  6, }, // Asia/Tehran
    {  121, 1317,   59926,  7, }, // Asia/Thimphu
    {  121, 6977,   59933, 13, }, // Asia/Vientiane
    {  121, 1235,   59946,  7, }, // Asia/Yangon
    {  121, 5671,   59953,  7, }, // Atlantic/Bermuda
    {  121, 3727,   59960,  7, }, // Atlantic/Cape_Verde
    {  121, 1395,   59967,  8, }, // Atlantic/Faroe
    {  121, 2748,   59975, 11, }, // Atlantic/Reykjavik
    {  121, 7272,   59986, 11, }, // Atlantic/South_Georgia
    {  121, 6821,     488, 10, }, // Atlantic/St_Helena
    {  121, 6441,   59997,  9, }, // Europe/Amsterdam
    {  121, 6216,   60006,  8, }, // Europe/Andorra
    {  121, 2300,   60014,  8, }, // Europe/Athens
    {  121, 4757,   60022,  7, }, // Europe/Berlin
    {  121, 2167,   60029,  7, }, // Europe/Brussels
    {  121, 3928,   60036, 10, }, // Europe/Bucharest
    {  121, 3806,   60046, 10, }, // Europe/Budapest
    {  121, 2583,   60056,  9, }, // Europe/Chisinau
    {  121, 6289,   60065, 13, }, // Europe/Copenhagen
    {  121, 2338,   60078,  6, }, // Europe/Dublin
    {  121, 6612,   60084, 10, }, // Europe/Helsinki
    {  121, 2527,     514,  4, }, // Europe/Kyiv
    {  121, 2501,   60094,  7, }, // Europe/London
    {  121, 6365,   60101,  9, }, // Europe/Luxembourg
    {  121, 4892,   60110,  8, }, // Europe/Madrid
    {  121, 3693,   60118,  5, }, // Europe/Minsk
    {  121, 6410,   60123,  7, }, // Europe/Monaco
    {  121, 3537,   60130,  7, }, // Europe/Moscow
    {  121, 6458,   60137,  6, }, // Europe/Oslo
    {  121, 4284,   60143,  6, }, // Europe/Paris
    {  121, 6275,   60149,  3, }, // Europe/Prague
    {  121, 8837,   60152,  5, }, // Europe/Riga
    {  121, 6245,   60157,  9, }, // Europe/Sarajevo
    {  121, 6599,   60166,  7, }, // Europe/Sofia
    {  121, 6523,   60173, 12, }, // Europe/Stockholm
    {  121, 8867,   60185,  7, }, // Europe/Tallinn
    {  121, 6202,   60192,  6, }, // Europe/Tirane
    {  121, 6352,   60198,  6, }, // Europe/Vaduz
    {  121, 6231,   60204,  7, }, // Europe/Vienna
    {  121, 8899,   60211, 10, }, // Europe/Vilnius
    {  121, 3190,   60221,  5, }, // Europe/Warsaw
    {  121, 6540,   60226,  6, }, // Europe/Zurich
    {  121, 5078,   60232, 15, }, // Indian/Antananarivo
    {  121, 6046,   60247, 10, }, // Indian/Christmas
    {  121, 6063,   60257,  7, }, // Indian/Cocos
    {  121, 5029,   60264,  8, }, // Indian/Comoro
    {  121, 6661,   60272, 10, }, // Indian/Kerguelen
    {  121, 7050,   60282,  8, }, // Indian/Maldives
    {  121, 4069,   60290,  9, }, // Indian/Mauritius
    {  121, 7211,     547,  7, }, // Indian/Reunion
    {  121, 4422,   60299,  6, }, // Pacific/Apia
    {  121, 3157,     554,  5, }, // Pacific/Chuuk
    {  121, 7327,   60305,  8, }, // Pacific/Fakaofo
    {  121, 7343,   60313, 10, }, // Pacific/Funafuti
    {  121, 6696,   60323,  8, }, // Pacific/Gambier
    {  121, 4877,   60331,  8, }, // Pacific/Majuro
    {  121, 8914,   60339,  6, }, // Pacific/Midway
    {  121, 7084,   60345,  6, }, // Pacific/Nauru
    {  121, 3126,   60351, 10, }, // Pacific/Pago_Pago
    {  121, 7155,   60361,  5, }, // Pacific/Palau
    {  121, 3096,     586,  7, }, // Pacific/Pohnpei
    {  121, 6076,   60366, 12, }, // Pacific/Rarotonga
    {  121, 6031,   60378,  8, }, // Pacific/Saipan
    {  121, 4583,   60386, 10, }, // Pacific/Tongatapu
    {  121, 7392,   60396,  3, }, // Pacific/Wake
    {  122,   14,       0,  6, }, // Africa/Asmara Embu/Latin/Kenya
    {  122, 4435,       6,  8, }, // Africa/Sao_Tome
    {  122, 4252,      14,  8, }, // America/Asuncion
    {  122,  237,      22,  8, }, // America/Atikokan
    {  122, 7623,      30, 17, }, // America/Bahia_Banderas
    {  122, 3868,      47,  6, }, // America/Cancun
    {  122, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  122, 5723,      66,  7, }, // America/Curacao
    {  122,  481,      73, 13, }, // America/Indiana/Knox
    {  122, 7961,      86, 16, }, // America/Indiana/Marengo
    {  122, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  122, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  122, 8038,     139, 14, }, // America/Indiana/Vevay
    {  122, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  122, 8086,     171, 16, }, // America/Indiana/Winamac
    {  122, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  122, 5932,     207, 22, }, // America/Lower_Princes
    {  122, 8220,     229,  6, }, // America/Merida
    {  122, 1850,     235, 19, }, // America/Noronha
    {  122, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  122, 8329,     274, 20, }, // America/North_Dakota/Center
    {  122, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  122,  393,     317,  4, }, // America/Nuuk
    {  122, 6899,     321, 16, }, // America/Scoresbysund
    {  122, 8508,     337, 14, }, // America/St_Barthelemy
    {  122, 2061,     351, 10, }, // America/St_Johns
    {  122, 5863,     361,  9, }, // America/St_Kitts
    {  122, 5880,     370,  9, }, // America/St_Lucia
    {  122,  855,     379, 10, }, // America/St_Thomas
    {  122, 5913,     389, 11, }, // America/St_Vincent
    {  122, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  122, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  122, 1185,     448,  9, }, // Asia/Kathmandu
    {  122,  992,     457,  7, }, // Asia/Kolkata
    {  122, 1211,     464,  5, }, // Asia/Macau
    {  122, 1235,     477,  6, }, // Asia/Yangon
    {  122, 1395,     483,  5, }, // Atlantic/Faroe
    {  122, 6821,     488, 10, }, // Atlantic/St_Helena
    {  122, 2527,     514,  4, }, // Europe/Kyiv
    {  122, 7211,     547,  7, }, // Indian/Reunion
    {  122, 3157,     554,  5, }, // Pacific/Chuuk
    {  122, 3096,     586,  7, }, // Pacific/Pohnpei
    {  123,   14,       0,  6, }, // Africa/Asmara English/Latin/United States
    {  123, 4435,       6,  8, }, // Africa/Sao_Tome
    {  123, 4252,      14,  8, }, // America/Asuncion
    {  123,  237,      22,  8, }, // America/Atikokan
    {  123, 7623,      30, 17, }, // America/Bahia_Banderas
    {  123, 3868,      47,  6, }, // America/Cancun
    {  123, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  123, 5723,      66,  7, }, // America/Curacao
    {  123,  481,      73, 13, }, // America/Indiana/Knox
    {  123, 7961,      86, 16, }, // America/Indiana/Marengo
    {  123, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  123, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  123, 8038,     139, 14, }, // America/Indiana/Vevay
    {  123, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  123, 8086,     171, 16, }, // America/Indiana/Winamac
    {  123, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  123, 5932,     207, 22, }, // America/Lower_Princes
    {  123, 8220,     229,  6, }, // America/Merida
    {  123, 1850,     235, 19, }, // America/Noronha
    {  123, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  123, 8329,     274, 20, }, // America/North_Dakota/Center
    {  123, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  123,  393,     317,  4, }, // America/Nuuk
    {  123, 6899,     321, 16, }, // America/Scoresbysund
    {  123, 8508,     337, 14, }, // America/St_Barthelemy
    {  123, 2061,     351, 10, }, // America/St_Johns
    {  123, 5863,     361,  9, }, // America/St_Kitts
    {  123, 5880,     370,  9, }, // America/St_Lucia
    {  123,  855,     379, 10, }, // America/St_Thomas
    {  123, 5913,     389, 11, }, // America/St_Vincent
    {  123, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  123, 8568,     416, 16, }, // Antarctica/Macquarie
    {  123, 1259,     432, 16, }, // Asia/Ho_Chi_Minh
    {  123, 1185,     448,  9, }, // Asia/Kathmandu
    {  123,  992,     457,  7, }, // Asia/Kolkata
    {  123, 1211,     464,  5, }, // Asia/Macau
    {  123, 8708,     469,  8, }, // Asia/Qostanay
    {  123, 1235,     477,  6, }, // Asia/Yangon
    {  123, 1395,     483,  5, }, // Atlantic/Faroe
    {  123, 6821,     488, 10, }, // Atlantic/St_Helena
    {  123, 1547,     498, 16, }, // Australia/Lord_Howe
    {  123, 2527,     514,  4, }, // Europe/Kyiv
    {  123, 6046,     518, 16, }, // Indian/Christmas
    {  123, 6063,     534, 13, }, // Indian/Cocos
    {  123, 7211,     547,  7, }, // Indian/Reunion
    {  123, 3157,     554,  5, }, // Pacific/Chuuk
    {  123, 2237,     559, 13, }, // Pacific/Easter
    {  123, 4168,     572, 14, }, // Pacific/Norfolk
    {  123, 3096,     586,  7, }, // Pacific/Pohnpei
    {  123, 7392,     593, 11, }, // Pacific/Wake
    {  124,  132,   60399,  8, }, // America/Adak English/Deseret/United States
    {  124, 3346,   60407, 14, }, // America/Anchorage
    {  124, 7699,   60421, 10, }, // America/Boise
    {  124, 2260,   60431, 12, }, // America/Chicago
    {  124,  805,   60443, 12, }, // America/Denver
    {  124, 3465,   60455, 14, }, // America/Detroit
    {  124,  348,   60469, 24, }, // America/Indiana/Indianapolis
    {  124,  481,   60493, 24, }, // America/Indiana/Knox
    {  124, 7961,   60517, 30, }, // America/Indiana/Marengo
    {  124, 7985,   60547, 36, }, // America/Indiana/Petersburg
    {  124, 8012,   60583, 31, }, // America/Indiana/Tell_City
    {  124, 8038,   60614, 24, }, // America/Indiana/Vevay
    {  124, 8060,   60638, 30, }, // America/Indiana/Vincennes
    {  124, 8086,   60668, 30, }, // America/Indiana/Winamac
    {  124, 5380,   60698,  8, }, // America/Juneau
    {  124,  521,   60706, 14, }, // America/Kentucky/Louisville
    {  124, 8125,   60720, 34, }, // America/Kentucky/Monticello
    {  124, 3239,   60754, 19, }, // America/Los_Angeles
    {  124, 8202,   60773, 16, }, // America/Menominee
    {  124, 2379,   60789, 13, }, // America/New_York
    {  124, 8288,   60802,  6, }, // America/Nome
    {  124, 8329,   60808, 35, }, // America/North_Dakota/Center
    {  124, 8357,   60843, 38, }, // America/North_Dakota/New_Salem
    {  124, 2973,   60881, 12, }, // America/Phoenix
    {  124, 8552,   60893, 14, }, // America/Yakutat
    {  124, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  124, 2723,   60907, 16, }, // Pacific/Honolulu
    {  124, 8914,   60923, 10, }, // Pacific/Midway
    {  124, 7392,   60933,  6, }, // Pacific/Wake
    {  126, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Anguilla
    {  126, 2061,   60952,  9, }, // America/St_Johns
    {  126, 5863,   60961,  8, }, // America/St_Kitts
    {  126, 5880,   60969,  8, }, // America/St_Lucia
    {  126,  855,   60977,  9, }, // America/St_Thomas
    {  126, 5913,   60986, 10, }, // America/St_Vincent
    {  126, 5523,    5609,  5, }, // Asia/Aqtau
    {  126, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  126, 3049,    4619,  9, }, // Pacific/Kanton
    {  127, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Antigua and Barbuda
    {  127, 2061,   60952,  9, }, // America/St_Johns
    {  127, 5863,   60961,  8, }, // America/St_Kitts
    {  127, 5880,   60969,  8, }, // America/St_Lucia
    {  127,  855,   60977,  9, }, // America/St_Thomas
    {  127, 5913,   60986, 10, }, // America/St_Vincent
    {  127, 5523,    5609,  5, }, // Asia/Aqtau
    {  127, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  127, 3049,    4619,  9, }, // Pacific/Kanton
    {  128, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Australia
    {  128, 2061,   60952,  9, }, // America/St_Johns
    {  128, 5863,   60961,  8, }, // America/St_Kitts
    {  128, 5880,   60969,  8, }, // America/St_Lucia
    {  128,  855,   60977,  9, }, // America/St_Thomas
    {  128, 5913,   60986, 10, }, // America/St_Vincent
    {  128, 5523,    5609,  5, }, // Asia/Aqtau
    {  128, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  128, 3049,    4619,  9, }, // Pacific/Kanton
    {  129, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Austria
    {  129, 2061,   60952,  9, }, // America/St_Johns
    {  129, 5863,   60961,  8, }, // America/St_Kitts
    {  129, 5880,   60969,  8, }, // America/St_Lucia
    {  129,  855,   60977,  9, }, // America/St_Thomas
    {  129, 5913,   60986, 10, }, // America/St_Vincent
    {  129, 5523,    5609,  5, }, // Asia/Aqtau
    {  129, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  129, 3049,    4619,  9, }, // Pacific/Kanton
    {  130, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Bahamas
    {  130, 2061,   60952,  9, }, // America/St_Johns
    {  130, 5863,   60961,  8, }, // America/St_Kitts
    {  130, 5880,   60969,  8, }, // America/St_Lucia
    {  130,  855,   60977,  9, }, // America/St_Thomas
    {  130, 5913,   60986, 10, }, // America/St_Vincent
    {  130, 5523,    5609,  5, }, // Asia/Aqtau
    {  130, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  130, 3049,    4619,  9, }, // Pacific/Kanton
    {  131, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Barbados
    {  131, 2061,   60952,  9, }, // America/St_Johns
    {  131, 5863,   60961,  8, }, // America/St_Kitts
    {  131, 5880,   60969,  8, }, // America/St_Lucia
    {  131,  855,   60977,  9, }, // America/St_Thomas
    {  131, 5913,   60986, 10, }, // America/St_Vincent
    {  131, 5523,    5609,  5, }, // Asia/Aqtau
    {  131, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  131, 3049,    4619,  9, }, // Pacific/Kanton
    {  132, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Belgium
    {  132, 2061,   60952,  9, }, // America/St_Johns
    {  132, 5863,   60961,  8, }, // America/St_Kitts
    {  132, 5880,   60969,  8, }, // America/St_Lucia
    {  132,  855,   60977,  9, }, // America/St_Thomas
    {  132, 5913,   60986, 10, }, // America/St_Vincent
    {  132, 5523,    5609,  5, }, // Asia/Aqtau
    {  132, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  132, 3049,    4619,  9, }, // Pacific/Kanton
    {  133, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Belize
    {  133, 2061,   60952,  9, }, // America/St_Johns
    {  133, 5863,   60961,  8, }, // America/St_Kitts
    {  133, 5880,   60969,  8, }, // America/St_Lucia
    {  133,  855,   60977,  9, }, // America/St_Thomas
    {  133, 5913,   60986, 10, }, // America/St_Vincent
    {  133, 5523,    5609,  5, }, // Asia/Aqtau
    {  133, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  133, 3049,    4619,  9, }, // Pacific/Kanton
    {  134, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Bermuda
    {  134, 2061,   60952,  9, }, // America/St_Johns
    {  134, 5863,   60961,  8, }, // America/St_Kitts
    {  134, 5880,   60969,  8, }, // America/St_Lucia
    {  134,  855,   60977,  9, }, // America/St_Thomas
    {  134, 5913,   60986, 10, }, // America/St_Vincent
    {  134, 5523,    5609,  5, }, // Asia/Aqtau
    {  134, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  134, 3049,    4619,  9, }, // Pacific/Kanton
    {  135, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Botswana
    {  135, 2061,   60952,  9, }, // America/St_Johns
    {  135, 5863,   60961,  8, }, // America/St_Kitts
    {  135, 5880,   60969,  8, }, // America/St_Lucia
    {  135,  855,   60977,  9, }, // America/St_Thomas
    {  135, 5913,   60986, 10, }, // America/St_Vincent
    {  135, 5523,    5609,  5, }, // Asia/Aqtau
    {  135, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  135, 3049,    4619,  9, }, // Pacific/Kanton
    {  136, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/British Indian Ocean Territory
    {  136, 2061,   60952,  9, }, // America/St_Johns
    {  136, 5863,   60961,  8, }, // America/St_Kitts
    {  136, 5880,   60969,  8, }, // America/St_Lucia
    {  136,  855,   60977,  9, }, // America/St_Thomas
    {  136, 5913,   60986, 10, }, // America/St_Vincent
    {  136, 5523,    5609,  5, }, // Asia/Aqtau
    {  136, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  136, 3049,    4619,  9, }, // Pacific/Kanton
    {  137, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/British Virgin Islands
    {  137, 2061,   60952,  9, }, // America/St_Johns
    {  137, 5863,   60961,  8, }, // America/St_Kitts
    {  137, 5880,   60969,  8, }, // America/St_Lucia
    {  137,  855,   60977,  9, }, // America/St_Thomas
    {  137, 5913,   60986, 10, }, // America/St_Vincent
    {  137, 5523,    5609,  5, }, // Asia/Aqtau
    {  137, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  137, 3049,    4619,  9, }, // Pacific/Kanton
    {  139, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Cameroon
    {  139, 2061,   60952,  9, }, // America/St_Johns
    {  139, 5863,   60961,  8, }, // America/St_Kitts
    {  139, 5880,   60969,  8, }, // America/St_Lucia
    {  139,  855,   60977,  9, }, // America/St_Thomas
    {  139, 5913,   60986, 10, }, // America/St_Vincent
    {  139, 5523,    5609,  5, }, // Asia/Aqtau
    {  139, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  139, 3049,    4619,  9, }, // Pacific/Kanton
    {  140, 8508,   26721, 16, }, // America/St_Barthelemy English/Latin/Canada
    {  140, 2061,   26737, 12, }, // America/St_Johns
    {  140, 5863,   26749, 11, }, // America/St_Kitts
    {  140, 5880,   35964, 11, }, // America/St_Lucia
    {  140,  855,   44293, 12, }, // America/St_Thomas
    {  140, 5913,   26783, 13, }, // America/St_Vincent
    {  140, 1235,   58618,  7, }, // Asia/Yangon
    {  140, 6821,   36198, 12, }, // Atlantic/St_Helena
    {  141, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Cayman Islands
    {  141, 2061,   60952,  9, }, // America/St_Johns
    {  141, 5863,   60961,  8, }, // America/St_Kitts
    {  141, 5880,   60969,  8, }, // America/St_Lucia
    {  141,  855,   60977,  9, }, // America/St_Thomas
    {  141, 5913,   60986, 10, }, // America/St_Vincent
    {  141, 5523,    5609,  5, }, // Asia/Aqtau
    {  141, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  141, 3049,    4619,  9, }, // Pacific/Kanton
    {  142, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Christmas Island
    {  142, 2061,   60952,  9, }, // America/St_Johns
    {  142, 5863,   60961,  8, }, // America/St_Kitts
    {  142, 5880,   60969,  8, }, // America/St_Lucia
    {  142,  855,   60977,  9, }, // America/St_Thomas
    {  142, 5913,   60986, 10, }, // America/St_Vincent
    {  142, 5523,    5609,  5, }, // Asia/Aqtau
    {  142, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  142, 3049,    4619,  9, }, // Pacific/Kanton
    {  143, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Cocos Islands
    {  143, 2061,   60952,  9, }, // America/St_Johns
    {  143, 5863,   60961,  8, }, // America/St_Kitts
    {  143, 5880,   60969,  8, }, // America/St_Lucia
    {  143,  855,   60977,  9, }, // America/St_Thomas
    {  143, 5913,   60986, 10, }, // America/St_Vincent
    {  143, 5523,    5609,  5, }, // Asia/Aqtau
    {  143, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  143, 3049,    4619,  9, }, // Pacific/Kanton
    {  144, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Cook Islands
    {  144, 2061,   60952,  9, }, // America/St_Johns
    {  144, 5863,   60961,  8, }, // America/St_Kitts
    {  144, 5880,   60969,  8, }, // America/St_Lucia
    {  144,  855,   60977,  9, }, // America/St_Thomas
    {  144, 5913,   60986, 10, }, // America/St_Vincent
    {  144, 5523,    5609,  5, }, // Asia/Aqtau
    {  144, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  144, 3049,    4619,  9, }, // Pacific/Kanton
    {  145, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Cyprus
    {  145, 2061,   60952,  9, }, // America/St_Johns
    {  145, 5863,   60961,  8, }, // America/St_Kitts
    {  145, 5880,   60969,  8, }, // America/St_Lucia
    {  145,  855,   60977,  9, }, // America/St_Thomas
    {  145, 5913,   60986, 10, }, // America/St_Vincent
    {  145, 5523,    5609,  5, }, // Asia/Aqtau
    {  145, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  145, 3049,    4619,  9, }, // Pacific/Kanton
    {  146, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Czechia
    {  146, 2061,   60952,  9, }, // America/St_Johns
    {  146, 5863,   60961,  8, }, // America/St_Kitts
    {  146, 5880,   60969,  8, }, // America/St_Lucia
    {  146,  855,   60977,  9, }, // America/St_Thomas
    {  146, 5913,   60986, 10, }, // America/St_Vincent
    {  146, 5523,    5609,  5, }, // Asia/Aqtau
    {  146, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  146, 3049,    4619,  9, }, // Pacific/Kanton
    {  147, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Denmark
    {  147, 2061,   60952,  9, }, // America/St_Johns
    {  147, 5863,   60961,  8, }, // America/St_Kitts
    {  147, 5880,   60969,  8, }, // America/St_Lucia
    {  147,  855,   60977,  9, }, // America/St_Thomas
    {  147, 5913,   60986, 10, }, // America/St_Vincent
    {  147, 5523,    5609,  5, }, // Asia/Aqtau
    {  147, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  147, 3049,    4619,  9, }, // Pacific/Kanton
    {  148, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Diego Garcia
    {  148, 2061,   60952,  9, }, // America/St_Johns
    {  148, 5863,   60961,  8, }, // America/St_Kitts
    {  148, 5880,   60969,  8, }, // America/St_Lucia
    {  148,  855,   60977,  9, }, // America/St_Thomas
    {  148, 5913,   60986, 10, }, // America/St_Vincent
    {  148, 5523,    5609,  5, }, // Asia/Aqtau
    {  148, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  148, 3049,    4619,  9, }, // Pacific/Kanton
    {  149, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Dominica
    {  149, 2061,   60952,  9, }, // America/St_Johns
    {  149, 5863,   60961,  8, }, // America/St_Kitts
    {  149, 5880,   60969,  8, }, // America/St_Lucia
    {  149,  855,   60977,  9, }, // America/St_Thomas
    {  149, 5913,   60986, 10, }, // America/St_Vincent
    {  149, 5523,    5609,  5, }, // Asia/Aqtau
    {  149, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  149, 3049,    4619,  9, }, // Pacific/Kanton
    {  150, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Eritrea
    {  150, 2061,   60952,  9, }, // America/St_Johns
    {  150, 5863,   60961,  8, }, // America/St_Kitts
    {  150, 5880,   60969,  8, }, // America/St_Lucia
    {  150,  855,   60977,  9, }, // America/St_Thomas
    {  150, 5913,   60986, 10, }, // America/St_Vincent
    {  150, 5523,    5609,  5, }, // Asia/Aqtau
    {  150, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  150, 3049,    4619,  9, }, // Pacific/Kanton
    {  151, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Eswatini
    {  151, 2061,   60952,  9, }, // America/St_Johns
    {  151, 5863,   60961,  8, }, // America/St_Kitts
    {  151, 5880,   60969,  8, }, // America/St_Lucia
    {  151,  855,   60977,  9, }, // America/St_Thomas
    {  151, 5913,   60986, 10, }, // America/St_Vincent
    {  151, 5523,    5609,  5, }, // Asia/Aqtau
    {  151, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  151, 3049,    4619,  9, }, // Pacific/Kanton
    {  152, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Europe
    {  152, 2061,   60952,  9, }, // America/St_Johns
    {  152, 5863,   60961,  8, }, // America/St_Kitts
    {  152, 5880,   60969,  8, }, // America/St_Lucia
    {  152,  855,   60977,  9, }, // America/St_Thomas
    {  152, 5913,   60986, 10, }, // America/St_Vincent
    {  152, 5523,    5609,  5, }, // Asia/Aqtau
    {  152, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  152, 3049,    4619,  9, }, // Pacific/Kanton
    {  153, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Falkland Islands
    {  153, 2061,   60952,  9, }, // America/St_Johns
    {  153, 5863,   60961,  8, }, // America/St_Kitts
    {  153, 5880,   60969,  8, }, // America/St_Lucia
    {  153,  855,   60977,  9, }, // America/St_Thomas
    {  153, 5913,   60986, 10, }, // America/St_Vincent
    {  153, 5523,    5609,  5, }, // Asia/Aqtau
    {  153, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  153, 3049,    4619,  9, }, // Pacific/Kanton
    {  154, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Fiji
    {  154, 2061,   60952,  9, }, // America/St_Johns
    {  154, 5863,   60961,  8, }, // America/St_Kitts
    {  154, 5880,   60969,  8, }, // America/St_Lucia
    {  154,  855,   60977,  9, }, // America/St_Thomas
    {  154, 5913,   60986, 10, }, // America/St_Vincent
    {  154, 5523,    5609,  5, }, // Asia/Aqtau
    {  154, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  154, 3049,    4619,  9, }, // Pacific/Kanton
    {  155, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Finland
    {  155, 2061,   60952,  9, }, // America/St_Johns
    {  155, 5863,   60961,  8, }, // America/St_Kitts
    {  155, 5880,   60969,  8, }, // America/St_Lucia
    {  155,  855,   60977,  9, }, // America/St_Thomas
    {  155, 5913,   60986, 10, }, // America/St_Vincent
    {  155, 5523,    5609,  5, }, // Asia/Aqtau
    {  155, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  155, 3049,    4619,  9, }, // Pacific/Kanton
    {  156, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/France
    {  156, 2061,   60952,  9, }, // America/St_Johns
    {  156, 5863,   60961,  8, }, // America/St_Kitts
    {  156, 5880,   60969,  8, }, // America/St_Lucia
    {  156,  855,   60977,  9, }, // America/St_Thomas
    {  156, 5913,   60986, 10, }, // America/St_Vincent
    {  156, 5523,    5609,  5, }, // Asia/Aqtau
    {  156, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  156, 3049,    4619,  9, }, // Pacific/Kanton
    {  157, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Gambia
    {  157, 2061,   60952,  9, }, // America/St_Johns
    {  157, 5863,   60961,  8, }, // America/St_Kitts
    {  157, 5880,   60969,  8, }, // America/St_Lucia
    {  157,  855,   60977,  9, }, // America/St_Thomas
    {  157, 5913,   60986, 10, }, // America/St_Vincent
    {  157, 5523,    5609,  5, }, // Asia/Aqtau
    {  157, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  157, 3049,    4619,  9, }, // Pacific/Kanton
    {  158, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Germany
    {  158, 2061,   60952,  9, }, // America/St_Johns
    {  158, 5863,   60961,  8, }, // America/St_Kitts
    {  158, 5880,   60969,  8, }, // America/St_Lucia
    {  158,  855,   60977,  9, }, // America/St_Thomas
    {  158, 5913,   60986, 10, }, // America/St_Vincent
    {  158, 5523,    5609,  5, }, // Asia/Aqtau
    {  158, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  158, 3049,    4619,  9, }, // Pacific/Kanton
    {  159, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Ghana
    {  159, 2061,   60952,  9, }, // America/St_Johns
    {  159, 5863,   60961,  8, }, // America/St_Kitts
    {  159, 5880,   60969,  8, }, // America/St_Lucia
    {  159,  855,   60977,  9, }, // America/St_Thomas
    {  159, 5913,   60986, 10, }, // America/St_Vincent
    {  159, 5523,    5609,  5, }, // Asia/Aqtau
    {  159, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  159, 3049,    4619,  9, }, // Pacific/Kanton
    {  160, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Gibraltar
    {  160, 2061,   60952,  9, }, // America/St_Johns
    {  160, 5863,   60961,  8, }, // America/St_Kitts
    {  160, 5880,   60969,  8, }, // America/St_Lucia
    {  160,  855,   60977,  9, }, // America/St_Thomas
    {  160, 5913,   60986, 10, }, // America/St_Vincent
    {  160, 5523,    5609,  5, }, // Asia/Aqtau
    {  160, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  160, 3049,    4619,  9, }, // Pacific/Kanton
    {  161, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Grenada
    {  161, 2061,   60952,  9, }, // America/St_Johns
    {  161, 5863,   60961,  8, }, // America/St_Kitts
    {  161, 5880,   60969,  8, }, // America/St_Lucia
    {  161,  855,   60977,  9, }, // America/St_Thomas
    {  161, 5913,   60986, 10, }, // America/St_Vincent
    {  161, 5523,    5609,  5, }, // Asia/Aqtau
    {  161, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  161, 3049,    4619,  9, }, // Pacific/Kanton
    {  163, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Guernsey
    {  163, 2061,   60952,  9, }, // America/St_Johns
    {  163, 5863,   60961,  8, }, // America/St_Kitts
    {  163, 5880,   60969,  8, }, // America/St_Lucia
    {  163,  855,   60977,  9, }, // America/St_Thomas
    {  163, 5913,   60986, 10, }, // America/St_Vincent
    {  163, 5523,    5609,  5, }, // Asia/Aqtau
    {  163, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  163, 3049,    4619,  9, }, // Pacific/Kanton
    {  164, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Guyana
    {  164, 2061,   60952,  9, }, // America/St_Johns
    {  164, 5863,   60961,  8, }, // America/St_Kitts
    {  164, 5880,   60969,  8, }, // America/St_Lucia
    {  164,  855,   60977,  9, }, // America/St_Thomas
    {  164, 5913,   60986, 10, }, // America/St_Vincent
    {  164, 5523,    5609,  5, }, // Asia/Aqtau
    {  164, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  164, 3049,    4619,  9, }, // Pacific/Kanton
    {  165, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Hong Kong
    {  165, 2061,   60952,  9, }, // America/St_Johns
    {  165, 5863,   60961,  8, }, // America/St_Kitts
    {  165, 5880,   60969,  8, }, // America/St_Lucia
    {  165,  855,   60977,  9, }, // America/St_Thomas
    {  165, 5913,   60986, 10, }, // America/St_Vincent
    {  165, 5523,    5609,  5, }, // Asia/Aqtau
    {  165, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  165, 3049,    4619,  9, }, // Pacific/Kanton
    {  166, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Hungary
    {  166, 2061,   60952,  9, }, // America/St_Johns
    {  166, 5863,   60961,  8, }, // America/St_Kitts
    {  166, 5880,   60969,  8, }, // America/St_Lucia
    {  166,  855,   60977,  9, }, // America/St_Thomas
    {  166, 5913,   60986, 10, }, // America/St_Vincent
    {  166, 5523,    5609,  5, }, // Asia/Aqtau
    {  166, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  166, 3049,    4619,  9, }, // Pacific/Kanton
    {  167, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/India
    {  167, 2061,   60952,  9, }, // America/St_Johns
    {  167, 5863,   60961,  8, }, // America/St_Kitts
    {  167, 5880,   60969,  8, }, // America/St_Lucia
    {  167,  855,   60977,  9, }, // America/St_Thomas
    {  167, 5913,   60986, 10, }, // America/St_Vincent
    {  167, 5523,    5609,  5, }, // Asia/Aqtau
    {  167, 4771,   26835,  5, }, // Asia/Hovd
    {  167, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  167, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  167, 3049,    4619,  9, }, // Pacific/Kanton
    {  168, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Indonesia
    {  168, 2061,   60952,  9, }, // America/St_Johns
    {  168, 5863,   60961,  8, }, // America/St_Kitts
    {  168, 5880,   60969,  8, }, // America/St_Lucia
    {  168,  855,   60977,  9, }, // America/St_Thomas
    {  168, 5913,   60986, 10, }, // America/St_Vincent
    {  168, 5523,    5609,  5, }, // Asia/Aqtau
    {  168, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  168, 3049,    4619,  9, }, // Pacific/Kanton
    {  169, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Ireland
    {  169, 2061,   60952,  9, }, // America/St_Johns
    {  169, 5863,   60961,  8, }, // America/St_Kitts
    {  169, 5880,   60969,  8, }, // America/St_Lucia
    {  169,  855,   60977,  9, }, // America/St_Thomas
    {  169, 5913,   60986, 10, }, // America/St_Vincent
    {  169, 5523,    5609,  5, }, // Asia/Aqtau
    {  169, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  169, 3049,    4619,  9, }, // Pacific/Kanton
    {  170, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Isle of Man
    {  170, 2061,   60952,  9, }, // America/St_Johns
    {  170, 5863,   60961,  8, }, // America/St_Kitts
    {  170, 5880,   60969,  8, }, // America/St_Lucia
    {  170,  855,   60977,  9, }, // America/St_Thomas
    {  170, 5913,   60986, 10, }, // America/St_Vincent
    {  170, 5523,    5609,  5, }, // Asia/Aqtau
    {  170, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  170, 3049,    4619,  9, }, // Pacific/Kanton
    {  171, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Israel
    {  171, 2061,   60952,  9, }, // America/St_Johns
    {  171, 5863,   60961,  8, }, // America/St_Kitts
    {  171, 5880,   60969,  8, }, // America/St_Lucia
    {  171,  855,   60977,  9, }, // America/St_Thomas
    {  171, 5913,   60986, 10, }, // America/St_Vincent
    {  171, 5523,    5609,  5, }, // Asia/Aqtau
    {  171, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  171, 3049,    4619,  9, }, // Pacific/Kanton
    {  172, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Italy
    {  172, 2061,   60952,  9, }, // America/St_Johns
    {  172, 5863,   60961,  8, }, // America/St_Kitts
    {  172, 5880,   60969,  8, }, // America/St_Lucia
    {  172,  855,   60977,  9, }, // America/St_Thomas
    {  172, 5913,   60986, 10, }, // America/St_Vincent
    {  172, 5523,    5609,  5, }, // Asia/Aqtau
    {  172, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  172, 3049,    4619,  9, }, // Pacific/Kanton
    {  173, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Jamaica
    {  173, 2061,   60952,  9, }, // America/St_Johns
    {  173, 5863,   60961,  8, }, // America/St_Kitts
    {  173, 5880,   60969,  8, }, // America/St_Lucia
    {  173,  855,   60977,  9, }, // America/St_Thomas
    {  173, 5913,   60986, 10, }, // America/St_Vincent
    {  173, 5523,    5609,  5, }, // Asia/Aqtau
    {  173, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  173, 3049,    4619,  9, }, // Pacific/Kanton
    {  174, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Jersey
    {  174, 2061,   60952,  9, }, // America/St_Johns
    {  174, 5863,   60961,  8, }, // America/St_Kitts
    {  174, 5880,   60969,  8, }, // America/St_Lucia
    {  174,  855,   60977,  9, }, // America/St_Thomas
    {  174, 5913,   60986, 10, }, // America/St_Vincent
    {  174, 5523,    5609,  5, }, // Asia/Aqtau
    {  174, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  174, 3049,    4619,  9, }, // Pacific/Kanton
    {  175, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Kenya
    {  175, 2061,   60952,  9, }, // America/St_Johns
    {  175, 5863,   60961,  8, }, // America/St_Kitts
    {  175, 5880,   60969,  8, }, // America/St_Lucia
    {  175,  855,   60977,  9, }, // America/St_Thomas
    {  175, 5913,   60986, 10, }, // America/St_Vincent
    {  175, 5523,    5609,  5, }, // Asia/Aqtau
    {  175, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  175, 3049,    4619,  9, }, // Pacific/Kanton
    {  176, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Kiribati
    {  176, 2061,   60952,  9, }, // America/St_Johns
    {  176, 5863,   60961,  8, }, // America/St_Kitts
    {  176, 5880,   60969,  8, }, // America/St_Lucia
    {  176,  855,   60977,  9, }, // America/St_Thomas
    {  176, 5913,   60986, 10, }, // America/St_Vincent
    {  176, 5523,    5609,  5, }, // Asia/Aqtau
    {  176, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  176, 3049,    4619,  9, }, // Pacific/Kanton
    {  177, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Lesotho
    {  177, 2061,   60952,  9, }, // America/St_Johns
    {  177, 5863,   60961,  8, }, // America/St_Kitts
    {  177, 5880,   60969,  8, }, // America/St_Lucia
    {  177,  855,   60977,  9, }, // America/St_Thomas
    {  177, 5913,   60986, 10, }, // America/St_Vincent
    {  177, 5523,    5609,  5, }, // Asia/Aqtau
    {  177, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  177, 3049,    4619,  9, }, // Pacific/Kanton
    {  178, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Liberia
    {  178, 2061,   60952,  9, }, // America/St_Johns
    {  178, 5863,   60961,  8, }, // America/St_Kitts
    {  178, 5880,   60969,  8, }, // America/St_Lucia
    {  178,  855,   60977,  9, }, // America/St_Thomas
    {  178, 5913,   60986, 10, }, // America/St_Vincent
    {  178, 5523,    5609,  5, }, // Asia/Aqtau
    {  178, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  178, 3049,    4619,  9, }, // Pacific/Kanton
    {  179, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Macao
    {  179, 2061,   60952,  9, }, // America/St_Johns
    {  179, 5863,   60961,  8, }, // America/St_Kitts
    {  179, 5880,   60969,  8, }, // America/St_Lucia
    {  179,  855,   60977,  9, }, // America/St_Thomas
    {  179, 5913,   60986, 10, }, // America/St_Vincent
    {  179, 5523,    5609,  5, }, // Asia/Aqtau
    {  179, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  179, 3049,    4619,  9, }, // Pacific/Kanton
    {  180, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Madagascar
    {  180, 2061,   60952,  9, }, // America/St_Johns
    {  180, 5863,   60961,  8, }, // America/St_Kitts
    {  180, 5880,   60969,  8, }, // America/St_Lucia
    {  180,  855,   60977,  9, }, // America/St_Thomas
    {  180, 5913,   60986, 10, }, // America/St_Vincent
    {  180, 5523,    5609,  5, }, // Asia/Aqtau
    {  180, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  180, 3049,    4619,  9, }, // Pacific/Kanton
    {  181, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Malawi
    {  181, 2061,   60952,  9, }, // America/St_Johns
    {  181, 5863,   60961,  8, }, // America/St_Kitts
    {  181, 5880,   60969,  8, }, // America/St_Lucia
    {  181,  855,   60977,  9, }, // America/St_Thomas
    {  181, 5913,   60986, 10, }, // America/St_Vincent
    {  181, 5523,    5609,  5, }, // Asia/Aqtau
    {  181, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  181, 3049,    4619,  9, }, // Pacific/Kanton
    {  182, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Malaysia
    {  182, 2061,   60952,  9, }, // America/St_Johns
    {  182, 5863,   60961,  8, }, // America/St_Kitts
    {  182, 5880,   60969,  8, }, // America/St_Lucia
    {  182,  855,   60977,  9, }, // America/St_Thomas
    {  182, 5913,   60986, 10, }, // America/St_Vincent
    {  182, 5523,    5609,  5, }, // Asia/Aqtau
    {  182, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  182, 3049,    4619,  9, }, // Pacific/Kanton
    {  183, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Maldives
    {  183, 2061,   60952,  9, }, // America/St_Johns
    {  183, 5863,   60961,  8, }, // America/St_Kitts
    {  183, 5880,   60969,  8, }, // America/St_Lucia
    {  183,  855,   60977,  9, }, // America/St_Thomas
    {  183, 5913,   60986, 10, }, // America/St_Vincent
    {  183, 5523,    5609,  5, }, // Asia/Aqtau
    {  183, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  183, 3049,    4619,  9, }, // Pacific/Kanton
    {  184, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Malta
    {  184, 2061,   60952,  9, }, // America/St_Johns
    {  184, 5863,   60961,  8, }, // America/St_Kitts
    {  184, 5880,   60969,  8, }, // America/St_Lucia
    {  184,  855,   60977,  9, }, // America/St_Thomas
    {  184, 5913,   60986, 10, }, // America/St_Vincent
    {  184, 5523,    5609,  5, }, // Asia/Aqtau
    {  184, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  184, 3049,    4619,  9, }, // Pacific/Kanton
    {  186, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Mauritius
    {  186, 2061,   60952,  9, }, // America/St_Johns
    {  186, 5863,   60961,  8, }, // America/St_Kitts
    {  186, 5880,   60969,  8, }, // America/St_Lucia
    {  186,  855,   60977,  9, }, // America/St_Thomas
    {  186, 5913,   60986, 10, }, // America/St_Vincent
    {  186, 5523,    5609,  5, }, // Asia/Aqtau
    {  186, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  186, 3049,    4619,  9, }, // Pacific/Kanton
    {  187, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Micronesia
    {  187, 2061,   60952,  9, }, // America/St_Johns
    {  187, 5863,   60961,  8, }, // America/St_Kitts
    {  187, 5880,   60969,  8, }, // America/St_Lucia
    {  187,  855,   60977,  9, }, // America/St_Thomas
    {  187, 5913,   60986, 10, }, // America/St_Vincent
    {  187, 5523,    5609,  5, }, // Asia/Aqtau
    {  187, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  187, 3049,    4619,  9, }, // Pacific/Kanton
    {  188, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Montserrat
    {  188, 2061,   60952,  9, }, // America/St_Johns
    {  188, 5863,   60961,  8, }, // America/St_Kitts
    {  188, 5880,   60969,  8, }, // America/St_Lucia
    {  188,  855,   60977,  9, }, // America/St_Thomas
    {  188, 5913,   60986, 10, }, // America/St_Vincent
    {  188, 5523,    5609,  5, }, // Asia/Aqtau
    {  188, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  188, 3049,    4619,  9, }, // Pacific/Kanton
    {  189, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Namibia
    {  189, 2061,   60952,  9, }, // America/St_Johns
    {  189, 5863,   60961,  8, }, // America/St_Kitts
    {  189, 5880,   60969,  8, }, // America/St_Lucia
    {  189,  855,   60977,  9, }, // America/St_Thomas
    {  189, 5913,   60986, 10, }, // America/St_Vincent
    {  189, 5523,    5609,  5, }, // Asia/Aqtau
    {  189, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  189, 3049,    4619,  9, }, // Pacific/Kanton
    {  190, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Nauru
    {  190, 2061,   60952,  9, }, // America/St_Johns
    {  190, 5863,   60961,  8, }, // America/St_Kitts
    {  190, 5880,   60969,  8, }, // America/St_Lucia
    {  190,  855,   60977,  9, }, // America/St_Thomas
    {  190, 5913,   60986, 10, }, // America/St_Vincent
    {  190, 5523,    5609,  5, }, // Asia/Aqtau
    {  190, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  190, 3049,    4619,  9, }, // Pacific/Kanton
    {  191, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Netherlands
    {  191, 2061,   60952,  9, }, // America/St_Johns
    {  191, 5863,   60961,  8, }, // America/St_Kitts
    {  191, 5880,   60969,  8, }, // America/St_Lucia
    {  191,  855,   60977,  9, }, // America/St_Thomas
    {  191, 5913,   60986, 10, }, // America/St_Vincent
    {  191, 5523,    5609,  5, }, // Asia/Aqtau
    {  191, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  191, 3049,    4619,  9, }, // Pacific/Kanton
    {  192, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/New Zealand
    {  192, 2061,   60952,  9, }, // America/St_Johns
    {  192, 5863,   60961,  8, }, // America/St_Kitts
    {  192, 5880,   60969,  8, }, // America/St_Lucia
    {  192,  855,   60977,  9, }, // America/St_Thomas
    {  192, 5913,   60986, 10, }, // America/St_Vincent
    {  192, 5523,    5609,  5, }, // Asia/Aqtau
    {  192, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  192, 3049,    4619,  9, }, // Pacific/Kanton
    {  193, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Nigeria
    {  193, 2061,   60952,  9, }, // America/St_Johns
    {  193, 5863,   60961,  8, }, // America/St_Kitts
    {  193, 5880,   60969,  8, }, // America/St_Lucia
    {  193,  855,   60977,  9, }, // America/St_Thomas
    {  193, 5913,   60986, 10, }, // America/St_Vincent
    {  193, 5523,    5609,  5, }, // Asia/Aqtau
    {  193, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  193, 3049,    4619,  9, }, // Pacific/Kanton
    {  194, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Niue
    {  194, 2061,   60952,  9, }, // America/St_Johns
    {  194, 5863,   60961,  8, }, // America/St_Kitts
    {  194, 5880,   60969,  8, }, // America/St_Lucia
    {  194,  855,   60977,  9, }, // America/St_Thomas
    {  194, 5913,   60986, 10, }, // America/St_Vincent
    {  194, 5523,    5609,  5, }, // Asia/Aqtau
    {  194, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  194, 3049,    4619,  9, }, // Pacific/Kanton
    {  195, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Norfolk Island
    {  195, 2061,   60952,  9, }, // America/St_Johns
    {  195, 5863,   60961,  8, }, // America/St_Kitts
    {  195, 5880,   60969,  8, }, // America/St_Lucia
    {  195,  855,   60977,  9, }, // America/St_Thomas
    {  195, 5913,   60986, 10, }, // America/St_Vincent
    {  195, 5523,    5609,  5, }, // Asia/Aqtau
    {  195, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  195, 3049,    4619,  9, }, // Pacific/Kanton
    {  197, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Norway
    {  197, 2061,   60952,  9, }, // America/St_Johns
    {  197, 5863,   60961,  8, }, // America/St_Kitts
    {  197, 5880,   60969,  8, }, // America/St_Lucia
    {  197,  855,   60977,  9, }, // America/St_Thomas
    {  197, 5913,   60986, 10, }, // America/St_Vincent
    {  197, 5523,    5609,  5, }, // Asia/Aqtau
    {  197, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  197, 3049,    4619,  9, }, // Pacific/Kanton
    {  198, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Pakistan
    {  198, 2061,   60952,  9, }, // America/St_Johns
    {  198, 5863,   60961,  8, }, // America/St_Kitts
    {  198, 5880,   60969,  8, }, // America/St_Lucia
    {  198,  855,   60977,  9, }, // America/St_Thomas
    {  198, 5913,   60986, 10, }, // America/St_Vincent
    {  198, 5523,    5609,  5, }, // Asia/Aqtau
    {  198, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  198, 3049,    4619,  9, }, // Pacific/Kanton
    {  199, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Palau
    {  199, 2061,   60952,  9, }, // America/St_Johns
    {  199, 5863,   60961,  8, }, // America/St_Kitts
    {  199, 5880,   60969,  8, }, // America/St_Lucia
    {  199,  855,   60977,  9, }, // America/St_Thomas
    {  199, 5913,   60986, 10, }, // America/St_Vincent
    {  199, 5523,    5609,  5, }, // Asia/Aqtau
    {  199, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  199, 3049,    4619,  9, }, // Pacific/Kanton
    {  200, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Papua New Guinea
    {  200, 2061,   60952,  9, }, // America/St_Johns
    {  200, 5863,   60961,  8, }, // America/St_Kitts
    {  200, 5880,   60969,  8, }, // America/St_Lucia
    {  200,  855,   60977,  9, }, // America/St_Thomas
    {  200, 5913,   60986, 10, }, // America/St_Vincent
    {  200, 5523,    5609,  5, }, // Asia/Aqtau
    {  200, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  200, 3049,    4619,  9, }, // Pacific/Kanton
    {  202, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Pitcairn
    {  202, 2061,   60952,  9, }, // America/St_Johns
    {  202, 5863,   60961,  8, }, // America/St_Kitts
    {  202, 5880,   60969,  8, }, // America/St_Lucia
    {  202,  855,   60977,  9, }, // America/St_Thomas
    {  202, 5913,   60986, 10, }, // America/St_Vincent
    {  202, 5523,    5609,  5, }, // Asia/Aqtau
    {  202, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  202, 3049,    4619,  9, }, // Pacific/Kanton
    {  203, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Poland
    {  203, 2061,   60952,  9, }, // America/St_Johns
    {  203, 5863,   60961,  8, }, // America/St_Kitts
    {  203, 5880,   60969,  8, }, // America/St_Lucia
    {  203,  855,   60977,  9, }, // America/St_Thomas
    {  203, 5913,   60986, 10, }, // America/St_Vincent
    {  203, 5523,    5609,  5, }, // Asia/Aqtau
    {  203, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  203, 3049,    4619,  9, }, // Pacific/Kanton
    {  204, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Portugal
    {  204, 2061,   60952,  9, }, // America/St_Johns
    {  204, 5863,   60961,  8, }, // America/St_Kitts
    {  204, 5880,   60969,  8, }, // America/St_Lucia
    {  204,  855,   60977,  9, }, // America/St_Thomas
    {  204, 5913,   60986, 10, }, // America/St_Vincent
    {  204, 5523,    5609,  5, }, // Asia/Aqtau
    {  204, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  204, 3049,    4619,  9, }, // Pacific/Kanton
    {  206, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Romania
    {  206, 2061,   60952,  9, }, // America/St_Johns
    {  206, 5863,   60961,  8, }, // America/St_Kitts
    {  206, 5880,   60969,  8, }, // America/St_Lucia
    {  206,  855,   60977,  9, }, // America/St_Thomas
    {  206, 5913,   60986, 10, }, // America/St_Vincent
    {  206, 5523,    5609,  5, }, // Asia/Aqtau
    {  206, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  206, 3049,    4619,  9, }, // Pacific/Kanton
    {  207, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Rwanda
    {  207, 2061,   60952,  9, }, // America/St_Johns
    {  207, 5863,   60961,  8, }, // America/St_Kitts
    {  207, 5880,   60969,  8, }, // America/St_Lucia
    {  207,  855,   60977,  9, }, // America/St_Thomas
    {  207, 5913,   60986, 10, }, // America/St_Vincent
    {  207, 5523,    5609,  5, }, // Asia/Aqtau
    {  207, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  207, 3049,    4619,  9, }, // Pacific/Kanton
    {  208, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Saint Helena
    {  208, 2061,   60952,  9, }, // America/St_Johns
    {  208, 5863,   60961,  8, }, // America/St_Kitts
    {  208, 5880,   60969,  8, }, // America/St_Lucia
    {  208,  855,   60977,  9, }, // America/St_Thomas
    {  208, 5913,   60986, 10, }, // America/St_Vincent
    {  208, 5523,    5609,  5, }, // Asia/Aqtau
    {  208, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  208, 3049,    4619,  9, }, // Pacific/Kanton
    {  209, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Saint Kitts and Nevis
    {  209, 2061,   60952,  9, }, // America/St_Johns
    {  209, 5863,   60961,  8, }, // America/St_Kitts
    {  209, 5880,   60969,  8, }, // America/St_Lucia
    {  209,  855,   60977,  9, }, // America/St_Thomas
    {  209, 5913,   60986, 10, }, // America/St_Vincent
    {  209, 5523,    5609,  5, }, // Asia/Aqtau
    {  209, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  209, 3049,    4619,  9, }, // Pacific/Kanton
    {  210, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Saint Lucia
    {  210, 2061,   60952,  9, }, // America/St_Johns
    {  210, 5863,   60961,  8, }, // America/St_Kitts
    {  210, 5880,   60969,  8, }, // America/St_Lucia
    {  210,  855,   60977,  9, }, // America/St_Thomas
    {  210, 5913,   60986, 10, }, // America/St_Vincent
    {  210, 5523,    5609,  5, }, // Asia/Aqtau
    {  210, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  210, 3049,    4619,  9, }, // Pacific/Kanton
    {  211, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Saint Vincent and Grenadines
    {  211, 2061,   60952,  9, }, // America/St_Johns
    {  211, 5863,   60961,  8, }, // America/St_Kitts
    {  211, 5880,   60969,  8, }, // America/St_Lucia
    {  211,  855,   60977,  9, }, // America/St_Thomas
    {  211, 5913,   60986, 10, }, // America/St_Vincent
    {  211, 5523,    5609,  5, }, // Asia/Aqtau
    {  211, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  211, 3049,    4619,  9, }, // Pacific/Kanton
    {  212, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Samoa
    {  212, 2061,   60952,  9, }, // America/St_Johns
    {  212, 5863,   60961,  8, }, // America/St_Kitts
    {  212, 5880,   60969,  8, }, // America/St_Lucia
    {  212,  855,   60977,  9, }, // America/St_Thomas
    {  212, 5913,   60986, 10, }, // America/St_Vincent
    {  212, 5523,    5609,  5, }, // Asia/Aqtau
    {  212, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  212, 3049,    4619,  9, }, // Pacific/Kanton
    {  213, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Seychelles
    {  213, 2061,   60952,  9, }, // America/St_Johns
    {  213, 5863,   60961,  8, }, // America/St_Kitts
    {  213, 5880,   60969,  8, }, // America/St_Lucia
    {  213,  855,   60977,  9, }, // America/St_Thomas
    {  213, 5913,   60986, 10, }, // America/St_Vincent
    {  213, 5523,    5609,  5, }, // Asia/Aqtau
    {  213, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  213, 3049,    4619,  9, }, // Pacific/Kanton
    {  214, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Sierra Leone
    {  214, 2061,   60952,  9, }, // America/St_Johns
    {  214, 5863,   60961,  8, }, // America/St_Kitts
    {  214, 5880,   60969,  8, }, // America/St_Lucia
    {  214,  855,   60977,  9, }, // America/St_Thomas
    {  214, 5913,   60986, 10, }, // America/St_Vincent
    {  214, 5523,    5609,  5, }, // Asia/Aqtau
    {  214, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  214, 3049,    4619,  9, }, // Pacific/Kanton
    {  215, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Singapore
    {  215, 2061,   60952,  9, }, // America/St_Johns
    {  215, 5863,   60961,  8, }, // America/St_Kitts
    {  215, 5880,   60969,  8, }, // America/St_Lucia
    {  215,  855,   60977,  9, }, // America/St_Thomas
    {  215, 5913,   60986, 10, }, // America/St_Vincent
    {  215, 5523,    5609,  5, }, // Asia/Aqtau
    {  215, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  215, 3049,    4619,  9, }, // Pacific/Kanton
    {  216, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Sint Maarten
    {  216, 2061,   60952,  9, }, // America/St_Johns
    {  216, 5863,   60961,  8, }, // America/St_Kitts
    {  216, 5880,   60969,  8, }, // America/St_Lucia
    {  216,  855,   60977,  9, }, // America/St_Thomas
    {  216, 5913,   60986, 10, }, // America/St_Vincent
    {  216, 5523,    5609,  5, }, // Asia/Aqtau
    {  216, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  216, 3049,    4619,  9, }, // Pacific/Kanton
    {  217, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Slovakia
    {  217, 2061,   60952,  9, }, // America/St_Johns
    {  217, 5863,   60961,  8, }, // America/St_Kitts
    {  217, 5880,   60969,  8, }, // America/St_Lucia
    {  217,  855,   60977,  9, }, // America/St_Thomas
    {  217, 5913,   60986, 10, }, // America/St_Vincent
    {  217, 5523,    5609,  5, }, // Asia/Aqtau
    {  217, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  217, 3049,    4619,  9, }, // Pacific/Kanton
    {  218, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Slovenia
    {  218, 2061,   60952,  9, }, // America/St_Johns
    {  218, 5863,   60961,  8, }, // America/St_Kitts
    {  218, 5880,   60969,  8, }, // America/St_Lucia
    {  218,  855,   60977,  9, }, // America/St_Thomas
    {  218, 5913,   60986, 10, }, // America/St_Vincent
    {  218, 5523,    5609,  5, }, // Asia/Aqtau
    {  218, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  218, 3049,    4619,  9, }, // Pacific/Kanton
    {  219, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Solomon Islands
    {  219, 2061,   60952,  9, }, // America/St_Johns
    {  219, 5863,   60961,  8, }, // America/St_Kitts
    {  219, 5880,   60969,  8, }, // America/St_Lucia
    {  219,  855,   60977,  9, }, // America/St_Thomas
    {  219, 5913,   60986, 10, }, // America/St_Vincent
    {  219, 5523,    5609,  5, }, // Asia/Aqtau
    {  219, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  219, 3049,    4619,  9, }, // Pacific/Kanton
    {  220, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/South Africa
    {  220, 2061,   60952,  9, }, // America/St_Johns
    {  220, 5863,   60961,  8, }, // America/St_Kitts
    {  220, 5880,   60969,  8, }, // America/St_Lucia
    {  220,  855,   60977,  9, }, // America/St_Thomas
    {  220, 5913,   60986, 10, }, // America/St_Vincent
    {  220, 5523,    5609,  5, }, // Asia/Aqtau
    {  220, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  220, 3049,    4619,  9, }, // Pacific/Kanton
    {  221, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/South Georgia and South Sandwich Islands
    {  221, 2061,   60952,  9, }, // America/St_Johns
    {  221, 5863,   60961,  8, }, // America/St_Kitts
    {  221, 5880,   60969,  8, }, // America/St_Lucia
    {  221,  855,   60977,  9, }, // America/St_Thomas
    {  221, 5913,   60986, 10, }, // America/St_Vincent
    {  221, 5523,    5609,  5, }, // Asia/Aqtau
    {  221, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  221, 3049,    4619,  9, }, // Pacific/Kanton
    {  222, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/South Sudan
    {  222, 2061,   60952,  9, }, // America/St_Johns
    {  222, 5863,   60961,  8, }, // America/St_Kitts
    {  222, 5880,   60969,  8, }, // America/St_Lucia
    {  222,  855,   60977,  9, }, // America/St_Thomas
    {  222, 5913,   60986, 10, }, // America/St_Vincent
    {  222, 5523,    5609,  5, }, // Asia/Aqtau
    {  222, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  222, 3049,    4619,  9, }, // Pacific/Kanton
    {  223, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Spain
    {  223, 2061,   60952,  9, }, // America/St_Johns
    {  223, 5863,   60961,  8, }, // America/St_Kitts
    {  223, 5880,   60969,  8, }, // America/St_Lucia
    {  223,  855,   60977,  9, }, // America/St_Thomas
    {  223, 5913,   60986, 10, }, // America/St_Vincent
    {  223, 5523,    5609,  5, }, // Asia/Aqtau
    {  223, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  223, 3049,    4619,  9, }, // Pacific/Kanton
    {  224, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Sudan
    {  224, 2061,   60952,  9, }, // America/St_Johns
    {  224, 5863,   60961,  8, }, // America/St_Kitts
    {  224, 5880,   60969,  8, }, // America/St_Lucia
    {  224,  855,   60977,  9, }, // America/St_Thomas
    {  224, 5913,   60986, 10, }, // America/St_Vincent
    {  224, 5523,    5609,  5, }, // Asia/Aqtau
    {  224, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  224, 3049,    4619,  9, }, // Pacific/Kanton
    {  225, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Sweden
    {  225, 2061,   60952,  9, }, // America/St_Johns
    {  225, 5863,   60961,  8, }, // America/St_Kitts
    {  225, 5880,   60969,  8, }, // America/St_Lucia
    {  225,  855,   60977,  9, }, // America/St_Thomas
    {  225, 5913,   60986, 10, }, // America/St_Vincent
    {  225, 5523,    5609,  5, }, // Asia/Aqtau
    {  225, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  225, 3049,    4619,  9, }, // Pacific/Kanton
    {  226, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Switzerland
    {  226, 2061,   60952,  9, }, // America/St_Johns
    {  226, 5863,   60961,  8, }, // America/St_Kitts
    {  226, 5880,   60969,  8, }, // America/St_Lucia
    {  226,  855,   60977,  9, }, // America/St_Thomas
    {  226, 5913,   60986, 10, }, // America/St_Vincent
    {  226, 5523,    5609,  5, }, // Asia/Aqtau
    {  226, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  226, 3049,    4619,  9, }, // Pacific/Kanton
    {  227, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Tanzania
    {  227, 2061,   60952,  9, }, // America/St_Johns
    {  227, 5863,   60961,  8, }, // America/St_Kitts
    {  227, 5880,   60969,  8, }, // America/St_Lucia
    {  227,  855,   60977,  9, }, // America/St_Thomas
    {  227, 5913,   60986, 10, }, // America/St_Vincent
    {  227, 5523,    5609,  5, }, // Asia/Aqtau
    {  227, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  227, 3049,    4619,  9, }, // Pacific/Kanton
    {  228, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Tokelau
    {  228, 2061,   60952,  9, }, // America/St_Johns
    {  228, 5863,   60961,  8, }, // America/St_Kitts
    {  228, 5880,   60969,  8, }, // America/St_Lucia
    {  228,  855,   60977,  9, }, // America/St_Thomas
    {  228, 5913,   60986, 10, }, // America/St_Vincent
    {  228, 5523,    5609,  5, }, // Asia/Aqtau
    {  228, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  228, 3049,    4619,  9, }, // Pacific/Kanton
    {  229, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Tonga
    {  229, 2061,   60952,  9, }, // America/St_Johns
    {  229, 5863,   60961,  8, }, // America/St_Kitts
    {  229, 5880,   60969,  8, }, // America/St_Lucia
    {  229,  855,   60977,  9, }, // America/St_Thomas
    {  229, 5913,   60986, 10, }, // America/St_Vincent
    {  229, 5523,    5609,  5, }, // Asia/Aqtau
    {  229, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  229, 3049,    4619,  9, }, // Pacific/Kanton
    {  230, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Trinidad and Tobago
    {  230, 2061,   60952,  9, }, // America/St_Johns
    {  230, 5863,   60961,  8, }, // America/St_Kitts
    {  230, 5880,   60969,  8, }, // America/St_Lucia
    {  230,  855,   60977,  9, }, // America/St_Thomas
    {  230, 5913,   60986, 10, }, // America/St_Vincent
    {  230, 5523,    5609,  5, }, // Asia/Aqtau
    {  230, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  230, 3049,    4619,  9, }, // Pacific/Kanton
    {  231, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Turks and Caicos Islands
    {  231, 2061,   60952,  9, }, // America/St_Johns
    {  231, 5863,   60961,  8, }, // America/St_Kitts
    {  231, 5880,   60969,  8, }, // America/St_Lucia
    {  231,  855,   60977,  9, }, // America/St_Thomas
    {  231, 5913,   60986, 10, }, // America/St_Vincent
    {  231, 5523,    5609,  5, }, // Asia/Aqtau
    {  231, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  231, 3049,    4619,  9, }, // Pacific/Kanton
    {  232, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Tuvalu
    {  232, 2061,   60952,  9, }, // America/St_Johns
    {  232, 5863,   60961,  8, }, // America/St_Kitts
    {  232, 5880,   60969,  8, }, // America/St_Lucia
    {  232,  855,   60977,  9, }, // America/St_Thomas
    {  232, 5913,   60986, 10, }, // America/St_Vincent
    {  232, 5523,    5609,  5, }, // Asia/Aqtau
    {  232, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  232, 3049,    4619,  9, }, // Pacific/Kanton
    {  233, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Uganda
    {  233, 2061,   60952,  9, }, // America/St_Johns
    {  233, 5863,   60961,  8, }, // America/St_Kitts
    {  233, 5880,   60969,  8, }, // America/St_Lucia
    {  233,  855,   60977,  9, }, // America/St_Thomas
    {  233, 5913,   60986, 10, }, // America/St_Vincent
    {  233, 5523,    5609,  5, }, // Asia/Aqtau
    {  233, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  233, 3049,    4619,  9, }, // Pacific/Kanton
    {  235, 7623,    3943, 14, }, // America/Bahia_Banderas English/Latin/United Kingdom
    {  235, 3868,   33314,  6, }, // America/Cancun
    {  235, 8220,    7126,  6, }, // America/Merida
    {  235, 8508,   60939, 13, }, // America/St_Barthelemy
    {  235, 2061,   60952,  9, }, // America/St_Johns
    {  235, 5863,   60961,  8, }, // America/St_Kitts
    {  235, 5880,   60969,  8, }, // America/St_Lucia
    {  235,  855,   60977,  9, }, // America/St_Thomas
    {  235, 5913,   60986, 10, }, // America/St_Vincent
    {  235, 5523,    5609,  5, }, // Asia/Aqtau
    {  235, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  235, 3049,    4619,  9, }, // Pacific/Kanton
    {  238, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Vanuatu
    {  238, 2061,   60952,  9, }, // America/St_Johns
    {  238, 5863,   60961,  8, }, // America/St_Kitts
    {  238, 5880,   60969,  8, }, // America/St_Lucia
    {  238,  855,   60977,  9, }, // America/St_Thomas
    {  238, 5913,   60986, 10, }, // America/St_Vincent
    {  238, 5523,    5609,  5, }, // Asia/Aqtau
    {  238, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  238, 3049,    4619,  9, }, // Pacific/Kanton
    {  239, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/world
    {  239, 2061,   60952,  9, }, // America/St_Johns
    {  239, 5863,   60961,  8, }, // America/St_Kitts
    {  239, 5880,   60969,  8, }, // America/St_Lucia
    {  239,  855,   60977,  9, }, // America/St_Thomas
    {  239, 5913,   60986, 10, }, // America/St_Vincent
    {  239, 5523,    5609,  5, }, // Asia/Aqtau
    {  239, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  239, 3049,    4619,  9, }, // Pacific/Kanton
    {  240, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Zambia
    {  240, 2061,   60952,  9, }, // America/St_Johns
    {  240, 5863,   60961,  8, }, // America/St_Kitts
    {  240, 5880,   60969,  8, }, // America/St_Lucia
    {  240,  855,   60977,  9, }, // America/St_Thomas
    {  240, 5913,   60986, 10, }, // America/St_Vincent
    {  240, 5523,    5609,  5, }, // Asia/Aqtau
    {  240, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  240, 3049,    4619,  9, }, // Pacific/Kanton
    {  241, 8508,   60939, 13, }, // America/St_Barthelemy English/Latin/Zimbabwe
    {  241, 2061,   60952,  9, }, // America/St_Johns
    {  241, 5863,   60961,  8, }, // America/St_Kitts
    {  241, 5880,   60969,  8, }, // America/St_Lucia
    {  241,  855,   60977,  9, }, // America/St_Thomas
    {  241, 5913,   60986, 10, }, // America/St_Vincent
    {  241, 5523,    5609,  5, }, // Asia/Aqtau
    {  241, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  241, 3049,    4619,  9, }, // Pacific/Kanton
    {  242, 1259,     432, 11, }, // Asia/Ho_Chi_Minh English/Shavian/United Kingdom
    {  243,   14,       0,  6, }, // Africa/Asmara Erzya/Cyrillic/Russia
    {  243, 4435,       6,  8, }, // Africa/Sao_Tome
    {  243, 4252,      14,  8, }, // America/Asuncion
    {  243,  237,      22,  8, }, // America/Atikokan
    {  243, 7623,      30, 17, }, // America/Bahia_Banderas
    {  243, 7699,   36531,  5, }, // America/Boise
    {  243, 3868,      47,  6, }, // America/Cancun
    {  243, 2260,   61005,  6, }, // America/Chicago
    {  243, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  243, 5723,      66,  7, }, // America/Curacao
    {  243,  805,    1319,  6, }, // America/Denver
    {  243, 5770,    1410,  7, }, // America/Grenada
    {  243,  481,      73, 13, }, // America/Indiana/Knox
    {  243, 7961,      86, 16, }, // America/Indiana/Marengo
    {  243, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  243, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  243, 8038,     139, 14, }, // America/Indiana/Vevay
    {  243, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  243, 8086,     171, 16, }, // America/Indiana/Winamac
    {  243, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  243, 5932,     207, 22, }, // America/Lower_Princes
    {  243, 8220,     229,  6, }, // America/Merida
    {  243, 1850,     235, 19, }, // America/Noronha
    {  243, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  243, 8329,     274, 20, }, // America/North_Dakota/Center
    {  243, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  243,  393,     317,  4, }, // America/Nuuk
    {  243, 2356,    1901,  6, }, // America/Panama
    {  243, 6899,     321, 16, }, // America/Scoresbysund
    {  243, 8508,     337, 14, }, // America/St_Barthelemy
    {  243, 2061,     351, 10, }, // America/St_Johns
    {  243, 5863,     361,  9, }, // America/St_Kitts
    {  243, 5880,     370,  9, }, // America/St_Lucia
    {  243,  855,     379, 10, }, // America/St_Thomas
    {  243, 5913,     389, 11, }, // America/St_Vincent
    {  243, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  243, 1429,   61011, 11, }, // Arctic/Longyearbyen
    {  243, 3607,    2355,  6, }, // Asia/Baghdad
    {  243, 3653,    2368,  4, }, // Asia/Baku
    {  243, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  243, 2704,   52034,  7, }, // Asia/Hong_Kong
    {  243, 1185,     448,  9, }, // Asia/Kathmandu
    {  243,  992,     457,  7, }, // Asia/Kolkata
    {  243, 1211,     464,  5, }, // Asia/Macau
    {  243, 4229,   61022,  6, }, // Asia/Omsk
    {  243, 4408,    2732,  7, }, // Asia/Sakhalin
    {  243, 7245,    2739,  9, }, // Asia/Samarkand
    {  243, 3279,    2748,  4, }, // Asia/Seoul
    {  243, 1053,   28933,  6, }, // Asia/Shanghai
    {  243, 3263,   61028,  6, }, // Asia/Taipei
    {  243, 4781,    2785,  7, }, // Asia/Tashkent
    {  243, 2821,    2810,  5, }, // Asia/Tokyo
    {  243, 4572,   61034,  7, }, // Asia/Tomsk
    {  243, 1021,   61041, 10, }, // Asia/Ulaanbaatar
    {  243, 1235,     477,  6, }, // Asia/Yangon
    {  243, 5671,   35284,  7, }, // Atlantic/Bermuda
    {  243, 1395,     483,  5, }, // Atlantic/Faroe
    {  243, 8736,   37264,  7, }, // Atlantic/Madeira
    {  243, 2748,   52214,  9, }, // Atlantic/Reykjavik
    {  243, 6821,     488, 10, }, // Atlantic/St_Helena
    {  243, 6441,    3111,  9, }, // Europe/Amsterdam
    {  243, 6216,    3120,  7, }, // Europe/Andorra
    {  243, 2300,   61051,  5, }, // Europe/Athens
    {  243, 6336,    3139,  7, }, // Europe/Belgrade
    {  243, 4757,    3146,  6, }, // Europe/Berlin
    {  243, 6488,    3152, 10, }, // Europe/Bratislava
    {  243, 2167,   52296,  8, }, // Europe/Brussels
    {  243, 3928,    3170,  8, }, // Europe/Bucharest
    {  243, 3806,    3178,  8, }, // Europe/Budapest
    {  243, 6289,   52323, 10, }, // Europe/Copenhagen
    {  243, 2338,    3226,  6, }, // Europe/Dublin
    {  243, 6612,   52333,  9, }, // Europe/Helsinki
    {  243, 8929,    3287,  5, }, // Europe/Kirov
    {  243, 2527,    3292,  4, }, // Europe/Kyiv
    {  243, 3213,    3296,  8, }, // Europe/Lisbon
    {  243, 6506,   29432,  7, }, // Europe/Ljubljana
    {  243, 2501,    3313,  6, }, // Europe/London
    {  243, 6365,   29445, 10, }, // Europe/Luxembourg
    {  243, 4892,    3330,  6, }, // Europe/Madrid
    {  243, 6397,   29461,  6, }, // Europe/Malta
    {  243, 3693,   61056,  7, }, // Europe/Minsk
    {  243, 6410,    3355,  6, }, // Europe/Monaco
    {  243, 3537,   61063,  6, }, // Europe/Moscow
    {  243, 6458,    3367,  4, }, // Europe/Oslo
    {  243, 4284,    3371,  5, }, // Europe/Paris
    {  243, 6424,    3376,  9, }, // Europe/Podgorica
    {  243, 6275,    3385,  5, }, // Europe/Prague
    {  243, 8837,    3390,  4, }, // Europe/Riga
    {  243, 6324,    3394,  3, }, // Europe/Rome
    {  243, 4331,    3397,  6, }, // Europe/Samara
    {  243, 6470,    3403, 10, }, // Europe/San_Marino
    {  243, 6245,    3413,  7, }, // Europe/Sarajevo
    {  243, 4451,    3420,  7, }, // Europe/Saratov
    {  243, 8849,   52357, 11, }, // Europe/Simferopol
    {  243, 6383,   52368,  6, }, // Europe/Skopje
    {  243, 6599,   37418,  5, }, // Europe/Sofia
    {  243, 6523,   52374,  9, }, // Europe/Stockholm
    {  243, 8867,    3455,  6, }, // Europe/Tallinn
    {  243, 6202,    3461,  6, }, // Europe/Tirane
    {  243, 6352,    3476,  5, }, // Europe/Vaduz
    {  243, 6567,    3481,  7, }, // Europe/Vatican
    {  243, 6231,    3488,  4, }, // Europe/Vienna
    {  243, 8899,   52392,  7, }, // Europe/Vilnius
    {  243, 3190,    3508,  7, }, // Europe/Warsaw
    {  243, 6261,    3515,  6, }, // Europe/Zagreb
    {  243, 6540,   37442,  5, }, // Europe/Zurich
    {  243, 7211,     547,  7, }, // Indian/Reunion
    {  243, 3157,     554,  5, }, // Pacific/Chuuk
    {  243, 3096,     586,  7, }, // Pacific/Pohnpei
    {  244, 6788,   61069,  7, }, // Africa/Abidjan Esperanto/Latin/world
    {  244, 6760,   61076,  5, }, // Africa/Accra
    {  244, 5059,   61081,  9, }, // Africa/Addis_Ababa
    {  244, 7420,   61090,  6, }, // Africa/Algiers
    {  244,   14,   61096,  6, }, // Africa/Asmara
    {  244, 5257,   61102,  5, }, // Africa/Bangui
    {  244, 6746,   61107,  7, }, // Africa/Banjul
    {  244, 7435,   61114,  6, }, // Africa/Bissau
    {  244, 5287,   61120,  9, }, // Africa/Brazzaville
    {  244, 4922,   61129,  9, }, // Africa/Bujumbura
    {  244, 2320,    4690,  5, }, // Africa/Cairo
    {  244, 4117,   61138, 10, }, // Africa/Casablanca
    {  244, 7449,   61148,  5, }, // Africa/Ceuta
    {  244, 6773,   61153,  8, }, // Africa/Conakry
    {  244, 6840,   61161,  6, }, // Africa/Dakar
    {  244, 5130,   61167, 10, }, // Africa/Dar_es_Salaam
    {  244, 5043,   61177,  7, }, // Africa/Djibouti
    {  244, 5243,   61184,  6, }, // Africa/Douala
    {  244, 5166,   61190,  5, }, // Africa/El_Aaiun
    {  244, 6853,   61195,  8, }, // Africa/Freetown
    {  244, 4906,   61203,  8, }, // Africa/Gaborone
    {  244, 5015,   61211,  7, }, // Africa/Harare
    {  244, 4479,   61218, 12, }, // Africa/Johannesburg
    {  244, 4499,   61230,  5, }, // Africa/Juba
    {  244, 5151,   61235,  7, }, // Africa/Kampala
    {  244, 4524,   61242,  7, }, // Africa/Khartoum
    {  244, 4973,   61249,  6, }, // Africa/Kigali
    {  244, 5306,   61255,  7, }, // Africa/Kinshasa
    {  244, 4744,   61262,  6, }, // Africa/Lagos
    {  244, 5336,   61268,  9, }, // Africa/Libreville
    {  244, 6869,   61277,  5, }, // Africa/Lome
    {  244, 5211,   61282,  6, }, // Africa/Luanda
    {  244, 4939,   61288,  9, }, // Africa/Lubumbashi
    {  244, 5001,   61297,  6, }, // Africa/Lusaka
    {  244, 5197,   61303,  7, }, // Africa/Maseru
    {  244, 5182,   61310,  7, }, // Africa/Mbabane
    {  244, 5113,   61317,  8, }, // Africa/Mogadishu
    {  244, 7034,   61325,  8, }, // Africa/Monrovia
    {  244, 3853,   61333,  8, }, // Africa/Nairobi
    {  244, 5271,   61341,  8, }, // Africa/Ndjamena
    {  244, 5354,   61349,  7, }, // Africa/Niamey
    {  244, 6803,   61356,  8, }, // Africa/Nouakchott
    {  244, 6727,   61364,  9, }, // Africa/Ouagadougou
    {  244, 5225,   61373,  9, }, // Africa/Porto-Novo
    {  244, 4435,   61382,  8, }, // Africa/Sao_Tome
    {  244, 2866,   61390,  7, }, // Africa/Tripoli
    {  244, 6554,   61397,  6, }, // Africa/Tunis
    {  244, 4152,   61403,  8, }, // Africa/Windhoek
    {  244, 5607,   61411,  7, }, // America/Anguilla
    {  244, 5624,   61418,  7, }, // America/Antigua
    {  244, 4554,   26559,  9, }, // America/Araguaina
    {  244,  166,   61425,  7, }, // America/Argentina/Buenos_Aires
    {  244,  270,   61432,  7, }, // America/Argentina/Cordoba
    {  244, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  244, 7520,   61439,  9, }, // America/Argentina/Salta
    {  244, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  244, 5640,   61448,  5, }, // America/Aruba
    {  244, 4252,   61453,  9, }, // America/Asuncion
    {  244,  237,      22,  8, }, // America/Atikokan
    {  244, 3679,   61462,  5, }, // America/Bahia
    {  244, 7623,      30, 17, }, // America/Bahia_Banderas
    {  244, 5654,   61467,  7, }, // America/Barbados
    {  244, 7646,   61474,  6, }, // America/Belem
    {  244, 5407,   61480,  6, }, // America/Belize
    {  244, 4361,   61486,  6, }, // America/Bogota
    {  244, 7713,   61492, 14, }, // America/Cambridge_Bay
    {  244, 3868,   61506,  7, }, // America/Cancun
    {  244, 4694,   61513,  8, }, // America/Caracas
    {  244, 4345,   61521,  6, }, // America/Cayenne
    {  244, 5496,   61527,  8, }, // America/Cayman
    {  244, 2260,   61535,  6, }, // America/Chicago
    {  244, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  244, 5422,   61541,  9, }, // America/Costa_Rica
    {  244, 3791,   26574,  6, }, // America/Cuiaba
    {  244, 5723,   61550,  7, }, // America/Curacao
    {  244,  805,   61557,  7, }, // America/Denver
    {  244, 3465,   61564,  8, }, // America/Detroit
    {  244, 5739,   61572,  8, }, // America/Dominica
    {  244,  893,   61580,  9, }, // America/Edmonton
    {  244, 7869,   26580,  8, }, // America/Eirunepe
    {  244, 5441,   61589,  9, }, // America/El_Salvador
    {  244, 7906,   61598,  9, }, // America/Fortaleza
    {  244, 4612,   61607, 12, }, // America/Grand_Turk
    {  244, 5770,   61619,  7, }, // America/Grenada
    {  244, 5786,   61626,  9, }, // America/Guadeloupe
    {  244, 3760,   61635,  9, }, // America/Guatemala
    {  244, 6932,   61644,  6, }, // America/Guyana
    {  244, 1939,   61650,  9, }, // America/Halifax
    {  244, 2281,   61659,  6, }, // America/Havana
    {  244,  348,   61665, 21, }, // America/Indiana/Indianapolis
    {  244,  481,   61686, 14, }, // America/Indiana/Knox
    {  244, 7961,   61700, 17, }, // America/Indiana/Marengo
    {  244, 7985,   61717, 20, }, // America/Indiana/Petersburg
    {  244, 8012,   61737, 19, }, // America/Indiana/Tell_City
    {  244, 8038,   61756, 15, }, // America/Indiana/Vevay
    {  244, 8060,   61771, 19, }, // America/Indiana/Vincennes
    {  244, 8086,   61790, 17, }, // America/Indiana/Winamac
    {  244,  660,   61807,  8, }, // America/Iqaluit
    {  244, 2799,   61815,  7, }, // America/Jamaica
    {  244, 8125,   61822, 20, }, // America/Kentucky/Monticello
    {  244, 7169,   61842,  4, }, // America/Lima
    {  244, 3239,   61846, 11, }, // America/Los_Angeles
    {  244, 5932,     207, 22, }, // America/Lower_Princes
    {  244, 8153,   26588,  6, }, // America/Maceio
    {  244, 8168,   61857,  7, }, // America/Managua
    {  244, 1908,   61864,  7, }, // America/Manaus
    {  244, 5897,   61871,  8, }, // America/Marigot
    {  244, 5805,   61879,  9, }, // America/Martinique
    {  244, 2917,   26603,  8, }, // America/Mazatlan
    {  244, 8220,   61888,  6, }, // America/Merida
    {  244, 2949,   61894, 10, }, // America/Mexico_City
    {  244, 4391,   61904,  8, }, // America/Miquelon
    {  244, 8254,   61912,  8, }, // America/Moncton
    {  244, 8270,   61920,  9, }, // America/Monterrey
    {  244, 5824,   61929,  9, }, // America/Montserrat
    {  244, 5481,   61938,  6, }, // America/Nassau
    {  244, 2379,   61944,  8, }, // America/New_York
    {  244, 1850,     235, 19, }, // America/Noronha
    {  244, 8301,   61952, 20, }, // America/North_Dakota/Beulah
    {  244, 8329,   61972, 20, }, // America/North_Dakota/Center
    {  244, 8357,   61992, 23, }, // America/North_Dakota/New_Salem
    {  244,  393,   62015,  4, }, // America/Nuuk
    {  244, 2356,   62019,  6, }, // America/Panama
    {  244, 2973,   62025,  7, }, // America/Phoenix
    {  244, 3945,   62032, 11, }, // America/Port-au-Prince
    {  244, 5954,   62043, 10, }, // America/Port_of_Spain
    {  244, 5843,   62053, 10, }, // America/Puerto_Rico
    {  244, 8477,   26704,  8, }, // America/Santarem
    {  244, 6111,   62063, 14, }, // America/Santo_Domingo
    {  244, 1878,   62077,  8, }, // America/Sao_Paulo
    {  244, 6899,     321, 16, }, // America/Scoresbysund
    {  244, 8508,   62085, 17, }, // America/St_Barthelemy
    {  244, 2061,     351, 10, }, // America/St_Johns
    {  244, 5863,   62102, 17, }, // America/St_Kitts
    {  244, 5880,   62119, 12, }, // America/St_Lucia
    {  244,  855,   62131, 13, }, // America/St_Thomas
    {  244, 5913,   62144, 15, }, // America/St_Vincent
    {  244, 5461,   62159, 11, }, // America/Tegucigalpa
    {  244, 5756,   26796,  7, }, // America/Thule
    {  244, 2093,   62170,  9, }, // America/Vancouver
    {  244,  734,   62179,  8, }, // America/Winnipeg
    {  244, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  244, 8568,   62187, 14, }, // Antarctica/Macquarie
    {  244, 7295,   62201,  5, }, // Antarctica/Syowa
    {  244, 1429,   62206, 11, }, // Arctic/Longyearbyen
    {  244, 5570,   62217,  5, }, // Asia/Aden
    {  244, 5395,   62222,  6, }, // Asia/Almaty
    {  244, 3968,   62228,  5, }, // Asia/Amman
    {  244, 5511,    7600,  6, }, // Asia/Anadyr
    {  244, 5523,    5609,  5, }, // Asia/Aqtau
    {  244, 5368,    7606,  6, }, // Asia/Aqtobe
    {  244,  964,   62233,  8, }, // Asia/Ashgabat
    {  244, 8624,    7612,  6, }, // Asia/Atyrau
    {  244, 3607,   62241,  7, }, // Asia/Baghdad
    {  244, 5534,   62248,  7, }, // Asia/Bahrain
    {  244, 3653,   62255,  5, }, // Asia/Baku
    {  244, 4466,   62260,  7, }, // Asia/Bangkok
    {  244, 4086,   62267,  7, }, // Asia/Beirut
    {  244, 3778,   62274,  7, }, // Asia/Bishkek
    {  244, 5989,   62281,  7, }, // Asia/Brunei
    {  244, 4601,   62288,  4, }, // Asia/Chita
    {  244, 4511,    5637,  7, }, // Asia/Colombo
    {  244, 4540,   26821,  7, }, // Asia/Damascus
    {  244, 1093,     268,  4, }, // Asia/Dhaka
    {  244, 6192,   62292,  4, }, // Asia/Dili
    {  244, 3596,   62296,  9, }, // Asia/Dubai
    {  244, 6159,   62305,  8, }, // Asia/Dushanbe
    {  244, 8651,   62313,  5, }, // Asia/Gaza
    {  244, 4795,   62318,  7, }, // Asia/Hebron
    {  244, 1259,   62325,  8, }, // Asia/Ho_Chi_Minh
    {  244, 2704,   62333,  8, }, // Asia/Hong_Kong
    {  244, 4771,   62341,  4, }, // Asia/Hovd
    {  244, 4184,   62345,  8, }, // Asia/Irkutsk
    {  244, 7006,   62353,  7, }, // Asia/Jakarta
    {  244, 1290,   62360, 10, }, // Asia/Jerusalem
    {  244, 3560,   62370,  6, }, // Asia/Kabul
    {  244, 4316,   62376,  8, }, // Asia/Kamchatka
    {  244, 4239,   62384,  7, }, // Asia/Karachi
    {  244, 1185,   62391,  9, }, // Asia/Kathmandu
    {  244, 8661,   62400,  7, }, // Asia/Khandyga
    {  244,  992,   62407,  7, }, // Asia/Kolkata
    {  244, 4197,   62414, 12, }, // Asia/Krasnoyarsk
    {  244, 4859,   62426, 12, }, // Asia/Kuala_Lumpur
    {  244, 5547,   62438,  7, }, // Asia/Kuwait
    {  244, 1211,    7731,  5, }, // Asia/Macau
    {  244, 7182,   62445,  6, }, // Asia/Manila
    {  244, 6920,   62451,  7, }, // Asia/Muscat
    {  244, 2554,   62458,  7, }, // Asia/Nicosia
    {  244, 8675,   62465, 12, }, // Asia/Novokuznetsk
    {  244, 4135,   62477, 12, }, // Asia/Novosibirsk
    {  244, 4229,   62489,  5, }, // Asia/Omsk
    {  244, 7145,   62494,  5, }, // Asia/Oral
    {  244, 6961,   62499,  8, }, // Asia/Phnom_Penh
    {  244, 4214,   62507, 10, }, // Asia/Pyongyang
    {  244, 5559,   62517,  6, }, // Asia/Qatar
    {  244, 8708,    7770,  8, }, // Asia/Qostanay
    {  244, 4269,   62523,  9, }, // Asia/Qyzylorda
    {  244, 3584,   62532,  5, }, // Asia/Riyadh
    {  244, 4408,   62537,  8, }, // Asia/Sakhalin
    {  244, 7245,   62545, 10, }, // Asia/Samarkand
    {  244, 3279,   62555,  5, }, // Asia/Seoul
    {  244, 1053,   62560,  7, }, // Asia/Shanghai
    {  244, 3300,   62567,  9, }, // Asia/Singapore
    {  244, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {  244, 3263,   62576,  6, }, // Asia/Taipei
    {  244, 4781,   62582,  8, }, // Asia/Tashkent
    {  244, 3915,   62590,  7, }, // Asia/Tbilisi
    {  244, 2772,   62597,  8, }, // Asia/Tehran
    {  244, 1317,   62605,  6, }, // Asia/Thimphu
    {  244, 2821,    4356,  5, }, // Asia/Tokyo
    {  244, 1021,   62611, 10, }, // Asia/Ulaanbaatar
    {  244, 1159,   62621,  7, }, // Asia/Urumqi
    {  244, 8722,   62628,  7, }, // Asia/Ust-Nera
    {  244, 6977,   62635,  9, }, // Asia/Vientiane
    {  244, 4710,   62644, 12, }, // Asia/Vladivostok
    {  244, 4828,   62656,  8, }, // Asia/Yakutsk
    {  244, 1235,   62664,  7, }, // Asia/Yangon
    {  244, 3883,   62671, 14, }, // Asia/Yekaterinburg
    {  244, 3747,   62685,  7, }, // Asia/Yerevan
    {  244, 3663,   62692,  6, }, // Atlantic/Azores
    {  244, 5671,   62698,  8, }, // Atlantic/Bermuda
    {  244, 6628,   62706,  8, }, // Atlantic/Canary
    {  244, 3727,   62714,  9, }, // Atlantic/Cape_Verde
    {  244, 1395,   62723,  6, }, // Atlantic/Faroe
    {  244, 8736,   62729,  7, }, // Atlantic/Madeira
    {  244, 2748,   62736, 10, }, // Atlantic/Reykjavik
    {  244, 7272,   62746, 11, }, // Atlantic/South_Georgia
    {  244, 6821,   62757, 13, }, // Atlantic/St_Helena
    {  244, 6644,   62770,  8, }, // Atlantic/Stanley
    {  244, 1670,   62778,  8, }, // Australia/Adelaide
    {  244, 1635,   62786,  8, }, // Australia/Brisbane
    {  244, 1583,   62794,  7, }, // Australia/Darwin
    {  244, 1516,   62801,  7, }, // Australia/Hobart
    {  244, 1727,   62808,  8, }, // Australia/Melbourne
    {  244, 1762,   62816,  5, }, // Australia/Perth
    {  244, 1463,   62821,  7, }, // Australia/Sydney
    {  244, 6441,   62828, 10, }, // Europe/Amsterdam
    {  244, 6216,   62838,  6, }, // Europe/Andorra
    {  244, 3620,   62844,  9, }, // Europe/Astrakhan
    {  244, 2300,   62853,  5, }, // Europe/Athens
    {  244, 6336,   62858,  8, }, // Europe/Belgrade
    {  244, 4757,   62866,  7, }, // Europe/Berlin
    {  244, 6488,   62873, 10, }, // Europe/Bratislava
    {  244, 2167,   62883,  7, }, // Europe/Brussels
    {  244, 3928,   62890,  9, }, // Europe/Bucharest
    {  244, 3806,   62899,  9, }, // Europe/Budapest
    {  244, 8772,   62908, 21, }, // Europe/Busingen
    {  244, 2583,   62929,  8, }, // Europe/Chisinau
    {  244, 6289,   62937,  9, }, // Europe/Copenhagen
    {  244, 2338,   62946,  7, }, // Europe/Dublin
    {  244, 6307,   62953, 10, }, // Europe/Gibraltar
    {  244, 8788,   62963,  9, }, // Europe/Guernsey
    {  244, 6612,   62972,  8, }, // Europe/Helsinki
    {  244, 8804,   62980, 10, }, // Europe/Isle_of_Man
    {  244, 1130,   62990,  9, }, // Europe/Istanbul
    {  244, 8823,   62999,  7, }, // Europe/Jersey
    {  244, 3979,   63006, 12, }, // Europe/Kaliningrad
    {  244, 2527,   63018,  5, }, // Europe/Kyiv
    {  244, 3213,   63023,  7, }, // Europe/Lisbon
    {  244, 6506,   63030,  9, }, // Europe/Ljubljana
    {  244, 2501,   63039,  7, }, // Europe/London
    {  244, 6365,   63046, 11, }, // Europe/Luxembourg
    {  244, 4892,   63057,  7, }, // Europe/Madrid
    {  244, 6397,   63064,  5, }, // Europe/Malta
    {  244, 3693,   63069,  6, }, // Europe/Minsk
    {  244, 6410,    6044,  6, }, // Europe/Monaco
    {  244, 3537,   63075,  6, }, // Europe/Moscow
    {  244, 4284,   63081,  6, }, // Europe/Paris
    {  244, 6424,   63087,  9, }, // Europe/Podgorica
    {  244, 6275,   63096,  5, }, // Europe/Prague
    {  244, 8837,   63101,  4, }, // Europe/Riga
    {  244, 6324,   63105,  4, }, // Europe/Rome
    {  244, 6470,   63109,  9, }, // Europe/San_Marino
    {  244, 8849,   63118, 11, }, // Europe/Simferopol
    {  244, 6383,   63129,  6, }, // Europe/Skopje
    {  244, 6599,   63135,  5, }, // Europe/Sofia
    {  244, 6523,   63140,  9, }, // Europe/Stockholm
    {  244, 8867,   63149,  6, }, // Europe/Tallinn
    {  244, 6202,   63155,  6, }, // Europe/Tirane
    {  244, 8882,   63161, 10, }, // Europe/Ulyanovsk
    {  244, 6352,   63171,  6, }, // Europe/Vaduz
    {  244, 6567,   27101,  8, }, // Europe/Vatican
    {  244, 6231,   63177,  5, }, // Europe/Vienna
    {  244, 8899,   63182,  5, }, // Europe/Vilnius
    {  244, 4727,   63187, 10, }, // Europe/Volgograd
    {  244, 3190,   63197,  8, }, // Europe/Warsaw
    {  244, 6261,   63205,  7, }, // Europe/Zagreb
    {  244, 6540,   63212,  6, }, // Europe/Zurich
    {  244, 6947,   63218,  7, }, // Indian/Chagos
    {  244, 6046,   63225, 15, }, // Indian/Christmas
    {  244, 6063,   63240, 12, }, // Indian/Cocos
    {  244, 5029,   63252,  7, }, // Indian/Comoro
    {  244, 6661,   63259, 10, }, // Indian/Kerguelen
    {  244, 7260,   27115,  4, }, // Indian/Mahe
    {  244, 7050,   63269,  8, }, // Indian/Maldives
    {  244, 4069,   63277,  8, }, // Indian/Mauritius
    {  244, 5098,   63285,  6, }, // Indian/Mayotte
    {  244, 7211,   63291,  6, }, // Indian/Reunion
    {  244, 4422,   63297,  4, }, // Pacific/Apia
    {  244,  932,   63301,  8, }, // Pacific/Auckland
    {  244, 3015,   63309,  7, }, // Pacific/Chatham
    {  244, 3157,   63316,  4, }, // Pacific/Chuuk
    {  244, 2237,   63320, 10, }, // Pacific/Easter
    {  244, 3902,   63330,  5, }, // Pacific/Fiji
    {  244, 7343,   63335,  9, }, // Pacific/Funafuti
    {  244, 6678,   63344,  9, }, // Pacific/Galapagos
    {  244, 6018,   63353,  5, }, // Pacific/Guam
    {  244, 4051,   63358, 13, }, // Pacific/Marquesas
    {  244, 8914,   63371, 13, }, // Pacific/Midway
    {  244, 7084,   63384,  5, }, // Pacific/Nauru
    {  244, 7132,   63389,  4, }, // Pacific/Niue
    {  244, 4168,   63393, 13, }, // Pacific/Norfolk
    {  244, 7098,   63406,  5, }, // Pacific/Noumea
    {  244, 3126,   63411,  8, }, // Pacific/Pago_Pago
    {  244, 7155,   63419,  6, }, // Pacific/Palau
    {  244, 7194,   63425, 15, }, // Pacific/Pitcairn
    {  244, 3096,    8429,  6, }, // Pacific/Pohnpei
    {  244, 6076,   63440,  9, }, // Pacific/Rarotonga
    {  244, 6031,   63449,  7, }, // Pacific/Saipan
    {  244, 7312,   63456,  7, }, // Pacific/Tahiti
    {  244, 6712,   63463,  6, }, // Pacific/Tarawa
    {  244, 7392,   63469, 10, }, // Pacific/Wake
    {  244, 7405,   63479,  6, }, // Pacific/Wallis
    {  245, 5059,    3902, 11, }, // Africa/Addis_Ababa Estonian/Latin/Estonia
    {  245, 7420,   63485,  6, }, // Africa/Algiers
    {  245,   14,       0,  6, }, // Africa/Asmara
    {  245, 2320,    4690,  5, }, // Africa/Cairo
    {  245, 5166,   63491,  8, }, // Africa/El_Aaiun
    {  245, 4524,   63499,  6, }, // Africa/Khartoum
    {  245, 6869,   20418,  4, }, // Africa/Lome
    {  245, 5113,   26511,  8, }, // Africa/Mogadishu
    {  245, 5271,   44128,  9, }, // Africa/Ndjamena
    {  245, 4435,       6,  8, }, // Africa/Sao_Tome
    {  245, 4554,   26559,  9, }, // America/Araguaina
    {  245,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  245, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  245, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  245, 4252,      14,  8, }, // America/Asuncion
    {  245,  237,      22,  8, }, // America/Atikokan
    {  245, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  245, 7646,   35896,  5, }, // America/Belem
    {  245, 4361,   20507,  6, }, // America/Bogota
    {  245, 3868,      47,  6, }, // America/Cancun
    {  245, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  245, 3791,   26574,  6, }, // America/Cuiaba
    {  245, 5723,      66,  7, }, // America/Curacao
    {  245, 7869,   26580,  8, }, // America/Eirunepe
    {  245, 2281,   63505,  7, }, // America/Havana
    {  245,  481,      73, 13, }, // America/Indiana/Knox
    {  245, 7961,      86, 16, }, // America/Indiana/Marengo
    {  245, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  245, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  245, 8038,     139, 14, }, // America/Indiana/Vevay
    {  245, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  245, 8086,     171, 16, }, // America/Indiana/Winamac
    {  245, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  245, 5932,     207, 22, }, // America/Lower_Princes
    {  245, 8153,   26588,  6, }, // America/Maceio
    {  245, 2917,   26603,  8, }, // America/Mazatlan
    {  245, 8220,     229,  6, }, // America/Merida
    {  245, 2949,   57601,  6, }, // America/Mexico_City
    {  245, 1850,     235, 19, }, // America/Noronha
    {  245, 8301,   63512, 20, }, // America/North_Dakota/Beulah
    {  245, 8329,   63532, 20, }, // America/North_Dakota/Center
    {  245, 8357,   63552, 23, }, // America/North_Dakota/New_Salem
    {  245,  393,     317,  4, }, // America/Nuuk
    {  245, 8477,   26704,  8, }, // America/Santarem
    {  245, 1878,   26712,  9, }, // America/Sao_Paulo
    {  245, 6899,     321, 16, }, // America/Scoresbysund
    {  245, 8508,   26721, 16, }, // America/St_Barthelemy
    {  245, 2061,   26737, 12, }, // America/St_Johns
    {  245, 5863,   26749, 11, }, // America/St_Kitts
    {  245, 5880,   35964, 11, }, // America/St_Lucia
    {  245,  855,   44293, 12, }, // America/St_Thomas
    {  245, 5913,   26783, 13, }, // America/St_Vincent
    {  245, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  245, 5395,   63575,  6, }, // Asia/Almaty
    {  245, 5511,   63581,  6, }, // Asia/Anadyr
    {  245, 5523,    5609,  5, }, // Asia/Aqtau
    {  245, 5368,   63587,  6, }, // Asia/Aqtobe
    {  245,  964,   44322,  7, }, // Asia/Ashgabat
    {  245, 8624,   63593,  6, }, // Asia/Atyrau
    {  245, 3607,    4162,  6, }, // Asia/Baghdad
    {  245, 5534,    4168,  7, }, // Asia/Bahrain
    {  245, 3653,   63599,  5, }, // Asia/Baku
    {  245, 3778,   33455,  6, }, // Asia/Bishkek
    {  245, 4601,   63604,  5, }, // Asia/Chita
    {  245, 4540,    4201,  8, }, // Asia/Damascus
    {  245, 6159,   33468,  7, }, // Asia/Dushanbe
    {  245, 1259,   63609, 11, }, // Asia/Ho_Chi_Minh
    {  245, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  245, 1290,   63620, 11, }, // Asia/Jerusalem
    {  245, 4316,   63631,  9, }, // Asia/Kamchatka
    {  245, 1185,    5711,  8, }, // Asia/Kathmandu
    {  245, 8661,   63640,  7, }, // Asia/Khandyga
    {  245,  992,     457,  7, }, // Asia/Kolkata
    {  245, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  245, 5547,   63647,  6, }, // Asia/Kuwait
    {  245, 1211,    4321,  5, }, // Asia/Macau
    {  245, 6920,   63653,  6, }, // Asia/Muscat
    {  245, 2554,    5738,  7, }, // Asia/Nicosia
    {  245, 5559,    4332,  5, }, // Asia/Qatar
    {  245, 8708,    7770,  8, }, // Asia/Qostanay
    {  245, 4269,   63659,  9, }, // Asia/Qyzylorda
    {  245, 3584,   63668,  8, }, // Asia/Riyadh
    {  245, 4408,   63676,  8, }, // Asia/Sakhalin
    {  245, 3279,   58092,  4, }, // Asia/Seoul
    {  245, 3300,   20900,  8, }, // Asia/Singapore
    {  245, 4297,   63684, 13, }, // Asia/Srednekolymsk
    {  245, 4781,   33589,  7, }, // Asia/Tashkent
    {  245, 3915,   63697,  8, }, // Asia/Tbilisi
    {  245, 2772,    7842,  7, }, // Asia/Tehran
    {  245, 2821,   63705,  5, }, // Asia/Tokyo
    {  245, 1159,   26933,  6, }, // Asia/Urumqi
    {  245, 4828,    7873,  7, }, // Asia/Yakutsk
    {  245, 1235,     477,  6, }, // Asia/Yangon
    {  245, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  245, 3747,    7898,  7, }, // Asia/Yerevan
    {  245, 3663,   63710,  8, }, // Atlantic/Azores
    {  245, 6628,   63718, 14, }, // Atlantic/Canary
    {  245, 3727,   63732, 15, }, // Atlantic/Cape_Verde
    {  245, 1395,   63747, 12, }, // Atlantic/Faroe
    {  245, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  245, 7272,   63759, 13, }, // Atlantic/South_Georgia
    {  245, 6821,   36198, 12, }, // Atlantic/St_Helena
    {  245, 3620,   33644,  8, }, // Europe/Astrakhan
    {  245, 2300,   63772,  6, }, // Europe/Athens
    {  245, 6336,   27015,  7, }, // Europe/Belgrade
    {  245, 4757,   63778,  7, }, // Europe/Berlin
    {  245, 2167,   22766,  7, }, // Europe/Brussels
    {  245, 3928,   27029,  8, }, // Europe/Bucharest
    {  245, 8772,   27037,  8, }, // Europe/Busingen
    {  245, 2583,   63785,  8, }, // Europe/Chisinau
    {  245, 6289,   63793, 11, }, // Europe/Copenhagen
    {  245, 6612,   63804,  8, }, // Europe/Helsinki
    {  245, 8804,   63812,  9, }, // Europe/Isle_of_Man
    {  245, 1130,   22825,  8, }, // Europe/Istanbul
    {  245, 2527,   63821,  5, }, // Europe/Kyiv
    {  245, 3213,    4499,  8, }, // Europe/Lisbon
    {  245, 6582,   63826, 13, }, // Europe/Mariehamn
    {  245, 3537,   22880,  6, }, // Europe/Moscow
    {  245, 4284,   63839,  6, }, // Europe/Paris
    {  245, 6275,   36285,  5, }, // Europe/Prague
    {  245, 8837,   63845,  4, }, // Europe/Riga
    {  245, 6324,   63849,  5, }, // Europe/Rome
    {  245, 6202,   21213,  6, }, // Europe/Tirane
    {  245, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {  245, 6567,    6096,  7, }, // Europe/Vatican
    {  245, 6231,   63854,  4, }, // Europe/Vienna
    {  245, 3190,   63858,  8, }, // Europe/Warsaw
    {  245, 6540,    4577,  6, }, // Europe/Zurich
    {  245, 6046,   63866,  9, }, // Indian/Christmas
    {  245, 6063,   63875, 12, }, // Indian/Cocos
    {  245, 7260,   27115,  4, }, // Indian/Mahe
    {  245, 7050,   63887,  9, }, // Indian/Maldives
    {  245, 7211,     547,  7, }, // Indian/Reunion
    {  245, 3157,     554,  5, }, // Pacific/Chuuk
    {  245, 2237,   63896, 13, }, // Pacific/Easter
    {  245, 3902,   33836,  5, }, // Pacific/Fiji
    {  245, 6678,   21277,  9, }, // Pacific/Galapagos
    {  245, 2723,    4611,  8, }, // Pacific/Honolulu
    {  245, 3049,    4619,  9, }, // Pacific/Kanton
    {  245, 4051,   63909, 12, }, // Pacific/Marquesas
    {  245, 7098,    4628,  6, }, // Pacific/Noumea
    {  245, 7155,   63921,  5, }, // Pacific/Palau
    {  245, 3096,     586,  7, }, // Pacific/Pohnpei
    {  246,   14,       0,  6, }, // Africa/Asmara Ewe/Latin/Ghana
    {  246, 4435,       6,  8, }, // Africa/Sao_Tome
    {  246, 4252,      14,  8, }, // America/Asuncion
    {  246,  237,      22,  8, }, // America/Atikokan
    {  246, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  246, 3868,   33314,  6, }, // America/Cancun
    {  246, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  246, 5723,      66,  7, }, // America/Curacao
    {  246,  481,      73, 13, }, // America/Indiana/Knox
    {  246, 7961,      86, 16, }, // America/Indiana/Marengo
    {  246, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  246, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  246, 8038,     139, 14, }, // America/Indiana/Vevay
    {  246, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  246, 8086,     171, 16, }, // America/Indiana/Winamac
    {  246, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  246, 5932,     207, 22, }, // America/Lower_Princes
    {  246, 8220,    7126,  6, }, // America/Merida
    {  246, 1850,     235, 19, }, // America/Noronha
    {  246, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  246, 8329,     274, 20, }, // America/North_Dakota/Center
    {  246, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  246,  393,     317,  4, }, // America/Nuuk
    {  246, 6899,     321, 16, }, // America/Scoresbysund
    {  246, 8508,     337, 14, }, // America/St_Barthelemy
    {  246, 2061,     351, 10, }, // America/St_Johns
    {  246, 5863,     361,  9, }, // America/St_Kitts
    {  246, 5880,     370,  9, }, // America/St_Lucia
    {  246,  855,     379, 10, }, // America/St_Thomas
    {  246, 5913,     389, 11, }, // America/St_Vincent
    {  246, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  246, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  246, 1185,   63926, 24, }, // Asia/Kathmandu
    {  246,  992,     457,  7, }, // Asia/Kolkata
    {  246, 1211,    4321,  5, }, // Asia/Macau
    {  246, 1235,     477,  6, }, // Asia/Yangon
    {  246, 1395,     483,  5, }, // Atlantic/Faroe
    {  246, 6821,     488, 10, }, // Atlantic/St_Helena
    {  246, 2527,    8148,  4, }, // Europe/Kyiv
    {  246, 7211,     547,  7, }, // Indian/Reunion
    {  246, 3157,     554,  5, }, // Pacific/Chuuk
    {  246, 2723,    4611,  8, }, // Pacific/Honolulu
    {  246, 3049,    4619,  9, }, // Pacific/Kanton
    {  246, 3096,     586,  7, }, // Pacific/Pohnpei
    {  248,   14,       0,  6, }, // Africa/Asmara Ewondo/Latin/Cameroon
    {  248, 4435,       6,  8, }, // Africa/Sao_Tome
    {  248, 4252,      14,  8, }, // America/Asuncion
    {  248,  237,      22,  8, }, // America/Atikokan
    {  248, 7623,      30, 17, }, // America/Bahia_Banderas
    {  248, 3868,      47,  6, }, // America/Cancun
    {  248, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  248, 5723,      66,  7, }, // America/Curacao
    {  248,  481,      73, 13, }, // America/Indiana/Knox
    {  248, 7961,      86, 16, }, // America/Indiana/Marengo
    {  248, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  248, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  248, 8038,     139, 14, }, // America/Indiana/Vevay
    {  248, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  248, 8086,     171, 16, }, // America/Indiana/Winamac
    {  248, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  248, 5932,     207, 22, }, // America/Lower_Princes
    {  248, 8220,     229,  6, }, // America/Merida
    {  248, 1850,     235, 19, }, // America/Noronha
    {  248, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  248, 8329,     274, 20, }, // America/North_Dakota/Center
    {  248, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  248,  393,     317,  4, }, // America/Nuuk
    {  248, 6899,     321, 16, }, // America/Scoresbysund
    {  248, 8508,     337, 14, }, // America/St_Barthelemy
    {  248, 2061,     351, 10, }, // America/St_Johns
    {  248, 5863,     361,  9, }, // America/St_Kitts
    {  248, 5880,     370,  9, }, // America/St_Lucia
    {  248,  855,     379, 10, }, // America/St_Thomas
    {  248, 5913,     389, 11, }, // America/St_Vincent
    {  248, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  248, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  248, 1185,     448,  9, }, // Asia/Kathmandu
    {  248,  992,     457,  7, }, // Asia/Kolkata
    {  248, 1211,     464,  5, }, // Asia/Macau
    {  248, 1235,     477,  6, }, // Asia/Yangon
    {  248, 1395,     483,  5, }, // Atlantic/Faroe
    {  248, 6821,     488, 10, }, // Atlantic/St_Helena
    {  248, 2527,     514,  4, }, // Europe/Kyiv
    {  248, 7211,     547,  7, }, // Indian/Reunion
    {  248, 3157,     554,  5, }, // Pacific/Chuuk
    {  248, 3096,     586,  7, }, // Pacific/Pohnpei
    {  249,   14,       0,  6, }, // Africa/Asmara Faroese/Latin/Faroe Islands
    {  249, 5043,   26492,  7, }, // Africa/Djibouti
    {  249, 4435,       6,  8, }, // Africa/Sao_Tome
    {  249, 4252,      14,  8, }, // America/Asuncion
    {  249,  237,      22,  8, }, // America/Atikokan
    {  249, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  249, 5407,   63950,  5, }, // America/Belize
    {  249, 3868,   33314,  6, }, // America/Cancun
    {  249, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  249, 5422,   21621, 10, }, // America/Costa_Rica
    {  249, 5723,      66,  7, }, // America/Curacao
    {  249,  481,      73, 13, }, // America/Indiana/Knox
    {  249, 7961,      86, 16, }, // America/Indiana/Marengo
    {  249, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  249, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  249, 8038,     139, 14, }, // America/Indiana/Vevay
    {  249, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  249, 8086,     171, 16, }, // America/Indiana/Winamac
    {  249, 2799,    3995,  7, }, // America/Jamaica
    {  249, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  249, 5932,     207, 22, }, // America/Lower_Princes
    {  249, 8220,    7126,  6, }, // America/Merida
    {  249, 1850,     235, 19, }, // America/Noronha
    {  249, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  249, 8329,     274, 20, }, // America/North_Dakota/Center
    {  249, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  249,  393,     317,  4, }, // America/Nuuk
    {  249, 5843,   22058, 11, }, // America/Puerto_Rico
    {  249, 6899,     321, 16, }, // America/Scoresbysund
    {  249, 8508,     337, 14, }, // America/St_Barthelemy
    {  249, 2061,     351, 10, }, // America/St_Johns
    {  249, 5863,     361,  9, }, // America/St_Kitts
    {  249, 5880,     370,  9, }, // America/St_Lucia
    {  249,  855,     379, 10, }, // America/St_Thomas
    {  249, 5913,     389, 11, }, // America/St_Vincent
    {  249, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  249, 5534,   63955,  6, }, // Asia/Bahrain
    {  249, 8651,   63961,  4, }, // Asia/Gaza
    {  249, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  249, 1185,     448,  9, }, // Asia/Kathmandu
    {  249,  992,     457,  7, }, // Asia/Kolkata
    {  249, 5547,   63965,  6, }, // Asia/Kuwait
    {  249, 1211,    7731,  5, }, // Asia/Macau
    {  249, 8708,     469,  8, }, // Asia/Qostanay
    {  249, 3300,    7809,  8, }, // Asia/Singapore
    {  249, 2772,    7842,  7, }, // Asia/Tehran
    {  249, 1235,   58618,  7, }, // Asia/Yangon
    {  249, 3663,   63971,  9, }, // Atlantic/Azores
    {  249, 3727,   63980, 16, }, // Atlantic/Cape_Verde
    {  249, 1395,   63996,  7, }, // Atlantic/Faroe
    {  249, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  249, 7272,   64003, 19, }, // Atlantic/South_Georgia
    {  249, 6821,     488, 10, }, // Atlantic/St_Helena
    {  249, 2300,    5911,  4, }, // Europe/Athens
    {  249, 6336,    8060,  7, }, // Europe/Belgrade
    {  249, 2167,   57661,  9, }, // Europe/Brussels
    {  249, 3928,   27029,  8, }, // Europe/Bucharest
    {  249, 6289,   64022, 13, }, // Europe/Copenhagen
    {  249, 2527,    8148,  4, }, // Europe/Kyiv
    {  249, 3213,    4499,  8, }, // Europe/Lisbon
    {  249, 6365,   64035, 10, }, // Europe/Luxembourg
    {  249, 6410,    6044,  6, }, // Europe/Monaco
    {  249, 3537,   22880,  6, }, // Europe/Moscow
    {  249, 6275,    8201,  4, }, // Europe/Prague
    {  249, 6324,    6064,  3, }, // Europe/Rome
    {  249, 6523,   64045,  9, }, // Europe/Stockholm
    {  249, 6567,   64054,  9, }, // Europe/Vatican
    {  249, 6231,   57515,  4, }, // Europe/Vienna
    {  249, 3190,   64063,  8, }, // Europe/Warsaw
    {  249, 6540,    4577,  6, }, // Europe/Zurich
    {  249, 7050,   64071, 13, }, // Indian/Maldives
    {  249, 4069,   64084,  8, }, // Indian/Mauritius
    {  249, 7211,     547,  7, }, // Indian/Reunion
    {  249, 3157,     554,  5, }, // Pacific/Chuuk
    {  249, 2723,    4611,  8, }, // Pacific/Honolulu
    {  249, 3049,    4619,  9, }, // Pacific/Kanton
    {  249, 3096,     586,  7, }, // Pacific/Pohnpei
    {  251,   14,       0,  6, }, // Africa/Asmara Filipino/Latin/Philippines
    {  251, 4435,       6,  8, }, // Africa/Sao_Tome
    {  251, 4252,      14,  8, }, // America/Asuncion
    {  251,  237,      22,  8, }, // America/Atikokan
    {  251, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  251, 3868,   33314,  6, }, // America/Cancun
    {  251, 7774,   64092, 17, }, // America/Ciudad_Juarez
    {  251, 5723,      66,  7, }, // America/Curacao
    {  251,  481,      73, 13, }, // America/Indiana/Knox
    {  251, 7961,      86, 16, }, // America/Indiana/Marengo
    {  251, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  251, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  251, 8038,     139, 14, }, // America/Indiana/Vevay
    {  251, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  251, 8086,     171, 16, }, // America/Indiana/Winamac
    {  251, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  251, 5932,     207, 22, }, // America/Lower_Princes
    {  251, 8220,    7126,  6, }, // America/Merida
    {  251, 2949,   64109, 17, }, // America/Mexico_City
    {  251, 1850,     235, 19, }, // America/Noronha
    {  251, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  251, 8329,     274, 20, }, // America/North_Dakota/Center
    {  251, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  251,  393,     317,  4, }, // America/Nuuk
    {  251, 5954,   64126, 18, }, // America/Port_of_Spain
    {  251, 8424,   64144, 25, }, // America/Rankin_Inlet
    {  251, 6899,     321, 16, }, // America/Scoresbysund
    {  251, 8508,     337, 14, }, // America/St_Barthelemy
    {  251, 2061,     351, 10, }, // America/St_Johns
    {  251, 5863,     361,  9, }, // America/St_Kitts
    {  251, 5880,     370,  9, }, // America/St_Lucia
    {  251,  855,     379, 10, }, // America/St_Thomas
    {  251, 5913,     389, 11, }, // America/St_Vincent
    {  251, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  251, 1259,   64169, 22, }, // Asia/Ho_Chi_Minh
    {  251, 1185,     448,  9, }, // Asia/Kathmandu
    {  251,  992,     457,  7, }, // Asia/Kolkata
    {  251, 1211,    4321,  5, }, // Asia/Macau
    {  251, 8708,     469,  8, }, // Asia/Qostanay
    {  251, 1235,     477,  6, }, // Asia/Yangon
    {  251, 1395,     483,  5, }, // Atlantic/Faroe
    {  251, 6821,     488, 10, }, // Atlantic/St_Helena
    {  251, 2527,    8148,  4, }, // Europe/Kyiv
    {  251, 7211,     547,  7, }, // Indian/Reunion
    {  251, 3157,     554,  5, }, // Pacific/Chuuk
    {  251, 2723,    4611,  8, }, // Pacific/Honolulu
    {  251, 3049,    4619,  9, }, // Pacific/Kanton
    {  251, 3096,     586,  7, }, // Pacific/Pohnpei
    {  252, 5059,    3902, 11, }, // Africa/Addis_Ababa Finnish/Latin/Finland
    {  252, 7420,   44088,  5, }, // Africa/Algiers
    {  252,   14,       0,  6, }, // Africa/Asmara
    {  252, 2320,    4690,  5, }, // Africa/Cairo
    {  252, 5166,   63491,  8, }, // Africa/El_Aaiun
    {  252, 4524,   26504,  7, }, // Africa/Khartoum
    {  252, 6869,   20418,  4, }, // Africa/Lome
    {  252, 5271,   44128,  9, }, // Africa/Ndjamena
    {  252, 4435,       6,  8, }, // Africa/Sao_Tome
    {  252, 4554,   26559,  9, }, // America/Araguaina
    {  252,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  252, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  252, 4252,      14,  8, }, // America/Asuncion
    {  252,  237,      22,  8, }, // America/Atikokan
    {  252, 7623,      30, 17, }, // America/Bahia_Banderas
    {  252, 4361,   20507,  6, }, // America/Bogota
    {  252, 3868,      47,  6, }, // America/Cancun
    {  252, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  252, 3791,   26574,  6, }, // America/Cuiaba
    {  252, 5723,      66,  7, }, // America/Curacao
    {  252, 7869,   26580,  8, }, // America/Eirunepe
    {  252, 2281,   63505,  7, }, // America/Havana
    {  252,  481,      73, 13, }, // America/Indiana/Knox
    {  252, 7961,      86, 16, }, // America/Indiana/Marengo
    {  252, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  252, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  252, 8038,     139, 14, }, // America/Indiana/Vevay
    {  252, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  252, 8086,     171, 16, }, // America/Indiana/Winamac
    {  252, 2799,    3995,  7, }, // America/Jamaica
    {  252, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  252, 5932,     207, 22, }, // America/Lower_Princes
    {  252, 8153,   26588,  6, }, // America/Maceio
    {  252, 2917,   26603,  8, }, // America/Mazatlan
    {  252, 8220,     229,  6, }, // America/Merida
    {  252, 2949,   57591, 16, }, // America/Mexico_City
    {  252, 1850,     235, 19, }, // America/Noronha
    {  252, 8301,   64191, 22, }, // America/North_Dakota/Beulah
    {  252, 8329,   64213, 22, }, // America/North_Dakota/Center
    {  252, 8357,   64235, 25, }, // America/North_Dakota/New_Salem
    {  252,  393,   35928,  7, }, // America/Nuuk
    {  252, 8477,   26704,  8, }, // America/Santarem
    {  252, 2201,   64260, 17, }, // America/Santiago
    {  252, 1878,   26712,  9, }, // America/Sao_Paulo
    {  252, 6899,   44281, 12, }, // America/Scoresbysund
    {  252, 8508,   26721, 16, }, // America/St_Barthelemy
    {  252, 2061,     351, 10, }, // America/St_Johns
    {  252, 5863,   26749, 11, }, // America/St_Kitts
    {  252, 5880,   35964, 11, }, // America/St_Lucia
    {  252,  855,   44293, 12, }, // America/St_Thomas
    {  252, 5913,   26783, 13, }, // America/St_Vincent
    {  252, 5756,   26796,  7, }, // America/Thule
    {  252, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  252, 8568,   64277, 15, }, // Antarctica/Macquarie
    {  252, 5523,   64292,  5, }, // Asia/Aqtau
    {  252, 5368,   57205,  6, }, // Asia/Aqtobe
    {  252,  964,   57615,  7, }, // Asia/Ashgabat
    {  252, 8624,   58781,  6, }, // Asia/Atyrau
    {  252, 3607,    4162,  6, }, // Asia/Baghdad
    {  252, 3778,   33455,  6, }, // Asia/Bishkek
    {  252, 4601,   63604,  5, }, // Asia/Chita
    {  252, 4540,   64297,  8, }, // Asia/Damascus
    {  252, 6159,   33468,  7, }, // Asia/Dushanbe
    {  252, 1259,   64305, 22, }, // Asia/Ho_Chi_Minh
    {  252, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  252, 4316,   63631,  9, }, // Asia/Kamchatka
    {  252, 1185,     448,  9, }, // Asia/Kathmandu
    {  252, 8661,   64327,  7, }, // Asia/Khandyga
    {  252,  992,   64334,  8, }, // Asia/Kolkata
    {  252, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  252, 1211,     464,  5, }, // Asia/Macau
    {  252, 6920,   36067,  6, }, // Asia/Muscat
    {  252, 2554,    5738,  7, }, // Asia/Nicosia
    {  252, 7145,   58053,  6, }, // Asia/Oral
    {  252, 4214,   33562,  9, }, // Asia/Pyongyang
    {  252, 8708,   64342,  8, }, // Asia/Qostanay
    {  252, 4269,   22533,  9, }, // Asia/Qyzylorda
    {  252, 3584,    7787,  4, }, // Asia/Riyadh
    {  252, 4408,   33576,  7, }, // Asia/Sakhalin
    {  252, 3279,   58092,  4, }, // Asia/Seoul
    {  252, 4781,   33589,  7, }, // Asia/Tashkent
    {  252, 2772,    7842,  7, }, // Asia/Tehran
    {  252, 2821,    4356,  5, }, // Asia/Tokyo
    {  252, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {  252, 1159,   26933,  6, }, // Asia/Urumqi
    {  252, 4828,    7873,  7, }, // Asia/Yakutsk
    {  252, 1235,     477,  6, }, // Asia/Yangon
    {  252, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  252, 3747,    7898,  7, }, // Asia/Yerevan
    {  252, 3663,   64350,  6, }, // Atlantic/Azores
    {  252, 6628,   64356, 14, }, // Atlantic/Canary
    {  252, 3727,   57380,  9, }, // Atlantic/Cape_Verde
    {  252, 1395,   64370,  9, }, // Atlantic/Faroe
    {  252, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  252, 7272,   64379, 13, }, // Atlantic/South_Georgia
    {  252, 6821,   36198, 12, }, // Atlantic/St_Helena
    {  252, 3620,   33644,  8, }, // Europe/Astrakhan
    {  252, 2300,   63772,  6, }, // Europe/Athens
    {  252, 6336,   27015,  7, }, // Europe/Belgrade
    {  252, 4757,   64392,  8, }, // Europe/Berlin
    {  252, 2167,   64400,  7, }, // Europe/Brussels
    {  252, 3928,   27029,  8, }, // Europe/Bucharest
    {  252, 8772,   27037,  8, }, // Europe/Busingen
    {  252, 2583,   64407,  8, }, // Europe/Chisinau
    {  252, 6289,   64415, 12, }, // Europe/Copenhagen
    {  252, 8804,   64427,  8, }, // Europe/Isle_of_Man
    {  252, 2527,   64435,  5, }, // Europe/Kyiv
    {  252, 3213,    4499,  8, }, // Europe/Lisbon
    {  252, 2501,   64440,  6, }, // Europe/London
    {  252, 6365,    4513,  9, }, // Europe/Luxembourg
    {  252, 6582,   63826, 13, }, // Europe/Mariehamn
    {  252, 3537,   64446,  7, }, // Europe/Moscow
    {  252, 4284,   64453,  7, }, // Europe/Paris
    {  252, 6275,   36285,  5, }, // Europe/Prague
    {  252, 8837,   64460,  5, }, // Europe/Riga
    {  252, 6324,   63849,  5, }, // Europe/Rome
    {  252, 6523,   64465,  8, }, // Europe/Stockholm
    {  252, 8867,   64473,  8, }, // Europe/Tallinn
    {  252, 6202,   21213,  6, }, // Europe/Tirane
    {  252, 8882,    8261,  9, }, // Europe/Ulyanovsk
    {  252, 6567,   64481,  9, }, // Europe/Vatican
    {  252, 6231,   57515,  4, }, // Europe/Vienna
    {  252, 8899,   64490,  5, }, // Europe/Vilnius
    {  252, 3190,   64495,  7, }, // Europe/Warsaw
    {  252, 6540,    4577,  6, }, // Europe/Zurich
    {  252, 6046,   64502, 10, }, // Indian/Christmas
    {  252, 6063,   64512, 12, }, // Indian/Cocos
    {  252, 5029,   64524,  7, }, // Indian/Comoro
    {  252, 6661,   64531, 15, }, // Indian/Kerguelen
    {  252, 7260,   27115,  4, }, // Indian/Mahe
    {  252, 7050,   64546, 10, }, // Indian/Maldives
    {  252, 7211,     547,  7, }, // Indian/Reunion
    {  252, 3015,   64556, 13, }, // Pacific/Chatham
    {  252, 3157,     554,  5, }, // Pacific/Chuuk
    {  252, 2237,   64569, 13, }, // Pacific/Easter
    {  252, 3902,   33836,  5, }, // Pacific/Fiji
    {  252, 6696,   64582, 13, }, // Pacific/Gambier
    {  252, 2723,    4611,  8, }, // Pacific/Honolulu
    {  252, 3049,    4619,  9, }, // Pacific/Kanton
    {  252, 4051,   64595, 15, }, // Pacific/Marquesas
    {  252, 8914,   64610, 12, }, // Pacific/Midway
    {  252, 7098,    4628,  6, }, // Pacific/Noumea
    {  252, 3096,     586,  7, }, // Pacific/Pohnpei
    {  253, 5059,   64622, 11, }, // Africa/Addis_Ababa French/Latin/France
    {  253, 7420,   44088,  5, }, // Africa/Algiers
    {  253,   14,       0,  6, }, // Africa/Asmara
    {  253, 2320,   64633,  8, }, // Africa/Cairo
    {  253, 5166,   64641,  8, }, // Africa/El_Aaiun
    {  253, 6869,   20418,  4, }, // Africa/Lome
    {  253, 5113,   44110, 10, }, // Africa/Mogadishu
    {  253, 5271,   44128,  9, }, // Africa/Ndjamena
    {  253, 4435,       6,  8, }, // Africa/Sao_Tome
    {  253, 2866,   64649, 15, }, // Africa/Tripoli
    {  253, 4554,   26559,  9, }, // America/Araguaina
    {  253,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  253, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  253, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  253, 7597,   64664,  7, }, // America/Argentina/Ushuaia
    {  253, 4252,      14,  8, }, // America/Asuncion
    {  253,  237,      22,  8, }, // America/Atikokan
    {  253, 7623,   64671, 17, }, // America/Bahia_Banderas
    {  253, 5654,   64688, 10, }, // America/Barbados
    {  253, 7646,   35896,  5, }, // America/Belem
    {  253, 3868,      47,  6, }, // America/Cancun
    {  253, 5496,   64698,  7, }, // America/Cayman
    {  253, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  253, 3791,   26574,  6, }, // America/Cuiaba
    {  253, 5723,      66,  7, }, // America/Curacao
    {  253, 3465,   64705,  7, }, // America/Detroit
    {  253, 5739,   64712,  9, }, // America/Dominica
    {  253, 7869,   26580,  8, }, // America/Eirunepe
    {  253, 5770,   64721,  7, }, // America/Grenada
    {  253, 2281,   64728,  9, }, // America/Havana
    {  253,  481,   64737, 14, }, // America/Indiana/Knox
    {  253, 7961,   64751, 17, }, // America/Indiana/Marengo
    {  253, 7985,   64768, 20, }, // America/Indiana/Petersburg
    {  253, 8012,   64788, 19, }, // America/Indiana/Tell_City
    {  253, 8038,   64807, 15, }, // America/Indiana/Vevay
    {  253, 8060,   64822, 19, }, // America/Indiana/Vincennes
    {  253, 8086,   64841, 17, }, // America/Indiana/Winamac
    {  253, 2799,   64858,  8, }, // America/Jamaica
    {  253, 8125,   64866, 21, }, // America/Kentucky/Monticello
    {  253, 5932,     207, 22, }, // America/Lower_Princes
    {  253, 8153,   26588,  6, }, // America/Maceio
    {  253, 1908,   64887,  6, }, // America/Manaus
    {  253, 2917,   26603,  8, }, // America/Mazatlan
    {  253, 8220,     229,  6, }, // America/Merida
    {  253, 2949,   58762,  6, }, // America/Mexico_City
    {  253, 1850,     235, 19, }, // America/Noronha
    {  253, 8301,   64893, 23, }, // America/North_Dakota/Beulah
    {  253, 8329,   64916, 23, }, // America/North_Dakota/Center
    {  253, 8357,   64939, 26, }, // America/North_Dakota/New_Salem
    {  253,  393,     317,  4, }, // America/Nuuk
    {  253, 5954,   64965, 14, }, // America/Port_of_Spain
    {  253, 5843,   64979, 10, }, // America/Puerto_Rico
    {  253, 8477,   26704,  8, }, // America/Santarem
    {  253, 6111,   64989, 14, }, // America/Santo_Domingo
    {  253, 1878,   26712,  9, }, // America/Sao_Paulo
    {  253, 6899,     321, 16, }, // America/Scoresbysund
    {  253, 8508,   26721, 16, }, // America/St_Barthelemy
    {  253, 2061,   65003, 25, }, // America/St_Johns
    {  253, 5863,   65028, 16, }, // America/St_Kitts
    {  253, 5880,   65044, 12, }, // America/St_Lucia
    {  253,  855,   26771, 12, }, // America/St_Thomas
    {  253, 5913,   65056, 13, }, // America/St_Vincent
    {  253, 5756,   65069,  5, }, // America/Thule
    {  253, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  253, 7295,   62201,  5, }, // Antarctica/Syowa
    {  253, 5395,   57607,  8, }, // Asia/Almaty
    {  253, 5523,   65074,  6, }, // Asia/Aqtau
    {  253, 5368,   65080, 11, }, // Asia/Aqtobe
    {  253,  964,   65091,  8, }, // Asia/Ashgabat
    {  253, 8624,   65099,  7, }, // Asia/Atyrau
    {  253, 3607,    4162,  6, }, // Asia/Baghdad
    {  253, 5534,   65106,  7, }, // Asia/Bahrain
    {  253, 3653,   35998,  5, }, // Asia/Baku
    {  253, 4086,   65113,  8, }, // Asia/Beirut
    {  253, 3778,   65121,  7, }, // Asia/Bishkek
    {  253, 4601,   36009,  6, }, // Asia/Chita
    {  253, 4540,    4201,  5, }, // Asia/Damascus
    {  253, 3596,   65128,  5, }, // Asia/Dubai
    {  253, 6159,   65133,  9, }, // Asia/Dushanbe
    {  253, 8636,   65142, 10, }, // Asia/Famagusta
    {  253, 4795,   65152,  6, }, // Asia/Hebron
    {  253, 1259,   65158, 17, }, // Asia/Ho_Chi_Minh
    {  253, 4184,   65175,  8, }, // Asia/Irkutsk
    {  253, 1290,   65183,  9, }, // Asia/Jerusalem
    {  253, 3560,   36037,  6, }, // Asia/Kabul
    {  253, 4316,   36043, 10, }, // Asia/Kamchatka
    {  253, 1185,   65192,  9, }, // Asia/Kathmandu
    {  253,  992,   36053,  8, }, // Asia/Kolkata
    {  253, 4197,   65201, 11, }, // Asia/Krasnoyarsk
    {  253, 5547,   65212,  6, }, // Asia/Kuwait
    {  253, 1211,     464,  5, }, // Asia/Macau
    {  253, 1349,   65218,  8, }, // Asia/Makassar
    {  253, 7182,   65226,  7, }, // Asia/Manila
    {  253, 6920,   20857,  7, }, // Asia/Muscat
    {  253, 2554,   65233,  7, }, // Asia/Nicosia
    {  253, 4135,   44379, 12, }, // Asia/Novosibirsk
    {  253, 7145,   65240,  7, }, // Asia/Oral
    {  253, 8708,   65247,  8, }, // Asia/Qostanay
    {  253, 4269,   65255,  9, }, // Asia/Qyzylorda
    {  253, 3584,   20874,  5, }, // Asia/Riyadh
    {  253, 4408,   65264,  9, }, // Asia/Sakhalin
    {  253, 7245,   65273, 10, }, // Asia/Samarkand
    {  253, 3279,   65283,  5, }, // Asia/Seoul
    {  253, 3300,   36101,  9, }, // Asia/Singapore
    {  253, 4781,   65288,  8, }, // Asia/Tashkent
    {  253, 3915,   65296,  8, }, // Asia/Tbilisi
    {  253, 2772,   65304,  7, }, // Asia/Tehran
    {  253, 1021,   65311, 11, }, // Asia/Ulaanbaatar
    {  253, 1159,   26933,  6, }, // Asia/Urumqi
    {  253, 4828,   65322,  8, }, // Asia/Yakutsk
    {  253, 1235,   65330,  7, }, // Asia/Yangon
    {  253, 3883,   65337, 13, }, // Asia/Yekaterinburg
    {  253, 3747,   26947,  6, }, // Asia/Yerevan
    {  253, 3663,   44461,  6, }, // Atlantic/Azores
    {  253, 5671,   44467,  8, }, // Atlantic/Bermuda
    {  253, 6628,   65350, 13, }, // Atlantic/Canary
    {  253, 3727,   65363,  8, }, // Atlantic/Cape_Verde
    {  253, 1395,   65371, 10, }, // Atlantic/Faroe
    {  253, 8736,   65381,  6, }, // Atlantic/Madeira
    {  253, 7272,   65387, 14, }, // Atlantic/South_Georgia
    {  253, 6821,   65401, 13, }, // Atlantic/St_Helena
    {  253, 1670,   65414,  8, }, // Australia/Adelaide
    {  253, 6216,   65422,  7, }, // Europe/Andorra
    {  253, 2300,   65429,  7, }, // Europe/Athens
    {  253, 2167,   57661,  9, }, // Europe/Brussels
    {  253, 3928,   21073,  8, }, // Europe/Bucharest
    {  253, 8772,   27037,  8, }, // Europe/Busingen
    {  253, 6289,   21081, 10, }, // Europe/Copenhagen
    {  253, 8788,   27045,  9, }, // Europe/Guernsey
    {  253, 8804,   65436, 10, }, // Europe/Isle_of_Man
    {  253, 2527,    8148,  4, }, // Europe/Kyiv
    {  253, 3213,   65446,  8, }, // Europe/Lisbon
    {  253, 2501,   21152,  7, }, // Europe/London
    {  253, 6397,   65454,  5, }, // Europe/Malta
    {  253, 3537,   44576,  6, }, // Europe/Moscow
    {  253, 6470,   65459, 11, }, // Europe/San_Marino
    {  253, 6202,   21213,  6, }, // Europe/Tirane
    {  253, 8882,   65470, 10, }, // Europe/Ulyanovsk
    {  253, 6567,   65480, 10, }, // Europe/Vatican
    {  253, 6231,   65490,  6, }, // Europe/Vienna
    {  253, 3190,   65496,  8, }, // Europe/Warsaw
    {  253, 5029,   65504,  7, }, // Indian/Comoro
    {  253, 7260,   27115,  4, }, // Indian/Mahe
    {  253, 4069,   65511,  7, }, // Indian/Mauritius
    {  253, 7211,   65518, 10, }, // Indian/Reunion
    {  253, 3157,     554,  5, }, // Pacific/Chuuk
    {  253, 2237,   65528, 13, }, // Pacific/Easter
    {  253, 7360,   27148,  5, }, // Pacific/Efate
    {  253, 3902,    4606,  5, }, // Pacific/Fiji
    {  253, 6678,   21277,  9, }, // Pacific/Galapagos
    {  253, 2723,    4611,  8, }, // Pacific/Honolulu
    {  253, 3049,    4619,  9, }, // Pacific/Kanton
    {  253, 4051,   65541,  9, }, // Pacific/Marquesas
    {  253, 7098,    4628,  6, }, // Pacific/Noumea
    {  253, 7155,   65550,  6, }, // Pacific/Palau
    {  253, 3096,     586,  7, }, // Pacific/Pohnpei
    {  260, 5271,   65556,  8, }, // Africa/Ndjamena French/Latin/Canada
    {  260, 2866,   65564, 15, }, // Africa/Tripoli
    {  260, 5654,   65579, 12, }, // America/Barbados
    {  260, 5496,   65591, 12, }, // America/Cayman
    {  260, 8301,   65603, 23, }, // America/North_Dakota/Beulah
    {  260, 8329,   65626, 23, }, // America/North_Dakota/Center
    {  260, 8357,   65649, 26, }, // America/North_Dakota/New_Salem
    {  260, 2061,     351, 10, }, // America/St_Johns
    {  260, 5863,   65675, 26, }, // America/St_Kitts
    {  260,  855,   44293, 12, }, // America/St_Thomas
    {  260, 6133,   65701, 16, }, // Antarctica/DumontDUrville
    {  260, 1093,   65717,  5, }, // Asia/Dhaka
    {  260, 1317,   65722,  8, }, // Asia/Thimphu
    {  260, 6628,   65730, 13, }, // Atlantic/Canary
    {  260, 1395,   65743, 10, }, // Atlantic/Faroe
    {  260, 8804,   65753, 10, }, // Europe/Isle_of_Man
    {  260, 2501,   21152,  7, }, // Europe/London
    {  260, 6567,   21222,  7, }, // Europe/Vatican
    {  260, 2237,   65763, 13, }, // Pacific/Easter
    {  260, 7155,   65776,  5, }, // Pacific/Palau
    {  299,   14,       0,  6, }, // Africa/Asmara Friulian/Latin/Italy
    {  299, 4435,       6,  8, }, // Africa/Sao_Tome
    {  299, 4252,      14,  8, }, // America/Asuncion
    {  299,  237,      22,  8, }, // America/Atikokan
    {  299, 7623,      30, 17, }, // America/Bahia_Banderas
    {  299, 3868,      47,  6, }, // America/Cancun
    {  299, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  299, 5723,      66,  7, }, // America/Curacao
    {  299,  481,      73, 13, }, // America/Indiana/Knox
    {  299, 7961,      86, 16, }, // America/Indiana/Marengo
    {  299, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  299, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  299, 8038,     139, 14, }, // America/Indiana/Vevay
    {  299, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  299, 8086,     171, 16, }, // America/Indiana/Winamac
    {  299, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  299, 5932,     207, 22, }, // America/Lower_Princes
    {  299, 8220,     229,  6, }, // America/Merida
    {  299, 2379,   65781, 10, }, // America/New_York
    {  299, 1850,     235, 19, }, // America/Noronha
    {  299, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  299, 8329,     274, 20, }, // America/North_Dakota/Center
    {  299, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  299,  393,     317,  4, }, // America/Nuuk
    {  299, 1878,   65791, 20, }, // America/Sao_Paulo
    {  299, 6899,     321, 16, }, // America/Scoresbysund
    {  299, 8508,     337, 14, }, // America/St_Barthelemy
    {  299, 2061,     351, 10, }, // America/St_Johns
    {  299, 5863,     361,  9, }, // America/St_Kitts
    {  299, 5880,     370,  9, }, // America/St_Lucia
    {  299,  855,     379, 10, }, // America/St_Thomas
    {  299, 5913,     389, 11, }, // America/St_Vincent
    {  299, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  299, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  299, 1185,     448,  9, }, // Asia/Kathmandu
    {  299,  992,     457,  7, }, // Asia/Kolkata
    {  299, 1211,     464,  5, }, // Asia/Macau
    {  299, 1235,     477,  6, }, // Asia/Yangon
    {  299, 3663,   65811,  6, }, // Atlantic/Azores
    {  299, 6628,   65817,  8, }, // Atlantic/Canary
    {  299, 1395,     483,  5, }, // Atlantic/Faroe
    {  299, 6821,     488, 10, }, // Atlantic/St_Helena
    {  299, 6336,   65825,  7, }, // Europe/Belgrade
    {  299, 2527,     514,  4, }, // Europe/Kyiv
    {  299, 3213,   65832,  7, }, // Europe/Lisbon
    {  299, 6506,   65839,  7, }, // Europe/Ljubljana
    {  299, 6365,   65846, 10, }, // Europe/Luxembourg
    {  299, 6397,   65454,  5, }, // Europe/Malta
    {  299, 3537,   65856,  6, }, // Europe/Moscow
    {  299, 6275,   65862,  6, }, // Europe/Prague
    {  299, 6470,   65868,  9, }, // Europe/San_Marino
    {  299, 6231,   65877,  5, }, // Europe/Vienna
    {  299, 7211,     547,  7, }, // Indian/Reunion
    {  299, 3157,     554,  5, }, // Pacific/Chuuk
    {  299, 3096,     586,  7, }, // Pacific/Pohnpei
    {  300,   14,       0,  6, }, // Africa/Asmara Fulah/Latin/Senegal
    {  300, 4435,       6,  8, }, // Africa/Sao_Tome
    {  300, 4252,      14,  8, }, // America/Asuncion
    {  300,  237,      22,  8, }, // America/Atikokan
    {  300, 7623,      30, 17, }, // America/Bahia_Banderas
    {  300, 3868,      47,  6, }, // America/Cancun
    {  300, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  300, 5723,      66,  7, }, // America/Curacao
    {  300,  481,      73, 13, }, // America/Indiana/Knox
    {  300, 7961,      86, 16, }, // America/Indiana/Marengo
    {  300, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  300, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  300, 8038,     139, 14, }, // America/Indiana/Vevay
    {  300, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  300, 8086,     171, 16, }, // America/Indiana/Winamac
    {  300, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  300, 5932,     207, 22, }, // America/Lower_Princes
    {  300, 8220,     229,  6, }, // America/Merida
    {  300, 1850,     235, 19, }, // America/Noronha
    {  300, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  300, 8329,     274, 20, }, // America/North_Dakota/Center
    {  300, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  300,  393,     317,  4, }, // America/Nuuk
    {  300, 6899,     321, 16, }, // America/Scoresbysund
    {  300, 8508,     337, 14, }, // America/St_Barthelemy
    {  300, 2061,     351, 10, }, // America/St_Johns
    {  300, 5863,     361,  9, }, // America/St_Kitts
    {  300, 5880,     370,  9, }, // America/St_Lucia
    {  300,  855,     379, 10, }, // America/St_Thomas
    {  300, 5913,     389, 11, }, // America/St_Vincent
    {  300, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  300, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  300, 1185,     448,  9, }, // Asia/Kathmandu
    {  300,  992,     457,  7, }, // Asia/Kolkata
    {  300, 1211,     464,  5, }, // Asia/Macau
    {  300, 1235,     477,  6, }, // Asia/Yangon
    {  300, 1395,     483,  5, }, // Atlantic/Faroe
    {  300, 6821,     488, 10, }, // Atlantic/St_Helena
    {  300, 2527,     514,  4, }, // Europe/Kyiv
    {  300, 7211,     547,  7, }, // Indian/Reunion
    {  300, 3157,     554,  5, }, // Pacific/Chuuk
    {  300, 3096,     586,  7, }, // Pacific/Pohnpei
    {  306, 6788,   65882, 12, }, // Africa/Abidjan Fulah/Adlam/Guinea
    {  306, 6760,   65894, 10, }, // Africa/Accra
    {  306, 5059,   65904, 18, }, // Africa/Addis_Ababa
    {  306, 7420,   65922, 14, }, // Africa/Algiers
    {  306,   14,   65936, 12, }, // Africa/Asmara
    {  306,   44,   65948, 14, }, // Africa/Bamako
    {  306, 5257,   65962, 10, }, // Africa/Bangui
    {  306, 6746,   65972, 12, }, // Africa/Banjul
    {  306, 7435,   65984, 12, }, // Africa/Bissau
    {  306, 4957,   65996, 18, }, // Africa/Blantyre
    {  306, 5287,   66014, 16, }, // Africa/Brazzaville
    {  306, 4922,   66030, 18, }, // Africa/Bujumbura
    {  306, 2320,   66048, 10, }, // Africa/Cairo
    {  306, 4117,   66058, 26, }, // Africa/Casablanca
    {  306, 7449,   66084, 10, }, // Africa/Ceuta
    {  306, 6773,   66094, 18, }, // Africa/Conakry
    {  306, 6840,   66112, 12, }, // Africa/Dakar
    {  306, 5130,   66124, 25, }, // Africa/Dar_es_Salaam
    {  306, 5043,   66149, 14, }, // Africa/Djibouti
    {  306, 5243,   66163, 12, }, // Africa/Douala
    {  306, 5166,   66175, 14, }, // Africa/El_Aaiun
    {  306, 6853,   66189, 12, }, // Africa/Freetown
    {  306, 4906,   66201, 16, }, // Africa/Gaborone
    {  306, 5015,   66217, 12, }, // Africa/Harare
    {  306, 4479,   66229, 22, }, // Africa/Johannesburg
    {  306, 4499,   66251,  8, }, // Africa/Juba
    {  306, 5151,   66259, 14, }, // Africa/Kampala
    {  306, 4524,   66273, 14, }, // Africa/Khartoum
    {  306, 4973,   66287, 12, }, // Africa/Kigali
    {  306, 5306,   66299, 14, }, // Africa/Kinshasa
    {  306, 4744,   66313, 12, }, // Africa/Lagos
    {  306, 5336,   66325, 20, }, // Africa/Libreville
    {  306, 6869,   66345,  8, }, // Africa/Lome
    {  306, 5211,   66353, 16, }, // Africa/Luanda
    {  306, 4939,   66369, 18, }, // Africa/Lubumbashi
    {  306, 5001,   66387, 12, }, // Africa/Lusaka
    {  306, 5322,   66399, 14, }, // Africa/Malabo
    {  306, 4987,   66413, 12, }, // Africa/Maputo
    {  306, 5197,   66425, 12, }, // Africa/Maseru
    {  306, 5182,   66437, 18, }, // Africa/Mbabane
    {  306, 5113,   66455, 16, }, // Africa/Mogadishu
    {  306, 7034,   66471, 16, }, // Africa/Monrovia
    {  306, 3853,   66487, 14, }, // Africa/Nairobi
    {  306, 5271,   66501, 16, }, // Africa/Ndjamena
    {  306, 5354,   66517, 12, }, // Africa/Niamey
    {  306, 6803,   66529, 20, }, // Africa/Nouakchott
    {  306, 6727,   66549, 16, }, // Africa/Ouagadougou
    {  306, 5225,   66565, 21, }, // Africa/Porto-Novo
    {  306, 4435,   66586, 19, }, // Africa/Sao_Tome
    {  306, 2866,   66605, 14, }, // Africa/Tripoli
    {  306, 6554,   66619, 12, }, // Africa/Tunis
    {  306, 4152,   66631, 14, }, // Africa/Windhoek
    {  306,  132,   66645,  8, }, // America/Adak
    {  306, 3346,   66653, 18, }, // America/Anchorage
    {  306, 5607,   66671, 14, }, // America/Anguilla
    {  306, 5624,   66685, 12, }, // America/Antigua
    {  306, 4554,   66697, 18, }, // America/Araguaina
    {  306,  166,   66715, 29, }, // America/Argentina/Buenos_Aires
    {  306,   91,   66744, 20, }, // America/Argentina/Catamarca
    {  306,  270,   66764, 16, }, // America/Argentina/Cordoba
    {  306,  441,   66780, 10, }, // America/Argentina/Jujuy
    {  306, 7462,   66790, 17, }, // America/Argentina/La_Rioja
    {  306,  565,   66807, 16, }, // America/Argentina/Mendoza
    {  306, 7489,   66823, 21, }, // America/Argentina/Rio_Gallegos
    {  306, 7520,   66844, 10, }, // America/Argentina/Salta
    {  306, 7544,   66854, 19, }, // America/Argentina/San_Juan
    {  306, 5580,   66873, 19, }, // America/Argentina/San_Luis
    {  306, 7571,   66892, 16, }, // America/Argentina/Tucuman
    {  306, 7597,   66908, 14, }, // America/Argentina/Ushuaia
    {  306, 5640,   66922, 12, }, // America/Aruba
    {  306, 4252,   66934, 18, }, // America/Asuncion
    {  306,  237,   66952, 18, }, // America/Atikokan
    {  306, 3679,   66970, 12, }, // America/Bahia
    {  306, 7623,   66982, 33, }, // America/Bahia_Banderas
    {  306, 5654,   67015, 18, }, // America/Barbados
    {  306, 7646,   67033, 10, }, // America/Belem
    {  306, 5407,   67043, 12, }, // America/Belize
    {  306, 7660,   67055, 25, }, // America/Blanc-Sablon
    {  306, 7681,   67080, 19, }, // America/Boa_Vista
    {  306, 4361,   67099, 12, }, // America/Bogota
    {  306, 7699,   67111, 12, }, // America/Boise
    {  306, 7713,   67123, 25, }, // America/Cambridge_Bay
    {  306, 7735,   67148, 23, }, // America/Campo_Grande
    {  306, 3868,   67171, 14, }, // America/Cancun
    {  306, 4694,   67185, 14, }, // America/Caracas
    {  306, 4345,   67199, 12, }, // America/Cayenne
    {  306, 5496,   67211, 14, }, // America/Cayman
    {  306, 2260,   67225, 16, }, // America/Chicago
    {  306, 7756,   67241, 16, }, // America/Chihuahua
    {  306, 5422,   67257, 21, }, // America/Costa_Rica
    {  306, 7796,   67278, 14, }, // America/Creston
    {  306, 3791,   67292, 14, }, // America/Cuiaba
    {  306, 5723,   67306, 18, }, // America/Curacao
    {  306, 7812,   67324, 26, }, // America/Danmarkshavn
    {  306, 7833,   67350, 12, }, // America/Dawson
    {  306, 7848,   67362, 21, }, // America/Dawson_Creek
    {  306,  805,   67383, 12, }, // America/Denver
    {  306, 3465,   67395, 14, }, // America/Detroit
    {  306, 5739,   67409, 18, }, // America/Dominica
    {  306,  893,   67427, 16, }, // America/Edmonton
    {  306, 7869,   67443, 14, }, // America/Eirunepe
    {  306, 5441,   67457, 23, }, // America/El_Salvador
    {  306, 7886,   67480, 22, }, // America/Fort_Nelson
    {  306, 7906,   67502, 20, }, // America/Fortaleza
    {  306, 7924,   67522, 15, }, // America/Glace_Bay
    {  306, 6881,   67537, 15, }, // America/Goose_Bay
    {  306, 4612,   67552, 19, }, // America/Grand_Turk
    {  306, 5770,   67571, 16, }, // America/Grenada
    {  306, 5786,   67587, 24, }, // America/Guadeloupe
    {  306, 3760,   67611, 20, }, // America/Guatemala
    {  306, 4841,   67631, 14, }, // America/Guayaquil
    {  306, 6932,   67645, 14, }, // America/Guyana
    {  306, 1939,   67659, 18, }, // America/Halifax
    {  306, 2281,   67677, 14, }, // America/Havana
    {  306, 7942,   67691, 24, }, // America/Hermosillo
    {  306,  348,   67715, 28, }, // America/Indiana/Indianapolis
    {  306,  481,   67743, 28, }, // America/Indiana/Knox
    {  306, 7961,   67771, 34, }, // America/Indiana/Marengo
    {  306, 7985,   67805, 40, }, // America/Indiana/Petersburg
    {  306, 8012,   67845, 37, }, // America/Indiana/Tell_City
    {  306, 8038,   67882, 32, }, // America/Indiana/Vevay
    {  306, 8060,   67914, 34, }, // America/Indiana/Vincennes
    {  306, 8086,   67948, 34, }, // America/Indiana/Winamac
    {  306, 8110,   67982, 12, }, // America/Inuvik
    {  306,  660,   67994, 16, }, // America/Iqaluit
    {  306, 2799,   68010, 16, }, // America/Jamaica
    {  306, 5380,   68026, 12, }, // America/Juneau
    {  306,  521,   68038, 12, }, // America/Kentucky/Louisville
    {  306, 8125,   68050, 40, }, // America/Kentucky/Monticello
    {  306, 5704,   68090, 20, }, // America/Kralendijk
    {  306, 4376,   68110, 13, }, // America/La_Paz
    {  306, 7169,   68123, 10, }, // America/Lima
    {  306, 3239,   68133, 21, }, // America/Los_Angeles
    {  306, 5932,   68154, 36, }, // America/Lower_Princes
    {  306, 8153,   68190, 12, }, // America/Maceio
    {  306, 8168,   68202, 14, }, // America/Managua
    {  306, 1908,   68216, 12, }, // America/Manaus
    {  306, 5897,   68228, 14, }, // America/Marigot
    {  306, 5805,   68242, 16, }, // America/Martinique
    {  306, 8184,   68258, 20, }, // America/Matamoros
    {  306, 2917,   68278, 16, }, // America/Mazatlan
    {  306, 8202,   68294, 16, }, // America/Menominee
    {  306, 8220,   68310, 12, }, // America/Merida
    {  306, 8235,   68322, 20, }, // America/Metlakatla
    {  306, 2949,   68342, 27, }, // America/Mexico_City
    {  306, 4391,   68369, 14, }, // America/Miquelon
    {  306, 8254,   68383, 16, }, // America/Moncton
    {  306, 8270,   68399, 18, }, // America/Monterrey
    {  306, 4098,   68417, 24, }, // America/Montevideo
    {  306, 5824,   68441, 20, }, // America/Montserrat
    {  306, 5481,   68461, 10, }, // America/Nassau
    {  306, 2379,   68471, 15, }, // America/New_York
    {  306, 8288,   68486, 10, }, // America/Nome
    {  306, 1850,   68496, 14, }, // America/Noronha
    {  306, 8301,   68510, 33, }, // America/North_Dakota/Beulah
    {  306, 8329,   68543, 37, }, // America/North_Dakota/Center
    {  306, 8357,   68580, 42, }, // America/North_Dakota/New_Salem
    {  306,  393,   68622,  8, }, // America/Nuuk
    {  306, 8388,   68630, 14, }, // America/Ojinaga
    {  306, 2356,   68644, 16, }, // America/Panama
    {  306, 6173,   68660, 20, }, // America/Paramaribo
    {  306, 2973,   68680, 12, }, // America/Phoenix
    {  306, 3945,   68692, 22, }, // America/Port-au-Prince
    {  306, 5954,   68714, 26, }, // America/Port_of_Spain
    {  306, 8404,   68740, 23, }, // America/Porto_Velho
    {  306, 5843,   68763, 19, }, // America/Puerto_Rico
    {  306, 4030,   68782, 23, }, // America/Punta_Arenas
    {  306, 8424,   68805, 23, }, // America/Rankin_Inlet
    {  306, 8445,   68828, 12, }, // America/Recife
    {  306, 1995,   68840, 14, }, // America/Regina
    {  306, 8460,   68854, 16, }, // America/Resolute
    {  306,  695,   68870, 21, }, // America/Rio_Branco
    {  306, 8477,   68891, 18, }, // America/Santarem
    {  306, 2201,   68909, 20, }, // America/Santiago
    {  306, 6111,   68929, 27, }, // America/Santo_Domingo
    {  306, 1878,   68956, 19, }, // America/Sao_Paulo
    {  306, 6899,   68975, 30, }, // America/Scoresbysund
    {  306, 8494,   69005, 10, }, // America/Sitka
    {  306, 8508,   69015, 27, }, // America/St_Barthelemy
    {  306, 2061,   69042, 19, }, // America/St_Johns
    {  306, 5863,   69061, 21, }, // America/St_Kitts
    {  306, 5880,   69082, 19, }, // America/St_Lucia
    {  306,  855,   69101, 21, }, // America/St_Thomas
    {  306, 5913,   69122, 23, }, // America/St_Vincent
    {  306, 8530,   69145, 23, }, // America/Swift_Current
    {  306, 5461,   69168, 22, }, // America/Tegucigalpa
    {  306, 5756,   69190,  8, }, // America/Thule
    {  306,  313,   69198, 18, }, // America/Tijuana
    {  306,  608,   69216, 16, }, // America/Toronto
    {  306, 5688,   69232, 16, }, // America/Tortola
    {  306, 2093,   69248, 16, }, // America/Vancouver
    {  306, 2144,   69264, 18, }, // America/Whitehorse
    {  306,  734,   69282, 16, }, // America/Winnipeg
    {  306, 8552,   69298, 14, }, // America/Yakutat
    {  306, 6001,   69312, 10, }, // Antarctica/Casey
    {  306, 6094,   69322, 12, }, // Antarctica/Davis
    {  306, 6133,   69334, 27, }, // Antarctica/DumontDUrville
    {  306, 8568,   69361, 14, }, // Antarctica/Macquarie
    {  306, 7066,   69375, 12, }, // Antarctica/Mawson
    {  306, 7113,   69387, 18, }, // Antarctica/McMurdo
    {  306, 8589,   69405, 14, }, // Antarctica/Palmer
    {  306, 7226,   69419, 12, }, // Antarctica/Rothera
    {  306, 7295,   69431, 14, }, // Antarctica/Syowa
    {  306, 8607,   69445, 12, }, // Antarctica/Troll
    {  306, 7374,   69457, 12, }, // Antarctica/Vostok
    {  306, 1429,   69469, 24, }, // Arctic/Longyearbyen
    {  306, 5570,   69493,  8, }, // Asia/Aden
    {  306, 5395,   69501, 14, }, // Asia/Almaty
    {  306, 3968,   69515, 12, }, // Asia/Amman
    {  306, 5511,   69527, 14, }, // Asia/Anadyr
    {  306, 5523,   69541, 14, }, // Asia/Aqtau
    {  306, 5368,   69555, 14, }, // Asia/Aqtobe
    {  306,  964,   69569, 16, }, // Asia/Ashgabat
    {  306, 8624,   69585, 14, }, // Asia/Atyrau
    {  306, 3607,   69599, 16, }, // Asia/Baghdad
    {  306, 5534,   69615, 16, }, // Asia/Bahrain
    {  306, 3653,   69631, 10, }, // Asia/Baku
    {  306, 4466,   69641, 16, }, // Asia/Bangkok
    {  306, 3571,   69657, 16, }, // Asia/Barnaul
    {  306, 4086,   69673, 16, }, // Asia/Beirut
    {  306, 3778,   69689, 16, }, // Asia/Bishkek
    {  306, 5989,   69705, 12, }, // Asia/Brunei
    {  306, 4601,   69717, 10, }, // Asia/Chita
    {  306, 4511,   69727, 14, }, // Asia/Colombo
    {  306, 4540,   69741, 14, }, // Asia/Damascus
    {  306, 1093,   66112, 10, }, // Asia/Dhaka
    {  306, 6192,   69755, 10, }, // Asia/Dili
    {  306, 3596,   69765, 10, }, // Asia/Dubai
    {  306, 6159,   69775, 14, }, // Asia/Dushanbe
    {  306, 8636,   69789, 18, }, // Asia/Famagusta
    {  306, 8651,   69807, 10, }, // Asia/Gaza
    {  306, 4795,   69817, 14, }, // Asia/Hebron
    {  306, 1259,   69831, 31, }, // Asia/Ho_Chi_Minh
    {  306, 2704,   69862, 17, }, // Asia/Hong_Kong
    {  306, 4771,   69879, 10, }, // Asia/Hovd
    {  306, 4184,   69889, 18, }, // Asia/Irkutsk
    {  306, 7006,   69907, 16, }, // Asia/Jakarta
    {  306, 6992,   69923, 16, }, // Asia/Jayapura
    {  306, 1290,   69939, 12, }, // Asia/Jerusalem
    {  306, 3560,   69951, 10, }, // Asia/Kabul
    {  306, 4316,   69961, 18, }, // Asia/Kamchatka
    {  306, 4239,   69979, 14, }, // Asia/Karachi
    {  306, 1185,   69993, 18, }, // Asia/Kathmandu
    {  306, 8661,   70011, 14, }, // Asia/Khandyga
    {  306,  992,   70025, 14, }, // Asia/Kolkata
    {  306, 4197,   70039, 28, }, // Asia/Krasnoyarsk
    {  306, 4859,   70067, 27, }, // Asia/Kuala_Lumpur
    {  306, 5976,   70094, 10, }, // Asia/Kuching
    {  306, 5547,   70104, 14, }, // Asia/Kuwait
    {  306, 1211,   70118, 12, }, // Asia/Macau
    {  306, 4017,   70130, 14, }, // Asia/Magadan
    {  306, 1349,   70144, 16, }, // Asia/Makassar
    {  306, 7182,   70160, 12, }, // Asia/Manila
    {  306, 6920,   70172, 14, }, // Asia/Muscat
    {  306, 2554,   70186, 16, }, // Asia/Nicosia
    {  306, 8675,   70202, 28, }, // Asia/Novokuznetsk
    {  306, 4135,   70230, 24, }, // Asia/Novosibirsk
    {  306, 4229,   70254, 12, }, // Asia/Omsk
    {  306, 7145,   70266,  8, }, // Asia/Oral
    {  306, 6961,   70274, 17, }, // Asia/Phnom_Penh
    {  306, 8693,   70291, 20, }, // Asia/Pontianak
    {  306, 4214,   70311, 16, }, // Asia/Pyongyang
    {  306, 5559,   70327, 10, }, // Asia/Qatar
    {  306, 8708,   70337, 16, }, // Asia/Qostanay
    {  306, 4269,   70353, 18, }, // Asia/Qyzylorda
    {  306, 3584,   70371, 12, }, // Asia/Riyadh
    {  306, 4408,   70383, 16, }, // Asia/Sakhalin
    {  306, 7245,   70399, 20, }, // Asia/Samarkand
    {  306, 3279,   70419, 10, }, // Asia/Seoul
    {  306, 1053,   70429, 12, }, // Asia/Shanghai
    {  306, 3300,   70441, 18, }, // Asia/Singapore
    {  306, 4297,   70459, 24, }, // Asia/Srednekolymsk
    {  306, 3263,   70483, 12, }, // Asia/Taipei
    {  306, 4781,   70495, 16, }, // Asia/Tashkent
    {  306, 3915,   70511, 18, }, // Asia/Tbilisi
    {  306, 2772,   70529, 16, }, // Asia/Tehran
    {  306, 1317,   70545, 10, }, // Asia/Thimphu
    {  306, 2821,   70555, 12, }, // Asia/Tokyo
    {  306, 4572,   70567, 14, }, // Asia/Tomsk
    {  306, 1021,   70581, 18, }, // Asia/Ulaanbaatar
    {  306, 1159,   70599, 12, }, // Asia/Urumqi
    {  306, 8722,   70611, 17, }, // Asia/Ust-Nera
    {  306, 6977,   70628, 18, }, // Asia/Vientiane
    {  306, 4710,   70646, 28, }, // Asia/Vladivostok
    {  306, 4828,   70674, 18, }, // Asia/Yakutsk
    {  306, 1235,   70692, 14, }, // Asia/Yangon
    {  306, 3883,   70706, 28, }, // Asia/Yekaterinburg
    {  306, 3747,   70734, 16, }, // Asia/Yerevan
    {  306, 3663,   70750, 14, }, // Atlantic/Azores
    {  306, 5671,   70764, 16, }, // Atlantic/Bermuda
    {  306, 6628,   70780, 12, }, // Atlantic/Canary
    {  306, 3727,   70792, 21, }, // Atlantic/Cape_Verde
    {  306, 1395,   70813, 10, }, // Atlantic/Faroe
    {  306, 8736,   70823, 14, }, // Atlantic/Madeira
    {  306, 2748,   70837, 18, }, // Atlantic/Reykjavik
    {  306, 7272,   70855, 25, }, // Atlantic/South_Georgia
    {  306, 6821,   70880, 23, }, // Atlantic/St_Helena
    {  306, 6644,   70903, 16, }, // Atlantic/Stanley
    {  306, 1670,   70919, 16, }, // Australia/Adelaide
    {  306, 1635,   70935, 20, }, // Australia/Brisbane
    {  306, 1799,   70955, 21, }, // Australia/Broken_Hill
    {  306, 1583,   70976, 14, }, // Australia/Darwin
    {  306, 3637,   70990, 12, }, // Australia/Eucla
    {  306, 1516,   71002, 16, }, // Australia/Hobart
    {  306, 8753,   71018, 20, }, // Australia/Lindeman
    {  306, 1547,   71038, 19, }, // Australia/Lord_Howe
    {  306, 1727,   71057, 18, }, // Australia/Melbourne
    {  306, 1762,   71075, 10, }, // Australia/Perth
    {  306, 1463,   71085, 12, }, // Australia/Sydney
    {  306, 6441,   71097, 22, }, // Europe/Amsterdam
    {  306, 6216,   71119, 14, }, // Europe/Andorra
    {  306, 3620,   71133, 18, }, // Europe/Astrakhan
    {  306, 2300,   71151, 12, }, // Europe/Athens
    {  306, 6336,   71163, 18, }, // Europe/Belgrade
    {  306, 4757,   71181, 12, }, // Europe/Berlin
    {  306, 6488,   71193, 22, }, // Europe/Bratislava
    {  306, 2167,   71215, 16, }, // Europe/Brussels
    {  306, 3928,   71231, 18, }, // Europe/Bucharest
    {  306, 3806,   71249, 16, }, // Europe/Budapest
    {  306, 8772,   71265, 16, }, // Europe/Busingen
    {  306, 2583,   71281, 18, }, // Europe/Chisinau
    {  306, 6289,   71299, 18, }, // Europe/Copenhagen
    {  306, 2338,   71317, 14, }, // Europe/Dublin
    {  306, 6307,   71331, 20, }, // Europe/Gibraltar
    {  306, 8788,   71351, 16, }, // Europe/Guernsey
    {  306, 6612,   71367, 16, }, // Europe/Helsinki
    {  306, 8804,   71383, 23, }, // Europe/Isle_of_Man
    {  306, 1130,   71406, 16, }, // Europe/Istanbul
    {  306, 8823,   71422, 12, }, // Europe/Jersey
    {  306, 3979,   71434, 18, }, // Europe/Kaliningrad
    {  306, 8929,   71452, 14, }, // Europe/Kirov
    {  306, 2527,   71466, 12, }, // Europe/Kyiv
    {  306, 3213,   71478, 14, }, // Europe/Lisbon
    {  306, 6506,   71492, 20, }, // Europe/Ljubljana
    {  306, 2501,   71512, 12, }, // Europe/London
    {  306, 6365,   71524, 22, }, // Europe/Luxembourg
    {  306, 4892,   71546, 14, }, // Europe/Madrid
    {  306, 6397,   71560, 10, }, // Europe/Malta
    {  306, 6582,   71570, 26, }, // Europe/Mariehamn
    {  306, 3693,   71596, 14, }, // Europe/Minsk
    {  306, 6410,   71610, 14, }, // Europe/Monaco
    {  306, 3537,   71624, 10, }, // Europe/Moscow
    {  306, 6458,   71634, 10, }, // Europe/Oslo
    {  306, 4284,   71644,  8, }, // Europe/Paris
    {  306, 6424,   71652, 20, }, // Europe/Podgorica
    {  306, 6275,   71672, 14, }, // Europe/Prague
    {  306, 8837,   71686,  8, }, // Europe/Riga
    {  306, 6324,   71694, 10, }, // Europe/Rome
    {  306, 4331,   71704, 12, }, // Europe/Samara
    {  306, 6470,   71716, 19, }, // Europe/San_Marino
    {  306, 6245,   71735, 18, }, // Europe/Sarajevo
    {  306, 4451,   71753, 16, }, // Europe/Saratov
    {  306, 8849,   71769, 20, }, // Europe/Simferopol
    {  306, 6383,   71789, 18, }, // Europe/Skopje
    {  306, 6599,   71807, 12, }, // Europe/Sofia
    {  306, 6523,   71819, 18, }, // Europe/Stockholm
    {  306, 8867,   71837, 14, }, // Europe/Tallinn
    {  306, 6202,   71851, 12, }, // Europe/Tirane
    {  306, 8882,   71863, 22, }, // Europe/Ulyanovsk
    {  306, 6352,   71885, 14, }, // Europe/Vaduz
    {  306, 6567,   71899, 14, }, // Europe/Vatican
    {  306, 6231,   71913, 14, }, // Europe/Vienna
    {  306, 8899,   71927, 14, }, // Europe/Vilnius
    {  306, 4727,   71941, 20, }, // Europe/Volgograd
    {  306, 3190,   71961, 10, }, // Europe/Warsaw
    {  306, 6261,   71971, 14, }, // Europe/Zagreb
    {  306, 6540,   71985, 10, }, // Europe/Zurich
    {  306, 5078,   71995, 28, }, // Indian/Antananarivo
    {  306, 6947,   72023, 10, }, // Indian/Chagos
    {  306, 6046,   72033, 18, }, // Indian/Christmas
    {  306, 6063,   72051, 12, }, // Indian/Cocos
    {  306, 5029,   72063, 14, }, // Indian/Comoro
    {  306, 6661,   72077, 16, }, // Indian/Kerguelen
    {  306, 7260,   72093, 10, }, // Indian/Mahe
    {  306, 7050,   72103, 18, }, // Indian/Maldives
    {  306, 4069,   72121, 14, }, // Indian/Mauritius
    {  306, 5098,   72135, 14, }, // Indian/Mayotte
    {  306, 7211,   72149, 16, }, // Indian/Reunion
    {  306, 4422,   72165, 12, }, // Pacific/Apia
    {  306,  932,   72177, 14, }, // Pacific/Auckland
    {  306, 3706,   72191, 18, }, // Pacific/Bougainville
    {  306, 3015,   72209, 12, }, // Pacific/Chatham
    {  306, 3157,   72221, 10, }, // Pacific/Chuuk
    {  306, 2237,   72231, 10, }, // Pacific/Easter
    {  306, 7360,   72241, 10, }, // Pacific/Efate
    {  306, 7327,   72251, 14, }, // Pacific/Fakaofo
    {  306, 3902,   72265, 10, }, // Pacific/Fiji
    {  306, 7343,   72275, 18, }, // Pacific/Funafuti
    {  306, 6678,   72293, 18, }, // Pacific/Galapagos
    {  306, 6696,   72311, 16, }, // Pacific/Gambier
    {  306, 3822,   72327, 24, }, // Pacific/Guadalcanal
    {  306, 6018,   72351, 12, }, // Pacific/Guam
    {  306, 3049,   72363, 20, }, // Pacific/Kanton
    {  306, 3998,   72383, 20, }, // Pacific/Kiritimati
    {  306, 7019,   72403, 12, }, // Pacific/Kosrae
    {  306, 2842,   72415, 20, }, // Pacific/Kwajalein
    {  306, 4877,   72435, 14, }, // Pacific/Majuro
    {  306, 4051,   72449, 18, }, // Pacific/Marquesas
    {  306, 8914,   72467, 12, }, // Pacific/Midway
    {  306, 7084,   72479, 10, }, // Pacific/Nauru
    {  306, 7132,   72489, 10, }, // Pacific/Niue
    {  306, 4168,   72499, 16, }, // Pacific/Norfolk
    {  306, 7098,   72515, 12, }, // Pacific/Noumea
    {  306, 3126,   72527, 17, }, // Pacific/Pago_Pago
    {  306, 7155,   72544, 10, }, // Pacific/Palau
    {  306, 7194,   72554, 18, }, // Pacific/Pitcairn
    {  306, 3096,   72572, 12, }, // Pacific/Pohnpei
    {  306, 4807,   72584, 25, }, // Pacific/Port_Moresby
    {  306, 6076,   72609, 18, }, // Pacific/Rarotonga
    {  306, 6031,   72627, 14, }, // Pacific/Saipan
    {  306, 7312,   72641, 14, }, // Pacific/Tahiti
    {  306, 6712,   72655, 14, }, // Pacific/Tarawa
    {  306, 4583,   72669, 20, }, // Pacific/Tongatapu
    {  306, 7392,   72689, 10, }, // Pacific/Wake
    {  306, 7405,   72699, 14, }, // Pacific/Wallis
    {  324, 5059,   72713, 11, }, // Africa/Addis_Ababa Gaelic/Latin/United Kingdom
    {  324,   14,   72724,  6, }, // Africa/Asmara
    {  324, 5130,   72730, 12, }, // Africa/Dar_es_Salaam
    {  324, 5043,   72742, 10, }, // Africa/Djibouti
    {  324, 5166,   63491,  8, }, // Africa/El_Aaiun
    {  324, 4479,   72752, 11, }, // Africa/Johannesburg
    {  324, 6869,   20418,  4, }, // Africa/Lome
    {  324, 5271,   72763,  9, }, // Africa/Ndjamena
    {  324, 4435,       6,  8, }, // Africa/Sao_Tome
    {  324, 5607,   72772,  9, }, // America/Anguilla
    {  324, 5624,   72781,  8, }, // America/Antigua
    {  324, 4554,   26559,  9, }, // America/Araguaina
    {  324,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  324, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  324, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  324, 5640,   72789,  5, }, // America/Aruba
    {  324, 4252,      14,  8, }, // America/Asuncion
    {  324,  237,      22,  8, }, // America/Atikokan
    {  324, 7623,      30, 17, }, // America/Bahia_Banderas
    {  324, 7646,   35896,  5, }, // America/Belem
    {  324, 5407,   72794, 10, }, // America/Belize
    {  324, 4361,   20507,  6, }, // America/Bogota
    {  324, 3868,      47,  6, }, // America/Cancun
    {  324, 5496,   72804,  7, }, // America/Cayman
    {  324, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  324, 5422,   72811, 11, }, // America/Costa_Rica
    {  324, 3791,   26574,  6, }, // America/Cuiaba
    {  324, 5723,      66,  7, }, // America/Curacao
    {  324, 5739,   72822, 10, }, // America/Dominica
    {  324, 7869,   26580,  8, }, // America/Eirunepe
    {  324, 5441,   72832, 12, }, // America/El_Salvador
    {  324, 7924,   72844,  9, }, // America/Glace_Bay
    {  324, 4612,   72853, 12, }, // America/Grand_Turk
    {  324, 5770,   72865,  8, }, // America/Grenada
    {  324, 5786,   20526,  8, }, // America/Guadeloupe
    {  324, 3760,   72873,  9, }, // America/Guatemala
    {  324, 6932,   72882,  9, }, // America/Guyana
    {  324,  481,      73, 13, }, // America/Indiana/Knox
    {  324, 7961,      86, 16, }, // America/Indiana/Marengo
    {  324, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  324, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  324, 8038,     139, 14, }, // America/Indiana/Vevay
    {  324, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  324, 8086,     171, 16, }, // America/Indiana/Winamac
    {  324, 8110,   72891,  7, }, // America/Inuvik
    {  324, 2799,   72898,  8, }, // America/Jamaica
    {  324, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  324, 5932,     207, 22, }, // America/Lower_Princes
    {  324, 8153,   26588,  6, }, // America/Maceio
    {  324, 5805,   72906,  9, }, // America/Martinique
    {  324, 2917,   26603,  8, }, // America/Mazatlan
    {  324, 8220,     229,  6, }, // America/Merida
    {  324, 2949,   72915, 17, }, // America/Mexico_City
    {  324, 5824,   72932,  9, }, // America/Montserrat
    {  324, 2379,   72941, 13, }, // America/New_York
    {  324, 1850,     235, 19, }, // America/Noronha
    {  324, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  324, 8329,     274, 20, }, // America/North_Dakota/Center
    {  324, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  324,  393,     317,  4, }, // America/Nuuk
    {  324, 5954,   72954, 15, }, // America/Port_of_Spain
    {  324, 5843,   72969, 11, }, // America/Puerto_Rico
    {  324, 8424,   72980, 11, }, // America/Rankin_Inlet
    {  324, 8460,   72991, 10, }, // America/Resolute
    {  324, 8477,   26704,  8, }, // America/Santarem
    {  324, 1878,   26712,  9, }, // America/Sao_Paulo
    {  324, 6899,     321, 16, }, // America/Scoresbysund
    {  324, 8508,   35936, 16, }, // America/St_Barthelemy
    {  324, 2061,     351, 10, }, // America/St_Johns
    {  324, 5863,   73001, 14, }, // America/St_Kitts
    {  324, 5880,   73015, 12, }, // America/St_Lucia
    {  324,  855,     379, 10, }, // America/St_Thomas
    {  324, 5913,   73027, 15, }, // America/St_Vincent
    {  324, 5756,   26796,  7, }, // America/Thule
    {  324, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  324, 8568,   73042, 17, }, // Antarctica/Macquarie
    {  324, 3968,   73059,  5, }, // Asia/Amman
    {  324, 5368,   57205,  6, }, // Asia/Aqtobe
    {  324,  964,   44322,  7, }, // Asia/Ashgabat
    {  324, 3607,   73064,  7, }, // Asia/Baghdad
    {  324, 5534,   73071,  8, }, // Asia/Bahrain
    {  324, 3778,   33455,  6, }, // Asia/Bishkek
    {  324, 5989,   73079,  8, }, // Asia/Brunei
    {  324, 6159,   33468,  7, }, // Asia/Dushanbe
    {  324, 8651,   73087,  4, }, // Asia/Gaza
    {  324, 1259,   73091, 19, }, // Asia/Ho_Chi_Minh
    {  324, 4771,   26835,  5, }, // Asia/Hovd
    {  324, 1290,   73110,  9, }, // Asia/Jerusalem
    {  324, 4239,   73119,  6, }, // Asia/Karachi
    {  324, 1185,     448,  9, }, // Asia/Kathmandu
    {  324,  992,     457,  7, }, // Asia/Kolkata
    {  324, 5547,   73125,  8, }, // Asia/Kuwait
    {  324, 1211,   73133,  7, }, // Asia/Macau
    {  324, 4214,   73140, 10, }, // Asia/Pyongyang
    {  324, 5559,   73150,  5, }, // Asia/Qatar
    {  324, 8708,   73155,  8, }, // Asia/Qostanay
    {  324, 4269,   22533,  9, }, // Asia/Qyzylorda
    {  324, 3300,   73163,  9, }, // Asia/Singapore
    {  324, 4781,   73172,  7, }, // Asia/Tashkent
    {  324, 3915,   73179,  8, }, // Asia/Tbilisi
    {  324, 2772,   73187,  6, }, // Asia/Tehran
    {  324, 2821,   63705,  5, }, // Asia/Tokyo
    {  324, 1159,   26933,  6, }, // Asia/Urumqi
    {  324, 6977,   73193, 10, }, // Asia/Vientiane
    {  324, 1235,    7880,  6, }, // Asia/Yangon
    {  324, 3663,   73203, 13, }, // Atlantic/Azores
    {  324, 5671,   73216,  8, }, // Atlantic/Bermuda
    {  324, 6628,   73224, 22, }, // Atlantic/Canary
    {  324, 3727,   73246, 13, }, // Atlantic/Cape_Verde
    {  324, 1395,   73259,  4, }, // Atlantic/Faroe
    {  324, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  324, 7272,   73263, 14, }, // Atlantic/South_Georgia
    {  324, 6821,   73277, 19, }, // Atlantic/St_Helena
    {  324, 1463,    5892,  5, }, // Australia/Sydney
    {  324, 2300,   73296,  9, }, // Europe/Athens
    {  324, 2167,   73305, 12, }, // Europe/Brussels
    {  324, 2583,   63785,  8, }, // Europe/Chisinau
    {  324, 6289,   73317,  6, }, // Europe/Copenhagen
    {  324, 2338,   73323, 17, }, // Europe/Dublin
    {  324, 6307,   73340, 10, }, // Europe/Gibraltar
    {  324, 8788,   73350, 10, }, // Europe/Guernsey
    {  324, 8804,   73360, 15, }, // Europe/Isle_of_Man
    {  324, 8823,   73375,  9, }, // Europe/Jersey
    {  324, 2527,    8148,  4, }, // Europe/Kyiv
    {  324, 2501,   73384, 20, }, // Europe/London
    {  324, 6365,   73404, 10, }, // Europe/Luxembourg
    {  324, 3537,   73414,  5, }, // Europe/Moscow
    {  324, 4284,   73419,  5, }, // Europe/Paris
    {  324, 6275,   73424,  4, }, // Europe/Prague
    {  324, 8837,   73428,  4, }, // Europe/Riga
    {  324, 6324,   73432,  8, }, // Europe/Rome
    {  324, 6599,   22919,  6, }, // Europe/Sofia
    {  324, 6202,    8255,  6, }, // Europe/Tirane
    {  324, 6567,   73440, 11, }, // Europe/Vatican
    {  324, 6540,    4577,  6, }, // Europe/Zurich
    {  324, 6046,   73451,  7, }, // Indian/Christmas
    {  324, 6661,   36302,  9, }, // Indian/Kerguelen
    {  324, 7260,   27115,  4, }, // Indian/Mahe
    {  324, 7050,   73458, 24, }, // Indian/Maldives
    {  324, 4069,   73482, 24, }, // Indian/Mauritius
    {  324, 7211,     547,  7, }, // Indian/Reunion
    {  324, 3157,     554,  5, }, // Pacific/Chuuk
    {  324, 2237,   73506,  8, }, // Pacific/Easter
    {  324, 3902,   73514,  4, }, // Pacific/Fiji
    {  324, 6678,   21277,  9, }, // Pacific/Galapagos
    {  324, 6696,   73518,  9, }, // Pacific/Gambier
    {  324, 2723,    4611,  8, }, // Pacific/Honolulu
    {  324, 3049,    4619,  9, }, // Pacific/Kanton
    {  324, 4051,   73527, 20, }, // Pacific/Marquesas
    {  324, 7084,   73547,  6, }, // Pacific/Nauru
    {  324, 7155,   73553,  6, }, // Pacific/Palau
    {  324, 7194,   73559, 14, }, // Pacific/Pitcairn
    {  324, 3096,     586,  7, }, // Pacific/Pohnpei
    {  324, 7405,   73573,  6, }, // Pacific/Wallis
    {  325, 6760,    4825,  2, }, // Africa/Accra Ga/Latin/Ghana
    {  325,   14,       0,  6, }, // Africa/Asmara
    {  325, 2320,    4690,  5, }, // Africa/Cairo
    {  325, 4117,    4695, 10, }, // Africa/Casablanca
    {  325, 6773,   26485,  7, }, // Africa/Conakry
    {  325, 6803,   73579, 10, }, // Africa/Nouakchott
    {  325, 4435,       6,  8, }, // Africa/Sao_Tome
    {  325, 3346,   73589,  8, }, // America/Anchorage
    {  325, 4252,      14,  8, }, // America/Asuncion
    {  325,  237,      22,  8, }, // America/Atikokan
    {  325, 7623,      30, 17, }, // America/Bahia_Banderas
    {  325, 7660,    6620, 12, }, // America/Blanc-Sablon
    {  325, 7713,   73597, 25, }, // America/Cambridge_Bay
    {  325, 3868,    6682,  6, }, // America/Cancun
    {  325, 5496,   21601,  6, }, // America/Cayman
    {  325, 2260,   73622,  7, }, // America/Chicago
    {  325, 7756,   73629,  9, }, // America/Chihuahua
    {  325, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  325, 5422,   21621, 10, }, // America/Costa_Rica
    {  325, 7796,    6736,  7, }, // America/Creston
    {  325, 5723,    6749,  7, }, // America/Curacao
    {  325, 7848,   73638, 21, }, // America/Dawson_Creek
    {  325, 5739,   21666,  8, }, // America/Dominica
    {  325, 7886,   73659, 10, }, // America/Fort_Nelson
    {  325, 7924,   73669, 21, }, // America/Glace_Bay
    {  325, 6881,   73690, 21, }, // America/Goose_Bay
    {  325, 4612,   73711, 10, }, // America/Grand_Turk
    {  325, 1939,   73721,  7, }, // America/Halifax
    {  325,  481,   73728, 13, }, // America/Indiana/Knox
    {  325, 7961,      86, 16, }, // America/Indiana/Marengo
    {  325, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  325, 8012,   73741, 19, }, // America/Indiana/Tell_City
    {  325, 8038,     139, 14, }, // America/Indiana/Vevay
    {  325, 8060,   73760, 18, }, // America/Indiana/Vincennes
    {  325, 8086,    5161, 16, }, // America/Indiana/Winamac
    {  325,  660,    5177,  7, }, // America/Iqaluit
    {  325, 2799,    3995,  7, }, // America/Jamaica
    {  325, 8125,   73778, 19, }, // America/Kentucky/Monticello
    {  325, 5932,   73797, 26, }, // America/Lower_Princes
    {  325, 5805,    5260,  8, }, // America/Martinique
    {  325, 8220,     229,  6, }, // America/Merida
    {  325, 2949,   73823, 10, }, // America/Mexico_City
    {  325, 4391,    7149,  7, }, // America/Miquelon
    {  325, 8254,    7156,  7, }, // America/Moncton
    {  325, 1850,     235, 19, }, // America/Noronha
    {  325, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  325, 8329,   73833, 23, }, // America/North_Dakota/Center
    {  325, 8357,   73856, 26, }, // America/North_Dakota/New_Salem
    {  325,  393,     317,  4, }, // America/Nuuk
    {  325, 3945,   73882, 21, }, // America/Port-au-Prince
    {  325, 5954,   73903, 18, }, // America/Port_of_Spain
    {  325, 5843,   22058, 11, }, // America/Puerto_Rico
    {  325, 8424,   73921, 15, }, // America/Rankin_Inlet
    {  325, 6899,   73936, 15, }, // America/Scoresbysund
    {  325, 8508,     337, 14, }, // America/St_Barthelemy
    {  325, 2061,     351, 10, }, // America/St_Johns
    {  325, 5863,     361,  9, }, // America/St_Kitts
    {  325, 5880,   73951,  9, }, // America/St_Lucia
    {  325,  855,     379, 10, }, // America/St_Thomas
    {  325, 5913,   73960, 11, }, // America/St_Vincent
    {  325, 8530,   73971, 12, }, // America/Swift_Current
    {  325, 5461,    5528, 11, }, // America/Tegucigalpa
    {  325, 2093,   73983,  9, }, // America/Vancouver
    {  325, 2144,   73992, 10, }, // America/Whitehorse
    {  325, 6001,   74002,  5, }, // Antarctica/Casey
    {  325, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  325, 8568,   74007,  8, }, // Antarctica/Macquarie
    {  325, 7113,   74015,  8, }, // Antarctica/McMurdo
    {  325, 5523,    5609,  5, }, // Asia/Aqtau
    {  325, 5368,    7606,  6, }, // Asia/Aqtobe
    {  325, 4511,    5637,  7, }, // Asia/Colombo
    {  325, 4540,   26821,  7, }, // Asia/Damascus
    {  325, 1259,   74023, 20, }, // Asia/Ho_Chi_Minh
    {  325, 1290,    5686,  9, }, // Asia/Jerusalem
    {  325, 4239,   74043,  7, }, // Asia/Karachi
    {  325, 1185,     448,  9, }, // Asia/Kathmandu
    {  325,  992,     457,  7, }, // Asia/Kolkata
    {  325, 5976,   74050,  7, }, // Asia/Kuching
    {  325, 1211,    7731,  5, }, // Asia/Macau
    {  325, 6920,    4326,  6, }, // Asia/Muscat
    {  325, 2554,    5738,  7, }, // Asia/Nicosia
    {  325, 5559,    4332,  4, }, // Asia/Qatar
    {  325, 8708,     469,  8, }, // Asia/Qostanay
    {  325, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  325, 1159,   74057,  6, }, // Asia/Urumqi
    {  325, 1235,     477,  6, }, // Asia/Yangon
    {  325, 3727,   22654, 10, }, // Atlantic/Cape_Verde
    {  325, 1395,     483,  5, }, // Atlantic/Faroe
    {  325, 6821,     488, 10, }, // Atlantic/St_Helena
    {  325, 1799,   74063, 15, }, // Australia/Broken_Hill
    {  325, 3637,   22722,  5, }, // Australia/Eucla
    {  325, 1547,   74078, 11, }, // Australia/Lord_Howe
    {  325, 2527,     514,  4, }, // Europe/Kyiv
    {  325, 6947,   74089,  6, }, // Indian/Chagos
    {  325, 6046,   74095,  7, }, // Indian/Christmas
    {  325, 6063,    4583,  5, }, // Indian/Cocos
    {  325, 5029,   22985,  6, }, // Indian/Comoro
    {  325, 7211,     547,  7, }, // Indian/Reunion
    {  325,  932,   74102,  6, }, // Pacific/Auckland
    {  325, 3015,   74108,  7, }, // Pacific/Chatham
    {  325, 3157,   74115,  5, }, // Pacific/Chuuk
    {  325, 3822,    8360, 11, }, // Pacific/Guadalcanal
    {  325, 4051,   74120,  9, }, // Pacific/Marquesas
    {  325, 7194,    6251,  8, }, // Pacific/Pitcairn
    {  325, 3096,     586,  7, }, // Pacific/Pohnpei
    {  326, 6760,   74129,  4, }, // Africa/Accra Galician/Latin/Spain
    {  326, 5059,   20370, 10, }, // Africa/Addis_Ababa
    {  326, 7420,   74133,  5, }, // Africa/Algiers
    {  326,   14,       0,  6, }, // Africa/Asmara
    {  326,   44,   74138,  6, }, // Africa/Bamako
    {  326, 2320,   74144,  7, }, // Africa/Cairo
    {  326, 5043,   26492,  7, }, // Africa/Djibouti
    {  326, 5166,   74151,  6, }, // Africa/El_Aaiun
    {  326, 4479,   74157, 12, }, // Africa/Johannesburg
    {  326, 4524,   74169,  7, }, // Africa/Khartoum
    {  326, 6869,   20418,  4, }, // Africa/Lome
    {  326, 5001,   74176,  6, }, // Africa/Lusaka
    {  326, 5113,   74182,  8, }, // Africa/Mogadishu
    {  326, 5271,   44128,  9, }, // Africa/Ndjamena
    {  326, 6727,   26534,  8, }, // Africa/Ouagadougou
    {  326, 4435,   74190,  8, }, // Africa/Sao_Tome
    {  326, 2866,   20467,  7, }, // Africa/Tripoli
    {  326, 6554,   74198,  5, }, // Africa/Tunis
    {  326, 5607,    4775,  7, }, // America/Anguilla
    {  326, 4554,   26559,  9, }, // America/Araguaina
    {  326,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  326, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  326, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  326, 4252,      14,  8, }, // America/Asuncion
    {  326,  237,      22,  8, }, // America/Atikokan
    {  326, 3679,   74203,  4, }, // America/Bahia
    {  326, 7623,      30, 17, }, // America/Bahia_Banderas
    {  326, 7646,   35896,  5, }, // America/Belem
    {  326, 4361,   20507,  6, }, // America/Bogota
    {  326, 3868,      47,  6, }, // America/Cancun
    {  326, 4345,   44167,  6, }, // America/Cayenne
    {  326, 5496,   74207, 12, }, // America/Cayman
    {  326, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  326, 3791,   26574,  6, }, // America/Cuiaba
    {  326, 5723,      66,  7, }, // America/Curacao
    {  326, 7869,   26580,  8, }, // America/Eirunepe
    {  326, 5441,   74219, 10, }, // America/El_Salvador
    {  326, 5770,   20519,  7, }, // America/Grenada
    {  326, 5786,   20526,  9, }, // America/Guadeloupe
    {  326, 6932,   74229,  6, }, // America/Guyana
    {  326, 2281,   74235,  8, }, // America/Havana
    {  326,  348,   74243, 12, }, // America/Indiana/Indianapolis
    {  326,  481,      73, 13, }, // America/Indiana/Knox
    {  326, 7961,      86, 16, }, // America/Indiana/Marengo
    {  326, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  326, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  326, 8038,     139, 14, }, // America/Indiana/Vevay
    {  326, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  326, 8086,     171, 16, }, // America/Indiana/Winamac
    {  326, 2799,   20544,  7, }, // America/Jamaica
    {  326, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  326, 4376,   74255,  5, }, // America/La_Paz
    {  326, 3239,   74260, 10, }, // America/Los_Angeles
    {  326, 5932,     207, 22, }, // America/Lower_Princes
    {  326, 8153,   26588,  6, }, // America/Maceio
    {  326, 5805,   20554,  9, }, // America/Martinique
    {  326, 2917,   26603,  8, }, // America/Mazatlan
    {  326, 8220,     229,  6, }, // America/Merida
    {  326, 2949,   74270, 16, }, // America/Mexico_City
    {  326, 2379,   44194,  9, }, // America/New_York
    {  326, 1850,     235, 19, }, // America/Noronha
    {  326, 8301,   74286, 23, }, // America/North_Dakota/Beulah
    {  326, 8329,   74309, 23, }, // America/North_Dakota/Center
    {  326, 8357,   74332, 26, }, // America/North_Dakota/New_Salem
    {  326,  393,     317,  4, }, // America/Nuuk
    {  326, 2356,   20665,  6, }, // America/Panama
    {  326, 3945,   74358, 14, }, // America/Port-au-Prince
    {  326, 5954,   74372, 12, }, // America/Port_of_Spain
    {  326, 5843,   64979, 10, }, // America/Puerto_Rico
    {  326,  695,   74384, 10, }, // America/Rio_Branco
    {  326, 8477,   26704,  8, }, // America/Santarem
    {  326, 1878,   26712,  9, }, // America/Sao_Paulo
    {  326, 6899,     321, 16, }, // America/Scoresbysund
    {  326, 8508,   35936, 16, }, // America/St_Barthelemy
    {  326, 2061,   26737, 12, }, // America/St_Johns
    {  326, 5863,   26749, 11, }, // America/St_Kitts
    {  326, 5880,   74394, 11, }, // America/St_Lucia
    {  326,  855,   44293, 12, }, // America/St_Thomas
    {  326, 5913,   74405, 11, }, // America/St_Vincent
    {  326, 5688,   20723,  7, }, // America/Tortola
    {  326, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  326, 7295,   62201,  5, }, // Antarctica/Syowa
    {  326, 5570,   74416,  4, }, // Asia/Aden
    {  326, 5395,    7594,  6, }, // Asia/Almaty
    {  326, 3968,   20730,  4, }, // Asia/Amman
    {  326, 5523,    5609,  5, }, // Asia/Aqtau
    {  326, 5368,    7606,  6, }, // Asia/Aqtobe
    {  326,  964,   74420,  9, }, // Asia/Ashgabat
    {  326, 3607,    4162,  6, }, // Asia/Baghdad
    {  326, 3653,   74429,  4, }, // Asia/Baku
    {  326, 4601,   74433,  5, }, // Asia/Chita
    {  326, 4540,   74438,  7, }, // Asia/Damascus
    {  326, 4795,   20771,  6, }, // Asia/Hebron
    {  326, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  326, 7006,   74445,  7, }, // Asia/Jakarta
    {  326, 1290,   20821,  9, }, // Asia/Jerusalem
    {  326, 3560,   74452,  5, }, // Asia/Kabul
    {  326, 1185,   20830,  8, }, // Asia/Kathmandu
    {  326, 8661,   58020,  8, }, // Asia/Khandyga
    {  326,  992,   20838,  7, }, // Asia/Kolkata
    {  326, 1211,    4321,  5, }, // Asia/Macau
    {  326, 6920,   20857,  7, }, // Asia/Muscat
    {  326, 8708,   44391,  8, }, // Asia/Qostanay
    {  326, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  326, 3584,    7787,  4, }, // Asia/Riyadh
    {  326, 4408,   44399,  8, }, // Asia/Sakhalin
    {  326, 7245,   20886, 10, }, // Asia/Samarkand
    {  326, 3279,   20896,  4, }, // Asia/Seoul
    {  326, 3300,   20900,  8, }, // Asia/Singapore
    {  326, 4297,    7817, 13, }, // Asia/Srednekolymsk
    {  326, 2772,   58125,  7, }, // Asia/Tehran
    {  326, 1159,   26933,  6, }, // Asia/Urumqi
    {  326, 4828,   44441,  7, }, // Asia/Yakutsk
    {  326, 1235,     477,  6, }, // Asia/Yangon
    {  326, 3883,   74457, 13, }, // Asia/Yekaterinburg
    {  326, 3747,   74470,  7, }, // Asia/Yerevan
    {  326, 5671,   74477, 14, }, // Atlantic/Bermuda
    {  326, 6628,   74491, 14, }, // Atlantic/Canary
    {  326, 3727,   26968, 10, }, // Atlantic/Cape_Verde
    {  326, 1395,   20992,  5, }, // Atlantic/Faroe
    {  326, 2748,   74505, 10, }, // Atlantic/Reykjavik
    {  326, 7272,   74515, 14, }, // Atlantic/South_Georgia
    {  326, 6821,   26997, 12, }, // Atlantic/St_Helena
    {  326, 1670,   21030,  8, }, // Australia/Adelaide
    {  326, 1463,   22739,  6, }, // Australia/Sydney
    {  326, 6441,   74529,  9, }, // Europe/Amsterdam
    {  326, 3620,   74538,  8, }, // Europe/Astrakhan
    {  326, 2300,   27009,  6, }, // Europe/Athens
    {  326, 6336,   58906,  8, }, // Europe/Belgrade
    {  326, 4757,   21059,  6, }, // Europe/Berlin
    {  326, 2167,   74546,  8, }, // Europe/Brussels
    {  326, 3928,   21073,  8, }, // Europe/Bucharest
    {  326, 6289,   21081, 10, }, // Europe/Copenhagen
    {  326, 2338,   21091,  6, }, // Europe/Dublin
    {  326, 6307,   21097,  9, }, // Europe/Gibraltar
    {  326, 6612,   74554,  9, }, // Europe/Helsinki
    {  326, 8804,   74563, 11, }, // Europe/Isle_of_Man
    {  326, 3979,   63006, 12, }, // Europe/Kaliningrad
    {  326, 2527,   44566,  4, }, // Europe/Kyiv
    {  326, 3213,   21137,  6, }, // Europe/Lisbon
    {  326, 6506,   21143,  9, }, // Europe/Ljubljana
    {  326, 2501,   21152,  7, }, // Europe/London
    {  326, 6365,   74574, 10, }, // Europe/Luxembourg
    {  326, 6410,   74584,  6, }, // Europe/Monaco
    {  326, 3537,   74590,  7, }, // Europe/Moscow
    {  326, 4284,   21180,  5, }, // Europe/Paris
    {  326, 6275,   21185,  5, }, // Europe/Prague
    {  326, 6324,    6064,  4, }, // Europe/Rome
    {  326, 6245,   74597,  8, }, // Europe/Sarajevo
    {  326, 8849,   74605, 10, }, // Europe/Simferopol
    {  326, 6599,   21199,  5, }, // Europe/Sofia
    {  326, 6523,   74615,  9, }, // Europe/Stockholm
    {  326, 6202,   21213,  6, }, // Europe/Tirane
    {  326, 8882,   27092,  9, }, // Europe/Ulyanovsk
    {  326, 6567,   74624,  8, }, // Europe/Vatican
    {  326, 6231,   21230,  5, }, // Europe/Vienna
    {  326, 4727,   63187, 10, }, // Europe/Volgograd
    {  326, 3190,   21244,  8, }, // Europe/Warsaw
    {  326, 6540,    4577,  6, }, // Europe/Zurich
    {  326, 6046,   74632, 14, }, // Indian/Christmas
    {  326, 5029,   65504,  7, }, // Indian/Comoro
    {  326, 7260,   27115,  4, }, // Indian/Mahe
    {  326, 7050,   74646,  8, }, // Indian/Maldives
    {  326, 4069,   74654,  8, }, // Indian/Mauritius
    {  326, 7211,   21260,  7, }, // Indian/Reunion
    {  326, 3157,     554,  5, }, // Pacific/Chuuk
    {  326, 2237,   74662, 14, }, // Pacific/Easter
    {  326, 3902,   21273,  4, }, // Pacific/Fiji
    {  326, 6678,   74676, 15, }, // Pacific/Galapagos
    {  326, 2723,   74691,  8, }, // Pacific/Honolulu
    {  326, 3049,    4619,  9, }, // Pacific/Kanton
    {  326, 3096,     586,  7, }, // Pacific/Pohnpei
    {  326, 7312,   44657,  6, }, // Pacific/Tahiti
    {  327,   14,       0,  6, }, // Africa/Asmara Ganda/Latin/Uganda
    {  327, 4435,       6,  8, }, // Africa/Sao_Tome
    {  327, 4252,      14,  8, }, // America/Asuncion
    {  327,  237,      22,  8, }, // America/Atikokan
    {  327, 7623,      30, 17, }, // America/Bahia_Banderas
    {  327, 3868,      47,  6, }, // America/Cancun
    {  327, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  327, 5723,      66,  7, }, // America/Curacao
    {  327,  481,      73, 13, }, // America/Indiana/Knox
    {  327, 7961,      86, 16, }, // America/Indiana/Marengo
    {  327, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  327, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  327, 8038,     139, 14, }, // America/Indiana/Vevay
    {  327, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  327, 8086,     171, 16, }, // America/Indiana/Winamac
    {  327, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  327, 5932,     207, 22, }, // America/Lower_Princes
    {  327, 8220,     229,  6, }, // America/Merida
    {  327, 1850,     235, 19, }, // America/Noronha
    {  327, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  327, 8329,     274, 20, }, // America/North_Dakota/Center
    {  327, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  327,  393,     317,  4, }, // America/Nuuk
    {  327, 6899,     321, 16, }, // America/Scoresbysund
    {  327, 8508,     337, 14, }, // America/St_Barthelemy
    {  327, 2061,     351, 10, }, // America/St_Johns
    {  327, 5863,     361,  9, }, // America/St_Kitts
    {  327, 5880,     370,  9, }, // America/St_Lucia
    {  327,  855,     379, 10, }, // America/St_Thomas
    {  327, 5913,     389, 11, }, // America/St_Vincent
    {  327, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  327, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  327, 1185,     448,  9, }, // Asia/Kathmandu
    {  327,  992,     457,  7, }, // Asia/Kolkata
    {  327, 1211,     464,  5, }, // Asia/Macau
    {  327, 1235,     477,  6, }, // Asia/Yangon
    {  327, 1395,     483,  5, }, // Atlantic/Faroe
    {  327, 6821,     488, 10, }, // Atlantic/St_Helena
    {  327, 2527,     514,  4, }, // Europe/Kyiv
    {  327, 7211,     547,  7, }, // Indian/Reunion
    {  327, 3157,     554,  5, }, // Pacific/Chuuk
    {  327, 3096,     586,  7, }, // Pacific/Pohnpei
    {  328,   14,       0,  6, }, // Africa/Asmara Geez/Ethiopic/Ethiopia
    {  328, 4435,       6,  8, }, // Africa/Sao_Tome
    {  328, 4252,      14,  8, }, // America/Asuncion
    {  328,  237,      22,  8, }, // America/Atikokan
    {  328, 7623,      30, 17, }, // America/Bahia_Banderas
    {  328, 3868,      47,  6, }, // America/Cancun
    {  328, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  328, 5723,      66,  7, }, // America/Curacao
    {  328,  481,      73, 13, }, // America/Indiana/Knox
    {  328, 7961,      86, 16, }, // America/Indiana/Marengo
    {  328, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  328, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  328, 8038,     139, 14, }, // America/Indiana/Vevay
    {  328, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  328, 8086,     171, 16, }, // America/Indiana/Winamac
    {  328, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  328, 5932,     207, 22, }, // America/Lower_Princes
    {  328, 8220,     229,  6, }, // America/Merida
    {  328, 1850,     235, 19, }, // America/Noronha
    {  328, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  328, 8329,     274, 20, }, // America/North_Dakota/Center
    {  328, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  328,  393,     317,  4, }, // America/Nuuk
    {  328, 6899,     321, 16, }, // America/Scoresbysund
    {  328, 8508,     337, 14, }, // America/St_Barthelemy
    {  328, 2061,     351, 10, }, // America/St_Johns
    {  328, 5863,     361,  9, }, // America/St_Kitts
    {  328, 5880,     370,  9, }, // America/St_Lucia
    {  328,  855,     379, 10, }, // America/St_Thomas
    {  328, 5913,     389, 11, }, // America/St_Vincent
    {  328, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  328, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  328, 1185,     448,  9, }, // Asia/Kathmandu
    {  328,  992,     457,  7, }, // Asia/Kolkata
    {  328, 1211,     464,  5, }, // Asia/Macau
    {  328, 1235,     477,  6, }, // Asia/Yangon
    {  328, 1395,     483,  5, }, // Atlantic/Faroe
    {  328, 6821,     488, 10, }, // Atlantic/St_Helena
    {  328, 2527,     514,  4, }, // Europe/Kyiv
    {  328, 7211,     547,  7, }, // Indian/Reunion
    {  328, 3157,     554,  5, }, // Pacific/Chuuk
    {  328, 3096,     586,  7, }, // Pacific/Pohnpei
    {  330, 6788,   74699,  7, }, // Africa/Abidjan Georgian/Georgian/Georgia
    {  330, 6760,   74706,  4, }, // Africa/Accra
    {  330, 5059,   74710, 10, }, // Africa/Addis_Ababa
    {  330, 7420,   74720,  6, }, // Africa/Algiers
    {  330,   14,   74726,  6, }, // Africa/Asmara
    {  330,   44,   74732,  6, }, // Africa/Bamako
    {  330, 5257,   74738,  5, }, // Africa/Bangui
    {  330, 6746,   74743,  7, }, // Africa/Banjul
    {  330, 7435,   74750,  5, }, // Africa/Bissau
    {  330, 4957,   74755,  8, }, // Africa/Blantyre
    {  330, 5287,   74763,  9, }, // Africa/Brazzaville
    {  330, 4922,   74772,  9, }, // Africa/Bujumbura
    {  330, 2320,   74781,  5, }, // Africa/Cairo
    {  330, 4117,   74786, 10, }, // Africa/Casablanca
    {  330, 7449,   74796,  5, }, // Africa/Ceuta
    {  330, 6773,   74801,  7, }, // Africa/Conakry
    {  330, 6840,   74808,  6, }, // Africa/Dakar
    {  330, 5130,   74814, 13, }, // Africa/Dar_es_Salaam
    {  330, 5043,   74827,  6, }, // Africa/Djibouti
    {  330, 5243,   74833,  5, }, // Africa/Douala
    {  330, 5166,   74838,  9, }, // Africa/El_Aaiun
    {  330, 6853,   74847,  8, }, // Africa/Freetown
    {  330, 4906,   74855,  8, }, // Africa/Gaborone
    {  330, 5015,   74863,  6, }, // Africa/Harare
    {  330, 4479,   74869, 12, }, // Africa/Johannesburg
    {  330, 4499,   74881,  4, }, // Africa/Juba
    {  330, 5151,   74885,  7, }, // Africa/Kampala
    {  330, 4524,   74892,  7, }, // Africa/Khartoum
    {  330, 4973,   74899,  6, }, // Africa/Kigali
    {  330, 5306,   74905,  7, }, // Africa/Kinshasa
    {  330, 4744,   74912,  6, }, // Africa/Lagos
    {  330, 5336,   74918,  9, }, // Africa/Libreville
    {  330, 6869,   74927,  4, }, // Africa/Lome
    {  330, 5211,   74931,  6, }, // Africa/Luanda
    {  330, 4939,   74937,  9, }, // Africa/Lubumbashi
    {  330, 5001,   74946,  6, }, // Africa/Lusaka
    {  330, 5322,   74952,  6, }, // Africa/Malabo
    {  330, 4987,   74958,  6, }, // Africa/Maputo
    {  330, 5197,   74964,  6, }, // Africa/Maseru
    {  330, 5182,   74970,  7, }, // Africa/Mbabane
    {  330, 5113,   74977,  8, }, // Africa/Mogadishu
    {  330, 7034,   74985,  8, }, // Africa/Monrovia
    {  330, 3853,   74993,  7, }, // Africa/Nairobi
    {  330, 5271,   75000,  7, }, // Africa/Ndjamena
    {  330, 5354,   75007,  6, }, // Africa/Niamey
    {  330, 6803,   75013,  8, }, // Africa/Nouakchott
    {  330, 6727,   75021,  8, }, // Africa/Ouagadougou
    {  330, 5225,   75029, 10, }, // Africa/Porto-Novo
    {  330, 4435,   75039,  8, }, // Africa/Sao_Tome
    {  330, 2866,   75047,  7, }, // Africa/Tripoli
    {  330, 6554,   75054,  6, }, // Africa/Tunis
    {  330, 4152,   75060,  8, }, // Africa/Windhoek
    {  330,  132,   75068,  5, }, // America/Adak
    {  330, 3346,   75073,  8, }, // America/Anchorage
    {  330, 5607,   75081,  7, }, // America/Anguilla
    {  330, 5624,   75088,  7, }, // America/Antigua
    {  330, 4554,   75095,  9, }, // America/Araguaina
    {  330,  166,   75104, 13, }, // America/Argentina/Buenos_Aires
    {  330,   91,   75117,  9, }, // America/Argentina/Catamarca
    {  330,  270,   75126,  7, }, // America/Argentina/Cordoba
    {  330,  441,   75133,  5, }, // America/Argentina/Jujuy
    {  330, 7462,   75138,  8, }, // America/Argentina/La_Rioja
    {  330,  565,   75146,  7, }, // America/Argentina/Mendoza
    {  330, 7489,   75153, 12, }, // America/Argentina/Rio_Gallegos
    {  330, 7520,   75165,  5, }, // America/Argentina/Salta
    {  330, 7544,   75170,  9, }, // America/Argentina/San_Juan
    {  330, 5580,   75179,  9, }, // America/Argentina/San_Luis
    {  330, 7571,   75188,  8, }, // America/Argentina/Tucuman
    {  330, 7597,   75196,  6, }, // America/Argentina/Ushuaia
    {  330, 5640,   75202,  5, }, // America/Aruba
    {  330, 4252,   75207,  9, }, // America/Asuncion
    {  330,  237,   75216,  9, }, // America/Atikokan
    {  330, 3679,   75225,  4, }, // America/Bahia
    {  330, 7623,   75229, 15, }, // America/Bahia_Banderas
    {  330, 5654,   75244,  9, }, // America/Barbados
    {  330, 7646,   75253,  6, }, // America/Belem
    {  330, 5407,   75259,  6, }, // America/Belize
    {  330, 7660,   75265, 12, }, // America/Blanc-Sablon
    {  330, 7681,   75277,  9, }, // America/Boa_Vista
    {  330, 4361,   75286,  6, }, // America/Bogota
    {  330, 7699,   75292,  5, }, // America/Boise
    {  330, 7713,   75297, 11, }, // America/Cambridge_Bay
    {  330, 7735,   75308, 12, }, // America/Campo_Grande
    {  330, 3868,   75320,  7, }, // America/Cancun
    {  330, 4694,   75327,  8, }, // America/Caracas
    {  330, 4345,   75335,  6, }, // America/Cayenne
    {  330, 5496,   75341,  7, }, // America/Cayman
    {  330, 2260,   75348,  6, }, // America/Chicago
    {  330, 7756,   75354,  8, }, // America/Chihuahua
    {  330, 7774,   75362, 14, }, // America/Ciudad_Juarez
    {  330, 5422,   75376, 10, }, // America/Costa_Rica
    {  330, 7796,   75386,  8, }, // America/Creston
    {  330, 3791,   75394,  6, }, // America/Cuiaba
    {  330, 5723,   75400,  8, }, // America/Curacao
    {  330, 7812,   75408, 12, }, // America/Danmarkshavn
    {  330, 7833,   75420,  7, }, // America/Dawson
    {  330, 7848,   75427, 12, }, // America/Dawson_Creek
    {  330,  805,   75439,  7, }, // America/Denver
    {  330, 3465,   75446,  8, }, // America/Detroit
    {  330, 5739,   75454,  8, }, // America/Dominica
    {  330,  893,   75462,  9, }, // America/Edmonton
    {  330, 7869,   75471,  8, }, // America/Eirunepe
    {  330, 5441,   75479,  9, }, // America/El_Salvador
    {  330, 7886,   75488, 12, }, // America/Fort_Nelson
    {  330, 7906,   75500,  9, }, // America/Fortaleza
    {  330, 7924,   75509,  9, }, // America/Glace_Bay
    {  330, 6881,   75518,  7, }, // America/Goose_Bay
    {  330, 4612,   75525, 11, }, // America/Grand_Turk
    {  330, 5770,   75536,  7, }, // America/Grenada
    {  330, 5786,   75543,  9, }, // America/Guadeloupe
    {  330, 3760,   75552,  9, }, // America/Guatemala
    {  330, 4841,   75561,  9, }, // America/Guayaquil
    {  330, 6932,   75570,  6, }, // America/Guyana
    {  330, 1939,   75576,  9, }, // America/Halifax
    {  330, 2281,   75585,  6, }, // America/Havana
    {  330, 7942,   75591,  9, }, // America/Hermosillo
    {  330,  348,   75600, 13, }, // America/Indiana/Indianapolis
    {  330,  481,   75613, 14, }, // America/Indiana/Knox
    {  330, 7961,   75627, 16, }, // America/Indiana/Marengo
    {  330, 7985,   75643, 20, }, // America/Indiana/Petersburg
    {  330, 8012,   75663, 17, }, // America/Indiana/Tell_City
    {  330, 8038,   75680, 14, }, // America/Indiana/Vevay
    {  330, 8060,   75694, 16, }, // America/Indiana/Vincennes
    {  330, 8086,   75710, 17, }, // America/Indiana/Winamac
    {  330, 8110,   75727,  7, }, // America/Inuvik
    {  330,  660,   75734,  8, }, // America/Iqaluit
    {  330, 2799,   75742,  7, }, // America/Jamaica
    {  330, 5380,   75749,  4, }, // America/Juneau
    {  330,  521,   75753,  8, }, // America/Kentucky/Louisville
    {  330, 8125,   75761, 18, }, // America/Kentucky/Monticello
    {  330, 5704,   75779, 11, }, // America/Kralendijk
    {  330, 4376,   75790,  7, }, // America/La_Paz
    {  330, 7169,   75797,  4, }, // America/Lima
    {  330, 3239,   75801, 12, }, // America/Los_Angeles
    {  330, 5932,   75813, 19, }, // America/Lower_Princes
    {  330, 8153,   75832,  6, }, // America/Maceio
    {  330, 8168,   75838,  7, }, // America/Managua
    {  330, 1908,   75845,  7, }, // America/Manaus
    {  330, 5897,   75852,  6, }, // America/Marigot
    {  330, 5805,   75858,  9, }, // America/Martinique
    {  330, 8184,   75867, 10, }, // America/Matamoros
    {  330, 2917,   75877,  9, }, // America/Mazatlan
    {  330, 8202,   75886,  8, }, // America/Menominee
    {  330, 8220,   75894,  6, }, // America/Merida
    {  330, 8235,   75900, 10, }, // America/Metlakatla
    {  330, 2949,   75910,  6, }, // America/Mexico_City
    {  330, 4391,   75916,  8, }, // America/Miquelon
    {  330, 8254,   75924,  8, }, // America/Moncton
    {  330, 8270,   75932,  8, }, // America/Monterrey
    {  330, 4098,   75940, 10, }, // America/Montevideo
    {  330, 5824,   75950,  9, }, // America/Montserrat
    {  330, 5481,   75959,  5, }, // America/Nassau
    {  330, 2379,   75964,  9, }, // America/New_York
    {  330, 8288,   75888,  4, }, // America/Nome
    {  330, 1850,   75973,  7, }, // America/Noronha
    {  330, 8301,   75980, 23, }, // America/North_Dakota/Beulah
    {  330, 8329,   76003, 24, }, // America/North_Dakota/Center
    {  330, 8357,   76027, 28, }, // America/North_Dakota/New_Salem
    {  330,  393,   76055,  7, }, // America/Nuuk
    {  330, 8388,   76062,  7, }, // America/Ojinaga
    {  330, 2356,   76069,  6, }, // America/Panama
    {  330, 6173,   76075, 10, }, // America/Paramaribo
    {  330, 2973,   76085,  7, }, // America/Phoenix
    {  330, 3945,   76092, 13, }, // America/Port-au-Prince
    {  330, 5954,   76105, 14, }, // America/Port_of_Spain
    {  330, 8404,   76119, 11, }, // America/Porto_Velho
    {  330, 5843,   76130, 11, }, // America/Puerto_Rico
    {  330, 4030,   76141, 13, }, // America/Punta_Arenas
    {  330, 8424,   76154, 13, }, // America/Rankin_Inlet
    {  330, 8445,   76167,  6, }, // America/Recife
    {  330, 1995,   76173,  6, }, // America/Regina
    {  330, 8460,   76179,  8, }, // America/Resolute
    {  330,  695,   76187, 10, }, // America/Rio_Branco
    {  330, 8477,   76197,  9, }, // America/Santarem
    {  330, 2201,   76206,  8, }, // America/Santiago
    {  330, 6111,   76214, 13, }, // America/Santo_Domingo
    {  330, 1878,   76227,  9, }, // America/Sao_Paulo
    {  330, 6899,   76236, 12, }, // America/Scoresbysund
    {  330, 8494,   76248,  5, }, // America/Sitka
    {  330, 8508,   76253, 13, }, // America/St_Barthelemy
    {  330, 2061,   76266, 10, }, // America/St_Johns
    {  330, 5863,   76276, 10, }, // America/St_Kitts
    {  330, 5880,   76286, 10, }, // America/St_Lucia
    {  330,  855,   76296, 10, }, // America/St_Thomas
    {  330, 5913,   76306, 12, }, // America/St_Vincent
    {  330, 8530,   76318, 13, }, // America/Swift_Current
    {  330, 5461,   76331, 11, }, // America/Tegucigalpa
    {  330, 5756,   76342,  4, }, // America/Thule
    {  330,  313,   76346,  7, }, // America/Tijuana
    {  330,  608,   76353,  7, }, // America/Toronto
    {  330, 5688,   76360,  7, }, // America/Tortola
    {  330, 2093,   76367,  9, }, // America/Vancouver
    {  330, 2144,   76376,  9, }, // America/Whitehorse
    {  330,  734,   76385,  8, }, // America/Winnipeg
    {  330, 8552,   76393,  8, }, // America/Yakutat
    {  330, 6001,   76401,  5, }, // Antarctica/Casey
    {  330, 6094,   76406,  6, }, // Antarctica/Davis
    {  330, 6133,   76412, 15, }, // Antarctica/DumontDUrville
    {  330, 8568,   76427,  7, }, // Antarctica/Macquarie
    {  330, 7066,   76434,  7, }, // Antarctica/Mawson
    {  330, 7113,   76441,  8, }, // Antarctica/McMurdo
    {  330, 8589,   76449,  7, }, // Antarctica/Palmer
    {  330, 7226,   76456,  6, }, // Antarctica/Rothera
    {  330, 7295,   76462,  5, }, // Antarctica/Syowa
    {  330, 8607,   76467,  5, }, // Antarctica/Troll
    {  330, 7374,   76472,  7, }, // Antarctica/Vostok
    {  330, 1429,   76479, 11, }, // Arctic/Longyearbyen
    {  330, 5570,   76490,  5, }, // Asia/Aden
    {  330, 5395,   76495,  6, }, // Asia/Almaty
    {  330, 3968,   76501,  5, }, // Asia/Amman
    {  330, 5511,   76506,  7, }, // Asia/Anadyr
    {  330, 5523,   76513,  5, }, // Asia/Aqtau
    {  330, 5368,   76518,  6, }, // Asia/Aqtobe
    {  330,  964,   76524,  8, }, // Asia/Ashgabat
    {  330, 8624,   76532,  6, }, // Asia/Atyrau
    {  330, 3607,   76538,  7, }, // Asia/Baghdad
    {  330, 5534,   76545,  8, }, // Asia/Bahrain
    {  330, 3653,   76553,  4, }, // Asia/Baku
    {  330, 4466,   76557,  8, }, // Asia/Bangkok
    {  330, 3571,   76565,  8, }, // Asia/Barnaul
    {  330, 4086,   76573,  7, }, // Asia/Beirut
    {  330, 3778,   76580,  7, }, // Asia/Bishkek
    {  330, 5989,   76587,  6, }, // Asia/Brunei
    {  330, 4601,   76593,  4, }, // Asia/Chita
    {  330, 4511,   76597,  7, }, // Asia/Colombo
    {  330, 4540,   76604,  7, }, // Asia/Damascus
    {  330, 1093,   74808,  4, }, // Asia/Dhaka
    {  330, 6192,   76611,  4, }, // Asia/Dili
    {  330, 3596,   76615,  5, }, // Asia/Dubai
    {  330, 6159,   76620,  7, }, // Asia/Dushanbe
    {  330, 8636,   76627,  9, }, // Asia/Famagusta
    {  330, 8651,   76636,  4, }, // Asia/Gaza
    {  330, 4795,   76640,  7, }, // Asia/Hebron
    {  330, 1259,   76647,  8, }, // Asia/Ho_Chi_Minh
    {  330, 2704,   76655,  8, }, // Asia/Hong_Kong
    {  330, 4771,   76663,  5, }, // Asia/Hovd
    {  330, 4184,   76668,  8, }, // Asia/Irkutsk
    {  330, 7006,   76676,  7, }, // Asia/Jakarta
    {  330, 6992,   76683,  8, }, // Asia/Jayapura
    {  330, 1290,   76691, 10, }, // Asia/Jerusalem
    {  330, 3560,   76701,  6, }, // Asia/Kabul
    {  330, 4316,   76707,  8, }, // Asia/Kamchatka
    {  330, 4239,   76715,  6, }, // Asia/Karachi
    {  330, 1185,   76721,  8, }, // Asia/Kathmandu
    {  330, 8661,   76729,  7, }, // Asia/Khandyga
    {  330,  992,   76736,  7, }, // Asia/Kolkata
    {  330, 4197,   76743, 12, }, // Asia/Krasnoyarsk
    {  330, 4859,   76755, 13, }, // Asia/Kuala_Lumpur
    {  330, 5976,   76768,  7, }, // Asia/Kuching
    {  330, 5547,   76775,  7, }, // Asia/Kuwait
    {  330, 1211,   76782,  5, }, // Asia/Macau
    {  330, 4017,   76787,  8, }, // Asia/Magadan
    {  330, 1349,   76795,  8, }, // Asia/Makassar
    {  330, 7182,   76803,  6, }, // Asia/Manila
    {  330, 6920,   76809,  7, }, // Asia/Muscat
    {  330, 2554,   76816,  7, }, // Asia/Nicosia
    {  330, 8675,   76823, 12, }, // Asia/Novokuznetsk
    {  330, 4135,   76835, 12, }, // Asia/Novosibirsk
    {  330, 4229,   76847,  5, }, // Asia/Omsk
    {  330, 7145,   76852,  5, }, // Asia/Oral
    {  330, 6961,   76857,  8, }, // Asia/Phnom_Penh
    {  330, 8693,   76865, 10, }, // Asia/Pontianak
    {  330, 4214,   76875,  8, }, // Asia/Pyongyang
    {  330, 5559,   76883,  6, }, // Asia/Qatar
    {  330, 8708,   76889,  8, }, // Asia/Qostanay
    {  330, 4269,   76897,  9, }, // Asia/Qyzylorda
    {  330, 3584,   76906,  8, }, // Asia/Riyadh
    {  330, 4408,   76914,  8, }, // Asia/Sakhalin
    {  330, 7245,   76922, 10, }, // Asia/Samarkand
    {  330, 3279,   76932,  5, }, // Asia/Seoul
    {  330, 1053,   76937,  6, }, // Asia/Shanghai
    {  330, 3300,   76943,  9, }, // Asia/Singapore
    {  330, 4297,   76952, 14, }, // Asia/Srednekolymsk
    {  330, 3263,   76966,  6, }, // Asia/Taipei
    {  330, 4781,   76972,  8, }, // Asia/Tashkent
    {  330, 3915,   76980,  7, }, // Asia/Tbilisi
    {  330, 2772,   76987,  7, }, // Asia/Tehran
    {  330, 1317,   76994,  7, }, // Asia/Thimphu
    {  330, 2821,   77001,  5, }, // Asia/Tokyo
    {  330, 4572,   77006,  6, }, // Asia/Tomsk
    {  330, 1021,   77012, 10, }, // Asia/Ulaanbaatar
    {  330, 1159,   77022,  6, }, // Asia/Urumqi
    {  330, 8722,   77028,  8, }, // Asia/Ust-Nera
    {  330, 6977,   77036,  9, }, // Asia/Vientiane
    {  330, 4710,   77045, 12, }, // Asia/Vladivostok
    {  330, 4828,   77057,  8, }, // Asia/Yakutsk
    {  330, 1235,   77065,  7, }, // Asia/Yangon
    {  330, 3883,   77072, 13, }, // Asia/Yekaterinburg
    {  330, 3747,   77085,  7, }, // Asia/Yerevan
    {  330, 3663,   77092, 16, }, // Atlantic/Azores
    {  330, 5671,   77108,  7, }, // Atlantic/Bermuda
    {  330, 6628,   77115,  6, }, // Atlantic/Canary
    {  330, 3727,   77121, 10, }, // Atlantic/Cape_Verde
    {  330, 1395,   77131, 17, }, // Atlantic/Faroe
    {  330, 8736,   77148,  7, }, // Atlantic/Madeira
    {  330, 2748,   77155, 10, }, // Atlantic/Reykjavik
    {  330, 7272,   77165, 14, }, // Atlantic/South_Georgia
    {  330, 6821,   77179, 18, }, // Atlantic/St_Helena
    {  330, 6644,   77197,  6, }, // Atlantic/Stanley
    {  330, 1670,   77203,  8, }, // Australia/Adelaide
    {  330, 1635,   77211,  9, }, // Australia/Brisbane
    {  330, 1799,   77220, 12, }, // Australia/Broken_Hill
    {  330, 1583,   77232,  7, }, // Australia/Darwin
    {  330, 3637,   77239,  5, }, // Australia/Eucla
    {  330, 1516,   77244,  7, }, // Australia/Hobart
    {  330, 8753,   77251,  8, }, // Australia/Lindeman
    {  330, 1547,   77259,  9, }, // Australia/Lord_Howe
    {  330, 1727,   77268,  8, }, // Australia/Melbourne
    {  330, 1762,   77276,  5, }, // Australia/Perth
    {  330, 1463,   77281,  6, }, // Australia/Sydney
    {  330, 6441,   77287, 10, }, // Europe/Amsterdam
    {  330, 6216,   77297,  6, }, // Europe/Andorra
    {  330, 3620,   77303,  9, }, // Europe/Astrakhan
    {  330, 2300,   77312,  5, }, // Europe/Athens
    {  330, 6336,   77317,  8, }, // Europe/Belgrade
    {  330, 4757,   77325,  7, }, // Europe/Berlin
    {  330, 6488,   77332, 10, }, // Europe/Bratislava
    {  330, 2167,   77342,  8, }, // Europe/Brussels
    {  330, 3928,   77350,  9, }, // Europe/Bucharest
    {  330, 3806,   77359,  9, }, // Europe/Budapest
    {  330, 8772,   77368,  9, }, // Europe/Busingen
    {  330, 2583,   77377,  9, }, // Europe/Chisinau
    {  330, 6289,   77386, 11, }, // Europe/Copenhagen
    {  330, 2338,   77397,  7, }, // Europe/Dublin
    {  330, 6307,   77404, 10, }, // Europe/Gibraltar
    {  330, 8788,   77414,  6, }, // Europe/Guernsey
    {  330, 6612,   77420,  8, }, // Europe/Helsinki
    {  330, 8804,   77428, 13, }, // Europe/Isle_of_Man
    {  330, 1130,   77441,  8, }, // Europe/Istanbul
    {  330, 8823,   77449,  5, }, // Europe/Jersey
    {  330, 3979,   77454, 12, }, // Europe/Kaliningrad
    {  330, 8929,   77466,  6, }, // Europe/Kirov
    {  330, 2527,   77472,  5, }, // Europe/Kyiv
    {  330, 3213,   77477,  8, }, // Europe/Lisbon
    {  330, 6506,   77485,  9, }, // Europe/Ljubljana
    {  330, 2501,   77494,  7, }, // Europe/London
    {  330, 6365,   77501, 11, }, // Europe/Luxembourg
    {  330, 4892,   77512,  7, }, // Europe/Madrid
    {  330, 6397,   77519,  5, }, // Europe/Malta
    {  330, 6582,   77524,  9, }, // Europe/Mariehamn
    {  330, 3693,   77533,  6, }, // Europe/Minsk
    {  330, 6410,   77539,  6, }, // Europe/Monaco
    {  330, 3537,   77545,  7, }, // Europe/Moscow
    {  330, 6458,   77552,  4, }, // Europe/Oslo
    {  330, 4284,   77556,  6, }, // Europe/Paris
    {  330, 6424,   77562,  9, }, // Europe/Podgorica
    {  330, 6275,   77571,  5, }, // Europe/Prague
    {  330, 8837,   77576,  4, }, // Europe/Riga
    {  330, 6324,   77580,  4, }, // Europe/Rome
    {  330, 4331,   77584,  6, }, // Europe/Samara
    {  330, 6470,   77590, 10, }, // Europe/San_Marino
    {  330, 6245,   77600,  7, }, // Europe/Sarajevo
    {  330, 4451,   77607,  8, }, // Europe/Saratov
    {  330, 8849,   77615, 11, }, // Europe/Simferopol
    {  330, 6383,   77626,  6, }, // Europe/Skopje
    {  330, 6599,   77632,  5, }, // Europe/Sofia
    {  330, 6523,   77637,  9, }, // Europe/Stockholm
    {  330, 8867,   77646,  6, }, // Europe/Tallinn
    {  330, 6202,   77652,  6, }, // Europe/Tirane
    {  330, 8882,   77658, 10, }, // Europe/Ulyanovsk
    {  330, 6352,   77668,  6, }, // Europe/Vaduz
    {  330, 6567,   77674,  8, }, // Europe/Vatican
    {  330, 6231,   77682,  4, }, // Europe/Vienna
    {  330, 8899,   77686,  8, }, // Europe/Vilnius
    {  330, 4727,   77694, 10, }, // Europe/Volgograd
    {  330, 3190,   77704,  7, }, // Europe/Warsaw
    {  330, 6261,   77711,  7, }, // Europe/Zagreb
    {  330, 6540,   77718,  7, }, // Europe/Zurich
    {  330, 5078,   77725, 12, }, // Indian/Antananarivo
    {  330, 6947,   77737,  6, }, // Indian/Chagos
    {  330, 6046,   77743, 13, }, // Indian/Christmas
    {  330, 6063,   77756,  6, }, // Indian/Cocos
    {  330, 5029,   77762,  6, }, // Indian/Comoro
    {  330, 6661,   77768,  9, }, // Indian/Kerguelen
    {  330, 7260,   77777,  4, }, // Indian/Mahe
    {  330, 7050,   77781,  9, }, // Indian/Maldives
    {  330, 4069,   77790,  7, }, // Indian/Mauritius
    {  330, 5098,   77797,  6, }, // Indian/Mayotte
    {  330, 7211,   77803,  9, }, // Indian/Reunion
    {  330, 4422,   77812,  4, }, // Pacific/Apia
    {  330,  932,   77816,  7, }, // Pacific/Auckland
    {  330, 3706,   77823,  9, }, // Pacific/Bougainville
    {  330, 3015,   77832,  6, }, // Pacific/Chatham
    {  330, 3157,   77838,  5, }, // Pacific/Chuuk
    {  330, 2237,   77843,  6, }, // Pacific/Easter
    {  330, 7360,   77849,  5, }, // Pacific/Efate
    {  330, 7327,   77854,  7, }, // Pacific/Fakaofo
    {  330, 3902,   77861,  4, }, // Pacific/Fiji
    {  330, 7343,   77865,  8, }, // Pacific/Funafuti
    {  330, 6678,   77873, 10, }, // Pacific/Galapagos
    {  330, 6696,   77883,  8, }, // Pacific/Gambier
    {  330, 3822,   77891, 12, }, // Pacific/Guadalcanal
    {  330, 6018,   77903,  5, }, // Pacific/Guam
    {  330, 2723,   77908,  8, }, // Pacific/Honolulu
    {  330, 3049,   77916,  9, }, // Pacific/Kanton
    {  330, 3998,   77925, 10, }, // Pacific/Kiritimati
    {  330, 7019,   77935,  6, }, // Pacific/Kosrae
    {  330, 2842,   77941, 10, }, // Pacific/Kwajalein
    {  330, 4877,   77951,  6, }, // Pacific/Majuro
    {  330, 4051,   77957,  9, }, // Pacific/Marquesas
    {  330, 8914,   77966,  6, }, // Pacific/Midway
    {  330, 7084,   77972,  5, }, // Pacific/Nauru
    {  330, 7132,   77977,  4, }, // Pacific/Niue
    {  330, 4168,   77981,  8, }, // Pacific/Norfolk
    {  330, 7098,   77989,  5, }, // Pacific/Noumea
    {  330, 3126,   77994,  9, }, // Pacific/Pago_Pago
    {  330, 7155,   78003,  5, }, // Pacific/Palau
    {  330, 7194,   78008,  8, }, // Pacific/Pitcairn
    {  330, 3096,   78016,  6, }, // Pacific/Pohnpei
    {  330, 4807,   78022, 11, }, // Pacific/Port_Moresby
    {  330, 6076,   78033,  9, }, // Pacific/Rarotonga
    {  330, 6031,   78042,  7, }, // Pacific/Saipan
    {  330, 7312,   78049,  5, }, // Pacific/Tahiti
    {  330, 6712,   78054,  6, }, // Pacific/Tarawa
    {  330, 4583,   78060,  9, }, // Pacific/Tongatapu
    {  330, 7392,   78069,  5, }, // Pacific/Wake
    {  330, 7405,   78074,  6, }, // Pacific/Wallis
    {  331, 5059,    3902, 11, }, // Africa/Addis_Ababa German/Latin/Germany
    {  331, 7420,   58555,  6, }, // Africa/Algiers
    {  331,   14,       0,  6, }, // Africa/Asmara
    {  331, 2320,    4690,  5, }, // Africa/Cairo
    {  331, 5130,   78080, 10, }, // Africa/Dar_es_Salaam
    {  331, 5043,   78090,  9, }, // Africa/Djibouti
    {  331, 5166,   63491,  8, }, // Africa/El_Aaiun
    {  331, 4524,   26504,  7, }, // Africa/Khartoum
    {  331, 6869,   20418,  4, }, // Africa/Lome
    {  331, 5113,   78099, 10, }, // Africa/Mogadishu
    {  331, 5271,   44128,  9, }, // Africa/Ndjamena
    {  331, 5225,   26542, 10, }, // Africa/Porto-Novo
    {  331, 4435,       6,  8, }, // Africa/Sao_Tome
    {  331, 2866,   57756,  8, }, // Africa/Tripoli
    {  331,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  331, 4252,      14,  8, }, // America/Asuncion
    {  331,  237,      22,  8, }, // America/Atikokan
    {  331, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  331, 4361,   20507,  6, }, // America/Bogota
    {  331, 3868,      47,  6, }, // America/Cancun
    {  331, 5496,   78109, 12, }, // America/Cayman
    {  331, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  331, 5723,      66,  7, }, // America/Curacao
    {  331, 2281,   63505,  7, }, // America/Havana
    {  331,  481,      73, 13, }, // America/Indiana/Knox
    {  331, 7961,      86, 16, }, // America/Indiana/Marengo
    {  331, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  331, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  331, 8038,     139, 14, }, // America/Indiana/Vevay
    {  331, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  331, 8086,     171, 16, }, // America/Indiana/Winamac
    {  331, 2799,    3995,  7, }, // America/Jamaica
    {  331, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  331, 5932,     207, 22, }, // America/Lower_Princes
    {  331, 8220,    7126,  6, }, // America/Merida
    {  331, 2949,   78121, 12, }, // America/Mexico_City
    {  331, 1850,     235, 19, }, // America/Noronha
    {  331, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  331, 8329,     274, 20, }, // America/North_Dakota/Center
    {  331, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  331,  393,     317,  4, }, // America/Nuuk
    {  331, 1878,   26712,  9, }, // America/Sao_Paulo
    {  331, 6899,     321, 16, }, // America/Scoresbysund
    {  331, 8508,   26721, 16, }, // America/St_Barthelemy
    {  331, 2061,     351, 10, }, // America/St_Johns
    {  331, 5863,     361,  9, }, // America/St_Kitts
    {  331, 5880,     370,  9, }, // America/St_Lucia
    {  331,  855,     379, 10, }, // America/St_Thomas
    {  331, 5913,     389, 11, }, // America/St_Vincent
    {  331, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  331, 7374,    4147,  6, }, // Antarctica/Vostok
    {  331, 5368,    7606,  6, }, // Asia/Aqtobe
    {  331,  964,   44322,  7, }, // Asia/Ashgabat
    {  331, 3607,    4162,  6, }, // Asia/Baghdad
    {  331, 3778,   57220,  8, }, // Asia/Bishkek
    {  331, 5989,   78133, 17, }, // Asia/Brunei
    {  331, 4601,   78150,  7, }, // Asia/Chita
    {  331, 4540,    4201,  8, }, // Asia/Damascus
    {  331, 6159,   57228,  9, }, // Asia/Dushanbe
    {  331, 1259,   78157, 17, }, // Asia/Ho_Chi_Minh
    {  331, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  331, 4771,   78174,  5, }, // Asia/Hovd
    {  331, 4316,   78179, 11, }, // Asia/Kamchatka
    {  331, 4239,   78190,  9, }, // Asia/Karachi
    {  331, 1185,     448,  9, }, // Asia/Kathmandu
    {  331, 8661,   58020,  8, }, // Asia/Khandyga
    {  331,  992,   64334,  8, }, // Asia/Kolkata
    {  331, 4197,    4288, 11, }, // Asia/Krasnoyarsk
    {  331, 1211,    4321,  5, }, // Asia/Macau
    {  331, 6920,   26882,  6, }, // Asia/Muscat
    {  331, 2554,    5738,  7, }, // Asia/Nicosia
    {  331, 8675,   78199, 12, }, // Asia/Novokuznetsk
    {  331, 4135,   78211, 11, }, // Asia/Novosibirsk
    {  331, 4214,   78222,  9, }, // Asia/Pyongyang
    {  331, 5559,    4332,  5, }, // Asia/Qatar
    {  331, 8708,   44391,  8, }, // Asia/Qostanay
    {  331, 4269,   57300,  9, }, // Asia/Qyzylorda
    {  331, 3584,    7787,  4, }, // Asia/Riyadh
    {  331, 4408,   58084,  8, }, // Asia/Sakhalin
    {  331, 3300,   20900,  8, }, // Asia/Singapore
    {  331, 3263,   78231,  6, }, // Asia/Taipei
    {  331, 4781,   57328,  9, }, // Asia/Tashkent
    {  331, 3915,   78237,  6, }, // Asia/Tbilisi
    {  331, 2772,    7842,  7, }, // Asia/Tehran
    {  331, 2821,    4356,  5, }, // Asia/Tokyo
    {  331, 1159,   26933,  6, }, // Asia/Urumqi
    {  331, 4710,    4361, 11, }, // Asia/Vladivostok
    {  331, 4828,    7873,  7, }, // Asia/Yakutsk
    {  331, 1235,    7880,  6, }, // Asia/Yangon
    {  331, 3883,    4380, 13, }, // Asia/Yekaterinburg
    {  331, 3747,   57360,  6, }, // Asia/Yerevan
    {  331, 3663,   58841,  6, }, // Atlantic/Azores
    {  331, 6628,   78243,  7, }, // Atlantic/Canary
    {  331, 3727,   26968, 10, }, // Atlantic/Cape_Verde
    {  331, 1395,   78250,  6, }, // Atlantic/Faroe
    {  331, 2748,   78256, 11, }, // Atlantic/Reykjavik
    {  331, 7272,   78267, 11, }, // Atlantic/South_Georgia
    {  331, 6821,     488, 10, }, // Atlantic/St_Helena
    {  331, 3620,   78278,  9, }, // Europe/Astrakhan
    {  331, 2300,    4438,  5, }, // Europe/Athens
    {  331, 6336,   27015,  7, }, // Europe/Belgrade
    {  331, 2167,   22766,  7, }, // Europe/Brussels
    {  331, 3928,   27029,  8, }, // Europe/Bucharest
    {  331, 8772,   27037,  8, }, // Europe/Busingen
    {  331, 6289,    4475, 10, }, // Europe/Copenhagen
    {  331, 8929,   78287,  5, }, // Europe/Kirov
    {  331, 2527,   78292,  4, }, // Europe/Kyiv
    {  331, 3213,    4499,  8, }, // Europe/Lisbon
    {  331, 6365,    4513,  9, }, // Europe/Luxembourg
    {  331, 3537,   57485,  6, }, // Europe/Moscow
    {  331, 6275,    8201,  4, }, // Europe/Prague
    {  331, 6324,    6064,  3, }, // Europe/Rome
    {  331, 4451,   78296,  7, }, // Europe/Saratov
    {  331, 6202,   21213,  6, }, // Europe/Tirane
    {  331, 8882,   78303,  9, }, // Europe/Ulyanovsk
    {  331, 6567,    6096,  7, }, // Europe/Vatican
    {  331, 6231,   57515,  4, }, // Europe/Vienna
    {  331, 4727,    4561,  9, }, // Europe/Volgograd
    {  331, 3190,   57528,  8, }, // Europe/Warsaw
    {  331, 6540,    4577,  6, }, // Europe/Zurich
    {  331, 6046,   78312, 15, }, // Indian/Christmas
    {  331, 5029,   78327,  7, }, // Indian/Comoro
    {  331, 7050,   78334,  9, }, // Indian/Maldives
    {  331, 7211,     547,  7, }, // Indian/Reunion
    {  331, 3157,     554,  5, }, // Pacific/Chuuk
    {  331, 2237,   78343, 10, }, // Pacific/Easter
    {  331, 3902,   78353,  7, }, // Pacific/Fiji
    {  331, 2723,    4611,  8, }, // Pacific/Honolulu
    {  331, 3049,    4619,  9, }, // Pacific/Kanton
    {  331, 3096,     586,  7, }, // Pacific/Pohnpei
    {  337, 5989,   78133,  6, }, // Asia/Brunei German/Latin/Switzerland
    {  337, 1211,     464,  5, }, // Asia/Macau
    {  337, 4451,   78360,  7, }, // Europe/Saratov
    {  338, 6788,   78367,  8, }, // Africa/Abidjan Greek/Greek/Greece
    {  338, 6760,   78375,  4, }, // Africa/Accra
    {  338, 5059,   78379, 13, }, // Africa/Addis_Ababa
    {  338, 7420,   78392,  6, }, // Africa/Algiers
    {  338,   14,   78398,  6, }, // Africa/Asmara
    {  338,   44,   78404,  7, }, // Africa/Bamako
    {  338, 5257,   78411,  7, }, // Africa/Bangui
    {  338, 6746,   78418,  8, }, // Africa/Banjul
    {  338, 7435,   78426,  7, }, // Africa/Bissau
    {  338, 4957,   78433,  9, }, // Africa/Blantyre
    {  338, 5287,   78442,  9, }, // Africa/Brazzaville
    {  338, 4922,   78451, 13, }, // Africa/Bujumbura
    {  338, 2320,   78464,  5, }, // Africa/Cairo
    {  338, 4117,   78469, 11, }, // Africa/Casablanca
    {  338, 7449,   78480,  6, }, // Africa/Ceuta
    {  338, 6773,   78486,  7, }, // Africa/Conakry
    {  338, 6840,   78493,  6, }, // Africa/Dakar
    {  338, 5130,   78499, 13, }, // Africa/Dar_es_Salaam
    {  338, 5043,   78512,  9, }, // Africa/Djibouti
    {  338, 5243,   78521,  7, }, // Africa/Douala
    {  338, 5166,   78528,  9, }, // Africa/El_Aaiun
    {  338, 6853,   78537,  8, }, // Africa/Freetown
    {  338, 4906,   78545, 10, }, // Africa/Gaborone
    {  338, 5015,   78555,  6, }, // Africa/Harare
    {  338, 4479,   78561, 15, }, // Africa/Johannesburg
    {  338, 4499,   78576,  7, }, // Africa/Juba
    {  338, 5151,   78583,  7, }, // Africa/Kampala
    {  338, 4524,   78590,  7, }, // Africa/Khartoum
    {  338, 4973,   78597,  7, }, // Africa/Kigali
    {  338, 5306,   78604,  7, }, // Africa/Kinshasa
    {  338, 4744,   78611,  6, }, // Africa/Lagos
    {  338, 5336,   78617,  9, }, // Africa/Libreville
    {  338, 6869,   78626,  4, }, // Africa/Lome
    {  338, 5211,   78630,  7, }, // Africa/Luanda
    {  338, 4939,   78637, 12, }, // Africa/Lubumbashi
    {  338, 5001,   78649,  7, }, // Africa/Lusaka
    {  338, 5322,   78656,  7, }, // Africa/Malabo
    {  338, 4987,   78663,  7, }, // Africa/Maputo
    {  338, 5197,   78670,  7, }, // Africa/Maseru
    {  338, 5182,   78677,  8, }, // Africa/Mbabane
    {  338, 5113,   78685, 11, }, // Africa/Mogadishu
    {  338, 7034,   78696,  8, }, // Africa/Monrovia
    {  338, 3853,   78704,  8, }, // Africa/Nairobi
    {  338, 5271,   78712,  8, }, // Africa/Ndjamena
    {  338, 5354,   78720,  6, }, // Africa/Niamey
    {  338, 6803,   78726,  8, }, // Africa/Nouakchott
    {  338, 6727,   78734, 14, }, // Africa/Ouagadougou
    {  338, 5225,   78748, 10, }, // Africa/Porto-Novo
    {  338, 4435,   78758,  8, }, // Africa/Sao_Tome
    {  338, 2866,   78766,  7, }, // Africa/Tripoli
    {  338, 6554,   78773,  6, }, // Africa/Tunis
    {  338, 4152,   78779,  8, }, // Africa/Windhoek
    {  338,  132,   78787,  5, }, // America/Adak
    {  338, 3346,   78792,  8, }, // America/Anchorage
    {  338, 5607,   78800,  9, }, // America/Anguilla
    {  338, 5624,   78809,  9, }, // America/Antigua
    {  338, 4554,   78818, 11, }, // America/Araguaina
    {  338,  166,   78829, 14, }, // America/Argentina/Buenos_Aires
    {  338,   91,   78843,  9, }, // America/Argentina/Catamarca
    {  338,  270,   78852,  7, }, // America/Argentina/Cordoba
    {  338,  441,   78859,  7, }, // America/Argentina/Jujuy
    {  338, 7462,   78866,  8, }, // America/Argentina/La_Rioja
    {  338,  565,   78874,  7, }, // America/Argentina/Mendoza
    {  338, 7489,   78881, 14, }, // America/Argentina/Rio_Gallegos
    {  338, 7520,   78895,  5, }, // America/Argentina/Salta
    {  338, 7544,   78900,  9, }, // America/Argentina/San_Juan
    {  338, 5580,   78909,  9, }, // America/Argentina/San_Luis
    {  338, 7571,   78918,  9, }, // America/Argentina/Tucuman
    {  338, 7597,   78927,  8, }, // America/Argentina/Ushuaia
    {  338, 5640,   78935,  7, }, // America/Aruba
    {  338, 4252,   78942,  9, }, // America/Asuncion
    {  338,  237,   78951,  8, }, // America/Atikokan
    {  338, 3679,   78959,  5, }, // America/Bahia
    {  338, 7623,   78964, 19, }, // America/Bahia_Banderas
    {  338, 5654,   78983, 12, }, // America/Barbados
    {  338, 7646,   78995,  6, }, // America/Belem
    {  338, 5407,   79001,  6, }, // America/Belize
    {  338, 7660,   79007, 13, }, // America/Blanc-Sablon
    {  338, 7681,   79020, 10, }, // America/Boa_Vista
    {  338, 4361,   79030,  8, }, // America/Bogota
    {  338, 7699,   79038,  6, }, // America/Boise
    {  338, 7713,   79044, 13, }, // America/Cambridge_Bay
    {  338, 7735,   79057, 13, }, // America/Campo_Grande
    {  338, 3868,   79070,  7, }, // America/Cancun
    {  338, 4694,   79077,  7, }, // America/Caracas
    {  338, 4345,   79084,  6, }, // America/Cayenne
    {  338, 5496,   79090,  6, }, // America/Cayman
    {  338, 2260,   79096,  6, }, // America/Chicago
    {  338, 7756,   79102,  9, }, // America/Chihuahua
    {  338, 7774,   79111, 15, }, // America/Ciudad_Juarez
    {  338, 5422,   79126, 10, }, // America/Costa_Rica
    {  338, 7796,   79136,  7, }, // America/Creston
    {  338, 3791,   79143,  8, }, // America/Cuiaba
    {  338, 5723,   79151,  8, }, // America/Curacao
    {  338, 7812,   79159, 12, }, // America/Danmarkshavn
    {  338, 7833,   79171,  6, }, // America/Dawson
    {  338, 7848,   79177, 11, }, // America/Dawson_Creek
    {  338,  805,   79188,  7, }, // America/Denver
    {  338, 3465,   79195,  8, }, // America/Detroit
    {  338, 5739,   79203,  9, }, // America/Dominica
    {  338,  893,   79212,  9, }, // America/Edmonton
    {  338, 7869,   79221,  9, }, // America/Eirunepe
    {  338, 5441,   79230, 11, }, // America/El_Salvador
    {  338, 7886,   79241, 11, }, // America/Fort_Nelson
    {  338, 7906,   79252,  9, }, // America/Fortaleza
    {  338, 7924,   79261, 11, }, // America/Glace_Bay
    {  338, 6881,   79272, 10, }, // America/Goose_Bay
    {  338, 4612,   79282, 12, }, // America/Grand_Turk
    {  338, 5770,   79294,  7, }, // America/Grenada
    {  338, 5786,   79301, 11, }, // America/Guadeloupe
    {  338, 3760,   79312, 10, }, // America/Guatemala
    {  338, 4841,   79322, 11, }, // America/Guayaquil
    {  338, 6932,   79333,  7, }, // America/Guyana
    {  338, 1939,   79340,  7, }, // America/Halifax
    {  338, 2281,   79347,  5, }, // America/Havana
    {  338, 7942,   79352,  9, }, // America/Hermosillo
    {  338,  348,   79361, 12, }, // America/Indiana/Indianapolis
    {  338,  481,   79373, 12, }, // America/Indiana/Knox
    {  338, 7961,   79385, 17, }, // America/Indiana/Marengo
    {  338, 7985,   79402, 21, }, // America/Indiana/Petersburg
    {  338, 8012,   79423, 17, }, // America/Indiana/Tell_City
    {  338, 8038,   79440, 14, }, // America/Indiana/Vevay
    {  338, 8060,   79454, 15, }, // America/Indiana/Vincennes
    {  338, 8086,   79469, 18, }, // America/Indiana/Winamac
    {  338, 8110,   79487,  7, }, // America/Inuvik
    {  338,  660,   79494,  8, }, // America/Iqaluit
    {  338, 2799,   79502,  8, }, // America/Jamaica
    {  338, 5380,   79510,  6, }, // America/Juneau
    {  338,  521,   79516,  7, }, // America/Kentucky/Louisville
    {  338, 8125,   79523, 19, }, // America/Kentucky/Monticello
    {  338, 5704,   79542,  9, }, // America/Kralendijk
    {  338, 4376,   79551,  6, }, // America/La_Paz
    {  338, 7169,   79557,  4, }, // America/Lima
    {  338, 3239,   79561, 12, }, // America/Los_Angeles
    {  338, 5932,     207, 22, }, // America/Lower_Princes
    {  338, 8153,   79573,  6, }, // America/Maceio
    {  338, 8168,   79579,  9, }, // America/Managua
    {  338, 1908,   79588,  7, }, // America/Manaus
    {  338, 5897,   79595,  7, }, // America/Marigot
    {  338, 5805,   79602,  9, }, // America/Martinique
    {  338, 8184,   79611,  9, }, // America/Matamoros
    {  338, 2917,   79620,  8, }, // America/Mazatlan
    {  338, 8202,   79628,  8, }, // America/Menominee
    {  338, 8220,   79636,  6, }, // America/Merida
    {  338, 8235,   79642, 10, }, // America/Metlakatla
    {  338, 2949,   79652, 16, }, // America/Mexico_City
    {  338, 4391,   79668,  7, }, // America/Miquelon
    {  338, 8254,   79675,  7, }, // America/Moncton
    {  338, 8270,   79682,  8, }, // America/Monterrey
    {  338, 4098,   79690, 10, }, // America/Montevideo
    {  338, 5824,   79700,  8, }, // America/Montserrat
    {  338, 5481,   79708,  6, }, // America/Nassau
    {  338, 2379,   79714,  9, }, // America/New_York
    {  338, 8288,   79723,  4, }, // America/Nome
    {  338, 1850,   79727,  7, }, // America/Noronha
    {  338, 8301,   79734, 23, }, // America/North_Dakota/Beulah
    {  338, 8329,   79757, 22, }, // America/North_Dakota/Center
    {  338, 8357,   79779, 27, }, // America/North_Dakota/New_Salem
    {  338,  393,   79806,  6, }, // America/Nuuk
    {  338, 8388,   79812,  8, }, // America/Ojinaga
    {  338, 2356,   79820,  7, }, // America/Panama
    {  338, 6173,   79827, 11, }, // America/Paramaribo
    {  338, 2973,   79838,  6, }, // America/Phoenix
    {  338, 3945,   79844, 12, }, // America/Port-au-Prince
    {  338, 5954,   79856, 13, }, // America/Port_of_Spain
    {  338, 8404,   79869, 11, }, // America/Porto_Velho
    {  338, 5843,   79880, 12, }, // America/Puerto_Rico
    {  338, 4030,   79892, 13, }, // America/Punta_Arenas
    {  338, 8424,   79905, 12, }, // America/Rankin_Inlet
    {  338, 8445,   79917,  6, }, // America/Recife
    {  338, 1995,   79923,  8, }, // America/Regina
    {  338, 8460,   79931,  8, }, // America/Resolute
    {  338,  695,   79939, 11, }, // America/Rio_Branco
    {  338, 8477,   79950,  8, }, // America/Santarem
    {  338, 2201,   79958,  9, }, // America/Santiago
    {  338, 6111,   79967, 15, }, // America/Santo_Domingo
    {  338, 1878,   79982,  9, }, // America/Sao_Paulo
    {  338, 6899,   79991, 14, }, // America/Scoresbysund
    {  338, 8494,   80005,  5, }, // America/Sitka
    {  338, 8508,   80010, 18, }, // America/St_Barthelemy
    {  338, 2061,   80028,  9, }, // America/St_Johns
    {  338, 5863,   80037,  8, }, // America/St_Kitts
    {  338, 5880,   80045, 11, }, // America/St_Lucia
    {  338,  855,   80056, 11, }, // America/St_Thomas
    {  338, 5913,   80067, 15, }, // America/St_Vincent
    {  338, 8530,   80082, 13, }, // America/Swift_Current
    {  338, 5461,   80095, 14, }, // America/Tegucigalpa
    {  338, 5756,   80109,  5, }, // America/Thule
    {  338,  313,   80114,  8, }, // America/Tijuana
    {  338,  608,   80122,  7, }, // America/Toronto
    {  338, 5688,   80129,  7, }, // America/Tortola
    {  338, 2093,   80136,  9, }, // America/Vancouver
    {  338, 2144,   80145, 10, }, // America/Whitehorse
    {  338,  734,   80155, 10, }, // America/Winnipeg
    {  338, 8552,   80165,  9, }, // America/Yakutat
    {  338, 6001,   80174,  5, }, // Antarctica/Casey
    {  338, 6094,   80179,  7, }, // Antarctica/Davis
    {  338, 6133,   80186, 17, }, // Antarctica/DumontDUrville
    {  338, 8568,   80203,  8, }, // Antarctica/Macquarie
    {  338, 7066,   80211,  5, }, // Antarctica/Mawson
    {  338, 7113,   80216,  9, }, // Antarctica/McMurdo
    {  338, 8589,   80225,  6, }, // Antarctica/Palmer
    {  338, 7226,   80231,  6, }, // Antarctica/Rothera
    {  338, 7295,   80237,  5, }, // Antarctica/Syowa
    {  338, 8607,   80242,  4, }, // Antarctica/Troll
    {  338, 7374,   80246,  6, }, // Antarctica/Vostok
    {  338, 1429,   80252, 14, }, // Arctic/Longyearbyen
    {  338, 5570,   80266,  5, }, // Asia/Aden
    {  338, 5395,   80271,  6, }, // Asia/Almaty
    {  338, 3968,   80277,  5, }, // Asia/Amman
    {  338, 5511,   80282,  7, }, // Asia/Anadyr
    {  338, 5523,   80289,  6, }, // Asia/Aqtau
    {  338, 5368,   80295,  7, }, // Asia/Aqtobe
    {  338,  964,   80302,  8, }, // Asia/Ashgabat
    {  338, 8624,   80310,  7, }, // Asia/Atyrau
    {  338, 3607,   80317,  7, }, // Asia/Baghdad
    {  338, 5534,   80324,  8, }, // Asia/Bahrain
    {  338, 3653,   80332,  6, }, // Asia/Baku
    {  338, 4466,   80338,  8, }, // Asia/Bangkok
    {  338, 3571,   80346,  9, }, // Asia/Barnaul
    {  338, 4086,   80355,  7, }, // Asia/Beirut
    {  338, 3778,   80362,  7, }, // Asia/Bishkek
    {  338, 5989,   80369,  8, }, // Asia/Brunei
    {  338, 4601,   80377,  5, }, // Asia/Chita
    {  338, 4511,   80382,  7, }, // Asia/Colombo
    {  338, 4540,   80389,  8, }, // Asia/Damascus
    {  338, 1093,   80397,  5, }, // Asia/Dhaka
    {  338, 6192,   80402,  5, }, // Asia/Dili
    {  338, 3596,   80407,  8, }, // Asia/Dubai
    {  338, 6159,   80415, 10, }, // Asia/Dushanbe
    {  338, 8636,   80425, 10, }, // Asia/Famagusta
    {  338, 8651,   80435,  4, }, // Asia/Gaza
    {  338, 4795,   80439,  7, }, // Asia/Hebron
    {  338, 1259,   80446, 16, }, // Asia/Ho_Chi_Minh
    {  338, 2704,   80462, 11, }, // Asia/Hong_Kong
    {  338, 4771,   80473,  5, }, // Asia/Hovd
    {  338, 4184,   80478,  8, }, // Asia/Irkutsk
    {  338, 7006,   80486,  8, }, // Asia/Jakarta
    {  338, 6992,   80494, 11, }, // Asia/Jayapura
    {  338, 1290,   80505, 10, }, // Asia/Jerusalem
    {  338, 3560,   80515,  7, }, // Asia/Kabul
    {  338, 4316,   80522,  9, }, // Asia/Kamchatka
    {  338, 4239,   80531,  7, }, // Asia/Karachi
    {  338, 1185,   80538,  9, }, // Asia/Kathmandu
    {  338, 8661,   80547,  8, }, // Asia/Khandyga
    {  338,  992,   80555,  8, }, // Asia/Kolkata
    {  338, 4197,   80563, 12, }, // Asia/Krasnoyarsk
    {  338, 4859,   80575, 15, }, // Asia/Kuala_Lumpur
    {  338, 5976,   80590,  9, }, // Asia/Kuching
    {  338, 5547,   80599,  7, }, // Asia/Kuwait
    {  338, 1211,   80606,  5, }, // Asia/Macau
    {  338, 4017,   80611,  9, }, // Asia/Magadan
    {  338, 1349,   80620,  7, }, // Asia/Makassar
    {  338, 7182,   80627,  6, }, // Asia/Manila
    {  338, 6920,   80633,  6, }, // Asia/Muscat
    {  338, 2554,   80639,  8, }, // Asia/Nicosia
    {  338, 8675,   80647, 13, }, // Asia/Novokuznetsk
    {  338, 4135,   80660, 12, }, // Asia/Novosibirsk
    {  338, 4229,   80672,  4, }, // Asia/Omsk
    {  338, 7145,   80676,  4, }, // Asia/Oral
    {  338, 6961,   80680,  9, }, // Asia/Phnom_Penh
    {  338, 8693,   80689,  9, }, // Asia/Pontianak
    {  338, 4214,   80698, 12, }, // Asia/Pyongyang
    {  338, 5559,   80710,  5, }, // Asia/Qatar
    {  338, 8708,   80715,  8, }, // Asia/Qostanay
    {  338, 4269,   80723, 10, }, // Asia/Qyzylorda
    {  338, 3584,   80733,  5, }, // Asia/Riyadh
    {  338, 4408,   80738,  8, }, // Asia/Sakhalin
    {  338, 7245,   80746, 10, }, // Asia/Samarkand
    {  338, 3279,   80756,  5, }, // Asia/Seoul
    {  338, 1053,   80761,  7, }, // Asia/Shanghai
    {  338, 3300,   80768, 10, }, // Asia/Singapore
    {  338, 4297,   80778, 14, }, // Asia/Srednekolymsk
    {  338, 3263,   80792,  6, }, // Asia/Taipei
    {  338, 4781,   80798,  8, }, // Asia/Tashkent
    {  338, 3915,   80806,  7, }, // Asia/Tbilisi
    {  338, 2772,   80813,  8, }, // Asia/Tehran
    {  338, 1317,   80821,  6, }, // Asia/Thimphu
    {  338, 2821,   80827,  5, }, // Asia/Tokyo
    {  338, 4572,   80832,  5, }, // Asia/Tomsk
    {  338, 1021,   80837, 12, }, // Asia/Ulaanbaatar
    {  338, 1159,   80849,  9, }, // Asia/Urumqi
    {  338, 8722,   80858,  9, }, // Asia/Ust-Nera
    {  338, 6977,   80867,  8, }, // Asia/Vientiane
    {  338, 4710,   80875, 11, }, // Asia/Vladivostok
    {  338, 4828,   80886,  9, }, // Asia/Yakutsk
    {  338, 1235,   80895,  8, }, // Asia/Yangon
    {  338, 3883,   80903, 15, }, // Asia/Yekaterinburg
    {  338, 3747,   80918,  6, }, // Asia/Yerevan
    {  338, 3663,   80924,  6, }, // Atlantic/Azores
    {  338, 5671,   80930,  9, }, // Atlantic/Bermuda
    {  338, 6628,   80939,  7, }, // Atlantic/Canary
    {  338, 3727,   80946, 17, }, // Atlantic/Cape_Verde
    {  338, 1395,   80963,  6, }, // Atlantic/Faroe
    {  338, 8736,   80969,  6, }, // Atlantic/Madeira
    {  338, 2748,   80975,  9, }, // Atlantic/Reykjavik
    {  338, 7272,   80984, 13, }, // Atlantic/South_Georgia
    {  338, 6821,   80997,  9, }, // Atlantic/St_Helena
    {  338, 6644,   81006,  7, }, // Atlantic/Stanley
    {  338, 1670,   81013,  8, }, // Australia/Adelaide
    {  338, 1635,   81021, 10, }, // Australia/Brisbane
    {  338, 1799,   81031, 11, }, // Australia/Broken_Hill
    {  338, 1583,   81042,  9, }, // Australia/Darwin
    {  338, 3637,   81051,  7, }, // Australia/Eucla
    {  338, 1516,   81058,  7, }, // Australia/Hobart
    {  338, 8753,   81065,  8, }, // Australia/Lindeman
    {  338, 1547,   81073, 10, }, // Australia/Lord_Howe
    {  338, 1727,   81083,  9, }, // Australia/Melbourne
    {  338, 1762,   81092,  4, }, // Australia/Perth
    {  338, 1463,   81096,  6, }, // Australia/Sydney
    {  338, 6441,   81102, 10, }, // Europe/Amsterdam
    {  338, 6216,   81112,  6, }, // Europe/Andorra
    {  338, 3620,   81118,  8, }, // Europe/Astrakhan
    {  338, 2300,   81126,  5, }, // Europe/Athens
    {  338, 6336,   81131,  9, }, // Europe/Belgrade
    {  338, 4757,   81140,  8, }, // Europe/Berlin
    {  338, 6488,   81148, 11, }, // Europe/Bratislava
    {  338, 2167,   81159,  9, }, // Europe/Brussels
    {  338, 3928,   81168, 11, }, // Europe/Bucharest
    {  338, 3806,   81179, 10, }, // Europe/Budapest
    {  338, 8772,   81189, 10, }, // Europe/Busingen
    {  338, 2583,   81199,  8, }, // Europe/Chisinau
    {  338, 6289,   81207,  9, }, // Europe/Copenhagen
    {  338, 2338,   81216,  8, }, // Europe/Dublin
    {  338, 6307,   81224,  9, }, // Europe/Gibraltar
    {  338, 8788,   81233,  7, }, // Europe/Guernsey
    {  338, 6612,   81240,  7, }, // Europe/Helsinki
    {  338, 8804,   81247, 13, }, // Europe/Isle_of_Man
    {  338, 1130,   81260, 16, }, // Europe/Istanbul
    {  338, 8823,   81276,  7, }, // Europe/Jersey
    {  338, 3979,   81283, 13, }, // Europe/Kaliningrad
    {  338, 8929,   81296,  5, }, // Europe/Kirov
    {  338, 2527,   81301,  5, }, // Europe/Kyiv
    {  338, 3213,   81306,  8, }, // Europe/Lisbon
    {  338, 6506,   81314, 11, }, // Europe/Ljubljana
    {  338, 2501,   81325,  7, }, // Europe/London
    {  338, 6365,   81332, 12, }, // Europe/Luxembourg
    {  338, 4892,   81344,  7, }, // Europe/Madrid
    {  338, 6397,   81351,  5, }, // Europe/Malta
    {  338, 6582,   81356,  9, }, // Europe/Mariehamn
    {  338, 3693,   81365,  5, }, // Europe/Minsk
    {  338, 6410,   81370,  6, }, // Europe/Monaco
    {  338, 3537,   81376,  5, }, // Europe/Moscow
    {  338, 6458,   81381,  4, }, // Europe/Oslo
    {  338, 4284,   81385,  6, }, // Europe/Paris
    {  338, 6424,   81391, 12, }, // Europe/Podgorica
    {  338, 6275,   81403,  5, }, // Europe/Prague
    {  338, 8837,   81408,  4, }, // Europe/Riga
    {  338, 6324,   81412,  4, }, // Europe/Rome
    {  338, 4331,   81416,  6, }, // Europe/Samara
    {  338, 6470,   81422, 13, }, // Europe/San_Marino
    {  338, 6245,   81435,  8, }, // Europe/Sarajevo
    {  338, 4451,   81443,  7, }, // Europe/Saratov
    {  338, 8849,   81450, 11, }, // Europe/Simferopol
    {  338, 6383,   81461,  6, }, // Europe/Skopje
    {  338, 6599,   81467,  5, }, // Europe/Sofia
    {  338, 6523,   81472,  9, }, // Europe/Stockholm
    {  338, 8867,   81481,  5, }, // Europe/Tallinn
    {  338, 6202,   81486,  6, }, // Europe/Tirane
    {  338, 8882,   81492, 10, }, // Europe/Ulyanovsk
    {  338, 6352,   81502,  7, }, // Europe/Vaduz
    {  338, 6567,   81509,  8, }, // Europe/Vatican
    {  338, 6231,   81517,  6, }, // Europe/Vienna
    {  338, 8899,   81523,  8, }, // Europe/Vilnius
    {  338, 4727,   81531, 11, }, // Europe/Volgograd
    {  338, 3190,   81542,  8, }, // Europe/Warsaw
    {  338, 6261,   81550,  8, }, // Europe/Zagreb
    {  338, 6540,   81558,  6, }, // Europe/Zurich
    {  338, 5078,   81564, 12, }, // Indian/Antananarivo
    {  338, 6947,   81576,  7, }, // Indian/Chagos
    {  338, 6046,   81583, 19, }, // Indian/Christmas
    {  338, 6063,   81602,  5, }, // Indian/Cocos
    {  338, 5029,   81607,  6, }, // Indian/Comoro
    {  338, 6661,   81613,  9, }, // Indian/Kerguelen
    {  338, 7260,   81622,  4, }, // Indian/Mahe
    {  338, 7050,   81626,  8, }, // Indian/Maldives
    {  338, 4069,   81634,  9, }, // Indian/Mauritius
    {  338, 5098,   81643,  6, }, // Indian/Mayotte
    {  338, 7211,   81649,  7, }, // Indian/Reunion
    {  338, 4422,   81656,  4, }, // Pacific/Apia
    {  338,  932,   81660,  6, }, // Pacific/Auckland
    {  338, 3706,   81666, 11, }, // Pacific/Bougainville
    {  338, 3015,   81677,  6, }, // Pacific/Chatham
    {  338, 3157,   81683,  5, }, // Pacific/Chuuk
    {  338, 2237,   81688, 11, }, // Pacific/Easter
    {  338, 7360,   81699,  5, }, // Pacific/Efate
    {  338, 7327,   81704,  7, }, // Pacific/Fakaofo
    {  338, 3902,   81711,  5, }, // Pacific/Fiji
    {  338, 7343,   81716, 10, }, // Pacific/Funafuti
    {  338, 6678,   81726, 11, }, // Pacific/Galapagos
    {  338, 6696,   81737,  8, }, // Pacific/Gambier
    {  338, 3822,   81745, 14, }, // Pacific/Guadalcanal
    {  338, 6018,   81759,  6, }, // Pacific/Guam
    {  338, 2723,   81765, 10, }, // Pacific/Honolulu
    {  338, 3049,   81775, 10, }, // Pacific/Kanton
    {  338, 3998,   81785, 10, }, // Pacific/Kiritimati
    {  338, 7019,   81795,  6, }, // Pacific/Kosrae
    {  338, 2842,   81801, 11, }, // Pacific/Kwajalein
    {  338, 4877,   81812,  8, }, // Pacific/Majuro
    {  338, 4051,   81820,  8, }, // Pacific/Marquesas
    {  338, 8914,   81828,  9, }, // Pacific/Midway
    {  338, 7084,   81837,  7, }, // Pacific/Nauru
    {  338, 7132,   81844,  5, }, // Pacific/Niue
    {  338, 4168,   81849,  7, }, // Pacific/Norfolk
    {  338, 7098,   81856,  6, }, // Pacific/Noumea
    {  338, 3126,   81862, 11, }, // Pacific/Pago_Pago
    {  338, 7155,   81873,  6, }, // Pacific/Palau
    {  338, 7194,   81879,  7, }, // Pacific/Pitcairn
    {  338, 3096,   81886,  6, }, // Pacific/Pohnpei
    {  338, 4807,   81892, 13, }, // Pacific/Port_Moresby
    {  338, 6076,   81905, 10, }, // Pacific/Rarotonga
    {  338, 6031,   81915,  6, }, // Pacific/Saipan
    {  338, 7312,   81921,  5, }, // Pacific/Tahiti
    {  338, 6712,   81926,  7, }, // Pacific/Tarawa
    {  338, 4583,   81933, 11, }, // Pacific/Tongatapu
    {  338, 7392,   81944,  6, }, // Pacific/Wake
    {  338, 7405,   81950,  7, }, // Pacific/Wallis
    {  340,   14,       0,  6, }, // Africa/Asmara Guarani/Latin/Paraguay
    {  340, 4435,       6,  8, }, // Africa/Sao_Tome
    {  340, 4252,      14,  8, }, // America/Asuncion
    {  340,  237,      22,  8, }, // America/Atikokan
    {  340, 7623,      30, 17, }, // America/Bahia_Banderas
    {  340, 3868,      47,  6, }, // America/Cancun
    {  340, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  340, 5723,      66,  7, }, // America/Curacao
    {  340,  481,      73, 13, }, // America/Indiana/Knox
    {  340, 7961,      86, 16, }, // America/Indiana/Marengo
    {  340, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  340, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  340, 8038,     139, 14, }, // America/Indiana/Vevay
    {  340, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  340, 8086,     171, 16, }, // America/Indiana/Winamac
    {  340, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  340, 5932,     207, 22, }, // America/Lower_Princes
    {  340, 8220,     229,  6, }, // America/Merida
    {  340, 1850,     235, 19, }, // America/Noronha
    {  340, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  340, 8329,     274, 20, }, // America/North_Dakota/Center
    {  340, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  340,  393,     317,  4, }, // America/Nuuk
    {  340, 6899,     321, 16, }, // America/Scoresbysund
    {  340, 8508,     337, 14, }, // America/St_Barthelemy
    {  340, 2061,     351, 10, }, // America/St_Johns
    {  340, 5863,     361,  9, }, // America/St_Kitts
    {  340, 5880,     370,  9, }, // America/St_Lucia
    {  340,  855,     379, 10, }, // America/St_Thomas
    {  340, 5913,     389, 11, }, // America/St_Vincent
    {  340, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  340, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  340, 1185,     448,  9, }, // Asia/Kathmandu
    {  340,  992,     457,  7, }, // Asia/Kolkata
    {  340, 1211,     464,  5, }, // Asia/Macau
    {  340, 1235,     477,  6, }, // Asia/Yangon
    {  340, 1395,     483,  5, }, // Atlantic/Faroe
    {  340, 6821,     488, 10, }, // Atlantic/St_Helena
    {  340, 2527,     514,  4, }, // Europe/Kyiv
    {  340, 7211,     547,  7, }, // Indian/Reunion
    {  340, 3157,     554,  5, }, // Pacific/Chuuk
    {  340, 3096,     586,  7, }, // Pacific/Pohnpei
    {  341, 6788,   81957,  8, }, // Africa/Abidjan Gujarati/Gujarati/India
    {  341, 6760,   81965,  4, }, // Africa/Accra
    {  341, 5059,   81969, 10, }, // Africa/Addis_Ababa
    {  341, 7420,   81979,  9, }, // Africa/Algiers
    {  341,   14,   81988,  7, }, // Africa/Asmara
    {  341,   44,   81995,  5, }, // Africa/Bamako
    {  341, 5257,   82000,  6, }, // Africa/Bangui
    {  341, 6746,   82006,  6, }, // Africa/Banjul
    {  341, 7435,   82012,  5, }, // Africa/Bissau
    {  341, 4957,   82017,  8, }, // Africa/Blantyre
    {  341, 5287,   82025, 10, }, // Africa/Brazzaville
    {  341, 4922,   82035,  9, }, // Africa/Bujumbura
    {  341, 2320,   82044,  4, }, // Africa/Cairo
    {  341, 4117,   82048, 11, }, // Africa/Casablanca
    {  341, 7449,   82059,  6, }, // Africa/Ceuta
    {  341, 6773,   82065,  8, }, // Africa/Conakry
    {  341, 6840,   82073,  4, }, // Africa/Dakar
    {  341, 5130,   82077, 11, }, // Africa/Dar_es_Salaam
    {  341, 5043,   82088,  6, }, // Africa/Djibouti
    {  341, 5243,   82094,  5, }, // Africa/Douala
    {  341, 5166,   82099,  6, }, // Africa/El_Aaiun
    {  341, 6853,   82105,  8, }, // Africa/Freetown
    {  341, 4906,   82113,  7, }, // Africa/Gaborone
    {  341, 5015,   82120,  5, }, // Africa/Harare
    {  341, 4479,   82125, 11, }, // Africa/Johannesburg
    {  341, 4499,   82136,  4, }, // Africa/Juba
    {  341, 5151,   82140,  7, }, // Africa/Kampala
    {  341, 4524,   82147,  7, }, // Africa/Khartoum
    {  341, 4973,   82154,  6, }, // Africa/Kigali
    {  341, 5306,   82160,  7, }, // Africa/Kinshasa
    {  341, 4744,   82167,  5, }, // Africa/Lagos
    {  341, 5336,   82172, 10, }, // Africa/Libreville
    {  341, 6869,   82182,  3, }, // Africa/Lome
    {  341, 5211,   82185,  9, }, // Africa/Luanda
    {  341, 4939,   82194, 10, }, // Africa/Lubumbashi
    {  341, 5001,   82204,  6, }, // Africa/Lusaka
    {  341, 5322,   82210,  5, }, // Africa/Malabo
    {  341, 4987,   82215,  6, }, // Africa/Maputo
    {  341, 5197,   82221,  5, }, // Africa/Maseru
    {  341, 5182,   82226,  7, }, // Africa/Mbabane
    {  341, 5113,   82233,  8, }, // Africa/Mogadishu
    {  341, 7034,   82241,  9, }, // Africa/Monrovia
    {  341, 3853,   82250,  6, }, // Africa/Nairobi
    {  341, 5271,   82256,  7, }, // Africa/Ndjamena
    {  341, 5354,   82263,  6, }, // Africa/Niamey
    {  341, 6803,   82269,  6, }, // Africa/Nouakchott
    {  341, 6727,   82275,  8, }, // Africa/Ouagadougou
    {  341, 5225,   82283, 11, }, // Africa/Porto-Novo
    {  341, 4435,   82294,  7, }, // Africa/Sao_Tome
    {  341, 2866,   82301,  8, }, // Africa/Tripoli
    {  341, 6554,   82309,  7, }, // Africa/Tunis
    {  341, 4152,   82316,  7, }, // Africa/Windhoek
    {  341,  132,   82323,  3, }, // America/Adak
    {  341, 3346,   82326,  8, }, // America/Anchorage
    {  341, 5607,   82334,  8, }, // America/Anguilla
    {  341, 5624,   82342,  8, }, // America/Antigua
    {  341, 4554,   82350,  8, }, // America/Araguaina
    {  341,  166,   82358, 12, }, // America/Argentina/Buenos_Aires
    {  341,   91,   82370, 10, }, // America/Argentina/Catamarca
    {  341,  270,   82380,  8, }, // America/Argentina/Cordoba
    {  341,  441,   82388,  5, }, // America/Argentina/Jujuy
    {  341, 7462,   82393,  8, }, // America/Argentina/La_Rioja
    {  341,  565,   82401,  8, }, // America/Argentina/Mendoza
    {  341, 7489,   82409, 11, }, // America/Argentina/Rio_Gallegos
    {  341, 7520,   82420,  6, }, // America/Argentina/Salta
    {  341, 7544,   82426,  8, }, // America/Argentina/San_Juan
    {  341, 5580,   82434,  8, }, // America/Argentina/San_Luis
    {  341, 7571,   82442,  7, }, // America/Argentina/Tucuman
    {  341, 7597,   82449,  5, }, // America/Argentina/Ushuaia
    {  341, 5640,   82454,  5, }, // America/Aruba
    {  341, 4252,   82459,  8, }, // America/Asuncion
    {  341,  237,   82467,  8, }, // America/Atikokan
    {  341, 3679,   82475,  6, }, // America/Bahia
    {  341, 7623,   82481, 14, }, // America/Bahia_Banderas
    {  341, 5654,   82495,  8, }, // America/Barbados
    {  341, 7646,   82503,  5, }, // America/Belem
    {  341, 5407,   82508,  5, }, // America/Belize
    {  341, 7660,   82513, 13, }, // America/Blanc-Sablon
    {  341, 7681,   82526, 10, }, // America/Boa_Vista
    {  341, 4361,   82536,  6, }, // America/Bogota
    {  341, 7699,   82542,  4, }, // America/Boise
    {  341, 7713,   82546, 12, }, // America/Cambridge_Bay
    {  341, 7735,   82558, 13, }, // America/Campo_Grande
    {  341, 3868,   82571,  7, }, // America/Cancun
    {  341, 4694,   82578,  6, }, // America/Caracas
    {  341, 4345,   82584,  6, }, // America/Cayenne
    {  341, 5496,   82590,  5, }, // America/Cayman
    {  341, 2260,   82595,  6, }, // America/Chicago
    {  341, 7756,   82601,  8, }, // America/Chihuahua
    {  341, 7774,   82609, 14, }, // America/Ciudad_Juarez
    {  341, 5422,   82623, 11, }, // America/Costa_Rica
    {  341, 7796,   82634,  8, }, // America/Creston
    {  341, 3791,   82642,  7, }, // America/Cuiaba
    {  341, 5723,   82649,  7, }, // America/Curacao
    {  341, 7812,   82656, 11, }, // America/Danmarkshavn
    {  341, 7833,   82667,  4, }, // America/Dawson
    {  341, 7848,   82671, 10, }, // America/Dawson_Creek
    {  341,  805,   82681,  6, }, // America/Denver
    {  341, 3465,   82687,  8, }, // America/Detroit
    {  341, 5739,   82695,  8, }, // America/Dominica
    {  341,  893,   82703,  8, }, // America/Edmonton
    {  341, 7869,   82711,  6, }, // America/Eirunepe
    {  341, 5441,   82717, 12, }, // America/El_Salvador
    {  341, 7886,   82729, 12, }, // America/Fort_Nelson
    {  341, 7906,   82741, 10, }, // America/Fortaleza
    {  341, 7924,   82751,  8, }, // America/Glace_Bay
    {  341, 6881,   82759,  6, }, // America/Goose_Bay
    {  341, 4612,   82765, 12, }, // America/Grand_Turk
    {  341, 5770,   82777,  8, }, // America/Grenada
    {  341, 5786,   82785,  9, }, // America/Guadeloupe
    {  341, 3760,   82794, 10, }, // America/Guatemala
    {  341, 4841,   82804,  9, }, // America/Guayaquil
    {  341, 6932,   82813,  5, }, // America/Guyana
    {  341, 1939,   82818,  9, }, // America/Halifax
    {  341, 2281,   82827,  5, }, // America/Havana
    {  341, 7942,   82832,  8, }, // America/Hermosillo
    {  341,  348,   82840, 14, }, // America/Indiana/Indianapolis
    {  341,  481,   82854, 16, }, // America/Indiana/Knox
    {  341, 7961,   82870, 18, }, // America/Indiana/Marengo
    {  341, 7985,   82888, 21, }, // America/Indiana/Petersburg
    {  341, 8012,   82909, 19, }, // America/Indiana/Tell_City
    {  341, 8038,   82928, 15, }, // America/Indiana/Vevay
    {  341, 8060,   82943, 20, }, // America/Indiana/Vincennes
    {  341, 8086,   82963, 18, }, // America/Indiana/Winamac
    {  341, 8110,   82981,  6, }, // America/Inuvik
    {  341,  660,   82987,  7, }, // America/Iqaluit
    {  341, 2799,   82994,  5, }, // America/Jamaica
    {  341, 5380,   82999,  5, }, // America/Juneau
    {  341,  521,   83004,  6, }, // America/Kentucky/Louisville
    {  341, 8125,   83010, 20, }, // America/Kentucky/Monticello
    {  341, 5704,   83030, 11, }, // America/Kralendijk
    {  341, 4376,   83041,  6, }, // America/La_Paz
    {  341, 7169,   83047,  4, }, // America/Lima
    {  341, 3239,   83051, 11, }, // America/Los_Angeles
    {  341, 5932,   83062, 24, }, // America/Lower_Princes
    {  341, 8153,   83086,  5, }, // America/Maceio
    {  341, 8168,   83091,  7, }, // America/Managua
    {  341, 1908,   83098,  4, }, // America/Manaus
    {  341, 5897,   83102,  7, }, // America/Marigot
    {  341, 5805,   83109,  9, }, // America/Martinique
    {  341, 8184,   83118,  9, }, // America/Matamoros
    {  341, 2917,   83127,  7, }, // America/Mazatlan
    {  341, 8202,   83134,  8, }, // America/Menominee
    {  341, 8220,   83142,  6, }, // America/Merida
    {  341, 8235,   83148, 12, }, // America/Metlakatla
    {  341, 2949,   83160, 13, }, // America/Mexico_City
    {  341, 4391,   83173,  9, }, // America/Miquelon
    {  341, 8254,   83182,  7, }, // America/Moncton
    {  341, 8270,   83189,  8, }, // America/Monterrey
    {  341, 4098,   83197, 10, }, // America/Montevideo
    {  341, 5824,   83207,  9, }, // America/Montserrat
    {  341, 5481,   83216,  5, }, // America/Nassau
    {  341, 2379,   83221,  9, }, // America/New_York
    {  341, 8288,   83136,  3, }, // America/Nome
    {  341, 1850,   83230,  8, }, // America/Noronha
    {  341, 8301,   83238, 21, }, // America/North_Dakota/Beulah
    {  341, 8329,   83259, 20, }, // America/North_Dakota/Center
    {  341, 8357,   83279, 23, }, // America/North_Dakota/New_Salem
    {  341,  393,   83302,  3, }, // America/Nuuk
    {  341, 8388,   83305,  7, }, // America/Ojinaga
    {  341, 2356,   83312,  5, }, // America/Panama
    {  341, 6173,   83317, 10, }, // America/Paramaribo
    {  341, 2973,   83327,  7, }, // America/Phoenix
    {  341, 3945,   83334, 15, }, // America/Port-au-Prince
    {  341, 5954,   83349, 14, }, // America/Port_of_Spain
    {  341, 8404,   83363, 13, }, // America/Porto_Velho
    {  341, 5843,   83376, 14, }, // America/Puerto_Rico
    {  341, 4030,   83390, 13, }, // America/Punta_Arenas
    {  341, 8424,   83403, 13, }, // America/Rankin_Inlet
    {  341, 8445,   83416,  5, }, // America/Recife
    {  341, 1995,   83421,  6, }, // America/Regina
    {  341, 8460,   83427,  7, }, // America/Resolute
    {  341,  695,   83434, 12, }, // America/Rio_Branco
    {  341, 8477,   83446,  9, }, // America/Santarem
    {  341, 2201,   83455,  9, }, // America/Santiago
    {  341, 6111,   83464, 13, }, // America/Santo_Domingo
    {  341, 1878,   83477,  9, }, // America/Sao_Paulo
    {  341, 6899,   83486, 14, }, // America/Scoresbysund
    {  341, 8494,   83500,  6, }, // America/Sitka
    {  341, 8508,   83506, 15, }, // America/St_Barthelemy
    {  341, 2061,   83521, 12, }, // America/St_Johns
    {  341, 5863,   83533, 10, }, // America/St_Kitts
    {  341, 5880,   83543, 11, }, // America/St_Lucia
    {  341,  855,   83554,  9, }, // America/St_Thomas
    {  341, 5913,   83563, 14, }, // America/St_Vincent
    {  341, 8530,   83577, 12, }, // America/Swift_Current
    {  341, 5461,   83589, 11, }, // America/Tegucigalpa
    {  341, 5756,   83600,  4, }, // America/Thule
    {  341,  313,   83604,  7, }, // America/Tijuana
    {  341,  608,   83611,  7, }, // America/Toronto
    {  341, 5688,   83618,  8, }, // America/Tortola
    {  341, 2093,   83626,  8, }, // America/Vancouver
    {  341, 2144,   83634, 11, }, // America/Whitehorse
    {  341,  734,   83645,  9, }, // America/Winnipeg
    {  341, 8552,   83654,  5, }, // America/Yakutat
    {  341, 6001,   83659,  4, }, // Antarctica/Casey
    {  341, 6094,   83663,  5, }, // Antarctica/Davis
    {  341, 6133,   83668, 17, }, // Antarctica/DumontDUrville
    {  341, 8568,   83685,  8, }, // Antarctica/Macquarie
    {  341, 7066,   83693,  4, }, // Antarctica/Mawson
    {  341, 7113,   83697,  8, }, // Antarctica/McMurdo
    {  341, 8589,   83705,  6, }, // Antarctica/Palmer
    {  341, 7226,   83711,  6, }, // Antarctica/Rothera
    {  341, 7295,   83717,  6, }, // Antarctica/Syowa
    {  341, 8607,   83723,  5, }, // Antarctica/Troll
    {  341, 7374,   83728,  7, }, // Antarctica/Vostok
    {  341, 1429,   83735, 12, }, // Arctic/Longyearbyen
    {  341, 5570,   83747,  4, }, // Asia/Aden
    {  341, 5395,   83751,  7, }, // Asia/Almaty
    {  341, 3968,   83758,  6, }, // Asia/Amman
    {  341, 5511,   83764,  5, }, // Asia/Anadyr
    {  341, 5523,   83769,  5, }, // Asia/Aqtau
    {  341, 5368,   83774,  6, }, // Asia/Aqtobe
    {  341,  964,   83780,  6, }, // Asia/Ashgabat
    {  341, 8624,   83786,  7, }, // Asia/Atyrau
    {  341, 3607,   83793,  5, }, // Asia/Baghdad
    {  341, 5534,   83798,  6, }, // Asia/Bahrain
    {  341, 3653,   82647,  4, }, // Asia/Baku
    {  341, 4466,   83804,  7, }, // Asia/Bangkok
    {  341, 3571,   83811,  6, }, // Asia/Barnaul
    {  341, 4086,   83817,  5, }, // Asia/Beirut
    {  341, 3778,   83822,  6, }, // Asia/Bishkek
    {  341, 5989,   83828,  7, }, // Asia/Brunei
    {  341, 4601,   83835,  4, }, // Asia/Chita
    {  341, 4511,   83839,  6, }, // Asia/Colombo
    {  341, 4540,   83845,  7, }, // Asia/Damascus
    {  341, 1093,   83852,  4, }, // Asia/Dhaka
    {  341, 6192,   83856,  4, }, // Asia/Dili
    {  341, 3596,   83860,  4, }, // Asia/Dubai
    {  341, 6159,   83864,  8, }, // Asia/Dushanbe
    {  341, 8636,   83872, 10, }, // Asia/Famagusta
    {  341, 8651,   83882,  4, }, // Asia/Gaza
    {  341, 4795,   83886,  7, }, // Asia/Hebron
    {  341, 1259,   83893, 14, }, // Asia/Ho_Chi_Minh
    {  341, 2704,   83907,  8, }, // Asia/Hong_Kong
    {  341, 4771,   83915,  5, }, // Asia/Hovd
    {  341, 4184,   83920, 10, }, // Asia/Irkutsk
    {  341, 7006,   83930,  7, }, // Asia/Jakarta
    {  341, 6992,   83937,  7, }, // Asia/Jayapura
    {  341, 1290,   83944,  8, }, // Asia/Jerusalem
    {  341, 3560,   83952,  5, }, // Asia/Kabul
    {  341, 4316,   83957,  8, }, // Asia/Kamchatka
    {  341, 4239,   83965,  5, }, // Asia/Karachi
    {  341, 1185,   83970,  7, }, // Asia/Kathmandu
    {  341, 8661,   83977,  6, }, // Asia/Khandyga
    {  341,  992,   83983,  7, }, // Asia/Kolkata
    {  341, 4197,   83990, 15, }, // Asia/Krasnoyarsk
    {  341, 4859,   84005, 13, }, // Asia/Kuala_Lumpur
    {  341, 5976,   84018,  6, }, // Asia/Kuching
    {  341, 5547,   84024,  5, }, // Asia/Kuwait
    {  341, 1211,   84029,  4, }, // Asia/Macau
    {  341, 4017,   84033,  6, }, // Asia/Magadan
    {  341, 1349,   84039,  7, }, // Asia/Makassar
    {  341, 7182,   84046,  5, }, // Asia/Manila
    {  341, 6920,   84051,  5, }, // Asia/Muscat
    {  341, 2554,   84056,  8, }, // Asia/Nicosia
    {  341, 8675,   84064, 15, }, // Asia/Novokuznetsk
    {  341, 4135,   84079, 15, }, // Asia/Novosibirsk
    {  341, 4229,   84094,  6, }, // Asia/Omsk
    {  341, 7145,   84100,  3, }, // Asia/Oral
    {  341, 6961,   84103, 11, }, // Asia/Phnom_Penh
    {  341, 8693,   84114, 10, }, // Asia/Pontianak
    {  341, 4214,   84124, 10, }, // Asia/Pyongyang
    {  341, 5559,   84134,  4, }, // Asia/Qatar
    {  341, 8708,   84138,  8, }, // Asia/Qostanay
    {  341, 4269,   84146, 10, }, // Asia/Qyzylorda
    {  341, 3584,   84156,  5, }, // Asia/Riyadh
    {  341, 4408,   84161,  6, }, // Asia/Sakhalin
    {  341, 7245,   84167,  7, }, // Asia/Samarkand
    {  341, 3279,   84174,  4, }, // Asia/Seoul
    {  341, 1053,   84178,  6, }, // Asia/Shanghai
    {  341, 3300,   84184,  8, }, // Asia/Singapore
    {  341, 4297,   84192, 17, }, // Asia/Srednekolymsk
    {  341, 3263,   84209,  6, }, // Asia/Taipei
    {  341, 4781,   84215,  8, }, // Asia/Tashkent
    {  341, 3915,   84223,  6, }, // Asia/Tbilisi
    {  341, 2772,   84229,  6, }, // Asia/Tehran
    {  341, 1317,   84235,  6, }, // Asia/Thimphu
    {  341, 2821,   84241,  6, }, // Asia/Tokyo
    {  341, 4572,   84247,  6, }, // Asia/Tomsk
    {  341, 1021,   84253,  8, }, // Asia/Ulaanbaatar
    {  341, 1159,   84261,  7, }, // Asia/Urumqi
    {  341, 8722,   84268,  9, }, // Asia/Ust-Nera
    {  341, 6977,   84277, 10, }, // Asia/Vientiane
    {  341, 4710,   84287, 13, }, // Asia/Vladivostok
    {  341, 4828,   84300,  7, }, // Asia/Yakutsk
    {  341, 1235,   84307,  5, }, // Asia/Yangon
    {  341, 3883,   84312, 13, }, // Asia/Yekaterinburg
    {  341, 3747,   84325,  7, }, // Asia/Yerevan
    {  341, 3663,   84332,  6, }, // Atlantic/Azores
    {  341, 5671,   84338,  7, }, // Atlantic/Bermuda
    {  341, 6628,   84345,  6, }, // Atlantic/Canary
    {  341, 3727,   84351,  9, }, // Atlantic/Cape_Verde
    {  341, 1395,   84360,  4, }, // Atlantic/Faroe
    {  341, 8736,   84364,  5, }, // Atlantic/Madeira
    {  341, 2748,   84369,  8, }, // Atlantic/Reykjavik
    {  341, 7272,   84377, 17, }, // Atlantic/South_Georgia
    {  341, 6821,   84394, 11, }, // Atlantic/St_Helena
    {  341, 6644,   84405,  7, }, // Atlantic/Stanley
    {  341, 1670,   84412,  7, }, // Australia/Adelaide
    {  341, 1635,   84419,  8, }, // Australia/Brisbane
    {  341, 1799,   84427, 10, }, // Australia/Broken_Hill
    {  341, 1583,   84437,  7, }, // Australia/Darwin
    {  341, 3637,   84444,  5, }, // Australia/Eucla
    {  341, 1516,   84449,  7, }, // Australia/Hobart
    {  341, 8753,   84456,  9, }, // Australia/Lindeman
    {  341, 1547,   84465,  9, }, // Australia/Lord_Howe
    {  341, 1727,   84474,  8, }, // Australia/Melbourne
    {  341, 1762,   84482,  4, }, // Australia/Perth
    {  341, 1463,   84486,  5, }, // Australia/Sydney
    {  341, 6441,   84491, 10, }, // Europe/Amsterdam
    {  341, 6216,   84501,  6, }, // Europe/Andorra
    {  341, 3620,   84507,  8, }, // Europe/Astrakhan
    {  341, 2300,   84515,  5, }, // Europe/Athens
    {  341, 6336,   84520,  8, }, // Europe/Belgrade
    {  341, 4757,   84528,  6, }, // Europe/Berlin
    {  341, 6488,   84534, 11, }, // Europe/Bratislava
    {  341, 2167,   84545,  8, }, // Europe/Brussels
    {  341, 3928,   84553,  8, }, // Europe/Bucharest
    {  341, 3806,   84561,  9, }, // Europe/Budapest
    {  341, 8772,   84570,  8, }, // Europe/Busingen
    {  341, 2583,   84578,  7, }, // Europe/Chisinau
    {  341, 6289,   84585,  8, }, // Europe/Copenhagen
    {  341, 2338,   84593,  5, }, // Europe/Dublin
    {  341, 6307,   84598, 10, }, // Europe/Gibraltar
    {  341, 8788,   84608,  6, }, // Europe/Guernsey
    {  341, 6612,   84614,  8, }, // Europe/Helsinki
    {  341, 8804,   84622, 10, }, // Europe/Isle_of_Man
    {  341, 1130,   84632,  9, }, // Europe/Istanbul
    {  341, 8823,   84641,  5, }, // Europe/Jersey
    {  341, 3979,   84646, 12, }, // Europe/Kaliningrad
    {  341, 8929,   84658,  5, }, // Europe/Kirov
    {  341, 2527,   84663,  3, }, // Europe/Kyiv
    {  341, 3213,   84666,  6, }, // Europe/Lisbon
    {  341, 6506,   84672, 10, }, // Europe/Ljubljana
    {  341, 2501,   84682,  4, }, // Europe/London
    {  341, 6365,   84686,  9, }, // Europe/Luxembourg
    {  341, 4892,   84695,  7, }, // Europe/Madrid
    {  341, 6397,   84702,  6, }, // Europe/Malta
    {  341, 6582,   84708,  7, }, // Europe/Mariehamn
    {  341, 3693,   84715,  6, }, // Europe/Minsk
    {  341, 6410,   84721,  6, }, // Europe/Monaco
    {  341, 3537,   84727,  6, }, // Europe/Moscow
    {  341, 6458,   84733,  5, }, // Europe/Oslo
    {  341, 4284,   84738,  5, }, // Europe/Paris
    {  341, 6424,   84743,  9, }, // Europe/Podgorica
    {  341, 6275,   84752,  5, }, // Europe/Prague
    {  341, 8837,   84757,  4, }, // Europe/Riga
    {  341, 6324,   83495,  3, }, // Europe/Rome
    {  341, 4331,   84761,  5, }, // Europe/Samara
    {  341, 6470,   84766, 10, }, // Europe/San_Marino
    {  341, 6245,   84776,  8, }, // Europe/Sarajevo
    {  341, 4451,   84784,  7, }, // Europe/Saratov
    {  341, 8849,   84791, 11, }, // Europe/Simferopol
    {  341, 6383,   84802,  7, }, // Europe/Skopje
    {  341, 6599,   84809,  6, }, // Europe/Sofia
    {  341, 6523,   84815,  8, }, // Europe/Stockholm
    {  341, 8867,   84823,  6, }, // Europe/Tallinn
    {  341, 6202,   84829,  6, }, // Europe/Tirane
    {  341, 8882,   84835, 10, }, // Europe/Ulyanovsk
    {  341, 6352,   84845,  5, }, // Europe/Vaduz
    {  341, 6567,   84850,  6, }, // Europe/Vatican
    {  341, 6231,   84856,  6, }, // Europe/Vienna
    {  341, 8899,   84862,  8, }, // Europe/Vilnius
    {  341, 4727,   84870, 11, }, // Europe/Volgograd
    {  341, 3190,   84881,  5, }, // Europe/Warsaw
    {  341, 6261,   84886,  6, }, // Europe/Zagreb
    {  341, 6540,   84892,  5, }, // Europe/Zurich
    {  341, 5078,   84897, 12, }, // Indian/Antananarivo
    {  341, 6947,   84909,  5, }, // Indian/Chagos
    {  341, 6046,   84914,  7, }, // Indian/Christmas
    {  341, 6063,   84921,  5, }, // Indian/Cocos
    {  341, 5029,   84926,  6, }, // Indian/Comoro
    {  341, 6661,   84932, 10, }, // Indian/Kerguelen
    {  341, 7260,   84942,  4, }, // Indian/Mahe
    {  341, 7050,   84946,  8, }, // Indian/Maldives
    {  341, 4069,   84954,  8, }, // Indian/Mauritius
    {  341, 5098,   84962,  5, }, // Indian/Mayotte
    {  341, 7211,   84967,  8, }, // Indian/Reunion
    {  341, 4422,   84975,  5, }, // Pacific/Apia
    {  341,  932,   84980,  7, }, // Pacific/Auckland
    {  341, 3706,   84987, 10, }, // Pacific/Bougainville
    {  341, 3015,   84997,  3, }, // Pacific/Chatham
    {  341, 3157,   85000,  3, }, // Pacific/Chuuk
    {  341, 2237,   85003,  5, }, // Pacific/Easter
    {  341, 7360,   85008,  4, }, // Pacific/Efate
    {  341, 7327,   85012,  7, }, // Pacific/Fakaofo
    {  341, 3902,   85019,  4, }, // Pacific/Fiji
    {  341, 7343,   85023,  8, }, // Pacific/Funafuti
    {  341, 6678,   85031,  9, }, // Pacific/Galapagos
    {  341, 6696,   85040,  8, }, // Pacific/Gambier
    {  341, 3822,   85048,  8, }, // Pacific/Guadalcanal
    {  341, 6018,   85056,  5, }, // Pacific/Guam
    {  341, 2723,   85061,  8, }, // Pacific/Honolulu
    {  341, 3049,   85069,  8, }, // Pacific/Kanton
    {  341, 3998,   85077, 10, }, // Pacific/Kiritimati
    {  341, 7019,   85087,  5, }, // Pacific/Kosrae
    {  341, 2842,   85092,  9, }, // Pacific/Kwajalein
    {  341, 4877,   85101,  6, }, // Pacific/Majuro
    {  341, 4051,   85107,  9, }, // Pacific/Marquesas
    {  341, 8914,   85116,  5, }, // Pacific/Midway
    {  341, 7084,   85121,  4, }, // Pacific/Nauru
    {  341, 7132,   85125,  4, }, // Pacific/Niue
    {  341, 4168,   85129,  6, }, // Pacific/Norfolk
    {  341, 7098,   85135,  5, }, // Pacific/Noumea
    {  341, 3126,   85140,  9, }, // Pacific/Pago_Pago
    {  341, 7155,   85149,  4, }, // Pacific/Palau
    {  341, 7194,   85153,  8, }, // Pacific/Pitcairn
    {  341, 3096,   85161,  6, }, // Pacific/Pohnpei
    {  341, 4807,   85167, 14, }, // Pacific/Port_Moresby
    {  341, 6076,   85181,  9, }, // Pacific/Rarotonga
    {  341, 6031,   85190,  5, }, // Pacific/Saipan
    {  341, 7312,   85195,  6, }, // Pacific/Tahiti
    {  341, 6712,   85201,  6, }, // Pacific/Tarawa
    {  341, 4583,   85207,  9, }, // Pacific/Tongatapu
    {  341, 7392,   85216,  3, }, // Pacific/Wake
    {  341, 7405,   85219,  5, }, // Pacific/Wallis
    {  342,   14,       0,  6, }, // Africa/Asmara Gusii/Latin/Kenya
    {  342, 4435,       6,  8, }, // Africa/Sao_Tome
    {  342, 4252,      14,  8, }, // America/Asuncion
    {  342,  237,      22,  8, }, // America/Atikokan
    {  342, 7623,      30, 17, }, // America/Bahia_Banderas
    {  342, 3868,      47,  6, }, // America/Cancun
    {  342, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  342, 5723,      66,  7, }, // America/Curacao
    {  342,  481,      73, 13, }, // America/Indiana/Knox
    {  342, 7961,      86, 16, }, // America/Indiana/Marengo
    {  342, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  342, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  342, 8038,     139, 14, }, // America/Indiana/Vevay
    {  342, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  342, 8086,     171, 16, }, // America/Indiana/Winamac
    {  342, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  342, 5932,     207, 22, }, // America/Lower_Princes
    {  342, 8220,     229,  6, }, // America/Merida
    {  342, 1850,     235, 19, }, // America/Noronha
    {  342, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  342, 8329,     274, 20, }, // America/North_Dakota/Center
    {  342, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  342,  393,     317,  4, }, // America/Nuuk
    {  342, 6899,     321, 16, }, // America/Scoresbysund
    {  342, 8508,     337, 14, }, // America/St_Barthelemy
    {  342, 2061,     351, 10, }, // America/St_Johns
    {  342, 5863,     361,  9, }, // America/St_Kitts
    {  342, 5880,     370,  9, }, // America/St_Lucia
    {  342,  855,     379, 10, }, // America/St_Thomas
    {  342, 5913,     389, 11, }, // America/St_Vincent
    {  342, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  342, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  342, 1185,     448,  9, }, // Asia/Kathmandu
    {  342,  992,     457,  7, }, // Asia/Kolkata
    {  342, 1211,     464,  5, }, // Asia/Macau
    {  342, 1235,     477,  6, }, // Asia/Yangon
    {  342, 1395,     483,  5, }, // Atlantic/Faroe
    {  342, 6821,     488, 10, }, // Atlantic/St_Helena
    {  342, 2527,     514,  4, }, // Europe/Kyiv
    {  342, 7211,     547,  7, }, // Indian/Reunion
    {  342, 3157,     554,  5, }, // Pacific/Chuuk
    {  342, 3096,     586,  7, }, // Pacific/Pohnpei
    {  343, 5059,   64622, 11, }, // Africa/Addis_Ababa Haitian/Latin/Haiti
    {  343, 7420,   44088,  5, }, // Africa/Algiers
    {  343,   14,       0,  6, }, // Africa/Asmara
    {  343, 2320,   64633,  8, }, // Africa/Cairo
    {  343, 5166,   64641,  8, }, // Africa/El_Aaiun
    {  343, 6869,   20418,  4, }, // Africa/Lome
    {  343, 5113,   44110, 10, }, // Africa/Mogadishu
    {  343, 5271,   44128,  9, }, // Africa/Ndjamena
    {  343, 4435,       6,  8, }, // Africa/Sao_Tome
    {  343, 2866,   64649, 15, }, // Africa/Tripoli
    {  343, 4554,   26559,  9, }, // America/Araguaina
    {  343,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  343, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  343, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  343, 7597,   64664,  7, }, // America/Argentina/Ushuaia
    {  343, 4252,      14,  8, }, // America/Asuncion
    {  343,  237,      22,  8, }, // America/Atikokan
    {  343, 7623,   64671, 17, }, // America/Bahia_Banderas
    {  343, 5654,   64688, 10, }, // America/Barbados
    {  343, 7646,   35896,  5, }, // America/Belem
    {  343, 3868,      47,  6, }, // America/Cancun
    {  343, 5496,   64698,  7, }, // America/Cayman
    {  343, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  343, 3791,   26574,  6, }, // America/Cuiaba
    {  343, 5723,      66,  7, }, // America/Curacao
    {  343, 3465,   64705,  7, }, // America/Detroit
    {  343, 5739,   64712,  9, }, // America/Dominica
    {  343, 7869,   26580,  8, }, // America/Eirunepe
    {  343, 5770,   64721,  7, }, // America/Grenada
    {  343, 2281,   64728,  9, }, // America/Havana
    {  343,  481,   64737, 14, }, // America/Indiana/Knox
    {  343, 7961,   64751, 17, }, // America/Indiana/Marengo
    {  343, 7985,   64768, 20, }, // America/Indiana/Petersburg
    {  343, 8012,   64788, 19, }, // America/Indiana/Tell_City
    {  343, 8038,   64807, 15, }, // America/Indiana/Vevay
    {  343, 8060,   64822, 19, }, // America/Indiana/Vincennes
    {  343, 8086,   64841, 17, }, // America/Indiana/Winamac
    {  343, 2799,   64858,  8, }, // America/Jamaica
    {  343, 8125,   64866, 21, }, // America/Kentucky/Monticello
    {  343, 5932,     207, 22, }, // America/Lower_Princes
    {  343, 8153,   26588,  6, }, // America/Maceio
    {  343, 1908,   64887,  6, }, // America/Manaus
    {  343, 2917,   26603,  8, }, // America/Mazatlan
    {  343, 8220,     229,  6, }, // America/Merida
    {  343, 2949,   58762,  6, }, // America/Mexico_City
    {  343, 1850,     235, 19, }, // America/Noronha
    {  343, 8301,   64893, 23, }, // America/North_Dakota/Beulah
    {  343, 8329,   64916, 23, }, // America/North_Dakota/Center
    {  343, 8357,   64939, 26, }, // America/North_Dakota/New_Salem
    {  343,  393,     317,  4, }, // America/Nuuk
    {  343, 5954,   64965, 14, }, // America/Port_of_Spain
    {  343, 5843,   64979, 10, }, // America/Puerto_Rico
    {  343, 8477,   26704,  8, }, // America/Santarem
    {  343, 6111,   64989, 14, }, // America/Santo_Domingo
    {  343, 1878,   26712,  9, }, // America/Sao_Paulo
    {  343, 6899,     321, 16, }, // America/Scoresbysund
    {  343, 8508,   26721, 16, }, // America/St_Barthelemy
    {  343, 2061,   65003, 25, }, // America/St_Johns
    {  343, 5863,   65028, 16, }, // America/St_Kitts
    {  343, 5880,   65044, 12, }, // America/St_Lucia
    {  343,  855,   26771, 12, }, // America/St_Thomas
    {  343, 5913,   65056, 13, }, // America/St_Vincent
    {  343, 5756,   65069,  5, }, // America/Thule
    {  343, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  343, 7295,   62201,  5, }, // Antarctica/Syowa
    {  343, 5395,   57607,  8, }, // Asia/Almaty
    {  343, 5523,   65074,  6, }, // Asia/Aqtau
    {  343, 5368,   65080, 11, }, // Asia/Aqtobe
    {  343,  964,   65091,  8, }, // Asia/Ashgabat
    {  343, 8624,   65099,  7, }, // Asia/Atyrau
    {  343, 3607,    4162,  6, }, // Asia/Baghdad
    {  343, 5534,   65106,  7, }, // Asia/Bahrain
    {  343, 3653,   35998,  5, }, // Asia/Baku
    {  343, 4086,   65113,  8, }, // Asia/Beirut
    {  343, 3778,   65121,  7, }, // Asia/Bishkek
    {  343, 4601,   36009,  6, }, // Asia/Chita
    {  343, 4540,    4201,  5, }, // Asia/Damascus
    {  343, 3596,   65128,  5, }, // Asia/Dubai
    {  343, 6159,   65133,  9, }, // Asia/Dushanbe
    {  343, 8636,   65142, 10, }, // Asia/Famagusta
    {  343, 4795,   65152,  6, }, // Asia/Hebron
    {  343, 1259,   65158, 17, }, // Asia/Ho_Chi_Minh
    {  343, 4184,   65175,  8, }, // Asia/Irkutsk
    {  343, 1290,   65183,  9, }, // Asia/Jerusalem
    {  343, 3560,   36037,  6, }, // Asia/Kabul
    {  343, 4316,   36043, 10, }, // Asia/Kamchatka
    {  343, 1185,   65192,  9, }, // Asia/Kathmandu
    {  343,  992,   36053,  8, }, // Asia/Kolkata
    {  343, 4197,   65201, 11, }, // Asia/Krasnoyarsk
    {  343, 5547,   65212,  6, }, // Asia/Kuwait
    {  343, 1211,     464,  5, }, // Asia/Macau
    {  343, 1349,   65218,  8, }, // Asia/Makassar
    {  343, 7182,   65226,  7, }, // Asia/Manila
    {  343, 6920,   20857,  7, }, // Asia/Muscat
    {  343, 2554,   65233,  7, }, // Asia/Nicosia
    {  343, 4135,   44379, 12, }, // Asia/Novosibirsk
    {  343, 7145,   65240,  7, }, // Asia/Oral
    {  343, 8708,   65247,  8, }, // Asia/Qostanay
    {  343, 4269,   65255,  9, }, // Asia/Qyzylorda
    {  343, 3584,   20874,  5, }, // Asia/Riyadh
    {  343, 4408,   65264,  9, }, // Asia/Sakhalin
    {  343, 7245,   65273, 10, }, // Asia/Samarkand
    {  343, 3279,   65283,  5, }, // Asia/Seoul
    {  343, 3300,   36101,  9, }, // Asia/Singapore
    {  343, 4781,   65288,  8, }, // Asia/Tashkent
    {  343, 3915,   65296,  8, }, // Asia/Tbilisi
    {  343, 2772,   65304,  7, }, // Asia/Tehran
    {  343, 1021,   65311, 11, }, // Asia/Ulaanbaatar
    {  343, 1159,   26933,  6, }, // Asia/Urumqi
    {  343, 4828,   65322,  8, }, // Asia/Yakutsk
    {  343, 1235,   65330,  7, }, // Asia/Yangon
    {  343, 3883,   65337, 13, }, // Asia/Yekaterinburg
    {  343, 3747,   26947,  6, }, // Asia/Yerevan
    {  343, 3663,   44461,  6, }, // Atlantic/Azores
    {  343, 5671,   44467,  8, }, // Atlantic/Bermuda
    {  343, 6628,   65350, 13, }, // Atlantic/Canary
    {  343, 3727,   65363,  8, }, // Atlantic/Cape_Verde
    {  343, 1395,   65371, 10, }, // Atlantic/Faroe
    {  343, 8736,   65381,  6, }, // Atlantic/Madeira
    {  343, 7272,   65387, 14, }, // Atlantic/South_Georgia
    {  343, 6821,   65401, 13, }, // Atlantic/St_Helena
    {  343, 1670,   65414,  8, }, // Australia/Adelaide
    {  343, 6216,   65422,  7, }, // Europe/Andorra
    {  343, 2300,   65429,  7, }, // Europe/Athens
    {  343, 2167,   57661,  9, }, // Europe/Brussels
    {  343, 3928,   21073,  8, }, // Europe/Bucharest
    {  343, 8772,   27037,  8, }, // Europe/Busingen
    {  343, 6289,   21081, 10, }, // Europe/Copenhagen
    {  343, 8788,   27045,  9, }, // Europe/Guernsey
    {  343, 8804,   65436, 10, }, // Europe/Isle_of_Man
    {  343, 2527,    8148,  4, }, // Europe/Kyiv
    {  343, 3213,   65446,  8, }, // Europe/Lisbon
    {  343, 2501,   21152,  7, }, // Europe/London
    {  343, 6397,   65454,  5, }, // Europe/Malta
    {  343, 3537,   44576,  6, }, // Europe/Moscow
    {  343, 6470,   65459, 11, }, // Europe/San_Marino
    {  343, 6202,   21213,  6, }, // Europe/Tirane
    {  343, 8882,   65470, 10, }, // Europe/Ulyanovsk
    {  343, 6567,   65480, 10, }, // Europe/Vatican
    {  343, 6231,   65490,  6, }, // Europe/Vienna
    {  343, 3190,   65496,  8, }, // Europe/Warsaw
    {  343, 5029,   65504,  7, }, // Indian/Comoro
    {  343, 7260,   27115,  4, }, // Indian/Mahe
    {  343, 4069,   65511,  7, }, // Indian/Mauritius
    {  343, 7211,   65518, 10, }, // Indian/Reunion
    {  343, 3157,     554,  5, }, // Pacific/Chuuk
    {  343, 2237,   65528, 13, }, // Pacific/Easter
    {  343, 7360,   27148,  5, }, // Pacific/Efate
    {  343, 3902,    4606,  5, }, // Pacific/Fiji
    {  343, 6678,   21277,  9, }, // Pacific/Galapagos
    {  343, 2723,    4611,  8, }, // Pacific/Honolulu
    {  343, 3049,    4619,  9, }, // Pacific/Kanton
    {  343, 4051,   65541,  9, }, // Pacific/Marquesas
    {  343, 7098,    4628,  6, }, // Pacific/Noumea
    {  343, 7155,   65550,  6, }, // Pacific/Palau
    {  343, 3096,     586,  7, }, // Pacific/Pohnpei
    {  344,   14,       0,  6, }, // Africa/Asmara Hausa/Latin/Nigeria
    {  344, 4435,       6,  8, }, // Africa/Sao_Tome
    {  344, 4252,      14,  8, }, // America/Asuncion
    {  344,  237,      22,  8, }, // America/Atikokan
    {  344, 7623,      30, 17, }, // America/Bahia_Banderas
    {  344, 3868,      47,  6, }, // America/Cancun
    {  344, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  344, 5723,      66,  7, }, // America/Curacao
    {  344,  481,      73, 13, }, // America/Indiana/Knox
    {  344, 7961,      86, 16, }, // America/Indiana/Marengo
    {  344, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  344, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  344, 8038,     139, 14, }, // America/Indiana/Vevay
    {  344, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  344, 8086,     171, 16, }, // America/Indiana/Winamac
    {  344, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  344, 5932,     207, 22, }, // America/Lower_Princes
    {  344, 8220,     229,  6, }, // America/Merida
    {  344, 1850,     235, 19, }, // America/Noronha
    {  344, 8301,   85224, 23, }, // America/North_Dakota/Beulah
    {  344, 8329,   85247, 23, }, // America/North_Dakota/Center
    {  344, 8357,   85270, 26, }, // America/North_Dakota/New_Salem
    {  344,  393,     317,  4, }, // America/Nuuk
    {  344, 6899,     321, 16, }, // America/Scoresbysund
    {  344, 8508,     337, 14, }, // America/St_Barthelemy
    {  344, 2061,     351, 10, }, // America/St_Johns
    {  344, 5863,     361,  9, }, // America/St_Kitts
    {  344, 5880,     370,  9, }, // America/St_Lucia
    {  344,  855,     379, 10, }, // America/St_Thomas
    {  344, 5913,     389, 11, }, // America/St_Vincent
    {  344, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  344, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  344, 1185,     448,  9, }, // Asia/Kathmandu
    {  344,  992,     457,  7, }, // Asia/Kolkata
    {  344, 1211,     464,  5, }, // Asia/Macau
    {  344, 1235,     477,  6, }, // Asia/Yangon
    {  344, 1395,     483,  5, }, // Atlantic/Faroe
    {  344, 6821,     488, 10, }, // Atlantic/St_Helena
    {  344, 2527,     514,  4, }, // Europe/Kyiv
    {  344, 7211,     547,  7, }, // Indian/Reunion
    {  344, 3157,     554,  5, }, // Pacific/Chuuk
    {  344, 3096,     586,  7, }, // Pacific/Pohnpei
    {  345, 8301,     254, 20, }, // America/North_Dakota/Beulah Hausa/Arabic/Nigeria
    {  345, 8329,     274, 20, }, // America/North_Dakota/Center
    {  345, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  346, 8301,     254, 20, }, // America/North_Dakota/Beulah Hausa/Arabic/Sudan
    {  346, 8329,     274, 20, }, // America/North_Dakota/Center
    {  346, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  349,   14,       0,  6, }, // Africa/Asmara Hawaiian/Latin/United States
    {  349, 4435,       6,  8, }, // Africa/Sao_Tome
    {  349, 4252,      14,  8, }, // America/Asuncion
    {  349,  237,      22,  8, }, // America/Atikokan
    {  349, 7623,      30, 17, }, // America/Bahia_Banderas
    {  349, 3868,      47,  6, }, // America/Cancun
    {  349, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  349, 5723,      66,  7, }, // America/Curacao
    {  349,  481,      73, 13, }, // America/Indiana/Knox
    {  349, 7961,      86, 16, }, // America/Indiana/Marengo
    {  349, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  349, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  349, 8038,     139, 14, }, // America/Indiana/Vevay
    {  349, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  349, 8086,     171, 16, }, // America/Indiana/Winamac
    {  349, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  349, 5932,     207, 22, }, // America/Lower_Princes
    {  349, 8220,     229,  6, }, // America/Merida
    {  349, 1850,     235, 19, }, // America/Noronha
    {  349, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  349, 8329,     274, 20, }, // America/North_Dakota/Center
    {  349, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  349,  393,     317,  4, }, // America/Nuuk
    {  349, 6899,     321, 16, }, // America/Scoresbysund
    {  349, 8508,     337, 14, }, // America/St_Barthelemy
    {  349, 2061,     351, 10, }, // America/St_Johns
    {  349, 5863,     361,  9, }, // America/St_Kitts
    {  349, 5880,     370,  9, }, // America/St_Lucia
    {  349,  855,     379, 10, }, // America/St_Thomas
    {  349, 5913,     389, 11, }, // America/St_Vincent
    {  349, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  349, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  349, 1185,     448,  9, }, // Asia/Kathmandu
    {  349,  992,     457,  7, }, // Asia/Kolkata
    {  349, 1211,     464,  5, }, // Asia/Macau
    {  349, 1235,     477,  6, }, // Asia/Yangon
    {  349, 1395,     483,  5, }, // Atlantic/Faroe
    {  349, 6821,     488, 10, }, // Atlantic/St_Helena
    {  349, 2527,     514,  4, }, // Europe/Kyiv
    {  349, 7211,     547,  7, }, // Indian/Reunion
    {  349, 3157,     554,  5, }, // Pacific/Chuuk
    {  349, 3096,     586,  7, }, // Pacific/Pohnpei
    {  350, 6788,   85296,  7, }, // Africa/Abidjan Hebrew/Hebrew/Israel
    {  350, 6760,   85303,  4, }, // Africa/Accra
    {  350, 5059,   85307,  9, }, // Africa/Addis_Ababa
    {  350, 7420,   85316,  6, }, // Africa/Algiers
    {  350,   14,   85322,  5, }, // Africa/Asmara
    {  350,   44,   85327,  5, }, // Africa/Bamako
    {  350, 5257,   85332,  6, }, // Africa/Bangui
    {  350, 6746,   85338,  6, }, // Africa/Banjul
    {  350, 7435,   85344,  5, }, // Africa/Bissau
    {  350, 4957,   85349,  6, }, // Africa/Blantyre
    {  350, 5287,   85355,  7, }, // Africa/Brazzaville
    {  350, 4922,   85362, 10, }, // Africa/Bujumbura
    {  350, 2320,   85372,  4, }, // Africa/Cairo
    {  350, 4117,   85376,  7, }, // Africa/Casablanca
    {  350, 7449,   85383,  5, }, // Africa/Ceuta
    {  350, 6773,   85388,  7, }, // Africa/Conakry
    {  350, 6840,   85395,  4, }, // Africa/Dakar
    {  350, 5130,   85399, 10, }, // Africa/Dar_es_Salaam
    {  350, 5043,   85409,  7, }, // Africa/Djibouti
    {  350, 5243,   85416,  5, }, // Africa/Douala
    {  350, 5166,   85421,  7, }, // Africa/El_Aaiun
    {  350, 6853,   85428,  7, }, // Africa/Freetown
    {  350, 4906,   85435,  7, }, // Africa/Gaborone
    {  350, 5015,   85442,  5, }, // Africa/Harare
    {  350, 4479,   85447,  9, }, // Africa/Johannesburg
    {  350, 4499,   85456,  5, }, // Africa/Juba
    {  350, 5151,   85461,  6, }, // Africa/Kampala
    {  350, 4524,   85467,  5, }, // Africa/Khartoum
    {  350, 4973,   85472,  5, }, // Africa/Kigali
    {  350, 5306,   85477,  6, }, // Africa/Kinshasa
    {  350, 4744,   85483,  5, }, // Africa/Lagos
    {  350, 5336,   85488,  8, }, // Africa/Libreville
    {  350, 6869,   85496,  4, }, // Africa/Lome
    {  350, 5211,   85500,  6, }, // Africa/Luanda
    {  350, 4939,   85506,  9, }, // Africa/Lubumbashi
    {  350, 5001,   85515,  5, }, // Africa/Lusaka
    {  350, 5322,   85520,  4, }, // Africa/Malabo
    {  350, 4987,   85524,  6, }, // Africa/Maputo
    {  350, 5197,   85530,  4, }, // Africa/Maseru
    {  350, 5182,   85534,  5, }, // Africa/Mbabane
    {  350, 5113,   85539,  7, }, // Africa/Mogadishu
    {  350, 7034,   85546,  8, }, // Africa/Monrovia
    {  350, 3853,   85554,  7, }, // Africa/Nairobi
    {  350, 5271,   85561,  6, }, // Africa/Ndjamena
    {  350, 5354,   85567,  6, }, // Africa/Niamey
    {  350, 6803,   85573,  8, }, // Africa/Nouakchott
    {  350, 6727,   85581,  9, }, // Africa/Ouagadougou
    {  350, 5225,   85590, 10, }, // Africa/Porto-Novo
    {  350, 4435,   85600,  8, }, // Africa/Sao_Tome
    {  350, 2866,   85608,  7, }, // Africa/Tripoli
    {  350, 6554,   85615,  5, }, // Africa/Tunis
    {  350, 4152,   85620,  7, }, // Africa/Windhoek
    {  350,  132,   85627,  4, }, // America/Adak
    {  350, 3346,   85631,  7, }, // America/Anchorage
    {  350, 5607,   85638,  8, }, // America/Anguilla
    {  350, 5624,   85646,  8, }, // America/Antigua
    {  350, 4554,   85654,  9, }, // America/Araguaina
    {  350,  166,   85663, 12, }, // America/Argentina/Buenos_Aires
    {  350,   91,   85675,  6, }, // America/Argentina/Catamarca
    {  350,  270,   85681,  7, }, // America/Argentina/Cordoba
    {  350,  441,   85688,  5, }, // America/Argentina/Jujuy
    {  350, 7462,   85693,  8, }, // America/Argentina/La_Rioja
    {  350,  565,   85701,  6, }, // America/Argentina/Mendoza
    {  350, 7489,   85707, 11, }, // America/Argentina/Rio_Gallegos
    {  350, 7520,   85718,  4, }, // America/Argentina/Salta
    {  350, 7544,   85722,  7, }, // America/Argentina/San_Juan
    {  350, 5580,   85729,  8, }, // America/Argentina/San_Luis
    {  350, 7571,   85737,  6, }, // America/Argentina/Tucuman
    {  350, 7597,   85743,  8, }, // America/Argentina/Ushuaia
    {  350, 5640,   85751,  5, }, // America/Aruba
    {  350, 4252,   85756,  8, }, // America/Asuncion
    {  350,  237,   85764,  7, }, // America/Atikokan
    {  350, 3679,   85771,  5, }, // America/Bahia
    {  350, 7623,   85776, 11, }, // America/Bahia_Banderas
    {  350, 5654,   85787,  6, }, // America/Barbados
    {  350, 7646,   85793,  3, }, // America/Belem
    {  350, 5407,   85796,  4, }, // America/Belize
    {  350, 7660,   85800, 10, }, // America/Blanc-Sablon
    {  350, 7681,   85810, 10, }, // America/Boa_Vista
    {  350, 4361,   85820,  6, }, // America/Bogota
    {  350, 7699,   85826,  5, }, // America/Boise
    {  350, 7713,   85831, 14, }, // America/Cambridge_Bay
    {  350, 7735,   85845, 10, }, // America/Campo_Grande
    {  350, 3868,   85855,  5, }, // America/Cancun
    {  350, 4694,   85860,  5, }, // America/Caracas
    {  350, 4345,   85865,  5, }, // America/Cayenne
    {  350, 5496,   85870,  5, }, // America/Cayman
    {  350, 2260,   85875,  5, }, // America/Chicago
    {  350, 7756,   85880,  9, }, // America/Chihuahua
    {  350, 7774,   85889, 11, }, // America/Ciudad_Juarez
    {  350, 5422,   85900, 10, }, // America/Costa_Rica
    {  350, 7796,   85910,  6, }, // America/Creston
    {  350, 3791,   85916,  6, }, // America/Cuiaba
    {  350, 5723,   85922,  7, }, // America/Curacao
    {  350, 7812,   85929, 10, }, // America/Danmarkshavn
    {  350, 7833,   85939,  5, }, // America/Dawson
    {  350, 7848,   85944, 10, }, // America/Dawson_Creek
    {  350,  805,   85954,  5, }, // America/Denver
    {  350, 3465,   85959,  6, }, // America/Detroit
    {  350, 5739,   85965,  8, }, // America/Dominica
    {  350,  893,   85973,  8, }, // America/Edmonton
    {  350, 7869,   85981,  7, }, // America/Eirunepe
    {  350, 5441,   85988,  9, }, // America/El_Salvador
    {  350, 7886,   85997, 10, }, // America/Fort_Nelson
    {  350, 7906,   86007,  8, }, // America/Fortaleza
    {  350, 7924,   86015,  9, }, // America/Glace_Bay
    {  350, 6881,   86024,  7, }, // America/Goose_Bay
    {  350, 4612,   86031,  9, }, // America/Grand_Turk
    {  350, 5770,   85850,  5, }, // America/Grenada
    {  350, 5786,   86040,  7, }, // America/Guadeloupe
    {  350, 3760,   86047,  7, }, // America/Guatemala
    {  350, 4841,   86054,  8, }, // America/Guayaquil
    {  350, 6932,   86062,  5, }, // America/Guyana
    {  350, 1939,   86067,  6, }, // America/Halifax
    {  350, 2281,   86073,  6, }, // America/Havana
    {  350, 7942,   86079,  7, }, // America/Hermosillo
    {  350,  348,   86086, 12, }, // America/Indiana/Indianapolis
    {  350,  481,   86098, 14, }, // America/Indiana/Knox
    {  350, 7961,   86112, 15, }, // America/Indiana/Marengo
    {  350, 7985,   86127, 19, }, // America/Indiana/Petersburg
    {  350, 8012,   86146, 17, }, // America/Indiana/Tell_City
    {  350, 8038,   86163, 17, }, // America/Indiana/Vevay
    {  350, 8060,   86180, 16, }, // America/Indiana/Vincennes
    {  350, 8086,   86196, 16, }, // America/Indiana/Winamac
    {  350, 8110,   86212,  7, }, // America/Inuvik
    {  350,  660,   86219,  8, }, // America/Iqaluit
    {  350, 2799,   86227,  7, }, // America/Jamaica
    {  350, 5380,   86234,  5, }, // America/Juneau
    {  350,  521,   86239,  8, }, // America/Kentucky/Louisville
    {  350, 8125,   86247, 17, }, // America/Kentucky/Monticello
    {  350, 5704,   86264,  8, }, // America/Kralendijk
    {  350, 4376,   86272,  6, }, // America/La_Paz
    {  350, 7169,   86278,  4, }, // America/Lima
    {  350, 3239,   86282, 10, }, // America/Los_Angeles
    {  350, 5932,   86292, 20, }, // America/Lower_Princes
    {  350, 8153,   86312,  6, }, // America/Maceio
    {  350, 8168,   86318,  6, }, // America/Managua
    {  350, 1908,   86324,  5, }, // America/Manaus
    {  350, 5897,   86329,  5, }, // America/Marigot
    {  350, 5805,   86334,  7, }, // America/Martinique
    {  350, 8184,   86341,  7, }, // America/Matamoros
    {  350, 2917,   86348,  5, }, // America/Mazatlan
    {  350, 8202,   86353,  7, }, // America/Menominee
    {  350, 8220,   86360,  5, }, // America/Merida
    {  350, 8235,   86365,  7, }, // America/Metlakatla
    {  350, 2949,   86372, 11, }, // America/Mexico_City
    {  350, 4391,   86383,  6, }, // America/Miquelon
    {  350, 8254,   86389,  7, }, // America/Moncton
    {  350, 8270,   86396,  7, }, // America/Monterrey
    {  350, 4098,   86403, 10, }, // America/Montevideo
    {  350, 5824,   86413,  7, }, // America/Montserrat
    {  350, 5481,   86420,  4, }, // America/Nassau
    {  350, 2379,   86424,  8, }, // America/New_York
    {  350, 8288,   86432,  3, }, // America/Nome
    {  350, 1850,   86435,  7, }, // America/Noronha
    {  350, 8301,   86442, 20, }, // America/North_Dakota/Beulah
    {  350, 8329,   86462, 19, }, // America/North_Dakota/Center
    {  350, 8357,   86481, 24, }, // America/North_Dakota/New_Salem
    {  350,  393,   86505,  5, }, // America/Nuuk
    {  350, 8388,   86510,  9, }, // America/Ojinaga
    {  350, 2356,   86519,  4, }, // America/Panama
    {  350, 6173,   86523,  7, }, // America/Paramaribo
    {  350, 2973,   86530,  6, }, // America/Phoenix
    {  350, 3945,   86536, 13, }, // America/Port-au-Prince
    {  350, 5954,   86549, 14, }, // America/Port_of_Spain
    {  350, 8404,   86563, 10, }, // America/Porto_Velho
    {  350, 5843,   86573, 11, }, // America/Puerto_Rico
    {  350, 4030,   86584, 10, }, // America/Punta_Arenas
    {  350, 8424,   86594, 11, }, // America/Rankin_Inlet
    {  350, 8445,   86605,  5, }, // America/Recife
    {  350, 1995,   86610,  6, }, // America/Regina
    {  350, 8460,   86616,  6, }, // America/Resolute
    {  350,  695,   86622,  9, }, // America/Rio_Branco
    {  350, 8477,   86631,  5, }, // America/Santarem
    {  350, 2201,   86636,  7, }, // America/Santiago
    {  350, 6111,   86643, 12, }, // America/Santo_Domingo
    {  350, 1878,   86655,  9, }, // America/Sao_Paulo
    {  350, 6899,   86664, 11, }, // America/Scoresbysund
    {  350, 8494,   86675,  5, }, // America/Sitka
    {  350, 8508,   86680, 10, }, // America/St_Barthelemy
    {  350, 2061,   86690,  9, }, // America/St_Johns
    {  350, 5863,   86699,  8, }, // America/St_Kitts
    {  350, 5880,   86707,  9, }, // America/St_Lucia
    {  350,  855,   86716,  9, }, // America/St_Thomas
    {  350, 5913,   86725, 10, }, // America/St_Vincent
    {  350, 8530,   86735, 11, }, // America/Swift_Current
    {  350, 5461,   86746,  9, }, // America/Tegucigalpa
    {  350, 5756,   86755,  4, }, // America/Thule
    {  350,  313,   86759,  7, }, // America/Tijuana
    {  350,  608,   86766,  7, }, // America/Toronto
    {  350, 5688,   86773,  7, }, // America/Tortola
    {  350, 2093,   86780,  6, }, // America/Vancouver
    {  350, 2144,   86786,  9, }, // America/Whitehorse
    {  350,  734,   86795,  7, }, // America/Winnipeg
    {  350, 8552,   86802,  6, }, // America/Yakutat
    {  350, 6001,   86808,  5, }, // Antarctica/Casey
    {  350, 6094,   86813,  6, }, // Antarctica/Davis
    {  350, 6133,   86819, 15, }, // Antarctica/DumontDUrville
    {  350, 8568,   86834,  7, }, // Antarctica/Macquarie
    {  350, 7066,   86841,  5, }, // Antarctica/Mawson
    {  350, 7113,   86846,  7, }, // Antarctica/McMurdo
    {  350, 8589,   86853,  5, }, // Antarctica/Palmer
    {  350, 7226,   86858,  6, }, // Antarctica/Rothera
    {  350, 7295,   86864,  6, }, // Antarctica/Syowa
    {  350, 8607,   86870,  4, }, // Antarctica/Troll
    {  350, 7374,   86874,  6, }, // Antarctica/Vostok
    {  350, 1429,   86880, 10, }, // Arctic/Longyearbyen
    {  350, 5570,   86890,  3, }, // Asia/Aden
    {  350, 5395,   86893,  6, }, // Asia/Almaty
    {  350, 3968,   86899,  4, }, // Asia/Amman
    {  350, 5511,   86903,  5, }, // Asia/Anadyr
    {  350, 5523,   86908,  5, }, // Asia/Aqtau
    {  350, 5368,   86913,  6, }, // Asia/Aqtobe
    {  350,  964,   86919,  5, }, // Asia/Ashgabat
    {  350, 8624,   86924,  6, }, // Asia/Atyrau
    {  350, 3607,   86930,  4, }, // Asia/Baghdad
    {  350, 5534,   86934,  6, }, // Asia/Bahrain
    {  350, 3653,   86940,  4, }, // Asia/Baku
    {  350, 4466,   86944,  6, }, // Asia/Bangkok
    {  350, 3571,   86950,  6, }, // Asia/Barnaul
    {  350, 4086,   86956,  6, }, // Asia/Beirut
    {  350, 3778,   86962,  5, }, // Asia/Bishkek
    {  350, 5989,   86967,  6, }, // Asia/Brunei
    {  350, 4601,   86973,  5, }, // Asia/Chita
    {  350, 4511,   86978,  7, }, // Asia/Colombo
    {  350, 4540,   86985,  4, }, // Asia/Damascus
    {  350, 1093,   86989,  4, }, // Asia/Dhaka
    {  350, 6192,   86993,  4, }, // Asia/Dili
    {  350, 3596,   86997,  5, }, // Asia/Dubai
    {  350, 6159,   87002,  6, }, // Asia/Dushanbe
    {  350, 8636,   87008,  7, }, // Asia/Famagusta
    {  350, 8651,   87015,  3, }, // Asia/Gaza
    {  350, 4795,   87018,  5, }, // Asia/Hebron
    {  350, 1259,   87023, 15, }, // Asia/Ho_Chi_Minh
    {  350, 2704,   87038,  9, }, // Asia/Hong_Kong
    {  350, 4771,   87047,  4, }, // Asia/Hovd
    {  350, 4184,   87051,  8, }, // Asia/Irkutsk
    {  350, 7006,   87059,  6, }, // Asia/Jakarta
    {  350, 6992,   87065,  9, }, // Asia/Jayapura
    {  350, 1290,   87074,  7, }, // Asia/Jerusalem
    {  350, 3560,   87081,  5, }, // Asia/Kabul
    {  350, 4316,   87086,  7, }, // Asia/Kamchatka
    {  350, 4239,   87093,  6, }, // Asia/Karachi
    {  350, 1185,   87099,  6, }, // Asia/Kathmandu
    {  350, 8661,   87105,  6, }, // Asia/Khandyga
    {  350,  992,   87111,  6, }, // Asia/Kolkata
    {  350, 4197,   87117, 10, }, // Asia/Krasnoyarsk
    {  350, 4859,   87127, 12, }, // Asia/Kuala_Lumpur
    {  350, 5976,   87139,  7, }, // Asia/Kuching
    {  350, 5547,   87146,  5, }, // Asia/Kuwait
    {  350, 1211,   87151,  4, }, // Asia/Macau
    {  350, 4017,   87155,  4, }, // Asia/Magadan
    {  350, 1349,   87159,  7, }, // Asia/Makassar
    {  350, 7182,   87166,  5, }, // Asia/Manila
    {  350, 6920,   87171,  5, }, // Asia/Muscat
    {  350, 2554,   87176,  7, }, // Asia/Nicosia
    {  350, 8675,   87183, 11, }, // Asia/Novokuznetsk
    {  350, 4135,   87194, 11, }, // Asia/Novosibirsk
    {  350, 4229,   87205,  5, }, // Asia/Omsk
    {  350, 7145,   87210,  4, }, // Asia/Oral
    {  350, 6961,   87214,  7, }, // Asia/Phnom_Penh
    {  350, 8693,   87221,  8, }, // Asia/Pontianak
    {  350, 4214,   87229,  9, }, // Asia/Pyongyang
    {  350, 5559,   87238,  4, }, // Asia/Qatar
    {  350, 8708,   87242,  7, }, // Asia/Qostanay
    {  350, 4269,   87249,  9, }, // Asia/Qyzylorda
    {  350, 3584,   87258,  4, }, // Asia/Riyadh
    {  350, 4408,   87262,  5, }, // Asia/Sakhalin
    {  350, 7245,   87267,  6, }, // Asia/Samarkand
    {  350, 3279,   87273,  5, }, // Asia/Seoul
    {  350, 1053,   87278,  5, }, // Asia/Shanghai
    {  350, 3300,   87283,  7, }, // Asia/Singapore
    {  350, 4297,   87290, 13, }, // Asia/Srednekolymsk
    {  350, 3263,   87303,  6, }, // Asia/Taipei
    {  350, 4781,   87309,  5, }, // Asia/Tashkent
    {  350, 3915,   87314,  7, }, // Asia/Tbilisi
    {  350, 2772,   87321,  4, }, // Asia/Tehran
    {  350, 1317,   87325,  7, }, // Asia/Thimphu
    {  350, 2821,   87332,  5, }, // Asia/Tokyo
    {  350, 4572,   87337,  5, }, // Asia/Tomsk
    {  350, 1021,   87342, 11, }, // Asia/Ulaanbaatar
    {  350, 1159,   87353,  7, }, // Asia/Urumqi
    {  350, 8722,   87360,  8, }, // Asia/Ust-Nera
    {  350, 6977,   87368,  8, }, // Asia/Vientiane
    {  350, 4710,   87376, 10, }, // Asia/Vladivostok
    {  350, 4828,   87386,  6, }, // Asia/Yakutsk
    {  350, 1235,   87392,  5, }, // Asia/Yangon
    {  350, 3883,   87397, 10, }, // Asia/Yekaterinburg
    {  350, 3747,   87407,  6, }, // Asia/Yerevan
    {  350, 3663,   87413, 14, }, // Atlantic/Azores
    {  350, 5671,   87427,  6, }, // Atlantic/Bermuda
    {  350, 6628,   87433, 13, }, // Atlantic/Canary
    {  350, 3727,   87446,  7, }, // Atlantic/Cape_Verde
    {  350, 1395,   87453,  4, }, // Atlantic/Faroe
    {  350, 8736,   87457,  6, }, // Atlantic/Madeira
    {  350, 2748,   87463, 10, }, // Atlantic/Reykjavik
    {  350, 7272,   87473, 13, }, // Atlantic/South_Georgia
    {  350, 6821,   87486,  8, }, // Atlantic/St_Helena
    {  350, 6644,   87494,  5, }, // Atlantic/Stanley
    {  350, 1670,   87499,  6, }, // Australia/Adelaide
    {  350, 1635,   87505,  8, }, // Australia/Brisbane
    {  350, 1799,   87513,  9, }, // Australia/Broken_Hill
    {  350, 1583,   87522,  6, }, // Australia/Darwin
    {  350, 3637,   87528,  5, }, // Australia/Eucla
    {  350, 1516,   87533,  5, }, // Australia/Hobart
    {  350, 8753,   87538,  6, }, // Australia/Lindeman
    {  350, 1547,   87544, 12, }, // Australia/Lord_Howe
    {  350, 1727,   87556,  6, }, // Australia/Melbourne
    {  350, 1762,   87562,  4, }, // Australia/Perth
    {  350, 1463,   87566,  5, }, // Australia/Sydney
    {  350, 6441,   87571,  7, }, // Europe/Amsterdam
    {  350, 6216,   87578,  6, }, // Europe/Andorra
    {  350, 3620,   87584,  6, }, // Europe/Astrakhan
    {  350, 2300,   87590,  5, }, // Europe/Athens
    {  350, 6336,   87595,  5, }, // Europe/Belgrade
    {  350, 4757,   87600,  5, }, // Europe/Berlin
    {  350, 6488,   87605,  8, }, // Europe/Bratislava
    {  350, 2167,   87613,  5, }, // Europe/Brussels
    {  350, 3928,   87618,  6, }, // Europe/Bucharest
    {  350, 3806,   87624,  6, }, // Europe/Budapest
    {  350, 8772,   87630,  7, }, // Europe/Busingen
    {  350, 2583,   87637,  6, }, // Europe/Chisinau
    {  350, 6289,   87643,  7, }, // Europe/Copenhagen
    {  350, 2338,   87650,  5, }, // Europe/Dublin
    {  350, 6307,   87655,  7, }, // Europe/Gibraltar
    {  350, 8788,   87662,  5, }, // Europe/Guernsey
    {  350, 6612,   87667,  7, }, // Europe/Helsinki
    {  350, 8804,   87674,  7, }, // Europe/Isle_of_Man
    {  350, 1130,   87681,  8, }, // Europe/Istanbul
    {  350, 8823,   87689,  5, }, // Europe/Jersey
    {  350, 3979,   87694,  9, }, // Europe/Kaliningrad
    {  350, 8929,   87703,  5, }, // Europe/Kirov
    {  350, 2527,   87708,  4, }, // Europe/Kyiv
    {  350, 3213,   87712,  6, }, // Europe/Lisbon
    {  350, 6506,   87718,  8, }, // Europe/Ljubljana
    {  350, 2501,   87726,  6, }, // Europe/London
    {  350, 6365,   87732,  9, }, // Europe/Luxembourg
    {  350, 4892,   87741,  5, }, // Europe/Madrid
    {  350, 6397,   87746,  4, }, // Europe/Malta
    {  350, 6582,   87750,  8, }, // Europe/Mariehamn
    {  350, 3693,   87758,  5, }, // Europe/Minsk
    {  350, 6410,   87763,  5, }, // Europe/Monaco
    {  350, 3537,   87768,  6, }, // Europe/Moscow
    {  350, 6458,   87774,  5, }, // Europe/Oslo
    {  350, 4284,   87779,  4, }, // Europe/Paris
    {  350, 6424,   87783,  9, }, // Europe/Podgorica
    {  350, 6275,   87792,  4, }, // Europe/Prague
    {  350, 8837,   87796,  4, }, // Europe/Riga
    {  350, 6324,   87800,  4, }, // Europe/Rome
    {  350, 4331,   85323,  4, }, // Europe/Samara
    {  350, 6470,   87804,  8, }, // Europe/San_Marino
    {  350, 6245,   87812,  6, }, // Europe/Sarajevo
    {  350, 4451,   87818,  6, }, // Europe/Saratov
    {  350, 8849,   87824,  9, }, // Europe/Simferopol
    {  350, 6383,   87833,  6, }, // Europe/Skopje
    {  350, 6599,   87839,  5, }, // Europe/Sofia
    {  350, 6523,   87844,  8, }, // Europe/Stockholm
    {  350, 8867,   87852,  5, }, // Europe/Tallinn
    {  350, 6202,   87857,  5, }, // Europe/Tirane
    {  350, 8882,   87862, 10, }, // Europe/Ulyanovsk
    {  350, 6352,   87872,  5, }, // Europe/Vaduz
    {  350, 6567,   87877,  7, }, // Europe/Vatican
    {  350, 6231,   87884,  4, }, // Europe/Vienna
    {  350, 8899,   87888,  5, }, // Europe/Vilnius
    {  350, 4727,   87893,  8, }, // Europe/Volgograd
    {  350, 3190,   87901,  4, }, // Europe/Warsaw
    {  350, 6261,   87905,  5, }, // Europe/Zagreb
    {  350, 6540,   87910,  5, }, // Europe/Zurich
    {  350, 5078,   87915,  9, }, // Indian/Antananarivo
    {  350, 6947,   87924,  6, }, // Indian/Chagos
    {  350, 6046,   87930, 11, }, // Indian/Christmas
    {  350, 6063,   87941,  5, }, // Indian/Cocos
    {  350, 5029,   87946,  6, }, // Indian/Comoro
    {  350, 6661,   87952,  7, }, // Indian/Kerguelen
    {  350, 7260,   87959,  3, }, // Indian/Mahe
    {  350, 7050,   87962, 15, }, // Indian/Maldives
    {  350, 4069,   87977,  9, }, // Indian/Mauritius
    {  350, 5098,   87986,  5, }, // Indian/Mayotte
    {  350, 7211,   87991,  7, }, // Indian/Reunion
    {  350, 4422,   87998,  4, }, // Pacific/Apia
    {  350,  932,   88002,  6, }, // Pacific/Auckland
    {  350, 3706,   88008,  8, }, // Pacific/Bougainville
    {  350, 3015,   88016,  7, }, // Pacific/Chatham
    {  350, 3157,   88023,  4, }, // Pacific/Chuuk
    {  350, 2237,   88027,  8, }, // Pacific/Easter
    {  350, 7360,   88035,  4, }, // Pacific/Efate
    {  350, 7327,   88039,  6, }, // Pacific/Fakaofo
    {  350, 3902,   88045,  5, }, // Pacific/Fiji
    {  350, 7343,   88050,  7, }, // Pacific/Funafuti
    {  350, 6678,   88057,  7, }, // Pacific/Galapagos
    {  350, 6696,   88064, 10, }, // Pacific/Gambier
    {  350, 3822,   88074,  9, }, // Pacific/Guadalcanal
    {  350, 6018,   88083,  4, }, // Pacific/Guam
    {  350, 2723,   88087,  8, }, // Pacific/Honolulu
    {  350, 3049,   88095,  8, }, // Pacific/Kanton
    {  350, 3998,   88103, 10, }, // Pacific/Kiritimati
    {  350, 7019,   88113,  5, }, // Pacific/Kosrae
    {  350, 2842,   88118, 10, }, // Pacific/Kwajalein
    {  350, 4877,   88128,  7, }, // Pacific/Majuro
    {  350, 4051,   88135,  9, }, // Pacific/Marquesas
    {  350, 8914,   88144,  7, }, // Pacific/Midway
    {  350, 7084,   88151,  5, }, // Pacific/Nauru
    {  350, 7132,   88156,  5, }, // Pacific/Niue
    {  350, 4168,   88161,  6, }, // Pacific/Norfolk
    {  350, 7098,   88167,  5, }, // Pacific/Noumea
    {  350, 3126,   88172,  9, }, // Pacific/Pago_Pago
    {  350, 7155,   88181,  4, }, // Pacific/Palau
    {  350, 7194,   88185,  6, }, // Pacific/Pitcairn
    {  350, 3096,   88191,  6, }, // Pacific/Pohnpei
    {  350, 4807,   88197, 11, }, // Pacific/Port_Moresby
    {  350, 6076,   88208,  9, }, // Pacific/Rarotonga
    {  350, 6031,   88217,  6, }, // Pacific/Saipan
    {  350, 7312,   88223,  5, }, // Pacific/Tahiti
    {  350, 6712,   88228,  7, }, // Pacific/Tarawa
    {  350, 4583,   88235,  8, }, // Pacific/Tongatapu
    {  350, 7392,   88243,  4, }, // Pacific/Wake
    {  350, 7405,   88247,  5, }, // Pacific/Wallis
    {  351, 6788,   29964,  7, }, // Africa/Abidjan Hindi/Devanagari/India
    {  351, 6760,   88252,  5, }, // Africa/Accra
    {  351, 5059,   88257, 10, }, // Africa/Addis_Ababa
    {  351, 7420,   88267,  9, }, // Africa/Algiers
    {  351,   14,   88276,  7, }, // Africa/Asmara
    {  351,   44,   88283,  6, }, // Africa/Bamako
    {  351, 5257,   88289,  6, }, // Africa/Bangui
    {  351, 6746,   88295,  6, }, // Africa/Banjul
    {  351, 7435,   88301,  5, }, // Africa/Bissau
    {  351, 4957,   88306,  9, }, // Africa/Blantyre
    {  351, 5287,   88315, 11, }, // Africa/Brazzaville
    {  351, 4922,   88326,  9, }, // Africa/Bujumbura
    {  351, 2320,   88335,  5, }, // Africa/Cairo
    {  351, 4117,   30065, 11, }, // Africa/Casablanca
    {  351, 7449,   88340,  5, }, // Africa/Ceuta
    {  351, 6773,   88345,  8, }, // Africa/Conakry
    {  351, 6840,   88353,  4, }, // Africa/Dakar
    {  351, 5130,   88357, 11, }, // Africa/Dar_es_Salaam
    {  351, 5043,   88368,  6, }, // Africa/Djibouti
    {  351, 5243,   88374,  5, }, // Africa/Douala
    {  351, 5166,   88379,  8, }, // Africa/El_Aaiun
    {  351, 6853,   88387,  9, }, // Africa/Freetown
    {  351, 4906,   88396,  7, }, // Africa/Gaborone
    {  351, 5015,   88403,  5, }, // Africa/Harare
    {  351, 4479,   88408, 10, }, // Africa/Johannesburg
    {  351, 4499,   30154,  4, }, // Africa/Juba
    {  351, 5151,   88418,  6, }, // Africa/Kampala
    {  351, 4524,   30166,  7, }, // Africa/Khartoum
    {  351, 4973,   88424,  6, }, // Africa/Kigali
    {  351, 5306,   88430,  7, }, // Africa/Kinshasa
    {  351, 4744,   88437,  5, }, // Africa/Lagos
    {  351, 5336,   88442, 10, }, // Africa/Libreville
    {  351, 6869,   88452,  3, }, // Africa/Lome
    {  351, 5211,   88455,  6, }, // Africa/Luanda
    {  351, 4939,   88461,  9, }, // Africa/Lubumbashi
    {  351, 5001,   30221,  6, }, // Africa/Lusaka
    {  351, 5322,   88470,  5, }, // Africa/Malabo
    {  351, 4987,   88475,  6, }, // Africa/Maputo
    {  351, 5197,   30239,  6, }, // Africa/Maseru
    {  351, 5182,   88481,  7, }, // Africa/Mbabane
    {  351, 5113,   88488,  8, }, // Africa/Mogadishu
    {  351, 7034,   88496,  9, }, // Africa/Monrovia
    {  351, 3853,   88505,  6, }, // Africa/Nairobi
    {  351, 5271,   88511, 10, }, // Africa/Ndjamena
    {  351, 5354,   88521,  6, }, // Africa/Niamey
    {  351, 6803,   88527,  7, }, // Africa/Nouakchott
    {  351, 6727,   88534,  7, }, // Africa/Ouagadougou
    {  351, 5225,   88541, 11, }, // Africa/Porto-Novo
    {  351, 4435,   88552,  7, }, // Africa/Sao_Tome
    {  351, 2866,   88559,  8, }, // Africa/Tripoli
    {  351, 6554,   30328,  7, }, // Africa/Tunis
    {  351, 4152,   88567,  7, }, // Africa/Windhoek
    {  351,  132,   88574,  3, }, // America/Adak
    {  351, 3346,   30347,  6, }, // America/Anchorage
    {  351, 5607,   88577,  8, }, // America/Anguilla
    {  351, 5624,   88585,  7, }, // America/Antigua
    {  351, 4554,   88592,  9, }, // America/Araguaina
    {  351,  166,   88601, 11, }, // America/Argentina/Buenos_Aires
    {  351,   91,   30390, 10, }, // America/Argentina/Catamarca
    {  351,  270,   88612,  8, }, // America/Argentina/Cordoba
    {  351,  441,   88620,  5, }, // America/Argentina/Jujuy
    {  351, 7462,   88625,  8, }, // America/Argentina/La_Rioja
    {  351,  565,   88633,  8, }, // America/Argentina/Mendoza
    {  351, 7489,   88641, 12, }, // America/Argentina/Rio_Gallegos
    {  351, 7520,   30437,  6, }, // America/Argentina/Salta
    {  351, 7544,   88653,  9, }, // America/Argentina/San_Juan
    {  351, 5580,   88662,  7, }, // America/Argentina/San_Luis
    {  351, 7571,   88669,  6, }, // America/Argentina/Tucuman
    {  351, 7597,   88675,  7, }, // America/Argentina/Ushuaia
    {  351, 5640,   88682,  5, }, // America/Aruba
    {  351, 4252,   88687,  8, }, // America/Asuncion
    {  351,  237,   88695,  8, }, // America/Atikokan
    {  351, 3679,   88703,  5, }, // America/Bahia
    {  351, 7623,   88708, 15, }, // America/Bahia_Banderas
    {  351, 5654,   88723,  8, }, // America/Barbados
    {  351, 7646,   30526,  5, }, // America/Belem
    {  351, 5407,   88731,  6, }, // America/Belize
    {  351, 7660,   88737, 13, }, // America/Blanc-Sablon
    {  351, 7681,   88750, 10, }, // America/Boa_Vista
    {  351, 4361,   88760,  6, }, // America/Bogota
    {  351, 7699,   88766,  5, }, // America/Boise
    {  351, 7713,   88771, 15, }, // America/Cambridge_Bay
    {  351, 7735,   88786, 13, }, // America/Campo_Grande
    {  351, 3868,   88799,  6, }, // America/Cancun
    {  351, 4694,   88805,  6, }, // America/Caracas
    {  351, 4345,   30609,  5, }, // America/Cayenne
    {  351, 5496,   30614,  5, }, // America/Cayman
    {  351, 2260,   88811,  6, }, // America/Chicago
    {  351, 7756,   88817,  8, }, // America/Chihuahua
    {  351, 7774,   88825, 16, }, // America/Ciudad_Juarez
    {  351, 5422,   88841, 11, }, // America/Costa_Rica
    {  351, 7796,   30642,  8, }, // America/Creston
    {  351, 3791,   88852,  7, }, // America/Cuiaba
    {  351, 5723,   88859,  7, }, // America/Curacao
    {  351, 7812,   88866, 11, }, // America/Danmarkshavn
    {  351, 7833,   88877,  4, }, // America/Dawson
    {  351, 7848,   88881, 10, }, // America/Dawson_Creek
    {  351,  805,   88891,  5, }, // America/Denver
    {  351, 3465,   88896,  8, }, // America/Detroit
    {  351, 5739,   88904,  8, }, // America/Dominica
    {  351,  893,   88912,  6, }, // America/Edmonton
    {  351, 7869,   30723,  7, }, // America/Eirunepe
    {  351, 5441,   88918, 11, }, // America/El_Salvador
    {  351, 7886,   88929, 13, }, // America/Fort_Nelson
    {  351, 7906,   88942, 12, }, // America/Fortaleza
    {  351, 7924,   88954, 11, }, // America/Glace_Bay
    {  351, 6881,   88965,  9, }, // America/Goose_Bay
    {  351, 4612,   88974, 11, }, // America/Grand_Turk
    {  351, 5770,   30789,  8, }, // America/Grenada
    {  351, 5786,   88985,  9, }, // America/Guadeloupe
    {  351, 3760,   30806, 10, }, // America/Guatemala
    {  351, 4841,   88994,  9, }, // America/Guayaquil
    {  351, 6932,   89003,  5, }, // America/Guyana
    {  351, 1939,   89008, 10, }, // America/Halifax
    {  351, 2281,   89018,  5, }, // America/Havana
    {  351, 7942,   89023, 11, }, // America/Hermosillo
    {  351,  348,   89034, 13, }, // America/Indiana/Indianapolis
    {  351,  481,   89047, 15, }, // America/Indiana/Knox
    {  351, 7961,   89062, 17, }, // America/Indiana/Marengo
    {  351, 7985,   89079, 20, }, // America/Indiana/Petersburg
    {  351, 8012,   89099, 18, }, // America/Indiana/Tell_City
    {  351, 8038,   89117, 14, }, // America/Indiana/Vevay
    {  351, 8060,   89131, 18, }, // America/Indiana/Vincennes
    {  351, 8086,   89149, 17, }, // America/Indiana/Winamac
    {  351, 8110,   30999,  6, }, // America/Inuvik
    {  351,  660,   89166,  7, }, // America/Iqaluit
    {  351, 2799,   89173,  5, }, // America/Jamaica
    {  351, 5380,   89178,  7, }, // America/Juneau
    {  351,  521,   89185,  8, }, // America/Kentucky/Louisville
    {  351, 8125,   89193, 17, }, // America/Kentucky/Monticello
    {  351, 5704,   89210, 12, }, // America/Kralendijk
    {  351, 4376,   89222,  7, }, // America/La_Paz
    {  351, 7169,   31064,  4, }, // America/Lima
    {  351, 3239,   89229, 11, }, // America/Los_Angeles
    {  351, 5932,   89240, 22, }, // America/Lower_Princes
    {  351, 8153,   89262,  5, }, // America/Maceio
    {  351, 8168,   89267,  7, }, // America/Managua
    {  351, 1908,   89274,  4, }, // America/Manaus
    {  351, 5897,   89278,  7, }, // America/Marigot
    {  351, 5805,   89285,  9, }, // America/Martinique
    {  351, 8184,   89294,  9, }, // America/Matamoros
    {  351, 2917,   89303,  9, }, // America/Mazatlan
    {  351, 8202,   89312,  8, }, // America/Menominee
    {  351, 8220,   31158,  6, }, // America/Merida
    {  351, 8235,   89320, 12, }, // America/Metlakatla
    {  351, 2949,   89332, 13, }, // America/Mexico_City
    {  351, 4391,   89345,  7, }, // America/Miquelon
    {  351, 8254,   89352,  6, }, // America/Moncton
    {  351, 8270,   89358,  9, }, // America/Monterrey
    {  351, 4098,   89367, 11, }, // America/Montevideo
    {  351, 5824,   89378,  9, }, // America/Montserrat
    {  351, 5481,   89387,  5, }, // America/Nassau
    {  351, 2379,   89392,  9, }, // America/New_York
    {  351, 8288,   89314,  3, }, // America/Nome
    {  351, 1850,   89401,  8, }, // America/Noronha
    {  351, 8301,   89409, 20, }, // America/North_Dakota/Beulah
    {  351, 8329,   89429, 19, }, // America/North_Dakota/Center
    {  351, 8357,   89448, 24, }, // America/North_Dakota/New_Salem
    {  351,  393,   89472,  3, }, // America/Nuuk
    {  351, 8388,   89475,  9, }, // America/Ojinaga
    {  351, 2356,   89484,  5, }, // America/Panama
    {  351, 6173,   89489, 10, }, // America/Paramaribo
    {  351, 2973,   89499,  8, }, // America/Phoenix
    {  351, 3945,   89507, 14, }, // America/Port-au-Prince
    {  351, 5954,   89521, 15, }, // America/Port_of_Spain
    {  351, 8404,   89536, 13, }, // America/Porto_Velho
    {  351, 5843,   89549, 11, }, // America/Puerto_Rico
    {  351, 4030,   89560, 12, }, // America/Punta_Arenas
    {  351, 8424,   89572, 12, }, // America/Rankin_Inlet
    {  351, 8445,   89584,  7, }, // America/Recife
    {  351, 1995,   31431,  6, }, // America/Regina
    {  351, 8460,   89591,  9, }, // America/Resolute
    {  351,  695,   89600, 12, }, // America/Rio_Branco
    {  351, 8477,   89612,  8, }, // America/Santarem
    {  351, 2201,   89620,  9, }, // America/Santiago
    {  351, 6111,   89629, 13, }, // America/Santo_Domingo
    {  351, 1878,   89642,  9, }, // America/Sao_Paulo
    {  351, 6899,   89651, 13, }, // America/Scoresbysund
    {  351, 8494,   89664,  6, }, // America/Sitka
    {  351, 8508,   89670, 15, }, // America/St_Barthelemy
    {  351, 2061,   89685,  9, }, // America/St_Johns
    {  351, 5863,   89694, 10, }, // America/St_Kitts
    {  351, 5880,   89704, 11, }, // America/St_Lucia
    {  351,  855,   89715,  9, }, // America/St_Thomas
    {  351, 5913,   89724, 12, }, // America/St_Vincent
    {  351, 8530,   89736, 13, }, // America/Swift_Current
    {  351, 5461,   89749, 11, }, // America/Tegucigalpa
    {  351, 5756,   89760,  6, }, // America/Thule
    {  351,  313,   89766,  7, }, // America/Tijuana
    {  351,  608,   89773,  6, }, // America/Toronto
    {  351, 5688,   89779,  8, }, // America/Tortola
    {  351, 2093,   89787,  7, }, // America/Vancouver
    {  351, 2144,   89794, 11, }, // America/Whitehorse
    {  351,  734,   89805,  7, }, // America/Winnipeg
    {  351, 8552,   89812,  7, }, // America/Yakutat
    {  351, 6001,   31673,  4, }, // Antarctica/Casey
    {  351, 6094,   89819,  5, }, // Antarctica/Davis
    {  351, 6133,   89824, 19, }, // Antarctica/DumontDUrville
    {  351, 8568,   89843,  7, }, // Antarctica/Macquarie
    {  351, 7066,   89850,  4, }, // Antarctica/Mawson
    {  351, 7113,   89854,  9, }, // Antarctica/McMurdo
    {  351, 8589,   89863,  4, }, // Antarctica/Palmer
    {  351, 7226,   89867,  6, }, // Antarctica/Rothera
    {  351, 7295,   89873,  6, }, // Antarctica/Syowa
    {  351, 8607,   89879,  5, }, // Antarctica/Troll
    {  351, 7374,   89884,  7, }, // Antarctica/Vostok
    {  351, 1429,   89891, 13, }, // Arctic/Longyearbyen
    {  351, 5570,   89904,  4, }, // Asia/Aden
    {  351, 5395,   89908,  7, }, // Asia/Almaty
    {  351, 3968,   89915,  6, }, // Asia/Amman
    {  351, 5511,   89921,  6, }, // Asia/Anadyr
    {  351, 5523,   31778,  6, }, // Asia/Aqtau
    {  351, 5368,   89927,  6, }, // Asia/Aqtobe
    {  351,  964,   31791,  8, }, // Asia/Ashgabat
    {  351, 8624,   89933,  5, }, // Asia/Atyrau
    {  351, 3607,   89938,  5, }, // Asia/Baghdad
    {  351, 5534,   89943,  5, }, // Asia/Bahrain
    {  351, 3653,   88857,  4, }, // Asia/Baku
    {  351, 4466,   89948,  6, }, // Asia/Bangkok
    {  351, 3571,   89954,  6, }, // Asia/Barnaul
    {  351, 4086,   89960,  5, }, // Asia/Beirut
    {  351, 3778,   31836,  7, }, // Asia/Bishkek
    {  351, 5989,   89965,  7, }, // Asia/Brunei
    {  351, 4601,   89972,  6, }, // Asia/Chita
    {  351, 4511,   89978,  6, }, // Asia/Colombo
    {  351, 4540,   89984,  7, }, // Asia/Damascus
    {  351, 1093,   89991,  4, }, // Asia/Dhaka
    {  351, 6192,   89995,  4, }, // Asia/Dili
    {  351, 3596,   89999,  4, }, // Asia/Dubai
    {  351, 6159,   90003,  7, }, // Asia/Dushanbe
    {  351, 8636,   90010, 11, }, // Asia/Famagusta
    {  351, 8651,   90021,  5, }, // Asia/Gaza
    {  351, 4795,   90026,  7, }, // Asia/Hebron
    {  351, 1259,   90033, 16, }, // Asia/Ho_Chi_Minh
    {  351, 2704,   90049,  9, }, // Asia/Hong_Kong
    {  351, 4771,   90058,  5, }, // Asia/Hovd
    {  351, 4184,   90063, 10, }, // Asia/Irkutsk
    {  351, 7006,   90073,  7, }, // Asia/Jakarta
    {  351, 6992,   31943,  7, }, // Asia/Jayapura
    {  351, 1290,   90080,  6, }, // Asia/Jerusalem
    {  351, 3560,   90086,  5, }, // Asia/Kabul
    {  351, 4316,   90091,  7, }, // Asia/Kamchatka
    {  351, 4239,   31972,  5, }, // Asia/Karachi
    {  351, 1185,   90098,  8, }, // Asia/Kathmandu
    {  351, 8661,   90106,  7, }, // Asia/Khandyga
    {  351,  992,   90113,  7, }, // Asia/Kolkata
    {  351, 4197,   90120, 15, }, // Asia/Krasnoyarsk
    {  351, 4859,   90135, 10, }, // Asia/Kuala_Lumpur
    {  351, 5976,   32028,  6, }, // Asia/Kuching
    {  351, 5547,   32034,  5, }, // Asia/Kuwait
    {  351, 1211,   90145,  4, }, // Asia/Macau
    {  351, 4017,   32044,  7, }, // Asia/Magadan
    {  351, 1349,   90149,  6, }, // Asia/Makassar
    {  351, 7182,   32060,  5, }, // Asia/Manila
    {  351, 6920,   90155,  5, }, // Asia/Muscat
    {  351, 2554,   90160,  8, }, // Asia/Nicosia
    {  351, 8675,   90168, 16, }, // Asia/Novokuznetsk
    {  351, 4135,   90184, 13, }, // Asia/Novosibirsk
    {  351, 4229,   90197,  6, }, // Asia/Omsk
    {  351, 7145,   90203,  3, }, // Asia/Oral
    {  351, 6961,   90206,  9, }, // Asia/Phnom_Penh
    {  351, 8693,   90215,  9, }, // Asia/Pontianak
    {  351, 4214,   90224, 10, }, // Asia/Pyongyang
    {  351, 5559,   90234,  3, }, // Asia/Qatar
    {  351, 8708,   90237,  8, }, // Asia/Qostanay
    {  351, 4269,   90245, 11, }, // Asia/Qyzylorda
    {  351, 3584,   90256,  5, }, // Asia/Riyadh
    {  351, 4408,   90261,  6, }, // Asia/Sakhalin
    {  351, 7245,   90267,  6, }, // Asia/Samarkand
    {  351, 3279,   90273,  4, }, // Asia/Seoul
    {  351, 1053,   90277,  5, }, // Asia/Shanghai
    {  351, 3300,   32190,  8, }, // Asia/Singapore
    {  351, 4297,   90282, 16, }, // Asia/Srednekolymsk
    {  351, 3263,   90298,  6, }, // Asia/Taipei
    {  351, 4781,   90304,  6, }, // Asia/Tashkent
    {  351, 3915,   90310,  7, }, // Asia/Tbilisi
    {  351, 2772,   32236,  6, }, // Asia/Tehran
    {  351, 1317,   90317,  5, }, // Asia/Thimphu
    {  351, 2821,   90322,  6, }, // Asia/Tokyo
    {  351, 4572,   90328,  7, }, // Asia/Tomsk
    {  351, 1021,   90335,  8, }, // Asia/Ulaanbaatar
    {  351, 1159,   90343,  7, }, // Asia/Urumqi
    {  351, 8722,   90350, 10, }, // Asia/Ust-Nera
    {  351, 6977,   90360,  9, }, // Asia/Vientiane
    {  351, 4710,   90369, 13, }, // Asia/Vladivostok
    {  351, 4828,   32305,  9, }, // Asia/Yakutsk
    {  351, 1235,   32314,  5, }, // Asia/Yangon
    {  351, 3883,   90382, 13, }, // Asia/Yekaterinburg
    {  351, 3747,   90395,  7, }, // Asia/Yerevan
    {  351, 3663,   90402,  7, }, // Atlantic/Azores
    {  351, 5671,   90409,  6, }, // Atlantic/Bermuda
    {  351, 6628,   90415,  6, }, // Atlantic/Canary
    {  351, 3727,   90421,  8, }, // Atlantic/Cape_Verde
    {  351, 1395,   90429,  5, }, // Atlantic/Faroe
    {  351, 8736,   90434,  5, }, // Atlantic/Madeira
    {  351, 2748,   90439,  9, }, // Atlantic/Reykjavik
    {  351, 7272,   90448, 15, }, // Atlantic/South_Georgia
    {  351, 6821,   90463, 11, }, // Atlantic/St_Helena
    {  351, 6644,   90474,  7, }, // Atlantic/Stanley
    {  351, 1670,   90481,  6, }, // Australia/Adelaide
    {  351, 1635,   90487,  8, }, // Australia/Brisbane
    {  351, 1799,   90495, 10, }, // Australia/Broken_Hill
    {  351, 1583,   90505,  7, }, // Australia/Darwin
    {  351, 3637,   32452,  6, }, // Australia/Eucla
    {  351, 1516,   90512,  7, }, // Australia/Hobart
    {  351, 8753,   90519,  8, }, // Australia/Lindeman
    {  351, 1547,   90527, 10, }, // Australia/Lord_Howe
    {  351, 1727,   90537,  8, }, // Australia/Melbourne
    {  351, 1762,   90545,  4, }, // Australia/Perth
    {  351, 1463,   32494,  5, }, // Australia/Sydney
    {  351, 6441,   90549, 10, }, // Europe/Amsterdam
    {  351, 6216,   90559,  6, }, // Europe/Andorra
    {  351, 3620,   90565, 10, }, // Europe/Astrakhan
    {  351, 2300,   90575,  5, }, // Europe/Athens
    {  351, 6336,   32532,  8, }, // Europe/Belgrade
    {  351, 4757,   90580,  6, }, // Europe/Berlin
    {  351, 6488,   90586, 12, }, // Europe/Bratislava
    {  351, 2167,   90598,  9, }, // Europe/Brussels
    {  351, 3928,   90607, 10, }, // Europe/Bucharest
    {  351, 3806,   90617,  9, }, // Europe/Budapest
    {  351, 8772,   90626, 10, }, // Europe/Busingen
    {  351, 2583,   90636,  7, }, // Europe/Chisinau
    {  351, 6289,   90643,  9, }, // Europe/Copenhagen
    {  351, 2338,   90652,  5, }, // Europe/Dublin
    {  351, 6307,   90657, 10, }, // Europe/Gibraltar
    {  351, 8788,   90667,  6, }, // Europe/Guernsey
    {  351, 6612,   90673,  8, }, // Europe/Helsinki
    {  351, 8804,   90681, 11, }, // Europe/Isle_of_Man
    {  351, 1130,   90692,  9, }, // Europe/Istanbul
    {  351, 8823,   90701,  5, }, // Europe/Jersey
    {  351, 3979,   90706, 12, }, // Europe/Kaliningrad
    {  351, 8929,   90718,  5, }, // Europe/Kirov
    {  351, 2527,   90723,  3, }, // Europe/Kyiv
    {  351, 3213,   32690,  6, }, // Europe/Lisbon
    {  351, 6506,   90726, 11, }, // Europe/Ljubljana
    {  351, 2501,   90737,  4, }, // Europe/London
    {  351, 6365,   90741, 10, }, // Europe/Luxembourg
    {  351, 4892,   90751,  7, }, // Europe/Madrid
    {  351, 6397,   32731,  6, }, // Europe/Malta
    {  351, 6582,   90758,  9, }, // Europe/Mariehamn
    {  351, 3693,   90767,  6, }, // Europe/Minsk
    {  351, 6410,   90773,  6, }, // Europe/Monaco
    {  351, 3537,   90779,  6, }, // Europe/Moscow
    {  351, 6458,   90785,  5, }, // Europe/Oslo
    {  351, 4284,   32766,  5, }, // Europe/Paris
    {  351, 6424,   90790, 10, }, // Europe/Podgorica
    {  351, 6275,   90800,  5, }, // Europe/Prague
    {  351, 8837,   90805,  4, }, // Europe/Riga
    {  351, 6324,   90432,  3, }, // Europe/Rome
    {  351, 4331,   90809,  5, }, // Europe/Samara
    {  351, 6470,   90814, 10, }, // Europe/San_Marino
    {  351, 6245,   90824,  8, }, // Europe/Sarajevo
    {  351, 4451,   90832,  7, }, // Europe/Saratov
    {  351, 8849,   90839, 12, }, // Europe/Simferopol
    {  351, 6383,   90851,  8, }, // Europe/Skopje
    {  351, 6599,   90859,  7, }, // Europe/Sofia
    {  351, 6523,   90866,  8, }, // Europe/Stockholm
    {  351, 8867,   90874,  5, }, // Europe/Tallinn
    {  351, 6202,   90879,  6, }, // Europe/Tirane
    {  351, 8882,   90885, 12, }, // Europe/Ulyanovsk
    {  351, 6352,   90897,  6, }, // Europe/Vaduz
    {  351, 6567,   90903,  6, }, // Europe/Vatican
    {  351, 6231,   90909,  5, }, // Europe/Vienna
    {  351, 8899,   90914,  8, }, // Europe/Vilnius
    {  351, 4727,   90922, 11, }, // Europe/Volgograd
    {  351, 3190,   90933,  5, }, // Europe/Warsaw
    {  351, 6261,   90938,  8, }, // Europe/Zagreb
    {  351, 6540,   90946,  9, }, // Europe/Zurich
    {  351, 5078,   90955, 11, }, // Indian/Antananarivo
    {  351, 6947,   90966,  5, }, // Indian/Chagos
    {  351, 6046,   90971,  7, }, // Indian/Christmas
    {  351, 6063,   90978,  5, }, // Indian/Cocos
    {  351, 5029,   90983,  6, }, // Indian/Comoro
    {  351, 6661,   90989,  7, }, // Indian/Kerguelen
    {  351, 7260,   32983,  4, }, // Indian/Mahe
    {  351, 7050,   90996,  6, }, // Indian/Maldives
    {  351, 4069,   91002,  6, }, // Indian/Mauritius
    {  351, 5098,   91008,  8, }, // Indian/Mayotte
    {  351, 7211,   91016,  8, }, // Indian/Reunion
    {  351, 4422,   91024,  5, }, // Pacific/Apia
    {  351,  932,   91029,  6, }, // Pacific/Auckland
    {  351, 3706,   91035,  8, }, // Pacific/Bougainville
    {  351, 3015,   91043,  4, }, // Pacific/Chatham
    {  351, 3157,   91047,  2, }, // Pacific/Chuuk
    {  351, 2237,   91049,  5, }, // Pacific/Easter
    {  351, 7360,   91054,  5, }, // Pacific/Efate
    {  351, 7327,   91059,  9, }, // Pacific/Fakaofo
    {  351, 3902,   91068,  5, }, // Pacific/Fiji
    {  351, 7343,   91073, 12, }, // Pacific/Funafuti
    {  351, 6678,   91085,  9, }, // Pacific/Galapagos
    {  351, 6696,   91094,  7, }, // Pacific/Gambier
    {  351, 3822,   91101, 10, }, // Pacific/Guadalcanal
    {  351, 6018,   31112,  4, }, // Pacific/Guam
    {  351, 2723,   91111,  8, }, // Pacific/Honolulu
    {  351, 3049,   91119,  7, }, // Pacific/Kanton
    {  351, 3998,   33132, 10, }, // Pacific/Kiritimati
    {  351, 7019,   91126,  6, }, // Pacific/Kosrae
    {  351, 2842,   91132, 10, }, // Pacific/Kwajalein
    {  351, 4877,   91142,  6, }, // Pacific/Majuro
    {  351, 4051,   91148,  8, }, // Pacific/Marquesas
    {  351, 8914,   91156,  5, }, // Pacific/Midway
    {  351, 7084,   91161,  4, }, // Pacific/Nauru
    {  351, 7132,   91165,  4, }, // Pacific/Niue
    {  351, 4168,   91169,  7, }, // Pacific/Norfolk
    {  351, 7098,   91176,  6, }, // Pacific/Noumea
    {  351, 3126,   91182,  9, }, // Pacific/Pago_Pago
    {  351, 7155,   91191,  4, }, // Pacific/Palau
    {  351, 7194,   33210,  8, }, // Pacific/Pitcairn
    {  351, 3096,   91195,  6, }, // Pacific/Pohnpei
    {  351, 4807,   91201, 14, }, // Pacific/Port_Moresby
    {  351, 6076,   91215,  9, }, // Pacific/Rarotonga
    {  351, 6031,   91224,  6, }, // Pacific/Saipan
    {  351, 7312,   91230,  6, }, // Pacific/Tahiti
    {  351, 6712,   91236,  6, }, // Pacific/Tarawa
    {  351, 4583,   91242,  9, }, // Pacific/Tongatapu
    {  351, 7392,   33268,  3, }, // Pacific/Wake
    {  351, 7405,   33271,  5, }, // Pacific/Wallis
    {  352,   14,   91251,  6, }, // Africa/Asmara Hindi/Latin/India
    {  352, 5225,   26542, 10, }, // Africa/Porto-Novo
    {  352, 4435,   91257,  8, }, // Africa/Sao_Tome
    {  352, 4252,   61453,  8, }, // America/Asuncion
    {  352,  237,   91265, 13, }, // America/Atikokan
    {  352, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  352, 7660,   44149, 12, }, // America/Blanc-Sablon
    {  352, 3868,   33314,  6, }, // America/Cancun
    {  352, 7774,   91278, 13, }, // America/Ciudad_Juarez
    {  352, 5723,   91291,  7, }, // America/Curacao
    {  352,  481,      73, 13, }, // America/Indiana/Knox
    {  352, 7961,      86, 16, }, // America/Indiana/Marengo
    {  352, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  352, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  352, 8038,     139, 14, }, // America/Indiana/Vevay
    {  352, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  352, 8086,     171, 16, }, // America/Indiana/Winamac
    {  352, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  352, 5932,     207, 22, }, // America/Lower_Princes
    {  352, 8220,    7126,  6, }, // America/Merida
    {  352, 1850,     235, 19, }, // America/Noronha
    {  352, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  352, 8329,     274, 20, }, // America/North_Dakota/Center
    {  352, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  352,  393,     317,  4, }, // America/Nuuk
    {  352, 6899,     321, 16, }, // America/Scoresbysund
    {  352, 8508,   91298, 13, }, // America/St_Barthelemy
    {  352, 2061,   60952,  9, }, // America/St_Johns
    {  352, 5863,   60961,  8, }, // America/St_Kitts
    {  352, 5880,   60969,  8, }, // America/St_Lucia
    {  352,  855,   60977,  9, }, // America/St_Thomas
    {  352, 5913,   60986, 10, }, // America/St_Vincent
    {  352, 6133,   91311, 14, }, // Antarctica/DumontDUrville
    {  352, 8568,     416, 16, }, // Antarctica/Macquarie
    {  352, 5523,   91325,  5, }, // Asia/Aqtau
    {  352, 1259,   91330,  6, }, // Asia/Ho_Chi_Minh
    {  352, 4771,   26835,  5, }, // Asia/Hovd
    {  352, 1185,     448,  9, }, // Asia/Kathmandu
    {  352,  992,     457,  7, }, // Asia/Kolkata
    {  352, 1211,    4321,  5, }, // Asia/Macau
    {  352, 8708,   91336,  8, }, // Asia/Qostanay
    {  352, 4269,   26897,  9, }, // Asia/Qyzylorda
    {  352, 1235,     477,  6, }, // Asia/Yangon
    {  352, 1395,   91344,  6, }, // Atlantic/Faroe
    {  352, 6821,   60996,  9, }, // Atlantic/St_Helena
    {  352, 1547,     498, 16, }, // Australia/Lord_Howe
    {  352, 2527,     514,  4, }, // Europe/Kyiv
    {  352, 6046,     518, 16, }, // Indian/Christmas
    {  352, 6063,     534, 13, }, // Indian/Cocos
    {  352, 7211,   91350,  7, }, // Indian/Reunion
    {  352, 3157,   91357,  4, }, // Pacific/Chuuk
    {  352, 2237,     559, 13, }, // Pacific/Easter
    {  352, 2723,    4611,  8, }, // Pacific/Honolulu
    {  352, 3049,    4619,  9, }, // Pacific/Kanton
    {  352, 4168,     572, 14, }, // Pacific/Norfolk
    {  352, 3096,    8429,  6, }, // Pacific/Pohnpei
    {  352, 7392,     593, 11, }, // Pacific/Wake
    {  353, 5059,   91361, 12, }, // Africa/Addis_Ababa Hungarian/Latin/Hungary
    {  353, 7420,   91373,  5, }, // Africa/Algiers
    {  353,   14,   91378,  7, }, // Africa/Asmara
    {  353, 2320,   91385,  5, }, // Africa/Cairo
    {  353, 5130,   91390, 13, }, // Africa/Dar_es_Salaam
    {  353, 5043,   91403,  8, }, // Africa/Djibouti
    {  353, 5166,   91411,  7, }, // Africa/El_Aaiun
    {  353, 4524,   91418,  6, }, // Africa/Khartoum
    {  353, 5322,   91424,  6, }, // Africa/Malabo
    {  353, 4435,       6,  8, }, // Africa/Sao_Tome
    {  353, 6554,   91430,  6, }, // Africa/Tunis
    {  353, 4554,   26559,  9, }, // America/Araguaina
    {  353,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  353, 7489,   44137, 12, }, // America/Argentina/Rio_Gallegos
    {  353, 7571,   20486,  7, }, // America/Argentina/Tucuman
    {  353, 4252,      14,  8, }, // America/Asuncion
    {  353,  237,      22,  8, }, // America/Atikokan
    {  353, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  353, 7646,   35896,  5, }, // America/Belem
    {  353, 4361,   20507,  6, }, // America/Bogota
    {  353, 3868,      47,  6, }, // America/Cancun
    {  353, 5496,   91436, 15, }, // America/Cayman
    {  353, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  353, 3791,   26574,  6, }, // America/Cuiaba
    {  353, 5723,      66,  7, }, // America/Curacao
    {  353, 5739,   21666,  8, }, // America/Dominica
    {  353, 7869,   26580,  8, }, // America/Eirunepe
    {  353, 5441,    6806,  8, }, // America/El_Salvador
    {  353, 2281,   63505,  7, }, // America/Havana
    {  353,  481,      73, 13, }, // America/Indiana/Knox
    {  353, 7961,      86, 16, }, // America/Indiana/Marengo
    {  353, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  353, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  353, 8038,     139, 14, }, // America/Indiana/Vevay
    {  353, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  353, 8086,     171, 16, }, // America/Indiana/Winamac
    {  353, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  353, 5932,     207, 22, }, // America/Lower_Princes
    {  353, 8153,   26588,  6, }, // America/Maceio
    {  353, 2917,   26603,  8, }, // America/Mazatlan
    {  353, 8220,     229,  6, }, // America/Merida
    {  353, 2949,   91451, 11, }, // America/Mexico_City
    {  353, 1850,     235, 19, }, // America/Noronha
    {  353, 8301,   91462, 20, }, // America/North_Dakota/Beulah
    {  353, 8329,   91482, 20, }, // America/North_Dakota/Center
    {  353, 8357,   91502, 23, }, // America/North_Dakota/New_Salem
    {  353,  393,     317,  4, }, // America/Nuuk
    {  353,  695,   74384, 10, }, // America/Rio_Branco
    {  353, 1878,   26712,  9, }, // America/Sao_Paulo
    {  353, 6899,     321, 16, }, // America/Scoresbysund
    {  353, 8508,   26721, 16, }, // America/St_Barthelemy
    {  353, 2061,     351, 10, }, // America/St_Johns
    {  353, 5863,     361,  9, }, // America/St_Kitts
    {  353, 5880,     370,  9, }, // America/St_Lucia
    {  353,  855,     379, 10, }, // America/St_Thomas
    {  353, 5913,     389, 11, }, // America/St_Vincent
    {  353, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  353, 7374,   91525,  7, }, // Antarctica/Vostok
    {  353, 5570,   91532,  4, }, // Asia/Aden
    {  353, 5395,   58773,  8, }, // Asia/Almaty
    {  353, 3968,   57924,  5, }, // Asia/Amman
    {  353, 5511,    7600,  6, }, // Asia/Anadyr
    {  353, 5523,    5609,  5, }, // Asia/Aqtau
    {  353, 5368,   63587,  6, }, // Asia/Aqtobe
    {  353,  964,   26803,  7, }, // Asia/Ashgabat
    {  353, 8624,    7612,  6, }, // Asia/Atyrau
    {  353, 3607,    4162,  6, }, // Asia/Baghdad
    {  353, 5534,    4168,  7, }, // Asia/Bahrain
    {  353, 4086,   57950,  6, }, // Asia/Beirut
    {  353, 3778,   91536,  6, }, // Asia/Bishkek
    {  353, 4601,   91542,  5, }, // Asia/Chita
    {  353, 4540,   91547, 10, }, // Asia/Damascus
    {  353, 1093,   91557,  5, }, // Asia/Dhaka
    {  353, 3596,   57968,  5, }, // Asia/Dubai
    {  353, 6159,   91562,  7, }, // Asia/Dushanbe
    {  353, 8651,   91569,  4, }, // Asia/Gaza
    {  353, 1259,   91573, 16, }, // Asia/Ho_Chi_Minh
    {  353, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  353, 4184,   91589,  8, }, // Asia/Irkutsk
    {  353, 1290,   91597, 10, }, // Asia/Jerusalem
    {  353, 4316,   91607,  9, }, // Asia/Kamchatka
    {  353, 4239,   91616,  7, }, // Asia/Karachi
    {  353, 1185,    5711,  8, }, // Asia/Kathmandu
    {  353, 8661,   33524,  7, }, // Asia/Khandyga
    {  353,  992,   64334,  8, }, // Asia/Kolkata
    {  353, 4197,   91623, 13, }, // Asia/Krasnoyarsk
    {  353, 5976,   91636,  7, }, // Asia/Kuching
    {  353, 5547,   63965,  6, }, // Asia/Kuwait
    {  353, 1211,   91643,  5, }, // Asia/Macau
    {  353, 4017,   20850,  7, }, // Asia/Magadan
    {  353, 1349,    7736,  7, }, // Asia/Makassar
    {  353, 6920,   91648,  7, }, // Asia/Muscat
    {  353, 8675,   91655, 12, }, // Asia/Novokuznetsk
    {  353, 4135,   91667, 13, }, // Asia/Novosibirsk
    {  353, 4229,   91680,  5, }, // Asia/Omsk
    {  353, 4214,   91685,  7, }, // Asia/Pyongyang
    {  353, 5559,    4332,  5, }, // Asia/Qatar
    {  353, 8708,   91692,  9, }, // Asia/Qostanay
    {  353, 4269,    7778,  9, }, // Asia/Qyzylorda
    {  353, 3584,   58079,  5, }, // Asia/Riyadh
    {  353, 4408,   91701,  8, }, // Asia/Sakhalin
    {  353, 7245,   91709, 10, }, // Asia/Samarkand
    {  353, 3279,   91719,  5, }, // Asia/Seoul
    {  353, 1053,   91724,  7, }, // Asia/Shanghai
    {  353, 3300,   91731,  9, }, // Asia/Singapore
    {  353, 4297,   91740, 15, }, // Asia/Srednekolymsk
    {  353, 3263,    7830,  6, }, // Asia/Taipei
    {  353, 4781,   91755,  7, }, // Asia/Tashkent
    {  353, 3915,   91762,  8, }, // Asia/Tbilisi
    {  353, 2772,   58125,  7, }, // Asia/Tehran
    {  353, 1317,   91770,  5, }, // Asia/Thimphu
    {  353, 2821,   91775,  5, }, // Asia/Tokyo
    {  353, 4572,   91780,  6, }, // Asia/Tomsk
    {  353, 1021,   91786,  9, }, // Asia/Ulaanbaatar
    {  353, 1159,   91795,  7, }, // Asia/Urumqi
    {  353, 8722,   91802, 11, }, // Asia/Ust-Nera
    {  353, 6977,   20929,  8, }, // Asia/Vientiane
    {  353, 4710,   91813, 13, }, // Asia/Vladivostok
    {  353, 4828,   91826,  8, }, // Asia/Yakutsk
    {  353, 1235,     477,  6, }, // Asia/Yangon
    {  353, 3883,   91834, 14, }, // Asia/Yekaterinburg
    {  353, 3747,   91848,  7, }, // Asia/Yerevan
    {  353, 3663,   91855, 14, }, // Atlantic/Azores
    {  353, 6628,   91869, 15, }, // Atlantic/Canary
    {  353, 3727,   91884, 18, }, // Atlantic/Cape_Verde
    {  353, 1395,   91902,  6, }, // Atlantic/Faroe
    {  353, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  353, 7272,   91908, 12, }, // Atlantic/South_Georgia
    {  353, 6821,   91920, 11, }, // Atlantic/St_Helena
    {  353, 6441,   91931, 10, }, // Europe/Amsterdam
    {  353, 3620,   91941,  9, }, // Europe/Astrakhan
    {  353, 2300,   58255,  5, }, // Europe/Athens
    {  353, 6336,   91950,  7, }, // Europe/Belgrade
    {  353, 6488,   91957,  7, }, // Europe/Bratislava
    {  353, 2167,   91964,  8, }, // Europe/Brussels
    {  353, 3928,   27029,  8, }, // Europe/Bucharest
    {  353, 8772,   27037,  8, }, // Europe/Busingen
    {  353, 6289,   91972, 10, }, // Europe/Copenhagen
    {  353, 6307,   91982,  9, }, // Europe/Gibraltar
    {  353, 8804,   91991, 10, }, // Europe/Isle_of_Man
    {  353, 1130,   92001,  9, }, // Europe/Istanbul
    {  353, 3979,   92010, 12, }, // Europe/Kaliningrad
    {  353, 2527,   33723,  5, }, // Europe/Kyiv
    {  353, 3213,   92022,  9, }, // Europe/Lisbon
    {  353, 6365,    4513,  9, }, // Europe/Luxembourg
    {  353, 6397,   92031,  5, }, // Europe/Malta
    {  353, 3693,   92036,  6, }, // Europe/Minsk
    {  353, 3537,   92042,  7, }, // Europe/Moscow
    {  353, 4284,   92049,  6, }, // Europe/Paris
    {  353, 6275,   92055,  5, }, // Europe/Prague
    {  353, 6324,   92060,  4, }, // Europe/Rome
    {  353, 4331,   92064,  7, }, // Europe/Samara
    {  353, 6245,   92071,  9, }, // Europe/Sarajevo
    {  353, 4451,   92080,  8, }, // Europe/Saratov
    {  353, 8849,   92088, 11, }, // Europe/Simferopol
    {  353, 6383,   92099,  7, }, // Europe/Skopje
    {  353, 6599,   92106,  6, }, // Europe/Sofia
    {  353, 8867,   22925,  6, }, // Europe/Tallinn
    {  353, 6202,   21213,  6, }, // Europe/Tirane
    {  353, 8882,   92112, 10, }, // Europe/Ulyanovsk
    {  353, 6567,   58354,  7, }, // Europe/Vatican
    {  353, 6231,   92122,  4, }, // Europe/Vienna
    {  353, 4727,   92126,  9, }, // Europe/Volgograd
    {  353, 3190,   92135,  5, }, // Europe/Warsaw
    {  353, 6261,   92140,  6, }, // Europe/Zagreb
    {  353, 6540,    4577,  6, }, // Europe/Zurich
    {  353, 6046,   92146, 16, }, // Indian/Christmas
    {  353, 6063,   92162, 13, }, // Indian/Cocos
    {  353, 5029,   92175,  6, }, // Indian/Comoro
    {  353, 7050,   92181, 15, }, // Indian/Maldives
    {  353, 7211,     547,  7, }, // Indian/Reunion
    {  353, 3015,   92196, 16, }, // Pacific/Chatham
    {  353, 3157,   91357,  4, }, // Pacific/Chuuk
    {  353, 2237,   92212, 15, }, // Pacific/Easter
    {  353, 3902,   92227,  6, }, // Pacific/Fiji
    {  353, 6678,   92233, 18, }, // Pacific/Galapagos
    {  353, 6696,   92251, 16, }, // Pacific/Gambier
    {  353, 2723,    4611,  8, }, // Pacific/Honolulu
    {  353, 3049,    4619,  9, }, // Pacific/Kanton
    {  353, 3998,   92267, 17, }, // Pacific/Kiritimati
    {  353, 7019,   92284, 15, }, // Pacific/Kosrae
    {  353, 2842,   92299, 16, }, // Pacific/Kwajalein
    {  353, 4877,   92315, 13, }, // Pacific/Majuro
    {  353, 4051,   92328, 18, }, // Pacific/Marquesas
    {  353, 8914,   92346, 15, }, // Pacific/Midway
    {  353, 7194,   92361, 17, }, // Pacific/Pitcairn
    {  353, 3096,   92378, 15, }, // Pacific/Pohnpei
    {  353, 7392,   92393, 11, }, // Pacific/Wake
    {  354, 7420,   92404, 11, }, // Africa/Algiers Icelandic/Latin/Iceland
    {  354,   14,       0,  6, }, // Africa/Asmara
    {  354, 7435,   92415,  5, }, // Africa/Bissau
    {  354, 2320,   92420,  5, }, // Africa/Cairo
    {  354, 5043,   92425,  7, }, // Africa/Djibouti
    {  354, 4479,   92432, 14, }, // Africa/Johannesburg
    {  354, 4435,   92446,  8, }, // Africa/Sao_Tome
    {  354, 2866,   92454,  7, }, // Africa/Tripoli
    {  354, 6554,   92461,  9, }, // Africa/Tunis
    {  354, 5607,   92470,  8, }, // America/Anguilla
    {  354, 5624,   92478,  7, }, // America/Antigua
    {  354, 5640,   92485,  5, }, // America/Aruba
    {  354, 4252,      14,  8, }, // America/Asuncion
    {  354,  237,      22,  8, }, // America/Atikokan
    {  354, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  354, 5407,   92490,  5, }, // America/Belize
    {  354, 3868,   92495,  6, }, // America/Cancun
    {  354, 5496,   92501, 12, }, // America/Cayman
    {  354, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  354, 5422,   92513,  9, }, // America/Costa_Rica
    {  354, 5723,      66,  7, }, // America/Curacao
    {  354, 5739,   92522,  8, }, // America/Dominica
    {  354, 5786,   92530,  8, }, // America/Guadeloupe
    {  354, 3760,   33338,  9, }, // America/Guatemala
    {  354, 6932,   92538,  7, }, // America/Guyana
    {  354,  481,      73, 13, }, // America/Indiana/Knox
    {  354, 7961,      86, 16, }, // America/Indiana/Marengo
    {  354, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  354, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  354, 8038,     139, 14, }, // America/Indiana/Vevay
    {  354, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  354, 8086,     171, 16, }, // America/Indiana/Winamac
    {  354, 2799,   92545,  7, }, // America/Jamaica
    {  354, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  354, 5932,     207, 22, }, // America/Lower_Princes
    {  354, 5805,   92552,  8, }, // America/Martinique
    {  354, 8220,    7126,  6, }, // America/Merida
    {  354, 2949,   92560, 10, }, // America/Mexico_City
    {  354, 1850,     235, 19, }, // America/Noronha
    {  354, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  354, 8329,     274, 20, }, // America/North_Dakota/Center
    {  354, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  354,  393,     317,  4, }, // America/Nuuk
    {  354, 5843,   92570, 11, }, // America/Puerto_Rico
    {  354, 6899,     321, 16, }, // America/Scoresbysund
    {  354, 8508,   92581, 25, }, // America/St_Barthelemy
    {  354, 2061,     351, 10, }, // America/St_Johns
    {  354, 5863,   92606, 12, }, // America/St_Kitts
    {  354, 5880,   92618, 12, }, // America/St_Lucia
    {  354,  855,   92630, 13, }, // America/St_Thomas
    {  354, 5913,   92643, 14, }, // America/St_Vincent
    {  354, 5688,   92657,  7, }, // America/Tortola
    {  354, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  354, 3607,    4162,  6, }, // Asia/Baghdad
    {  354, 5534,   63955,  6, }, // Asia/Bahrain
    {  354, 3653,   20747,  4, }, // Asia/Baku
    {  354, 4086,   92664,  6, }, // Asia/Beirut
    {  354, 5989,   92670,  6, }, // Asia/Brunei
    {  354, 4511,   92676,  7, }, // Asia/Colombo
    {  354, 4540,    4201,  8, }, // Asia/Damascus
    {  354, 1093,   91557,  5, }, // Asia/Dhaka
    {  354, 1259,   92683, 16, }, // Asia/Ho_Chi_Minh
    {  354, 7006,    4247,  8, }, // Asia/Jakarta
    {  354, 1290,   92699,  9, }, // Asia/Jerusalem
    {  354, 3560,   92708,  5, }, // Asia/Kabul
    {  354, 4316,    4261, 10, }, // Asia/Kamchatka
    {  354, 1185,   20830,  8, }, // Asia/Kathmandu
    {  354,  992,   92713,  8, }, // Asia/Kolkata
    {  354, 4859,   92721, 12, }, // Asia/Kuala_Lumpur
    {  354, 5547,   92733,  6, }, // Asia/Kuwait
    {  354, 1211,   91643,  5, }, // Asia/Macau
    {  354, 2554,   92739,  7, }, // Asia/Nicosia
    {  354, 4214,   33562,  9, }, // Asia/Pyongyang
    {  354, 5559,    4332,  5, }, // Asia/Qatar
    {  354, 8708,     469,  8, }, // Asia/Qostanay
    {  354, 3584,   92746,  5, }, // Asia/Riyadh
    {  354, 3279,   20896,  4, }, // Asia/Seoul
    {  354, 1053,   92751,  7, }, // Asia/Shanghai
    {  354, 3300,   92758,  8, }, // Asia/Singapore
    {  354, 2772,    7842,  7, }, // Asia/Tehran
    {  354, 2821,   92766,  5, }, // Asia/Tokyo
    {  354, 1021,   92771, 10, }, // Asia/Ulaanbaatar
    {  354, 1235,   20937,  6, }, // Asia/Yangon
    {  354, 3747,    7898,  7, }, // Asia/Yerevan
    {  354, 3663,   92781,  9, }, // Atlantic/Azores
    {  354, 5671,   92790,  7, }, // Atlantic/Bermuda
    {  354, 6628,   92797, 11, }, // Atlantic/Canary
    {  354, 3727,   92808, 14, }, // Atlantic/Cape_Verde
    {  354, 1395,   92822,  8, }, // Atlantic/Faroe
    {  354, 2748,   36176,  9, }, // Atlantic/Reykjavik
    {  354, 7272,   92830, 13, }, // Atlantic/South_Georgia
    {  354, 6821,   92843, 13, }, // Atlantic/St_Helena
    {  354, 2300,   92856,  5, }, // Europe/Athens
    {  354, 6336,   27015,  7, }, // Europe/Belgrade
    {  354, 4757,   21059,  6, }, // Europe/Berlin
    {  354, 2167,    4450,  7, }, // Europe/Brussels
    {  354, 3928,   92861,  8, }, // Europe/Bucharest
    {  354, 3806,   92869,  8, }, // Europe/Budapest
    {  354, 6289,   92877, 13, }, // Europe/Copenhagen
    {  354, 6307,   92890,  9, }, // Europe/Gibraltar
    {  354, 8804,   92899,  3, }, // Europe/Isle_of_Man
    {  354, 1130,   92902,  8, }, // Europe/Istanbul
    {  354, 2527,   92910, 10, }, // Europe/Kyiv
    {  354, 3213,    4499,  8, }, // Europe/Lisbon
    {  354, 2501,   92920,  8, }, // Europe/London
    {  354, 6365,   92928,  9, }, // Europe/Luxembourg
    {  354, 4892,   92937,  6, }, // Europe/Madrid
    {  354, 6582,   92943,  9, }, // Europe/Mariehamn
    {  354, 6410,   92952,  6, }, // Europe/Monaco
    {  354, 3537,   22880,  6, }, // Europe/Moscow
    {  354, 6458,   92958,  4, }, // Europe/Oslo
    {  354, 4284,   21180,  5, }, // Europe/Paris
    {  354, 6275,    8201,  4, }, // Europe/Prague
    {  354, 6324,   92060,  3, }, // Europe/Rome
    {  354, 6470,   92962, 10, }, // Europe/San_Marino
    {  354, 6245,   92972,  8, }, // Europe/Sarajevo
    {  354, 6599,   92980,  5, }, // Europe/Sofia
    {  354, 6523,   92985, 11, }, // Europe/Stockholm
    {  354, 6202,   92996,  6, }, // Europe/Tirane
    {  354, 6567,   93002,  9, }, // Europe/Vatican
    {  354, 6231,   93011,  3, }, // Europe/Vienna
    {  354, 8899,   93014,  7, }, // Europe/Vilnius
    {  354, 3190,   93021,  6, }, // Europe/Warsaw
    {  354, 6046,   93027,  6, }, // Indian/Christmas
    {  354, 6063,   93033, 10, }, // Indian/Cocos
    {  354, 7050,   93043, 11, }, // Indian/Maldives
    {  354, 4069,   93054,  8, }, // Indian/Mauritius
    {  354, 7211,     547,  7, }, // Indian/Reunion
    {  354, 3157,     554,  5, }, // Pacific/Chuuk
    {  354, 2237,   93062,  9, }, // Pacific/Easter
    {  354, 3902,   93071,  5, }, // Pacific/Fiji
    {  354, 6018,   63353,  4, }, // Pacific/Guam
    {  354, 2723,    4611,  8, }, // Pacific/Honolulu
    {  354, 3049,    4619,  9, }, // Pacific/Kanton
    {  354, 4051,   93076, 15, }, // Pacific/Marquesas
    {  354, 7084,   93091,  4, }, // Pacific/Nauru
    {  354, 7155,   93095,  4, }, // Pacific/Palau
    {  354, 3096,     586,  7, }, // Pacific/Pohnpei
    {  354, 7312,   93099,  6, }, // Pacific/Tahiti
    {  355,   14,       0,  6, }, // Africa/Asmara Ido/Latin/world
    {  355, 4435,       6,  8, }, // Africa/Sao_Tome
    {  355, 4252,      14,  8, }, // America/Asuncion
    {  355,  237,      22,  8, }, // America/Atikokan
    {  355, 7623,      30, 17, }, // America/Bahia_Banderas
    {  355, 3868,      47,  6, }, // America/Cancun
    {  355, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  355, 5723,      66,  7, }, // America/Curacao
    {  355,  481,      73, 13, }, // America/Indiana/Knox
    {  355, 7961,      86, 16, }, // America/Indiana/Marengo
    {  355, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  355, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  355, 8038,     139, 14, }, // America/Indiana/Vevay
    {  355, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  355, 8086,     171, 16, }, // America/Indiana/Winamac
    {  355, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  355, 5932,     207, 22, }, // America/Lower_Princes
    {  355, 8220,     229,  6, }, // America/Merida
    {  355, 1850,     235, 19, }, // America/Noronha
    {  355, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  355, 8329,     274, 20, }, // America/North_Dakota/Center
    {  355, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  355,  393,     317,  4, }, // America/Nuuk
    {  355, 6899,     321, 16, }, // America/Scoresbysund
    {  355, 8508,     337, 14, }, // America/St_Barthelemy
    {  355, 2061,     351, 10, }, // America/St_Johns
    {  355, 5863,     361,  9, }, // America/St_Kitts
    {  355, 5880,     370,  9, }, // America/St_Lucia
    {  355,  855,     379, 10, }, // America/St_Thomas
    {  355, 5913,     389, 11, }, // America/St_Vincent
    {  355, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  355, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  355, 1185,     448,  9, }, // Asia/Kathmandu
    {  355,  992,     457,  7, }, // Asia/Kolkata
    {  355, 1211,     464,  5, }, // Asia/Macau
    {  355, 1235,     477,  6, }, // Asia/Yangon
    {  355, 1395,     483,  5, }, // Atlantic/Faroe
    {  355, 6821,     488, 10, }, // Atlantic/St_Helena
    {  355, 2527,     514,  4, }, // Europe/Kyiv
    {  355, 7211,     547,  7, }, // Indian/Reunion
    {  355, 3157,     554,  5, }, // Pacific/Chuuk
    {  355, 3096,     586,  7, }, // Pacific/Pohnpei
    {  356,   14,       0,  6, }, // Africa/Asmara Igbo/Latin/Nigeria
    {  356, 4435,       6,  8, }, // Africa/Sao_Tome
    {  356, 4252,      14,  8, }, // America/Asuncion
    {  356,  237,      22,  8, }, // America/Atikokan
    {  356, 7623,      30, 17, }, // America/Bahia_Banderas
    {  356, 3868,      47,  6, }, // America/Cancun
    {  356, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  356, 5723,      66,  7, }, // America/Curacao
    {  356,  481,      73, 13, }, // America/Indiana/Knox
    {  356, 7961,      86, 16, }, // America/Indiana/Marengo
    {  356, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  356, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  356, 8038,     139, 14, }, // America/Indiana/Vevay
    {  356, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  356, 8086,     171, 16, }, // America/Indiana/Winamac
    {  356, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  356, 5932,     207, 22, }, // America/Lower_Princes
    {  356, 8220,     229,  6, }, // America/Merida
    {  356, 1850,     235, 19, }, // America/Noronha
    {  356, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  356, 8329,     274, 20, }, // America/North_Dakota/Center
    {  356, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  356,  393,     317,  4, }, // America/Nuuk
    {  356, 6899,     321, 16, }, // America/Scoresbysund
    {  356, 8508,     337, 14, }, // America/St_Barthelemy
    {  356, 2061,     351, 10, }, // America/St_Johns
    {  356, 5863,     361,  9, }, // America/St_Kitts
    {  356, 5880,     370,  9, }, // America/St_Lucia
    {  356,  855,     379, 10, }, // America/St_Thomas
    {  356, 5913,     389, 11, }, // America/St_Vincent
    {  356, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  356, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  356, 1185,     448,  9, }, // Asia/Kathmandu
    {  356,  992,     457,  7, }, // Asia/Kolkata
    {  356, 1211,     464,  5, }, // Asia/Macau
    {  356, 1235,     477,  6, }, // Asia/Yangon
    {  356, 1395,     483,  5, }, // Atlantic/Faroe
    {  356, 6821,     488, 10, }, // Atlantic/St_Helena
    {  356, 2527,     514,  4, }, // Europe/Kyiv
    {  356, 7211,     547,  7, }, // Indian/Reunion
    {  356, 3157,     554,  5, }, // Pacific/Chuuk
    {  356, 3049,    4619,  9, }, // Pacific/Kanton
    {  356, 3096,     586,  7, }, // Pacific/Pohnpei
    {  357,   14,       0,  6, }, // Africa/Asmara Inari Sami/Latin/Finland
    {  357, 4435,       6,  8, }, // Africa/Sao_Tome
    {  357, 4252,      14,  8, }, // America/Asuncion
    {  357,  237,      22,  8, }, // America/Atikokan
    {  357, 7623,      30, 17, }, // America/Bahia_Banderas
    {  357, 3868,      47,  6, }, // America/Cancun
    {  357, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  357, 5723,      66,  7, }, // America/Curacao
    {  357,  481,      73, 13, }, // America/Indiana/Knox
    {  357, 7961,      86, 16, }, // America/Indiana/Marengo
    {  357, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  357, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  357, 8038,     139, 14, }, // America/Indiana/Vevay
    {  357, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  357, 8086,     171, 16, }, // America/Indiana/Winamac
    {  357, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  357, 5932,     207, 22, }, // America/Lower_Princes
    {  357, 8220,     229,  6, }, // America/Merida
    {  357, 1850,     235, 19, }, // America/Noronha
    {  357, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  357, 8329,     274, 20, }, // America/North_Dakota/Center
    {  357, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  357,  393,     317,  4, }, // America/Nuuk
    {  357, 6899,     321, 16, }, // America/Scoresbysund
    {  357, 8508,     337, 14, }, // America/St_Barthelemy
    {  357, 2061,     351, 10, }, // America/St_Johns
    {  357, 5863,     361,  9, }, // America/St_Kitts
    {  357, 5880,     370,  9, }, // America/St_Lucia
    {  357,  855,     379, 10, }, // America/St_Thomas
    {  357, 5913,     389, 11, }, // America/St_Vincent
    {  357, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  357, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  357, 1185,     448,  9, }, // Asia/Kathmandu
    {  357,  992,     457,  7, }, // Asia/Kolkata
    {  357, 1211,     464,  5, }, // Asia/Macau
    {  357, 1235,     477,  6, }, // Asia/Yangon
    {  357, 1395,     483,  5, }, // Atlantic/Faroe
    {  357, 6821,     488, 10, }, // Atlantic/St_Helena
    {  357, 2527,     514,  4, }, // Europe/Kyiv
    {  357, 7211,     547,  7, }, // Indian/Reunion
    {  357, 3157,     554,  5, }, // Pacific/Chuuk
    {  357, 3096,     586,  7, }, // Pacific/Pohnpei
    {  358, 7420,   93105,  5, }, // Africa/Algiers Indonesian/Latin/Indonesia
    {  358,   14,       0,  6, }, // Africa/Asmara
    {  358, 2320,    4690,  5, }, // Africa/Cairo
    {  358, 4435,       6,  8, }, // Africa/Sao_Tome
    {  358, 5607,    4775,  7, }, // America/Anguilla
    {  358, 4252,      14,  8, }, // America/Asuncion
    {  358,  237,      22,  8, }, // America/Atikokan
    {  358, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  358, 3868,   33314,  6, }, // America/Cancun
    {  358, 7774,   91278, 13, }, // America/Ciudad_Juarez
    {  358, 5422,   21621, 10, }, // America/Costa_Rica
    {  358, 5723,      66,  7, }, // America/Curacao
    {  358, 5739,   21666,  8, }, // America/Dominica
    {  358,  481,      73, 13, }, // America/Indiana/Knox
    {  358, 7961,      86, 16, }, // America/Indiana/Marengo
    {  358, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  358, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  358, 8038,     139, 14, }, // America/Indiana/Vevay
    {  358, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  358, 8086,     171, 16, }, // America/Indiana/Winamac
    {  358, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  358, 5932,     207, 22, }, // America/Lower_Princes
    {  358, 5805,    5260,  8, }, // America/Martinique
    {  358, 8220,    7126,  6, }, // America/Merida
    {  358, 1850,     235, 19, }, // America/Noronha
    {  358, 8301,   93110, 20, }, // America/North_Dakota/Beulah
    {  358, 8329,   93130, 20, }, // America/North_Dakota/Center
    {  358, 8357,   93150, 23, }, // America/North_Dakota/New_Salem
    {  358,  393,     317,  4, }, // America/Nuuk
    {  358, 6899,     321, 16, }, // America/Scoresbysund
    {  358, 8508,     337, 14, }, // America/St_Barthelemy
    {  358, 2061,     351, 10, }, // America/St_Johns
    {  358, 5863,     361,  9, }, // America/St_Kitts
    {  358, 5880,     370,  9, }, // America/St_Lucia
    {  358,  855,     379, 10, }, // America/St_Thomas
    {  358, 5913,     389, 11, }, // America/St_Vincent
    {  358, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  358, 5523,    5609,  5, }, // Asia/Aqtau
    {  358, 5368,    7606,  6, }, // Asia/Aqtobe
    {  358, 4511,    5637,  7, }, // Asia/Colombo
    {  358, 4540,    4201,  8, }, // Asia/Damascus
    {  358, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  358, 1290,    5686,  9, }, // Asia/Jerusalem
    {  358, 1185,     448,  9, }, // Asia/Kathmandu
    {  358,  992,     457,  7, }, // Asia/Kolkata
    {  358, 1211,   33537,  5, }, // Asia/Macau
    {  358, 6920,    4326,  6, }, // Asia/Muscat
    {  358, 2554,    5738,  7, }, // Asia/Nicosia
    {  358, 8708,     469,  8, }, // Asia/Qostanay
    {  358, 3300,   93173,  9, }, // Asia/Singapore
    {  358, 2772,    7842,  7, }, // Asia/Tehran
    {  358, 1235,   58618,  7, }, // Asia/Yangon
    {  358, 3727,   93182, 13, }, // Atlantic/Cape_Verde
    {  358, 1395,     483,  5, }, // Atlantic/Faroe
    {  358, 7272,   93195, 15, }, // Atlantic/South_Georgia
    {  358, 6821,     488, 10, }, // Atlantic/St_Helena
    {  358, 2300,   93210,  6, }, // Europe/Athens
    {  358, 6336,    8060,  7, }, // Europe/Belgrade
    {  358, 2583,   93216,  8, }, // Europe/Chisinau
    {  358, 6289,    4475, 10, }, // Europe/Copenhagen
    {  358, 8804,   93224,  9, }, // Europe/Isle_of_Man
    {  358, 2527,    8148,  4, }, // Europe/Kyiv
    {  358, 6365,    8172, 10, }, // Europe/Luxembourg
    {  358, 6410,    6044,  6, }, // Europe/Monaco
    {  358, 3537,   93233,  6, }, // Europe/Moscow
    {  358, 6275,   36285,  5, }, // Europe/Prague
    {  358, 6324,    6064,  4, }, // Europe/Rome
    {  358, 6567,    6096,  7, }, // Europe/Vatican
    {  358, 6231,     171,  4, }, // Europe/Vienna
    {  358, 3190,   93239,  7, }, // Europe/Warsaw
    {  358, 5029,   22985,  6, }, // Indian/Comoro
    {  358, 7050,   93246,  8, }, // Indian/Maldives
    {  358, 7211,     547,  7, }, // Indian/Reunion
    {  358, 3157,     554,  5, }, // Pacific/Chuuk
    {  358, 3822,    8360, 11, }, // Pacific/Guadalcanal
    {  358, 2723,    4611,  8, }, // Pacific/Honolulu
    {  358, 3049,    4619,  9, }, // Pacific/Kanton
    {  358, 3096,     586,  7, }, // Pacific/Pohnpei
    {  359,   14,       0,  6, }, // Africa/Asmara Interlingua/Latin/world
    {  359, 5043,   26492,  7, }, // Africa/Djibouti
    {  359, 4435,       6,  8, }, // Africa/Sao_Tome
    {  359, 4252,      14,  8, }, // America/Asuncion
    {  359,  237,      22,  8, }, // America/Atikokan
    {  359, 7623,   64671, 17, }, // America/Bahia_Banderas
    {  359, 3868,   33314,  6, }, // America/Cancun
    {  359, 5496,   44173,  6, }, // America/Cayman
    {  359, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  359, 5723,      66,  7, }, // America/Curacao
    {  359,  481,      73, 13, }, // America/Indiana/Knox
    {  359, 7961,      86, 16, }, // America/Indiana/Marengo
    {  359, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  359, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  359, 8038,     139, 14, }, // America/Indiana/Vevay
    {  359, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  359, 8086,     171, 16, }, // America/Indiana/Winamac
    {  359, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  359, 5932,     207, 22, }, // America/Lower_Princes
    {  359, 5805,   20554,  9, }, // America/Martinique
    {  359, 8220,    7126,  6, }, // America/Merida
    {  359, 2949,   93254, 16, }, // America/Mexico_City
    {  359, 2379,   93270,  9, }, // America/New_York
    {  359, 1850,     235, 19, }, // America/Noronha
    {  359, 8301,   44203, 23, }, // America/North_Dakota/Beulah
    {  359, 8329,   44226, 23, }, // America/North_Dakota/Center
    {  359, 8357,   44249, 26, }, // America/North_Dakota/New_Salem
    {  359,  393,     317,  4, }, // America/Nuuk
    {  359, 5843,   64979, 10, }, // America/Puerto_Rico
    {  359, 6899,     321, 16, }, // America/Scoresbysund
    {  359, 8508,   93279, 18, }, // America/St_Barthelemy
    {  359, 2061,   93297, 28, }, // America/St_Johns
    {  359, 5863,   93325, 19, }, // America/St_Kitts
    {  359, 5880,   93344, 12, }, // America/St_Lucia
    {  359,  855,   93356, 13, }, // America/St_Thomas
    {  359, 5913,   93369, 15, }, // America/St_Vincent
    {  359, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  359, 5534,    4168,  7, }, // Asia/Bahrain
    {  359, 4540,   74438,  7, }, // Asia/Damascus
    {  359, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  359, 2704,    4231,  8, }, // Asia/Hong_Kong
    {  359, 1185,     448,  9, }, // Asia/Kathmandu
    {  359, 8661,   58020,  8, }, // Asia/Khandyga
    {  359,  992,   36053,  8, }, // Asia/Kolkata
    {  359, 1211,     464,  5, }, // Asia/Macau
    {  359, 4408,   58084,  8, }, // Asia/Sakhalin
    {  359, 1021,   26923, 10, }, // Asia/Ulaanbaatar
    {  359, 1235,     477,  6, }, // Asia/Yangon
    {  359, 3883,    7886, 12, }, // Asia/Yekaterinburg
    {  359, 6628,   74497,  8, }, // Atlantic/Canary
    {  359, 3727,   93384, 10, }, // Atlantic/Cape_Verde
    {  359, 1395,   20992,  5, }, // Atlantic/Faroe
    {  359, 6821,     488, 10, }, // Atlantic/St_Helena
    {  359, 2300,   93394,  7, }, // Europe/Athens
    {  359, 6336,   58906,  8, }, // Europe/Belgrade
    {  359, 2167,   57661,  9, }, // Europe/Brussels
    {  359, 3928,   21073,  8, }, // Europe/Bucharest
    {  359, 8772,   27037,  8, }, // Europe/Busingen
    {  359, 8804,   93401, 13, }, // Europe/Isle_of_Man
    {  359, 2527,    8148,  4, }, // Europe/Kyiv
    {  359, 3213,   93414,  7, }, // Europe/Lisbon
    {  359, 6365,    4513,  9, }, // Europe/Luxembourg
    {  359, 3537,   74590,  7, }, // Europe/Moscow
    {  359, 6275,   21185,  5, }, // Europe/Prague
    {  359, 6324,    6064,  4, }, // Europe/Rome
    {  359, 6202,   21213,  6, }, // Europe/Tirane
    {  359, 6567,   74624,  8, }, // Europe/Vatican
    {  359, 3190,   21244,  8, }, // Europe/Warsaw
    {  359, 6046,   93421,  5, }, // Indian/Christmas
    {  359, 7050,   74646,  8, }, // Indian/Maldives
    {  359, 4069,   93426,  8, }, // Indian/Mauritius
    {  359, 5098,   93434,  7, }, // Indian/Mayotte
    {  359, 7211,     547,  7, }, // Indian/Reunion
    {  359, 3157,     554,  5, }, // Pacific/Chuuk
    {  359, 2237,   93441,  6, }, // Pacific/Easter
    {  359, 6678,   21277,  9, }, // Pacific/Galapagos
    {  359, 3096,     586,  7, }, // Pacific/Pohnpei
    {  360, 5059,   64622, 11, }, // Africa/Addis_Ababa Interlingue/Latin/Estonia
    {  360, 7420,   44088,  5, }, // Africa/Algiers
    {  360,   14,       0,  6, }, // Africa/Asmara
    {  360, 5130,   93447, 13, }, // Africa/Dar_es_Salaam
    {  360, 5043,   26492,  7, }, // Africa/Djibouti
    {  360, 5166,   93460,  8, }, // Africa/El_Aaiun
    {  360, 4524,   26504,  7, }, // Africa/Khartoum
    {  360, 6727,   26534,  8, }, // Africa/Ouagadougou
    {  360, 4435,   93468,  8, }, // Africa/Sao_Tome
    {  360,  166,   93476, 12, }, // America/Argentina/Buenos_Aires
    {  360, 7462,   93488,  8, }, // America/Argentina/La_Rioja
    {  360, 7489,   93496, 12, }, // America/Argentina/Rio_Gallegos
    {  360, 7544,   93508,  9, }, // America/Argentina/San_Juan
    {  360, 5580,   93517,  9, }, // America/Argentina/San_Luis
    {  360, 4252,      14,  8, }, // America/Asuncion
    {  360,  237,      22,  8, }, // America/Atikokan
    {  360, 7623,   93526, 15, }, // America/Bahia_Banderas
    {  360, 7681,    6632,  9, }, // America/Boa_Vista
    {  360, 7713,   93541, 13, }, // America/Cambridge_Bay
    {  360, 7735,   93554, 12, }, // America/Campo_Grande
    {  360, 3868,      47,  6, }, // America/Cancun
    {  360, 7774,   93566, 13, }, // America/Ciudad_Juarez
    {  360, 5422,   93579, 10, }, // America/Costa_Rica
    {  360, 5723,      66,  7, }, // America/Curacao
    {  360, 7848,   93589, 12, }, // America/Dawson_Creek
    {  360, 5441,   93601, 11, }, // America/El_Salvador
    {  360, 7886,    6814, 11, }, // America/Fort_Nelson
    {  360, 7924,   93612,  9, }, // America/Glace_Bay
    {  360, 6881,   93621,  9, }, // America/Goose_Bay
    {  360, 4612,   93630, 10, }, // America/Grand_Turk
    {  360, 5786,   93640,  9, }, // America/Guadeloupe
    {  360,  481,      73, 13, }, // America/Indiana/Knox
    {  360, 7961,      86, 16, }, // America/Indiana/Marengo
    {  360, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  360, 8012,   93649, 18, }, // America/Indiana/Tell_City
    {  360, 8038,     139, 14, }, // America/Indiana/Vevay
    {  360, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  360, 8086,     171, 16, }, // America/Indiana/Winamac
    {  360, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  360, 4376,   93667,  6, }, // America/La_Paz
    {  360, 3239,   93673, 11, }, // America/Los_Angeles
    {  360, 5932,   93684, 22, }, // America/Lower_Princes
    {  360, 5805,   20554,  9, }, // America/Martinique
    {  360, 8220,     229,  6, }, // America/Merida
    {  360, 2949,   93706, 12, }, // America/Mexico_City
    {  360, 1850,     235, 19, }, // America/Noronha
    {  360, 8301,   93718, 19, }, // America/North_Dakota/Beulah
    {  360, 8329,   93737, 19, }, // America/North_Dakota/Center
    {  360, 8357,   93756, 22, }, // America/North_Dakota/New_Salem
    {  360,  393,     317,  4, }, // America/Nuuk
    {  360, 5954,   26691, 13, }, // America/Port_of_Spain
    {  360, 8404,    7301, 11, }, // America/Porto_Velho
    {  360, 5843,   93778, 10, }, // America/Puerto_Rico
    {  360, 4030,    7322, 12, }, // America/Punta_Arenas
    {  360, 8424,   93788, 12, }, // America/Rankin_Inlet
    {  360,  695,   93800, 10, }, // America/Rio_Branco
    {  360, 6111,   93810, 11, }, // America/Santo_Domingo
    {  360, 1878,   93821,  9, }, // America/Sao_Paulo
    {  360, 6899,     321, 16, }, // America/Scoresbysund
    {  360, 8508,   93830, 15, }, // America/St_Barthelemy
    {  360, 2061,   93845, 10, }, // America/St_Johns
    {  360, 5863,   93855,  9, }, // America/St_Kitts
    {  360, 5880,   93864,  9, }, // America/St_Lucia
    {  360,  855,   93873, 10, }, // America/St_Thomas
    {  360, 5913,   93883, 11, }, // America/St_Vincent
    {  360, 8530,   93894, 13, }, // America/Swift_Current
    {  360, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  360, 7295,   62201,  5, }, // Antarctica/Syowa
    {  360, 5395,    7594,  6, }, // Asia/Almaty
    {  360, 5523,    5609,  5, }, // Asia/Aqtau
    {  360, 5368,    7606,  6, }, // Asia/Aqtobe
    {  360, 8624,    7612,  6, }, // Asia/Atyrau
    {  360, 4540,   74438,  7, }, // Asia/Damascus
    {  360, 1259,   78157, 11, }, // Asia/Ho_Chi_Minh
    {  360, 2704,    7653,  9, }, // Asia/Hong_Kong
    {  360, 1185,     448,  9, }, // Asia/Kathmandu
    {  360,  992,     457,  7, }, // Asia/Kolkata
    {  360, 4859,    7707, 12, }, // Asia/Kuala_Lumpur
    {  360, 1211,     464,  5, }, // Asia/Macau
    {  360, 6961,   93907, 10, }, // Asia/Phnom_Penh
    {  360, 8708,     469,  8, }, // Asia/Qostanay
    {  360, 4269,    7778,  9, }, // Asia/Qyzylorda
    {  360, 3300,   20900,  8, }, // Asia/Singapore
    {  360, 2772,    7842,  7, }, // Asia/Tehran
    {  360, 2821,    4356,  5, }, // Asia/Tokyo
    {  360, 1235,     477,  6, }, // Asia/Yangon
    {  360, 6628,   74497,  7, }, // Atlantic/Canary
    {  360, 3727,   93917,  9, }, // Atlantic/Cape_Verde
    {  360, 1395,   20992,  5, }, // Atlantic/Faroe
    {  360, 7272,   93926, 11, }, // Atlantic/South_Georgia
    {  360, 6821,   93937, 11, }, // Atlantic/St_Helena
    {  360, 1799,   93948, 11, }, // Australia/Broken_Hill
    {  360, 1547,   93959, 15, }, // Australia/Lord_Howe
    {  360, 1762,   22735,  4, }, // Australia/Perth
    {  360, 2300,    5911,  4, }, // Europe/Athens
    {  360, 6336,   27015,  7, }, // Europe/Belgrade
    {  360, 2167,   57661,  9, }, // Europe/Brussels
    {  360, 3928,   93974,  9, }, // Europe/Bucharest
    {  360, 6289,   58657,  9, }, // Europe/Copenhagen
    {  360, 8804,   93983, 12, }, // Europe/Isle_of_Man
    {  360, 2527,    8148,  4, }, // Europe/Kyiv
    {  360, 3213,   21137,  6, }, // Europe/Lisbon
    {  360, 6365,    4513,  9, }, // Europe/Luxembourg
    {  360, 6410,   74584,  6, }, // Europe/Monaco
    {  360, 3537,   93995,  6, }, // Europe/Moscow
    {  360, 6275,   36285,  5, }, // Europe/Prague
    {  360, 6324,    6064,  4, }, // Europe/Rome
    {  360, 6470,    8214, 10, }, // Europe/San_Marino
    {  360, 6202,   21213,  6, }, // Europe/Tirane
    {  360, 3190,   58675,  8, }, // Europe/Warsaw
    {  360, 6540,    4577,  6, }, // Europe/Zurich
    {  360, 4069,   74654,  8, }, // Indian/Mauritius
    {  360, 7211,     547,  7, }, // Indian/Reunion
    {  360, 3157,     554,  5, }, // Pacific/Chuuk
    {  360, 2237,   94001,  5, }, // Pacific/Easter
    {  360, 3902,    4606,  5, }, // Pacific/Fiji
    {  360, 3126,    8413,  9, }, // Pacific/Pago_Pago
    {  360, 3096,     586,  7, }, // Pacific/Pohnpei
    {  360, 4807,   94006, 12, }, // Pacific/Port_Moresby
    {  361,   14,       0,  6, }, // Africa/Asmara Inuktitut/Canadian Aboriginal/Canada
    {  361, 4435,       6,  8, }, // Africa/Sao_Tome
    {  361, 4252,      14,  8, }, // America/Asuncion
    {  361,  237,      22,  8, }, // America/Atikokan
    {  361, 7623,      30, 17, }, // America/Bahia_Banderas
    {  361, 3868,      47,  6, }, // America/Cancun
    {  361, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  361, 5723,      66,  7, }, // America/Curacao
    {  361,  481,      73, 13, }, // America/Indiana/Knox
    {  361, 7961,      86, 16, }, // America/Indiana/Marengo
    {  361, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  361, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  361, 8038,     139, 14, }, // America/Indiana/Vevay
    {  361, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  361, 8086,     171, 16, }, // America/Indiana/Winamac
    {  361, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  361, 5932,     207, 22, }, // America/Lower_Princes
    {  361, 8220,     229,  6, }, // America/Merida
    {  361, 1850,     235, 19, }, // America/Noronha
    {  361, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  361, 8329,     274, 20, }, // America/North_Dakota/Center
    {  361, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  361,  393,     317,  4, }, // America/Nuuk
    {  361, 6899,     321, 16, }, // America/Scoresbysund
    {  361, 8508,     337, 14, }, // America/St_Barthelemy
    {  361, 2061,     351, 10, }, // America/St_Johns
    {  361, 5863,     361,  9, }, // America/St_Kitts
    {  361, 5880,     370,  9, }, // America/St_Lucia
    {  361,  855,     379, 10, }, // America/St_Thomas
    {  361, 5913,     389, 11, }, // America/St_Vincent
    {  361, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  361, 1259,     432, 11, }, // Asia/Ho_Chi_Minh
    {  361, 1185,     448,  9, }, // Asia/Kathmandu
    {  361,  992,     457,  7, }, // Asia/Kolkata
    {  361, 1211,     464,  5, }, // Asia/Macau
    {  361, 1235,     477,  6, }, // Asia/Yangon
    {  361, 1395,     483,  5, }, // Atlantic/Faroe
    {  361, 6821,     488, 10, }, // Atlantic/St_Helena
    {  361, 2527,     514,  4, }, // Europe/Kyiv
    {  361, 7211,     547,  7, }, // Indian/Reunion
    {  361, 3157,     554,  5, }, // Pacific/Chuuk
    {  361, 3096,     586,  7, }, // Pacific/Pohnpei
    {  363, 7420,   94018, 20, }, // Africa/Algiers Irish/Latin/Ireland
    {  363,   14,       0,  6, }, // Africa/Asmara
    {  363, 2320,   94038,  6, }, // Africa/Cairo
    {  363, 6773,   94044,  8, }, // Africa/Conakry
    {  363, 6840,   94052,  5, }, // Africa/Dakar
    {  363, 5130,   94057,  9, }, // Africa/Dar_es_Salaam
    {  363, 5166,   94066,  6, }, // Africa/El_Aaiun
    {  363, 4524,   94072,  6, }, // Africa/Khartoum
    {  363, 6869,   20418,  4, }, // Africa/Lome
    {  363, 4987,   94078,  6, }, // Africa/Maputo
    {  363, 5113,   94084, 10, }, // Africa/Mogadishu
    {  363, 6803,   94094,  7, }, // Africa/Nouakchott
    {  363, 4435,       6,  8, }, // Africa/Sao_Tome
    {  363, 2866,   94101,  7, }, // Africa/Tripoli
    {  363, 6554,   94108,  6, }, // Africa/Tunis
    {  363, 5607,   94114,  7, }, // America/Anguilla
    {  363,  270,   20479,  7, }, // America/Argentina/Cordoba
    {  363, 5640,   92485,  5, }, // America/Aruba
    {  363, 4252,      14,  8, }, // America/Asuncion
    {  363,  237,      22,  8, }, // America/Atikokan
    {  363, 7623,    3943, 14, }, // America/Bahia_Banderas
    {  363, 5654,   94121,  8, }, // America/Barbados
    {  363, 7646,   35896,  5, }, // America/Belem
    {  363, 5407,   94129, 10, }, // America/Belize
    {  363, 4361,   94139,  6, }, // America/Bogota
    {  363, 3868,      47,  6, }, // America/Cancun
    {  363, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  363, 5422,   94145, 10, }, // America/Costa_Rica
    {  363, 5723,   94155,  6, }, // America/Curacao
    {  363, 5739,   72822,  9, }, // America/Dominica
    {  363, 5441,   94161, 13, }, // America/El_Salvador
    {  363, 5770,   94174,  8, }, // America/Grenada
    {  363, 5786,   94182,  9, }, // America/Guadeloupe
    {  363, 3760,   72873,  9, }, // America/Guatemala
    {  363, 6932,   94191,  9, }, // America/Guyana
    {  363,  481,      73, 13, }, // America/Indiana/Knox
    {  363, 7961,      86, 16, }, // America/Indiana/Marengo
    {  363, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  363, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  363, 8038,     139, 14, }, // America/Indiana/Vevay
    {  363, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  363, 8086,     171, 16, }, // America/Indiana/Winamac
    {  363, 2799,   94200,  7, }, // America/Jamaica
    {  363, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  363, 7169,   94207,  5, }, // America/Lima
    {  363, 5932,     207, 22, }, // America/Lower_Princes
    {  363, 8220,    7126,  6, }, // America/Merida
    {  363, 2949,   94212, 18, }, // America/Mexico_City
    {  363, 5824,   72932,  9, }, // America/Montserrat
    {  363, 2379,   94230, 11, }, // America/New_York
    {  363, 1850,     235, 19, }, // America/Noronha
    {  363, 8301,     254, 20, }, // America/North_Dakota/Beulah
    {  363, 8329,     274, 20, }, // America/North_Dakota/Center
    {  363, 8357,     294, 23, }, // America/North_Dakota/New_Salem
    {  363,  393,     317,  4, }, // America/Nuuk
    {  363, 5843,   94241, 10, }, // America/Puerto_Rico
    {  363, 1878,   26712,  9, }, // America/Sao_Paulo
    {  363, 6899,     321, 16, }, // America/Scoresbysund
    {  363, 8508,   35936, 16, }, // America/St_Barthelemy
    {  363, 2061,     351, 10, }, // America/St_Johns
    {  363, 5863,   94251, 13, }, // America/St_Kitts
    {  363, 5880,   35964, 11, }, // America/St_Lucia
    {  363,  855,     379, 10, }, // America/St_Thomas
    {  363, 5913,   94264, 12, }, // America/St_Vincent
    {  363, 5756,   94276, 10, }, // America/Thule
    {  363, 6133,     400, 16, }, // Antarctica/DumontDUrville
    {  363, 8568,   94286, 10, }, // Antarctica/Macquarie
    {  363, 5570,   94296,  5, }, // Asia/Aden
    {  363, 3607,    4162,  6, }, // Asia/Baghdad
    {  363, 5534,   94301,  7, }, // Asia/Bahrain
    {  363, 3653,   94308,  4, }, // Asia/Baku
    {  363, 4086,   94312,  7, }, // Asia/Beirut
    {  363, 5989,   94319,  6, }, // Asia/Brunei
    {  363, 4540,   94325, 10, }, // Asia/Damascus
    {  363, 4795,   94335,  7, }, // Asia/Hebron
    {  363, 1259,   73091, 19, }, // Asia/Ho_Chi_Minh
    {  363, 2704,   94342,  9, }, // Asia/Hong_Kong
    {  363, 7006,   94351,  7, }, // Asia/Jakarta
    {  363, 1290,   94358, 11, }, // Asia/Jerusalem
    {  363, 3560,   94369,  5, }, // Asia/Kabul
    {  363, 1185,     448,  9, }, // Asia/Kathmandu
    {  363,  992,   94374,  7, }, // Asia/Kolkata
    {  363, 5547,   94381,  5, }, // Asia/Kuwait
    {  363, 1211,     464,  5, }, // Asia/Macau
    {  363, 1349,   94386,  7, }, // Asia/Makassar
    {  363, 7182,   94393,  7, }, // Asia/Manila
    {  363, 2554,   94400, 10, }, // Asia/Nicosia
    {  363, 5559,   73150,  5, }, // Asia/Qatar
    {  363, 8708,     469,  8, }, // Asia/Qostanay
    {  363, 3279,   94410,  3, }, // Asia/Seoul
    {  363, 1053,   94413,  9, }, // Asia/Shanghai
    {  363, 3300,   94422,  9, }, // Asia/Singapore
    {  363, 2821,   94431,  6, }, // Asia/Tokyo
    {  363, 4828,   94437,  7, }, // Asia/Yakutsk
    {  363, 1235,   20937,  6, }, // Asia/Yangon
    {  363, 3747,   94444,  8, }, // Asia/Yerevan
    {  363, 3663,   94452,  9, }, // Atlantic/Azores
    {  363, 5671,   94461,  9, }, // Atlantic/Bermuda
    {  363, 6628,   94470, 22, }, // Atlantic/Canary
    {  363, 3727,   94492, 10, }, // Atlantic/Cape_Verde
    {  363, 1395,   94502, 13, }, // Atlantic/Faroe
    {  363, 8736,   94515,  8, }, // Atlantic/Madeira
    {  363, 2748,   94523,  8, }, // Atlantic/Reykjavik
    {  363, 7272,   94531, 18, }, // Atlantic/South_Georgia
    {  363, 6821,   94549, 10, }, // Atlantic/St_Helena
    {  363, 6441,   94559,  9, }, // Europe/Amsterdam
    {  363, 6216,   94568,  6, }, // Europe/Andorra
    {  363, 3620,   94574, 12, }, // Europe/Astrakhan
    {  363, 2300,   94586,  9, }, // Europe/Athens
    {  363, 6336,   94595,  8, }, // Europe/Belgrade
    {  363, 4757,   94603,  7, }, // Europe/Berlin
    {  363, 6488,   94610, 14, }, // Europe/Bratislava
    {  363, 2167,   94624, 12, }, // Europe/Brussels
    {  363, 3928,   94636,  9, }, // Europe/Bucharest
    {  363, 3806,   94645, 10, }, // Europe/Budapest
    {  363, 2583,   94655,  7, }, // Europe/Chisinau
    {  363, 6289,   94662, 10, }, // Europe/Copenhagen
    {  363, 2338,   94672, 17, }, // Europe/Dublin
    {  363, 6307,   94689, 10, }, // Europe/Gibraltar
    {  363, 8788,   94699,  7, }, // Europe/Guernsey
    {  363, 6612,   94706,  9, }, // Europe/Helsinki
    {  363, 8804,   94715, 14, }, // Europe/Isle_of_Man
    {  363, 1130,   94729,  9, }, // Europe/Istanbul
    {  363, 8823,   94738,  6, }, // Europe/Jersey
    {  363, 2527,   94744,  3, }, // Europe/Kyiv
    {  363, 3213,   94747,  8, }, // Europe/Lisbon
    {  363, 6506,   94755, 10, }, // Europe/Ljubljana
    {  363, 2501,   94765,  7, }, // Europe/London
    {  363, 6365,   94772, 10, }, // Europe/Luxembourg
    {  363, 4892,   94782,  7, }, // Europe/Madrid
    {  363, 6397,   92031,  5, }, // Europe/Malta
    {  363, 3693,   94789,  6, }, // Europe/Minsk
    {  363, 6410,   94795,  6, }, // Europe/Monaco
    {  363, 3537,   94801,  5, }, // Europe/Moscow
    {  363, 6458,   92958,  4, }, // Europe/Oslo
    {  363, 4284,   94806,  5, }, // Europe/Paris
    {  363, 6424,   94811, 11, }, // Europe/Podgorica
    {  363, 6275,   92055,  4, }, // Europe/Prague
    {  363, 8837,   94822,  4, }, // Europe/Riga
    {  363, 6324,   94826,  8, }, // Europe/Rome
    {  363, 6470,   94834, 11, }, // Europe/San_Marino
    {  363, 6245,   94845,  8, }, // Europe/Sarajevo
    {  363, 6383,   94853,  6, }, // Europe/Skopje
    {  363, 6599,   94859,  6, }, // Europe/Sofia
    {  363, 6523,   94865,  7, }, // Europe/Stockholm
    {  363, 8867,   94872,  8, }, // Europe/Tallinn
    {  363, 6202,   94880,  7, }, // Europe/Tirane
    {  363, 6352,   94887,  5, }, // Europe/Vaduz
    {  363, 6567,   94892, 11, }, // Europe/Vatican
    {  363, 6231,   93011,  3, }, // Europe/Vienna
    {  363, 8899,   94903,  7, }, // Europe/Vilnius
    {  363, 3190,   94910,  5, }, // Europe/Warsaw
    {  363, 6261,   94915,  6, }, // Europe/Zagreb
    {  363, 6540,    4577,  6, }, // Europe/Zurich
    {  363, 5078,   94921, 14, }, // Indian/Antananarivo
    {  363, 6046,   94935, 16, }, // Indian/Christmas
    {  363, 6063,   94951, 12, }, // Indian/Cocos
    {  363, 5029,   94963, 15, }, // Indian/Comoro
    {  363, 7050,   94978, 17, }, // Indian/Maldives
    {  363, 4069,   94995, 14, }, // Indian/Mauritius
    {  363, 7211,   65518, 10, }, // Indian/Reunion
    {  363, 3157,     554,  5, }, // Pacific/Chuuk
    {  363, 3902,   95009,  5, }, // Pacific/Fiji
    {  363, 2723,    4611,  8, }, // Pacific/Honolulu
    {  363, 3049,    4619,  9, }, // Pacific/Kanton
    {  363, 4051,   95014, 23, }, // Pacific/Marquesas
    {  363, 8914,   95037, 14, }, // Pacific/Midway
    {  363, 7084,   93091,  4, }, // Pacific/Nauru
    {  363, 3096,     586,  7, }, // Pacific/Pohnpei
    {  363, 7312,   95051,  7, }, // Pacific/Tahiti
    {  363, 7405,   95058,  6, }, // Pacific/Wallis
    {  365, 5059,    3902, 11, }, // Africa/Addis_Ababa Italian/Latin/Italy
    {  365, 7420,   95064,  6, }, // Africa/Algiers
    {  365,   14,       0,  6, }, // Africa/Asmara
    {  365, 2320,   95070,  8, }, // Africa/Cairo
    {  365, 5043,   95078,  6, }, // Africa/Djibouti
    {  365, 5166,   95084,  7, }, // Africa/El_Aaiun
    {  365, 4499,   95091,  5, }, // Africa/Juba
    {  365, 4524,   26504,  7, }, // Africa/Khartoum
    {  365, 6869,   20418,  4, }, // Africa/Lome
    {  3