/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.RemoteBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationTarget;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPRemoteBrokerConnection
implements RemoteBrokerConnection {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REMOTE_BROKER_CONNECTION_RECORD = "REMOTE_BROKER_CONNECTION_RECORD";
    private List<AMQPFederationTarget> federations = new ArrayList<AMQPFederationTarget>();
    private final ActiveMQServer server;
    private final AMQPConnectionContext connection;
    private final String remoteNodeId;
    private final String remoteConnectionName;
    private State state = State.UNINITIALIZED;

    public AMQPRemoteBrokerConnection(ActiveMQServer server, AMQPConnectionContext connection, String remoteNodeId, String remoteConnectionName) {
        this.server = server;
        this.connection = connection;
        this.remoteNodeId = remoteNodeId;
        this.remoteConnectionName = remoteConnectionName;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public AMQPConnectionContext getConnection() {
        return this.connection;
    }

    public String getNodeId() {
        return this.remoteNodeId;
    }

    public String getName() {
        return this.remoteConnectionName;
    }

    public String getProtocol() {
        return "AMQP";
    }

    public boolean isManagable() {
        return this.remoteConnectionName != null && !this.remoteConnectionName.isBlank() && this.remoteNodeId != null && !this.remoteNodeId.isBlank();
    }

    public boolean isInitialized() {
        return this.state.ordinal() > State.UNINITIALIZED.ordinal();
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isShutdown() {
        return this.state == State.SHUTDOWN;
    }

    public synchronized void initialize() throws ActiveMQException {
        this.failIfShutdown();
        if (this.state == State.UNINITIALIZED) {
            this.state = State.STARTED;
            if (this.isManagable()) {
                try {
                    this.server.getManagementService().registerRemoteBrokerConnection((RemoteBrokerConnection)this);
                }
                catch (Exception e) {
                    logger.warn("Ignoring error while attempting to register remote broker connection with management services");
                }
            }
        }
    }

    public synchronized void shutdown() {
        if (this.state.ordinal() < State.SHUTDOWN.ordinal()) {
            this.state = State.SHUTDOWN;
            if (this.isManagable()) {
                try {
                    this.server.getManagementService().unregisterRemoteBrokerConnection(this.getNodeId(), this.getName());
                }
                catch (Exception e) {
                    logger.warn("Ignoring error while attempting to unregister remote broker connection with management services");
                }
            }
            this.federations.forEach(federation -> {
                try {
                    federation.shutdown();
                }
                catch (ActiveMQException e) {
                    logger.warn("Exception suppressed on remote broker federation shutdown: ", (Throwable)e);
                }
            });
        }
    }

    public synchronized AMQPRemoteBrokerConnection addFederationTarget(AMQPFederationTarget federation) throws ActiveMQException {
        this.failIfShutdown();
        if (this.isStarted()) {
            federation.start();
        }
        this.federations.add(federation);
        return this;
    }

    public static AMQPRemoteBrokerConnection getOrCreateRemoteBrokerConnection(ActiveMQServer server, AMQPConnectionContext connection, Connection protonConnection) throws ActiveMQException {
        Record attachments = protonConnection.attachments();
        AMQPRemoteBrokerConnection brokerConnection = (AMQPRemoteBrokerConnection)attachments.get((Object)REMOTE_BROKER_CONNECTION_RECORD, AMQPRemoteBrokerConnection.class);
        if (brokerConnection == null) {
            Map connectionProperties = protonConnection.getRemoteProperties() != null ? protonConnection.getRemoteProperties() : Collections.EMPTY_MAP;
            Map brokerConnectionInfo = connectionProperties.getOrDefault(AMQPBrokerConnectionConstants.BROKER_CONNECTION_INFO, Collections.EMPTY_MAP);
            ActiveMQProtonRemotingConnection remoteingConnection = connection.getConnectionCallback().getProtonConnectionDelegate();
            String remoteNodeId = (String)brokerConnectionInfo.get("nodeId");
            String remoteConnectionName = (String)brokerConnectionInfo.get("connectionName");
            final AMQPRemoteBrokerConnection newBrokerConnection = brokerConnection = new AMQPRemoteBrokerConnection(server, connection, remoteNodeId, remoteConnectionName);
            brokerConnection.initialize();
            remoteingConnection.addCloseListener(() -> AMQPRemoteBrokerConnection.handleConnectionShutdown(newBrokerConnection));
            remoteingConnection.addFailureListener(new FailureListener(){

                public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                    AMQPRemoteBrokerConnection.handleConnectionShutdown(newBrokerConnection);
                }

                public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                    AMQPRemoteBrokerConnection.handleConnectionShutdown(newBrokerConnection);
                }
            });
            attachments.set((Object)REMOTE_BROKER_CONNECTION_RECORD, AMQPRemoteBrokerConnection.class, (Object)brokerConnection);
        }
        return brokerConnection;
    }

    private static void handleConnectionShutdown(AMQPRemoteBrokerConnection connection) {
        try {
            connection.shutdown();
        }
        catch (Exception e) {
            logger.warn("Exception suppressed on remote broker connection shutdown: ", (Throwable)e);
        }
    }

    private void failIfShutdown() throws ActiveMQIllegalStateException {
        if (this.state == State.SHUTDOWN) {
            throw new ActiveMQIllegalStateException("The remote broker connection instance has been shutdown");
        }
    }

    private static enum State {
        UNINITIALIZED,
        STARTED,
        SHUTDOWN;

    }
}

