/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.NameFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(list);
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(IOCase.INSENSITIVE, list);
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1.txt");
        list.add("test2.txt");
        NameFileFilter filter = new NameFileFilter(IOCase.SENSITIVE, list);
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() {
        NameFileFilter filter = new NameFileFilter(new String[]{"test1.txt"});
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() {
        NameFileFilter filter = new NameFileFilter(IOCase.INSENSITIVE, new String[]{"test2.txt"});
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() {
        NameFileFilter filter = new NameFileFilter(IOCase.SENSITIVE, new String[]{"test2.txt"});
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("Test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(NameFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

