/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class AccessMgrRestImpl
extends Manageable
implements AccessMgr {
    private static final String CLS_NM = AccessMgrRestImpl.class.getName();

    @Override
    public Session authenticate(String userId, String password) throws SecurityException {
        VUtil.assertNotNullOrEmpty(userId, 1006, CLS_NM + ".authenticate");
        VUtil.assertNotNullOrEmpty(password, 1009, ".authenticate");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(new User(userId, password));
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacAuthN");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session retSession = response.getSession();
        return retSession;
    }

    @Override
    public Session createSession(User user, boolean isTrusted) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".createSession");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = isTrusted ? RestUtils.getInstance().post(szRequest, "rbacCreateT") : RestUtils.getInstance().post(szRequest, "rbacCreate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session retSession = response.getSession();
        return retSession;
    }

    @Override
    public Session createSession(User user, List<RoleConstraint> constraints, boolean isTrusted) throws SecurityException {
        VUtil.assertNotNull(constraints, 5102, CLS_NM + ".createSession");
        for (RoleConstraint constraint : constraints) {
            user.addProperty(constraint.getKey(), constraint.getValue());
        }
        return this.createSession(user, isTrusted);
    }

    @Override
    public Session createSession(Group group) throws SecurityException {
        VUtil.assertNotNull(group, 10308, CLS_NM + ".createSession");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(group);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacCreateGroup");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session retSession = response.getSession();
        return retSession;
    }

    @Override
    public boolean checkAccess(Session session, Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3008, CLS_NM + ".checkAccess");
        VUtil.assertNotNull(session, 1030, CLS_NM + ".checkAccess");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacAuthZ");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public boolean checkAccess(User user, Permission perm, boolean isTrusted) throws SecurityException {
        VUtil.assertNotNull(perm, 3008, CLS_NM + ".checkAccess");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".checkAccess");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity2(user);
        request.setEntity(perm);
        request.setIsFlag(isTrusted);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacCheck");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        return result;
    }

    @Override
    public boolean isUserInRole(User user, Role role, boolean isTrusted) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".isUserInRole");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".isUserInRole");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity2(user);
        request.setEntity(role);
        request.setIsFlag(isTrusted);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacCheckRole");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        return result;
    }

    @Override
    public List<Permission> sessionPermissions(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".sessionPermissions");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacPerms");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        Session outSession = response.getSession();
        session.copy(outSession);
        return retPerms;
    }

    @Override
    public List<UserRole> sessionRoles(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".sessionRoles");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserRole> retRoles = response.getEntities();
        Session outSession = response.getSession();
        session.copy(outSession);
        return retRoles;
    }

    @Override
    public Set<String> authorizedRoles(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".sessionRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacAuthzRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        Session outSession = response.getSession();
        session.copy(outSession);
        return retRoleNames;
    }

    @Override
    public void addActiveRole(Session session, UserRole role) throws SecurityException {
        String fullMethodName = CLS_NM + ".addActiveRole";
        VUtil.assertNotNull(session, 1030, fullMethodName);
        VUtil.assertNotNull(role, 5007, fullMethodName);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session outSession = response.getSession();
        session.copy(outSession);
    }

    @Override
    public void dropActiveRole(Session session, UserRole role) throws SecurityException {
        String fullMethodName = ".dropActiveRole";
        VUtil.assertNotNull(session, 1030, CLS_NM + fullMethodName);
        VUtil.assertNotNull(role, 5007, CLS_NM + fullMethodName);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacDrop");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session outSession = response.getSession();
        session.copy(outSession);
    }

    @Override
    public String getUserId(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".getUserId");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacUserId");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        User outUser = (User)response.getEntity();
        String userId = outUser.getUserId();
        Session outSession = response.getSession();
        session.copy(outSession);
        return userId;
    }

    @Override
    public User getUser(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".getUser");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "rbacUser");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        User retUser = (User)response.getEntity();
        Session outSession = response.getSession();
        session.copy(outSession);
        return retUser;
    }
}

