/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

public class FilterHandler
implements Comparable<FilterHandler> {
    private final long contextServiceId;
    private final FilterInfo filterInfo;
    private final ExtServletContext context;
    private final BundleContext bundleContext;
    private volatile Filter filter;
    protected volatile int useCount;

    public FilterHandler(long contextServiceId, ExtServletContext context, FilterInfo filterInfo, BundleContext bundleContext) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.filterInfo = filterInfo;
        this.bundleContext = bundleContext;
    }

    @Override
    public int compareTo(FilterHandler other) {
        return this.filterInfo.compareTo(other.filterInfo);
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getName() {
        Filter local;
        String name = this.filterInfo.getName();
        if (name == null && (local = this.filter) != null) {
            name = this.filterInfo.getClassName(local);
        }
        return name;
    }

    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        this.filter = (Filter)this.getFilterInfo().getService(this.bundleContext);
        if (this.filter == null) {
            return 5;
        }
        try {
            this.filter.init((FilterConfig)new FilterConfigImpl(this.getName(), this.getContext(), this.getFilterInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(this.getFilterInfo().getServiceReference(), "Error during calling init() on filter ".concat(this.filterInfo.getClassName(this.filter))), (Throwable)e);
            this.getFilterInfo().ungetService(this.bundleContext, this.filter);
            return 4;
        }
        ++this.useCount;
        return -1;
    }

    public void handle(@NotNull ServletRequest req, @NotNull ServletResponse res, @NotNull FilterChain chain) throws ServletException, IOException {
        Filter local = this.filter;
        if (local == null) {
            throw new ServletException("Filter has been unregistered.");
        }
        local.doFilter(req, res, chain);
    }

    public boolean destroy() {
        Filter f = this.getFilter();
        if (f != null) {
            --this.useCount;
            if (this.useCount == 0) {
                this.filter = null;
                try {
                    f.destroy();
                }
                catch (Exception ignore) {
                    SystemLogger.LOGGER.error(SystemLogger.formatMessage(this.getFilterInfo().getServiceReference(), "Error during calling destroy() on filter ".concat(this.getFilterInfo().getClassName(f))), (Throwable)ignore);
                }
                this.getFilterInfo().ungetService(this.bundleContext, f);
                return true;
            }
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.filterInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterHandler other = (FilterHandler)obj;
        return this.filterInfo.equals(other.filterInfo);
    }
}

