/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.common.impl.lc;

import org.apache.groovy.contracts.common.base.BaseLifecycle;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.generation.PreconditionGenerator;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;

public class PreconditionLifecycle
extends BaseLifecycle {
    @Override
    public void beforeProcessingConstructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        this.generatePrecondition(processingContextInformation, classNode, constructorNode);
    }

    @Override
    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        this.generatePrecondition(processingContextInformation, classNode, methodNode);
    }

    private void generatePrecondition(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!processingContextInformation.isPreconditionsEnabled()) {
            return;
        }
        if (!CandidateChecks.isPreconditionCandidate(classNode, methodNode)) {
            return;
        }
        if (processingContextInformation.contract().preconditions().contains(methodNode)) {
            return;
        }
        PreconditionGenerator preconditionGenerator = new PreconditionGenerator(processingContextInformation.readerSource());
        preconditionGenerator.generateDefaultPreconditionStatement(classNode, methodNode);
    }
}

