/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformedLogRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformedLogRecord> {
    private static final SdkField<Long> EVENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("eventNumber").getter(TransformedLogRecord.getter(TransformedLogRecord::eventNumber)).setter(TransformedLogRecord.setter(Builder::eventNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventNumber").build()}).build();
    private static final SdkField<String> EVENT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventMessage").getter(TransformedLogRecord.getter(TransformedLogRecord::eventMessage)).setter(TransformedLogRecord.setter(Builder::eventMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventMessage").build()}).build();
    private static final SdkField<String> TRANSFORMED_EVENT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformedEventMessage").getter(TransformedLogRecord.getter(TransformedLogRecord::transformedEventMessage)).setter(TransformedLogRecord.setter(Builder::transformedEventMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformedEventMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NUMBER_FIELD, EVENT_MESSAGE_FIELD, TRANSFORMED_EVENT_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformedLogRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long eventNumber;
    private final String eventMessage;
    private final String transformedEventMessage;

    private TransformedLogRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.transformedEventMessage = builder.transformedEventMessage;
    }

    public final Long eventNumber() {
        return this.eventNumber;
    }

    public final String eventMessage() {
        return this.eventMessage;
    }

    public final String transformedEventMessage() {
        return this.transformedEventMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformedEventMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformedLogRecord)) {
            return false;
        }
        TransformedLogRecord other = (TransformedLogRecord)obj;
        return Objects.equals(this.eventNumber(), other.eventNumber()) && Objects.equals(this.eventMessage(), other.eventMessage()) && Objects.equals(this.transformedEventMessage(), other.transformedEventMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TransformedLogRecord").add("EventNumber", (Object)this.eventNumber()).add("EventMessage", (Object)this.eventMessage()).add("TransformedEventMessage", (Object)this.transformedEventMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventNumber": {
                return Optional.ofNullable(clazz.cast(this.eventNumber()));
            }
            case "eventMessage": {
                return Optional.ofNullable(clazz.cast(this.eventMessage()));
            }
            case "transformedEventMessage": {
                return Optional.ofNullable(clazz.cast(this.transformedEventMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventNumber", EVENT_NUMBER_FIELD);
        map.put("eventMessage", EVENT_MESSAGE_FIELD);
        map.put("transformedEventMessage", TRANSFORMED_EVENT_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformedLogRecord, T> g) {
        return obj -> g.apply((TransformedLogRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long eventNumber;
        private String eventMessage;
        private String transformedEventMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformedLogRecord model) {
            this.eventNumber(model.eventNumber);
            this.eventMessage(model.eventMessage);
            this.transformedEventMessage(model.transformedEventMessage);
        }

        public final Long getEventNumber() {
            return this.eventNumber;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final String getEventMessage() {
            return this.eventMessage;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final String getTransformedEventMessage() {
            return this.transformedEventMessage;
        }

        public final void setTransformedEventMessage(String transformedEventMessage) {
            this.transformedEventMessage = transformedEventMessage;
        }

        @Override
        public final Builder transformedEventMessage(String transformedEventMessage) {
            this.transformedEventMessage = transformedEventMessage;
            return this;
        }

        public TransformedLogRecord build() {
            return new TransformedLogRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformedLogRecord> {
        public Builder eventNumber(Long var1);

        public Builder eventMessage(String var1);

        public Builder transformedEventMessage(String var1);
    }
}

