/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.ArrayList;
import org.apache.polaris.core.auth.PolarisAuthorizerFactory;
import org.apache.polaris.core.config.ProductionReadinessCheck;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.apache.polaris.extension.auth.opa.OpaPolarisAuthorizerFactory;

@ApplicationScoped
public class OpaProductionReadinessChecks {
    @Produces
    public ProductionReadinessCheck checkOpaAuthorization(PolarisAuthorizerFactory authorizerFactory) {
        if (authorizerFactory instanceof OpaPolarisAuthorizerFactory) {
            OpaPolarisAuthorizerFactory opaFactory = (OpaPolarisAuthorizerFactory)authorizerFactory;
            OpaAuthorizationConfig config = opaFactory.getConfig();
            ArrayList<ProductionReadinessCheck.Error> errors = new ArrayList<ProductionReadinessCheck.Error>();
            errors.add(ProductionReadinessCheck.Error.of((String)"OPA authorization is currently a Beta feature and is not a stable release. Breaking changes may be introduced in future versions. Use with caution in production environments.", (String)"polaris.authorization.type"));
            if (!config.http().verifySsl()) {
                errors.add(ProductionReadinessCheck.Error.ofSevere((String)"SSL certificate verification is disabled for OPA communication. This exposes the service to man-in-the-middle attacks and other severe security risks.", (String)"polaris.authorization.opa.http.verify-ssl"));
            }
            return ProductionReadinessCheck.of(errors);
        }
        return ProductionReadinessCheck.OK;
    }
}

