/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.api.RateLimitException;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitEvents;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitLogger;
import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class RateLimit<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final String description;
    private final TimeWindow timeWindow;

    public RateLimit(FaultToleranceStrategy<V> delegate, String description, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis, RateLimitType type, Stopwatch stopwatch) {
        this.delegate = Preconditions.checkNotNull(delegate, "Rate limit delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Rate limit description must be set");
        Preconditions.checkNotNull(type, "Rate limit type must be set");
        Preconditions.check(maxInvocations, maxInvocations > 0, "Max invocations must be > 0");
        Preconditions.check(timeWindowInMillis, timeWindowInMillis > 0L, "Time window length must be > 0");
        Preconditions.check(minSpacingInMillis, minSpacingInMillis >= 0L, "Min spacing must be >= 0");
        Preconditions.checkNotNull(stopwatch, "Stopwatch must be set");
        if (type == RateLimitType.FIXED) {
            this.timeWindow = TimeWindow.createFixed(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else if (type == RateLimitType.ROLLING) {
            this.timeWindow = TimeWindow.createRolling(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else if (type == RateLimitType.SMOOTH) {
            this.timeWindow = TimeWindow.createSmooth(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
        } else {
            throw new IllegalArgumentException("Unknown rate limit type: " + String.valueOf(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        RateLimitLogger.LOG.trace("RateLimit started");
        try {
            Completer result = Completer.create();
            long retryAfter = this.timeWindow.record();
            if (retryAfter == 0L) {
                try {
                    RateLimitLogger.LOG.trace("Task permitted by rate limit");
                    ctx.fireEvent(RateLimitEvents.DecisionMade.PERMITTED);
                    this.delegate.apply(ctx).thenComplete(result);
                }
                catch (Exception e) {
                    result.completeWithError(e);
                }
            } else {
                RateLimitLogger.LOG.debugf("%s rate limit exceeded", this.description);
                ctx.fireEvent(RateLimitEvents.DecisionMade.REJECTED);
                result.completeWithError((Throwable)new RateLimitException(retryAfter, this.description + " rate limit exceeded"));
            }
            Future future = result.future();
            return future;
        }
        finally {
            RateLimitLogger.LOG.trace("RateLimit finished");
        }
    }
}

