/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.pa;

import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class PaDataEntry
extends KrbSequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)PaDataEntryField.PADATA_TYPE, 1, Asn1Integer.class), new ExplicitField((EnumType)PaDataEntryField.PADATA_VALUE, 2, Asn1OctetString.class)};

    public PaDataEntry() {
        super(fieldInfos);
    }

    public PaDataEntry(PaDataType type, byte[] paData) {
        super(fieldInfos);
        this.setPaDataType(type);
        this.setPaDataValue(paData);
    }

    public PaDataType getPaDataType() {
        Integer value = this.getFieldAsInteger(PaDataEntryField.PADATA_TYPE);
        return PaDataType.fromValue(value);
    }

    public void setPaDataType(PaDataType paDataType) {
        this.setFieldAsInt(PaDataEntryField.PADATA_TYPE, paDataType.getValue());
    }

    public byte[] getPaDataValue() {
        return this.getFieldAsOctets(PaDataEntryField.PADATA_VALUE);
    }

    public void setPaDataValue(byte[] paDataValue) {
        this.setFieldAsOctets(PaDataEntryField.PADATA_VALUE, paDataValue);
    }

    protected static enum PaDataEntryField implements EnumType
    {
        PADATA_TYPE,
        PADATA_VALUE;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

