/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.filter.StatisticsClassException;
import org.apache.tsfile.file.metadata.statistics.FloatStatistics;
import org.apache.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DoubleStatistics
extends Statistics<Double> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DoubleStatistics.class);
    private double minValue;
    private double maxValue;
    private double firstValue;
    private double lastValue;
    private double sumValue;

    @Override
    public TSDataType getType() {
        return TSDataType.DOUBLE;
    }

    @Override
    public int getStatsSize() {
        return 40;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public void initializeStats(double min, double max, double first, double last, double sum) {
        this.minValue = min;
        this.maxValue = max;
        this.firstValue = first;
        this.lastValue = last;
        this.sumValue = sum;
    }

    private void updateStats(double minValue, double maxValue, double lastValue, double sumValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        this.lastValue = lastValue;
    }

    private void updateStats(double minValue, double maxValue, double firstValue, double lastValue, double sumValue, long startTime, long endTime) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    void updateStats(double value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value);
        }
    }

    @Override
    void updateStats(double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Double getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Double getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        return this.sumValue;
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.DOUBLE, "long sum"}));
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        if (stats instanceof DoubleStatistics || stats instanceof FloatStatistics || stats instanceof IntegerStatistics || stats instanceof LongStatistics) {
            if (this.isEmpty) {
                this.initializeStats(((Number)stats.getMinValue()).doubleValue(), ((Number)stats.getMaxValue()).doubleValue(), ((Number)stats.getFirstValue()).doubleValue(), ((Number)stats.getLastValue()).doubleValue(), stats.getSumDoubleValue());
                this.isEmpty = false;
            } else {
                this.updateStats(((Number)stats.getMinValue()).doubleValue(), ((Number)stats.getMaxValue()).doubleValue(), ((Number)stats.getFirstValue()).doubleValue(), ((Number)stats.getLastValue()).doubleValue(), stats.getSumDoubleValue(), stats.getStartTime(), stats.getEndTime());
            }
        } else {
            throw new StatisticsClassException(this.getClass(), stats.getClass());
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.minValue = ReadWriteIOUtils.readDouble(inputStream);
        this.maxValue = ReadWriteIOUtils.readDouble(inputStream);
        this.firstValue = ReadWriteIOUtils.readDouble(inputStream);
        this.lastValue = ReadWriteIOUtils.readDouble(inputStream);
        this.sumValue = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.minValue = ReadWriteIOUtils.readDouble(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readDouble(byteBuffer);
        this.firstValue = ReadWriteIOUtils.readDouble(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readDouble(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readDouble(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        double e = 1.0E-5;
        DoubleStatistics that = (DoubleStatistics)o;
        return Math.abs(that.minValue - this.minValue) < e && Math.abs(that.maxValue - this.maxValue) < e && Math.abs(that.firstValue - this.firstValue) < e && Math.abs(that.lastValue - this.lastValue) < e && Math.abs(that.sumValue - this.sumValue) < e;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minValue, this.maxValue, this.firstValue, this.lastValue, this.sumValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [minValue:" + this.minValue + ",maxValue:" + this.maxValue + ",firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + ",sumValue:" + this.sumValue + "]";
    }
}

