/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.mailbox.MessageUid;

public abstract class AbstractSelectionCommandParser
extends AbstractImapCommandParser {
    private static final String CONDSTORE = ImapConstants.SUPPORTS_CONDSTORE.asString();
    private static final String QRESYNC = ImapConstants.SUPPORTS_QRESYNC.asString();

    public AbstractSelectionCommandParser(ImapCommand command, StatusResponseFactory statusResponseFactory) {
        super(command, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        boolean condstore = false;
        AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity lastKnownUidValidity = AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity.UNKNOWN;
        Long knownModSeq = null;
        UidRange[] uidSet = null;
        UidRange[] knownUidSet = null;
        IdRange[] knownSequenceSet = null;
        char c = '\u0000';
        try {
            c = request.nextWordChar();
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
        if (c == '(') {
            request.consume();
            int n = ImapRequestLineReader.cap(request.nextChar());
            switch (n) {
                case 67: {
                    request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase(CONDSTORE));
                    condstore = true;
                    break;
                }
                case 81: {
                    request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase(QRESYNC));
                    request.consumeChar(' ');
                    request.consumeChar('(');
                    long uidValidityAsNumber = request.number();
                    lastKnownUidValidity = AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity.of(uidValidityAsNumber);
                    request.consumeChar(' ');
                    knownModSeq = request.number(true);
                    char nc = request.nextChar();
                    if (nc == ' ') {
                        request.consumeChar(' ');
                        uidSet = request.parseUidRange();
                        this.checkUidRanges(uidSet, false);
                        nc = request.nextChar();
                        if (nc == ' ') {
                            request.consumeChar(' ');
                            request.consumeChar('(');
                            knownSequenceSet = request.parseIdRange();
                            request.consumeChar(' ');
                            knownUidSet = request.parseUidRange();
                            this.checkIdRanges(knownSequenceSet, true);
                            this.checkUidRanges(knownUidSet, true);
                            request.consumeChar(')');
                        }
                    }
                    request.consumeChar(')');
                    break;
                }
                default: {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown option");
                }
            }
            request.consumeChar(')');
        }
        request.eol();
        return this.createRequest(mailboxName, condstore, lastKnownUidValidity, knownModSeq, uidSet, knownUidSet, knownSequenceSet, tag);
    }

    private void checkIdRanges(IdRange[] ranges, boolean checkOrder) throws DecodingException {
        long last = 0L;
        for (IdRange r : ranges) {
            long low = r.getLowVal();
            long high = r.getHighVal();
            if (low == Long.MAX_VALUE || high == Long.MAX_VALUE) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "* is not allowed in the sequence-set");
            }
            if (!checkOrder) continue;
            if (low < last) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Sequence-set must be in ascending order");
            }
            last = high;
        }
    }

    private void checkUidRanges(UidRange[] ranges, boolean checkOrder) throws DecodingException {
        MessageUid last = MessageUid.MIN_VALUE;
        for (UidRange r : ranges) {
            MessageUid low = r.getLowVal();
            MessageUid high = r.getHighVal();
            if (low.equals((Object)MessageUid.MAX_VALUE) || high.equals((Object)MessageUid.MAX_VALUE)) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "* is not allowed in the sequence-set");
            }
            if (!checkOrder) continue;
            if (low.compareTo(last) < 0) {
                throw new DecodingException(HumanReadableText.INVALID_MESSAGESET, "Sequence-set must be in ascending order");
            }
            last = high;
        }
    }

    protected abstract AbstractMailboxSelectionRequest createRequest(String var1, boolean var2, AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity var3, Long var4, UidRange[] var5, UidRange[] var6, IdRange[] var7, Tag var8);
}

