/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.migration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class MigrationTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final int targetVersion;
    private final Instant timestamp;

    public static AdditionalInformationDTOModule<MigrationTask.AdditionalInformation, MigrationTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(MigrationTask.AdditionalInformation.class).convertToDTO(MigrationTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new MigrationTask.AdditionalInformation(new SchemaVersion(dto.getTargetVersion()), dto.timestamp)).toDTOConverter((details, type) -> new MigrationTaskAdditionalInformationDTO(type, details.getToVersion(), details.timestamp())).typeName(MigrationTask.CASSANDRA_MIGRATION.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public MigrationTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="targetVersion") int targetVersion, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.targetVersion = targetVersion;
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int getTargetVersion() {
        return this.targetVersion;
    }
}

