/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.io.IOException;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class MemoryWorkQueue
implements WorkQueue {
    private final TaskManagerWorker worker;
    private final Disposable subscription;
    private final Sinks.Many<TaskWithId> tasks;

    public MemoryWorkQueue(TaskManagerWorker worker) {
        this.worker = worker;
        this.tasks = Sinks.many().unicast().onBackpressureBuffer();
        this.subscription = this.tasks.asFlux().subscribeOn(Schedulers.boundedElastic()).limitRate(1).concatMap(this::dispatchTaskToWorker).subscribe();
    }

    private Mono<?> dispatchTaskToWorker(TaskWithId taskWithId) {
        return this.worker.executeTask(taskWithId);
    }

    @Override
    public void submit(TaskWithId taskWithId) {
        this.tasks.emitNext((Object)taskWithId, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Override
    public void cancel(TaskId taskId) {
        this.worker.cancelTask(taskId);
    }

    @Override
    public void close() throws IOException {
        try {
            this.subscription.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.worker.close();
    }
}

