/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Overrides {
    public static final String OVERRIDE_RANGE = "range";
    private static final Logger LOGGER = LoggerFactory.getLogger(Overrides.class);

    private Overrides() {
    }

    @Deprecated
    public static <T extends Resource> void override(Map<String, T> resources, Collection<String> overrides) {
        for (Clause override : Parser.parseClauses(overrides.toArray(new String[overrides.size()]))) {
            String overrideRange = override.getAttribute(OVERRIDE_RANGE);
            Resource over = (Resource)resources.get(override.getName());
            if (over == null) continue;
            for (String uri : new ArrayList<String>(resources.keySet())) {
                Resource res = (Resource)resources.get(uri);
                if (!Overrides.shouldOverride(res, over, overrideRange)) continue;
                resources.put(uri, over);
            }
        }
    }

    public static <T extends Resource> void override(Map<String, T> resources, Map<String, T> overridenFrom) {
        for (Map.Entry<String, T> original : overridenFrom.entrySet()) {
            Resource replacement = (Resource)resources.get(original.getKey());
            if (replacement == null || Overrides.shouldOverride((Resource)original.getValue(), replacement, "[0,*)")) continue;
            resources.put(original.getKey(), (Resource)original.getValue());
        }
    }

    private static <T extends Resource> boolean shouldOverride(Resource resource, T override, String explicitRange) {
        VersionRange range;
        if (!ResolverUtil.getSymbolicName(resource).equals(ResolverUtil.getSymbolicName(override))) {
            return false;
        }
        if (explicitRange == null) {
            Version v1 = ResolverUtil.getVersion(resource);
            Version v2 = new Version(v1.getMajor(), v1.getMinor() + 1, 0);
            range = new VersionRange(false, v1, v2, true);
        } else {
            range = VersionRange.parseVersionRange(explicitRange);
        }
        return range.contains(ResolverUtil.getVersion(override)) && ResolverUtil.getVersion(resource).compareTo(ResolverUtil.getVersion(override)) < 0;
    }

    public static Set<String> loadOverrides(String overridesUrl) {
        LinkedHashSet<String> overrides;
        block15: {
            overrides = new LinkedHashSet<String>();
            try {
                if (overridesUrl == null) break block15;
                try (InputStream is = new URL(overridesUrl).openStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        overrides.add(line);
                    }
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Unable to load overrides bundles list {}", (Object)e.toString());
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return overrides;
    }

    public static String extractUrl(String override) {
        Clause[] cs = Parser.parseClauses(new String[]{override});
        if (cs.length != 1) {
            throw new IllegalStateException("Override contains more than one clause: " + override);
        }
        return cs[0].getName();
    }
}

