/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.xa.impl;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.RecoveryWorkAroundTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedXAResourceImpl
implements NamedXAResource,
AutoCloseable {
    final Logger logger = LoggerFactory.getLogger(NamedXAResourceImpl.class);
    final String name;
    final XAResource xaResource;
    final RecoveryWorkAroundTransactionManager transactionManager;
    final boolean original;
    boolean closed;

    public NamedXAResourceImpl(String name, XAResource xaResource, RecoveryWorkAroundTransactionManager transactionManager, boolean original) {
        this.name = name;
        this.xaResource = xaResource;
        this.transactionManager = transactionManager;
        this.original = original;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void safeCall(XAAction action) throws XAException {
        this.checkOpen();
        try {
            action.perform();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private <T> T safeCall(XAReturnAction<T> action) throws XAException {
        this.checkOpen();
        try {
            return action.perform();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private void checkOpen() throws XAException {
        if (this.closed) {
            XAException xaException = new XAException("This instance of the resource named " + this.name + " is no longer available");
            xaException.errorCode = -7;
            throw xaException;
        }
    }

    private XAException handleException(Exception e) throws XAException {
        if (e instanceof XAException) {
            XAException xae = (XAException)e;
            if (xae.errorCode == 0) {
                if (this.original) {
                    if (this.transactionManager.getNamedResource(this.name) == null) {
                        this.logger.error("The XA resource named {} threw an XAException but did not set the error code. There is also no RecoverableXAResource available with the name {}. It is not possible to recover from this situation and so the transaction will have to be resolved by an operator.", new Object[]{this.name, this.name, xae});
                        xae.errorCode = -3;
                    } else {
                        this.logger.warn("The XA resource named {} threw an XAException but did not set the error code. Changing it to be an \"RM_FAIL\" to permit recovery attempts", (Object)this.name, (Object)xae);
                        xae.errorCode = -7;
                    }
                } else {
                    this.logger.warn("The XA resource named {} threw an XAException but did not set the error code. Recovery has already been attempted for this resource and it has not been possible to recover from this situation. The transaction will have to be resolved by an operator.", (Object)this.name, (Object)xae);
                    xae.errorCode = -3;
                }
            }
            return xae;
        }
        this.logger.warn("The recoverable XA resource named {} threw an Exception which is not permitted by the interface. Changing it to be a \"Resource Manager Error\" XAException which prevents recovery", (Object)this.name, (Object)e);
        XAException xaException = new XAException(-3);
        xaException.initCause(e);
        return xaException;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.safeCall(() -> this.xaResource.commit(xid, onePhase));
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.safeCall(() -> this.xaResource.end(xid, flags));
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.safeCall(() -> this.xaResource.forget(xid));
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.safeCall(() -> this.xaResource.getTransactionTimeout());
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this.safeCall(() -> this.xaResource.isSameRM(xares));
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.safeCall(() -> this.xaResource.prepare(xid));
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.safeCall(() -> this.xaResource.recover(flag));
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.safeCall(() -> this.xaResource.rollback(xid));
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.safeCall(() -> this.xaResource.setTransactionTimeout(seconds));
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.safeCall(() -> this.xaResource.start(xid, flags));
    }

    private static interface XAReturnAction<T> {
        public T perform() throws XAException;
    }

    private static interface XAAction {
        public void perform() throws XAException;
    }
}

