/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.impala;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class ImpalaUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "IMPALAUI";
    public static final String SERVICE_TYPE = "IMPALA";
    public static final String ROLE_TYPE = "IMPALAD";
    static final String ENABLE_WEBSERVER = "impalad_enable_webserver";
    static final String SSL_ENABLED = "client_services_ssl_enabled";
    static final String WEBSERVER_PORT = "impalad_webserver_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModelGeneratorHandleResponse handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        ServiceModelGeneratorHandleResponse response = super.handles(service, serviceConfig, role, roleConfig);
        if (response.handled()) {
            String impalaWebserverEnabled = this.getRoleConfigValue(roleConfig, ENABLE_WEBSERVER);
            if (impalaWebserverEnabled == null) {
                response.addConfigurationIssue("Missing configuration: impalad_enable_webserver");
            } else if (!Boolean.parseBoolean(impalaWebserverEnabled)) {
                response.addConfigurationIssue("Invalid configuration: impalad_enable_webserver. Expected=true; Found=" + impalaWebserverEnabled);
            }
        }
        return response;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getServiceConfigValue(serviceConfig, SSL_ENABLED);
        String scheme = Boolean.parseBoolean(sslEnabled) ? "https" : "http";
        String port = this.getRoleConfigValue(roleConfig, WEBSERVER_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/", scheme, hostname, port));
        model.addServiceProperty(SSL_ENABLED, sslEnabled);
        model.addRoleProperty(this.getRoleType(), WEBSERVER_PORT, port);
        model.addRoleProperty(this.getRoleType(), ENABLE_WEBSERVER, this.getRoleConfigValue(roleConfig, ENABLE_WEBSERVER));
        return model;
    }
}

