/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.openide.util.Parameters;

public final class IndexingUtils {
    private static volatile IndexingStatus status;

    public static void runAsScanWork(@NonNull Runnable work) {
        Parameters.notNull("work", work);
        RepositoryUpdater.getDefault().runAsWork(work);
    }

    public static void setIndexingStatus(IndexingStatus st) {
        assert (st != null);
        assert (status == null);
        status = st;
    }

    public static Set<? extends RepositoryUpdater.IndexingState> getIndexingState() {
        if (status == null) {
            return RepositoryUpdater.getDefault().getIndexingState();
        }
        return status.getIndexingState();
    }

    public static boolean isScanInProgress() {
        return !IndexingUtils.getIndexingState().isEmpty();
    }

    private IndexingUtils() {
    }

    public static interface IndexingStatus {
        public Set<? extends RepositoryUpdater.IndexingState> getIndexingState();
    }
}

