/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.processors;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ProcessorsResult;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessorClient;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;

public class ChangeVersionProcessor
extends AbstractNiFiCommand<ProcessorsResult> {
    public ChangeVersionProcessor() {
        super("change-version-processor", ProcessorsResult.class);
    }

    @Override
    public String getDescription() {
        return "Recursively changes the version of the instances of the specified processor. If the process group is specified, the changes will be scoped to that process group and its childs ; if not specified the changes will recursively apply to the root process group. If the source version is specified, only instances with this version will be updated to the new version.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_GROUP.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_ARTIFACT.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_VERSION.createOption());
        this.addOption(CommandOption.EXT_QUALIFIED_NAME.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_CURRENT_VERSION.createOption());
    }

    @Override
    public ProcessorsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String bundleGroup = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_GROUP);
        String bundleArtifact = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_ARTIFACT);
        String bundleVersion = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_VERSION);
        String qualifiedName = this.getRequiredArg(properties, CommandOption.EXT_QUALIFIED_NAME);
        String sourceVersion = this.getArg(properties, CommandOption.EXT_BUNDLE_CURRENT_VERSION);
        FlowClient flowClient = client.getFlowClient();
        ProcessorClient processorClient = client.getProcessorClient();
        String pgId = this.getArg(properties, CommandOption.PG_ID);
        if (StringUtils.isBlank((CharSequence)pgId)) {
            pgId = flowClient.getRootGroupId();
        }
        Set<ProcessorEntity> updatedComponents = this.recursivelyChangeVersionProcessor(flowClient, processorClient, pgId, bundleGroup, bundleArtifact, bundleVersion, sourceVersion, qualifiedName);
        ProcessorsEntity processorsEntity = new ProcessorsEntity();
        processorsEntity.setProcessors(updatedComponents);
        return new ProcessorsResult(this.getResultType(properties), processorsEntity);
    }

    private Set<ProcessorEntity> recursivelyChangeVersionProcessor(FlowClient flowClient, ProcessorClient processorClient, String pgId, String bundleGroup, String bundleArtifact, String bundleVersion, String sourceVersion, String qualifiedName) throws NiFiClientException, IOException {
        HashSet<ProcessorEntity> updatedComponents = new HashSet<ProcessorEntity>();
        ProcessGroupFlowEntity sourcePgEntity = flowClient.getProcessGroup(pgId);
        ProcessGroupFlowDTO flow = sourcePgEntity.getProcessGroupFlow();
        Set processors = flow.getFlow().getProcessors();
        for (ProcessorEntity processor : processors) {
            BundleDTO bundle = processor.getComponent().getBundle();
            if (!bundle.getGroup().equals(bundleGroup) || !bundle.getArtifact().equals(bundleArtifact) || !processor.getComponent().getType().equals(qualifiedName) || !StringUtils.isBlank((CharSequence)sourceVersion) && !bundle.getVersion().equals(sourceVersion)) continue;
            boolean isRunning = processor.getComponent().getState().equals("RUNNING");
            if (isRunning) {
                processorClient.stopProcessor(processor);
                processor = processorClient.getProcessor(processor.getId());
            }
            BundleDTO updatedBundle = new BundleDTO(bundleGroup, bundleArtifact, bundleVersion);
            ProcessorDTO processorDto = new ProcessorDTO();
            processorDto.setId(processor.getId());
            processorDto.setBundle(updatedBundle);
            ProcessorEntity updatedEntity = new ProcessorEntity();
            updatedEntity.setRevision(processor.getRevision());
            updatedEntity.setComponent(processorDto);
            updatedEntity.setId(processor.getId());
            processorClient.updateProcessor(updatedEntity);
            if (isRunning) {
                processor = processorClient.getProcessor(processor.getId());
                processorClient.startProcessor(processor);
            }
            processor = processorClient.getProcessor(processor.getId());
            updatedComponents.add(processor);
        }
        Set processGroups = flow.getFlow().getProcessGroups();
        for (ProcessGroupEntity processGroup : processGroups) {
            updatedComponents.addAll(this.recursivelyChangeVersionProcessor(flowClient, processorClient, processGroup.getId(), bundleGroup, bundleArtifact, bundleVersion, sourceVersion, qualifiedName));
        }
        return updatedComponents;
    }
}

