/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.InitializationException;

public abstract class AbstractControllerService
extends AbstractConfigurableComponent
implements ControllerService {
    private String identifier;
    private ControllerServiceLookup serviceLookup;
    private ComponentLog logger;
    private StateManager stateManager;
    private volatile ConfigurationContext configurationContext;
    private volatile boolean enabled = false;
    private NodeTypeProvider nodeTypeProvider;

    @Override
    public final void initialize(ControllerServiceInitializationContext context) throws InitializationException {
        this.identifier = context.getIdentifier();
        this.serviceLookup = context.getControllerServiceLookup();
        this.logger = context.getLogger();
        this.stateManager = context.getStateManager();
        this.nodeTypeProvider = context.getNodeTypeProvider();
        this.init(context);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    protected final ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceLookup;
    }

    protected final NodeTypeProvider getNodeTypeProvider() {
        return this.nodeTypeProvider;
    }

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
    }

    @OnEnabled
    public final void enabled() {
        this.enabled = true;
    }

    @OnDisabled
    public final void disabled() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected ComponentLog getLogger() {
        return this.logger;
    }

    protected StateManager getStateManager() {
        return this.stateManager;
    }

    @OnEnabled
    public final void abstractStoreConfigContext(ConfigurationContext configContext) {
        this.configurationContext = configContext;
    }

    @OnDisabled
    public final void abstractClearConfigContext() {
        this.configurationContext = null;
    }

    protected ConfigurationContext getConfigurationContext() {
        ConfigurationContext context = this.configurationContext;
        if (context == null) {
            throw new IllegalStateException("No Configuration Context exists");
        }
        return this.configurationContext;
    }

    protected PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getConfigurationContext().getProperty(descriptor);
    }
}

