/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.util.Arrays;

public class NonThreadSafeCircularBuffer {
    private final byte[] lookingFor;
    private final int[] buffer;
    private int insertionPointer = 0;
    private int bufferSize = 0;

    public NonThreadSafeCircularBuffer(byte[] lookingFor) {
        this.lookingFor = lookingFor;
        this.buffer = new int[lookingFor.length];
        Arrays.fill(this.buffer, -1);
    }

    public byte[] getByteArray() {
        return this.lookingFor;
    }

    public int getOldestByte() {
        return this.buffer[this.insertionPointer];
    }

    public boolean isFilled() {
        return this.bufferSize >= this.buffer.length;
    }

    public boolean addAndCompare(byte data) {
        this.buffer[this.insertionPointer] = data;
        this.insertionPointer = (this.insertionPointer + 1) % this.lookingFor.length;
        ++this.bufferSize;
        if (this.bufferSize < this.lookingFor.length) {
            return false;
        }
        for (int i = 0; i < this.lookingFor.length; ++i) {
            byte compare = (byte)this.buffer[(this.insertionPointer + i) % this.lookingFor.length];
            if (compare == this.lookingFor[i]) continue;
            return false;
        }
        return true;
    }
}

