/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Arrays;

public class NaiveSearchRingBuffer {
    private final byte[] lookingFor;
    private final int[] buffer;
    private int insertionPointer = 0;
    private long bufferSize = 0L;

    public NaiveSearchRingBuffer(byte[] lookingFor) {
        this.lookingFor = lookingFor;
        this.buffer = new int[lookingFor.length];
        Arrays.fill(this.buffer, -1);
    }

    public byte[] getBufferContents() {
        int contentLength = (int)Math.min((long)this.lookingFor.length, this.bufferSize);
        byte[] contents = new byte[contentLength];
        for (int i = 0; i < contentLength; ++i) {
            byte nextByte;
            contents[i] = nextByte = (byte)this.buffer[(this.insertionPointer + i) % this.lookingFor.length];
        }
        return contents;
    }

    public int getOldestByte() {
        return this.buffer[this.insertionPointer];
    }

    public boolean isFilled() {
        return this.bufferSize >= (long)this.buffer.length;
    }

    public void clear() {
        Arrays.fill(this.buffer, -1);
        this.insertionPointer = 0;
        this.bufferSize = 0L;
    }

    public boolean addAndCompare(byte data) {
        this.buffer[this.insertionPointer] = data;
        this.insertionPointer = (this.insertionPointer + 1) % this.lookingFor.length;
        ++this.bufferSize;
        if (this.bufferSize < (long)this.lookingFor.length) {
            return false;
        }
        for (int i = 0; i < this.lookingFor.length; ++i) {
            byte compare = (byte)this.buffer[(this.insertionPointer + i) % this.lookingFor.length];
            if (compare == this.lookingFor[i]) continue;
            return false;
        }
        return true;
    }
}

