
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

// Remark: The different fields are encoded in Little-endian.

[type OpcuaConstants
    [const          uint 8     protocolVersion 0]
]

[type OpcuaAPU(bit response, bit binaryEncoding) byteOrder='LITTLE_ENDIAN'
    [simple MessagePDU('response', 'binaryEncoding') message]
]

[enum string 8 ChunkType
    ['"C"' CONTINUE ]
    ['"F"' FINAL    ]
    ['"A"' ABORT    ]
]

[enum string 24 MessageType
    ['"HEL"' HELLO       ]
    ['"ACK"' ACKNOWLEDGE ]
    ['"ERR"' ERROR       ]
    ['"OPN"' OPEN        ]
    ['"CLO"' CLOSE       ]
    ['"MSG"' MESSAGE     ]
]

[discriminatedType MessagePDU(bit response, bit binary)
    [discriminator    string 24          messageType]
    [simple           ChunkType          chunk]
    [implicit         uint 32            totalLength 'lengthInBytes']
    [typeSwitch messageType,response
        ['"HEL"','false'      OpcuaHelloRequest
            [simple           uint 32                 version   ]
            [simple           OpcuaProtocolLimits     limits    ]
            [simple           PascalString            endpoint  ]
        ]
        ['"ACK"','true'       OpcuaAcknowledgeResponse
            [simple           uint 32                 version   ]
            [simple           OpcuaProtocolLimits     limits    ]
        ]

        ['"OPN"','false'     OpcuaOpenRequest (uint 32 totalLength)
            [simple          OpenChannelMessage('response')  openRequest]
            [simple          Payload('binary', 'totalLength - openRequest.lengthInBytes - 16') message]
        ]
        ['"OPN"','true'      OpcuaOpenResponse (uint 32 totalLength)
            [simple          OpenChannelMessage('response') openResponse]
            [simple          Payload('binary', 'totalLength - openResponse.lengthInBytes - 16') message]
        ]
        ['"CLO"','false'     OpcuaCloseRequest
            [simple          SecurityHeader        securityHeader ]
            [simple          Payload('binary', '0') message        ]
        ]
        ['"MSG"','false'     OpcuaMessageRequest (uint 32 totalLength)
            [simple          SecurityHeader     securityHeader ]
            [simple          Payload('binary', 'totalLength - securityHeader.lengthInBytes - 16') message]
        ]
        ['"MSG"','true'      OpcuaMessageResponse (uint 32 totalLength)
            [simple          SecurityHeader     securityHeader ]
            [simple          Payload('binary', 'totalLength - securityHeader.lengthInBytes - 16') message]
        ]
        ['"ERR"','true'      OpcuaMessageError
            [simple          OpcuaStatusCode    error ]
            [simple          PascalString       reason]
        ]
    ]
]

[type OpenChannelMessage (bit response)
    [typeSwitch response
        ['false' OpenChannelMessageRequest
            [simple          int 32             secureChannelId]
            [simple          PascalString       endpoint]
            [simple          PascalByteString   senderCertificate]
            [simple          PascalByteString   receiverCertificateThumbprint]
        ]
        ['true' OpenChannelMessageResponse
            [simple          int 32             secureChannelId]
            [simple          PascalString       securityPolicyUri]
            [simple          PascalByteString   senderCertificate]
            [simple          PascalByteString   receiverCertificateThumbprint]
        ]
    ]
]

[type OpcuaProtocolLimits
    [simple           uint 32             receiveBufferSize]
    [simple           uint 32             sendBufferSize]
    [simple           uint 32             maxMessageSize]
    [simple           uint 32             maxChunkCount]
]

[type SecurityHeader
    [simple           uint 32            secureChannelId]
    [simple           uint 32            secureTokenId]
]

[discriminatedType Payload (bit binary, uint 32 byteCount)
    [simple SequenceHeader                    sequenceHeader            ]
    [typeSwitch binary
        ['false'      ExtensiblePayload
            [simple   RootExtensionObject('false') payload              ]
        ]
        ['true'       BinaryPayload
            [array    byte                     payload count 'byteCount']
        ]
    ]
]

[type SequenceHeader
    [simple           int 32             sequenceNumber]
    [simple           int 32             requestId]
]

[type ByteStringArray
    [simple int 32 arrayLength]
    [array uint 8 value count 'arrayLength']
]

[type GuidValue
    [simple uint 32 data1]
    [simple uint 16 data2]
    [simple uint 16 data3]
    [array  byte    data4 count '2']
    [array  byte    data5 count '6']
]

[type ExpandedNodeId
    [simple bit namespaceURISpecified]
    [simple bit serverIndexSpecified]
    [simple NodeIdTypeDefinition nodeId]
    [optional PascalString namespaceURI 'namespaceURISpecified']
    [optional uint 32 serverIndex 'serverIndexSpecified']
]



[type ExtensionObjectEncodingMask
    [reserved int 5 '0x00']
    [simple bit typeIdSpecified]
    [simple bit xmlBody]
    [simple bit binaryBody]
]

[discriminatedType ExtensionObject(bit includeEncodingMask)
    [abstract ExtensionObjectDefinition body]
    [simple ExpandedNodeId typeId]
    [virtual int 32 extensionId 'typeId == null ? 0 : STATIC_CALL("extensionId", typeId)']
    [typeSwitch includeEncodingMask
        ['false' RootExtensionObject (int 32 extensionId)
            [simple ExtensionObjectDefinition('extensionId') body]
        ]
        ['true' ExtensionObjectWithMask (int 32 extensionId)
            [simple ExtensionObjectEncodingMask encodingMask]
            [typeSwitch encodingMask.xmlBody, encodingMask.binaryBody
                ['false', 'true' BinaryExtensionObjectWithMask
                    [implicit int 32 bodyLength 'body == null ? 0 : body.lengthInBytes']
                    [simple ExtensionObjectDefinition('extensionId') body]
                ]
                ['false', 'false' NullExtensionObjectWithMask
                    [virtual ExtensionObjectDefinition('0') body 'null']
                ]
            ]
        ]
    ]
]

[discriminatedType ExtensionObjectDefinition(int 32 extensionId)
    [typeSwitch extensionId
        ['0' NullExtension
        ]
        
        ['12758' Union
            
        ]
        ['14535' KeyValuePair
            [simple QualifiedName key]
            [simple Variant value]
        ]
        ['16315' AdditionalParametersType
            [implicit int 32 noOfParameters 'parameters == null ? -1 : COUNT(parameters)']
            [array KeyValuePair('14535') parameters count 'noOfParameters']
        ]
        ['17550' EphemeralKeyType
            [simple PascalByteString publicKey]
            [simple PascalByteString signature]
        ]
        ['15530' EndpointType
            [simple PascalString endpointUrl]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [simple PascalString transportProfileUri]
        ]
        ['32423' BitFieldDefinition
            [simple PascalString name]
            [simple LocalizedText description]
            [reserved uint 7 '0x00']
            [reserved bit 'false']
            [simple uint 32 startingBitPosition]
            [simple uint 32 endingBitPosition]
        ]
        ['18808' RationalNumber
            [simple int 32 numerator]
            [simple uint 32 denominator]
        ]
        ['18809' OpcuaVector
            
        ]
        ['18811' CartesianCoordinates
            
        ]
        ['18813' Orientation
            
        ]
        ['18815' Frame
            
        ]
        ['15636' IdentityMappingRuleType
            [simple IdentityCriteriaType criteriaType]
            [simple PascalString criteria]
        ]
        ['23500' CurrencyUnitType
            [simple int 16 numericCode]
            [simple int 8 exponent]
            [simple PascalString alphabeticCode]
            [simple LocalizedText currency]
        ]
        ['32436' AnnotationDataType
            [simple PascalString annotation]
            [simple PascalString discipline]
            [simple PascalString uri]
        ]
        ['32437' LinearConversionDataType
            [simple float 32 initialAddend]
            [simple float 32 multiplicand]
            [simple float 32 divisor]
            [simple float 32 finalAddend]
        ]
        ['32440' QuantityDimension
            [simple int 8 massExponent]
            [simple int 8 lengthExponent]
            [simple int 8 timeExponent]
            [simple int 8 electricCurrentExponent]
            [simple int 8 amountOfSubstanceExponent]
            [simple int 8 luminousIntensityExponent]
            [simple int 8 absoluteTemperatureExponent]
            [simple int 8 dimensionlessExponent]
        ]
        ['12556' TrustListDataType
            [simple uint 32 specifiedLists]
            [implicit int 32 noOfTrustedCertificates 'trustedCertificates == null ? -1 : COUNT(trustedCertificates)']
            [array PascalByteString trustedCertificates count 'noOfTrustedCertificates']
            [implicit int 32 noOfTrustedCrls 'trustedCrls == null ? -1 : COUNT(trustedCrls)']
            [array PascalByteString trustedCrls count 'noOfTrustedCrls']
            [implicit int 32 noOfIssuerCertificates 'issuerCertificates == null ? -1 : COUNT(issuerCertificates)']
            [array PascalByteString issuerCertificates count 'noOfIssuerCertificates']
            [implicit int 32 noOfIssuerCrls 'issuerCrls == null ? -1 : COUNT(issuerCrls)']
            [array PascalByteString issuerCrls count 'noOfIssuerCrls']
        ]
        ['15436' BaseConfigurationDataType
            [simple uint 32 configurationVersion]
            [implicit int 32 noOfConfigurationProperties 'configurationProperties == null ? -1 : COUNT(configurationProperties)']
            [array KeyValuePair('14535') configurationProperties count 'noOfConfigurationProperties']
        ]
        ['15437' BaseConfigurationRecordDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
        ]
        ['15438' CertificateGroupDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [simple NodeId purpose]
            [implicit int 32 noOfCertificateTypes 'certificateTypes == null ? -1 : COUNT(certificateTypes)']
            [array NodeId certificateTypes count 'noOfCertificateTypes']
            [implicit int 32 noOfIsCertificateAssigned 'isCertificateAssigned == null ? -1 : COUNT(isCertificateAssigned)']
            [reserved uint 7 '0x00']
            [array bit isCertificateAssigned count 'noOfIsCertificateAssigned']
            [simple TrustListValidationOptions validationOptions]
        ]
        ['15540' ConfigurationUpdateTargetType
            [simple PascalString path]
            [simple ConfigurationUpdateType updateType]
        ]
        ['32287' TransactionErrorType
            [simple NodeId targetId]
            [simple StatusCode error]
            [simple LocalizedText message]
        ]
        ['15551' ApplicationConfigurationDataType
            [simple uint 32 configurationVersion]
            [implicit int 32 noOfConfigurationProperties 'configurationProperties == null ? -1 : COUNT(configurationProperties)']
            [array KeyValuePair('14535') configurationProperties count 'noOfConfigurationProperties']
            [simple ApplicationIdentityDataType('15558') applicationIdentity]
            [implicit int 32 noOfCertificateGroups 'certificateGroups == null ? -1 : COUNT(certificateGroups)']
            [array CertificateGroupDataType('15438') certificateGroups count 'noOfCertificateGroups']
            [implicit int 32 noOfServerEndpoints 'serverEndpoints == null ? -1 : COUNT(serverEndpoints)']
            [array ServerEndpointDataType('15560') serverEndpoints count 'noOfServerEndpoints']
            [implicit int 32 noOfClientEndpoints 'clientEndpoints == null ? -1 : COUNT(clientEndpoints)']
            [array EndpointDataType('15559') clientEndpoints count 'noOfClientEndpoints']
            [implicit int 32 noOfSecuritySettings 'securitySettings == null ? -1 : COUNT(securitySettings)']
            [array SecuritySettingsDataType('15561') securitySettings count 'noOfSecuritySettings']
            [implicit int 32 noOfUserTokenSettings 'userTokenSettings == null ? -1 : COUNT(userTokenSettings)']
            [array UserTokenSettingsDataType('15562') userTokenSettings count 'noOfUserTokenSettings']
            [implicit int 32 noOfAuthorizationServices 'authorizationServices == null ? -1 : COUNT(authorizationServices)']
            [array AuthorizationServiceConfigurationDataType('19447') authorizationServices count 'noOfAuthorizationServices']
        ]
        ['15558' ApplicationIdentityDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [simple PascalString applicationUri]
            [implicit int 32 noOfApplicationNames 'applicationNames == null ? -1 : COUNT(applicationNames)']
            [array LocalizedText applicationNames count 'noOfApplicationNames']
            [implicit int 32 noOfAdditionalServers 'additionalServers == null ? -1 : COUNT(additionalServers)']
            [array ApplicationDescription('310') additionalServers count 'noOfAdditionalServers']
        ]
        ['15559' EndpointDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [implicit int 32 noOfDiscoveryUrls 'discoveryUrls == null ? -1 : COUNT(discoveryUrls)']
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
            [simple PascalString networkName]
            [simple uint 16 port]
        ]
        ['15560' ServerEndpointDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [implicit int 32 noOfDiscoveryUrls 'discoveryUrls == null ? -1 : COUNT(discoveryUrls)']
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
            [simple PascalString networkName]
            [simple uint 16 port]
            [implicit int 32 noOfEndpointUrls 'endpointUrls == null ? -1 : COUNT(endpointUrls)']
            [array PascalString endpointUrls count 'noOfEndpointUrls']
            [implicit int 32 noOfSecuritySettingNames 'securitySettingNames == null ? -1 : COUNT(securitySettingNames)']
            [array PascalString securitySettingNames count 'noOfSecuritySettingNames']
            [simple PascalString transportProfileUri]
            [implicit int 32 noOfUserTokenSettingNames 'userTokenSettingNames == null ? -1 : COUNT(userTokenSettingNames)']
            [array PascalString userTokenSettingNames count 'noOfUserTokenSettingNames']
            [implicit int 32 noOfReverseConnectUrls 'reverseConnectUrls == null ? -1 : COUNT(reverseConnectUrls)']
            [array PascalString reverseConnectUrls count 'noOfReverseConnectUrls']
        ]
        ['15561' SecuritySettingsDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [implicit int 32 noOfSecurityModes 'securityModes == null ? -1 : COUNT(securityModes)']
            [array MessageSecurityMode securityModes count 'noOfSecurityModes']
            [implicit int 32 noOfSecurityPolicyUris 'securityPolicyUris == null ? -1 : COUNT(securityPolicyUris)']
            [array PascalString securityPolicyUris count 'noOfSecurityPolicyUris']
            [simple PascalString certificateGroupName]
        ]
        ['15562' UserTokenSettingsDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [simple UserTokenType tokenType]
            [simple PascalString issuedTokenType]
            [simple PascalString issuerEndpointUrl]
            [simple PascalString securityPolicyUri]
            [simple PascalString certificateGroupName]
            [simple PascalString authorizationServiceName]
        ]
        ['19447' AuthorizationServiceConfigurationDataType
            [simple PascalString name]
            [implicit int 32 noOfRecordProperties 'recordProperties == null ? -1 : COUNT(recordProperties)']
            [array KeyValuePair('14535') recordProperties count 'noOfRecordProperties']
            [simple PascalString serviceUri]
            [implicit int 32 noOfServiceCertificate 'serviceCertificate == null ? -1 : COUNT(serviceCertificate)']
            [array PascalByteString serviceCertificate count 'noOfServiceCertificate']
            [simple PascalString issuerEndpointSettings]
        ]
        ['15536' DataTypeSchemaHeader
            [implicit int 32 noOfNamespaces 'namespaces == null ? -1 : COUNT(namespaces)']
            [array PascalString namespaces count 'noOfNamespaces']
            [implicit int 32 noOfStructureDataTypes 'structureDataTypes == null ? -1 : COUNT(structureDataTypes)']
            [array StructureDescription('15489') structureDataTypes count 'noOfStructureDataTypes']
            [implicit int 32 noOfEnumDataTypes 'enumDataTypes == null ? -1 : COUNT(enumDataTypes)']
            [array EnumDescription('15490') enumDataTypes count 'noOfEnumDataTypes']
            [implicit int 32 noOfSimpleDataTypes 'simpleDataTypes == null ? -1 : COUNT(simpleDataTypes)']
            [array SimpleTypeDescription('15007') simpleDataTypes count 'noOfSimpleDataTypes']
        ]
        ['14527' DataTypeDescription
            [simple NodeId dataTypeId]
            [simple QualifiedName name]
        ]
        ['15489' StructureDescription
            [simple NodeId dataTypeId]
            [simple QualifiedName name]
            [simple StructureDefinition('101') structureDefinition]
        ]
        ['15490' EnumDescription
            [simple NodeId dataTypeId]
            [simple QualifiedName name]
            [simple EnumDefinition('102') enumDefinition]
            [simple uint 8 builtInType]
        ]
        ['15007' SimpleTypeDescription
            [simple NodeId dataTypeId]
            [simple QualifiedName name]
            [simple NodeId baseDataType]
            [simple uint 8 builtInType]
        ]
        ['15008' UABinaryFileDataType
            [implicit int 32 noOfNamespaces 'namespaces == null ? -1 : COUNT(namespaces)']
            [array PascalString namespaces count 'noOfNamespaces']
            [implicit int 32 noOfStructureDataTypes 'structureDataTypes == null ? -1 : COUNT(structureDataTypes)']
            [array StructureDescription('15489') structureDataTypes count 'noOfStructureDataTypes']
            [implicit int 32 noOfEnumDataTypes 'enumDataTypes == null ? -1 : COUNT(enumDataTypes)']
            [array EnumDescription('15490') enumDataTypes count 'noOfEnumDataTypes']
            [implicit int 32 noOfSimpleDataTypes 'simpleDataTypes == null ? -1 : COUNT(simpleDataTypes)']
            [array SimpleTypeDescription('15007') simpleDataTypes count 'noOfSimpleDataTypes']
            [simple PascalString schemaLocation]
            [implicit int 32 noOfFileHeader 'fileHeader == null ? -1 : COUNT(fileHeader)']
            [array KeyValuePair('14535') fileHeader count 'noOfFileHeader']
            [simple Variant body]
        ]
        ['24107' PortableQualifiedName
            [simple PascalString namespaceUri]
            [simple PascalString name]
        ]
        ['24108' PortableNodeId
            [simple PascalString namespaceUri]
            [simple NodeId identifier]
        ]
        ['24109' UnsignedRationalNumber
            [simple uint 32 numerator]
            [simple uint 32 denominator]
        ]
        ['14525' DataSetMetaDataType
            [implicit int 32 noOfNamespaces 'namespaces == null ? -1 : COUNT(namespaces)']
            [array PascalString namespaces count 'noOfNamespaces']
            [implicit int 32 noOfStructureDataTypes 'structureDataTypes == null ? -1 : COUNT(structureDataTypes)']
            [array StructureDescription('15489') structureDataTypes count 'noOfStructureDataTypes']
            [implicit int 32 noOfEnumDataTypes 'enumDataTypes == null ? -1 : COUNT(enumDataTypes)']
            [array EnumDescription('15490') enumDataTypes count 'noOfEnumDataTypes']
            [implicit int 32 noOfSimpleDataTypes 'simpleDataTypes == null ? -1 : COUNT(simpleDataTypes)']
            [array SimpleTypeDescription('15007') simpleDataTypes count 'noOfSimpleDataTypes']
            [simple PascalString name]
            [simple LocalizedText description]
            [implicit int 32 noOfFields 'fields == null ? -1 : COUNT(fields)']
            [array FieldMetaData('14526') fields count 'noOfFields']
            [simple GuidValue dataSetClassId]
            [simple ConfigurationVersionDataType('14595') configurationVersion]
        ]
        ['14526' FieldMetaData
            [simple PascalString name]
            [simple LocalizedText description]
            [simple DataSetFieldFlags fieldFlags]
            [simple uint 8 builtInType]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [implicit int 32 noOfArrayDimensions 'arrayDimensions == null ? -1 : COUNT(arrayDimensions)']
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
            [simple uint 32 maxStringLength]
            [simple GuidValue dataSetFieldId]
            [implicit int 32 noOfProperties 'properties == null ? -1 : COUNT(properties)']
            [array KeyValuePair('14535') properties count 'noOfProperties']
        ]
        ['14595' ConfigurationVersionDataType
            [simple uint 32 majorVersion]
            [simple uint 32 minorVersion]
        ]
        ['15580' PublishedDataSetDataType
            [simple PascalString name]
            [implicit int 32 noOfDataSetFolder 'dataSetFolder == null ? -1 : COUNT(dataSetFolder)']
            [array PascalString dataSetFolder count 'noOfDataSetFolder']
            [simple DataSetMetaDataType('14525') dataSetMetaData]
            [implicit int 32 noOfExtensionFields 'extensionFields == null ? -1 : COUNT(extensionFields)']
            [array KeyValuePair('14535') extensionFields count 'noOfExtensionFields']
            [simple ExtensionObject('true') dataSetSource]
        ]
        ['15582' PublishedDataSetSourceDataType
            
        ]
        ['14275' PublishedVariableDataType
            [simple NodeId publishedVariable]
            [simple uint 32 attributeId]
            [simple float 64 samplingIntervalHint]
            [simple uint 32 deadbandType]
            [simple float 64 deadbandValue]
            [simple PascalString indexRange]
            [simple Variant substituteValue]
            [implicit int 32 noOfMetaDataProperties 'metaDataProperties == null ? -1 : COUNT(metaDataProperties)']
            [array QualifiedName metaDataProperties count 'noOfMetaDataProperties']
        ]
        ['15583' PublishedDataItemsDataType
            [implicit int 32 noOfPublishedData 'publishedData == null ? -1 : COUNT(publishedData)']
            [array PublishedVariableDataType('14275') publishedData count 'noOfPublishedData']
        ]
        ['15584' PublishedEventsDataType
            [simple NodeId eventNotifier]
            [implicit int 32 noOfSelectedFields 'selectedFields == null ? -1 : COUNT(selectedFields)']
            [array SimpleAttributeOperand('603') selectedFields count 'noOfSelectedFields']
            [simple ContentFilter('588') filter]
        ]
        ['25271' PublishedDataSetCustomSourceDataType
            [reserved uint 7 '0x00']
            [simple bit cyclicDataSet]
            
        ]
        ['18595' ActionTargetDataType
            [simple uint 16 actionTargetId]
            [simple PascalString name]
            [simple LocalizedText description]
        ]
        ['18596' PublishedActionDataType
            [simple DataSetMetaDataType('14525') requestDataSetMetaData]
            [implicit int 32 noOfActionTargets 'actionTargets == null ? -1 : COUNT(actionTargets)']
            [array ActionTargetDataType('18595') actionTargets count 'noOfActionTargets']
        ]
        ['18599' ActionMethodDataType
            [simple NodeId objectId]
            [simple NodeId methodId]
        ]
        ['18795' PublishedActionMethodDataType
            [simple DataSetMetaDataType('14525') requestDataSetMetaData]
            [implicit int 32 noOfActionTargets 'actionTargets == null ? -1 : COUNT(actionTargets)']
            [array ActionTargetDataType('18595') actionTargets count 'noOfActionTargets']
            [implicit int 32 noOfActionMethods 'actionMethods == null ? -1 : COUNT(actionMethods)']
            [array ActionMethodDataType('18599') actionMethods count 'noOfActionMethods']
        ]
        ['15599' DataSetWriterDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple uint 16 dataSetWriterId]
            [simple DataSetFieldContentMask dataSetFieldContentMask]
            [simple uint 32 keyFrameCount]
            [simple PascalString dataSetName]
            [implicit int 32 noOfDataSetWriterProperties 'dataSetWriterProperties == null ? -1 : COUNT(dataSetWriterProperties)']
            [array KeyValuePair('14535') dataSetWriterProperties count 'noOfDataSetWriterProperties']
            [simple ExtensionObject('true') transportSettings]
            [simple ExtensionObject('true') messageSettings]
        ]
        ['15600' DataSetWriterTransportDataType
            
        ]
        ['15607' DataSetWriterMessageDataType
            
        ]
        ['15611' PubSubGroupDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityGroupId]
            [implicit int 32 noOfSecurityKeyServices 'securityKeyServices == null ? -1 : COUNT(securityKeyServices)']
            [array EndpointDescription('314') securityKeyServices count 'noOfSecurityKeyServices']
            [simple uint 32 maxNetworkMessageSize]
            [implicit int 32 noOfGroupProperties 'groupProperties == null ? -1 : COUNT(groupProperties)']
            [array KeyValuePair('14535') groupProperties count 'noOfGroupProperties']
        ]
        ['15482' WriterGroupDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityGroupId]
            [implicit int 32 noOfSecurityKeyServices 'securityKeyServices == null ? -1 : COUNT(securityKeyServices)']
            [array EndpointDescription('314') securityKeyServices count 'noOfSecurityKeyServices']
            [simple uint 32 maxNetworkMessageSize]
            [implicit int 32 noOfGroupProperties 'groupProperties == null ? -1 : COUNT(groupProperties)']
            [array KeyValuePair('14535') groupProperties count 'noOfGroupProperties']
            [simple uint 16 writerGroupId]
            [simple float 64 publishingInterval]
            [simple float 64 keepAliveTime]
            [simple uint 8 priority]
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [simple PascalString headerLayoutUri]
            [simple ExtensionObject('true') transportSettings]
            [simple ExtensionObject('true') messageSettings]
            [implicit int 32 noOfDataSetWriters 'dataSetWriters == null ? -1 : COUNT(dataSetWriters)']
            [array DataSetWriterDataType('15599') dataSetWriters count 'noOfDataSetWriters']
        ]
        ['15613' WriterGroupTransportDataType
            
        ]
        ['15618' WriterGroupMessageDataType
            
        ]
        ['15619' PubSubConnectionDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple Variant publisherId]
            [simple PascalString transportProfileUri]
            [simple ExtensionObject('true') address]
            [implicit int 32 noOfConnectionProperties 'connectionProperties == null ? -1 : COUNT(connectionProperties)']
            [array KeyValuePair('14535') connectionProperties count 'noOfConnectionProperties']
            [simple ExtensionObject('true') transportSettings]
            [implicit int 32 noOfWriterGroups 'writerGroups == null ? -1 : COUNT(writerGroups)']
            [array WriterGroupDataType('15482') writerGroups count 'noOfWriterGroups']
            [implicit int 32 noOfReaderGroups 'readerGroups == null ? -1 : COUNT(readerGroups)']
            [array ReaderGroupDataType('15522') readerGroups count 'noOfReaderGroups']
        ]
        ['15620' ConnectionTransportDataType
            
        ]
        ['15504' NetworkAddressDataType
            [simple PascalString networkInterface]
        ]
        ['15512' NetworkAddressUrlDataType
            [simple PascalString networkInterface]
            [simple PascalString url]
        ]
        ['15522' ReaderGroupDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityGroupId]
            [implicit int 32 noOfSecurityKeyServices 'securityKeyServices == null ? -1 : COUNT(securityKeyServices)']
            [array EndpointDescription('314') securityKeyServices count 'noOfSecurityKeyServices']
            [simple uint 32 maxNetworkMessageSize]
            [implicit int 32 noOfGroupProperties 'groupProperties == null ? -1 : COUNT(groupProperties)']
            [array KeyValuePair('14535') groupProperties count 'noOfGroupProperties']
            [simple ExtensionObject('true') transportSettings]
            [simple ExtensionObject('true') messageSettings]
            [implicit int 32 noOfDataSetReaders 'dataSetReaders == null ? -1 : COUNT(dataSetReaders)']
            [array DataSetReaderDataType('15625') dataSetReaders count 'noOfDataSetReaders']
        ]
        ['15623' ReaderGroupTransportDataType
            
        ]
        ['15624' ReaderGroupMessageDataType
            
        ]
        ['15625' DataSetReaderDataType
            [simple PascalString name]
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [simple Variant publisherId]
            [simple uint 16 writerGroupId]
            [simple uint 16 dataSetWriterId]
            [simple DataSetMetaDataType('14525') dataSetMetaData]
            [simple DataSetFieldContentMask dataSetFieldContentMask]
            [simple float 64 messageReceiveTimeout]
            [simple uint 32 keyFrameCount]
            [simple PascalString headerLayoutUri]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityGroupId]
            [implicit int 32 noOfSecurityKeyServices 'securityKeyServices == null ? -1 : COUNT(securityKeyServices)']
            [array EndpointDescription('314') securityKeyServices count 'noOfSecurityKeyServices']
            [implicit int 32 noOfDataSetReaderProperties 'dataSetReaderProperties == null ? -1 : COUNT(dataSetReaderProperties)']
            [array KeyValuePair('14535') dataSetReaderProperties count 'noOfDataSetReaderProperties']
            [simple ExtensionObject('true') transportSettings]
            [simple ExtensionObject('true') messageSettings]
            [simple ExtensionObject('true') subscribedDataSet]
        ]
        ['15630' DataSetReaderTransportDataType
            
        ]
        ['15631' DataSetReaderMessageDataType
            
        ]
        ['15632' SubscribedDataSetDataType
            
        ]
        ['15633' TargetVariablesDataType
            [implicit int 32 noOfTargetVariables 'targetVariables == null ? -1 : COUNT(targetVariables)']
            [array FieldTargetDataType('14746') targetVariables count 'noOfTargetVariables']
        ]
        ['14746' FieldTargetDataType
            [simple GuidValue dataSetFieldId]
            [simple PascalString receiverIndexRange]
            [simple NodeId targetNodeId]
            [simple uint 32 attributeId]
            [simple PascalString writeIndexRange]
            [simple OverrideValueHandling overrideValueHandling]
            [simple Variant overrideValue]
        ]
        ['15637' SubscribedDataSetMirrorDataType
            [simple PascalString parentNodeName]
            [implicit int 32 noOfRolePermissions 'rolePermissions == null ? -1 : COUNT(rolePermissions)']
            [array RolePermissionType('98') rolePermissions count 'noOfRolePermissions']
        ]
        ['15532' PubSubConfigurationDataType
            [implicit int 32 noOfPublishedDataSets 'publishedDataSets == null ? -1 : COUNT(publishedDataSets)']
            [array PublishedDataSetDataType('15580') publishedDataSets count 'noOfPublishedDataSets']
            [implicit int 32 noOfConnections 'connections == null ? -1 : COUNT(connections)']
            [array PubSubConnectionDataType('15619') connections count 'noOfConnections']
            [reserved uint 7 '0x00']
            [simple bit enabled]
            
        ]
        ['23601' StandaloneSubscribedDataSetRefDataType
            [simple PascalString dataSetName]
        ]
        ['23602' StandaloneSubscribedDataSetDataType
            [simple PascalString name]
            [implicit int 32 noOfDataSetFolder 'dataSetFolder == null ? -1 : COUNT(dataSetFolder)']
            [array PascalString dataSetFolder count 'noOfDataSetFolder']
            [simple DataSetMetaDataType('14525') dataSetMetaData]
            [simple ExtensionObject('true') subscribedDataSet]
        ]
        ['23603' SecurityGroupDataType
            [simple PascalString name]
            [implicit int 32 noOfSecurityGroupFolder 'securityGroupFolder == null ? -1 : COUNT(securityGroupFolder)']
            [array PascalString securityGroupFolder count 'noOfSecurityGroupFolder']
            [simple float 64 keyLifetime]
            [simple PascalString securityPolicyUri]
            [simple uint 32 maxFutureKeyCount]
            [simple uint 32 maxPastKeyCount]
            [simple PascalString securityGroupId]
            [implicit int 32 noOfRolePermissions 'rolePermissions == null ? -1 : COUNT(rolePermissions)']
            [array RolePermissionType('98') rolePermissions count 'noOfRolePermissions']
            [implicit int 32 noOfGroupProperties 'groupProperties == null ? -1 : COUNT(groupProperties)']
            [array KeyValuePair('14535') groupProperties count 'noOfGroupProperties']
        ]
        ['25272' PubSubKeyPushTargetDataType
            [simple PascalString applicationUri]
            [implicit int 32 noOfPushTargetFolder 'pushTargetFolder == null ? -1 : COUNT(pushTargetFolder)']
            [array PascalString pushTargetFolder count 'noOfPushTargetFolder']
            [simple PascalString endpointUrl]
            [simple PascalString securityPolicyUri]
            [simple UserTokenPolicy('306') userTokenType]
            [simple uint 16 requestedKeyCount]
            [simple float 64 retryInterval]
            [implicit int 32 noOfPushTargetProperties 'pushTargetProperties == null ? -1 : COUNT(pushTargetProperties)']
            [array KeyValuePair('14535') pushTargetProperties count 'noOfPushTargetProperties']
            [implicit int 32 noOfSecurityGroups 'securityGroups == null ? -1 : COUNT(securityGroups)']
            [array PascalString securityGroups count 'noOfSecurityGroups']
        ]
        ['23604' PubSubConfiguration2DataType
            [implicit int 32 noOfPublishedDataSets 'publishedDataSets == null ? -1 : COUNT(publishedDataSets)']
            [array PublishedDataSetDataType('15580') publishedDataSets count 'noOfPublishedDataSets']
            [implicit int 32 noOfConnections 'connections == null ? -1 : COUNT(connections)']
            [array PubSubConnectionDataType('15619') connections count 'noOfConnections']
            [reserved uint 7 '0x00']
            [simple bit enabled]
            [implicit int 32 noOfSubscribedDataSets 'subscribedDataSets == null ? -1 : COUNT(subscribedDataSets)']
            [array StandaloneSubscribedDataSetDataType('23602') subscribedDataSets count 'noOfSubscribedDataSets']
            [implicit int 32 noOfDataSetClasses 'dataSetClasses == null ? -1 : COUNT(dataSetClasses)']
            [array DataSetMetaDataType('14525') dataSetClasses count 'noOfDataSetClasses']
            [implicit int 32 noOfDefaultSecurityKeyServices 'defaultSecurityKeyServices == null ? -1 : COUNT(defaultSecurityKeyServices)']
            [array EndpointDescription('314') defaultSecurityKeyServices count 'noOfDefaultSecurityKeyServices']
            [implicit int 32 noOfSecurityGroups 'securityGroups == null ? -1 : COUNT(securityGroups)']
            [array SecurityGroupDataType('23603') securityGroups count 'noOfSecurityGroups']
            [implicit int 32 noOfPubSubKeyPushTargets 'pubSubKeyPushTargets == null ? -1 : COUNT(pubSubKeyPushTargets)']
            [array PubSubKeyPushTargetDataType('25272') pubSubKeyPushTargets count 'noOfPubSubKeyPushTargets']
            [simple uint 32 configurationVersion]
            [implicit int 32 noOfConfigurationProperties 'configurationProperties == null ? -1 : COUNT(configurationProperties)']
            [array KeyValuePair('14535') configurationProperties count 'noOfConfigurationProperties']
        ]
        ['15647' UadpWriterGroupMessageDataType
            [simple uint 32 groupVersion]
            [simple DataSetOrderingType dataSetOrdering]
            [simple UadpNetworkMessageContentMask networkMessageContentMask]
            [simple float 64 samplingOffset]
            [implicit int 32 noOfPublishingOffset 'publishingOffset == null ? -1 : COUNT(publishingOffset)']
            [array float 64 publishingOffset count 'noOfPublishingOffset']
        ]
        ['15654' UadpDataSetWriterMessageDataType
            [simple UadpDataSetMessageContentMask dataSetMessageContentMask]
            [simple uint 16 configuredSize]
            [simple uint 16 networkMessageNumber]
            [simple uint 16 dataSetOffset]
        ]
        ['15655' UadpDataSetReaderMessageDataType
            [simple uint 32 groupVersion]
            [simple uint 16 networkMessageNumber]
            [simple uint 16 dataSetOffset]
            [simple GuidValue dataSetClassId]
            [simple UadpNetworkMessageContentMask networkMessageContentMask]
            [simple UadpDataSetMessageContentMask dataSetMessageContentMask]
            [simple float 64 publishingInterval]
            [simple float 64 receiveOffset]
            [simple float 64 processingOffset]
        ]
        ['15659' JsonWriterGroupMessageDataType
            [simple JsonNetworkMessageContentMask networkMessageContentMask]
        ]
        ['15666' JsonDataSetWriterMessageDataType
            [simple JsonDataSetMessageContentMask dataSetMessageContentMask]
        ]
        ['15667' JsonDataSetReaderMessageDataType
            [simple JsonNetworkMessageContentMask networkMessageContentMask]
            [simple JsonDataSetMessageContentMask dataSetMessageContentMask]
        ]
        ['23605' QosDataType
            
        ]
        ['23606' TransmitQosDataType
            
        ]
        ['23607' TransmitQosPriorityDataType
            [simple PascalString priorityLabel]
        ]
        ['23610' ReceiveQosDataType
            
        ]
        ['23611' ReceiveQosPriorityDataType
            [simple PascalString priorityLabel]
        ]
        ['17469' DatagramConnectionTransportDataType
            [simple ExtensionObject('true') discoveryAddress]
        ]
        ['23614' DatagramConnectionTransport2DataType
            [simple ExtensionObject('true') discoveryAddress]
            [simple uint 32 discoveryAnnounceRate]
            [simple uint 32 discoveryMaxMessageSize]
            [simple PascalString qosCategory]
            [implicit int 32 noOfDatagramQos 'datagramQos == null ? -1 : COUNT(datagramQos)']
            [array ExtensionObject('true') datagramQos count 'noOfDatagramQos']
        ]
        ['15534' DatagramWriterGroupTransportDataType
            [simple uint 8 messageRepeatCount]
            [simple float 64 messageRepeatDelay]
        ]
        ['23615' DatagramWriterGroupTransport2DataType
            [simple uint 8 messageRepeatCount]
            [simple float 64 messageRepeatDelay]
            [simple ExtensionObject('true') address]
            [simple PascalString qosCategory]
            [implicit int 32 noOfDatagramQos 'datagramQos == null ? -1 : COUNT(datagramQos)']
            [array ExtensionObject('true') datagramQos count 'noOfDatagramQos']
            [simple uint 32 discoveryAnnounceRate]
            [simple PascalString topic]
        ]
        ['23616' DatagramDataSetReaderTransportDataType
            [simple ExtensionObject('true') address]
            [simple PascalString qosCategory]
            [implicit int 32 noOfDatagramQos 'datagramQos == null ? -1 : COUNT(datagramQos)']
            [array ExtensionObject('true') datagramQos count 'noOfDatagramQos']
            [simple PascalString topic]
        ]
        ['18796' DtlsPubSubConnectionDataType
            [simple PascalString clientCipherSuite]
            [implicit int 32 noOfServerCipherSuites 'serverCipherSuites == null ? -1 : COUNT(serverCipherSuites)']
            [array PascalString serverCipherSuites count 'noOfServerCipherSuites']
            [reserved uint 7 '0x00']
            [simple bit zeroRTT]
            [simple NodeId certificateGroupId]
            [reserved uint 7 '0x00']
            [simple bit verifyClientCertificate]
            
        ]
        ['15009' BrokerConnectionTransportDataType
            [simple PascalString resourceUri]
            [simple PascalString authenticationProfileUri]
        ]
        ['15669' BrokerWriterGroupTransportDataType
            [simple PascalString queueName]
            [simple PascalString resourceUri]
            [simple PascalString authenticationProfileUri]
            [simple BrokerTransportQualityOfService requestedDeliveryGuarantee]
        ]
        ['15671' BrokerDataSetWriterTransportDataType
            [simple PascalString queueName]
            [simple PascalString resourceUri]
            [simple PascalString authenticationProfileUri]
            [simple BrokerTransportQualityOfService requestedDeliveryGuarantee]
            [simple PascalString metaDataQueueName]
            [simple float 64 metaDataUpdateTime]
        ]
        ['15672' BrokerDataSetReaderTransportDataType
            [simple PascalString queueName]
            [simple PascalString resourceUri]
            [simple PascalString authenticationProfileUri]
            [simple BrokerTransportQualityOfService requestedDeliveryGuarantee]
            [simple PascalString metaDataQueueName]
        ]
        ['25521' PubSubConfigurationRefDataType
            [simple PubSubConfigurationRefMask configurationMask]
            [simple uint 16 elementIndex]
            [simple uint 16 connectionIndex]
            [simple uint 16 groupIndex]
        ]
        ['25522' PubSubConfigurationValueDataType
            [simple PubSubConfigurationRefDataType('25521') configurationElement]
            [simple PascalString name]
            [simple Variant identifier]
        ]
        ['19313' JsonNetworkMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple PascalString writerGroupName]
            [simple PascalString dataSetClassId]
            [implicit int 32 noOfMessages 'messages == null ? -1 : COUNT(messages)']
            [array ExtensionObject('true') messages count 'noOfMessages']
        ]
        ['19314' JsonDataSetMessage
            [simple uint 16 dataSetWriterId]
            [simple PascalString dataSetWriterName]
            [simple PascalString publisherId]
            [simple PascalString writerGroupName]
            [simple uint 32 sequenceNumber]
            [simple ConfigurationVersionDataType('14595') metaDataVersion]
            [simple uint 32 minorVersion]
            [simple int 64 timestamp]
            [simple StatusCode status]
            [simple PascalString messageType]
            [simple ExtensionObject('true') payload]
        ]
        ['19315' JsonDataSetMetaDataMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple uint 16 dataSetWriterId]
            [simple PascalString writerGroupName]
            [simple PascalString dataSetWriterName]
            [simple int 64 timestamp]
            [simple DataSetMetaDataType('14525') metaData]
        ]
        ['19316' JsonApplicationDescriptionMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [simple ApplicationDescription('310') description]
            [implicit int 32 noOfServerCapabilities 'serverCapabilities == null ? -1 : COUNT(serverCapabilities)']
            [array PascalString serverCapabilities count 'noOfServerCapabilities']
        ]
        ['19317' JsonServerEndpointsMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [simple ApplicationDescription('310') description]
            [implicit int 32 noOfEndpoints 'endpoints == null ? -1 : COUNT(endpoints)']
            [array EndpointDescription('314') endpoints count 'noOfEndpoints']
        ]
        ['19318' JsonStatusMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [reserved uint 7 '0x00']
            [simple bit isCyclic]
            [simple PubSubState status]
            [simple int 64 nextReportTime]
        ]
        ['19319' JsonPubSubConnectionMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [simple PubSubConnectionDataType('15619') connection]
        ]
        ['19320' JsonActionMetaDataMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple uint 16 dataSetWriterId]
            [simple PascalString dataSetWriterName]
            [simple int 64 timestamp]
            [implicit int 32 noOfActionTargets 'actionTargets == null ? -1 : COUNT(actionTargets)']
            [array ActionTargetDataType('18595') actionTargets count 'noOfActionTargets']
            [simple DataSetMetaDataType('14525') request]
            [simple DataSetMetaDataType('14525') response]
            [implicit int 32 noOfActionMethods 'actionMethods == null ? -1 : COUNT(actionMethods)']
            [array ActionMethodDataType('18599') actionMethods count 'noOfActionMethods']
        ]
        ['19321' JsonActionResponderMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [simple PubSubConnectionDataType('15619') connection]
        ]
        ['19322' JsonActionNetworkMessage
            [simple PascalString messageId]
            [simple PascalString messageType]
            [simple PascalString publisherId]
            [simple int 64 timestamp]
            [simple PascalString responseAddress]
            [simple PascalByteString correlationData]
            [simple PascalString requestorId]
            [simple float 64 timeoutHint]
            [implicit int 32 noOfMessages 'messages == null ? -1 : COUNT(messages)']
            [array ExtensionObject('true') messages count 'noOfMessages']
        ]
        ['19323' JsonActionRequestMessage
            [simple uint 16 dataSetWriterId]
            [simple uint 16 actionTargetId]
            [simple PascalString dataSetWriterName]
            [simple PascalString writerGroupName]
            [simple ConfigurationVersionDataType('14595') metaDataVersion]
            [simple uint 32 minorVersion]
            [simple int 64 timestamp]
            [simple PascalString messageType]
            [simple uint 16 requestId]
            [simple ActionState actionState]
            [simple ExtensionObject('true') payload]
        ]
        ['19324' JsonActionResponseMessage
            [simple uint 16 dataSetWriterId]
            [simple uint 16 actionTargetId]
            [simple PascalString dataSetWriterName]
            [simple PascalString writerGroupName]
            [simple ConfigurationVersionDataType('14595') metaDataVersion]
            [simple uint 32 minorVersion]
            [simple int 64 timestamp]
            [simple StatusCode status]
            [simple PascalString messageType]
            [simple uint 16 requestId]
            [simple ActionState actionState]
            [simple ExtensionObject('true') payload]
        ]
        ['23470' AliasNameDataType
            [simple QualifiedName aliasName]
            [implicit int 32 noOfReferencedNodes 'referencedNodes == null ? -1 : COUNT(referencedNodes)']
            [array ExpandedNodeId referencedNodes count 'noOfReferencedNodes']
        ]
        ['24283' UserManagementDataType
            [simple PascalString userName]
            [simple UserConfigurationMask userConfiguration]
            [simple PascalString description]
        ]
        ['25222' PriorityMappingEntryType
            [simple PascalString mappingUri]
            [simple PascalString priorityLabel]
            [simple uint 8 priorityValue_PCP]
            [simple uint 32 priorityValue_DSCP]
        ]
        ['18955' LldpManagementAddressTxPortType
            [simple uint 32 addressSubtype]
            [simple PascalString manAddress]
            [reserved uint 7 '0x00']
            [simple bit txEnable]
            [simple uint 32 addrLen]
            [simple ManAddrIfSubtype ifSubtype]
            [simple uint 32 ifId]
        ]
        ['18956' LldpManagementAddressType
            [simple uint 32 addressSubtype]
            [simple PascalString address]
            [simple ManAddrIfSubtype ifSubtype]
            [simple uint 32 ifId]
        ]
        ['18957' LldpTlvType
            [simple uint 32 tlvType]
            [simple PascalByteString tlvInfo]
        ]
        ['32661' ReferenceDescriptionDataType
            [simple NodeId sourceNode]
            [simple NodeId referenceType]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNode]
        ]
        ['32662' ReferenceListEntryDataType
            [simple NodeId referenceType]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNode]
        ]
        ['19363' LogRecord
            [simple int 64 eventTime]
            [simple uint 16 severity]
            [simple NodeId eventType]
            [simple NodeId sourceNode]
            [simple PascalString sourceName]
            [simple LocalizedText message]
            [simple TraceContextDataType('19749') traceContext]
            [implicit int 32 noOfAdditionalData 'additionalData == null ? -1 : COUNT(additionalData)']
            [array NameValuePair('19750') additionalData count 'noOfAdditionalData']
        ]
        ['19747' LogRecordsDataType
            [implicit int 32 noOfLogRecordArray 'logRecordArray == null ? -1 : COUNT(logRecordArray)']
            [array LogRecord('19363') logRecordArray count 'noOfLogRecordArray']
        ]
        ['19748' SpanContextDataType
            [simple GuidValue traceId]
            [simple uint 64 spanId]
        ]
        ['19749' TraceContextDataType
            [simple GuidValue traceId]
            [simple uint 64 spanId]
            [simple uint 64 parentSpanId]
            [simple PascalString parentIdentifier]
        ]
        ['19750' NameValuePair
            [simple PascalString name]
            [simple Variant value]
        ]
        ['98' RolePermissionType
            [simple NodeId roleId]
            [simple PermissionType permissions]
        ]
        ['99' DataTypeDefinition
            
        ]
        ['103' StructureField
            [simple PascalString name]
            [simple LocalizedText description]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [implicit int 32 noOfArrayDimensions 'arrayDimensions == null ? -1 : COUNT(arrayDimensions)']
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
            [simple uint 32 maxStringLength]
            [reserved uint 7 '0x00']
            [simple bit isOptional]
            
        ]
        ['101' StructureDefinition
            [simple NodeId defaultEncodingId]
            [simple NodeId baseDataType]
            [simple StructureType structureType]
            [implicit int 32 noOfFields 'fields == null ? -1 : COUNT(fields)']
            [array StructureField('103') fields count 'noOfFields']
        ]
        ['102' EnumDefinition
            [implicit int 32 noOfFields 'fields == null ? -1 : COUNT(fields)']
            [array EnumField('104') fields count 'noOfFields']
        ]
        ['298' Argument
            [simple PascalString name]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [implicit int 32 noOfArrayDimensions 'arrayDimensions == null ? -1 : COUNT(arrayDimensions)']
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
            [simple LocalizedText description]
        ]
        ['7596' EnumValueType
            [simple int 64 value]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
        ]
        ['104' EnumField
            [simple int 64 value]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple PascalString name]
        ]
        ['12757' OptionSet
            [simple PascalByteString value]
            [simple PascalByteString validBits]
        ]
        ['8914' TimeZoneDataType
            [simple int 16 offset]
            [reserved uint 7 '0x00']
            [simple bit daylightSavingInOffset]
            
        ]
        ['310' ApplicationDescription
            [simple PascalString applicationUri]
            [simple PascalString productUri]
            [simple LocalizedText applicationName]
            [simple ApplicationType applicationType]
            [simple PascalString gatewayServerUri]
            [simple PascalString discoveryProfileUri]
            [implicit int 32 noOfDiscoveryUrls 'discoveryUrls == null ? -1 : COUNT(discoveryUrls)']
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
        ]
        ['391' RequestHeader
            [simple NodeId authenticationToken]
            [simple int 64 timestamp]
            [simple uint 32 requestHandle]
            [simple uint 32 returnDiagnostics]
            [simple PascalString auditEntryId]
            [simple uint 32 timeoutHint]
            [simple ExtensionObject('true') additionalHeader]
        ]
        ['394' ResponseHeader
            [simple int 64 timestamp]
            [simple uint 32 requestHandle]
            [simple StatusCode serviceResult]
            [simple DiagnosticInfo serviceDiagnostics]
            [implicit int 32 noOfStringTable 'stringTable == null ? -1 : COUNT(stringTable)']
            [array PascalString stringTable count 'noOfStringTable']
            [simple ExtensionObject('true') additionalHeader]
        ]
        ['397' ServiceFault
            [simple ResponseHeader('394') responseHeader]
        ]
        ['15903' SessionlessInvokeRequestType
            [simple uint 32 urisVersion]
            [implicit int 32 noOfNamespaceUris 'namespaceUris == null ? -1 : COUNT(namespaceUris)']
            [array PascalString namespaceUris count 'noOfNamespaceUris']
            [implicit int 32 noOfServerUris 'serverUris == null ? -1 : COUNT(serverUris)']
            [array PascalString serverUris count 'noOfServerUris']
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [simple uint 32 serviceId]
        ]
        ['21001' SessionlessInvokeResponseType
            [implicit int 32 noOfNamespaceUris 'namespaceUris == null ? -1 : COUNT(namespaceUris)']
            [array PascalString namespaceUris count 'noOfNamespaceUris']
            [implicit int 32 noOfServerUris 'serverUris == null ? -1 : COUNT(serverUris)']
            [array PascalString serverUris count 'noOfServerUris']
            [simple uint 32 serviceId]
        ]
        ['422' FindServersRequest
            [simple RequestHeader('391') requestHeader]
            [simple PascalString endpointUrl]
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [implicit int 32 noOfServerUris 'serverUris == null ? -1 : COUNT(serverUris)']
            [array PascalString serverUris count 'noOfServerUris']
        ]
        ['425' FindServersResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfServers 'servers == null ? -1 : COUNT(servers)']
            [array ApplicationDescription('310') servers count 'noOfServers']
        ]
        ['12191' ServerOnNetwork
            [simple uint 32 recordId]
            [simple PascalString serverName]
            [simple PascalString discoveryUrl]
            [implicit int 32 noOfServerCapabilities 'serverCapabilities == null ? -1 : COUNT(serverCapabilities)']
            [array PascalString serverCapabilities count 'noOfServerCapabilities']
        ]
        ['12192' FindServersOnNetworkRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 startingRecordId]
            [simple uint 32 maxRecordsToReturn]
            [implicit int 32 noOfServerCapabilityFilter 'serverCapabilityFilter == null ? -1 : COUNT(serverCapabilityFilter)']
            [array PascalString serverCapabilityFilter count 'noOfServerCapabilityFilter']
        ]
        ['12193' FindServersOnNetworkResponse
            [simple ResponseHeader('394') responseHeader]
            [simple int 64 lastCounterResetTime]
            [implicit int 32 noOfServers 'servers == null ? -1 : COUNT(servers)']
            [array ServerOnNetwork('12191') servers count 'noOfServers']
        ]
        ['306' UserTokenPolicy
            [simple PascalString policyId]
            [simple UserTokenType tokenType]
            [simple PascalString issuedTokenType]
            [simple PascalString issuerEndpointUrl]
            [simple PascalString securityPolicyUri]
        ]
        ['314' EndpointDescription
            [simple PascalString endpointUrl]
            [simple ApplicationDescription('310') server]
            [simple PascalByteString serverCertificate]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [implicit int 32 noOfUserIdentityTokens 'userIdentityTokens == null ? -1 : COUNT(userIdentityTokens)']
            [array UserTokenPolicy('306') userIdentityTokens count 'noOfUserIdentityTokens']
            [simple PascalString transportProfileUri]
            [simple uint 8 securityLevel]
        ]
        ['428' GetEndpointsRequest
            [simple RequestHeader('391') requestHeader]
            [simple PascalString endpointUrl]
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [implicit int 32 noOfProfileUris 'profileUris == null ? -1 : COUNT(profileUris)']
            [array PascalString profileUris count 'noOfProfileUris']
        ]
        ['431' GetEndpointsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfEndpoints 'endpoints == null ? -1 : COUNT(endpoints)']
            [array EndpointDescription('314') endpoints count 'noOfEndpoints']
        ]
        ['434' RegisteredServer
            [simple PascalString serverUri]
            [simple PascalString productUri]
            [implicit int 32 noOfServerNames 'serverNames == null ? -1 : COUNT(serverNames)']
            [array LocalizedText serverNames count 'noOfServerNames']
            [simple ApplicationType serverType]
            [simple PascalString gatewayServerUri]
            [implicit int 32 noOfDiscoveryUrls 'discoveryUrls == null ? -1 : COUNT(discoveryUrls)']
            [array PascalString discoveryUrls count 'noOfDiscoveryUrls']
            [simple PascalString semaphoreFilePath]
            [reserved uint 7 '0x00']
            [simple bit isOnline]
            
        ]
        ['437' RegisterServerRequest
            [simple RequestHeader('391') requestHeader]
            [simple RegisteredServer('434') server]
        ]
        ['440' RegisterServerResponse
            [simple ResponseHeader('394') responseHeader]
        ]
        ['12892' DiscoveryConfiguration
            
        ]
        ['12893' MdnsDiscoveryConfiguration
            [simple PascalString mdnsServerName]
            [implicit int 32 noOfServerCapabilities 'serverCapabilities == null ? -1 : COUNT(serverCapabilities)']
            [array PascalString serverCapabilities count 'noOfServerCapabilities']
        ]
        ['12195' RegisterServer2Request
            [simple RequestHeader('391') requestHeader]
            [simple RegisteredServer('434') server]
            [implicit int 32 noOfDiscoveryConfiguration 'discoveryConfiguration == null ? -1 : COUNT(discoveryConfiguration)']
            [array ExtensionObject('true') discoveryConfiguration count 'noOfDiscoveryConfiguration']
        ]
        ['12196' RegisterServer2Response
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfConfigurationResults 'configurationResults == null ? -1 : COUNT(configurationResults)']
            [array StatusCode configurationResults count 'noOfConfigurationResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['443' ChannelSecurityToken
            [simple uint 32 channelId]
            [simple uint 32 tokenId]
            [simple int 64 createdAt]
            [simple uint 32 revisedLifetime]
        ]
        ['446' OpenSecureChannelRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 clientProtocolVersion]
            [simple SecurityTokenRequestType requestType]
            [simple MessageSecurityMode securityMode]
            [simple PascalByteString clientNonce]
            [simple uint 32 requestedLifetime]
        ]
        ['449' OpenSecureChannelResponse
            [simple ResponseHeader('394') responseHeader]
            [simple uint 32 serverProtocolVersion]
            [simple ChannelSecurityToken('443') securityToken]
            [simple PascalByteString serverNonce]
        ]
        ['452' CloseSecureChannelRequest
            [simple RequestHeader('391') requestHeader]
        ]
        ['455' CloseSecureChannelResponse
            [simple ResponseHeader('394') responseHeader]
        ]
        ['346' SignedSoftwareCertificate
            [simple PascalByteString certificateData]
            [simple PascalByteString signature]
        ]
        ['458' SignatureData
            [simple PascalString algorithm]
            [simple PascalByteString signature]
        ]
        ['461' CreateSessionRequest
            [simple RequestHeader('391') requestHeader]
            [simple ApplicationDescription('310') clientDescription]
            [simple PascalString serverUri]
            [simple PascalString endpointUrl]
            [simple PascalString sessionName]
            [simple PascalByteString clientNonce]
            [simple PascalByteString clientCertificate]
            [simple float 64 requestedSessionTimeout]
            [simple uint 32 maxResponseMessageSize]
        ]
        ['464' CreateSessionResponse
            [simple ResponseHeader('394') responseHeader]
            [simple NodeId sessionId]
            [simple NodeId authenticationToken]
            [simple float 64 revisedSessionTimeout]
            [simple PascalByteString serverNonce]
            [simple PascalByteString serverCertificate]
            [implicit int 32 noOfServerEndpoints 'serverEndpoints == null ? -1 : COUNT(serverEndpoints)']
            [array EndpointDescription('314') serverEndpoints count 'noOfServerEndpoints']
            [implicit int 32 noOfServerSoftwareCertificates 'serverSoftwareCertificates == null ? -1 : COUNT(serverSoftwareCertificates)']
            [array SignedSoftwareCertificate('346') serverSoftwareCertificates count 'noOfServerSoftwareCertificates']
            [simple SignatureData('458') serverSignature]
            [simple uint 32 maxRequestMessageSize]
        ]
        ['318' UserIdentityToken
            [simple PascalString policyId]
        ]
        ['321' AnonymousIdentityToken
            [simple PascalString policyId]
        ]
        ['324' UserNameIdentityToken
            [simple PascalString policyId]
            [simple PascalString userName]
            [simple PascalByteString password]
            [simple PascalString encryptionAlgorithm]
        ]
        ['327' X509IdentityToken
            [simple PascalString policyId]
            [simple PascalByteString certificateData]
        ]
        ['940' IssuedIdentityToken
            [simple PascalString policyId]
            [simple PascalByteString tokenData]
            [simple PascalString encryptionAlgorithm]
        ]
        ['467' ActivateSessionRequest
            [simple RequestHeader('391') requestHeader]
            [simple SignatureData('458') clientSignature]
            [implicit int 32 noOfClientSoftwareCertificates 'clientSoftwareCertificates == null ? -1 : COUNT(clientSoftwareCertificates)']
            [array SignedSoftwareCertificate('346') clientSoftwareCertificates count 'noOfClientSoftwareCertificates']
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [simple ExtensionObject('true') userIdentityToken]
            [simple SignatureData('458') userTokenSignature]
        ]
        ['470' ActivateSessionResponse
            [simple ResponseHeader('394') responseHeader]
            [simple PascalByteString serverNonce]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['473' CloseSessionRequest
            [simple RequestHeader('391') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit deleteSubscriptions]
            
        ]
        ['476' CloseSessionResponse
            [simple ResponseHeader('394') responseHeader]
        ]
        ['479' CancelRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 requestHandle]
        ]
        ['482' CancelResponse
            [simple ResponseHeader('394') responseHeader]
            [simple uint 32 cancelCount]
        ]
        ['351' NodeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
        ]
        ['354' ObjectAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [simple uint 8 eventNotifier]
        ]
        ['357' VariableAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [simple Variant value]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [implicit int 32 noOfArrayDimensions 'arrayDimensions == null ? -1 : COUNT(arrayDimensions)']
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
            [simple uint 8 accessLevel]
            [simple uint 8 userAccessLevel]
            [simple float 64 minimumSamplingInterval]
            [reserved uint 7 '0x00']
            [simple bit historizing]
            
        ]
        ['360' MethodAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [reserved uint 6 '0x00']
            [simple bit userExecutable]
            [simple bit executable]
            
        ]
        ['363' ObjectTypeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [reserved uint 7 '0x00']
            [simple bit isAbstract]
            
        ]
        ['366' VariableTypeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [simple Variant value]
            [simple NodeId dataType]
            [simple int 32 valueRank]
            [implicit int 32 noOfArrayDimensions 'arrayDimensions == null ? -1 : COUNT(arrayDimensions)']
            [array uint 32 arrayDimensions count 'noOfArrayDimensions']
            [reserved uint 7 '0x00']
            [simple bit isAbstract]
            
        ]
        ['369' ReferenceTypeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [reserved uint 6 '0x00']
            [simple bit symmetric]
            [simple bit isAbstract]
            [simple LocalizedText inverseName]
        ]
        ['372' DataTypeAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [reserved uint 7 '0x00']
            [simple bit isAbstract]
            
        ]
        ['375' ViewAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [reserved uint 7 '0x00']
            [simple bit containsNoLoops]
            [simple uint 8 eventNotifier]
        ]
        ['17608' GenericAttributeValue
            [simple uint 32 attributeId]
            [simple Variant value]
        ]
        ['17609' GenericAttributes
            [simple uint 32 specifiedAttributes]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
            [simple uint 32 writeMask]
            [simple uint 32 userWriteMask]
            [implicit int 32 noOfAttributeValues 'attributeValues == null ? -1 : COUNT(attributeValues)']
            [array GenericAttributeValue('17608') attributeValues count 'noOfAttributeValues']
        ]
        ['378' AddNodesItem
            [simple ExpandedNodeId parentNodeId]
            [simple NodeId referenceTypeId]
            [simple ExpandedNodeId requestedNewNodeId]
            [simple QualifiedName browseName]
            [simple NodeClass nodeClass]
            [simple ExtensionObject('true') nodeAttributes]
            [simple ExpandedNodeId typeDefinition]
        ]
        ['485' AddNodesResult
            [simple StatusCode statusCode]
            [simple NodeId addedNodeId]
        ]
        ['488' AddNodesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfNodesToAdd 'nodesToAdd == null ? -1 : COUNT(nodesToAdd)']
            [array AddNodesItem('378') nodesToAdd count 'noOfNodesToAdd']
        ]
        ['491' AddNodesResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array AddNodesResult('485') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['381' AddReferencesItem
            [simple NodeId sourceNodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple PascalString targetServerUri]
            [simple ExpandedNodeId targetNodeId]
            [simple NodeClass targetNodeClass]
        ]
        ['494' AddReferencesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfReferencesToAdd 'referencesToAdd == null ? -1 : COUNT(referencesToAdd)']
            [array AddReferencesItem('381') referencesToAdd count 'noOfReferencesToAdd']
        ]
        ['497' AddReferencesResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['384' DeleteNodesItem
            [simple NodeId nodeId]
            [reserved uint 7 '0x00']
            [simple bit deleteTargetReferences]
            
        ]
        ['500' DeleteNodesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfNodesToDelete 'nodesToDelete == null ? -1 : COUNT(nodesToDelete)']
            [array DeleteNodesItem('384') nodesToDelete count 'noOfNodesToDelete']
        ]
        ['503' DeleteNodesResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['387' DeleteReferencesItem
            [simple NodeId sourceNodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId targetNodeId]
            [reserved uint 7 '0x00']
            [simple bit deleteBidirectional]
            
        ]
        ['506' DeleteReferencesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfReferencesToDelete 'referencesToDelete == null ? -1 : COUNT(referencesToDelete)']
            [array DeleteReferencesItem('387') referencesToDelete count 'noOfReferencesToDelete']
        ]
        ['509' DeleteReferencesResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['513' ViewDescription
            [simple NodeId viewId]
            [simple int 64 timestamp]
            [simple uint 32 viewVersion]
        ]
        ['516' BrowseDescription
            [simple NodeId nodeId]
            [simple BrowseDirection browseDirection]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit includeSubtypes]
            [simple uint 32 nodeClassMask]
            [simple uint 32 resultMask]
        ]
        ['520' ReferenceDescription
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [simple ExpandedNodeId nodeId]
            [simple QualifiedName browseName]
            [simple LocalizedText displayName]
            [simple NodeClass nodeClass]
            [simple ExpandedNodeId typeDefinition]
        ]
        ['524' BrowseResult
            [simple StatusCode statusCode]
            [simple PascalByteString continuationPoint]
            [implicit int 32 noOfReferences 'references == null ? -1 : COUNT(references)']
            [array ReferenceDescription('520') references count 'noOfReferences']
        ]
        ['527' BrowseRequest
            [simple RequestHeader('391') requestHeader]
            [simple ViewDescription('513') view]
            [simple uint 32 requestedMaxReferencesPerNode]
            [implicit int 32 noOfNodesToBrowse 'nodesToBrowse == null ? -1 : COUNT(nodesToBrowse)']
            [array BrowseDescription('516') nodesToBrowse count 'noOfNodesToBrowse']
        ]
        ['530' BrowseResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array BrowseResult('524') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['533' BrowseNextRequest
            [simple RequestHeader('391') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoints]
            [implicit int 32 noOfContinuationPoints 'continuationPoints == null ? -1 : COUNT(continuationPoints)']
            [array PascalByteString continuationPoints count 'noOfContinuationPoints']
        ]
        ['536' BrowseNextResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array BrowseResult('524') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['539' RelativePathElement
            [simple NodeId referenceTypeId]
            [reserved uint 6 '0x00']
            [simple bit includeSubtypes]
            [simple bit isInverse]
            [simple QualifiedName targetName]
        ]
        ['542' RelativePath
            [implicit int 32 noOfElements 'elements == null ? -1 : COUNT(elements)']
            [array RelativePathElement('539') elements count 'noOfElements']
        ]
        ['545' BrowsePath
            [simple NodeId startingNode]
            [simple RelativePath('542') relativePath]
        ]
        ['548' BrowsePathTarget
            [simple ExpandedNodeId targetId]
            [simple uint 32 remainingPathIndex]
        ]
        ['551' BrowsePathResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfTargets 'targets == null ? -1 : COUNT(targets)']
            [array BrowsePathTarget('548') targets count 'noOfTargets']
        ]
        ['554' TranslateBrowsePathsToNodeIdsRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfBrowsePaths 'browsePaths == null ? -1 : COUNT(browsePaths)']
            [array BrowsePath('545') browsePaths count 'noOfBrowsePaths']
        ]
        ['557' TranslateBrowsePathsToNodeIdsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array BrowsePathResult('551') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['560' RegisterNodesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfNodesToRegister 'nodesToRegister == null ? -1 : COUNT(nodesToRegister)']
            [array NodeId nodesToRegister count 'noOfNodesToRegister']
        ]
        ['563' RegisterNodesResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfRegisteredNodeIds 'registeredNodeIds == null ? -1 : COUNT(registeredNodeIds)']
            [array NodeId registeredNodeIds count 'noOfRegisteredNodeIds']
        ]
        ['566' UnregisterNodesRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfNodesToUnregister 'nodesToUnregister == null ? -1 : COUNT(nodesToUnregister)']
            [array NodeId nodesToUnregister count 'noOfNodesToUnregister']
        ]
        ['569' UnregisterNodesResponse
            [simple ResponseHeader('394') responseHeader]
        ]
        ['333' EndpointConfiguration
            [simple int 32 operationTimeout]
            [reserved uint 7 '0x00']
            [simple bit useBinaryEncoding]
            [simple int 32 maxStringLength]
            [simple int 32 maxByteStringLength]
            [simple int 32 maxArrayLength]
            [simple int 32 maxMessageSize]
            [simple int 32 maxBufferSize]
            [simple int 32 channelLifetime]
            [simple int 32 securityTokenLifetime]
        ]
        ['572' QueryDataDescription
            [simple RelativePath('542') relativePath]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
        ]
        ['575' NodeTypeDescription
            [simple ExpandedNodeId typeDefinitionNode]
            [reserved uint 7 '0x00']
            [simple bit includeSubTypes]
            [implicit int 32 noOfDataToReturn 'dataToReturn == null ? -1 : COUNT(dataToReturn)']
            [array QueryDataDescription('572') dataToReturn count 'noOfDataToReturn']
        ]
        ['579' QueryDataSet
            [simple ExpandedNodeId nodeId]
            [simple ExpandedNodeId typeDefinitionNode]
            [implicit int 32 noOfValues 'values == null ? -1 : COUNT(values)']
            [array Variant values count 'noOfValues']
        ]
        ['582' NodeReference
            [simple NodeId nodeId]
            [simple NodeId referenceTypeId]
            [reserved uint 7 '0x00']
            [simple bit isForward]
            [implicit int 32 noOfReferencedNodeIds 'referencedNodeIds == null ? -1 : COUNT(referencedNodeIds)']
            [array NodeId referencedNodeIds count 'noOfReferencedNodeIds']
        ]
        ['585' ContentFilterElement
            [simple FilterOperator filterOperator]
            [implicit int 32 noOfFilterOperands 'filterOperands == null ? -1 : COUNT(filterOperands)']
            [array ExtensionObject('true') filterOperands count 'noOfFilterOperands']
        ]
        ['588' ContentFilter
            [implicit int 32 noOfElements 'elements == null ? -1 : COUNT(elements)']
            [array ContentFilterElement('585') elements count 'noOfElements']
        ]
        ['591' FilterOperand
            
        ]
        ['594' ElementOperand
            [simple uint 32 index]
        ]
        ['597' LiteralOperand
            [simple Variant value]
        ]
        ['600' AttributeOperand
            [simple NodeId nodeId]
            [simple PascalString alias]
            [simple RelativePath('542') browsePath]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
        ]
        ['603' SimpleAttributeOperand
            [simple NodeId typeDefinitionId]
            [implicit int 32 noOfBrowsePath 'browsePath == null ? -1 : COUNT(browsePath)']
            [array QualifiedName browsePath count 'noOfBrowsePath']
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
        ]
        ['606' ContentFilterElementResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfOperandStatusCodes 'operandStatusCodes == null ? -1 : COUNT(operandStatusCodes)']
            [array StatusCode operandStatusCodes count 'noOfOperandStatusCodes']
            [implicit int 32 noOfOperandDiagnosticInfos 'operandDiagnosticInfos == null ? -1 : COUNT(operandDiagnosticInfos)']
            [array DiagnosticInfo operandDiagnosticInfos count 'noOfOperandDiagnosticInfos']
        ]
        ['609' ContentFilterResult
            [implicit int 32 noOfElementResults 'elementResults == null ? -1 : COUNT(elementResults)']
            [array ContentFilterElementResult('606') elementResults count 'noOfElementResults']
            [implicit int 32 noOfElementDiagnosticInfos 'elementDiagnosticInfos == null ? -1 : COUNT(elementDiagnosticInfos)']
            [array DiagnosticInfo elementDiagnosticInfos count 'noOfElementDiagnosticInfos']
        ]
        ['612' ParsingResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfDataStatusCodes 'dataStatusCodes == null ? -1 : COUNT(dataStatusCodes)']
            [array StatusCode dataStatusCodes count 'noOfDataStatusCodes']
            [implicit int 32 noOfDataDiagnosticInfos 'dataDiagnosticInfos == null ? -1 : COUNT(dataDiagnosticInfos)']
            [array DiagnosticInfo dataDiagnosticInfos count 'noOfDataDiagnosticInfos']
        ]
        ['615' QueryFirstRequest
            [simple RequestHeader('391') requestHeader]
            [simple ViewDescription('513') view]
            [implicit int 32 noOfNodeTypes 'nodeTypes == null ? -1 : COUNT(nodeTypes)']
            [array NodeTypeDescription('575') nodeTypes count 'noOfNodeTypes']
            [simple ContentFilter('588') filter]
            [simple uint 32 maxDataSetsToReturn]
            [simple uint 32 maxReferencesToReturn]
        ]
        ['618' QueryFirstResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfQueryDataSets 'queryDataSets == null ? -1 : COUNT(queryDataSets)']
            [array QueryDataSet('579') queryDataSets count 'noOfQueryDataSets']
            [simple PascalByteString continuationPoint]
            [implicit int 32 noOfParsingResults 'parsingResults == null ? -1 : COUNT(parsingResults)']
            [array ParsingResult('612') parsingResults count 'noOfParsingResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
            [simple ContentFilterResult('609') filterResult]
        ]
        ['621' QueryNextRequest
            [simple RequestHeader('391') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoint]
            [simple PascalByteString continuationPoint]
        ]
        ['624' QueryNextResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfQueryDataSets 'queryDataSets == null ? -1 : COUNT(queryDataSets)']
            [array QueryDataSet('579') queryDataSets count 'noOfQueryDataSets']
            [simple PascalByteString revisedContinuationPoint]
        ]
        ['628' ReadValueId
            [simple NodeId nodeId]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
            [simple QualifiedName dataEncoding]
        ]
        ['631' ReadRequest
            [simple RequestHeader('391') requestHeader]
            [simple float 64 maxAge]
            [simple TimestampsToReturn timestampsToReturn]
            [implicit int 32 noOfNodesToRead 'nodesToRead == null ? -1 : COUNT(nodesToRead)']
            [array ReadValueId('628') nodesToRead count 'noOfNodesToRead']
        ]
        ['634' ReadResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array DataValue results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['637' HistoryReadValueId
            [simple NodeId nodeId]
            [simple PascalString indexRange]
            [simple QualifiedName dataEncoding]
            [simple PascalByteString continuationPoint]
        ]
        ['640' HistoryReadResult
            [simple StatusCode statusCode]
            [simple PascalByteString continuationPoint]
            [simple ExtensionObject('true') historyData]
        ]
        ['643' HistoryReadDetails
            
        ]
        ['646' ReadEventDetails
            [simple uint 32 numValuesPerNode]
            [simple int 64 startTime]
            [simple int 64 endTime]
            [simple EventFilter('727') filter]
        ]
        ['32801' ReadEventDetails2
            [simple uint 32 numValuesPerNode]
            [simple int 64 startTime]
            [simple int 64 endTime]
            [simple EventFilter('727') filter]
            [reserved uint 7 '0x00']
            [simple bit readModified]
            
        ]
        ['18650' SortRuleElement
            [simple SortOrderType sortOrder]
            [simple SimpleAttributeOperand('603') eventField]
        ]
        ['18651' ReadEventDetailsSorted
            [simple uint 32 numValuesPerNode]
            [simple int 64 startTime]
            [simple int 64 endTime]
            [simple EventFilter('727') filter]
            [implicit int 32 noOfSortClause 'sortClause == null ? -1 : COUNT(sortClause)']
            [array SortRuleElement('18650') sortClause count 'noOfSortClause']
        ]
        ['649' ReadRawModifiedDetails
            [reserved uint 7 '0x00']
            [simple bit isReadModified]
            [simple int 64 startTime]
            [simple int 64 endTime]
            [simple uint 32 numValuesPerNode]
            [reserved uint 7 '0x00']
            [simple bit returnBounds]
            
        ]
        ['652' ReadProcessedDetails
            [simple int 64 startTime]
            [simple int 64 endTime]
            [simple float 64 processingInterval]
            [implicit int 32 noOfAggregateType 'aggregateType == null ? -1 : COUNT(aggregateType)']
            [array NodeId aggregateType count 'noOfAggregateType']
            [simple AggregateConfiguration('950') aggregateConfiguration]
        ]
        ['655' ReadAtTimeDetails
            [implicit int 32 noOfReqTimes 'reqTimes == null ? -1 : COUNT(reqTimes)']
            [array int 64 reqTimes count 'noOfReqTimes']
            [reserved uint 7 '0x00']
            [simple bit useSimpleBounds]
            
        ]
        ['23499' ReadAnnotationDataDetails
            [implicit int 32 noOfReqTimes 'reqTimes == null ? -1 : COUNT(reqTimes)']
            [array int 64 reqTimes count 'noOfReqTimes']
        ]
        ['658' HistoryData
            [implicit int 32 noOfDataValues 'dataValues == null ? -1 : COUNT(dataValues)']
            [array DataValue dataValues count 'noOfDataValues']
        ]
        ['11218' ModificationInfo
            [simple int 64 modificationTime]
            [simple HistoryUpdateType updateType]
            [simple PascalString userName]
        ]
        ['11219' HistoryModifiedData
            [implicit int 32 noOfDataValues 'dataValues == null ? -1 : COUNT(dataValues)']
            [array DataValue dataValues count 'noOfDataValues']
            [implicit int 32 noOfModificationInfos 'modificationInfos == null ? -1 : COUNT(modificationInfos)']
            [array ModificationInfo('11218') modificationInfos count 'noOfModificationInfos']
        ]
        ['661' HistoryEvent
            [implicit int 32 noOfEvents 'events == null ? -1 : COUNT(events)']
            [array HistoryEventFieldList('922') events count 'noOfEvents']
        ]
        ['32826' HistoryModifiedEvent
            [implicit int 32 noOfEvents 'events == null ? -1 : COUNT(events)']
            [array HistoryEventFieldList('922') events count 'noOfEvents']
            [implicit int 32 noOfModificationInfos 'modificationInfos == null ? -1 : COUNT(modificationInfos)']
            [array ModificationInfo('11218') modificationInfos count 'noOfModificationInfos']
        ]
        ['664' HistoryReadRequest
            [simple RequestHeader('391') requestHeader]
            [simple ExtensionObject('true') historyReadDetails]
            [simple TimestampsToReturn timestampsToReturn]
            [reserved uint 7 '0x00']
            [simple bit releaseContinuationPoints]
            [implicit int 32 noOfNodesToRead 'nodesToRead == null ? -1 : COUNT(nodesToRead)']
            [array HistoryReadValueId('637') nodesToRead count 'noOfNodesToRead']
        ]
        ['667' HistoryReadResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array HistoryReadResult('640') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['670' WriteValue
            [simple NodeId nodeId]
            [simple uint 32 attributeId]
            [simple PascalString indexRange]
            [simple DataValue value]
        ]
        ['673' WriteRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfNodesToWrite 'nodesToWrite == null ? -1 : COUNT(nodesToWrite)']
            [array WriteValue('670') nodesToWrite count 'noOfNodesToWrite']
        ]
        ['676' WriteResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['679' HistoryUpdateDetails
            
        ]
        ['682' UpdateDataDetails
            [simple NodeId nodeId]
            [simple PerformUpdateType performInsertReplace]
            [implicit int 32 noOfUpdateValues 'updateValues == null ? -1 : COUNT(updateValues)']
            [array DataValue updateValues count 'noOfUpdateValues']
        ]
        ['11297' UpdateStructureDataDetails
            [simple NodeId nodeId]
            [simple PerformUpdateType performInsertReplace]
            [implicit int 32 noOfUpdateValues 'updateValues == null ? -1 : COUNT(updateValues)']
            [array DataValue updateValues count 'noOfUpdateValues']
        ]
        ['685' UpdateEventDetails
            [simple NodeId nodeId]
            [simple PerformUpdateType performInsertReplace]
            [simple EventFilter('727') filter]
            [implicit int 32 noOfEventData 'eventData == null ? -1 : COUNT(eventData)']
            [array HistoryEventFieldList('922') eventData count 'noOfEventData']
        ]
        ['688' DeleteRawModifiedDetails
            [simple NodeId nodeId]
            [reserved uint 7 '0x00']
            [simple bit isDeleteModified]
            [simple int 64 startTime]
            [simple int 64 endTime]
        ]
        ['691' DeleteAtTimeDetails
            [simple NodeId nodeId]
            [implicit int 32 noOfReqTimes 'reqTimes == null ? -1 : COUNT(reqTimes)']
            [array int 64 reqTimes count 'noOfReqTimes']
        ]
        ['694' DeleteEventDetails
            [simple NodeId nodeId]
            [implicit int 32 noOfEventIds 'eventIds == null ? -1 : COUNT(eventIds)']
            [array PascalByteString eventIds count 'noOfEventIds']
        ]
        ['697' HistoryUpdateResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfOperationResults 'operationResults == null ? -1 : COUNT(operationResults)']
            [array StatusCode operationResults count 'noOfOperationResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['700' HistoryUpdateRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfHistoryUpdateDetails 'historyUpdateDetails == null ? -1 : COUNT(historyUpdateDetails)']
            [array ExtensionObject('true') historyUpdateDetails count 'noOfHistoryUpdateDetails']
        ]
        ['703' HistoryUpdateResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array HistoryUpdateResult('697') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['706' CallMethodRequest
            [simple NodeId objectId]
            [simple NodeId methodId]
            [implicit int 32 noOfInputArguments 'inputArguments == null ? -1 : COUNT(inputArguments)']
            [array Variant inputArguments count 'noOfInputArguments']
        ]
        ['709' CallMethodResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfInputArgumentResults 'inputArgumentResults == null ? -1 : COUNT(inputArgumentResults)']
            [array StatusCode inputArgumentResults count 'noOfInputArgumentResults']
            [implicit int 32 noOfInputArgumentDiagnosticInfos 'inputArgumentDiagnosticInfos == null ? -1 : COUNT(inputArgumentDiagnosticInfos)']
            [array DiagnosticInfo inputArgumentDiagnosticInfos count 'noOfInputArgumentDiagnosticInfos']
            [implicit int 32 noOfOutputArguments 'outputArguments == null ? -1 : COUNT(outputArguments)']
            [array Variant outputArguments count 'noOfOutputArguments']
        ]
        ['712' CallRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfMethodsToCall 'methodsToCall == null ? -1 : COUNT(methodsToCall)']
            [array CallMethodRequest('706') methodsToCall count 'noOfMethodsToCall']
        ]
        ['715' CallResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array CallMethodResult('709') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['721' MonitoringFilter
            
        ]
        ['724' DataChangeFilter
            [simple DataChangeTrigger trigger]
            [simple uint 32 deadbandType]
            [simple float 64 deadbandValue]
        ]
        ['727' EventFilter
            [implicit int 32 noOfSelectClauses 'selectClauses == null ? -1 : COUNT(selectClauses)']
            [array SimpleAttributeOperand('603') selectClauses count 'noOfSelectClauses']
            [simple ContentFilter('588') whereClause]
        ]
        ['950' AggregateConfiguration
            [reserved uint 6 '0x00']
            [simple bit treatUncertainAsBad]
            [simple bit useServerCapabilitiesDefaults]
            [simple uint 8 percentDataBad]
            [simple uint 8 percentDataGood]
            [reserved uint 7 '0x00']
            [simple bit useSlopedExtrapolation]
            
        ]
        ['730' AggregateFilter
            [simple int 64 startTime]
            [simple NodeId aggregateType]
            [simple float 64 processingInterval]
            [simple AggregateConfiguration('950') aggregateConfiguration]
        ]
        ['733' MonitoringFilterResult
            
        ]
        ['736' EventFilterResult
            [implicit int 32 noOfSelectClauseResults 'selectClauseResults == null ? -1 : COUNT(selectClauseResults)']
            [array StatusCode selectClauseResults count 'noOfSelectClauseResults']
            [implicit int 32 noOfSelectClauseDiagnosticInfos 'selectClauseDiagnosticInfos == null ? -1 : COUNT(selectClauseDiagnosticInfos)']
            [array DiagnosticInfo selectClauseDiagnosticInfos count 'noOfSelectClauseDiagnosticInfos']
            [simple ContentFilterResult('609') whereClauseResult]
        ]
        ['739' AggregateFilterResult
            [simple int 64 revisedStartTime]
            [simple float 64 revisedProcessingInterval]
            [simple AggregateConfiguration('950') revisedAggregateConfiguration]
        ]
        ['742' MonitoringParameters
            [simple uint 32 clientHandle]
            [simple float 64 samplingInterval]
            [simple ExtensionObject('true') filter]
            [simple uint 32 queueSize]
            [reserved uint 7 '0x00']
            [simple bit discardOldest]
            
        ]
        ['745' MonitoredItemCreateRequest
            [simple ReadValueId('628') itemToMonitor]
            [simple MonitoringMode monitoringMode]
            [simple MonitoringParameters('742') requestedParameters]
        ]
        ['748' MonitoredItemCreateResult
            [simple StatusCode statusCode]
            [simple uint 32 monitoredItemId]
            [simple float 64 revisedSamplingInterval]
            [simple uint 32 revisedQueueSize]
            [simple ExtensionObject('true') filterResult]
        ]
        ['751' CreateMonitoredItemsRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple TimestampsToReturn timestampsToReturn]
            [implicit int 32 noOfItemsToCreate 'itemsToCreate == null ? -1 : COUNT(itemsToCreate)']
            [array MonitoredItemCreateRequest('745') itemsToCreate count 'noOfItemsToCreate']
        ]
        ['754' CreateMonitoredItemsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array MonitoredItemCreateResult('748') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['757' MonitoredItemModifyRequest
            [simple uint 32 monitoredItemId]
            [simple MonitoringParameters('742') requestedParameters]
        ]
        ['760' MonitoredItemModifyResult
            [simple StatusCode statusCode]
            [simple float 64 revisedSamplingInterval]
            [simple uint 32 revisedQueueSize]
            [simple ExtensionObject('true') filterResult]
        ]
        ['763' ModifyMonitoredItemsRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple TimestampsToReturn timestampsToReturn]
            [implicit int 32 noOfItemsToModify 'itemsToModify == null ? -1 : COUNT(itemsToModify)']
            [array MonitoredItemModifyRequest('757') itemsToModify count 'noOfItemsToModify']
        ]
        ['766' ModifyMonitoredItemsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array MonitoredItemModifyResult('760') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['769' SetMonitoringModeRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple MonitoringMode monitoringMode]
            [implicit int 32 noOfMonitoredItemIds 'monitoredItemIds == null ? -1 : COUNT(monitoredItemIds)']
            [array uint 32 monitoredItemIds count 'noOfMonitoredItemIds']
        ]
        ['772' SetMonitoringModeResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['775' SetTriggeringRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple uint 32 triggeringItemId]
            [implicit int 32 noOfLinksToAdd 'linksToAdd == null ? -1 : COUNT(linksToAdd)']
            [array uint 32 linksToAdd count 'noOfLinksToAdd']
            [implicit int 32 noOfLinksToRemove 'linksToRemove == null ? -1 : COUNT(linksToRemove)']
            [array uint 32 linksToRemove count 'noOfLinksToRemove']
        ]
        ['778' SetTriggeringResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfAddResults 'addResults == null ? -1 : COUNT(addResults)']
            [array StatusCode addResults count 'noOfAddResults']
            [implicit int 32 noOfAddDiagnosticInfos 'addDiagnosticInfos == null ? -1 : COUNT(addDiagnosticInfos)']
            [array DiagnosticInfo addDiagnosticInfos count 'noOfAddDiagnosticInfos']
            [implicit int 32 noOfRemoveResults 'removeResults == null ? -1 : COUNT(removeResults)']
            [array StatusCode removeResults count 'noOfRemoveResults']
            [implicit int 32 noOfRemoveDiagnosticInfos 'removeDiagnosticInfos == null ? -1 : COUNT(removeDiagnosticInfos)']
            [array DiagnosticInfo removeDiagnosticInfos count 'noOfRemoveDiagnosticInfos']
        ]
        ['781' DeleteMonitoredItemsRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [implicit int 32 noOfMonitoredItemIds 'monitoredItemIds == null ? -1 : COUNT(monitoredItemIds)']
            [array uint 32 monitoredItemIds count 'noOfMonitoredItemIds']
        ]
        ['784' DeleteMonitoredItemsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['787' CreateSubscriptionRequest
            [simple RequestHeader('391') requestHeader]
            [simple float 64 requestedPublishingInterval]
            [simple uint 32 requestedLifetimeCount]
            [simple uint 32 requestedMaxKeepAliveCount]
            [simple uint 32 maxNotificationsPerPublish]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [simple uint 8 priority]
        ]
        ['790' CreateSubscriptionResponse
            [simple ResponseHeader('394') responseHeader]
            [simple uint 32 subscriptionId]
            [simple float 64 revisedPublishingInterval]
            [simple uint 32 revisedLifetimeCount]
            [simple uint 32 revisedMaxKeepAliveCount]
        ]
        ['793' ModifySubscriptionRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple float 64 requestedPublishingInterval]
            [simple uint 32 requestedLifetimeCount]
            [simple uint 32 requestedMaxKeepAliveCount]
            [simple uint 32 maxNotificationsPerPublish]
            [simple uint 8 priority]
        ]
        ['796' ModifySubscriptionResponse
            [simple ResponseHeader('394') responseHeader]
            [simple float 64 revisedPublishingInterval]
            [simple uint 32 revisedLifetimeCount]
            [simple uint 32 revisedMaxKeepAliveCount]
        ]
        ['799' SetPublishingModeRequest
            [simple RequestHeader('391') requestHeader]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [implicit int 32 noOfSubscriptionIds 'subscriptionIds == null ? -1 : COUNT(subscriptionIds)']
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
        ]
        ['802' SetPublishingModeResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['805' NotificationMessage
            [simple uint 32 sequenceNumber]
            [simple int 64 publishTime]
            [implicit int 32 noOfNotificationData 'notificationData == null ? -1 : COUNT(notificationData)']
            [array ExtensionObject('true') notificationData count 'noOfNotificationData']
        ]
        ['947' NotificationData
            
        ]
        ['811' DataChangeNotification
            [implicit int 32 noOfMonitoredItems 'monitoredItems == null ? -1 : COUNT(monitoredItems)']
            [array MonitoredItemNotification('808') monitoredItems count 'noOfMonitoredItems']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['808' MonitoredItemNotification
            [simple uint 32 clientHandle]
            [simple DataValue value]
        ]
        ['916' EventNotificationList
            [implicit int 32 noOfEvents 'events == null ? -1 : COUNT(events)']
            [array EventFieldList('919') events count 'noOfEvents']
        ]
        ['919' EventFieldList
            [simple uint 32 clientHandle]
            [implicit int 32 noOfEventFields 'eventFields == null ? -1 : COUNT(eventFields)']
            [array Variant eventFields count 'noOfEventFields']
        ]
        ['922' HistoryEventFieldList
            [implicit int 32 noOfEventFields 'eventFields == null ? -1 : COUNT(eventFields)']
            [array Variant eventFields count 'noOfEventFields']
        ]
        ['820' StatusChangeNotification
            [simple StatusCode status]
            [simple DiagnosticInfo diagnosticInfo]
        ]
        ['823' SubscriptionAcknowledgement
            [simple uint 32 subscriptionId]
            [simple uint 32 sequenceNumber]
        ]
        ['826' PublishRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfSubscriptionAcknowledgements 'subscriptionAcknowledgements == null ? -1 : COUNT(subscriptionAcknowledgements)']
            [array SubscriptionAcknowledgement('823') subscriptionAcknowledgements count 'noOfSubscriptionAcknowledgements']
        ]
        ['829' PublishResponse
            [simple ResponseHeader('394') responseHeader]
            [simple uint 32 subscriptionId]
            [implicit int 32 noOfAvailableSequenceNumbers 'availableSequenceNumbers == null ? -1 : COUNT(availableSequenceNumbers)']
            [array uint 32 availableSequenceNumbers count 'noOfAvailableSequenceNumbers']
            [reserved uint 7 '0x00']
            [simple bit moreNotifications]
            [simple NotificationMessage('805') notificationMessage]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['832' RepublishRequest
            [simple RequestHeader('391') requestHeader]
            [simple uint 32 subscriptionId]
            [simple uint 32 retransmitSequenceNumber]
        ]
        ['835' RepublishResponse
            [simple ResponseHeader('394') responseHeader]
            [simple NotificationMessage('805') notificationMessage]
        ]
        ['838' TransferResult
            [simple StatusCode statusCode]
            [implicit int 32 noOfAvailableSequenceNumbers 'availableSequenceNumbers == null ? -1 : COUNT(availableSequenceNumbers)']
            [array uint 32 availableSequenceNumbers count 'noOfAvailableSequenceNumbers']
        ]
        ['841' TransferSubscriptionsRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfSubscriptionIds 'subscriptionIds == null ? -1 : COUNT(subscriptionIds)']
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
            [reserved uint 7 '0x00']
            [simple bit sendInitialValues]
            
        ]
        ['844' TransferSubscriptionsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array TransferResult('838') results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['847' DeleteSubscriptionsRequest
            [simple RequestHeader('391') requestHeader]
            [implicit int 32 noOfSubscriptionIds 'subscriptionIds == null ? -1 : COUNT(subscriptionIds)']
            [array uint 32 subscriptionIds count 'noOfSubscriptionIds']
        ]
        ['850' DeleteSubscriptionsResponse
            [simple ResponseHeader('394') responseHeader]
            [implicit int 32 noOfResults 'results == null ? -1 : COUNT(results)']
            [array StatusCode results count 'noOfResults']
            [implicit int 32 noOfDiagnosticInfos 'diagnosticInfos == null ? -1 : COUNT(diagnosticInfos)']
            [array DiagnosticInfo diagnosticInfos count 'noOfDiagnosticInfos']
        ]
        ['340' BuildInfo
            [simple PascalString productUri]
            [simple PascalString manufacturerName]
            [simple PascalString productName]
            [simple PascalString softwareVersion]
            [simple PascalString buildNumber]
            [simple int 64 buildDate]
        ]
        ['855' RedundantServerDataType
            [simple PascalString serverId]
            [simple uint 8 serviceLevel]
            [simple ServerState serverState]
        ]
        ['11945' EndpointUrlListDataType
            [implicit int 32 noOfEndpointUrlList 'endpointUrlList == null ? -1 : COUNT(endpointUrlList)']
            [array PascalString endpointUrlList count 'noOfEndpointUrlList']
        ]
        ['11946' NetworkGroupDataType
            [simple PascalString serverUri]
            [implicit int 32 noOfNetworkPaths 'networkPaths == null ? -1 : COUNT(networkPaths)']
            [array EndpointUrlListDataType('11945') networkPaths count 'noOfNetworkPaths']
        ]
        ['858' SamplingIntervalDiagnosticsDataType
            [simple float 64 samplingInterval]
            [simple uint 32 monitoredItemCount]
            [simple uint 32 maxMonitoredItemCount]
            [simple uint 32 disabledMonitoredItemCount]
        ]
        ['861' ServerDiagnosticsSummaryDataType
            [simple uint 32 serverViewCount]
            [simple uint 32 currentSessionCount]
            [simple uint 32 cumulatedSessionCount]
            [simple uint 32 securityRejectedSessionCount]
            [simple uint 32 rejectedSessionCount]
            [simple uint 32 sessionTimeoutCount]
            [simple uint 32 sessionAbortCount]
            [simple uint 32 currentSubscriptionCount]
            [simple uint 32 cumulatedSubscriptionCount]
            [simple uint 32 publishingIntervalCount]
            [simple uint 32 securityRejectedRequestsCount]
            [simple uint 32 rejectedRequestsCount]
        ]
        ['864' ServerStatusDataType
            [simple int 64 startTime]
            [simple int 64 currentTime]
            [simple ServerState state]
            [simple BuildInfo('340') buildInfo]
            [simple uint 32 secondsTillShutdown]
            [simple LocalizedText shutdownReason]
        ]
        ['867' SessionDiagnosticsDataType
            [simple NodeId sessionId]
            [simple PascalString sessionName]
            [simple ApplicationDescription('310') clientDescription]
            [simple PascalString serverUri]
            [simple PascalString endpointUrl]
            [implicit int 32 noOfLocaleIds 'localeIds == null ? -1 : COUNT(localeIds)']
            [array PascalString localeIds count 'noOfLocaleIds']
            [simple float 64 actualSessionTimeout]
            [simple uint 32 maxResponseMessageSize]
            [simple int 64 clientConnectionTime]
            [simple int 64 clientLastContactTime]
            [simple uint 32 currentSubscriptionsCount]
            [simple uint 32 currentMonitoredItemsCount]
            [simple uint 32 currentPublishRequestsInQueue]
            [simple ServiceCounterDataType('873') totalRequestCount]
            [simple uint 32 unauthorizedRequestCount]
            [simple ServiceCounterDataType('873') readCount]
            [simple ServiceCounterDataType('873') historyReadCount]
            [simple ServiceCounterDataType('873') writeCount]
            [simple ServiceCounterDataType('873') historyUpdateCount]
            [simple ServiceCounterDataType('873') callCount]
            [simple ServiceCounterDataType('873') createMonitoredItemsCount]
            [simple ServiceCounterDataType('873') modifyMonitoredItemsCount]
            [simple ServiceCounterDataType('873') setMonitoringModeCount]
            [simple ServiceCounterDataType('873') setTriggeringCount]
            [simple ServiceCounterDataType('873') deleteMonitoredItemsCount]
            [simple ServiceCounterDataType('873') createSubscriptionCount]
            [simple ServiceCounterDataType('873') modifySubscriptionCount]
            [simple ServiceCounterDataType('873') setPublishingModeCount]
            [simple ServiceCounterDataType('873') publishCount]
            [simple ServiceCounterDataType('873') republishCount]
            [simple ServiceCounterDataType('873') transferSubscriptionsCount]
            [simple ServiceCounterDataType('873') deleteSubscriptionsCount]
            [simple ServiceCounterDataType('873') addNodesCount]
            [simple ServiceCounterDataType('873') addReferencesCount]
            [simple ServiceCounterDataType('873') deleteNodesCount]
            [simple ServiceCounterDataType('873') deleteReferencesCount]
            [simple ServiceCounterDataType('873') browseCount]
            [simple ServiceCounterDataType('873') browseNextCount]
            [simple ServiceCounterDataType('873') translateBrowsePathsToNodeIdsCount]
            [simple ServiceCounterDataType('873') queryFirstCount]
            [simple ServiceCounterDataType('873') queryNextCount]
            [simple ServiceCounterDataType('873') registerNodesCount]
            [simple ServiceCounterDataType('873') unregisterNodesCount]
        ]
        ['870' SessionSecurityDiagnosticsDataType
            [simple NodeId sessionId]
            [simple PascalString clientUserIdOfSession]
            [implicit int 32 noOfClientUserIdHistory 'clientUserIdHistory == null ? -1 : COUNT(clientUserIdHistory)']
            [array PascalString clientUserIdHistory count 'noOfClientUserIdHistory']
            [simple PascalString authenticationMechanism]
            [simple PascalString encoding]
            [simple PascalString transportProtocol]
            [simple MessageSecurityMode securityMode]
            [simple PascalString securityPolicyUri]
            [simple PascalByteString clientCertificate]
        ]
        ['873' ServiceCounterDataType
            [simple uint 32 totalCount]
            [simple uint 32 errorCount]
        ]
        ['301' StatusResult
            [simple StatusCode statusCode]
            [simple DiagnosticInfo diagnosticInfo]
        ]
        ['876' SubscriptionDiagnosticsDataType
            [simple NodeId sessionId]
            [simple uint 32 subscriptionId]
            [simple uint 8 priority]
            [simple float 64 publishingInterval]
            [simple uint 32 maxKeepAliveCount]
            [simple uint 32 maxLifetimeCount]
            [simple uint 32 maxNotificationsPerPublish]
            [reserved uint 7 '0x00']
            [simple bit publishingEnabled]
            [simple uint 32 modifyCount]
            [simple uint 32 enableCount]
            [simple uint 32 disableCount]
            [simple uint 32 republishRequestCount]
            [simple uint 32 republishMessageRequestCount]
            [simple uint 32 republishMessageCount]
            [simple uint 32 transferRequestCount]
            [simple uint 32 transferredToAltClientCount]
            [simple uint 32 transferredToSameClientCount]
            [simple uint 32 publishRequestCount]
            [simple uint 32 dataChangeNotificationsCount]
            [simple uint 32 eventNotificationsCount]
            [simple uint 32 notificationsCount]
            [simple uint 32 latePublishRequestCount]
            [simple uint 32 currentKeepAliveCount]
            [simple uint 32 currentLifetimeCount]
            [simple uint 32 unacknowledgedMessageCount]
            [simple uint 32 discardedMessageCount]
            [simple uint 32 monitoredItemCount]
            [simple uint 32 disabledMonitoredItemCount]
            [simple uint 32 monitoringQueueOverflowCount]
            [simple uint 32 nextSequenceNumber]
            [simple uint 32 eventQueueOverflowCount]
        ]
        ['879' ModelChangeStructureDataType
            [simple NodeId affected]
            [simple NodeId affectedType]
            [simple uint 8 verb]
        ]
        ['899' SemanticChangeStructureDataType
            [simple NodeId affected]
            [simple NodeId affectedType]
        ]
        ['886' Range
            [simple float 64 low]
            [simple float 64 high]
        ]
        ['889' EUInformation
            [simple PascalString namespaceUri]
            [simple int 32 unitId]
            [simple LocalizedText displayName]
            [simple LocalizedText description]
        ]
        ['12173' ComplexNumberType
            [simple float 32 real]
            [simple float 32 imaginary]
        ]
        ['12174' DoubleComplexNumberType
            [simple float 64 real]
            [simple float 64 imaginary]
        ]
        ['12081' AxisInformation
            [simple EUInformation('889') engineeringUnits]
            [simple Range('886') eURange]
            [simple LocalizedText title]
            [simple AxisScaleEnumeration axisScaleType]
            [implicit int 32 noOfAxisSteps 'axisSteps == null ? -1 : COUNT(axisSteps)']
            [array float 64 axisSteps count 'noOfAxisSteps']
        ]
        ['12082' XVType
            [simple float 64 x]
            [simple float 32 value]
        ]
        ['896' ProgramDiagnosticDataType
            [simple NodeId createSessionId]
            [simple PascalString createClientName]
            [simple int 64 invocationCreationTime]
            [simple int 64 lastTransitionTime]
            [simple PascalString lastMethodCall]
            [simple NodeId lastMethodSessionId]
            [implicit int 32 noOfLastMethodInputArguments 'lastMethodInputArguments == null ? -1 : COUNT(lastMethodInputArguments)']
            [array Argument('298') lastMethodInputArguments count 'noOfLastMethodInputArguments']
            [implicit int 32 noOfLastMethodOutputArguments 'lastMethodOutputArguments == null ? -1 : COUNT(lastMethodOutputArguments)']
            [array Argument('298') lastMethodOutputArguments count 'noOfLastMethodOutputArguments']
            [simple int 64 lastMethodCallTime]
            [simple StatusResult('301') lastMethodReturnStatus]
        ]
        ['24035' ProgramDiagnostic2DataType
            [simple NodeId createSessionId]
            [simple PascalString createClientName]
            [simple int 64 invocationCreationTime]
            [simple int 64 lastTransitionTime]
            [simple PascalString lastMethodCall]
            [simple NodeId lastMethodSessionId]
            [implicit int 32 noOfLastMethodInputArguments 'lastMethodInputArguments == null ? -1 : COUNT(lastMethodInputArguments)']
            [array Argument('298') lastMethodInputArguments count 'noOfLastMethodInputArguments']
            [implicit int 32 noOfLastMethodOutputArguments 'lastMethodOutputArguments == null ? -1 : COUNT(lastMethodOutputArguments)']
            [array Argument('298') lastMethodOutputArguments count 'noOfLastMethodOutputArguments']
            [implicit int 32 noOfLastMethodInputValues 'lastMethodInputValues == null ? -1 : COUNT(lastMethodInputValues)']
            [array Variant lastMethodInputValues count 'noOfLastMethodInputValues']
            [implicit int 32 noOfLastMethodOutputValues 'lastMethodOutputValues == null ? -1 : COUNT(lastMethodOutputValues)']
            [array Variant lastMethodOutputValues count 'noOfLastMethodOutputValues']
            [simple int 64 lastMethodCallTime]
            [simple StatusCode lastMethodReturnStatus]
        ]
        ['893' Annotation
            [simple PascalString message]
            [simple PascalString userName]
            [simple int 64 annotationTime]
        ]
    ]
]

[discriminatedType Variant
    [simple bit arrayLengthSpecified]
    [simple bit arrayDimensionsSpecified]
    [discriminator uint 6 VariantType]
    [typeSwitch VariantType,arrayLengthSpecified
        ['0' VariantNull
        ]
        ['1' VariantBoolean (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array byte value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['2' VariantSByte (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array byte value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['3' VariantByte (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 8 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['4' VariantInt16 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 16 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['5' VariantUInt16 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 16 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['6' VariantInt32 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['7' VariantUInt32 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['8' VariantInt64 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['9' VariantUInt64 (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array uint 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['10' VariantFloat (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array float 32 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['11' VariantDouble (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array float 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['12' VariantString (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array PascalString value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['13' VariantDateTime (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array int 64 value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['14' VariantGuid (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array GuidValue value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['15' VariantByteString (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ByteStringArray value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['16' VariantXmlElement (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array PascalString value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['17' VariantNodeId (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array NodeId value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['18' VariantExpandedNodeId (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ExpandedNodeId value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['19' VariantStatusCode (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array StatusCode value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['20' VariantQualifiedName (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array QualifiedName value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['21' VariantLocalizedText (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array LocalizedText value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['22' VariantExtensionObject (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array ExtensionObject('true') value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['23' VariantDataValue (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array DataValue value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['24' VariantVariant (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array Variant value count 'arrayLength == null ? 1 : arrayLength']
        ]
        ['25' VariantDiagnosticInfo (bit arrayLengthSpecified)
            [optional int 32 arrayLength 'arrayLengthSpecified']
            [array DiagnosticInfo value count 'arrayLength == null ? 1 : arrayLength']
        ]
    ]
    [optional int 32 noOfArrayDimensions 'arrayDimensionsSpecified']
    [array bit arrayDimensions count 'noOfArrayDimensions == null ? 0 : noOfArrayDimensions']
]

// node type, with two leading reserved bytes
[enum uint 6 NodeIdType
    ['0' TwoByte   ]
    ['1' FourByte  ]
    ['2' Numeric   ]
    ['3' String    ]
    ['4' Guid      ]
    ['5' ByteString]
]

[discriminatedType NodeIdTypeDefinition
    [abstract vstring '-1' identifier]
    [abstract int 16 namespace]
    [discriminator NodeIdType nodeType]
    [typeSwitch nodeType
        ['nodeIdTypeTwoByte' NodeIdTwoByte
            [simple uint 8 id]
            [virtual vstring '-1' identifier 'id']
            [virtual int 16 namespace '-1'] // cause an error
        ]
        ['nodeIdTypeFourByte' NodeIdFourByte
            [simple uint 8 namespaceIndex]
            [simple uint 16 id]
            [virtual vstring '-1' identifier 'id']
            [virtual int 16 namespace 'namespaceIndex']
        ]
        ['nodeIdTypeNumeric' NodeIdNumeric
            [simple uint 16 namespaceIndex]
            [simple uint 32 id]
            [virtual vstring '-1' identifier 'id']
            [virtual int 16 namespace 'namespaceIndex']
        ]
        ['nodeIdTypeString' NodeIdString
            [simple uint 16 namespaceIndex]
            [simple PascalString id]
            [virtual vstring '-1' identifier 'id.stringValue']
            [virtual int 16 namespace 'namespaceIndex']
        ]
        ['nodeIdTypeGuid' NodeIdGuid
            [simple uint 16 namespaceIndex]
            [array byte id count '16']
            [virtual vstring '-1' identifier 'id']
            [virtual int 16 namespace 'namespaceIndex']
        ]
        ['nodeIdTypeByteString' NodeIdByteString
            [simple uint 16 namespaceIndex]
            [simple PascalByteString id]
            [virtual vstring '-1' identifier 'id.stringValue']
            [virtual int 16 namespace 'namespaceIndex']
        ]
    ]
]

[type NodeId
    [reserved int 2 '0x00']
    [simple NodeIdTypeDefinition nodeId]
]

[type PascalString
    [implicit int 32    sLength      'STATIC_CALL("utf8LengthToPascalLength", stringValue)' ]
    [virtual  int 32    stringLength 'STATIC_CALL("pascalLengthToUtf8Length", sLength)'     ]
    [optional vstring   'stringLength*8' stringValue 'sLength != -1']
]

[type PascalByteString
    [simple int 32 stringLength]
    [array byte stringValue count 'stringLength == -1 ? 0 : stringLength' ]
]

[type Structure

]

//[type DataTypeDefinition
//
//]

// StructuredTypes
[type XmlElement
    // An XML element encoded as a UTF-8 string.
    [simple int 32 length]
            [array string 8 value count 'length']
        ]
    [type TwoByteNodeId
    
    [simple uint 8 identifier]
        ]
    [type FourByteNodeId
    
    [simple uint 8 namespaceIndex]
            [simple uint 16 identifier]
        ]
    [type NumericNodeId
    
    [simple uint 16 namespaceIndex]
            [simple uint 32 identifier]
        ]
    [type StringNodeId
    
    [simple uint 16 namespaceIndex]
            [simple PascalString identifier]
        ]
    [type GuidNodeId
    
    [simple uint 16 namespaceIndex]
            [simple GuidValue identifier]
        ]
    [type ByteStringNodeId
    
    [simple uint 16 namespaceIndex]
            [simple PascalByteString identifier]
        ]
    [type DiagnosticInfo
    // A recursive structure containing diagnostic information associated with a status code.
    [reserved bit 'false']
            [simple bit innerDiagnosticInfoSpecified]
            [simple bit innerStatusCodeSpecified]
            [simple bit additionalInfoSpecified]
            [simple bit localeSpecified]
            [simple bit localizedTextSpecified]
            [simple bit namespaceURISpecified]
            [simple bit symbolicIdSpecified]
            [optional int 32 symbolicId 'symbolicIdSpecified']
            [optional int 32 namespaceURI 'namespaceURISpecified']
            [optional int 32 locale 'localeSpecified']
            [optional int 32 localizedText 'localizedTextSpecified']
            [optional PascalString additionalInfo 'additionalInfoSpecified']
            [optional StatusCode innerStatusCode 'innerStatusCodeSpecified']
            [optional DiagnosticInfo innerDiagnosticInfo 'innerDiagnosticInfoSpecified']
        ]
    [type QualifiedName
    // A string qualified with a namespace index.
    [simple uint 16 namespaceIndex]
            [simple PascalString name]
        ]
    [type LocalizedText
    // A string qualified with a namespace index.
    [reserved uint 6 '0x00']
            [simple bit textSpecified]
            [simple bit localeSpecified]
            [optional PascalString locale 'localeSpecified']
            [optional PascalString text 'textSpecified']
        ]
    [type DataValue
    // A value with an associated timestamp, and quality.
    [reserved uint 2 '0x00']
            [simple bit serverPicosecondsSpecified]
            [simple bit sourcePicosecondsSpecified]
            [simple bit serverTimestampSpecified]
            [simple bit sourceTimestampSpecified]
            [simple bit statusCodeSpecified]
            [simple bit valueSpecified]
            [optional Variant value 'valueSpecified']
            [optional StatusCode statusCode 'statusCodeSpecified']
            [optional int 64 sourceTimestamp 'sourceTimestampSpecified']
            [optional uint 16 sourcePicoseconds 'sourcePicosecondsSpecified']
            [optional int 64 serverTimestamp 'serverTimestampSpecified']
            [optional uint 16 serverPicoseconds 'serverPicosecondsSpecified']
        ]
    

// EnumeratedTypes


[enum uint 6 NodeIdType// The possible encodings for a NodeId value.
    ['0' nodeIdTypeTwoByte]
    ['1' nodeIdTypeFourByte]
    ['2' nodeIdTypeNumeric]
    ['3' nodeIdTypeString]
    ['4' nodeIdTypeGuid]
    ['5' nodeIdTypeByteString]
    ]
            

[enum uint 32 NamingRuleType
    ['1' namingRuleTypeMandatory]
    ['2' namingRuleTypeOptional]
    ['3' namingRuleTypeConstraint]
    ]
            

[enum uint 32 RedundantServerMode
    ['0' redundantServerModePrimaryWithBackup]
    ['1' redundantServerModePrimaryOnly]
    ['2' redundantServerModeBackupReady]
    ['3' redundantServerModeBackupNotReady]
    ]
            

[enum uint 32 OpenFileMode
    ['1' openFileModeRead]
    ['2' openFileModeWrite]
    ['4' openFileModeEraseExisting]
    ['8' openFileModeAppend]
    ]
            

[enum uint 32 IdentityCriteriaType
    ['1' identityCriteriaTypeUserName]
    ['2' identityCriteriaTypeThumbprint]
    ['3' identityCriteriaTypeRole]
    ['4' identityCriteriaTypeGroupId]
    ['5' identityCriteriaTypeAnonymous]
    ['6' identityCriteriaTypeAuthenticatedUser]
    ['7' identityCriteriaTypeApplication]
    ['8' identityCriteriaTypeX509Subject]
    ['9' identityCriteriaTypeTrustedApplication]
    ]
            

[enum uint 32 ConversionLimitEnum
    ['0' conversionLimitEnumNoConversion]
    ['1' conversionLimitEnumLimited]
    ['2' conversionLimitEnumUnlimited]
    ]
            

[enum uint 16 AlarmMask
    ['0' alarmMaskNone]
    ['1' alarmMaskActive]
    ['2' alarmMaskUnacknowledged]
    ['4' alarmMaskUnconfirmed]
    ]
            

[enum uint 32 TrustListValidationOptions
    ['0' trustListValidationOptionsNone]
    ['1' trustListValidationOptionsSuppressCertificateExpired]
    ['2' trustListValidationOptionsSuppressHostNameInvalid]
    ['4' trustListValidationOptionsSuppressRevocationStatusUnknown]
    ['8' trustListValidationOptionsSuppressIssuerCertificateExpired]
    ['16' trustListValidationOptionsSuppressIssuerRevocationStatusUnknown]
    ['32' trustListValidationOptionsCheckRevocationStatusOnline]
    ['64' trustListValidationOptionsCheckRevocationStatusOffline]
    ]
            

[enum uint 32 TrustListMasks
    ['0' trustListMasksNone]
    ['1' trustListMasksTrustedCertificates]
    ['2' trustListMasksTrustedCrls]
    ['4' trustListMasksIssuerCertificates]
    ['8' trustListMasksIssuerCrls]
    ['15' trustListMasksAll]
    ]
            

[enum uint 32 ConfigurationUpdateType
    ['1' configurationUpdateTypeInsert]
    ['2' configurationUpdateTypeReplace]
    ['3' configurationUpdateTypeInsertOrReplace]
    ['4' configurationUpdateTypeDelete]
    ]
            

[enum uint 32 PubSubState
    ['0' pubSubStateDisabled]
    ['1' pubSubStatePaused]
    ['2' pubSubStateOperational]
    ['3' pubSubStateError]
    ['4' pubSubStatePreOperational]
    ]
            

[enum uint 16 DataSetFieldFlags
    ['0' dataSetFieldFlagsNone]
    ['1' dataSetFieldFlagsPromotedField]
    ]
            

[enum uint 32 ActionState
    ['0' actionStateIdle]
    ['1' actionStateExecuting]
    ['2' actionStateDone]
    ]
            

[enum uint 32 DataSetFieldContentMask
    ['0' dataSetFieldContentMaskNone]
    ['1' dataSetFieldContentMaskStatusCode]
    ['2' dataSetFieldContentMaskSourceTimestamp]
    ['4' dataSetFieldContentMaskServerTimestamp]
    ['8' dataSetFieldContentMaskSourcePicoSeconds]
    ['16' dataSetFieldContentMaskServerPicoSeconds]
    ['32' dataSetFieldContentMaskRawData]
    ]
            

[enum uint 32 OverrideValueHandling
    ['0' overrideValueHandlingDisabled]
    ['1' overrideValueHandlingLastUsableValue]
    ['2' overrideValueHandlingOverrideValue]
    ]
            

[enum uint 32 DataSetOrderingType
    ['0' dataSetOrderingTypeUndefined]
    ['1' dataSetOrderingTypeAscendingWriterId]
    ['2' dataSetOrderingTypeAscendingWriterIdSingle]
    ]
            

[enum uint 32 UadpNetworkMessageContentMask
    ['0' uadpNetworkMessageContentMaskNone]
    ['1' uadpNetworkMessageContentMaskPublisherId]
    ['2' uadpNetworkMessageContentMaskGroupHeader]
    ['4' uadpNetworkMessageContentMaskWriterGroupId]
    ['8' uadpNetworkMessageContentMaskGroupVersion]
    ['16' uadpNetworkMessageContentMaskNetworkMessageNumber]
    ['32' uadpNetworkMessageContentMaskSequenceNumber]
    ['64' uadpNetworkMessageContentMaskPayloadHeader]
    ['128' uadpNetworkMessageContentMaskTimestamp]
    ['256' uadpNetworkMessageContentMaskPicoSeconds]
    ['512' uadpNetworkMessageContentMaskDataSetClassId]
    ['1024' uadpNetworkMessageContentMaskPromotedFields]
    ]
            

[enum uint 32 UadpDataSetMessageContentMask
    ['0' uadpDataSetMessageContentMaskNone]
    ['1' uadpDataSetMessageContentMaskTimestamp]
    ['2' uadpDataSetMessageContentMaskPicoSeconds]
    ['4' uadpDataSetMessageContentMaskStatus]
    ['8' uadpDataSetMessageContentMaskMajorVersion]
    ['16' uadpDataSetMessageContentMaskMinorVersion]
    ['32' uadpDataSetMessageContentMaskSequenceNumber]
    ]
            

[enum uint 32 JsonNetworkMessageContentMask
    ['0' jsonNetworkMessageContentMaskNone]
    ['1' jsonNetworkMessageContentMaskNetworkMessageHeader]
    ['2' jsonNetworkMessageContentMaskDataSetMessageHeader]
    ['4' jsonNetworkMessageContentMaskSingleDataSetMessage]
    ['8' jsonNetworkMessageContentMaskPublisherId]
    ['16' jsonNetworkMessageContentMaskDataSetClassId]
    ['32' jsonNetworkMessageContentMaskReplyTo]
    ['64' jsonNetworkMessageContentMaskWriterGroupName]
    ]
            

[enum uint 32 JsonDataSetMessageContentMask
    ['0' jsonDataSetMessageContentMaskNone]
    ['1' jsonDataSetMessageContentMaskDataSetWriterId]
    ['2' jsonDataSetMessageContentMaskMetaDataVersion]
    ['4' jsonDataSetMessageContentMaskSequenceNumber]
    ['8' jsonDataSetMessageContentMaskTimestamp]
    ['16' jsonDataSetMessageContentMaskStatus]
    ['32' jsonDataSetMessageContentMaskMessageType]
    ['64' jsonDataSetMessageContentMaskDataSetWriterName]
    ['128' jsonDataSetMessageContentMaskFieldEncoding1]
    ['256' jsonDataSetMessageContentMaskPublisherId]
    ['512' jsonDataSetMessageContentMaskWriterGroupName]
    ['1024' jsonDataSetMessageContentMaskMinorVersion]
    ['2048' jsonDataSetMessageContentMaskFieldEncoding2]
    ]
            

[enum uint 32 BrokerTransportQualityOfService
    ['0' brokerTransportQualityOfServiceNotSpecified]
    ['1' brokerTransportQualityOfServiceBestEffort]
    ['2' brokerTransportQualityOfServiceAtLeastOnce]
    ['3' brokerTransportQualityOfServiceAtMostOnce]
    ['4' brokerTransportQualityOfServiceExactlyOnce]
    ]
            

[enum uint 32 PubSubConfigurationRefMask
    ['0' pubSubConfigurationRefMaskNone]
    ['1' pubSubConfigurationRefMaskElementAdd]
    ['2' pubSubConfigurationRefMaskElementMatch]
    ['4' pubSubConfigurationRefMaskElementModify]
    ['8' pubSubConfigurationRefMaskElementRemove]
    ['16' pubSubConfigurationRefMaskReferenceWriter]
    ['32' pubSubConfigurationRefMaskReferenceReader]
    ['64' pubSubConfigurationRefMaskReferenceWriterGroup]
    ['128' pubSubConfigurationRefMaskReferenceReaderGroup]
    ['256' pubSubConfigurationRefMaskReferenceConnection]
    ['512' pubSubConfigurationRefMaskReferencePubDataset]
    ['1024' pubSubConfigurationRefMaskReferenceSubDataset]
    ['2048' pubSubConfigurationRefMaskReferenceSecurityGroup]
    ['4096' pubSubConfigurationRefMaskReferencePushTarget]
    ]
            

[enum uint 32 DiagnosticsLevel
    ['0' diagnosticsLevelBasic]
    ['1' diagnosticsLevelAdvanced]
    ['2' diagnosticsLevelInfo]
    ['3' diagnosticsLevelLog]
    ['4' diagnosticsLevelDebug]
    ]
            

[enum uint 32 PubSubDiagnosticsCounterClassification
    ['0' pubSubDiagnosticsCounterClassificationInformation]
    ['1' pubSubDiagnosticsCounterClassificationError]
    ]
            

[enum uint 32 PasswordOptionsMask
    ['0' passwordOptionsMaskNone]
    ['1' passwordOptionsMaskSupportInitialPasswordChange]
    ['2' passwordOptionsMaskSupportDisableUser]
    ['4' passwordOptionsMaskSupportDisableDeleteForUser]
    ['8' passwordOptionsMaskSupportNoChangeForUser]
    ['16' passwordOptionsMaskSupportDescriptionForUser]
    ['32' passwordOptionsMaskRequiresUpperCaseCharacters]
    ['64' passwordOptionsMaskRequiresLowerCaseCharacters]
    ['128' passwordOptionsMaskRequiresDigitCharacters]
    ['256' passwordOptionsMaskRequiresSpecialCharacters]
    ]
            

[enum uint 32 UserConfigurationMask
    ['0' userConfigurationMaskNone]
    ['1' userConfigurationMaskNoDelete]
    ['2' userConfigurationMaskDisabled]
    ['4' userConfigurationMaskNoChangeByUser]
    ['8' userConfigurationMaskMustChangePassword]
    ]
            

[enum uint 32 Duplex
    ['0' duplexFull]
    ['1' duplexHalf]
    ['2' duplexUnknown]
    ]
            

[enum uint 32 InterfaceAdminStatus
    ['0' interfaceAdminStatusUp]
    ['1' interfaceAdminStatusDown]
    ['2' interfaceAdminStatusTesting]
    ]
            

[enum uint 32 InterfaceOperStatus
    ['0' interfaceOperStatusUp]
    ['1' interfaceOperStatusDown]
    ['2' interfaceOperStatusTesting]
    ['3' interfaceOperStatusUnknown]
    ['4' interfaceOperStatusDormant]
    ['5' interfaceOperStatusNotPresent]
    ['6' interfaceOperStatusLowerLayerDown]
    ]
            

[enum uint 32 NegotiationStatus
    ['0' negotiationStatusInProgress]
    ['1' negotiationStatusComplete]
    ['2' negotiationStatusFailed]
    ['3' negotiationStatusUnknown]
    ['4' negotiationStatusNoNegotiation]
    ]
            

[enum uint 32 TsnFailureCode
    ['0' tsnFailureCodeNoFailure]
    ['1' tsnFailureCodeInsufficientBandwidth]
    ['2' tsnFailureCodeInsufficientResources]
    ['3' tsnFailureCodeInsufficientTrafficClassBandwidth]
    ['4' tsnFailureCodeStreamIdInUse]
    ['5' tsnFailureCodeStreamDestinationAddressInUse]
    ['6' tsnFailureCodeStreamPreemptedByHigherRank]
    ['7' tsnFailureCodeLatencyHasChanged]
    ['8' tsnFailureCodeEgressPortNotAvbCapable]
    ['9' tsnFailureCodeUseDifferentDestinationAddress]
    ['10' tsnFailureCodeOutOfMsrpResources]
    ['11' tsnFailureCodeOutOfMmrpResources]
    ['12' tsnFailureCodeCannotStoreDestinationAddress]
    ['13' tsnFailureCodePriorityIsNotAnSrcClass]
    ['14' tsnFailureCodeMaxFrameSizeTooLarge]
    ['15' tsnFailureCodeMaxFanInPortsLimitReached]
    ['16' tsnFailureCodeFirstValueChangedForStreamId]
    ['17' tsnFailureCodeVlanBlockedOnEgress]
    ['18' tsnFailureCodeVlanTaggingDisabledOnEgress]
    ['19' tsnFailureCodeSrClassPriorityMismatch]
    ['20' tsnFailureCodeFeatureNotPropagated]
    ['21' tsnFailureCodeMaxLatencyExceeded]
    ['22' tsnFailureCodeBridgeDoesNotProvideNetworkId]
    ['23' tsnFailureCodeStreamTransformNotSupported]
    ['24' tsnFailureCodeStreamIdTypeNotSupported]
    ['25' tsnFailureCodeFeatureNotSupported]
    ]
            

[enum uint 32 TsnStreamState
    ['0' tsnStreamStateDisabled]
    ['1' tsnStreamStateConfiguring]
    ['2' tsnStreamStateReady]
    ['3' tsnStreamStateOperational]
    ['4' tsnStreamStateError]
    ]
            

[enum uint 32 TsnTalkerStatus
    ['0' tsnTalkerStatusNone]
    ['1' tsnTalkerStatusReady]
    ['2' tsnTalkerStatusFailed]
    ]
            

[enum uint 32 TsnListenerStatus
    ['0' tsnListenerStatusNone]
    ['1' tsnListenerStatusReady]
    ['2' tsnListenerStatusPartialFailed]
    ['3' tsnListenerStatusFailed]
    ]
            

[enum uint 32 ChassisIdSubtype
    ['1' chassisIdSubtypeChassisComponent]
    ['2' chassisIdSubtypeInterfaceAlias]
    ['3' chassisIdSubtypePortComponent]
    ['4' chassisIdSubtypeMacAddress]
    ['5' chassisIdSubtypeNetworkAddress]
    ['6' chassisIdSubtypeInterfaceName]
    ['7' chassisIdSubtypeLocal]
    ]
            

[enum uint 32 PortIdSubtype
    ['1' portIdSubtypeInterfaceAlias]
    ['2' portIdSubtypePortComponent]
    ['3' portIdSubtypeMacAddress]
    ['4' portIdSubtypeNetworkAddress]
    ['5' portIdSubtypeInterfaceName]
    ['6' portIdSubtypeAgentCircuitId]
    ['7' portIdSubtypeLocal]
    ]
            

[enum uint 32 ManAddrIfSubtype
    ['0' manAddrIfSubtypeNone]
    ['1' manAddrIfSubtypeUnknown]
    ['2' manAddrIfSubtypePortRef]
    ['3' manAddrIfSubtypeSystemPortNumber]
    ]
            

[enum uint 32 LldpSystemCapabilitiesMap
    ['0' lldpSystemCapabilitiesMapNone]
    ['1' lldpSystemCapabilitiesMapOther]
    ['2' lldpSystemCapabilitiesMapRepeater]
    ['4' lldpSystemCapabilitiesMapBridge]
    ['8' lldpSystemCapabilitiesMapWlanAccessPoint]
    ['16' lldpSystemCapabilitiesMapRouter]
    ['32' lldpSystemCapabilitiesMapTelephone]
    ['64' lldpSystemCapabilitiesMapDocsisCableDevice]
    ['128' lldpSystemCapabilitiesMapStationOnly]
    ['256' lldpSystemCapabilitiesMapCvlanComponent]
    ['512' lldpSystemCapabilitiesMapSvlanComponent]
    ['1024' lldpSystemCapabilitiesMapTwoPortMacRelay]
    ]
            

[enum uint 32 LogRecordMask
    ['0' logRecordMaskNone]
    ['1' logRecordMaskEventType]
    ['2' logRecordMaskSourceNode]
    ['4' logRecordMaskSourceName]
    ['8' logRecordMaskTraceContext]
    ['16' logRecordMaskAdditionalData]
    ]
            

[enum uint 32 IdType
    ['0' idTypeNumeric]
    ['1' idTypeString]
    ['2' idTypeGuid]
    ['3' idTypeOpaque]
    ]
            

[enum uint 32 NodeClass
    ['0' nodeClassUnspecified]
    ['1' nodeClassObject]
    ['2' nodeClassVariable]
    ['4' nodeClassMethod]
    ['8' nodeClassObjectType]
    ['16' nodeClassVariableType]
    ['32' nodeClassReferenceType]
    ['64' nodeClassDataType]
    ['128' nodeClassView]
    ]
            

[enum uint 32 PermissionType
    ['0' permissionTypeNone]
    ['1' permissionTypeBrowse]
    ['2' permissionTypeReadRolePermissions]
    ['4' permissionTypeWriteAttribute]
    ['8' permissionTypeWriteRolePermissions]
    ['16' permissionTypeWriteHistorizing]
    ['32' permissionTypeRead]
    ['64' permissionTypeWrite]
    ['128' permissionTypeReadHistory]
    ['256' permissionTypeInsertHistory]
    ['512' permissionTypeModifyHistory]
    ['1024' permissionTypeDeleteHistory]
    ['2048' permissionTypeReceiveEvents]
    ['4096' permissionTypeCall]
    ['8192' permissionTypeAddReference]
    ['16384' permissionTypeRemoveReference]
    ['32768' permissionTypeDeleteNode]
    ['65536' permissionTypeAddNode]
    ]
            

[enum uint 8 AccessLevelType
    ['0' accessLevelTypeNone]
    ['1' accessLevelTypeCurrentRead]
    ['2' accessLevelTypeCurrentWrite]
    ['4' accessLevelTypeHistoryRead]
    ['8' accessLevelTypeHistoryWrite]
    ['16' accessLevelTypeSemanticChange]
    ['32' accessLevelTypeStatusWrite]
    ['64' accessLevelTypeTimestampWrite]
    ]
            

[enum uint 32 AccessLevelExType
    ['0' accessLevelExTypeNone]
    ['1' accessLevelExTypeCurrentRead]
    ['2' accessLevelExTypeCurrentWrite]
    ['4' accessLevelExTypeHistoryRead]
    ['8' accessLevelExTypeHistoryWrite]
    ['16' accessLevelExTypeSemanticChange]
    ['32' accessLevelExTypeStatusWrite]
    ['64' accessLevelExTypeTimestampWrite]
    ['256' accessLevelExTypeNonatomicRead]
    ['512' accessLevelExTypeNonatomicWrite]
    ['1024' accessLevelExTypeWriteFullArrayOnly]
    ['2048' accessLevelExTypeNoSubDataTypes]
    ['4096' accessLevelExTypeNonVolatile]
    ['8192' accessLevelExTypeConstant]
    ]
            

[enum uint 8 EventNotifierType
    ['0' eventNotifierTypeNone]
    ['1' eventNotifierTypeSubscribeToEvents]
    ['4' eventNotifierTypeHistoryRead]
    ['8' eventNotifierTypeHistoryWrite]
    ]
            

[enum uint 16 AccessRestrictionType
    ['0' accessRestrictionTypeNone]
    ['1' accessRestrictionTypeSigningRequired]
    ['2' accessRestrictionTypeEncryptionRequired]
    ['4' accessRestrictionTypeSessionRequired]
    ['8' accessRestrictionTypeApplyRestrictionsToBrowse]
    ]
            

[enum uint 32 StructureType
    ['0' structureTypeStructure]
    ['1' structureTypeStructureWithOptionalFields]
    ['2' structureTypeUnion]
    ['3' structureTypeStructureWithSubtypedValues]
    ['4' structureTypeUnionWithSubtypedValues]
    ]
            

[enum uint 32 ApplicationType
    ['0' applicationTypeServer]
    ['1' applicationTypeClient]
    ['2' applicationTypeClientAndServer]
    ['3' applicationTypeDiscoveryServer]
    ]
            

[enum uint 32 MessageSecurityMode
    ['0' messageSecurityModeInvalid]
    ['1' messageSecurityModeNone]
    ['2' messageSecurityModeSign]
    ['3' messageSecurityModeSignAndEncrypt]
    ]
            

[enum uint 32 UserTokenType
    ['0' userTokenTypeAnonymous]
    ['1' userTokenTypeUserName]
    ['2' userTokenTypeCertificate]
    ['3' userTokenTypeIssuedToken]
    ]
            

[enum uint 32 SecurityTokenRequestType
    ['0' securityTokenRequestTypeIssue]
    ['1' securityTokenRequestTypeRenew]
    ]
            

[enum uint 32 NodeAttributesMask
    ['0' nodeAttributesMaskNone]
    ['1' nodeAttributesMaskAccessLevel]
    ['2' nodeAttributesMaskArrayDimensions]
    ['4' nodeAttributesMaskBrowseName]
    ['8' nodeAttributesMaskContainsNoLoops]
    ['16' nodeAttributesMaskDataType]
    ['32' nodeAttributesMaskDescription]
    ['64' nodeAttributesMaskDisplayName]
    ['128' nodeAttributesMaskEventNotifier]
    ['256' nodeAttributesMaskExecutable]
    ['512' nodeAttributesMaskHistorizing]
    ['1024' nodeAttributesMaskInverseName]
    ['2048' nodeAttributesMaskIsAbstract]
    ['4096' nodeAttributesMaskMinimumSamplingInterval]
    ['8192' nodeAttributesMaskNodeClass]
    ['16384' nodeAttributesMaskNodeId]
    ['32768' nodeAttributesMaskSymmetric]
    ['65536' nodeAttributesMaskUserAccessLevel]
    ['131072' nodeAttributesMaskUserExecutable]
    ['262144' nodeAttributesMaskUserWriteMask]
    ['524288' nodeAttributesMaskValueRank]
    ['1048576' nodeAttributesMaskWriteMask]
    ['2097152' nodeAttributesMaskValue]
    ['4194304' nodeAttributesMaskDataTypeDefinition]
    ['8388608' nodeAttributesMaskRolePermissions]
    ['16777216' nodeAttributesMaskAccessRestrictions]
    ['33554431' nodeAttributesMaskAll]
    ['26501220' nodeAttributesMaskBaseNode]
    ['26501348' nodeAttributesMaskObject]
    ['26503268' nodeAttributesMaskObjectType]
    ['26571383' nodeAttributesMaskVariable]
    ['28600438' nodeAttributesMaskVariableType]
    ['26632548' nodeAttributesMaskMethod]
    ['26537060' nodeAttributesMaskReferenceType]
    ['26501356' nodeAttributesMaskView]
    ]
            

[enum uint 32 AttributeWriteMask
    ['0' attributeWriteMaskNone]
    ['1' attributeWriteMaskAccessLevel]
    ['2' attributeWriteMaskArrayDimensions]
    ['4' attributeWriteMaskBrowseName]
    ['8' attributeWriteMaskContainsNoLoops]
    ['16' attributeWriteMaskDataType]
    ['32' attributeWriteMaskDescription]
    ['64' attributeWriteMaskDisplayName]
    ['128' attributeWriteMaskEventNotifier]
    ['256' attributeWriteMaskExecutable]
    ['512' attributeWriteMaskHistorizing]
    ['1024' attributeWriteMaskInverseName]
    ['2048' attributeWriteMaskIsAbstract]
    ['4096' attributeWriteMaskMinimumSamplingInterval]
    ['8192' attributeWriteMaskNodeClass]
    ['16384' attributeWriteMaskNodeId]
    ['32768' attributeWriteMaskSymmetric]
    ['65536' attributeWriteMaskUserAccessLevel]
    ['131072' attributeWriteMaskUserExecutable]
    ['262144' attributeWriteMaskUserWriteMask]
    ['524288' attributeWriteMaskValueRank]
    ['1048576' attributeWriteMaskWriteMask]
    ['2097152' attributeWriteMaskValueForVariableType]
    ['4194304' attributeWriteMaskDataTypeDefinition]
    ['8388608' attributeWriteMaskRolePermissions]
    ['16777216' attributeWriteMaskAccessRestrictions]
    ['33554432' attributeWriteMaskAccessLevelEx]
    ]
            

[enum uint 32 BrowseDirection
    ['0' browseDirectionForward]
    ['1' browseDirectionInverse]
    ['2' browseDirectionBoth]
    ['3' browseDirectionInvalid]
    ]
            

[enum uint 32 BrowseResultMask
    ['0' browseResultMaskNone]
    ['1' browseResultMaskReferenceTypeId]
    ['2' browseResultMaskIsForward]
    ['4' browseResultMaskNodeClass]
    ['8' browseResultMaskBrowseName]
    ['16' browseResultMaskDisplayName]
    ['32' browseResultMaskTypeDefinition]
    ['63' browseResultMaskAll]
    ['3' browseResultMaskReferenceTypeInfo]
    ['60' browseResultMaskTargetInfo]
    ]
            

[enum uint 32 FilterOperator
    ['0' filterOperatorEquals]
    ['1' filterOperatorIsNull]
    ['2' filterOperatorGreaterThan]
    ['3' filterOperatorLessThan]
    ['4' filterOperatorGreaterThanOrEqual]
    ['5' filterOperatorLessThanOrEqual]
    ['6' filterOperatorLike]
    ['7' filterOperatorNot]
    ['8' filterOperatorBetween]
    ['9' filterOperatorInList]
    ['10' filterOperatorAnd]
    ['11' filterOperatorOr]
    ['12' filterOperatorCast]
    ['13' filterOperatorInView]
    ['14' filterOperatorOfType]
    ['15' filterOperatorRelatedTo]
    ['16' filterOperatorBitwiseAnd]
    ['17' filterOperatorBitwiseOr]
    ]
            

[enum uint 32 TimestampsToReturn
    ['0' timestampsToReturnSource]
    ['1' timestampsToReturnServer]
    ['2' timestampsToReturnBoth]
    ['3' timestampsToReturnNeither]
    ['4' timestampsToReturnInvalid]
    ]
            

[enum uint 32 SortOrderType
    ['0' sortOrderTypeAscending]
    ['1' sortOrderTypeDescending]
    ]
            

[enum uint 32 HistoryUpdateType
    ['1' historyUpdateTypeInsert]
    ['2' historyUpdateTypeReplace]
    ['3' historyUpdateTypeUpdate]
    ['4' historyUpdateTypeDelete]
    ]
            

[enum uint 32 PerformUpdateType
    ['1' performUpdateTypeInsert]
    ['2' performUpdateTypeReplace]
    ['3' performUpdateTypeUpdate]
    ['4' performUpdateTypeRemove]
    ]
            

[enum uint 32 MonitoringMode
    ['0' monitoringModeDisabled]
    ['1' monitoringModeSampling]
    ['2' monitoringModeReporting]
    ]
            

[enum uint 32 DataChangeTrigger
    ['0' dataChangeTriggerStatus]
    ['1' dataChangeTriggerStatusValue]
    ['2' dataChangeTriggerStatusValueTimestamp]
    ]
            

[enum uint 32 DeadbandType
    ['0' deadbandTypeNone]
    ['1' deadbandTypeAbsolute]
    ['2' deadbandTypePercent]
    ]
            

[enum uint 32 RedundancySupport
    ['0' redundancySupportNone]
    ['1' redundancySupportCold]
    ['2' redundancySupportWarm]
    ['3' redundancySupportHot]
    ['4' redundancySupportTransparent]
    ['5' redundancySupportHotAndMirrored]
    ]
            

[enum uint 32 ServerState
    ['0' serverStateRunning]
    ['1' serverStateFailed]
    ['2' serverStateNoConfiguration]
    ['3' serverStateSuspended]
    ['4' serverStateShutdown]
    ['5' serverStateTest]
    ['6' serverStateCommunicationFault]
    ['7' serverStateUnknown]
    ]
            

[enum uint 32 ModelChangeStructureVerbMask
    ['1' modelChangeStructureVerbMaskNodeAdded]
    ['2' modelChangeStructureVerbMaskNodeDeleted]
    ['4' modelChangeStructureVerbMaskReferenceAdded]
    ['8' modelChangeStructureVerbMaskReferenceDeleted]
    ['16' modelChangeStructureVerbMaskDataTypeChanged]
    ]
            

[enum uint 32 AxisScaleEnumeration
    ['0' axisScaleEnumerationLinear]
    ['1' axisScaleEnumerationLog]
    ['2' axisScaleEnumerationLn]
    ]
            

[enum uint 32 ExceptionDeviationFormat
    ['0' exceptionDeviationFormatAbsoluteValue]
    ['1' exceptionDeviationFormatPercentOfValue]
    ['2' exceptionDeviationFormatPercentOfRange]
    ['3' exceptionDeviationFormatPercentOfEURange]
    ['4' exceptionDeviationFormatUnknown]
    ]
            

// OpaqueType
[type StatusCode
    // A 32-bit status code value.
                [simple uint 32 statusCode]
]
    [type ImageBMP
    
]
    [type ImageGIF
    
]
    [type ImageJPG
    
]
    [type ImagePNG
    
]
    [type AudioDataType
    
]
    [type UriString
    
]
    [type BitFieldMaskDataType
    
]
    [type SemanticVersionString
    
]
    [type Handle
    
]
    [type TrimmedString
    
]
    [type EncodedTicket
    
]
    [type NormalizedString
    
]
    [type DecimalString
    
]
    [type DurationString
    
]
    [type TimeString
    
]
    [type DateString
    
]
    
  [type UtcTime
    
]
    [type LocaleId
    
]
    [type Index
    
]
    [type IntegerId
    
]
    [type VersionTime
    
]
    [type ApplicationInstanceCertificate
    
]
    [type SessionAuthenticationToken
    
]
    [type RsaEncryptedSecret
    
]
    [type EccEncryptedSecret
    
]
    [type ContinuationPoint
    
]
    [type Counter
    
]
    [type NumericRange
    
]
    

[enum string 112 OpcuaDataType(uint 8 variantType)
    ['"NULL"' NULL ['0']]
    ['"BOOL"' BOOL ['1']]
    ['"BYTE"' BYTE ['3']]
    ['"SINT"' SINT ['2']]
    ['"INT"' INT ['4']]
    ['"DINT"' DINT ['6']]
    ['"LINT"' LINT ['8']]
    ['"USINT"' USINT ['3']]
    ['"UINT"' UINT ['5']]
    ['"UDINT"' UDINT ['7']]
    ['"ULINT"' ULINT ['9']]
    ['"REAL"' REAL ['10']]
    ['"LREAL"' LREAL ['11']]
    ['"TIME"' TIME ['1']]
    ['"LTIME"' LTIME ['1']]
    ['"DATE"' DATE ['1']]
    ['"LDATE"' LDATE ['1']]
    ['"TIME_OF_DAY"' TIME_OF_DAY ['1']]
    ['"LTIME_OF_DAY"' LTIME_OF_DAY ['1']]
    ['"DATE_AND_TIME"' DATE_AND_TIME ['13']]
    ['"LDATE_AND_TIME"' LDATE_AND_TIME ['1']]
    ['"CHAR"' CHAR ['1']]
    ['"WCHAR"' WCHAR ['1']]
    ['"STRING"' STRING ['12']]
]

[enum string 8 OpcuaIdentifierType
    ['"s"' STRING_IDENTIFIER]
    ['"i"' NUMBER_IDENTIFIER]
    ['"g"' GUID_IDENTIFIER]
    ['"b"' BINARY_IDENTIFIER]
]


    