/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.misc;

import java.io.InputStream;
import java.util.Properties;

public class MetadataUtils {
    private static final String METADATA_CONF_PATH = "rocketmq.metadata.properties";
    private static final String WRAPPER_METADATA_CONF_PATH = "rocketmq.wrapper.metadata.properties";
    private static final Properties METADATA_PROPERTIES = new Properties();
    private static final Properties WRAPPER_METADATA_PROPERTIES = new Properties();
    private static final String VERSION_KEY = "rocketmq.version";
    private static final String WRAPPER_VERSION_KEY = "rocketmq.wrapper.version";

    private MetadataUtils() {
    }

    private static void load(String path, Properties properties) {
        try (InputStream stream = MetadataUtils.class.getClassLoader().getResourceAsStream(path);){
            properties.load(stream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getVersion() {
        return METADATA_PROPERTIES.getProperty(VERSION_KEY);
    }

    public static String getWrapperVersion() {
        return WRAPPER_METADATA_PROPERTIES.getProperty(WRAPPER_VERSION_KEY);
    }

    static {
        MetadataUtils.load(METADATA_CONF_PATH, METADATA_PROPERTIES);
        MetadataUtils.load(WRAPPER_METADATA_CONF_PATH, WRAPPER_METADATA_PROPERTIES);
    }
}

