/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.registry.sc.SCConfigurationProperties;
import org.apache.servicecomb.service.center.client.model.DataCenterInfo;
import org.apache.servicecomb.service.center.client.model.Framework;
import org.apache.servicecomb.service.center.client.model.HealthCheck;
import org.apache.servicecomb.service.center.client.model.HealthCheckMode;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.MicroserviceStatus;
import org.springframework.core.env.Environment;

public class MicroserviceHandler {
    private static final String SERVICE_MAPPING = "SERVICE_MAPPING";
    private static final String VERSION_MAPPING = "VERSION_MAPPING";
    private static final String APP_MAPPING = "APP_MAPPING";
    private static final String CAS_APPLICATION_ID = "CAS_APPLICATION_ID";
    private static final String CAS_COMPONENT_NAME = "CAS_COMPONENT_NAME";
    private static final String CAS_INSTANCE_VERSION = "CAS_INSTANCE_VERSION";
    private static final String CAS_INSTANCE_ID = "CAS_INSTANCE_ID";
    private static final String CAS_ENVIRONMENT_ID = "CAS_ENVIRONMENT_ID";
    private static final String SERVICE_PROPS = "SERVICECOMB_SERVICE_PROPS";
    private static final String INSTANCE_PROPS = "SERVICECOMB_INSTANCE_PROPS";

    public static Microservice createMicroservice(Environment environment) {
        Microservice microservice = new Microservice();
        microservice.setProperties(BootStrapProperties.readServiceProperties((Environment)environment));
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(APP_MAPPING)) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty(APP_MAPPING)))) {
            microservice.setAppId(environment.getProperty(environment.getProperty(APP_MAPPING)));
        } else {
            microservice.setAppId(BootStrapProperties.readApplication((Environment)environment));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(SERVICE_MAPPING)) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty(SERVICE_MAPPING)))) {
            microservice.setServiceName(environment.getProperty(environment.getProperty(SERVICE_MAPPING)));
        } else {
            microservice.setServiceName(BootStrapProperties.readServiceName((Environment)environment));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(VERSION_MAPPING)) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty(VERSION_MAPPING)))) {
            microservice.setVersion(environment.getProperty(environment.getProperty(VERSION_MAPPING)));
        } else {
            microservice.setVersion(BootStrapProperties.readServiceVersion((Environment)environment));
        }
        microservice.setEnvironment(BootStrapProperties.readServiceEnvironment((Environment)environment));
        Framework framework = MicroserviceHandler.createFramework();
        microservice.setFramework(framework);
        String[] servicePropArray = ConfigUtil.parseArrayValue((String)environment.getProperty(SERVICE_PROPS)).toArray(new String[0]);
        if (servicePropArray.length != 0) {
            microservice.getProperties().putAll(MicroserviceHandler.parseProps(servicePropArray));
        }
        microservice.setStatus(MicroserviceStatus.UP);
        return microservice;
    }

    private static Framework createFramework() {
        Framework framework = new Framework();
        framework.setName("ServiceComb");
        framework.setVersion(MicroserviceHandler.class.getPackage().getImplementationVersion());
        return framework;
    }

    public static MicroserviceInstance createMicroserviceInstance(Environment environment, SCConfigurationProperties scConfigurationProperties, DataCenterProperties dataCenterProperties) {
        String hostName;
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        String string = hostName = StringUtils.isEmpty((CharSequence)scConfigurationProperties.getHostname()) ? NetUtils.getHostName() : scConfigurationProperties.getHostname();
        if (hostName.length() > 64) {
            hostName = hostName.substring(0, 64);
        }
        microserviceInstance.setHostName(hostName);
        if (StringUtils.isNotEmpty((CharSequence)dataCenterProperties.getName())) {
            DataCenterInfo dataCenterInfo = new DataCenterInfo();
            dataCenterInfo.setName(dataCenterProperties.getName());
            dataCenterInfo.setRegion(dataCenterProperties.getRegion());
            dataCenterInfo.setAvailableZone(dataCenterProperties.getAvailableZone());
            microserviceInstance.setDataCenterInfo(dataCenterInfo);
        }
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setMode(HealthCheckMode.push);
        healthCheck.setInterval(scConfigurationProperties.getHealthCheckIntervalInSeconds());
        healthCheck.setTimes(scConfigurationProperties.getHealthCheckTimes());
        microserviceInstance.setHealthCheck(healthCheck);
        String currTime = String.valueOf(System.currentTimeMillis());
        microserviceInstance.setTimestamp(currTime);
        microserviceInstance.setModTimestamp(currTime);
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(VERSION_MAPPING)) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty(VERSION_MAPPING)))) {
            microserviceInstance.setVersion(environment.getProperty(environment.getProperty(VERSION_MAPPING)));
        } else {
            microserviceInstance.setVersion(BootStrapProperties.readServiceVersion((Environment)environment));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(BootStrapProperties.readServiceProperties((Environment)environment));
        properties.putAll(MicroserviceHandler.genCasProperties(environment));
        microserviceInstance.setProperties(properties);
        microserviceInstance.setStatus(MicroserviceInstanceStatus.valueOf((String)BootStrapProperties.readServiceInstanceInitialStatus((Environment)environment)));
        return microserviceInstance;
    }

    private static Map<String, String> genCasProperties(Environment environment) {
        String[] instancePropArray;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_APPLICATION_ID))) {
            properties.put(CAS_APPLICATION_ID, environment.getProperty(CAS_APPLICATION_ID));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_COMPONENT_NAME))) {
            properties.put(CAS_COMPONENT_NAME, environment.getProperty(CAS_COMPONENT_NAME));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_INSTANCE_VERSION))) {
            properties.put(CAS_INSTANCE_VERSION, environment.getProperty(CAS_INSTANCE_VERSION));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_INSTANCE_ID))) {
            properties.put(CAS_INSTANCE_ID, environment.getProperty(CAS_INSTANCE_ID));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_ENVIRONMENT_ID))) {
            properties.put(CAS_ENVIRONMENT_ID, environment.getProperty(CAS_ENVIRONMENT_ID));
        }
        if ((instancePropArray = ConfigUtil.parseArrayValue((String)environment.getProperty(INSTANCE_PROPS)).toArray(new String[0])).length != 0) {
            properties.putAll(MicroserviceHandler.parseProps(instancePropArray));
        }
        return properties;
    }

    private static Map<String, String> parseProps(String ... value) {
        return Arrays.stream(value).map(v -> v.split(":")).filter(v -> ((String[])v).length == 2).collect(Collectors.toMap(v -> v[0], v -> v[1]));
    }
}

