/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;

public class JRDesignHyperlink
extends JRBaseHyperlink
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_HYPERLINK_ANCHOR_EXPRESSION = "hyperlinkAnchorExpression";
    public static final String PROPERTY_HYPERLINK_PAGE_EXPRESSION = "hyperlinkPageExpression";
    public static final String PROPERTY_HYPERLINK_REFERENCE_EXPRESSION = "hyperlinkReferenceExpression";
    public static final String PROPERTY_HYPERLINK_WHEN_EXPRESSION = "hyperlinkWhenExpression";
    public static final String PROPERTY_HYPERLINK_TARGET = "hyperlinkTarget";
    public static final String PROPERTY_LINK_TARGET = "linkTarget";
    public static final String PROPERTY_HYPERLINK_TOOLTIP_EXPRESSION = "hyperlinkTooltipExpression";
    public static final String PROPERTY_LINK_TYPE = "hyperlinkType";
    public static final String PROPERTY_HYPERLINK_PARAMETERS = "hyperlinkParameters";
    private List<JRHyperlinkParameter> hyperlinkParametersList = new ArrayList<JRHyperlinkParameter>();
    private transient JRPropertyChangeSupport eventSupport;

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_REFERENCE_EXPRESSION, old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_WHEN_EXPRESSION, old, this.hyperlinkWhenExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_ANCHOR_EXPRESSION, old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_PAGE_EXPRESSION, old, this.hyperlinkPageExpression);
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange(PROPERTY_LINK_TYPE, old, this.linkType);
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange(PROPERTY_LINK_TARGET, old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParametersList.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParametersList.size()];
            this.hyperlinkParametersList.toArray(parameters);
        }
        return parameters;
    }

    @JsonSetter
    private void setHyperlinkParameters(List<JRHyperlinkParameter> parameters) {
        if (parameters != null) {
            for (JRHyperlinkParameter parameter : parameters) {
                this.addHyperlinkParameter(parameter);
            }
        }
    }

    @JsonIgnore
    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParametersList;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParametersList.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, this.hyperlinkParametersList.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParametersList.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParametersList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParametersList.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, parameter, it.nextIndex());
        }
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_TARGET, old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Object clone() {
        JRDesignHyperlink clone = (JRDesignHyperlink)super.clone();
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignHyperlink jRDesignHyperlink = this;
        synchronized (jRDesignHyperlink) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

