/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DatasetSortInfo;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.SortedDataSource;

class SortFillDatasetRun
extends JRFillDatasetRun {
    private DatasetSortInfo sortInfo;
    private int recordIndex;
    private List<SortedDataSource.SortRecord> records;

    public SortFillDatasetRun(BaseReportFiller filler, JRFillDataset dataset, DatasetSortInfo sortInfo) throws JRException {
        super(filler, (JRDatasetRun)new JRDesignDatasetRun(), dataset);
        this.sortInfo = sortInfo;
    }

    public List<SortedDataSource.SortRecord> sort() throws JRException {
        this.recordIndex = 0;
        this.records = new ArrayList<SortedDataSource.SortRecord>();
        try {
            this.iterate();
        }
        finally {
            this.dataset.closeQueryExecuter();
            this.dataset.reset();
        }
        return this.records;
    }

    @Override
    protected void detail() throws JRScriptletException, JRException {
        super.detail();
        List<DatasetSortInfo.RecordField> recordFields = this.sortInfo.getRecordFields();
        int fieldCount = recordFields.size();
        Object[] record = new Object[fieldCount];
        int index = 0;
        for (DatasetSortInfo.RecordField recordField : recordFields) {
            Object value = recordField.isVariable() ? this.dataset.getVariableValue(recordField.getName()) : this.dataset.getFieldValue(recordField.getName());
            record[index] = value;
            ++index;
        }
        SortedDataSource.SortRecord sortRecord = new SortedDataSource.SortRecord(record, this.recordIndex);
        ++this.recordIndex;
        this.records.add(sortRecord);
    }

    @Override
    protected boolean advanceDataset() throws JRException {
        return this.dataset.next(true);
    }

    @Override
    protected boolean toStartWhenNoData() {
        return false;
    }
}

