/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.feature.CharacteristicMap;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.MultiValuedAttribute;
import org.apache.sis.feature.SingletonAttribute;
import org.apache.sis.feature.Validator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractAttribute<V>
extends Field<V>
implements Serializable {
    private static final long serialVersionUID = 7442739120526654676L;
    final DefaultAttributeType<V> type;
    private transient Map<String, AbstractAttribute<?>> characteristics;

    protected AbstractAttribute(DefaultAttributeType<V> type) {
        this.type = type;
    }

    public static <V> AbstractAttribute<V> create(DefaultAttributeType<V> type) {
        ArgumentChecks.ensureNonNull("type", type);
        return AbstractAttribute.isSingleton(type.getMaximumOccurs()) ? new SingletonAttribute<V>(type) : new MultiValuedAttribute<V>(type);
    }

    static <V> AbstractAttribute<V> create(DefaultAttributeType<V> type, Object value) {
        ArgumentChecks.ensureNonNull("type", type);
        return AbstractAttribute.isSingleton(type.getMaximumOccurs()) ? new SingletonAttribute<V>(type, value) : new MultiValuedAttribute<V>(type, value);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        AbstractAttribute[] characterizedBy = this.characteristics instanceof CharacteristicMap ? (AbstractAttribute[])this.characteristics.values().toArray(AbstractAttribute[]::new) : null;
        out.writeObject(characterizedBy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            AbstractAttribute[] characterizedBy = (AbstractAttribute[])in.readObject();
            if (characterizedBy != null) {
                this.characteristics = this.newCharacteristicsMap();
                Collections.addAll(this.characteristics.values(), characterizedBy);
            }
        }
        catch (RuntimeException e) {
            throw (IOException)new InvalidObjectException(e.getLocalizedMessage()).initCause(e);
        }
    }

    @Override
    public GenericName getName() {
        return this.type.getName();
    }

    public DefaultAttributeType<V> getType() {
        return this.type;
    }

    @Override
    public abstract V getValue() throws IllegalStateException;

    @Override
    public Collection<V> getValues() {
        return super.getValues();
    }

    @Override
    public abstract void setValue(V var1) throws IllegalArgumentException;

    @Override
    public void setValues(Collection<? extends V> values) throws IllegalArgumentException {
        super.setValues(values);
    }

    public Map<String, AbstractAttribute<?>> characteristics() {
        if (this.characteristics == null) {
            this.characteristics = this.newCharacteristicsMap();
        }
        return this.characteristics;
    }

    private Map<String, AbstractAttribute<?>> newCharacteristicsMap() {
        CharacteristicTypeMap map;
        if (this.type instanceof DefaultAttributeType && !(map = this.type.characteristics()).isEmpty()) {
            if (!(map instanceof CharacteristicTypeMap)) {
                Collection<DefaultAttributeType<?>> types = map.values();
                map = CharacteristicTypeMap.create(this.type, (DefaultAttributeType[])types.toArray(DefaultAttributeType[]::new));
            }
            return new CharacteristicMap(this, map);
        }
        return Collections.emptyMap();
    }

    final Map<String, AbstractAttribute<?>> characteristicsReadOnly() {
        return this.characteristics != null ? this.characteristics : Collections.emptyMap();
    }

    public DataQuality quality() {
        Validator v = new Validator(ScopeCode.ATTRIBUTE);
        v.validate(this.type, this.getValues());
        return v.quality;
    }

    public String toString() {
        StringBuilder buffer = FieldType.toString(AbstractAttribute.isDeprecated(this.type), "Attribute", this.type.getName(), Classes.getShortName(this.type.getValueClass()), this.getValues().iterator());
        if (this.characteristics != null && !this.characteristics.isEmpty()) {
            buffer.append(System.lineSeparator());
            String separator = "\u2514\u2500 characteristics: ";
            for (Map.Entry<String, AbstractAttribute<?>> entry : this.characteristics.entrySet()) {
                buffer.append(separator).append(entry.getKey()).append('=').append(entry.getValue().getValue());
                separator = ", ";
            }
        }
        return buffer.toString();
    }

    public AbstractAttribute<V> clone() throws CloneNotSupportedException {
        AbstractAttribute clone = (AbstractAttribute)super.clone();
        Map<String, AbstractAttribute<?>> c = clone.characteristics;
        if (c instanceof CharacteristicMap) {
            clone.characteristics = ((CharacteristicMap)c).clone();
        }
        return clone;
    }
}

