/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import org.apache.camel.util.ObjectHelper;

public final class WeakThreadLocal<T>
implements Supplier<T> {
    private final ThreadLocal<WeakReference<T>> cache = new ThreadLocal();
    private final Supplier<T> supplier;

    public WeakThreadLocal(Supplier<T> supplier) {
        this.supplier = ObjectHelper.notNull(supplier, "value supplier");
    }

    @Override
    public T get() {
        Object value = null;
        WeakReference<T> ref = this.cache.get();
        if (ref != null) {
            value = ref.get();
        }
        if (value == null) {
            value = this.supplier.get();
            this.cache.set(new WeakReference<Object>(value));
        }
        return value;
    }

    public static <T> WeakThreadLocal<T> withSupplier(Supplier<T> supplier) {
        return new WeakThreadLocal<T>(supplier);
    }
}

