/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.resource.loader.IStringResourceLoader;

public class BundleStringResourceLoader
implements IStringResourceLoader {
    private final String bundleName;

    public BundleStringResourceLoader(String bundleName) {
        this.bundleName = bundleName;
    }

    @Override
    public final String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (locale == null) {
            locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(this.bundleName, locale).getString(key);
        }
        catch (MissingResourceException mrx) {
            try {
                return ResourceBundle.getBundle(this.bundleName, locale, Thread.currentThread().getContextClassLoader()).getString(key);
            }
            catch (MissingResourceException mrx2) {
                return null;
            }
        }
    }

    @Override
    public final String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        return this.loadStringResource((Class)null, key, locale, style, variation);
    }
}

