/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonOriginalPsiWalker
implements JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker INSTANCE = new JsonOriginalPsiWalker();

    public boolean handles(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        return element instanceof JsonFile && JsonDialectUtil.isStandardJson((PsiElement)element) || parent != null && (element instanceof JsonElement || element instanceof LeafPsiElement && parent instanceof JsonElement) && JsonDialectUtil.isStandardJson((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)parent));
    }

    @Override
    public boolean isQuotedString(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof JsonStringLiteral;
    }

    @Override
    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JsonObject) {
            return ThreeState.YES;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)element, (boolean)false) ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.NO;
    }

    @Override
    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(2);
        }
        if (element instanceof JsonStringLiteral || element instanceof JsonReferenceExpression) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof JsonProperty) || ((JsonProperty)parent).getNameElement() != element) {
                return false;
            }
            element = parent;
        }
        return element instanceof JsonProperty && ((JsonProperty)element).getValue() != null;
    }

    @Override
    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(3);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue) && !(current instanceof JsonProperty)) continue;
            return current;
        }
        return null;
    }

    @Override
    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(4);
        }
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array = (JsonArray)current;
                List list = array.getValueList();
                int idx = -1;
                for (int i = 0; i < list.size(); ++i) {
                    JsonValue value = (JsonValue)list.get(i);
                    if (!value.equals((Object)position)) continue;
                    idx = i;
                    break;
                }
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof JsonProperty) {
                propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        return pos;
    }

    @Override
    public boolean requiresNameQuotes() {
        return true;
    }

    @Override
    public boolean allowsSingleQuotes() {
        return false;
    }

    @Override
    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = current = element instanceof JsonProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        while (current != null && current.getNode().getElementType() != JsonElementTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        if (object != null) {
            for (JsonProperty property : object.getPropertyList()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        JsonObject object;
        if (originalPosition == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(6);
        }
        if ((object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, JsonObject.class, (boolean)false)) != null) {
            return object.getPropertyList().stream().filter(p -> !this.requiresNameQuotes() || p.getNameElement() instanceof JsonStringLiteral).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        JsonProperty property;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(7);
        }
        if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false)) == null) {
            return null;
        }
        return new JsonJsonPropertyAdapter(property);
    }

    @Override
    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(8);
        }
        return element instanceof PsiFile;
    }

    @Override
    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(9);
        }
        if (element instanceof JsonProperty) {
            JsonPropertyAdapter parentPropertyAdapter = this.getParentPropertyAdapter(element);
            return parentPropertyAdapter == null ? null : parentPropertyAdapter.getNameValueAdapter();
        }
        return element instanceof JsonValue ? JsonJsonPropertyAdapter.createAdapterByType((JsonValue)element) : null;
    }

    @Override
    public JsonLikeSyntaxAdapter getSyntaxAdapter(Project project) {
        return JsonOriginalSyntaxAdapter.INSTANCE;
    }

    @Override
    @Nullable
    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class), (Class[])new Class[]{JsonObject.class, JsonArray.class});
    }

    @Override
    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        if (file == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(10);
        }
        List list = file instanceof JsonFile ? ContainerUtil.createMaybeSingletonList((Object)((JsonFile)file).getTopLevelValue()) : ContainerUtil.emptyList();
        if (list == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof JsonProperty ? ((JsonProperty)property).getNameElement() : null;
    }

    @Override
    public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(12);
        }
        if ((parent = element.getParent()) instanceof JsonFile) {
            PsiElement child = PsiTreeUtil.skipMatching((PsiElement)element.getFirstChild(), e -> e.getNextSibling(), e -> !(e instanceof JsonElement));
            return child == null ? element.getTextRange() : child.getTextRange();
        }
        return element.getTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementToCheck";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingCommaAfter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentPropertyAdapter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTopJsonElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adjustErrorHighlightingRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    private static class JsonOriginalSyntaxAdapter
    implements JsonLikeSyntaxAdapter {
        private static final JsonOriginalSyntaxAdapter INSTANCE = new JsonOriginalSyntaxAdapter();

        private JsonOriginalSyntaxAdapter() {
        }

        @Override
        @NotNull
        public PsiElement createProperty(@NotNull String name, @NotNull String value, @NotNull Project project) {
            if (name == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(0);
            }
            if (value == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(1);
            }
            if (project == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(2);
            }
            JsonProperty jsonProperty = new JsonElementGenerator(project).createProperty(name, value);
            if (jsonProperty == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(3);
            }
            return jsonProperty;
        }

        @Override
        @NotNull
        public PsiElement createEmptyArray(@NotNull Project project, boolean preferInline) {
            if (project == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(4);
            }
            JsonArray jsonArray = new JsonElementGenerator(project).createEmptyArray();
            if (jsonArray == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(5);
            }
            return jsonArray;
        }

        @Nullable
        private static PsiElement skipWsBackward(@Nullable PsiElement item) {
            while (item instanceof PsiWhiteSpace || item instanceof PsiComment) {
                item = PsiTreeUtil.prevLeaf((PsiElement)item);
            }
            return item;
        }

        @Nullable
        private static PsiElement skipWsForward(@Nullable PsiElement item) {
            while (item instanceof PsiWhiteSpace || item instanceof PsiComment) {
                item = PsiTreeUtil.nextLeaf((PsiElement)item);
            }
            return item;
        }

        @Override
        public void removeArrayItem(@NotNull PsiElement item) {
            PsiElement parent;
            if (item == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(6);
            }
            if (!((parent = item.getParent()) instanceof JsonArray)) {
                throw new IllegalArgumentException("Cannot remove item from a non-array element");
            }
            PsiElement prev = JsonOriginalSyntaxAdapter.skipWsBackward(PsiTreeUtil.prevLeaf((PsiElement)item));
            PsiElement next = JsonOriginalSyntaxAdapter.skipWsForward(PsiTreeUtil.nextLeaf((PsiElement)item));
            if (prev instanceof LeafPsiElement && ((LeafPsiElement)prev).getElementType() == JsonElementTypes.COMMA) {
                prev.delete();
            } else if (next instanceof LeafPsiElement && ((LeafPsiElement)next).getElementType() == JsonElementTypes.COMMA) {
                next.delete();
            }
            item.delete();
        }

        @Override
        @NotNull
        public PsiElement addArrayItem(@NotNull PsiElement array, @NotNull String itemValue) {
            if (array == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(7);
            }
            if (itemValue == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(8);
            }
            if (!(array instanceof JsonArray)) {
                throw new IllegalArgumentException("Cannot add item to a non-array element");
            }
            JsonElementGenerator generator = new JsonElementGenerator(array.getProject());
            JsonValue arrayItem = generator.createArrayItemValue(itemValue);
            PsiElement addedItem = array.addBefore((PsiElement)arrayItem, array.getLastChild());
            if (((JsonArray)array).getValueList().size() > 1) {
                array.addBefore(generator.createComma(), addedItem);
            }
            PsiElement psiElement = addedItem;
            if (psiElement == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(9);
            }
            return psiElement;
        }

        @Override
        public void ensureComma(PsiElement self, PsiElement newElement) {
            if (newElement instanceof JsonProperty && self instanceof JsonProperty) {
                PsiElement sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)self);
                if (sibling != null && sibling.getText().equals(",")) {
                    return;
                }
                self.getParent().addAfter(new JsonElementGenerator(self.getProject()).createComma(), self);
            }
        }

        @Override
        public void removeIfComma(PsiElement forward) {
            if (forward instanceof LeafPsiElement) {
                LeafPsiElement prev;
                PsiElement psiElement;
                LeafPsiElement leaf = (LeafPsiElement)forward;
                if (leaf.getElementType() == JsonElementTypes.COMMA) {
                    forward.delete();
                }
                if (leaf.getElementType() == JsonElementTypes.R_CURLY && (psiElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)leaf)) instanceof LeafPsiElement && (prev = (LeafPsiElement)psiElement).getElementType() == JsonElementTypes.COMMA) {
                    prev.delete();
                }
            }
        }

        @Override
        public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
            return true;
        }

        @Override
        @NotNull
        public PsiElement adjustNewProperty(@NotNull PsiElement element) {
            if (element == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(10);
            }
            PsiElement psiElement = element;
            if (psiElement == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(11);
            }
            return psiElement;
        }

        @Override
        @NotNull
        public PsiElement adjustPropertyAnchor(@NotNull LeafPsiElement element) {
            if (element == null) {
                JsonOriginalSyntaxAdapter.$$$reportNull$$$0(12);
            }
            throw new IncorrectOperationException("Shouldn't use leafs for insertion in pure JSON!");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker$JsonOriginalSyntaxAdapter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemValue";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker$JsonOriginalSyntaxAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProperty";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEmptyArray";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addArrayItem";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustNewProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createProperty";
                    break;
                }
                case 3: 
                case 5: 
                case 9: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createEmptyArray";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeArrayItem";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addArrayItem";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustNewProperty";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustPropertyAnchor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 9, 11 -> new IllegalStateException(string);
            };
        }
    }
}

