/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.jsonSchema.extension.JsonAnnotationsCollectionMode;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\"E\u0010\u0000\u001a9\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003 \u0006*\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"JSON_SCHEMA_VALIDATION_MAP", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrComputeAdapterValidityAgainstGivenSchema", "value", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonValueAdapter;", "schema", "intellij.json.backend"})
public final class JsonSchemaValidityCacheKt {
    @NotNull
    private static final Key<CachedValue<Map<JsonSchemaObject, Boolean>>> JSON_SCHEMA_VALIDATION_MAP;

    public static final boolean getOrComputeAdapterValidityAgainstGivenSchema(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        PsiElement psiElement = value.getDelegate();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDelegate(...)");
        PsiElement delegatePsi = psiElement;
        Object object = CachedValuesManager.getManager((Project)delegatePsi.getProject()).getCachedValue((UserDataHolder)delegatePsi, JSON_SCHEMA_VALIDATION_MAP, () -> JsonSchemaValidityCacheKt.getOrComputeAdapterValidityAgainstGivenSchema$lambda$0(delegatePsi), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        Map cachedMap = (Map)object;
        Boolean cachedValue = (Boolean)cachedMap.get(schema);
        if (cachedValue != null) {
            return cachedValue;
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(value.getDelegate().getProject(), new JsonComplianceCheckerOptions(false, false, false, JsonAnnotationsCollectionMode.FIND_FIRST));
        checker.checkByScheme(value, schema);
        boolean computedValue = checker.isCorrect();
        cachedMap.put(schema, computedValue);
        return computedValue;
    }

    private static final CachedValueProvider.Result getOrComputeAdapterValidityAgainstGivenSchema$lambda$0(PsiElement $delegatePsi) {
        Object[] objectArray = new Object[]{$delegatePsi.getManager().getModificationTracker().forLanguage($delegatePsi.getLanguage()), JsonSchemaService.Impl.get($delegatePsi.getProject())};
        return CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])objectArray);
    }

    static {
        Key key = Key.create((String)"JSON_SCHEMA_VALIDATION_MAP");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JSON_SCHEMA_VALIDATION_MAP = key;
    }
}

