/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.rules.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public record Example(String errorText, List<String> correctedTexts, Map<Parameter, String> parameters) {
    private static final Predicate<String> textWithMarkers = Pattern.compile(".*<b>.+</b>.*", 32).asMatchPredicate();

    public Example(String errorText, String ... correctedTexts) {
        this(errorText, List.of(correctedTexts), Map.of());
    }

    public Example {
        if (!textWithMarkers.test(errorText) || !correctedTexts.stream().allMatch(textWithMarkers)) {
            throw new IllegalArgumentException("Examples should contain <b>...</b> selection");
        }
    }

    @Override
    public String toString() {
        return "Example{errorText='" + this.errorText + "', correctedTexts=" + String.valueOf(this.correctedTexts) + "}";
    }
}

