/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.Example;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.lang.invoke.CallSite;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DateChecker {
    public static final String yearPattern = "[123][0-9]{3}";
    public static final NodePattern year = NodePattern.N.form("[123][0-9]{3}");
    protected static final NodePattern dashDate = NodePattern.N.inFormSequence(0, "[123][0-9]{3}", "-", "\\d\\d", "-", "\\d\\d").markAs("Year");
    protected static final Pattern dotDate = Pattern.compile("([0-9]{1,3})\\.([0-9][0-9]?)(?:\\.([123][0-9]{3}))?");
    public static final NodePattern dottedDateNode = NodePattern.N.form(dotDate.pattern());
    protected final DateTimeFormatter fullDayFormat;
    protected final DateTimeFormatter canonicalDateFormat;
    protected final DateTimeFormatter noYearDateFormat;
    protected final Locale locale;
    public final List<String> monthNames;
    public final List<String> dayNames;
    private static final ThreadLocal<LocalDate> today = new ThreadLocal();

    public DateChecker(Locale locale, String canonicalDateFormat, String noYearDateFormat) {
        this.fullDayFormat = DateTimeFormatter.ofPattern("eeee", locale);
        this.canonicalDateFormat = DateTimeFormatter.ofPattern(canonicalDateFormat, locale);
        this.noYearDateFormat = DateTimeFormatter.ofPattern(noYearDateFormat, locale);
        this.locale = locale;
        this.monthNames = StreamEx.of((Object[])Month.values()).map(m -> this.renderMonth((Month)m).toLowerCase(locale)).toList();
        this.dayNames = StreamEx.of((Object[])DayOfWeek.values()).map(m -> this.renderDay(locale, (DayOfWeek)m).toLowerCase(locale)).toList();
    }

    protected String renderDay(Locale locale, DayOfWeek day) {
        return day.getDisplayName(TextStyle.FULL_STANDALONE, locale);
    }

    protected String renderMonth(Month m) {
        return m.getDisplayName(TextStyle.FULL_STANDALONE, this.locale);
    }

    public Example weekdayExample(YearStrategy strategy) {
        LocalDate now = LocalDate.now();
        DayOfWeek right = now.getDayOfWeek();
        DayOfWeek wrong = DayOfWeek.values()[(right.ordinal() + 1) % 7];
        DateTimeFormatter formatter = strategy == YearStrategy.absolute ? this.canonicalDateFormat : this.noYearDateFormat;
        String date = formatter.format(now);
        String sentence = this.weekdayExampleSentence(date, this.fullDayFormat.format(wrong));
        return new Example(sentence, this.weekdayExampleSentence(date, this.fullDayFormat.format(right)), this.weekdayExampleSentence(formatter.format(now.withDayOfMonth(DateChecker.findClosestDateForWeekday(now, wrong, right))), this.fullDayFormat.format(wrong)));
    }

    @Nullable
    public NodeMatch checkWeekday(Node dayName, NodeMatch match, ParsedDate parsedDate, YearStrategy strategy) {
        LocalDate date = parsedDate.validDate();
        if (date == null) {
            return null;
        }
        DayOfWeek dayInText = this.findDayOfWeek(dayName);
        DayOfWeek expected = date.getDayOfWeek();
        if (expected != dayInText) {
            if (strategy == YearStrategy.current) {
                boolean hasPast = this.hasPastTenseAround(dayName);
                if (hasPast && parsedDate.isInFuture()) {
                    return null;
                }
                if (!hasPast && date.isBefore(DateChecker.now()) && date.plusYears(1L).getDayOfWeek() == dayInText) {
                    return null;
                }
            }
            return match.withMessage(this.wrongWeekdayMessage(date, dayInText, dayName.tree().text(), strategy)).withCorrector(this.weekdayCorrector(dayName, expected)).withCorrector(this.monthDayCorrector(parsedDate, DateChecker.findClosestDateForWeekday(date, dayInText, expected))).withCorrector(DateChecker.toCurrentYear(date, parsedDate, dayInText));
        }
        return null;
    }

    @Nullable
    private static NodeCorrector toCurrentYear(LocalDate date, ParsedDate parsed, DayOfWeek dayInText) {
        int currentYear = DateChecker.now().getYear();
        try {
            if (parsed.yearRange != null && date.withYear(currentYear).getDayOfWeek() == dayInText) {
                return NodeCorrector.rawReplace(parsed.yearRange, String.valueOf(currentYear));
            }
        }
        catch (DateTimeException dateTimeException) {
            // empty catch block
        }
        return null;
    }

    private static int findClosestDateForWeekday(LocalDate date, DayOfWeek dayInText, DayOfWeek dayInLife) {
        int newDay;
        int delta = dayInText.getValue() - dayInLife.getValue();
        if (delta > 3) {
            delta -= 7;
        }
        if (delta < -3) {
            delta += 7;
        }
        if ((newDay = date.getDayOfMonth() + delta) <= 0) {
            newDay += 7;
        }
        if (newDay >= date.getMonth().length(date.isLeapYear())) {
            newDay -= 7;
        }
        return newDay;
    }

    protected abstract boolean hasPastTenseAround(Node var1);

    protected NodeCorrector weekdayCorrector(Node dayName, DayOfWeek expected) {
        String fullExpected = this.fullDayFormat.format(expected);
        String replacement = dayName.form().length() > 3 ? fullExpected : (dayName.form().endsWith(".") ? fullExpected.substring(0, dayName.form().length() - 1) + "." : fullExpected.substring(0, dayName.form().length()));
        return NodeCorrector.replace(dayName, replacement);
    }

    protected NodeCorrector monthDayCorrector(ParsedDate date, int dayOfMonth) {
        return NodeCorrector.rawReplace(date.dayOfMonth, String.valueOf(dayOfMonth));
    }

    protected abstract String weekdayExampleSentence(String var1, String var2);

    protected abstract String wrongWeekdayMessage(LocalDate var1, DayOfWeek var2, String var3, YearStrategy var4);

    protected static boolean isLeapYear(@NotNull String year) {
        return new GregorianCalendar().isLeapYear(Integer.parseInt(year));
    }

    protected DayOfWeek findDayOfWeek(Node weekday) {
        return DayOfWeek.of(DateChecker.findStarting(weekday.lowForm(), this.dayNames) + 1);
    }

    protected static int findStarting(String prefix, List<String> fullForms) {
        return (int)StreamEx.of(fullForms).indexOf(s -> s.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT))).orElseThrow();
    }

    @Nullable
    protected static LocalDate validDate(@Nullable Integer year, @NotNull Month month, int day) {
        if (year == null) {
            return null;
        }
        try {
            return LocalDate.of((int)year, month, day);
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    protected static NodePattern fiveDigitYear(String message) {
        return NodePattern.N.form("[12]\\d{4}").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\\d{2,}"))).and((n, match) -> {
            LinkedHashSet<CallSite> suggestions = new LinkedHashSet<CallSite>();
            String form = n.form();
            for (int i = 1; i < form.length(); ++i) {
                if (form.charAt(i - 1) != form.charAt(i)) continue;
                suggestions.add((CallSite)((Object)(form.substring(0, i - 1) + form.substring(i))));
            }
            return match.withMessage(message).withCorrector(NodeCorrector.replace(n, new ArrayList<String>(suggestions)));
        }).onlyWithSuggestions();
    }

    protected static String trimDot(String form) {
        return form.endsWith(".") ? form.substring(0, form.length() - 1) : form;
    }

    public static LocalDate now() {
        return today.get() != null ? today.get() : LocalDate.now();
    }

    @TestOnly
    public static void forceToday(LocalDate date, Runnable runnable) {
        assert (today.get() == null);
        today.set(date);
        try {
            runnable.run();
        }
        finally {
            today.remove();
        }
    }

    @Nullable
    protected NodeMatch checkDateFromLastYear(Node node, NodeMatch match, @Nullable ParsedDate parsed, String messageFormat) {
        LocalDate date;
        LocalDate localDate = date = parsed == null ? null : parsed.validDate();
        if (date == null || date.getMonth().compareTo(Month.MAY) >= 0 || this.hasPastTenseAround(node)) {
            return null;
        }
        LocalDate now = DateChecker.now();
        if (now.getMonth() == Month.JANUARY && now.getYear() == date.getYear() + 1) {
            Node yearNode = match.findMarkedNode("Year");
            if (yearNode != null) {
                match = match.withCorrector(NodeCorrector.replace(yearNode, String.valueOf(now.getYear())));
            } else if (node.form().endsWith(String.valueOf(date.getYear()))) {
                match = match.withCorrector(NodeCorrector.replace(node, node.form().substring(0, node.form().length() - 4) + now.getYear()));
            }
            return match.withMessage(String.format(messageFormat, now.getYear()));
        }
        return null;
    }

    public static enum YearStrategy {
        absolute{

            @Override
            public Integer nodeYear(@Nullable Node yearNode) {
                return yearNode == null ? null : Integer.valueOf(Integer.parseInt(yearNode.form()));
            }

            @Override
            public Integer stringYear(@Nullable String yearString) {
                return yearString == null || yearString.isEmpty() ? null : Integer.valueOf(Integer.parseInt(yearString));
            }
        }
        ,
        current{

            @Override
            public Integer nodeYear(@Nullable Node yearNode) {
                return yearNode == null ? Integer.valueOf(DateChecker.now().getYear()) : null;
            }

            @Override
            public Integer stringYear(@Nullable String yearString) {
                return yearString == null || yearString.isEmpty() ? Integer.valueOf(DateChecker.now().getYear()) : null;
            }
        };


        @Nullable
        public abstract Integer nodeYear(@Nullable Node var1);

        @Nullable
        public abstract Integer stringYear(@Nullable String var1);
    }

    public record ParsedDate(Tree tree, TextRange dayOfMonth, TextRange monthRange, @Nullable TextRange yearRange, Month month, int year) {
        @Nullable
        public LocalDate validDate() {
            try {
                return LocalDate.of(this.year, this.month, Integer.parseInt(this.dayOfMonth.substring(this.tree.text())));
            }
            catch (NumberFormatException | DateTimeException e) {
                return null;
            }
        }

        public boolean isInFuture() {
            LocalDate date = this.validDate();
            return date != null && date.isAfter(DateChecker.now());
        }

        @Nullable
        public static ParsedDate fromNodes(Node dayNode, Node monthNode, @Nullable Node yearNode, YearStrategy strategy, Function<Node, @Nullable Month> findMonth) {
            Integer year = strategy.nodeYear(yearNode);
            Month month = findMonth.apply(monthNode);
            return year == null || month == null ? null : new ParsedDate(monthNode.tree(), dayNode.textRange(), monthNode.textRange(), yearNode == null ? null : yearNode.textRange(), month, year);
        }

        @Nullable
        public static ParsedDate fromDMYDotDate(Node node, YearStrategy strategy) {
            Matcher matcher = dotDate.matcher(node.form());
            if (matcher.matches()) {
                TextRange dayRange = new TextRange(matcher.start(1), matcher.end(1)).shiftRight(node.startOffset());
                TextRange monthRange = new TextRange(matcher.start(2), matcher.end(2)).shiftRight(node.startOffset());
                int yearStart = matcher.start(3);
                TextRange yearRange = yearStart < 0 ? null : new TextRange(yearStart, matcher.end(3)).shiftRight(node.startOffset());
                Tree tree = node.tree();
                Integer year = strategy.stringYear(yearRange == null ? null : yearRange.substring(tree.text()));
                int month = Integer.parseInt(monthRange.substring(tree.text()));
                try {
                    return year == null ? null : new ParsedDate(tree, dayRange, monthRange, yearRange, Month.of(month), year);
                }
                catch (DateTimeException e) {
                    return null;
                }
            }
            return null;
        }

        @Nullable
        public static ParsedDate fromAmbiguousDate(Tree tree, TextRange range1, TextRange range2, @Nullable TextRange yearRange, YearStrategy strategy) {
            Integer year = strategy.stringYear(yearRange == null ? null : yearRange.substring(tree.text()));
            if (year == null) {
                return null;
            }
            int int1 = Integer.parseInt(range1.substring(tree.text()));
            int int2 = Integer.parseInt(range2.substring(tree.text()));
            if (int1 > 12 && int2 > 0 && int2 <= 12) {
                return new ParsedDate(tree, range1, range2, yearRange, Month.of(int2), year);
            }
            if (int2 > 12 && int1 > 0 && int1 <= 12) {
                return new ParsedDate(tree, range2, range1, yearRange, Month.of(int1), year);
            }
            return null;
        }
    }
}

