/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class PrepositionIssues {
    static final NodePattern goToHead = NodePattern.N.lemma("gehen|fahren|fliegen|reisen|ziehen|Flug|Fahrt|Reisen?").noDependents("compound:prt");
    static final NodePattern needAufWithIslandCountry = NodePattern.N.form("Bahamas|Far(\u00f6|oe)ern?|Komoren|Malediven|Marshallinseln|Philippinen|Salomonen|Seychellen").withHead(NodePattern.or(goToHead, NodePattern.N.lemma("zelten|wohnen|verbringen"))).withDependent("case", NodePattern.N.form("in|nach").markAs("InNachPrepChangeToAuf"));
    private static final String UM_WITH_TIME_MSG = "Mit Zeitangaben wird normalerweise die Pr\u00e4position \u201eum\u201c verwendet";
    private static final NodePattern baggageNouns = NodePattern.N.lemma(".*(Tasche|Koffer|Box|Rucksack|Gep\u00e4ck)");
    private static final NodePattern windDrivenObjects = NodePattern.N.lemma(".*(Ballon|Segel)");
    private static final NodePattern coverings = NodePattern.N.lemma(".*(Dach|Netz|Vorhang|Deckel?)");
    private static final NodePattern communicationNouns = NodePattern.N.lemma(".*(Brief|Plan|Rede)");
    private static final NodePattern paperObjects = NodePattern.N.lemma(".*(Papier|Blatt)");
    private static final NodeCorrector.Relative hyphenToBis = NodeCorrector.replace(" bis ");
    static final NodePattern geo = NodePattern.N.label("GEO_POLITICAL_ENTITY");
    private static final NodePattern countryFemOrNoun = NodePattern.or(Articles.countryFeminineArticle, GermanValences.ort.pos("SUB.*").noLabel(".*"), Articles.countryPluralArticle);

    PrepositionIssues() {
    }

    static @NotNull Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.PREPOSITION_ISSUES", "Falsche Verwendung oder Weglassen einer Pr\u00e4position", "Einige Ausdr\u00fccke werden typischerweise mit bestimmten Pr\u00e4positionen oder ohne diese verwendet.", "https://easy-deutsch.com/german-verbs/complements/verbs-with-prepositions/", () -> NodePattern.or(PrepositionIssues.prepositionChoiceWithVerbalHead(), PrepositionIssues.prepositionChoiceWithToponyms(), PrepositionIssues.prepositionChoiceInSpecificPhrases(), PrepositionIssues.missingPrepositionWithTime(), PrepositionIssues.missingPrepositionInRange(), PrepositionIssues.seitAb(), PrepositionIssues.prepEs(), PrepositionIssues.stattDas(), PrepositionIssues.lonePreposition(), PrepositionIssues.fixCollocations(), PrepositionIssues.prepositionMisuse()), new Example("Wann h\u00f6rst du <b>die Arbeit</b> auf?", "Wann h\u00f6rst du <b>mit der Arbeit</b> auf?"));
    }

    private static NodePattern fixCollocations() {
        return NodePattern.or(NodePattern.N.inFormSequence(0, "vom|seit", "anfang|beginn", "an").and(SpellingRules.typoReplacement("von")), NodePattern.N.inFormSequence(1, ".+mal", "per").directlyBefore(SemanticRules.timeUnit).and(SpellingRules.typoReplacement("pro")));
    }

    private static NodePattern prepositionMisuse() {
        NodeCorrector.Relative removePreposition = NodeCorrector.replace(NodePointer.marked("Prep"), "");
        return NodePattern.or(NodePattern.N.inFormSequence(1, "(Eracht|Wiss)ens", "nach").withNeighbor(-1, NodePattern.N.withDependent("det", NodePattern.N.pos("PRO:POS.*"))).message("H\u00e4ufiger Fehler: Die Pr\u00e4position \u201enach\u201c ist \u00fcberfl\u00fcssig").correct(NodeCorrector.replace("")), NodePattern.N.form("(" + String.valueOf(SemanticRules.dayOfWeek) + "|sonnabend|sp\u00e4t|fr\u00fch)?((nach|vor)?mittag|abend|nacht|morgen)s").withDependent("case", NodePattern.N.form("[ia](ns?|m)").directlyBeforeHead().message("Die Pr\u00e4position \u201e$_\u201c ist \u00fcberfl\u00fcssig").correct(NodeCorrector.replace(""))), NodePattern.N.pos("VER.*").andOr(NodePattern.N.lemma("helfen"), NodePattern.N.lemma("geben").withDependent("obj"), NodePattern.N.lemma("stellen").withDependent("obj", NodePattern.N.lemma("Frage"))).noDependents("iobj").noDependents("compound:prt|mark", NodePattern.N.afterHead()).noDependents("nsubj(:pass)?|expl", NodePattern.N.form("['`\u00b4\u2019e]s")).withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("f\u00fcr").markAs("Prep").beforeHead()).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obj"))).andOr(NodePattern.N.pos("PRO:PER:AKK.*").directlyAfter(NodePattern.N.alreadyMarkedAs("Prep")).noDependents("acl", NodePattern.N.afterHead()).and((node, match) -> {
            String newPronoun;
            String string = node.form().equals("Sie") ? "Ihnen" : (node.hasForm("mich") ? "mir" : (node.hasForm("dich") ? "dir" : (newPronoun = node.hasForm("ihn") || node.hasForm("es") ? "ihm" : node.form())));
            match = node.hasForm("uns|euch") ? match.withCorrector(NodeCorrector.removeNode(node.neighbor(-1))) : (node.form().equals("sie") ? match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, "ihr", "ihnen")) : match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, newPronoun)));
            return match;
        }), NodePattern.or(NodePattern.N.pos("EIG.*"), NodePattern.N.noPos(".*").label("PERSON")).correct(removePreposition), SemanticRules.animate.andNot(NodePattern.N.withHead(NodePattern.N.lemma("geben"))).correct(NodeCorrector.inflect("SUB:DAT.*").join(removePreposition)))).message("Die Pr\u00e4position \u201ef\u00fcr\u201c ist hier nicht n\u00f6tig, da \u201e$_\u201c an dieser Stelle Dativ erfordert"));
    }

    private static NodePattern lonePreposition() {
        return AdjDeclination.anyFusedPreposition.andOr(NodePattern.N.noHeadRelation("case").noDependents(), NodePattern.N.inFormSequence(0, "im", "(au(\u00df|ss)|inn)erhalb")).andNot(NodePattern.N.form("am").withHeadRelation("advmod").directlyBeforeHead()).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE).noSpaceBefore()).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.colon, CommonPatterns.ellipsis, GermanTreePatterns.closingQuotation))).andNot(CommonPatterns.skipForward(NodePattern.PUNCT, CommonPatterns.lastToken)).andNot(CommonPatterns.upperCase).directlyBefore(NodePattern.not(NodePattern.or(NodePattern.N.pos("SUB.*"), CommonPatterns.withNumberLikeForm))).noHeadRelation("mark").andNot(NodePattern.N.withNeighbor(1, Capitalization.bisZumGehtNichtMehr)).correct(NodeCorrector.replace("")).message("Diese Pr\u00e4position scheint keinem Nomen zugeordnet zu sein");
    }

    private static NodePattern prepEs() {
        return NodePattern.N.form("es").withDependent("case", NodePattern.N.form("au[fs]|an|bei|durch|in|f\u00fcr|mit|nach|neben|von|\u00fcber").directlyBeforeHead().and((prep, match) -> {
            String replacement = prep.lowForm().matches("[ai\u00fc].+") ? "dar" + prep.lowForm() : "da" + prep.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(prep, prep.neighbor(1), replacement));
        })).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(CommonPatterns.upperCase).message("Das neutrale Personalpronomen \u201ees\u201c steht normalerweise nicht nach Pr\u00e4positionen");
    }

    private static NodePattern stattDas() {
        return NodePattern.N.form("statt").withHead("case", NodePattern.N.pos("ART:DEF.*").andOr(CommonPatterns.firstChildPhrase.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withHead("acl", NodePattern.N.pos("SUB.*").markAs("Head"))).andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.noPos(".*SIN:(MAS|NEU).*")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "statt deren")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "statt dessen"))).message("Meinten Sie ein Relativpronomen?"), NodePattern.not(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withHeadRelation("acl"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "stattdessen")).message("Meinten Sie die Konjunktion \u201estattdessen\u201c?"))).directlyBeforeHead();
    }

    private static boolean isFuture(Node node) {
        return Integer.parseInt(node.form()) > DateChecker.now().getYear();
    }

    private static NodePattern seitAb() {
        NodePattern inPresentClause = NodePattern.N.withHead(NodePattern.or(GermanTreePatterns.finiteVerb.noDependents("aux(:pass)?|cop").pos(".*PR\u00c4.*").noPos(".*PRT.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*PR\u00c4.*").noPos(".*PRT.*").noDependents("aux(:pass)?|cop", NodePattern.N.pos(".*PRT.*")))).andNot(NodePattern.N.withHead("conj", NodePattern.or(GermanTreePatterns.finiteVerb.pos(".*PRT.*").noDependents("aux(:pass)?|cop"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*PRT.*"))))));
        return NodePattern.or(NodePattern.or(NodePattern.or(SemanticRules.dayOfWeek, GermanDateChecker.monthName).withDependent("amod", NodePattern.N.lemma("n\u00e4chst")), NodePattern.N.form("(\u00fcber)?morgen"), NodePattern.or(GermanDateChecker.year.and(NodePattern.custom(node -> PrepositionIssues.isFuture(node))), NodePattern.N.form("jahr").withDependent("nmod", GermanDateChecker.year.and(NodePattern.custom(node -> PrepositionIssues.isFuture(node))))).and(inPresentClause)).withDependent("case", NodePattern.N.form("seit").correct(NodeCorrector.replace("ab"))).message("Die Pr\u00e4position \u201eseit\u201c wird normalerweise verwendet, um einen Zeitraum in der Vergangenheit anzuzeigen"), NodePattern.or(NodePattern.or(SemanticRules.dayOfWeek, GermanDateChecker.monthName).withDependent("amod", NodePattern.N.lemma("letzte")), NodePattern.N.form("((vor)?vor|ehe)?gestern")).withDependent("case", NodePattern.N.form("ab").correct(NodeCorrector.replace("seit"))).message("Die Pr\u00e4position \u201eab\u201c wird normalerweise verwendet, um einen Zeitraum in der Zukunft anzuzeigen"));
    }

    private static NodePattern missingPrepositionWithTime() {
        NodePattern wrongTimePrep = NodePattern.N.form("[ia][mn]");
        return NodePattern.or(NodePattern.or(NodePattern.N.form("([01]\\d|2[0123]):([012345][05]|59)").withDependent("case", wrongTimePrep.correct(NodeCorrector.replace("um"))).message(UM_WITH_TIME_MSG), NodePattern.N.form("uhr").withDependent("nummod", NodePattern.N.noDependents("case").markAs("Time")).andOr(NodePattern.or(NodePattern.N.withDependent("punct", CommonPatterns.HYPHEN_LIKE_NODE.directlyBefore(NodePattern.N.alreadyMarkedAs("Time")).correct(hyphenToBis)), NodePattern.N.noDependents("case").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("case"))).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("bis")))).correct(NodeCorrector.insertBefore(NodePointer.marked("Time"), "um "))).message("Fehlt eine Pr\u00e4position vor einer Zeitangabe?"), NodePattern.N.withDependent("case", wrongTimePrep.correct(NodeCorrector.replace("um"))).message(UM_WITH_TIME_MSG)).andOr(NodePattern.N.noDependents(NodePattern.N.afterHead()), NodePattern.ROOT), NodePattern.N.form("viertel").withDependent("case", wrongTimePrep.correct(NodeCorrector.replace("um"))).andOr(NodePattern.N.inFormSequence(0, ".+", "vor|nach", "\\d\\d?|eins|zwei|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf|zw\u00f6lf"), NodePattern.N.withDependent("appos", NodePattern.N.pos("ZAL").directlyAfterHead())).message(UM_WITH_TIME_MSG)).andOr(CommonPatterns.skipConjUp(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound|dep", GermanTreePatterns.clause)), NodePattern.N.withDependent("cop").withDependent("case", NodePattern.N.directlyBefore("Time")), NodePattern.N.withHead("nmod|appos", NodePattern.N.withDependent("case", NodePattern.N.form("von").directlyBeforeHead())), NodePattern.ROOT.form("Uhr").withDependent("case", wrongTimePrep)), SemanticRules.dayOfWeek.withHead(GermanTreePatterns.clause).noDependents("appos|flat|[an]mod").withDependent("case", NodePattern.N.form("i[mn]|um").correct(NodeCorrector.replace("am"))).message("Mit Wochentagen wird normalerweise die Pr\u00e4position \u201eam\u201c verwendet"));
    }

    private static NodePattern missingPrepositionInRange() {
        String hyphenOrDash = "[-\u2014\u2013]";
        NodePattern withDependentVonOrZwischen = NodePattern.N.withDependent("case", NodePattern.N.form("von|zwischen").directlyBeforeHead().markAs("Case"));
        NodePattern geoPoliticalEntity = NodePattern.N.label("GEO_POLITICAL_ENTITY");
        NodePattern messageBis = NodePattern.N.message("Verwenden Sie \u201ebis\u201c, um eine Spanne anzugeben");
        NodePattern zwischen = NodePattern.N.form("zwischen");
        Pattern hyphenPattern = Pattern.compile("\\d{1,2}\\.-\\d{1,2}");
        return NodePattern.or(CommonPatterns.HYPHEN_LIKE_NODE.directlyBeforeHead().markAs("Hyphen").withHead(NodePattern.N.withHead("flat|nmod|conj", NodePattern.N.directlyBefore(NodePattern.N.alreadyMarkedAs("Hyphen")).andOr(withDependentVonOrZwischen, NodePattern.N.directlyAfterHead().withHead("appos", withDependentVonOrZwischen)))).andOr(NodePattern.N.inFormSequence(1, "[A-Za-z]", hyphenOrDash, "[A-Za-z]"), NodePattern.N.inFormSequence(1, "\\d{1,10}", hyphenOrDash, "\\d{1,10}").andOr(NodePattern.N.withNeighbor(-1, NodePattern.N.directlyAfterHead()), NodePattern.N.withNeighbor(-2, zwischen)), NodePattern.or(CommonPatterns.HYPHEN_LIKE_NODE, CommonPatterns.DASH_NODE).directlyBefore(geoPoliticalEntity).directlyAfter(geoPoliticalEntity.directlyAfter(zwischen))).andOr(NodePattern.markedNodeMatches("Case", zwischen).message("Verwenden Sie \u201eund\u201c, um eine Beziehung zwischen zwei Begriffen auszudr\u00fccken").correct(NodeCorrector.replace(" und ")), messageBis.correct(hyphenToBis)), messageBis.form("vom").directlyBefore(NodePattern.N.form("\\d{1,2}\\.?")).and((node, match) -> {
            int start = node.neighbor(1).startOffset();
            String text = node.tree().text().substring(start);
            Matcher matcher = hyphenPattern.matcher(text);
            if (!matcher.lookingAt()) {
                return null;
            }
            int end = matcher.end();
            String hyphenText = text.substring(0, end);
            String hyphenTextClean = hyphenText.replaceAll("(.*)-(.*)", "$1 bis $2");
            return match.withCorrector(NodeCorrector.rawReplace(start, start + end, hyphenTextClean));
        }));
    }

    private static NodePattern prepositionChoiceWithToponyms() {
        NodePattern wrongPrepositions = NodePattern.N.form("auf|zu[mr]?");
        NodeCorrector.Relative addEs = NodeCorrector.insertAfter("s");
        return NodePattern.or(needAufWithIslandCountry.withDependent("det").withDependent("case", NodePattern.N.markAs("Prep")).and((country, match) -> {
            Node prep = match.getMarkedNode("Prep");
            AgreementSet.InflectedForm form = new AgreementSet.InflectedForm(AgreementSet.Gender.NEU, AgreementSet.Number.PLU, Case.AKK, AdjDeclination.fromNPHead(country), AgreementSet.Person.P3);
            AgreementSet objSet = AgreementSet.create(country);
            if (objSet == null) {
                return null;
            }
            Map<Node, NodeCorrector> correctors = objSet.imposeFeatures(form, true);
            return match.withCorrector(NodeCorrector.replace(prep, "auf ").join(NodeCorrector.joinAll(correctors.values()))).withReportedNodes(country.phraseStart(), country).withMessage("Mit Namen von Inselstaaten wird normalerweise die Pr\u00e4position \u201eauf\u201c verwendet");
        }), geo.pos("(EIG|SUB).*").withHead("appos", SemanticRules.animate.noLabel(".*")).directlyAfterHead().message("Bei geografischen Namen ohne Artikel wird der Genitiv durch die Pr\u00e4position \u201evon\u201c oder das Anh\u00e4ngen von \u201e-s\u201c gebildet").correct(NodeCorrector.insertBefore("von ")).andOr(NodePattern.N.withDependent("flat", CommonPatterns.lastChildPhrase.and(geo).correct(addEs)), NodePattern.N.correct(addEs)), NodePattern.or(Articles.countryNeutralNoArticle.noDependents("amod|det").withDependent("case", NodePattern.or(wrongPrepositions, NodePattern.N.form("i[mn]?")).markAs("Prep").correct(NodeCorrector.replace("nach"))).message("Mit dem Namen dieses Landes wird normalerweise die Pr\u00e4position \u201enach\u201c verwendet"), NodePattern.or(Articles.countryFeminineArticle, Articles.countryPluralArticle.andNot(NodePattern.N.form("Bahamas|Far(\u00f6|oe)ern?|Komoren|Malediven|Marshallinseln|Philippinen|Salomonen|Seychellen"))).withDependent("det", NodePattern.N.markAs("Det")).withDependent("case", NodePattern.or(wrongPrepositions, NodePattern.N.form("nach")).markAs("Prep").correct(NodeCorrector.replace("in").join(NodeCorrector.replace(NodePointer.marked("Det"), "die")))).message("Mit dem Namen dieses Landes wird normalerweise die Pr\u00e4position \u201ein\u201c verwendet"), SemanticRules.cityName.withDependent("case", NodePattern.or(wrongPrepositions, NodePattern.N.form("i[mn]?")).markAs("Prep").correct(NodeCorrector.replace("nach"))).andOr(NodePattern.N.withHead(NodePattern.not(NodePattern.N.lemma("gehen"))), NodePattern.markedNodeMatches("Prep", NodePattern.not(NodePattern.N.form("zu[mr]?")))).message("Mit Stadtnamen wird normalerweise die Pr\u00e4position \u201enach\u201c verwendet")).withHead(goToHead.noDependents("xcomp|i?obj").andOr(NodePattern.not(CommonPatterns.severalDependents("obl")), NodePattern.markedNodeMatches("Prep", NodePattern.not(NodePattern.N.form("i[mn]?"))))));
    }

    private static NodePattern prepositionChoiceWithVerbalHead() {
        NodePattern an = NodePattern.N.form("a[nm]");
        NodePattern beschwerenPhysicalNouns = NodePattern.or(NodePattern.N.lemma(".*(Haar|Magen|Kleidung)"), baggageNouns, windDrivenObjects, coverings, communicationNouns, paperObjects, AgreementSet.bodyParts);
        return NodePattern.or(NodePattern.N.pos("(SUB|EIG|PRO).*").markAs("Obj").andOr(NodePattern.N.withHeadRelation("obj"), NodePattern.N.withHeadRelation("xcomp").noDependents(".*")).noDependents("case").andNot(SemanticRules.durableNoun).withHead(NodePattern.custom((node, match) -> {
            List<Valence> valences = GermanValences.get(node);
            Node obj = match.findMarkedNode("Obj");
            if (obj == null) {
                return null;
            }
            HashSet<String> possibleObjArguments = new HashSet<String>(Arrays.asList("A", "D"));
            if (ReflexivePronouns.accReflexivPronomen.matches(obj)) {
                possibleObjArguments.add("refl");
            }
            if (ReflexivePronouns.datReflexivPronomen.matches(obj)) {
                possibleObjArguments.add("DRefl");
            }
            if (!SemanticRules.animate.matches(obj)) {
                possibleObjArguments.add("A:Inanim");
            }
            if (SemanticRules.animate.matches(obj)) {
                possibleObjArguments.add("A:Anim");
            }
            if (valences.isEmpty() || valences.stream().anyMatch(as -> as.hasAnyArgument(possibleObjArguments))) {
                return null;
            }
            List prepositionalArguments = new ArrayList();
            for (Valence valence : valences) {
                prepositionalArguments.addAll(((StreamEx)StreamEx.of(valence.arguments).select(GermanValences.NominalArgument.class).filter(arg -> arg.preposition != null)).toList());
            }
            if (prepositionalArguments.isEmpty()) {
                return null;
            }
            prepositionalArguments = prepositionalArguments.stream().distinct().toList();
            ArrayList<NodeCorrector> resultCorrectors = new ArrayList<NodeCorrector>();
            for (GermanValences.NominalArgument prepArgument : prepositionalArguments) {
                AgreementSet.Number number;
                AgreementSet.Gender gender = obj.hasPos(".*FEM.*") ? AgreementSet.Gender.FEM : (obj.hasPos(".*MAS.*") ? AgreementSet.Gender.MAS : (obj.hasPos(".*NEU.*") ? AgreementSet.Gender.NEU : AgreementSet.Gender.ALG));
                AgreementSet.Number number2 = number = obj.hasPos(".*SIN.*") ? AgreementSet.Number.SIN : AgreementSet.Number.PLU;
                AgreementSet.Person person = obj.hasPos(".*:1.*") ? AgreementSet.Person.P1 : (obj.hasPos(".*:2.*") ? AgreementSet.Person.P2 : AgreementSet.Person.P3);
                AgreementSet.InflectedForm form = new AgreementSet.InflectedForm(gender, number, prepArgument.caze, AdjDeclination.fromNPHead(obj), person);
                AgreementSet objSet = AgreementSet.create(obj);
                if (objSet == null) {
                    return null;
                }
                Map<Node, NodeCorrector> correctors = objSet.imposeFeatures(form, true);
                NodeCorrector prepCorrector = NodeCorrector.insertBefore(obj.phraseStart(), prepArgument.preposition + " ");
                resultCorrectors.add(prepCorrector.join(NodeCorrector.joinAll(correctors.values())));
            }
            Node node2 = node.findSingleDependent("compound:prt");
            String verbLemma = node.hasPos("VER.*") && node.lemmaReadings().size() == 1 ? (node2 != null ? node2.lowForm() : "") + node.lemmaReadings().get(0) : null;
            String message = (String)(verbLemma != null ? "Das Verb \u201e" + verbLemma + "\u201c" : "Der Kontext") + " erfordert eine Pr\u00e4position";
            return match.withCorrectors(resultCorrectors).withReportedNodes(obj.phraseStart(), obj).withMessage(message);
        }).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu")).withDependent("aux")).andNot(NodePattern.N.lemma("beschweren").withDependent("obj", NodePattern.or(NodePattern.N.form("nix|es|das|dies"), beschwerenPhysicalNouns)).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("beim?"))).noDependents("expl:pv"))), NodePattern.N.label("ORGANIZATION").noDependents("det.*").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("nach").correct(NodeCorrector.replace("zu"))), NodePattern.N.noDependents("case").withHead(NodePattern.N.lemma("gehen").noDependents("obl")).withPhraseStart(NodePattern.N.correct(NodeCorrector.insertBefore("zu ")))).withHead("ob[jl]|xcomp", goToHead.noDependents("iobj").and(NodePattern.not(CommonPatterns.severalDependents("obl")))).message("Mit den Namen von Organisationen wird normalerweise die Pr\u00e4position \u201ezu\u201c verwendet"), NodePattern.or(NodePattern.N.pos("VER.*").withDependent("obl|i?obj|dep|xcomp", GermanValences.ort.markAs("Ort").noDependents("case|punct").andNot(NodePattern.N.withDependent("amod", geo.withDependent("case")))).and((node, match) -> {
            Node ort = match.getMarkedNode("Ort");
            List<Valence> valences = GermanValences.get(node);
            if (valences.isEmpty()) {
                return null;
            }
            boolean hasNach = valences.stream().anyMatch(as -> as.hasAnyArgument(Set.of("nachA:Ort")));
            boolean hasAus = valences.stream().anyMatch(as -> as.hasAnyArgument(Set.of("ausD:Ort")));
            boolean hasIn = valences.stream().anyMatch(as -> as.hasAnyArgument(Set.of("inA:Ort")));
            if (!(hasNach || hasAus || hasIn)) {
                return null;
            }
            ArrayList<String> prepositions = new ArrayList<String>();
            if (hasNach) {
                prepositions.add(countryFemOrNoun.matches(ort) ? "" : "nach ");
            }
            if (hasAus) {
                prepositions.add("aus ");
            }
            if (hasIn && countryFemOrNoun.matches(ort)) {
                prepositions.add("in ");
            }
            if (prepositions.isEmpty()) {
                return null;
            }
            for (String preposition : prepositions) {
                match = match.withCorrector(NodeCorrector.insertBefore(ort.phraseStart(), preposition));
            }
            return match;
        }), NodePattern.N.lemma("warten").withDependent("obj", NodePattern.N.noDependents("case").andOr(NodePattern.N.lemma("Abend|Ankunft|Antwort|Auftritt|Beginn|Brief|Ende|Fall|Flug|Mal|Morgen|Nacht|Reise|Rettung|Tag|Wieder(kehr|sehen)|.+(keit|ung)"), SemanticRules.dayOfWeek, GermanDateChecker.monthName).withPhraseStart(NodePattern.N.correct(NodeCorrector.insertBefore("auf "))))).message("Das Verb \u201e$_\u201c in diesem Kontext erfordert eine Pr\u00e4position"), NodePattern.or(NodePattern.N.lemma("handeln").withDependent("nsubj|expl", NodePattern.N.form("es")).withDependent("obj", NodePattern.N.form("sich")), NodePattern.N.lemma("bitten").withDependent("obj").noDependents("[xc]comp")).noDependents("ob[lj]", NodePattern.N.withDependent("case", NodePattern.N.form("um"))).noDependents("advmod", NodePattern.N.form("darum")).withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("i[mn]").correct(NodeCorrector.replace("um")))).message("Das Verb \u201e$_\u201c in diesem Kontext erfordert die Pr\u00e4position \u201eum\u201c"), NodePattern.N.lemma("nehmen").withDependent("compound:prt", NodePattern.N.form("teil").markAs("Prefix")).noDependents("ob[lj]", NodePattern.or(NodePattern.N.form("daran"), NodePattern.N.withDependent("case", an))).withDependent("obl", NodePattern.N.before("Prefix").withDependent("case", NodePattern.not(an).includeIntoReport().andOr(NodePattern.N.withHead(NodePattern.N.pos("SUB:DAT:SIN:(NEU|MAS)")).correct(NodeCorrector.replace("am")), NodePattern.N.correct(NodeCorrector.replace("an"))))).message("Das Verb \u201eteilnehmen\u201c erfordert die Pr\u00e4position \u201ean\u201c"), NodePattern.N.form("Hause").withHead("obl", NodePattern.not(CommonPatterns.severalDependents("obl")).lemma("fahren|kommen|gehen").noDependents("compound:prt")).withDependent("case", NodePattern.N.noForm("nach").and(SpellingRules.typoReplacement("nach"))));
    }

    private static NodePattern prepositionChoiceInSpecificPhrases() {
        NodePattern prep = NodePattern.N.withDependent("case", NodePattern.N.form("zu([rm])?|als"));
        NodePattern jobNoPrep = SemanticRules.job.andNot(prep).markAs("Job");
        NodePattern withSpecificHeadAndCaseAnCorrectToAuf = NodePattern.N.withHead("obl", NodePattern.or(NodePattern.N.lemma("finden|suchen|sehen|lesen|stehen|(an)?zeigen|sein|speichern|anlegen|ver\u00f6ffentlichen"), NodePattern.N.form("verf\u00fcgbar").withDependent("cop", NodePattern.N.lemma("sein")))).and(NodePattern.N.withDependent("case", NodePattern.N.form("an").correct(NodeCorrector.replace("auf"))));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "beim?", "Bedarfsfall").message("Verwenden Sie \u201eim Bedarfsfall\u201c f\u00fcr Einzelf\u00e4lle und \u201ebei Bedarf\u201c f\u00fcr allgemeine F\u00e4lle").correct(NodeCorrector.replace("im")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "bei Bedarf")), NodePattern.N.form("Achtung").withDependent("case|det", NodePattern.N.pos("(ART|PRP|ADV:MOD).*")).withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("f\u00fcr").correct(NodeCorrector.replace("vor")))).message("Standardsprachlich wird nach \u201e$_\u201c die Pr\u00e4position \u201evor\u201c verwendet"), NodePattern.N.form("Ausbildung(s(platz(es)?|stelle))?").andOr(NodePattern.N.withHead("compound", jobNoPrep), NodePattern.N.withDependent("appos|nmod", NodePattern.or(jobNoPrep.noDependents("compound", prep), NodePattern.N.inFormSequence(0, "[A-Z]+", "-").withNeighbor(2, jobNoPrep).andNot(prep).andOptionally(NodePattern.N.withNeighbor(-2, NodePattern.N.inFormSequence(0, ".*", "-").withDependent("case", NodePattern.N.markAs("Case")).andNot(prep)))))).message("Berufsbezeichnungen nach \u201e$_\u201c brauchen die Pr\u00e4position \u201ezu\u201c").and(NodePattern.custom((node, match) -> {
            String replacement;
            Node caseNode = match.findMarkedNode("Case");
            Node job = match.getMarkedNode("Job");
            if (job.hasPos("SUB:.*ADJ")) {
                return match.withCorrector(NodeCorrector.insertAfter(node, " zur")).withCorrector(NodeCorrector.insertAfter(node, " zum"));
            }
            String string = replacement = job.hasPos("SUB:.*FEM") ? " zur" : " zum";
            if (caseNode != null) {
                return match.withCorrector(NodeCorrector.replace(caseNode, replacement));
            }
            return match.withCorrector(NodeCorrector.insertAfter(node, replacement));
        })), NodePattern.N.lemma("Webse?ite|Homepage").andOr(withSpecificHeadAndCaseAnCorrectToAuf, NodePattern.N.directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.markAs("Head"))).withHead("appos|flat", NodePattern.N.pos(".*GEN.*").alreadyMarkedAs("Head").and(withSpecificHeadAndCaseAnCorrectToAuf))).message("Verwenden Sie \u201eauf\u201c, wenn es um Inhalte geht"));
    }
}

