/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.AccessedParameters;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.UnformattedChange;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeCorrector {
    public static final String TEMPLATE_PLACEHOLDER = "__________";

    public abstract TextRange calcChangeRange();

    @NotNull
    public abstract List<UnformattedChange> calcSuggestions(String var1);

    @Nullable
    public String getBatchId(Tree tree) {
        return null;
    }

    @Nullable
    public String getCustomDisplayName() {
        return null;
    }

    public NodeCorrector batchCapable(final @NotNull String batchId) {
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return NodeCorrector.this.calcChangeRange();
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return NodeCorrector.this.calcSuggestions(textBefore);
            }

            @Override
            public String getBatchId(Tree tree) {
                return tree.language().getShortCode() + "." + batchId;
            }

            @Override
            @Nullable
            public String getCustomDisplayName() {
                return NodeCorrector.this.getCustomDisplayName();
            }

            public String toString() {
                return "batchCapable:" + String.valueOf(NodeCorrector.this);
            }
        };
    }

    public NodeCorrector withCustomDisplayName(final @NotNull String displayName) {
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return NodeCorrector.this.calcChangeRange();
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return NodeCorrector.this.calcSuggestions(textBefore);
            }

            @Override
            @Nullable
            public String getBatchId(Tree tree) {
                return NodeCorrector.this.getBatchId(tree);
            }

            @Override
            public String getCustomDisplayName() {
                return displayName;
            }

            public String toString() {
                return "withCustomDisplayName:" + String.valueOf(NodeCorrector.this);
            }
        };
    }

    public NodeCorrector join(final @Nullable NodeCorrector another) {
        if (another == null) {
            return this;
        }
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return TextRange.span(NodeCorrector.this.calcChangeRange(), another.calcChangeRange());
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                try {
                    return UnformattedChange.join(NodeCorrector.this.calcSuggestions(textBefore), another.calcSuggestions(textBefore));
                }
                catch (Throwable e) {
                    throw new RuntimeException("Exception while joining suggestions in " + String.valueOf(this), e);
                }
            }

            public String toString() {
                return String.valueOf(NodeCorrector.this) + " join " + String.valueOf(another);
            }
        };
    }

    public NodeCorrector or(final @Nullable NodeCorrector another) {
        if (another == null) {
            return this;
        }
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return TextRange.span(NodeCorrector.this.calcChangeRange(), another.calcChangeRange());
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return ((StreamEx)StreamEx.of(NodeCorrector.this.calcSuggestions(textBefore)).append(another.calcSuggestions(textBefore)).distinct()).toList();
            }

            public String toString() {
                return String.valueOf(NodeCorrector.this) + " or " + String.valueOf(another);
            }
        };
    }

    private static NodeCorrector insert(final int offset, final String text) {
        return new NodeCorrector(){
            final TextChange.Replacement replacement;
            {
                this.replacement = new TextChange.Replacement(TextRange.fromLength(offset, 0), text);
            }

            @Override
            public TextRange calcChangeRange() {
                return this.replacement.range();
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return List.of(UnformattedChange.from(this.replacement));
            }

            public String toString() {
                return "insert:" + offset + "," + text.length();
            }
        };
    }

    public static Relative insertAfter(String text) {
        return m -> NodeCorrector.insertAfter(m.anchor(), text);
    }

    public static NodeCorrector insertAfter(@NotNull Node node, String text) {
        return NodeCorrector.insert(node.endOffset(), text);
    }

    public static Relative insertAfter(NodePointer node, String text) {
        return m -> NodeCorrector.insert(node.findNode(m).endOffset(), text);
    }

    public static Relative insertAfterPrevious(String text) {
        return NodeCorrector.insertAfter((NodeMatch m) -> Objects.requireNonNull(m.anchor().prevNode()), text);
    }

    public static Relative insertAfterPhrase(String text) {
        return m -> NodeCorrector.insertAfter(m.anchor().phraseEnd(), text);
    }

    public static Relative insertBefore(String text) {
        return m -> NodeCorrector.insertBefore(m.anchor(), text);
    }

    public static Relative insertBefore(@NotNull NodePointer anchor, String text) {
        return m -> NodeCorrector.insertBefore(anchor.findNode(m), text);
    }

    public static NodeCorrector insertBefore(@NotNull Node node, String text) {
        return NodeCorrector.insert(node.startOffset(), text);
    }

    public static Relative insertBeforePhrase(String text) {
        return m -> NodeCorrector.insertBefore(m.anchor().phraseStart(), text);
    }

    public static Relative inflect(@NotNull String targetPosTag) {
        return NodeCorrector.inflect(".+", targetPosTag);
    }

    public static Relative inflect(String posRegex, @NotNull String posReplacement) {
        return m -> NodeCorrector.inflect(m.anchor(), posRegex, posReplacement);
    }

    public static NodeCorrector inflect(Node node, @Language(value="RegExp") String posRegex, @NotNull String posReplacement) {
        Objects.requireNonNull(posReplacement);
        AccessedParameters atCreation = AccessedParameters.current();
        String ruleId = atCreation == null ? null : atCreation.ruleId;
        return NodeCorrector.replaceNodes(node, node, () -> {
            String prevId;
            AccessedParameters current = AccessedParameters.current();
            String string = prevId = current == null ? null : current.ruleId;
            if (current != null && ruleId != null) {
                current.ruleId = ruleId;
            }
            try {
                List<String> list = node.tree().treeSupport().inflectNode(node, posRegex, posReplacement);
                return list;
            }
            finally {
                if (current != null) {
                    current.ruleId = prevId;
                }
            }
        });
    }

    public static Relative inflect(NodePointer node, String posRegex, @NotNull String posReplacement) {
        return m -> NodeCorrector.inflect(node.findNode(m), posRegex, posReplacement);
    }

    public static NodeCorrector removeNode(@NotNull Node node) {
        return NodeCorrector.replaceNodes(node, node, "");
    }

    public static Relative removeNodes(NodePointer start, NodePointer end) {
        return NodeCorrector.replaceNodes(start, end, "");
    }

    public static NodeCorrector replaceNodes(@NotNull Node start, @NotNull Node end, String ... replacements) {
        return NodeCorrector.replaceNodes(start, end, () -> List.of(replacements));
    }

    public static Relative replaceNodes(NodePointer start, NodePointer end, String ... replacements) {
        return NodeCorrector.replaceNodes(start, end, (NodeMatch __) -> List.of(replacements));
    }

    public static Relative replaceNodes(NodePointer start, NodePointer end, Function<NodeMatch, List<String>> replacements) {
        return match -> NodeCorrector.replaceNodes(start.findNode(match), end.findNode(match), () -> (List)replacements.apply(match));
    }

    public static NodeCorrector replaceNodes(@NotNull Node start, @NotNull Node end, final Supplier<List<String>> replacements) {
        int endOffset;
        final int startOffset = start.startOffset();
        if (startOffset >= (endOffset = end.endOffset())) {
            throw new IllegalArgumentException("start offset exceeds end offset");
        }
        return new NodeCorrector(){
            private volatile List<TextChange.Replacement> changes;

            @Override
            public TextRange calcChangeRange() {
                return new TextRange(startOffset, endOffset);
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                List<TextChange.Replacement> changes = this.getChanges();
                return changes.stream().map(UnformattedChange::from).toList();
            }

            private List<TextChange.Replacement> getChanges() {
                List<TextChange.Replacement> changes = this.changes;
                if (changes == null) {
                    TextRange range = new TextRange(startOffset, endOffset);
                    this.changes = changes = ((List)replacements.get()).stream().map(s -> new TextChange.Replacement(range, (String)s)).toList();
                }
                return changes;
            }

            public String toString() {
                return "replaceNodes:" + startOffset + "," + endOffset + "," + String.valueOf(replacements);
            }
        };
    }

    public static Relative replace(String ... replacements) {
        return m -> NodeCorrector.replace(m.anchor(), replacements);
    }

    public static NodeCorrector replace(@NotNull Node node, String ... replacements) {
        return NodeCorrector.replace(node, List.of(replacements));
    }

    public static NodeCorrector replace(@NotNull Node node, @NotNull List<String> replacements) {
        return NodeCorrector.replaceNodes(node, node, () -> replacements);
    }

    public static Relative replace(NodePointer pointer, String ... replacements) {
        return NodeCorrector.replaceNodes(pointer, pointer, replacements);
    }

    public static Relative regexReplace(String regexp, @NotNull String replacement) {
        return m -> NodeCorrector.regexReplace(m.anchor(), regexp, replacement);
    }

    public static NodeCorrector regexReplace(@NotNull Node node, String regexp, @NotNull String replacement) {
        Pattern pattern = Node.compileCSRegexp(regexp);
        return NodeCorrector.replaceNodes(node, node, () -> {
            String replaced = pattern.matcher(node.form()).replaceAll(replacement);
            return replaced.equals(node.form()) ? List.of() : List.of(replaced);
        });
    }

    public static Relative regexReplace(NodePointer node, String regexp, @NotNull String replacement) {
        return m -> NodeCorrector.regexReplace(node.findNode(m), regexp, replacement);
    }

    public static NodeCorrector rawReplace(int start, int end, String replacement) {
        return NodeCorrector.rawReplace(new TextRange(start, end), replacement);
    }

    public static NodeCorrector rawReplace(final TextRange range, final String replacement) {
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return range;
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return List.of(new UnformattedChange(List.of(new TextChange.Replacement(range, replacement)), List.of()));
            }

            public String toString() {
                return "rawReplace:" + String.valueOf(range) + "," + replacement.length();
            }
        };
    }

    public static Concatenating concatenate(NodePointer until) {
        return new Concatenating(until, false, NodePattern.or(new NodePattern[0]));
    }

    public static Concatenating concatenate(int delta) {
        return NodeCorrector.concatenate(NodePointer.neighbor(delta));
    }

    @Nullable
    public static NodeCorrector joinAll(Collection<NodeCorrector> correctors) {
        return StreamEx.of(correctors).reduce(NodeCorrector::join).orElse(null);
    }

    @Nullable
    public static List<NodeCorrector> joinCorrectors(@Nullable List<NodeCorrector> prev, @Nullable List<NodeCorrector> correctors) {
        if (correctors == null) {
            return prev;
        }
        if (prev == null) {
            return correctors;
        }
        return StreamEx.of(correctors).flatMap(c2 -> StreamEx.of((Collection)prev).map(c1 -> c1.join((NodeCorrector)c2))).toList();
    }

    public static NodeCorrector fromChanges(final List<TextChange> changes) {
        return new NodeCorrector(){

            @Override
            public TextRange calcChangeRange() {
                return TextRange.spanRanges(changes.stream().map(c -> c.changedRange()));
            }

            @Override
            @NotNull
            public List<UnformattedChange> calcSuggestions(String textBefore) {
                return changes.stream().map(c -> new UnformattedChange(c.changes(), List.of())).toList();
            }
        };
    }

    public static interface Relative {
        public NodeCorrector eval(NodeMatch var1);

        default public Relative join(Relative another) {
            return match -> this.eval(match).join(another.eval(match));
        }

        default public Relative batchCapable(@NotNull String batchId) {
            return match -> this.eval(match).batchCapable(batchId);
        }
    }

    public record Concatenating(NodePointer until, boolean preserveCase, NodePattern skip) implements Relative
    {
        public Concatenating preservingCase() {
            return new Concatenating(this.until, true, this.skip);
        }

        public Concatenating skipping(NodePattern toSkip) {
            return new Concatenating(this.until, this.preserveCase, NodePattern.or(this.skip, toSkip));
        }

        public NodeRange range(NodeMatch match) {
            Node anchor = match.anchor();
            Node target = this.until.findNode(match);
            assert (anchor != target);
            return new NodeRange(anchor.isBefore(target) ? anchor : target, anchor.isAfter(target) ? anchor : target);
        }

        public String replacement(NodeRange range) {
            Node start = range.start();
            return (this.preserveCase ? start.form() : start.lowForm()) + ((StreamEx)((StreamEx)((StreamEx)start.forward().skip(1L)).takeWhileInclusive(n -> n != range.end())).filter(n -> !this.skip.matches((Node)n))).map(n -> n.lowForm()).joining();
        }

        @Override
        public NodeCorrector eval(NodeMatch match) {
            NodeRange range = this.range(match);
            return NodeCorrector.replaceNodes(range.start(), range.end(), this.replacement(range));
        }
    }
}

