/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class FunctionParsing
extends Parsing {
    private static final IElementType FUNCTION_TYPE = PyElementTypes.FUNCTION_DECLARATION;

    public FunctionParsing(ParsingContext context) {
        super(context);
    }

    public void parseFunctionDeclaration(@NotNull SyntaxTreeBuilder.Marker endMarker, boolean async) {
        if (endMarker == null) {
            FunctionParsing.$$$reportNull$$$0(0);
        }
        this.assertCurrentToken(PyTokenTypes.DEF_KEYWORD);
        this.parseFunctionInnards(endMarker, async);
    }

    protected IElementType getFunctionType() {
        return FUNCTION_TYPE;
    }

    protected void parseFunctionInnards(@NotNull SyntaxTreeBuilder.Marker functionMarker, boolean async) {
        if (functionMarker == null) {
            FunctionParsing.$$$reportNull$$$0(1);
        }
        this.myBuilder.advanceLexer();
        this.parseIdentifierOrSkip(PyTokenTypes.LPAR, PyTokenTypes.LBRACKET);
        this.myContext.getStatementParser().parseTypeParameterList();
        this.parseParameterList();
        this.parseReturnTypeAnnotation();
        this.checkMatches(PyTokenTypes.COLON, PyParsingBundle.message("PARSE.expected.colon", new Object[0]));
        ParsingContext context = this.getParsingContext();
        context.pushScope(context.getScope().withFunction(async));
        this.getStatementParser().parseSuite(functionMarker, this.getFunctionType());
        context.popScope();
    }

    public void parseReturnTypeAnnotation() {
        this.parseReturnTypeAnnotation(true);
    }

    protected void parseReturnTypeAnnotation(boolean checkLanguageLevel) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.RARROW) {
            if (checkLanguageLevel && this.myContext.getLanguageLevel().isPython2()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.function.return.type.annotations.py2", new Object[0]));
            }
            SyntaxTreeBuilder.Marker maybeReturnAnnotation = this.myBuilder.mark();
            this.nextToken();
            if (!this.myContext.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            maybeReturnAnnotation.done(PyElementTypes.ANNOTATION);
        }
    }

    public void parseDecoratedDeclaration() {
        this.assertCurrentToken(PyTokenTypes.AT);
        SyntaxTreeBuilder.Marker decoratorStartMarker = this.myBuilder.mark();
        SyntaxTreeBuilder.Marker decoListMarker = this.myBuilder.mark();
        boolean decorated = false;
        while (this.myBuilder.getTokenType() == PyTokenTypes.AT) {
            SyntaxTreeBuilder.Marker decoratorMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            this.myContext.getFunctionParser().parseDecoratorExpression();
            if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                decoratorMarker.done(PyElementTypes.DECORATOR_CALL);
                this.nextToken();
            } else {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.statement.break", new Object[0]));
                decoratorMarker.done(PyElementTypes.DECORATOR_CALL);
            }
            decorated = true;
        }
        if (decorated) {
            decoListMarker.done(PyElementTypes.DECORATOR_LIST);
        }
        this.parseDeclarationAfterDecorator(decoratorStartMarker);
    }

    public void parseDecoratorExpression() {
        if (!this.getExpressionParser().parseNamedTestExpression(false, false)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
    }

    private void parseDeclarationAfterDecorator(SyntaxTreeBuilder.Marker endMarker) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.ASYNC_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseDeclarationAfterDecorator(endMarker, true);
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "async")) {
            this.advanceAsync(true);
            this.parseDeclarationAfterDecorator(endMarker, true);
        } else {
            this.parseDeclarationAfterDecorator(endMarker, false);
        }
    }

    protected void parseDeclarationAfterDecorator(SyntaxTreeBuilder.Marker endMarker, boolean async) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.DEF_KEYWORD) {
            this.parseFunctionInnards(endMarker, async);
        } else if (this.myBuilder.getTokenType() == PyTokenTypes.CLASS_KEYWORD) {
            this.getStatementParser().parseClassDeclaration(endMarker);
        } else {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.@.or.def", new Object[0]));
            SyntaxTreeBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            this.myBuilder.mark().done(PyElementTypes.STATEMENT_LIST);
            endMarker.done(this.getFunctionType());
        }
    }

    public void parseParameterList() {
        if (this.myBuilder.getTokenType() != PyTokenTypes.LPAR) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.lpar", new Object[0]));
            SyntaxTreeBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            return;
        }
        this.parseParameterListContents(PyTokenTypes.RPAR, true, false);
    }

    public void parseParameterListContents(IElementType endToken, boolean advanceLexer, boolean isLambda) {
        SyntaxTreeBuilder.Marker parameterList = this.myBuilder.mark();
        if (advanceLexer) {
            this.myBuilder.advanceLexer();
        }
        boolean first = true;
        boolean afterStarParameter = false;
        while (this.myBuilder.getTokenType() != endToken) {
            if (first) {
                first = false;
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
            } else {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.comma.lpar.rpar", new Object[0]));
                break;
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
                this.parseParameterSubList();
                continue;
            }
            boolean isStarParameter = this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP);
            if (!this.parseParameter(endToken, isLambda)) {
                if (!afterStarParameter || !this.myContext.getLanguageLevel().isOlderThan(LanguageLevel.PYTHON36)) break;
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                break;
            }
            if (!isStarParameter) continue;
            afterStarParameter = true;
        }
        if (this.myBuilder.getTokenType() == endToken && endToken == PyTokenTypes.RPAR) {
            this.myBuilder.advanceLexer();
        }
        parameterList.done(PyElementTypes.PARAMETER_LIST);
        if (this.myBuilder.getTokenType() == endToken && endToken == PyTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
        }
    }

    protected boolean parseParameter(IElementType endToken, boolean isLambda) {
        SyntaxTreeBuilder.Marker parameter = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.DIV) {
            this.myBuilder.advanceLexer();
            parameter.done(PyElementTypes.SLASH_PARAMETER);
            return true;
        }
        boolean isStarParameter = false;
        if (this.myBuilder.getTokenType() == PyTokenTypes.MULT) {
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA || this.myBuilder.getTokenType() == endToken) {
                if (this.myContext.getLanguageLevel().isPython2()) {
                    parameter.rollbackTo();
                    parameter = this.myBuilder.mark();
                    FunctionParsing.advanceError(this.myBuilder, PyParsingBundle.message("PARSE.single.star.parameter.not.supported.py2", new Object[0]));
                }
                parameter.done(PyElementTypes.SINGLE_STAR_PARAMETER);
                return true;
            }
            isStarParameter = true;
        } else if (this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
            this.myBuilder.advanceLexer();
            isStarParameter = true;
        }
        if (this.matchToken(PyTokenTypes.IDENTIFIER)) {
            if (!isLambda) {
                this.parseParameterAnnotation();
            }
            if (!isStarParameter && this.matchToken(PyTokenTypes.EQ) && !this.getExpressionParser().parseSingleExpression(false)) {
                SyntaxTreeBuilder.Marker invalidElements = this.myBuilder.mark();
                while (!this.atAnyOfTokens(endToken, PyTokenTypes.LINE_BREAK, PyTokenTypes.COMMA, null)) {
                    this.nextToken();
                }
                invalidElements.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } else {
            parameter.rollbackTo();
            if (this.atToken(endToken)) {
                return false;
            }
            SyntaxTreeBuilder.Marker invalidElements = this.myBuilder.mark();
            while (!this.atToken(endToken) && !this.atAnyOfTokens(PyTokenTypes.LINE_BREAK, PyTokenTypes.COMMA, null)) {
                this.nextToken();
            }
            invalidElements.error(PyParsingBundle.message("PARSE.expected.formal.param.name", new Object[0]));
            return this.atToken(endToken) || this.atToken(PyTokenTypes.COMMA);
        }
        parameter.done(PyElementTypes.NAMED_PARAMETER);
        return true;
    }

    public void parseParameterAnnotation() {
        this.parseParameterAnnotation(true);
    }

    protected void parseParameterAnnotation(boolean checkLanguageLevel) {
        if (this.atToken(PyTokenTypes.COLON)) {
            if (checkLanguageLevel && this.myContext.getLanguageLevel().isPython2()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.function.type.annotations.py2", new Object[0]));
            }
            SyntaxTreeBuilder.Marker annotationMarker = this.myBuilder.mark();
            this.nextToken();
            if (!this.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            annotationMarker.done(PyElementTypes.ANNOTATION);
        }
    }

    protected void parseParameterSubList() {
        this.assertCurrentToken(PyTokenTypes.LPAR);
        SyntaxTreeBuilder.Marker tuple = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (true) {
            if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
                SyntaxTreeBuilder.Marker parameter = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                parameter.done(PyElementTypes.NAMED_PARAMETER);
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
                this.parseParameterSubList();
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.RPAR) {
                this.myBuilder.advanceLexer();
                break;
            }
            if (this.myBuilder.getTokenType() != PyTokenTypes.COMMA) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.comma.lpar.rpar", new Object[0]));
                break;
            }
            this.myBuilder.advanceLexer();
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.EQ) {
            this.myBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
        }
        tuple.done(PyElementTypes.TUPLE_PARAMETER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/parsing/FunctionParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFunctionDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFunctionInnards";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

