/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import java.util.concurrent.LinkedBlockingQueue;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class RpcContext {
    private static final boolean REWIND_QUEUE = Utils.getBoolean("JCEF_REWIND_QUEUE");
    private static final boolean CONNECT_AS_SLAVE = Utils.getBoolean("JCEF_CONNECT_AS_SLAVE");
    private static final RpcExecutor.Rpc NO_RPC = s -> {};
    public final CefServer server;
    private final RpcExecutor myMain = new RpcExecutor();
    private final RpcExecutor myBackground = new RpcExecutor();
    private final LinkedBlockingQueue<RpcExecutor.Rpc> myQueue = new LinkedBlockingQueue();
    private final Thread myThread;
    private volatile boolean myClosed = false;

    public RpcContext(CefServer server) {
        this.server = server;
        this.myThread = new Thread(() -> {
            try {
                while (true) {
                    RpcExecutor.Rpc rpc;
                    if ((rpc = this.myQueue.take()) == NO_RPC) {
                        return;
                    }
                    this.myBackground.exec(rpc);
                }
            }
            catch (InterruptedException e) {
                CefLog.Warn("RpcContext bg thread interrupted: %s", e.getMessage());
                return;
            }
        });
        this.myThread.setName("CefBgThread");
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void openTransport(ThriftTransport thriftServer) throws TTransportException {
        this.myMain.openTransport(thriftServer);
        this.myBackground.openTransport(thriftServer);
    }

    public int connect(ThriftTransport thriftBackward) {
        int cid = this.myMain.connect(thriftBackward, !CONNECT_AS_SLAVE);
        this.myBackground.exec(s -> s.attach(cid));
        return cid;
    }

    public void invokeLater(RpcExecutor.Rpc rpc) {
        this.myQueue.add(rpc);
    }

    public void close() {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myQueue.add(NO_RPC);
        if (REWIND_QUEUE) {
            try {
                this.myThread.join();
            }
            catch (InterruptedException e) {
                CefLog.Debug("RpcContext join interrupted: %s", e.getMessage());
            }
        }
        this.myMain.closeTransport();
        this.myBackground.closeTransport();
    }

    public void exec(RpcExecutor.Rpc r) {
        this.myMain.exec(r);
    }

    public <T> T execObj(RpcExecutor.RpcObj<T> r) {
        return this.myMain.execObj(r);
    }
}

