/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.ast.PyAstArgumentList;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstDecorator
extends PyAstCallExpression {
    default public String getName() {
        QualifiedName qname = this.getQualifiedName();
        return qname != null ? qname.getLastComponent() : null;
    }

    @Nullable
    default public PyAstFunction getTarget() {
        return (PyAstFunction)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyAstFunction.class);
    }

    @Nullable
    default public PyAstExpression getExpression() {
        return PyAstElementKt.findChildByClass((PsiElement)this, PyAstExpression.class);
    }

    @Override
    default public PyAstArgumentList getArgumentList() {
        PyAstCallExpression callExpr = (PyAstCallExpression)ObjectUtils.tryCast((Object)this.getExpression(), PyAstCallExpression.class);
        return callExpr != null ? callExpr.getArgumentList() : null;
    }

    @Override
    @Nullable
    default public PyAstExpression getCallee() {
        PyAstExpression exprAfterAt = this.getExpression();
        return exprAfterAt instanceof PyAstCallExpression ? ((PyAstCallExpression)exprAfterAt).getCallee() : exprAfterAt;
    }

    @Nullable
    default public QualifiedName getQualifiedName() {
        PyAstReferenceExpression refExpr = (PyAstReferenceExpression)ObjectUtils.tryCast((Object)this.getCallee(), PyAstReferenceExpression.class);
        return refExpr != null ? refExpr.asQualifiedName() : null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyDecorator(this);
    }
}

