/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.CommonDefsKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0004J\"\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u001a\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\rH\u0016R\u0019\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/html/LinkGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "resolveAnchors", "", "(Ljava/net/URI;Z)V", "getBaseURI", "()Ljava/net/URI;", "getResolveAnchors", "()Z", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "makeAbsoluteUrl", "", "destination", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "renderLink", "info", "Companion", "RenderInfo", "markdown"})
@SourceDebugExtension(value={"SMAP\nGeneratingProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratingProviders.kt\norg/intellij/markdown/html/LinkGeneratingProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
public abstract class LinkGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final URI baseURI;
    private final boolean resolveAnchors;
    @NotNull
    private static final TransparentInlineHolderProvider fallbackProvider = new TransparentInlineHolderProvider(0, 0, 3, null);
    @NotNull
    private static final TransparentInlineHolderProvider labelProvider = new TransparentInlineHolderProvider(1, -1);

    public LinkGeneratingProvider(@Nullable URI baseURI, boolean resolveAnchors) {
        this.baseURI = baseURI;
        this.resolveAnchors = resolveAnchors;
    }

    public /* synthetic */ LinkGeneratingProvider(URI uRI, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(uRI, bl);
    }

    @Nullable
    public final URI getBaseURI() {
        return this.baseURI;
    }

    public final boolean getResolveAnchors() {
        return this.resolveAnchors;
    }

    @Override
    public final void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RenderInfo renderInfo = this.getRenderInfo(text, node);
        if (renderInfo == null) {
            fallbackProvider.processNode(visitor, text, node);
            return;
        }
        RenderInfo info = renderInfo;
        this.renderLink(visitor, text, node, info);
    }

    @NotNull
    protected final CharSequence makeAbsoluteUrl(@NotNull CharSequence destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!this.resolveAnchors && StringsKt.startsWith$default((CharSequence)destination, (char)'#', (boolean)false, (int)2, null)) {
            return destination;
        }
        Object object = this.baseURI;
        return object != null && (object = CommonDefsKt.resolveToStringSafe((URI)object, ((Object)destination).toString())) != null ? (CharSequence)object : destination;
    }

    /*
     * WARNING - void declaration
     */
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull RenderInfo info) {
        String string;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "a";
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = "href=\"" + this.makeAbsoluteUrl(info.getDestination()) + '\"';
        CharSequence[] charSequenceArray2 = charSequenceArray;
        int n = 1;
        CharSequence charSequence2 = info.getTitle();
        if (charSequence2 != null) {
            void it;
            CharSequence charSequence3 = charSequence2;
            int n2 = n;
            CharSequence[] charSequenceArray3 = charSequenceArray2;
            CharSequence charSequence4 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            boolean bl = false;
            String string2 = "title=\"" + it + '\"';
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence4;
            charSequenceArray2 = charSequenceArray3;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray2[n] = string;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(htmlGeneratingVisitor, aSTNode, charSequence, charSequenceArray, false, 8, null);
        labelProvider.processNode(visitor, text, info.getLabel());
        visitor.consumeTagClose("a");
    }

    @Nullable
    public abstract RenderInfo getRenderInfo(@NotNull String var1, @NotNull ASTNode var2);

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/intellij/markdown/html/LinkGeneratingProvider$Companion;", "", "()V", "fallbackProvider", "Lorg/intellij/markdown/html/TransparentInlineHolderProvider;", "getFallbackProvider", "()Lorg/intellij/markdown/html/TransparentInlineHolderProvider;", "labelProvider", "getLabelProvider", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TransparentInlineHolderProvider getFallbackProvider() {
            return fallbackProvider;
        }

        @NotNull
        public final TransparentInlineHolderProvider getLabelProvider() {
            return labelProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "", "label", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getLabel", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "markdown"})
    public static final class RenderInfo {
        @NotNull
        private final ASTNode label;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;

        public RenderInfo(@NotNull ASTNode label, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.label = label;
            this.destination = destination;
            this.title = title;
        }

        @NotNull
        public final ASTNode getLabel() {
            return this.label;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        @NotNull
        public final ASTNode component1() {
            return this.label;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final RenderInfo copy(@NotNull ASTNode label, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return new RenderInfo(label, destination, title);
        }

        public static /* synthetic */ RenderInfo copy$default(RenderInfo renderInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if ((n & 1) != 0) {
                aSTNode = renderInfo.label;
            }
            if ((n & 2) != 0) {
                charSequence = renderInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = renderInfo.title;
            }
            return renderInfo.copy(aSTNode, charSequence, charSequence2);
        }

        @NotNull
        public String toString() {
            return "RenderInfo(label=" + this.label + ", destination=" + this.destination + ", title=" + this.title + ')';
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = result * 31 + this.destination.hashCode();
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderInfo)) {
                return false;
            }
            RenderInfo renderInfo = (RenderInfo)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)renderInfo.label)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.destination, (Object)renderInfo.destination)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)renderInfo.title);
        }
    }
}

