/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/io/impl/FileSpec;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "content", "", "originalFile", "Ljava/nio/file/Path;", "<init>", "([BLjava/nio/file/Path;)V", "getContent", "()[B", "getOriginalFile", "()Ljava/nio/file/Path;", "generate", "", "path", "generateInTempDir", "mergeWith", "other", "Lcom/intellij/util/io/DirectoryContentSpec;", "intellij.platform.testFramework"})
public final class FileSpec
extends DirectoryContentSpecImpl {
    @Nullable
    private final byte[] content;
    @Nullable
    private final Path originalFile;

    public FileSpec(@Nullable byte[] content, @Nullable Path originalFile) {
        super(null);
        this.content = content;
        this.originalFile = originalFile;
    }

    public /* synthetic */ FileSpec(byte[] byArray, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        this(byArray, path);
    }

    @Nullable
    public final byte[] getContent() {
        return this.content;
    }

    @Override
    @Nullable
    public Path getOriginalFile() {
        return this.originalFile;
    }

    @Override
    public void generate(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.content;
        if (this.content == null) {
            byArray = new byte[]{};
        }
        PathKt.write((Path)path, (byte[])byArray);
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        Path target = FileUtil.createTempFile((String)"file-by-spec", null, (boolean)true).toPath();
        Intrinsics.checkNotNull((Object)target);
        this.generate(target);
        return target;
    }

    @Override
    @NotNull
    public DirectoryContentSpecImpl mergeWith(@NotNull DirectoryContentSpec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (DirectoryContentSpecImpl)other;
    }
}

