/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a*\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u001a\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"findActivateScript", "Lkotlin/Pair;", "", "sdkPath", "shellPath", "findActivateInPath", "Ljava/io/File;", "path", "shellName", "condaEnvFolder", "findActivateOnWindows", "intellij.python.sdk"})
public final class PyVirtualEnvReaderKt {
    @Nullable
    public static final Pair<String, String> findActivateScript(@Nullable String sdkPath, @Nullable String shellPath) {
        if (PythonSdkUtil.isVirtualEnv(sdkPath)) {
            String shellName = shellPath != null ? new File(shellPath).getName() : null;
            String string = sdkPath;
            Intrinsics.checkNotNull((Object)string);
            File activate = PyVirtualEnvReaderKt.findActivateInPath(string, shellName);
            return activate != null && activate.exists() ? new Pair((Object)activate.getAbsolutePath(), null) : null;
        }
        if (PythonSdkUtil.isConda(sdkPath)) {
            String string = sdkPath;
            Intrinsics.checkNotNull((Object)string);
            String condaExecutable = PyCondaPackageService.Companion.getCondaExecutable(string);
            if (condaExecutable != null) {
                String string2 = new File(condaExecutable).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                File activate = PyVirtualEnvReaderKt.findActivateInPath(string2, null);
                if (activate != null && activate.exists()) {
                    return new Pair((Object)activate.getPath(), (Object)PyVirtualEnvReaderKt.condaEnvFolder(sdkPath));
                }
            }
        }
        return null;
    }

    private static final File findActivateInPath(String path, String shellName) {
        return SystemInfo.isWindows ? PyVirtualEnvReaderKt.findActivateOnWindows(path) : (Intrinsics.areEqual((Object)shellName, (Object)"fish") || Intrinsics.areEqual((Object)shellName, (Object)"csh") ? new File(new File(path).getParentFile(), "activate." + shellName) : new File(new File(path).getParentFile(), "activate"));
    }

    private static final String condaEnvFolder(String path) {
        return SystemInfo.isWindows ? new File(path).getParent() : new File(path).getParentFile().getParent();
    }

    private static final File findActivateOnWindows(String path) {
        Object[] objectArray = new String[]{"activate.bat", "Scripts/activate.bat"};
        Iterator iterator = CollectionsKt.arrayListOf((Object[])objectArray).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String location = (String)e;
            File file = new File(new File(path).getParentFile(), location);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

