/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RUN_CONFIGURATIONS_DIRECTORY", "", "removeConfigurationFromVcsIgnore", "", "project", "Lcom/intellij/openapi/project/Project;", "configurationName", "checkConfigurationVcsIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "configurationFileName", "getCheckerForFile", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "configurationNameToFileName", "checkProjectNotDefault", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsIgnoreManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsIgnoreManagerImpl.kt\ncom/intellij/openapi/vcs/changes/VcsIgnoreManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,223:1\n13#2:224\n*S KotlinDebug\n*F\n+ 1 VcsIgnoreManagerImpl.kt\ncom/intellij/openapi/vcs/changes/VcsIgnoreManagerImplKt\n*L\n36#1:224\n*E\n"})
public final class VcsIgnoreManagerImplKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RUN_CONFIGURATIONS_DIRECTORY = "runConfigurations";

    private static final void removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)project)) {
            Path path = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            Intrinsics.checkNotNull((Object)path);
            VirtualFile virtualFile2 = VfsUtil.findFile((Path)path, (boolean)true);
            virtualFile = virtualFile2;
            Intrinsics.checkNotNull((Object)virtualFile2);
        } else {
            VirtualFile virtualFile3 = project.getProjectFile();
            virtualFile = virtualFile3;
            Intrinsics.checkNotNull((Object)virtualFile3);
        }
        VirtualFile projectFileOrConfigDir = virtualFile;
        VirtualFile virtualFile4 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFileOrConfigDir);
        if (virtualFile4 == null) {
            return;
        }
        VirtualFile projectVcsRoot = virtualFile4;
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectVcsRoot);
        if (vcs == null) {
            LOG.debug("Cannot get VCS for root " + projectVcsRoot.getPath());
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        IgnoredCheckResult checkResult = VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationName);
        if (checkResult instanceof Ignored) {
            File ignoreFile = ((Ignored)checkResult).getIgnoreFile();
            FileUtil.appendToFile((File)ignoreFile, (String)ignoreContentProvider.buildUnignoreContent(((Ignored)checkResult).getMatchedPattern()));
        }
    }

    private static final IgnoredCheckResult checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        IgnoredCheckResult ignoredCheckResult;
        IProjectStore stateStore = ProjectKt.getStateStore((Project)project);
        Path dotIdea = stateStore.getDirectoryStorePath();
        if (dotIdea != null) {
            IgnoredCheckResult ignoredCheckResult2;
            FilePath filePath = VcsContextFactory.getInstance().createFilePath(dotIdea, true);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
            FilePath dotIdeaVcsPath = filePath;
            VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)dotIdeaVcsPath);
            if (virtualFile == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            VirtualFile vcsRootForIgnore = virtualFile;
            String filePattern = PathsKt.getInvariantSeparatorsPathString((Path)dotIdea) + "/runConfigurations/" + configurationFileName + "*.xml";
            VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, dotIdeaVcsPath);
            return vcsIgnoreChecker != null && (ignoredCheckResult2 = vcsIgnoreChecker.isFilePatternIgnored(vcsRootForIgnore, filePattern)) != null ? ignoredCheckResult2 : (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        Path projectFile = stateStore.getProjectFilePath();
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(projectFile, false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
        FilePath projectFileVcsPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)projectFileVcsPath);
        if (virtualFile == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        VirtualFile vcsRootForIgnore = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, projectFileVcsPath);
        return vcsIgnoreChecker != null && (ignoredCheckResult = vcsIgnoreChecker.isIgnored(vcsRootForIgnore, projectFile)) != null ? ignoredCheckResult : (IgnoredCheckResult)NotIgnored.INSTANCE;
    }

    private static final VcsIgnoreChecker getCheckerForFile(Project project, FilePath filePath) {
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        return (VcsIgnoreChecker)VcsIgnoreManagerImpl.EP_NAME.findFirstSafe(arg_0 -> VcsIgnoreManagerImplKt.getCheckerForFile$lambda$1(arg_0 -> VcsIgnoreManagerImplKt.getCheckerForFile$lambda$0(vcs, arg_0), arg_0));
    }

    private static final String configurationNameToFileName(String configurationName) {
        return (String)Scheme_implKt.getOLD_NAME_CONVERTER().invoke((Object)configurationName);
    }

    private static final void checkProjectNotDefault(Project project) {
        if (project.isDefault()) {
            throw new UnsupportedOperationException(VcsBundle.message((String)"changes.error.default.project.not.supported", (Object[])new Object[0]));
        }
    }

    private static final boolean getCheckerForFile$lambda$0(AbstractVcs $vcs, VcsIgnoreChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return Intrinsics.areEqual((Object)checker.getSupportedVcs(), (Object)$vcs.getKeyInstanceMethod());
    }

    private static final boolean getCheckerForFile$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$checkProjectNotDefault(Project project) {
        VcsIgnoreManagerImplKt.checkProjectNotDefault(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ VcsIgnoreChecker access$getCheckerForFile(Project project, FilePath filePath) {
        return VcsIgnoreManagerImplKt.getCheckerForFile(project, filePath);
    }

    public static final /* synthetic */ String access$configurationNameToFileName(String configurationName) {
        return VcsIgnoreManagerImplKt.configurationNameToFileName(configurationName);
    }

    public static final /* synthetic */ IgnoredCheckResult access$checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        return VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationFileName);
    }

    public static final /* synthetic */ void access$removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VcsIgnoreManagerImplKt.removeConfigurationFromVcsIgnore(project, configurationName);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsIgnoreManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

