/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ElementStatusTracker;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ElementStatusTrackerImpl
implements ElementStatusTracker {
    private final Project myProject;

    public ElementStatusTrackerImpl(@NotNull Project project) {
        if (project == null) {
            ElementStatusTrackerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public FileStatus getElementStatus(@NotNull PsiElement element) {
        Range r;
        if (element == null) {
            ElementStatusTrackerImpl.$$$reportNull$$$0(1);
        }
        if (!element.isValid()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }
        Document document = file.getViewProvider().getDocument();
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(document);
        if (tracker == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }
        TextRange range = element.getTextRange();
        if (range == null || range.getEndOffset() > document.getTextLength()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(5);
            }
            return fileStatus;
        }
        int start2 = document.getLineNumber(range.getStartOffset());
        int end = document.getLineNumber(range.getEndOffset());
        BitSet set = new BitSet();
        set.set(start2, end + 1);
        List ranges = tracker.getRangesForLines(set);
        if (ranges == null || ranges.isEmpty()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }
        if (ranges.size() == 1 && (r = (Range)ranges.get(0)).getType() == 2 && r.getLine1() <= start2 && r.getLine2() > end) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                ElementStatusTrackerImpl.$$$reportNull$$$0(7);
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.MODIFIED;
        if (fileStatus == null) {
            ElementStatusTrackerImpl.$$$reportNull$$$0(8);
        }
        return fileStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ElementStatusTrackerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ElementStatusTrackerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementStatus";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

