/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.inspection.ShredManager;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class UnexpectedAnchorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnexpectedAnchorInspection.$$$reportNull$$$0(0);
        }
        return new UnexpectedAnchorVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/UnexpectedAnchorInspection", "buildVisitor"));
    }

    private static class UnexpectedAnchorVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        UnexpectedAnchorVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpBoundary(RegExpBoundary boundary) {
            boolean unexpected;
            super.visitRegExpBoundary(boundary);
            RegExpBoundary.Type type = boundary.getType();
            switch (type) {
                case BEGIN: {
                    boolean bl = UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, false);
                    break;
                }
                case LINE_START: {
                    boolean bl = UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, true);
                    break;
                }
                case END: 
                case END_NO_LINE_TERM: {
                    boolean bl = UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, false);
                    break;
                }
                case LINE_END: {
                    boolean bl = UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, true);
                    break;
                }
                default: {
                    boolean bl = unexpected = false;
                }
            }
            if (unexpected) {
                this.myHolder.registerProblem((PsiElement)boundary, RegExpBundle.message("inspection.warning.anchor.code.ref.code.in.unexpected.position", new Object[0]), new LocalQuickFix[0]);
            }
        }

        private static boolean hasUnexpectedSibling(PsiElement element, boolean next, boolean line) {
            PsiElement sibling;
            PsiElement psiElement = sibling = next ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class}) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class});
            if (sibling == null) {
                return false;
            }
            return !line || UnexpectedAnchorVisitor.isUnexpectedSibling(element, next, sibling);
        }

        private static boolean isUnexpectedSibling(PsiElement element, boolean next, PsiElement sibling) {
            if (sibling instanceof RegExpChar) {
                int value = ((RegExpChar)sibling).getValue();
                if (value == 32) {
                    ShredManager shredManager = new ShredManager(element);
                    ShredManager.ShredInfo shredInfo = shredManager.getShredInfo(element.getParent().getText());
                    if (shredInfo == null || shredInfo.getHost() == null) {
                        return true;
                    }
                    if (RegExpLanguageHosts.getInstance().belongsToConditionalExpression(element, shredInfo.getHost())) {
                        return shredManager.containsCloseRealWhiteSpace(shredInfo, next);
                    }
                }
                return value != 10 && value != 13;
            }
            if (sibling instanceof RegExpSimpleClass) {
                RegExpSimpleClass.Kind kind = ((RegExpSimpleClass)sibling).getKind();
                return switch (kind) {
                    case RegExpSimpleClass.Kind.ANY, RegExpSimpleClass.Kind.NON_DIGIT, RegExpSimpleClass.Kind.NON_WORD, RegExpSimpleClass.Kind.SPACE, RegExpSimpleClass.Kind.NON_HORIZONTAL_SPACE, RegExpSimpleClass.Kind.NON_VERTICAL_SPACE, RegExpSimpleClass.Kind.NON_XML_NAME_START, RegExpSimpleClass.Kind.NON_XML_NAME_PART, RegExpSimpleClass.Kind.UNICODE_LINEBREAK -> false;
                    default -> true;
                };
            }
            if (sibling instanceof RegExpClosure) {
                RegExpClosure closure = (RegExpClosure)sibling;
                return UnexpectedAnchorVisitor.isUnexpectedSibling(element, next, closure.getAtom());
            }
            if (sibling instanceof RegExpGroup) {
                RegExpGroup group = (RegExpGroup)sibling;
                return UnexpectedAnchorVisitor.isUnexpectedSibling(element, next, group.getPattern());
            }
            if (sibling instanceof RegExpPattern) {
                RegExpPattern pattern = (RegExpPattern)sibling;
                for (RegExpBranch branch : pattern.getBranches()) {
                    if (!UnexpectedAnchorVisitor.isUnexpectedSibling(element, next, branch)) continue;
                    return true;
                }
                return false;
            }
            if (sibling instanceof RegExpBranch) {
                RegExpBranch branch = (RegExpBranch)sibling;
                for (RegExpAtom atom : branch.getAtoms()) {
                    if (!UnexpectedAnchorVisitor.isUnexpectedSibling(element, next, atom)) continue;
                    return true;
                }
                return false;
            }
            return sibling instanceof RegExpBoundary;
        }
    }
}

