/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.ui.InplaceButton;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.plugins.emojipicker.EmojiCategory;
import org.jetbrains.plugins.emojipicker.messages.EmojiCategoriesBundle;
import org.jetbrains.plugins.emojipicker.ui.EmojiPicker;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;

class EmojiCategoryPanel
extends JPanel {
    private final EmojiPickerStyle myStyle;
    private EmojiCategory myActiveCategory;

    EmojiCategoryPanel(final EmojiPicker emojiPicker, EmojiPickerStyle style, List<EmojiCategory> categories) {
        this.myStyle = style;
        Dimension size = new Dimension(0, JBUIScale.scale((int)39));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.insets = JBUI.insets((int)0, (int)4);
        this.setLayout(new GridBagLayout());
        final JBDimension buttonSize = new JBDimension(30, 30);
        for (final EmojiCategory category : categories) {
            @Nls String name = EmojiCategoriesBundle.findNameForCategory(category);
            InplaceButton button = new InplaceButton(name, category.getIcon(), e -> emojiPicker.selectCategory(category, true)){

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (emojiPicker.getCurrentFocusTarget() == category) {
                        buttonSize.update();
                        double x = (double)this.getWidth() / 2.0;
                        double y = (double)this.getHeight() / 2.0;
                        g.setColor(EmojiCategoryPanel.this.myStyle.myFocusBorderColor);
                        RectanglePainter2D.DRAW.paint((Graphics2D)g, x - buttonSize.getWidth() / 2.0, y - buttonSize.getHeight() / 2.0, buttonSize.getWidth(), buttonSize.getHeight(), (Object)4.0);
                    }
                    if (EmojiCategoryPanel.this.myActiveCategory == category) {
                        double height = JBUIScale.scale((float)2.0f);
                        g.setColor(EmojiCategoryPanel.this.myStyle.mySelectedCategoryColor);
                        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, (double)this.getHeight() - height, (double)this.getWidth(), height);
                    }
                }
            };
            button.setPreferredSize((Dimension)buttonSize);
            this.add((Component)button, gbc);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.myStyle.myToolbarColor);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 0.0, (double)this.getWidth(), (double)this.getHeight(), (Object)6.0);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, 6.0, (double)this.getWidth(), (double)(this.getHeight() - 6));
        g.setColor(this.myStyle.myBorderColor);
        RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, (double)((float)this.getHeight() - this.myStyle.myBorder.getFloat()), (double)this.getWidth(), (double)this.myStyle.myBorder.getFloat());
    }

    void selectCategory(EmojiCategory category) {
        this.myActiveCategory = category;
        this.repaint();
    }
}

