/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.Arrays;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.IntOpenHashSet;
import fleet.fastutil.ints.MutableIntList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\b\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0011\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0005\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"removeIf", "", "Lfleet/fastutil/ints/MutableIntList;", "predicate", "Lkotlin/Function1;", "", "retainAll", "elements", "Lfleet/fastutil/ints/IntList;", "removeAll", "setElements", "", "index", "a", "offset", "length", "addAll", "addElements", "", "pop", "removeValue", "key", "fleet.fastutil"})
@SourceDebugExtension(value={"SMAP\nMutableIntListExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableIntListExtensions.kt\nfleet/fastutil/ints/MutableIntListExtensionsKt\n*L\n1#1,94:1\n7#1,11:95\n*S KotlinDebug\n*F\n+ 1 MutableIntListExtensions.kt\nfleet/fastutil/ints/MutableIntListExtensionsKt\n*L\n23#1:95,11\n*E\n"})
public final class MutableIntListExtensionsKt {
    public static final boolean removeIf(@NotNull MutableIntList $this$removeIf, @NotNull Function1<? super Integer, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$removeIf, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeIf = false;
        boolean removed = false;
        int curIndex = IntListExtensionsKt.getIndices($this$removeIf).getFirst();
        while (true) {
            IntRange intRange = IntListExtensionsKt.getIndices($this$removeIf);
            int n = intRange.getFirst();
            boolean bl = curIndex <= intRange.getLast() ? n <= curIndex : false;
            if (!bl) break;
            if (((Boolean)predicate.invoke((Object)$this$removeIf.get(curIndex))).booleanValue()) {
                $this$removeIf.removeAt(curIndex);
                removed = true;
                continue;
            }
            ++curIndex;
        }
        return removed;
    }

    public static final boolean retainAll(@NotNull MutableIntList $this$retainAll, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$retainAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        IntOpenHashSet elementsSet = new IntOpenHashSet(elements, 0.0f, 2, null);
        MutableIntList $this$removeIf$iv = $this$retainAll;
        boolean $i$f$removeIf = false;
        boolean removed$iv = false;
        int curIndex$iv = IntListExtensionsKt.getIndices($this$removeIf$iv).getFirst();
        while (true) {
            IntRange intRange = IntListExtensionsKt.getIndices($this$removeIf$iv);
            int n = intRange.getFirst();
            boolean bl = curIndex$iv <= intRange.getLast() ? n <= curIndex$iv : false;
            if (!bl) break;
            int elem = $this$removeIf$iv.get(curIndex$iv);
            boolean bl2 = false;
            if (!elementsSet.contains(elem)) {
                $this$removeIf$iv.removeAt(curIndex$iv);
                removed$iv = true;
                continue;
            }
            ++curIndex$iv;
        }
        return removed$iv;
    }

    public static final boolean removeAll(@NotNull MutableIntList $this$removeAll, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        boolean modified = false;
        IntRange intRange = IntListExtensionsKt.getIndices(elements);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                if (MutableIntListExtensionsKt.removeValue($this$removeAll, elements.get(index))) {
                    modified = true;
                }
                if (index == n) break;
                ++index;
            }
        }
        return modified;
    }

    public static final void setElements(@NotNull MutableIntList $this$setElements, int index, @NotNull IntList a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > $this$setElements.getSize()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + $this$setElements.getSize() + ")");
        }
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        if (index + length > $this$setElements.getSize()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + $this$setElements.getSize() + ")");
        }
        int iter = index;
        int i2 = 0;
        while (i2 < length) {
            $this$setElements.set(iter, a.get(offset + i2++));
            ++iter;
        }
    }

    public static final void setElements(@NotNull MutableIntList $this$setElements, @NotNull IntList a) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        MutableIntListExtensionsKt.setElements($this$setElements, 0, a);
    }

    public static final void setElements(@NotNull MutableIntList $this$setElements, int index, @NotNull IntList a) {
        Intrinsics.checkNotNullParameter((Object)$this$setElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        MutableIntListExtensionsKt.setElements($this$setElements, index, a, 0, a.getSize());
    }

    public static final boolean addAll(@NotNull MutableIntList $this$addAll, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)$this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return $this$addAll.addAll($this$addAll.getSize(), elements);
    }

    public static final void addElements(@NotNull MutableIntList $this$addElements, int index, @NotNull int[] a) {
        Intrinsics.checkNotNullParameter((Object)$this$addElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        $this$addElements.addElements(index, a, 0, a.length);
    }

    public static final int pop(@NotNull MutableIntList $this$pop) {
        Intrinsics.checkNotNullParameter((Object)$this$pop, (String)"<this>");
        if (IntListExtensionsKt.isEmpty($this$pop)) {
            throw new IndexOutOfBoundsException();
        }
        return $this$pop.removeAt($this$pop.getSize() - 1);
    }

    public static final boolean removeValue(@NotNull MutableIntList $this$removeValue, int key) {
        Intrinsics.checkNotNullParameter((Object)$this$removeValue, (String)"<this>");
        int index = IntListExtensionsKt.indexOf($this$removeValue, key);
        if (index == -1) {
            return false;
        }
        $this$removeValue.removeAt(index);
        return true;
    }
}

