/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.assertj.core.util.diff.Delta;
import org.assertj.core.util.diff.DeltaComparator;

public class Patch<T> {
    private List<Delta<T>> deltas = new LinkedList<Delta<T>>();

    public List<T> applyTo(List<T> target) throws IllegalStateException {
        LinkedList<T> result2 = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.applyTo(result2);
        }
        return result2;
    }

    public void addDelta(Delta<T> delta) {
        this.deltas.add(delta);
    }

    public List<Delta<T>> getDeltas() {
        Collections.sort(this.deltas, DeltaComparator.INSTANCE);
        return this.deltas;
    }
}

