/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Streams;
import org.assertj.core.util.introspection.Introspection;
import org.assertj.core.util.introspection.IntrospectionError;

public class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();

    public static PropertySupport instance() {
        return INSTANCE;
    }

    PropertySupport() {
    }

    public <T> List<T> propertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        if (IterableUtil.isNullOrEmpty(target)) {
            return Collections.emptyList();
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            List<Object> propertyValues = this.propertyValues(firstPropertyName, Object.class, target);
            return this.propertyValues(this.nextPropertyNameFrom(propertyName), clazz, propertyValues);
        }
        return this.simplePropertyValues(propertyName, clazz, target);
    }

    public static <T> T propertyValueOf(String propertyName, Object target, Class<T> clazz) {
        return PropertySupport.instance().propertyValueOf(propertyName, clazz, target);
    }

    private <T> List<T> simplePropertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        return Streams.stream(target).map(e2 -> e2 == null ? null : this.propertyValue(propertyName, clazz, e2)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private String popPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return propertyNameChain;
        }
        return propertyNameChain.substring(0, propertyNameChain.indexOf(SEPARATOR));
    }

    private String nextPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return "";
        }
        return propertyNameChain.substring(propertyNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedProperty(String propertyName) {
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    public <T> T propertyValue(String propertyName, Class<T> clazz, Object target) {
        Method getter = Introspection.getPropertyGetter(propertyName, target);
        try {
            return (T)getter.invoke(target, new Object[0]);
        }
        catch (ClassCastException e2) {
            String msg = "Unable to obtain the value of the property <'%s'> from <%s> - wrong property type specified <%s>".formatted(propertyName, target, clazz);
            throw new IntrospectionError(msg, e2);
        }
        catch (Exception unexpected) {
            String msg = "Unable to obtain the value of the property <'%s'> from <%s>".formatted(propertyName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }

    public <T> T propertyValueOf(String propertyName, Class<T> clazz, Object target) {
        Preconditions.checkArgument(propertyName != null, "the property name should not be null.", new Object[0]);
        if (target == null) {
            return null;
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            Object propertyValue = this.propertyValue(firstPropertyName, Object.class, target);
            return this.propertyValueOf(this.nextPropertyNameFrom(propertyName), clazz, propertyValue);
        }
        return this.propertyValue(propertyName, clazz, target);
    }

    public List<Object> propertyValues(String fieldOrPropertyName, Iterable<?> target) {
        return this.propertyValues(fieldOrPropertyName, Object.class, target);
    }

    public boolean publicGetterExistsFor(String fieldName, Object actual) {
        try {
            Introspection.getPropertyGetter(fieldName, actual);
        }
        catch (IntrospectionError e2) {
            return false;
        }
        return true;
    }
}

